%apply range filter in bilateral neighborhood + with distance > 1

function output_image = square_filter_distance_fast(input_image,r_var,coeff,iteration)

timer_on = 0;

if(timer_on==1)
 tstart = tic;
end

update_image = double(input_image);
ini_image = double(input_image);
size_image = size(update_image);

size_coeff = size(coeff);
distance = (size_coeff(1)-1)/2;
diameter = size_coeff(1);
a2 = diameter*diameter;
p_center = (a2+1)/2;

col_coeff = coeff(:);

ini_pad_image = padarray(ini_image, [distance distance 0], 'symmetric');
col_ini_patch_image = zeros(3,a2,size_image(1)*size_image(2));
col_ini_patch_image(1,:,:) = im2col(ini_pad_image(:,:,1), [size_coeff(1) size_coeff(1)], 'sliding');
col_ini_patch_image(2,:,:) = im2col(ini_pad_image(:,:,2), [size_coeff(1) size_coeff(1)], 'sliding');
col_ini_patch_image(3,:,:) = im2col(ini_pad_image(:,:,3), [size_coeff(1) size_coeff(1)], 'sliding');
col_update_image = zeros(3,size_image(1)*size_image(2));
col_update_image(1,:) = im2col(update_image(:,:,1), [1 1], 'sliding');
col_update_image(2,:) = im2col(update_image(:,:,2), [1 1], 'sliding');
col_update_image(3,:) = im2col(update_image(:,:,3), [1 1], 'sliding');


for k=1:iteration

    for i=1:length(col_update_image)
      zi = col_update_image(:,i);
      
      dist = col_ini_patch_image(:,:,i) - zi(:,ones(a2,1));
      weight = exp(-sum(dist.^2)/(2*r_var));
      weight(p_center)=1; %center
      weight = col_coeff.*weight(:);
      wAll = sum(weight);
      
      col_update_image(:,i) = col_ini_patch_image(:,:,i)*weight/wAll;
    end

end

output_image = update_image;
output_image(:,:,1) = reshape(col_update_image(1,:),size_image(1),size_image(2));
output_image(:,:,2) = reshape(col_update_image(2,:),size_image(1),size_image(2));
output_image(:,:,3) = reshape(col_update_image(3,:),size_image(1),size_image(2));

if(timer_on==1)
 telasped =  toc(tstart);
 fprintf('Filter done in %f s\n',telasped);  
end
