
function [noisy_img,clean_img] = get_noisy_image(ImageName,NoiseName)

DirName = 'ori_color_images';

FileName = sprintf('%s.png',ImageName);
clean_img = imread(fullfile(DirName, FileName));
size_img = size(clean_img);

switch NoiseName
  case{'N0'}
      noisy_img = int16(double(clean_img));
  %Gaussian noise
  case{'N5'}
      noisy_img = int16(double(clean_img) + 5*randn(size(clean_img)));
  case{'N10'}
      noisy_img = int16(double(clean_img) + 10*randn(size(clean_img)));
  case{'N20'}
      noisy_img = int16(double(clean_img) + 20*randn(size(clean_img)));
  case{'N40'}
      noisy_img = int16(double(clean_img) + 40*randn(size(clean_img)));
  case{'N50'}
      noisy_img = int16(double(clean_img) + 50*randn(size(clean_img)));
  %Uniform noise
  case{'U5'}
      rand('seed',randn('seed'));
      noisy_img = int16(double(clean_img) + (5*sqrt(12))*(rand(size(clean_img))-0.5) );
  case{'U20'}
      rand('seed',randn('seed'));
      noisy_img = int16(double(clean_img) + (20*sqrt(12))*(rand(size(clean_img))-0.5) );
  case{'U50'}
      rand('seed',randn('seed'));
      noisy_img = int16(double(clean_img) + (50*sqrt(12))*(rand(size(clean_img))-0.5) );
  %Special noise
  otherwise
      FileName = sprintf('%s.png',ImageName);
      noisy_img = imread(fullfile('special_noisy_images',NoiseName,FileName));
end



clean_img = int16(clean_img);
