
function mad_nvar_2d = get_mad_nvar(noisy_img)

size_img = size(noisy_img);

diff_image  = zeros(size_img(1),size_img(2),size_img(3));
diff_image(:,:,1) = conv2(double(noisy_img(:,:,1)),[2 -1; -1 0],'same');
diff_image(:,:,2) = conv2(double(noisy_img(:,:,2)),[2 -1; -1 0],'same');
diff_image(:,:,3) = conv2(double(noisy_img(:,:,3)),[2 -1; -1 0],'same');

mad_nvar_2d = (median(abs(diff_image(:)-median(diff_image(:))))/0.6745)^2 / 6.0;
