
function pmf = get_chi_pmf_neighborhood_array(input_img,coeff)

value_range = ceil(sqrt((max(max(abs(input_img(:,:,1)))))^2 + (max(max(abs(input_img(:,:,2)))))^2 + (max(max(abs(input_img(:,:,3)))))^2))+1;
value_range = 4*value_range;

pmf = double(zeros(1,value_range));

%initialize coeff mask
size_coeff = size(coeff);
distance = (size_coeff(1)-1)/2;
diameter = size_coeff(1);
a2 = diameter*diameter;
p_center = (a2+1)/2;

col_coeff = coeff(:);

%initialize image patch
ini_image = double(input_img);
size_image = size(input_img);

ini_pad_image = padarray(ini_image, [distance distance 0], 'symmetric');
col_ini_patch_image = zeros(3,a2,size_image(1)*size_image(2));
col_ini_patch_image(1,:,:) = im2col(ini_pad_image(:,:,1), [size_coeff(1) size_coeff(1)], 'sliding');
col_ini_patch_image(2,:,:) = im2col(ini_pad_image(:,:,2), [size_coeff(1) size_coeff(1)], 'sliding');
col_ini_patch_image(3,:,:) = im2col(ini_pad_image(:,:,3), [size_coeff(1) size_coeff(1)], 'sliding');

col_coeff(p_center) = 0;
weight_coeff = col_coeff';
weight_coeff(p_center) = 0;

pmf_array = double(zeros(a2*value_range,1));
list = int32([0:value_range:(a2-1)*value_range]);

for i=1:size_image(1)*size_image(2)
  zi = col_ini_patch_image(:,p_center,i);
  
  
  
  dist = col_ini_patch_image(:,:,i) - zi(:,ones(a2,1));
  chi = int32(sqrt(sum(dist.^2)));

  pmf_array(list+chi+1) = pmf_array(list+chi+1) + col_coeff;
  
  %pmf_array(list+chi+1) = pmf_array(list+chi+1) + 1;
 
end

%pmf_matrix = reshape(pmf_array,value_range,a2);
%pmf = weight_coeff * pmf_matrix';


pmf = sum(reshape(pmf_array,value_range,a2)');

nzero_idx = find(pmf > 0);

pmf = pmf(1:max(nzero_idx));
pmf=pmf./sum(pmf);

