
%fit to p-order polynomial

function s_merge_v = find_representative_s_poly(p_in, ori_pmf_v, ori_send_v, ori_s_v, ori_slength_v, pmf_merge, new_send_v, new_slength_v)

s_merge_v = zeros(1,length(new_send_v));

ori_cur_idx = 1;
pre_cur_idx = 0;
s_end = 0;

for i=1:length(new_send_v)

    for tt = pre_cur_idx+1:length(ori_send_v)
        ori_cur_idx = tt;
        if ori_send_v(tt) >  new_send_v(i)
           ori_cur_idx = ori_cur_idx - 1;
           break;
        end
    end  
        
    this_s_seg = ori_s_v(pre_cur_idx+1:ori_cur_idx);
    this_p_seg = ori_pmf_v(pre_cur_idx+1:ori_cur_idx);
    this_l_seg = ori_slength_v(pre_cur_idx+1:ori_cur_idx);
    
    s_begin = s_end;
    s_end = ori_send_v(ori_cur_idx);
    
    pre_cur_idx = ori_cur_idx;
    
    %fit the s*
    
    s_seg = this_s_seg(find(this_p_seg~=0)); 
    p_seg = this_p_seg(find(this_p_seg~=0));
    l_seg = this_l_seg(find(this_p_seg~=0));

    row_count = length(s_seg);
        
    if row_count < (p_in+1)
       p = row_count - 1;  %data dim should >= fitting coeff number
       
       if p < 2
          p = 2; % at least using parabola fitting 
       end
    else
       p = p_in;
    end
    
    if length(this_p_seg) ~= row_count
       p = 2;    %if any prob is zero, it is near the tail (theoretically flat but empirically noisy) => use parabola fitting
    end   
    
    Q = zeros(row_count,1);
    A = ones(row_count,p+1);
    
    if row_count==0
       s_merge_v(i) = mean(this_s_seg(:));
    else
    
       Q(:) = log(p_seg(:)./l_seg(:)); %use pdf instead of pmf
       
       for j=0:p-1
         A(:,j+1) = s_seg(:).^(p-j);
       end
       
       sol = pinv(A)*Q;
       
       sol(end) = sol(end) -log(pmf_merge(i)/new_slength_v(i));  
             
       general_root = roots(sol');
       
      
       b_can = zeros(numel(general_root),1);
       
       for j=1:numel(general_root)
          if isreal(general_root(j))
             if general_root(j)>= s_begin && general_root(j)<= s_end
                b_can(j) = 1;
             end
          end
       end
       
       if sum(b_can) > 0 
         temp = general_root(b_can==1);
         s_merge_v(i) = temp(1); %either one should be representative
       else %no good solution
         s_merge_v(i) = mean(this_s_seg(:));
       end    
    end
end


