% EM+ for sigma only estimation

function [est_sigma est_beta est_epsilon KLD est_pmf_v] = csm_em_fit_sigma_only(dim, pmf_v, s_v, s_length_v, in_sigma, in_beta, in_epsilon, verbose_flag, overall_iteration_limit, sigma_converge_threshold, KLD_threshold)

if(~exist('verbose_flag','var'))
  verbose_flag = 0; %no detailed output
end

% ===========  iteration parameters  =================


if(~exist('overall_iteration_limit','var'))
  overall_iteration_limit = 10000;
end

if(~exist('sigma_converge_threshold','var'))
  sigma_converge_threshold = 1e-7;
end

if(~exist('KLD_threshold','var'))
  KLD_threshold = 1e-7;
end

intital_iteration = 1;
% ===========  function definition  =================
if dim>1
  fun_g0 = @(s,w,sigma,beta) (s ./ sigma ./ (2*(dim-1)).^0.5).^(dim-1) ./ sigma .* exp(-s.^2 ./ sigma.^2 / 2 .* w ./ (w+1)) .* (((w.^(-w) .* exp(w-1)).^beta) ./ (w+1).^0.5).^dim;
else
  fun_g0 = @(s,w,sigma,beta) 1 ./ sigma .* exp(-s.^2 ./ sigma.^2 / 2 .* w ./ (w+1)) .* (((w.^(-w) .* exp(w-1)).^beta) ./ (w+1).^0.5).^dim;
end

fun_g1 = @(s,w,sigma,beta) s.^2 .* w ./ (w+1) .* fun_g0(s,w,sigma,beta);
fun_g2 = @(s,w,sigma,beta) w .* (1-log(w)) .* fun_g0(s,w,sigma,beta);

fun_N = @(w,beta) ((w.^(-w) .* exp(w-1)).^beta ./ w.^(1/2)).^dim ;
fun_H = @(w,beta,N) ((w.^(-w) .* exp(w-1)).^beta ./ w.^(1/2)).^dim .*w .* (1-log(w))/N;

if dim>1
  fun_e0 = @(s,w,sigma,beta) (s ./ sigma ./ (2*(dim-1)).^0.5).^(dim-1) ./ sigma .* exp(-s.^2 ./ sigma.^2 / 2 .* w ./ (w+1));
else
  fun_e0 = @(s,w,sigma,beta) 1 ./ sigma .* exp(-s.^2 ./ sigma.^2 / 2 .* w ./ (w+1));
end

fun_range = @(theta) (theta(1)>beta_max) || (theta(1)<beta_min) || (theta(2)<sigma_min) || (theta(3)<epsilon_min) || (theta(3)>epsilon_max);


% ===========  Iteration begins  =================
est_sigma = in_sigma;
est_beta = in_beta;
est_epsilon = in_epsilon;
est_rvar = est_beta*dim*est_sigma^2;
theta = [est_beta est_sigma est_epsilon]';
A = -eye(3);
g = [0 0 0]';

for overall_iteration=1:overall_iteration_limit
    % =========== fix epsilon and beta, update sigma  ===============
        f0_v = zeros(1,length(s_v));
        f1_v = zeros(1,length(s_v));
        
        %EM for updating sigma
        tstart=tic;
        for j=1:length(s_v)
            sj = s_v(j);
            
            fun_para_g0 = @(w) fun_g0(sj,w,est_sigma,est_beta);
            fun_para_g1 = @(w) fun_g1(sj,w,est_sigma,est_beta);
        
            f0_v(j) = quadgk(fun_para_g0,est_epsilon,1);
            f1_v(j) = quadgk(fun_para_g1,est_epsilon,1);
        end
        
        %avoid f0 = 0
        ori_f0_v = f0_v;
        f1_v(f0_v==0) = 0;
        f0_v(f0_v==0) = 0.1;
        
        est_var = sum(pmf_v .* f1_v ./ f0_v) / dim;
        gd = -sum(pmf_v.*f1_v./f0_v)/est_sigma^3 + dim/est_sigma;
        t_sigma=toc(tstart);
        
        est_pmf_v = ori_f0_v .* s_length_v;
        est_pmf_v = est_pmf_v/sum(est_pmf_v);
        KLD = pmf_cross_entropy(pmf_v,est_pmf_v) - pmf_entropy(pmf_v); 
        
        if(verbose_flag==1)
          fprintf('bi-section iter %d: KLD %f, est_sigma %f, est_beta %f, est_epsilon %f; t_sigma %f\n', overall_iteration, KLD, est_sigma, est_beta, est_epsilon, t_sigma);
        end
        
        %convergence checking
        if (overall_iteration > intital_iteration) && (((abs(est_sigma-pre_sigma)/pre_sigma)<sigma_converge_threshold) || KLD < KLD_threshold)
          break;
        end

        pre_sigma = est_sigma;
        est_sigma = sqrt(est_var);
        %est_sigma = pre_sigma-gd;

end

fun_g = @(s,w,sigma,beta) (s ./ sigma ./ (2*(dim-1)).^0.5).^(dim-1) ./ sigma .* exp(-s.^2 ./ sigma.^2 / 2 .* w ./ (w+1)) .* (((w.^(-w) .* exp(w-1)).^beta) ./ (w+1).^0.5).^dim;

est_pmf_v = zeros(1,length(s_v));

for i=1:length(s_v)
    fun_para_g = @(w) fun_g(s_v(i),w,est_sigma,est_beta);
    est_pmf_v(i) = quadgk(fun_para_g,est_epsilon,1);
end

est_pmf_v = est_pmf_v .* s_length_v;
est_pmf_v = est_pmf_v/sum(est_pmf_v);
KLD = pmf_cross_entropy(pmf_v,est_pmf_v) - pmf_entropy(pmf_v);

if(verbose_flag==1)
  fprintf('==========> End: est_sigma %f, est_beta %f, est_epsilon %f, KLD %f\n', est_sigma, est_beta, est_epsilon, KLD);
end

