%Trimmed L-moments s=0,t=1~2

function [tr01_tau_3 tr02_tau_3] = get_lmoments_tau3_tr01_02(x_end_v, x_length_v, Fx)

func_P2 = @(x) 2*x-1;
func_P3 = @(x) 6*x.^2-6*x+1;
func_P4 = @(x) 20*x.^3-30*x.^2+12*x-1;
func_P5 = @(x) 70*x.^4-140*x.^3+90*x.^2-20*x+1;
func_P6 = @(x) 252*x.^5 - 630*x.^4 + 560*x.^3 - 210*x.^2 + 30*x - 1; %(63*(2*x-1).^5 - 70*(2*x-1).^3 + 15*(2*x-1))/8;

func_P2_D1 = @(x) 2;
func_P3_D1 = @(x) 12*x-6;
func_P3_D2 = @(x) 12;
func_P4_D1 = @(x) 60*x.^2-60*x+12;
func_P4_D2 = @(x) 120*x-60;
func_P4_D3 = @(x) 120;
func_P5_D1 = @(x) 280*x.^3-420*x.^2+180*x-20;
func_P5_D2 = @(x) 840*x.^2-840*x;
func_P5_D3 = @(x) 1680*x-840;
func_P5_D4 = @(x) 1680;
func_P6_D1 = @(x) 1260*x.^4 - 2520*x.^3 + 1680*x.^2 - 420*x + 30;
func_P6_D2 = @(x) 5040*x.^3 - 7560*x.^2 + 3360*x - 420;
func_P6_D3 = @(x) 15120*x.^2 - 15120*x + 3360;
func_P6_D4 = @(x) 30240*x - 15120;
func_P6_D5 = @(x) 30240;


func_P2_S1 = @(x) x.^2-x;
func_P3_S1 = @(x) 2*x.^3-3*x.^2+x;
func_P4_S1 = @(x) 5*x.^4-10*x.^3+6*x.^2-x;
func_P5_S1 = @(x) 14*x.^5 - 35*x.^4 + 30*x.^3 - 10*x.^2 + x;
func_P6_S1 = @(x) 42*x.^6 - 126*x.^5 + 140*x.^4 - 70*x.^3 + 15*x.^2 - x;

func_P2_S2 = @(x) 1.0/3.0*x.^3-1.0/2.0*x.^2;
func_P3_S2 = @(x) 1.0/2.0*x.^4-x.^3+1.0/2.0*x.^2;
func_P4_S2 = @(x) x.^5-5.0/2.0*x.^4+2*x.^3-1.0/2.0*x.^2;
func_P5_S2 = @(x) (7*x.^6)/3 - 7*x.^5 + (15*x.^4)/2 - (10*x.^3)/3 + x.^2/2;
func_P6_S2 = @(x) 6*x.^7 - 21*x.^6 + 28*x.^5 - (35*x.^4)/2 + 5*x.^3 - x.^2/2;

x_begin_v = x_end_v - x_length_v;
fx = (Fx-[0 Fx(1:end-1)])./x_length_v;

P2_S1_v = func_P2_S1(Fx);
P2_S2_v = func_P2_S2(Fx);
P2_m1_v = func_P2([0 Fx(1:end-1)]);
P2_D1_m1_v = func_P2_D1([0 Fx(1:end-1)]);
x_length_e2_v = x_length_v.*x_length_v;
x_length_e3_v = x_length_e2_v.*x_length_v;
fx_e2_v = fx.*fx;
lambda_2 = sum(x_end_v.*(P2_S1_v-[0 P2_S1_v(1:end-1)]) - P2_m1_v.*fx.*x_length_e2_v/2 - P2_D1_m1_v.*fx_e2_v.*x_length_e3_v/6);

P3_S1_v = func_P3_S1(Fx);
P3_S2_v = func_P3_S2(Fx);
P3_m1_v = func_P3([0 Fx(1:end-1)]);
P3_D1_m1_v = func_P3_D1([0 Fx(1:end-1)]);
P3_D2_m1_v = func_P3_D2([0 Fx(1:end-1)]);
x_length_e4_v = x_length_e3_v.*x_length_v;
fx_e3_v = fx_e2_v.*fx;
lambda_3 = sum(x_end_v.*(P3_S1_v-[0 P3_S1_v(1:end-1)]) - P3_m1_v.*fx.*x_length_e2_v/2 - P3_D1_m1_v.*fx_e2_v.*x_length_e3_v/6 - P3_D2_m1_v.*fx_e3_v.*x_length_e4_v/24);

P4_S1_v = func_P4_S1(Fx);
P4_S2_v = func_P4_S2(Fx);
P4_m1_v = func_P4([0 Fx(1:end-1)]);
P4_D1_m1_v = func_P4_D1([0 Fx(1:end-1)]);
P4_D2_m1_v = func_P4_D2([0 Fx(1:end-1)]);
P4_D3_m1_v = func_P4_D3([0 Fx(1:end-1)]);
x_length_e5_v = x_length_e4_v.*x_length_v;
fx_e4_v = fx_e3_v.*fx;
lambda_4 = sum(x_end_v.*(P4_S1_v-[0 P4_S1_v(1:end-1)]) - P4_m1_v.*fx.*x_length_e2_v/2 - P4_D1_m1_v.*fx_e2_v.*x_length_e3_v/6 - P4_D2_m1_v.*fx_e3_v.*x_length_e4_v/24 - P4_D3_m1_v.*fx_e4_v.*x_length_e5_v/120);

P5_S1_v = func_P5_S1(Fx);
P5_S2_v = func_P5_S2(Fx);
P5_m1_v = func_P5([0 Fx(1:end-1)]);
P5_D1_m1_v = func_P5_D1([0 Fx(1:end-1)]);
P5_D2_m1_v = func_P5_D2([0 Fx(1:end-1)]);
P5_D3_m1_v = func_P5_D3([0 Fx(1:end-1)]);
P5_D4_m1_v = func_P5_D3([0 Fx(1:end-1)]);
x_length_e6_v = x_length_e5_v.*x_length_v;
fx_e5_v = fx_e4_v.*fx;
lambda_5 = sum(x_end_v.*(P5_S1_v-[0 P5_S1_v(1:end-1)]) - P5_m1_v.*fx.*x_length_e2_v/2 - P5_D1_m1_v.*fx_e2_v.*x_length_e3_v/6 - P5_D2_m1_v.*fx_e3_v.*x_length_e4_v/24 - P5_D3_m1_v.*fx_e4_v.*x_length_e5_v/120 - P5_D4_m1_v.*fx_e5_v.*x_length_e6_v/720);

%Get trimmed l-moments

tr01_lambda_2 = (2+1)/2/2*(lambda_2-lambda_3);
tr01_lambda_3 = (3+1)/2/3*(lambda_3-lambda_4);

tr01_tau_3 = tr01_lambda_3/tr01_lambda_2;

%Get trimmed l-moments (0,2)

tr02_lambda_2 = ( 3*lambda_2 - 5*lambda_3 + 2*lambda_4)/5;
tr02_lambda_3 = (20*lambda_3 -35*lambda_4 +15*lambda_5)/42;

tr02_tau_3 = tr02_lambda_3/tr02_lambda_2;

