%apply range filter in bilateral neighborhood + with distance > 1

function output_image = square_filter_distance_fast_opt(input_image,r_var,coeff,iteration)

timer_on = 0;

if(timer_on==1)
 tstart = tic;
end

update_image = double(input_image);
ini_image = double(input_image);
size_image = size(update_image);

size_coeff = size(coeff);
distance = (size_coeff(1)-1)/2;
diameter = size_coeff(1);
a2 = diameter*diameter;
p_center = (a2+1)/2;

col_coeff = coeff(:);

ini_pad_image = padarray(ini_image, [distance distance 0], 'symmetric');

inver = -1.0/(2*r_var);

img_range_y = [distance+1:1:distance+size_image(1)];
img_range_x = [distance+1:1:distance+size_image(2)];

shift_idx = zeros(2,a2);
m=1;

for i=-distance:distance
    for j=-distance:distance
        shift_idx(:,m) = [i,j];
        m = m+1;
    end
end

acc_img = zeros(size_image);
wall_img = zeros(size_image(1),size_image(2));
weight = zeros(size_image(1),size_image(2));

parfor m=1:a2

   weight = exp(sum((ini_pad_image(img_range_y,img_range_x,:) - ini_pad_image(img_range_y+shift_idx(1,m),img_range_x+shift_idx(2,m),:)).^2,3)*inver)*col_coeff(m);
   wall_img = wall_img + weight;
   acc_img = acc_img + ini_pad_image(img_range_y+shift_idx(1,m),img_range_x+shift_idx(2,m),:).*weight(:,:,ones(3,1));

end

output_image = acc_img./wall_img(:,:,ones(3,1));


if(timer_on==1)
 telasped =  toc(tstart);
 fprintf('Filter done in %f s\n',telasped);  
end
