%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%  
%%  The following is a demo code for testing the default configuration of the
%%  recursive fitting and filtering scheme:
%%  Bilateral/Yaroslavsky filter, Gaussian range-weighted kernel, k=3, AWGN
%%  
%%  This is the supplementary material for the submitted paper
%%  "Fast Distribution Fitting for Parameter Estimation of Range-Weighted Neighborhood Filters," IEEE SPL.
%%  
%%  For running this code, you need the license of MATLAB Image Toolbox and Parallel Computing Toolbox.
%%  This code have been verified to work with Matlab R2010b.
%%
%%  Output description:
%%  *yaro_bf_recursive_filtering/
%%         *.csv:           results of fitting and filtering in csv format
%%         *fig/*.png:     denoised images
%%         *fit_fig/*.png: figures showing the fitting results
%%
%%  For any queries regarding this code, please contact chaotsung@ee.nthu.edu.tw
%%  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear

dim=3; %k=3
epsilon_bd = 0.1; %epsilon upper bound in Psi

%=============== Select test images =======================

%The following four lines for a simple test with Lena image, noise intensity 50, BF-9x9
test_image_v = {'lena'};
test_noise_v = {'N50'};
test_radius_v = [4];
test_neighbor_v = {'Bilateral'}; %Yaroslavsky or Bilateral

%The following four lines for BF-9x9. Uncomment for reproducing the results.
%test_image_v = {'lena','baboon','barbara','peppers','F16','house','kodim04','kodim08','kodim13','kodim19','kodim22','kodim23'};
%test_noise_v = {'N5', 'N10', 'N20', 'N40', 'N50'};
%test_radius_v = [4];
%test_neighbor_v = {'Bilateral'}; %Yaroslavsky or Bilateral

%The following four lines for YF-5x5 and YF-9x9. Uncomment for reproducing the results.
%test_image_v = {'lena','baboon','barbara','peppers','F16','house','kodim04','kodim08','kodim13','kodim19','kodim22','kodim23'};
%test_noise_v = {'N5', 'N10', 'N20', 'N40', 'N50'};
%test_radius_v = [2 4];
%test_neighbor_v = {'Yaroslavsky'}; %Yaroslavsky or Bilateral

%The following four lines for BF-9x9 and BF-13x13. Uncomment for reproducing the results.
%test_image_v = {'lena','baboon','barbara','peppers','F16','house','kodim04','kodim08','kodim13','kodim19','kodim22','kodim23'};
%test_noise_v = {'N5', 'N10', 'N20', 'N40', 'N50'};
%test_radius_v = [4 6];
%test_neighbor_v = {'Bilateral'}; %Yaroslavsky or Bilateral

%=============== Select fitting method =======================

%The following two lines for using EFM-20 fitting.
T=20;
GPMF_EFM_yaro_bf_recursive_filtering(dim, epsilon_bd, T, test_image_v, test_noise_v, test_radius_v, test_neighbor_v);

%The following two lines for using EFM-10 fitting. Uncomment for reproducing the results.
%T=10;
%GPMF_EFM_yaro_bf_recursive_filtering(dim, epsilon_bd, T, test_image_v, test_noise_v, test_radius_v, test_neighbor_v);

%The following line for using L-moment fitting. Uncomment for reproducing the results.
%GPMF_LM_yaro_bf_recursive_filtering(dim, test_image_v, test_noise_v, test_radius_v, test_neighbor_v);

%The following line for using direct EM+ fitting. Uncomment for reproducing the results.
%yaro_bf_recursive_filtering(dim, epsilon_bd, test_image_v, test_noise_v, test_radius_v, test_neighbor_v);

