%Equal-frequency merging
%Note: Leave the unused bins to the tail

function [pmf_merge send_v end_idx] = equal_freq_merge(pmf_merge, send_v, merge_count)

pmf_merge = pmf_merge/sum(pmf_merge);

target_prob = 1.0/double(merge_count);
acc_prob = 0;

i = 1;
pre_idx = 0;

new_pmf = zeros(1,merge_count);
new_send_v = zeros(1,merge_count);

for cur_idx=1:length(pmf_merge)

    acc_prob = acc_prob + pmf_merge(cur_idx);
    
    if acc_prob >=target_prob
       new_pmf(i) = acc_prob;
       new_send_v(i) = send_v(cur_idx);
       pre_idx = cur_idx;
       acc_prob = 0;
       i = i+1;
    end
end

%equal-width for the remaining tail
if i <= merge_count
   left_num = merge_count-i+1;
   step_size = floor(double(length(pmf_merge)-pre_idx)/double(left_num));
   
   if step_size == 0 %tear down the last bin
      i=i-1;
      pre_idx = find(send_v==new_send_v(i-1));
      
      left_num = merge_count-i+1;
      step_size = floor(double(length(pmf_merge)-pre_idx)/double(left_num));
   
   end
   
   for j=1:left_num-1
       new_pmf(i+j-1) = sum(pmf_merge(pre_idx+(j-1)*step_size+1:pre_idx+j*step_size));
       new_send_v(i+j-1) = send_v(pre_idx+j*step_size);
   end

   new_pmf(merge_count) = sum(pmf_merge(pre_idx+(left_num-1)*step_size+1:end));
   new_send_v(merge_count) = send_v(end);

end




pmf_merge = new_pmf/sum(new_pmf);
send_v = new_send_v;

