
function [est_alpha est_epsilon est_lambda2 cost_array gauss_curvature] = least_squared_tau_fitting_L2gv(in_tau3, in_tau4, alpha_array, epsilon_array, lambda_2_array, tau_3_array, tau_4_array)

cost_array = (tau_3_array - in_tau3).^2 + (tau_4_array - in_tau4).^2;

[min_v index_v] = min(cost_array);
[min_c index_j] = min(min_v,[],2);

index_i = index_v(index_j);

%refine sub-pixel i
if index_i==1 || index_i==size(cost_array,1)
   sub_pixel_i = 0;
   if index_i==1 
      curv_i = 2*(sqrt(cost_array(index_i+1,index_j))-sqrt(cost_array(index_i,index_j)));
   else
      curv_i = 2*(sqrt(cost_array(index_i-1,index_j))-sqrt(cost_array(index_i,index_j)));
   end
else
   E1 = sqrt(cost_array(index_i+1,index_j));
   E0 = sqrt(cost_array(index_i,index_j));
   Em1 = sqrt(cost_array(index_i-1,index_j));
   
   sub_pixel_i = 0.5 * (Em1 - E1)/(E1 - 2*E0 + Em1);
   curv_i = (E1 - 2*E0 + Em1);
end

%refine sub-pixel j
if index_j==1 || index_j==size(cost_array,2)
   sub_pixel_j = 0;
   if index_j==1 
      curv_j = 2*(sqrt(cost_array(index_i,index_j+1))-sqrt(cost_array(index_i,index_j)));
   else
      curv_j = 2*(sqrt(cost_array(index_i,index_j-1))-sqrt(cost_array(index_i,index_j)));
   end
else
   E1 = sqrt(cost_array(index_i,index_j+1));
   E0 = sqrt(cost_array(index_i,index_j));
   Em1 = sqrt(cost_array(index_i,index_j-1));
   
   sub_pixel_j = 0.5 * (Em1 - E1)/(E1 - 2*E0 + Em1);
   curv_j = (E1 - 2*E0 + Em1);
end

%Note: Elliptic paraboloid estimation equals to separable parabola estimations
%estimate alpha (linear interpolation)
if index_i==size(cost_array,1)
   est_alpha = alpha_array(index_i,index_j);
else
   est_alpha = alpha_array(index_i,index_j) + sub_pixel_i*(alpha_array(index_i+1,index_j)-alpha_array(index_i,index_j));
end

%estimate epsilon (linear interpolation in log domain)
if index_j==size(cost_array,2)
   est_epsilon = epsilon_array(index_i,index_j);
else
   log_epsilon = log(epsilon_array(index_i,index_j)) + sub_pixel_j*(log(epsilon_array(index_i,index_j+1))-log(epsilon_array(index_i,index_j)));
   est_epsilon = exp(log_epsilon);
end

%bilinear interpolation for lambda2

i_up = int16(floor(sub_pixel_i+index_i));
i_down = int16(ceil(sub_pixel_i+index_i));

j_left = int16(floor(sub_pixel_j+index_j));
j_right = int16(ceil(sub_pixel_j+index_j));

gain_right = sub_pixel_j+index_j - double(j_left);
gain_down = sub_pixel_i+index_i - double(i_up);

interp_up = (1-gain_right)*lambda_2_array(i_up,j_left) + gain_right*lambda_2_array(i_up,j_right);
interp_dn = (1-gain_right)*lambda_2_array(i_down,j_left) + gain_right*lambda_2_array(i_down,j_right);

est_lambda2 = (1-gain_down)*interp_up + gain_down*interp_dn;

%Gauss curvature equals to the multiplicaton of two curvature 

gauss_curvature = curv_i * curv_j;



