function [lambda_2 tau_3 tau_4] = get_lmoments(x_end_v, x_length_v, Fx)

func_P2 = @(x) 2*x-1;
func_P3 = @(x) 6*x.^2-6*x+1;
func_P4 = @(x) 20*x.^3-30*x.^2+12*x-1;

func_P2_D1 = @(x) 2;
func_P3_D1 = @(x) 12*x-6;
func_P3_D2 = @(x) 12;
func_P4_D1 = @(x) 60*x.^2-60*x+12;
func_P4_D2 = @(x) 120*x-60;
func_P4_D3 = @(x) 120;

func_P2_S1 = @(x) x.^2-x;
func_P3_S1 = @(x) 2*x.^3-3*x.^2+x;
func_P4_S1 = @(x) 5*x.^4-10*x.^3+6*x.^2-x;

func_P2_S2 = @(x) 1.0/3.0*x.^3-1.0/2.0*x.^2;
func_P3_S2 = @(x) 1.0/2.0*x.^4-x.^3+1.0/2.0*x.^2;
func_P4_S2 = @(x) x.^5-5.0/2.0*x.^4+2*x.^3-1.0/2.0*x.^2;

x_begin_v = x_end_v - x_length_v;
fx = (Fx-[0 Fx(1:end-1)])./x_length_v;

P2_S1_v = func_P2_S1(Fx);
P2_S2_v = func_P2_S2(Fx);
P2_m1_v = func_P2([0 Fx(1:end-1)]);
P2_D1_m1_v = func_P2_D1([0 Fx(1:end-1)]);
x_length_e2_v = x_length_v.*x_length_v;
x_length_e3_v = x_length_e2_v.*x_length_v;
fx_e2_v = fx.*fx;
lambda_2 = sum(x_end_v.*(P2_S1_v-[0 P2_S1_v(1:end-1)]) - P2_m1_v.*fx.*x_length_e2_v/2 - P2_D1_m1_v.*fx_e2_v.*x_length_e3_v/6);

P3_S1_v = func_P3_S1(Fx);
P3_S2_v = func_P3_S2(Fx);
P3_m1_v = func_P3([0 Fx(1:end-1)]);
P3_D1_m1_v = func_P3_D1([0 Fx(1:end-1)]);
P3_D2_m1_v = func_P3_D2([0 Fx(1:end-1)]);
x_length_e4_v = x_length_e3_v.*x_length_v;
fx_e3_v = fx_e2_v.*fx;
lambda_3 = sum(x_end_v.*(P3_S1_v-[0 P3_S1_v(1:end-1)]) - P3_m1_v.*fx.*x_length_e2_v/2 - P3_D1_m1_v.*fx_e2_v.*x_length_e3_v/6 - P3_D2_m1_v.*fx_e3_v.*x_length_e4_v/24);

P4_S1_v = func_P4_S1(Fx);
P4_S2_v = func_P4_S2(Fx);
P4_m1_v = func_P4([0 Fx(1:end-1)]);
P4_D1_m1_v = func_P4_D1([0 Fx(1:end-1)]);
P4_D2_m1_v = func_P4_D2([0 Fx(1:end-1)]);
P4_D3_m1_v = func_P4_D3([0 Fx(1:end-1)]);
x_length_e5_v = x_length_e4_v.*x_length_v;
fx_e4_v = fx_e3_v.*fx;
lambda_4 = sum(x_end_v.*(P4_S1_v-[0 P4_S1_v(1:end-1)]) - P4_m1_v.*fx.*x_length_e2_v/2 - P4_D1_m1_v.*fx_e2_v.*x_length_e3_v/6 - P4_D2_m1_v.*fx_e3_v.*x_length_e4_v/24 - P4_D3_m1_v.*fx_e4_v.*x_length_e5_v/120);

tau_3 = lambda_3/lambda_2;
tau_4 = lambda_4/lambda_2;

