
function pmf = get_chi_pmf_neighborhood_array_opt(input_img,coeff)

value_range = ceil(sqrt((max(max(abs(input_img(:,:,1)))))^2 + (max(max(abs(input_img(:,:,2)))))^2 + (max(max(abs(input_img(:,:,3)))))^2))+1;
value_range = 4*value_range;

pmf = double(zeros(1,value_range));

%initialize coeff mask
size_coeff = size(coeff);
distance = (size_coeff(1)-1)/2;
diameter = size_coeff(1);
a2 = diameter*diameter;
p_center = (a2+1)/2;

col_coeff = coeff(:);
col_coeff(p_center) = 0;

%initialize image patch
ini_image = double(input_img);
size_image = size(input_img);

ini_pad_image = padarray(ini_image, [distance distance 0], 'symmetric');

img_range_y = [distance+1:1:distance+size_image(1)];
img_range_x = [distance+1:1:distance+size_image(2)];

shift_idx = zeros(2,a2);
m=1;

for i=-distance:distance
    for j=-distance:distance
        shift_idx(:,m) = [i,j];
        m = m+1;
    end
end

chi_img = zeros([size_image(1) size_image(2)]);
hist_img = zeros(value_range,a2);

hist_edge = [0 (0:1:value_range-2)+0.5];

parfor m=1:a2

   chi_img = sqrt(sum((ini_pad_image(img_range_y,img_range_x,:) - ini_pad_image(img_range_y+shift_idx(1,m),img_range_x+shift_idx(2,m),:)).^2,3));
   hist_img(:,m) = histc(chi_img(:),hist_edge);

end

pmf = sum(hist_img*col_coeff,2);

nzero_idx = find(pmf > 0);

pmf = pmf(1:max(nzero_idx));
pmf=pmf./sum(pmf);

