/****************************************************************************/
/*   MPEG4 Visual Texture Coding (VTC) Mode Software                        */
/*                                                                          */
/*   This software was jointly developed by the following participants:     */
/*                                                                          */
/*   Single-quant,  multi-quant and flow control                            */
/*   are provided by  Sarnoff Corporation                                   */
/*     Iraj Sodagar   (iraj@sarnoff.com)                                    */
/*     Hung-Ju Lee    (hjlee@sarnoff.com)                                   */
/*     Paul Hatrack   (hatrack@sarnoff.com)                                 */
/*     Shipeng Li     (shipeng@sarnoff.com)                                 */
/*     Bing-Bing Chai (bchai@sarnoff.com)                                   */
/*     B.S. Srinivas  (bsrinivas@sarnoff.com)                               */
/*                                                                          */
/*   Bi-level is provided by Texas Instruments                              */
/*     Jie Liang      (liang@ti.com)                                        */
/*                                                                          */
/*   Shape Coding is provided by  OKI Electric Industry Co., Ltd.           */
/*     Zhixiong Wu    (sgo@hlabs.oki.co.jp)                                 */
/*     Yoshihiro Ueda (yueda@hlabs.oki.co.jp)                               */
/*     Toshifumi Kanamaru (kanamaru@hlabs.oki.co.jp)                        */
/*                                                                          */
/*   OKI, Sharp, Sarnoff, TI and Microsoft contributed to bitstream         */
/*   exchange and bug fixing.                                               */
/*                                                                          */
/*   Scalable Shape Coding was provided by:                                 */
/*         Shipeng Li (Sarnoff Corporation),                                */
/*         Dae-Sung Cho (Samsung AIT),					    */
/*         Se Hoon Son (Samsung AIT)	                                    */
/* In the course of development of the MPEG-4 standard, this software       */
/* module is an implementation of a part of one or more MPEG-4 tools as     */
/* specified by the MPEG-4 standard.                                        */
/*                                                                          */
/* The copyright of this software belongs to ISO/IEC. ISO/IEC gives use     */
/* of the MPEG-4 standard free license to use this  software module or      */
/* modifications thereof for hardware or software products claiming         */
/* conformance to the MPEG-4 standard.                                      */
/*                                                                          */
/* Those intending to use this software module in hardware or software      */
/* products are advised that use may infringe existing  patents. The        */
/* original developers of this software module and their companies, the     */
/* subsequent editors and their companies, and ISO/IEC have no liability    */
/* and ISO/IEC have no liability for use of this software module or         */
/* modification thereof in an implementation.                               */
/*                                                                          */
/* Permission is granted to MPEG members to use, copy, modify,              */
/* and distribute the software modules ( or portions thereof )              */
/* for standardization activity within ISO/IEC JTC1/SC29/WG11.              */
/*                                                                          */
/* Copyright 1995, 1996, 1997, 1998 ISO/IEC                                 */
/****************************************************************************/
/*****************************************************************************
 "This software module was originally developed by:
 
	Dae-Sung Cho (Samsung AIT),
	Se Hoon Son (Samsung AIT)
 
        and edited by:

	Dae-Sung Cho (Samsung AIT)
 
        in the course of development of the <MPEG-4 Video(ISO/IEC 14496-2)>. This
  software module is an implementation of a part of one or more <MPEG-4 Video
  (ISO/IEC 14496-2)> tools as specified by the <MPEG-4 Video(ISO/IEC 14496-2)
  >. ISO/IEC gives users of the <MPEG-4 Video(ISO/IEC 14496-2)> free license
  to this software module or modifications thereof for use in hardware or
  software products claiming conformance to the <MPEG-4 Video(ISO/IEC 14496-2
  )>. Those intending to use this software module in hardware or software
  products are advised that its use may infringe existing patents. The
  original developer of this software module and his/her company, the
  subsequent editors and their companies, and ISO/IEC have no liability for
  use of this software module or modifications thereof in an implementation.
  Copyright is not released for non <MPEG-4 Video(ISO/IEC 14496-2)>
  conforming products. Samsung AIT (SAIT) retains full right to use the code
  for his/her own purpose, assign or donate the code to a third party and to
  inhibit third parties from using the code for non <MPEG-4 Video(ISO/IEC
  14496-2)> conforming products. This copyright notice must be included in
  all copies or derivative works. Copyright (c)1997, 1998".
 *****************************************************************************/

#include <stdio.h>
#include <math.h>
#include <malloc.h>
#include "basic.hpp"
#include "dataStruct.hpp"
//#include "ShapeBaseCommon.h"
//#include "BinArCodec.h"
 
//#include "dwt.h"
#include "ShapeEnhDef.hpp"
//#include "ShapeEnhCommon.h"
//#include "ShapeEnhDecode.h"

#define Error -1

/***********************************************************HeaderBegin*******
 *
 * File:        sisc_decode.c
 *
 * Author:      Samsung AIT (SAIT)
 * Created:     23-Apr-98
 *
 * Description: Scalable shape coder using scan interleaving (sisc fac version)
 *
 * Copyright (C) 1996 Samsung AIT All Rights Reserved.                
 *
 ***********************************************************HeaderEnd*********/

Int CVTCDecoder::
ShapeEnhDeCoding(UChar *LowShape,		/* in: shape mask in the lower layer */
                        UChar *HalfShape,	/* out: shape mask in the current layer */
                        UChar *CurShape,	/* out: shape mask in the current layer */
                        Int object_width,
                        Int object_height,
			FILTER *filter)
{
    Int i, j, k, l, p, q, x, y, x2, y2;
    Int bab_type, ret;

    Int width2		= object_width,
	height2		= object_height,
	width		= width2 >> 1,
	height		= height2 >> 1;
    Int NB = (object_width >= 1024 || object_height >=1024)? 6:
      (object_width >=512|| object_height >=512)?5:4;
    Int mborder		= MBORDER,
    	mblks           = NB,
	mbsize          = 1<<mblks,		/* bab size in the current layer : 16 */
	mbsize_ext      = mbsize+(mborder<<1);  /* bordered bab size in the current layer: 20 */
 
    Int border		= BORDER,
    	blks            = mblks-1,
	bsize           = 1<<blks,		/* bab size in the lower layer : 8 */
	bsize_ext       = bsize+(border<<1);	/* bordered bab size in the lower layer: 8 */
 
    Int blkx            = (object_width+mbsize-1)/mbsize,
	blky            = (object_height+mbsize-1)/mbsize;

    UInt prob;

    UChar *lower_bab;			/* alpha block in the lower layer */
    UChar *bordered_lower_bab;		/* bordered alpha block in the lower layer */
 
    UChar *half_bab;			/* alpha mb in the current layer */
    UChar *bordered_half_bab;		/* bordered alpha mb in the current layer */
 
    UChar *curr_bab;			/* alpha mb in the current layer */
    UChar *bordered_curr_bab;		/* bordered alpha mb in the current layer */

    ArDecoder	ar_decoder;

    /*-- Memory allocation ---------------------------------------------------------*/
    lower_bab = (UChar *) calloc(bsize*bsize, sizeof(UChar));
    bordered_lower_bab = (UChar *) calloc(bsize_ext*bsize_ext, sizeof(UChar));
    half_bab = (UChar *) calloc(mbsize*bsize, sizeof(UChar));
    bordered_half_bab = (UChar *) calloc(mbsize_ext*bsize_ext, sizeof(UChar));
    curr_bab = (UChar *) calloc(mbsize*mbsize, sizeof(UChar));
    bordered_curr_bab = (UChar *) calloc(mbsize_ext*mbsize_ext, sizeof(UChar));

    /*-- Decode the Enhancement Layer ------------------------------------------------*/
    StartArDecoder_Still(&ar_decoder);

    for ( j=y=y2=0; j<blky; j++, y+=bsize, y2+=mbsize ) 
    {
      for ( i=x=x2=0; i<blkx; i++, x+=bsize, x2+=mbsize ) 
      {
        /*-- Initialize BABs --*/
	q = y*width;
	for ( l=p=0; l<bsize; l++, q+=width ) 
	{
          for ( k=0; k<bsize; k++, p++ ) 
	  {
	      if(  y+l < height && x+k < width )
		lower_bab[p] = (LowShape[ q+x+k ] != 0);
	      else
		lower_bab[p] = 0;
          }
	}
	
	q = y2*width;
	for ( l=p=0; l<mbsize; l++, q+=width ) 
          for ( k=0; k<bsize; k++, p++ ) 	
	    half_bab[p]=0;

	q = y2*width2;
	for ( l=p=0; l<mbsize; l++, q+=width2 ) 
          for ( k=0; k<mbsize; k++, p++ ) 	
		curr_bab[p]=0;

	/*-- Get BAB coding mode -- */

	if(filter->DWT_Class==DWT_ODD_SYMMETRIC){
	  prob=scalable_bab_type_prob[0];
	} else if(filter->DWT_Class==DWT_EVEN_SYMMETRIC) {
	  prob=scalable_bab_type_prob[1];
	} else {
	  fprintf(stderr,"Error: filter type in ShapeEnhHeaderDecode()!\n");
	  exit(0);
	}
	bab_type = ArDecodeSymbol_Still(&ar_decoder, prob);

        /* Add surrounding pixels for Modified SISC. */
	AddBorderToBABs(LowShape, HalfShape, CurShape,
			lower_bab, half_bab, curr_bab,
			bordered_lower_bab, bordered_half_bab,
			bordered_curr_bab,
			object_width, object_height,
			i, j, mbsize, blkx);

	/* Decode mask pixel values in the current layer */
	ret = ShapeEnhContentDecode(bordered_lower_bab, 
				bordered_half_bab, 
				bordered_curr_bab, 
				bab_type, 
				mbsize, 
					filter,
				&ar_decoder);

	if (ret == Error)
        {
          fprintf(stderr,"\n SI arithmetic coding Error !\n");
          return  Error;
        }

	q = mborder*mbsize_ext;
	for ( l=p=0; l<mbsize; l++, q+=mbsize_ext ) 
          for ( k=0; k<mbsize; k++, p++ ) 
	      	curr_bab[p]=bordered_curr_bab[q+k+mborder];

	q = mborder*bsize_ext;
	for ( l=p=0; l<mbsize; l++, q+=bsize_ext ) 
          for ( k=0; k<bsize; k++, p++ ) 
	      	half_bab[p]=bordered_half_bab[q+k+border];
        /*-- Put BABs to HalfShape--*/
	q = y2*width;
	for ( l=p=0; l<mbsize; l++, q+=width ) 
          for ( k=0; k<bsize; k++, p++ ) 
	    if(  y2+l < height2 && x+k < width )
	      HalfShape[ q+x+k ] = half_bab[p];
      
	/*-- Put BABs to CurShape--*/
	q = y2*width2;
	for ( l=p=0; l<mbsize; l++, q+=width2 ) 
	  for ( k=0; k<mbsize; k++, p++ ) 
	    if(  y2+l < height2 && x2+k < width2 )
	      CurShape[ q+x2+k ] = curr_bab[p];
      
      }
    }

    StopArDecoder_Still (&ar_decoder);

    /*-- Memory free ---------------------------------------------------------*/

    free(lower_bab);
    free(bordered_lower_bab);
    free(half_bab);
    free(bordered_half_bab);
    free(curr_bab);
    free(bordered_curr_bab);

    return ( 0 );
}


/* Modified by shson */
Int CVTCDecoder::
ShapeEnhContentDecode(UChar *bordered_lower_bab, 
			UChar *bordered_half_bab, 
			UChar *bordered_curr_bab, 
			Int bab_type, 
			Int mbsize,
		      FILTER *filter,
			ArDecoder *ar_decoder)
{
	if (bab_type==0) /* Interleaved Scan-Line (ISL) coding */
	{
		Int scan_order = DecideScanOrder(bordered_lower_bab,mbsize); // SAIT_PDAM: ADDED by D.-S.Cho (Samsung AIT)

		ExclusiveORdecoding (bordered_lower_bab,
				     bordered_half_bab,
				     bordered_curr_bab,
				     mbsize,
					 scan_order, // SAIT_PDAM: ADDED by D.-S.Cho (Samsung AIT)
				     ar_decoder);
        
	} else if (bab_type==1){        /* Raster Scan-Line (RSL) coding */
		FullDecoding (bordered_lower_bab,
			      bordered_half_bab,
			      bordered_curr_bab,
			      mbsize,
			      filter,
			      ar_decoder);
        
	} else {
		fprintf(stderr,"BAB type ERROR !\n");
	}
		

	return ( 0 );
}

/* Interleaved Scan-Line (ISL) Decoding */
Void CVTCDecoder::
ExclusiveORdecoding (UChar *bordered_lower_bab,
			UChar *bordered_half_bab,
			UChar *bordered_curr_bab,
			Int mbsize,
			Int scan_order,	// SAIT_PDAM: ADDED by D.-S.Cho (Samsung AIT)
			ArDecoder *ar_decoder)
{
	Int		i,j,i2,j2,k,l,prev,next;

	Int		mborder = MBORDER;
	Int		mbsize_ext = mbsize+(mborder<<1);
	Int		border = BORDER;
	Int		bsize = mbsize >> 1;
	Int		bsize_ext = bsize+(border<<1);

	Int		context, prob=0;

	UChar		*lower_bab_data,*half_bab_data,
			*curr_bab_data;
	UChar	*bordered_curr_bab_tr;	// SAIT_PDAM: ADDED by D.-S.Cho (Samsung AIT)

	lower_bab_data = bordered_lower_bab + border * bsize_ext + border;
	half_bab_data= bordered_half_bab + mborder * bsize_ext + border;
	curr_bab_data= bordered_curr_bab + mborder * mbsize_ext + mborder;

	/*-- P0 pixels reconstructing --*/
        for(j=j2=0,k=l=0; j<bsize; j++, j2+=2, k+=(mbsize_ext<<1), l+=bsize_ext)
	   for(i=i2=0; i<bsize; i++, i2+=2)
		curr_bab_data[k+i2]=lower_bab_data[l+i];

	/* SAIT_PDAM BEGIN - ADDED by D.-S.Cho (Samsung AIT)  */ 
	// current BAB transposition
	if (scan_order==1) {
		bordered_curr_bab_tr = (UChar *)calloc(mbsize_ext*mbsize_ext, sizeof(UChar));
		for (j=0; j<mbsize_ext; j++)
			for (i=0; i<mbsize_ext; i++)
					bordered_curr_bab_tr[j*mbsize_ext+i] = bordered_curr_bab[i*mbsize_ext+j];
		curr_bab_data=bordered_curr_bab_tr + mborder * mbsize_ext + mborder;
	}
	/* SAIT_PDAM END - ADDED by D.-S.Cho (Samsung AIT)  */ 

	/*-- P1 pixels decoding --*/
	/* SAIT_PDAM BEGIN - MODIFIED by D.-S.Cho (Samsung AIT)  */ 
	//for(j2=k=0; j2<mbsize; j2+=2, k+=(mbsize_ext<<1) )
    //    {
	//   for(i2=1; i2<mbsize; i2+=2)
	//   {
	for(i2=1; i2<mbsize; i2+=2)
	{
		for(j2=k=0; j2<mbsize; j2+=2, k+=(mbsize_ext<<1) )
        {
	/* SAIT_PDAM END - MODIFIED by D.-S.Cho (Samsung AIT) */ 
		prev= curr_bab_data[k+i2-1];
		next= curr_bab_data[k+i2+1];
                       
		if(prev!=next) 
		{
		   context = GetContextEnhBAB_XOR(curr_bab_data,
						i2, 
						j2, 
						mbsize_ext, 
						0); /* pixel type : 0-P1, 1-P2/P3 */

		   prob=scalable_xor_prob_1[context];
		   curr_bab_data[k+i2] = ArDecodeSymbol_Still(ar_decoder, prob);

		} 
		else 
		{
		   curr_bab_data[k+i2] = prev;
		}
	   }
	}

	/*-- P2/P3 pixels decoding --*/
        for(j2=1,k=mbsize_ext; j2<mbsize; j2+=2, k+=(mbsize_ext<<1) )
        {
	for(i2=0; i2<mbsize; i2++) 
	{ 
		prev= curr_bab_data[k-mbsize_ext+i2];
		next= curr_bab_data[k+mbsize_ext+i2];
		   
		if(prev!=next) 
		{
		   context = GetContextEnhBAB_XOR(curr_bab_data,
						i2, 
						j2, 
						mbsize_ext, 
						1);	/* pixel type : 0-P1, 1-P2/P3 */
		   	
		   prob=scalable_xor_prob_23[context];
		   curr_bab_data[k+i2] = ArDecodeSymbol_Still(ar_decoder, prob);

		} 
		else 
		{
		   curr_bab_data[k+i2] = prev;
		}
	   }
	}

	/* SAIT_PDAM BEGIN - ADDED by D.-S.Cho (Samsung AIT)  */ 
	if (scan_order == 1) {
		for (j=0; j<mbsize_ext; j++)
			for (i=0; i<mbsize_ext; i++)
					bordered_curr_bab[j*mbsize_ext+i]=bordered_curr_bab_tr[i*mbsize_ext+j];
		curr_bab_data = bordered_curr_bab + mborder*mbsize_ext + mborder;
		free (bordered_curr_bab_tr);
	}
	/* SAIT_PDAM END - ADDED by D.-S.Cho (Samsung AIT)  */ 

	/* get the half resolution needed */
	for(j2=0,k=0; j2<mbsize; j2++, k+=mbsize_ext )
        {
	  for(i=0; i<bsize; i++) 
	    {
	      i2 = i<<1; /* horizontal subsampling */
	      half_bab_data[j2*bsize_ext+i] = curr_bab_data[k+i2];
	    }
	}

}

/* Raster Scan-Line (RSL) Decoding */
Void CVTCDecoder::
FullDecoding (UChar *bordered_lower_bab,
		   UChar *bordered_half_bab,
		   UChar *bordered_curr_bab,
		   Int mbsize,
		   FILTER *filter,
		   ArDecoder *ar_decoder)
{
	Int		i,j,i2,j2,k,l;

	Int		mborder = MBORDER;
	Int		mbsize_ext = mbsize+(mborder<<1);
	Int		border = BORDER;
	Int		bsize = mbsize >> 1;
	Int		bsize_ext = bsize+(border<<1);
	//Int		low_value, not_coded;
	Int		context, prob=0;
	UChar		*lower_bab_data,*half_bab_data,
			*curr_bab_data;

	lower_bab_data = bordered_lower_bab + border * bsize_ext + border;
	half_bab_data= bordered_half_bab + mborder * bsize_ext + border;
	curr_bab_data= bordered_curr_bab + mborder * mbsize_ext + mborder;
	/* vertical pass */
	/* vertical pass first for half-higher layer encoding*/
/* Should insert the precise bordering process ! */
	for(j2=k=0; j2<mbsize; j2+=2, k+=2*bsize_ext)
	{
	   for(i=0; i<bsize; i++)
	   {
	     j = j2>>1;
	     l = j*bsize_ext;
	     /* T1 */

	     context =  (half_bab_data[k-bsize_ext+i]<<7) /* T9*/
	       | ( half_bab_data[k-bsize_ext+i+1] <<6) /* T8 */
	       | (half_bab_data[k+bsize_ext+i-1] <<5) /* T7 */
	       | (half_bab_data[k+i-1] <<4) /* T6 */
	       | (lower_bab_data[l+i] <<3) /* T5 */
	       | (lower_bab_data[l+i+1] <<2) /* T4 */
	       | (lower_bab_data[l+bsize_ext+i] <<1) /* T3 */
	       | (lower_bab_data[l+bsize_ext+i+1]); /* T2 */

	     if(filter->DWT_Class==DWT_ODD_SYMMETRIC){
	       prob=prob_odd0[context];
	     } else if(filter->DWT_Class==DWT_EVEN_SYMMETRIC) {
	       prob=prob_even0[context];
	     } else {
	       fprintf(stderr,"Error: filter type in FullEncoding() !\n");
	       exit(0);
	     }
	     half_bab_data[k+i] =  ArDecodeSymbol_Still(ar_decoder, prob);

	       /* T0 */
	     context =  (half_bab_data[k+i]<<7) /* T1*/
	       | ( lower_bab_data[l+bsize_ext+i-1] <<6) /* T10 */
	       | (half_bab_data[k+bsize_ext+i-1] <<5) /* T7 */
	       | (half_bab_data[k+i-1] <<4) /* T6 */
	       | (lower_bab_data[l+i] <<3) /* T5 */
	       | (lower_bab_data[l+i+1] <<2) /* T4 */
	       | (lower_bab_data[l+bsize_ext+i] <<1) /* T3 */
	       | (lower_bab_data[l+bsize_ext+i+1]); /* T2 */

	     if(filter->DWT_Class==DWT_ODD_SYMMETRIC){
	       prob=prob_odd1[context];
	     } else if(filter->DWT_Class==DWT_EVEN_SYMMETRIC) {
	       prob=prob_even1[context];
	     } else {
	       fprintf(stderr,"Error: filter type in FullEncoding() !\n");
	       exit(0);
	     }
	     
	     half_bab_data[k+bsize_ext+i]=ArDecodeSymbol_Still(ar_decoder, prob);
	   }
	}

	/* horizontal */
	for(i2=0; i2<mbsize; i2+=2)
	  {
	    for(j=k=0; j<mbsize; j++, k+=mbsize_ext)
	      {
	   
		i = i2>>1;
		l = j*bsize_ext;
		/* T1 */
		context =  (curr_bab_data[k+i2-1]<<7) /* T9*/
		  | ( curr_bab_data[k+mbsize_ext+i2-1] <<6) /* T8 */
		  | (curr_bab_data[k-mbsize_ext+i2+1] <<5) /* T7 */
		  | (curr_bab_data[k-mbsize_ext+i2] <<4) /* T6 */
		  | (half_bab_data[l+i] <<3) /* T5 */
		  | (half_bab_data[l+bsize_ext+i] <<2) /* T4 */
		  | (half_bab_data[l+i+1] <<1) /* T3 */
		  | (half_bab_data[l+bsize_ext+i+1]); /* T2 */

		if(filter->DWT_Class==DWT_ODD_SYMMETRIC){
		  prob=prob_odd0[context];
		} else if(filter->DWT_Class==DWT_EVEN_SYMMETRIC) {
		  prob=prob_even0[context];
		} else {
		  fprintf(stderr,"Error: filter type in FullEncoding() !\n");
		  exit(0);
		}
		curr_bab_data[k+i2]=ArDecodeSymbol_Still(ar_decoder, prob);

		/* T0 */
		context =  (curr_bab_data[k+i2]<<7) /* T1*/
		  | ( half_bab_data[l-bsize_ext+i+1] <<6) /* T10 */
		  | (curr_bab_data[k-mbsize_ext+i2+1] <<5) /* T7 */
		  | (curr_bab_data[k-mbsize_ext+i2] <<4) /* T6 */
		  | (half_bab_data[l+i] <<3) /* T5 */
		  | (half_bab_data[l+bsize_ext+i] <<2) /* T4 */
		  | (half_bab_data[l+i+1] <<1) /* T3 */
		  | (half_bab_data[l+bsize_ext+i+1]); /* T2 */

		if(filter->DWT_Class==DWT_ODD_SYMMETRIC){
		  prob=prob_odd1[context];
		} else if(filter->DWT_Class==DWT_EVEN_SYMMETRIC) {
		  prob=prob_even1[context];
		} else {
		  fprintf(stderr,"Error: filter type in FullEncoding() !\n");
		  exit(0);
		}
		curr_bab_data[k+i2+1]=ArDecodeSymbol_Still(ar_decoder, prob);
	      }
	  }
}
