#!/bin/csh -f
# Prepare MS MPEG-4 reference code for compilation under Unix and Linux

# Kris Huber (khuber@sorensontech.com) 2000/05/16

# 1.  Remove extra ^M's from some of the ASCII files:
echo "1.  Removing extra ^M's from some of the ASCII files:"

if( `uname -s` == "Linux" ) then
#     This alias is for more conveniently calling dos2unix, v3.0 by
#     Benjamin Lin <blin@socs.uts.edu.au> and
#     Bernd Johannes Wuebben (mac2unix mode) <wuebben@kde.org>, 1995/03/31:
	alias d2u 'dos2unix -k \!*'
	d2u -k *.hpp
	d2u -k *.cpp
	d2u -k */*.hpp
	d2u -k */*.cpp
	d2u -k */*.h
	d2u -k */*.c
	d2u -k */*/*.hpp
	d2u -k */*/*.cpp
	d2u -k */*/*.h
	d2u -k */*/*.c
	d2u -k demo/*.ctl
	d2u -k demo/*.par
	d2u -k demo/*/*.ctl
	d2u -k demo/*/*.par
else
#     This alias is for more conveniently calling Solaris/AIX-style dos2unix:
	alias d2u 'dos2unix \!* \!*.$$; mv \!*.$$ \!*'

#     These are the files that must be changed (they contain '\' at 
#     end-of-line to continue onto next line)
	d2u type/geom.cpp
	d2u vtc/ztq/globals.hpp
	d2u vtc/main/vtcdec.cpp
	d2u vtc/main/vtcenc.cpp
	d2u vtc/zte/ac.cpp
	d2u vtc/zte/bitpack.cpp
	d2u vtc/ztq/QMUtils.cpp
	d2u vtc/ztq/quant.cpp
	d2u sys/decoder/blkdec.cpp
	d2u app/decoder/decoder.cpp
	d2u vtc/wavelet/download_filter.cpp
	d2u vtc/pezw/PEZW_ac.cpp
endif
d2u unixmake
d2u Makefile
echo "done"
echo ""

# 2.  Make a directory 'obj' for object files.
echo "2.  Making a directory 'obj' for object files."
mkdir obj
echo "done"
echo ""

# 3.  Run GNU make 3.74 or above.
echo "3.  Run GNU make 3.74 or above."
echo ""
echo "Your version of GNU make is (you need 3.74 or higher):"
echo ""
gmake --version
# On some platforms 'gmake' will be called 'make' (uncomment next line if so):
# make --version
echo ""
echo "If the above went without errors, you are almost ready to compile."
echo "  Edit Makefile to set CCFLAGS how you want (g++ 2.95 needs -fpermissive flag)"
echo "  Edit unixmake to set CFLAGS how you want (g++ 2.95 needs -fpermissive flag)"
echo "  Edit unixmake to set BINDIR how you want"
echo "  'gmake' compiles using Makefile."
echo "  'gmake -f unixmake' compiles using unixmake."

