/****************************************************************************/
/*   MPEG4 Visual Texture Coding (VTC) Mode Software                        */
/*                                                                          */
/*   This software was jointly developed by the following participants:     */
/*                                                                          */
/*   Single-quant,  multi-quant and flow control                            */
/*   are provided by  Sarnoff Corporation                                   */
/*     Iraj Sodagar   (iraj@sarnoff.com)                                    */
/*     Hung-Ju Lee    (hjlee@sarnoff.com)                                   */
/*     Paul Hatrack   (hatrack@sarnoff.com)                                 */
/*     Shipeng Li     (shipeng@sarnoff.com)                                 */
/*     Bing-Bing Chai (bchai@sarnoff.com)                                   */
/*     B.S. Srinivas  (bsrinivas@sarnoff.com)                               */
/*                                                                          */
/*   Bi-level is provided by Texas Instruments                              */
/*     Jie Liang      (liang@ti.com)                                        */
/*                                                                          */
/*   Shape Coding is provided by  OKI Electric Industry Co., Ltd.           */
/*     Zhixiong Wu    (sgo@hlabs.oki.co.jp)                                 */
/*     Yoshihiro Ueda (yueda@hlabs.oki.co.jp)                               */
/*     Toshifumi Kanamaru (kanamaru@hlabs.oki.co.jp)                        */
/*                                                                          */
/*   OKI, Sharp, Sarnoff, TI and Microsoft contributed to bitstream         */
/*   exchange and bug fixing.                                               */
/*                                                                          */
/*   Scalable Shape Coding was provided by:                                 */
/*         Shipeng Li (Sarnoff Corporation),                                */
/*         Dae-Sung Cho (Samsung AIT),					    */
/*         Se Hoon Son (Samsung AIT)	                                    */
/* In the course of development of the MPEG-4 standard, this software       */
/* module is an implementation of a part of one or more MPEG-4 tools as     */
/* specified by the MPEG-4 standard.                                        */
/*                                                                          */
/* The copyright of this software belongs to ISO/IEC. ISO/IEC gives use     */
/* of the MPEG-4 standard free license to use this  software module or      */
/* modifications thereof for hardware or software products claiming         */
/* conformance to the MPEG-4 standard.                                      */
/*                                                                          */
/* Those intending to use this software module in hardware or software      */
/* products are advised that use may infringe existing  patents. The        */
/* original developers of this software module and their companies, the     */
/* subsequent editors and their companies, and ISO/IEC have no liability    */
/* and ISO/IEC have no liability for use of this software module or         */
/* modification thereof in an implementation.                               */
/*                                                                          */
/* Permission is granted to MPEG members to use, copy, modify,              */
/* and distribute the software modules ( or portions thereof )              */
/* for standardization activity within ISO/IEC JTC1/SC29/WG11.              */
/*                                                                          */
/* Copyright 1995, 1996, 1997, 1998 ISO/IEC                                 */
/****************************************************************************/
/*****************************************************************************
 "This software module was originally developed by:
 
	Dae-Sung Cho (Samsung AIT),
	Se Hoon Son (Samsung AIT)
 
        and edited by:
 
	Dae-Sung Cho (Samsung AIT)
	Modified by Shipeng Li, Sarnoff Corporation 12/98.

        in the course of development of the <MPEG-4 Video(ISO/IEC 14496-2)>. This
  software module is an implementation of a part of one or more <MPEG-4 Video
  (ISO/IEC 14496-2)> tools as specified by the <MPEG-4 Video(ISO/IEC 14496-2)
  >. ISO/IEC gives users of the <MPEG-4 Video(ISO/IEC 14496-2)> free license
  to this software module or modifications thereof for use in hardware or
  software products claiming conformance to the <MPEG-4 Video(ISO/IEC 14496-2
  )>. Those intending to use this software module in hardware or software
  products are advised that its use may infringe existing patents. The
  original developer of this software module and his/her company, the
  subsequent editors and their companies, and ISO/IEC have no liability for
  use of this software module or modifications thereof in an implementation.
  Copyright is not released for non <MPEG-4 Video(ISO/IEC 14496-2)>
  conforming products. Samsung AIT (SAIT) retains full right to use the code
  for his/her own purpose, assign or donate the code to a third party and to
  inhibit third parties from using the code for non <MPEG-4 Video(ISO/IEC
  14496-2)> conforming products. This copyright notice must be included in
  all copies or derivative works. Copyright (c) 1997, 1998".
 *****************************************************************************/

#include <stdio.h>
#include <malloc.h>
#include <memory.h>
#include <math.h>
#include "dataStruct.hpp"
//#include "ShapeBaseCommon.h"
//#include "BinArCodec.h"
//#include "dwt.h"
#include "ShapeEnhDef.hpp"
//#include "ShapeEnhCommon.h"
//#include "ShapeEnhEncode.h"

/***********************************************************HeaderBegin*******
 *
 * File:        ShapeEnhEncode.c
 *
 * Author:      Samsung AIT
 * Created:     10-13-97
 *
 * Description: Contains functions used to implement scan interleaving
 *                               coding of spatial scalable binary alpha blocks.
 *
 * Copyright (C) 1997, 1998 Samsung AIT All Rights Reserved.                 
 *
 ***********************************************************HeaderEnd*********/


#define Error -1

Int CVTCEncoder::
ShapeEnhEnCoding(UChar *LowShape,	 /* shape mask in the lower layer */
		 UChar *HalfShape, /* shape mask in the half-higher layer */
			UChar *CurShape, /* shape mask in the current layer */
			Int object_width,  /* object_width in the current layer */
			Int object_height,/* object_height in the current layer */
			FILTER *filter)
{
    Int i, j, k, l, p, q, x, y, x2, y2;
    Int bab_type, ret;
	Int scan_order; // SAIT_PDAM : ADDED by D.-S. Cho (Samsung AIT) 

    Int width2		= object_width,
	height2		= object_height,
	width		= width2 >> 1,
	height		= height2 >> 1;
    Int NB = (object_width >= 1024 || object_height >=1024)? 6:
      (object_width >=512|| object_height >=512)?5:4;
    Int mborder		= MBORDER,
    	mblks           = NB,
	mbsize          = 1<<mblks,		/* bab size in the current layer : 16 */
	mbsize_ext      = mbsize+(mborder<<1);  /* bordered bab size in the current layer: 20 */
 
    Int border		= BORDER,
    	blks            = mblks-1,
	bsize           = 1<<blks,		/* bab size in the lower layer : 8 */
	bsize_ext       = bsize+(border<<1);	/* bordered bab size in the lower layer: 8 */
 
    Int blkx            = (object_width+mbsize-1)/mbsize,
	blky            = (object_height+mbsize-1)/mbsize;
    static int first=0;
    Int cnt_mode0=0, cnt_mode1=0, cnt_mode2=0, cnt_total=0;
    
    UInt prob;

    UChar *lower_bab;			/* alpha block in the lower layer */
    UChar *bordered_lower_bab;		/* bordered alpha block in the lower layer */

    UChar *half_bab;			/* alpha block in the half-higher layer */
    UChar *bordered_half_bab;		/* bordered alpha block in the half-higher layer */
 
    
    UChar *curr_bab;			/* alpha mb in the current layer */
    UChar *bordered_curr_bab;		/* bordered alpha mb in the current layer */

    ArCoder       ar_coder;

	ShapeBitstream=NULL;
	ShapeBitstreamLength=0;
    /*-- Memory allocation ---------------------------------------------------------*/
    lower_bab = (UChar *) calloc(bsize*bsize, sizeof(UChar));
    bordered_lower_bab = (UChar *) calloc(bsize_ext*bsize_ext, sizeof(UChar));

    half_bab = (UChar *) calloc(bsize*mbsize, sizeof(UChar));
    bordered_half_bab = (UChar *) calloc(bsize_ext*mbsize_ext, sizeof(UChar));

    curr_bab = (UChar *) calloc(mbsize*mbsize, sizeof(UChar));
    bordered_curr_bab = (UChar *) calloc(mbsize_ext*mbsize_ext, sizeof(UChar));

    /*-- Initialize the shape bitstream --------------------------------------------*/
    ShapeBitstream = (BSS *)malloc(sizeof(BSS));
    if(ShapeBitstream==NULL) {
      fprintf(stderr,"Memory allocation failed\n");
      return Error;
    }
    ShapeBitstream->bs = (UChar *)malloc(sizeof(UChar)*object_width*object_height);
    if(ShapeBitstream->bs==NULL) {
      fprintf(stderr,"Memory allocation failed\n");
      return Error;
    }

    /*-- Clear the output buffer ---------------------------------------------------*/
    memset(ShapeBitstream->bs, (UChar )0, object_width*object_height);
    InitBitstream(1,ShapeBitstream);

    /*-- Encode the Enhancement Layer ------------------------------------------------*/
/*     fprintf(stderr,"-- Encode the BAB in the enhancement layer !\n"); */

    StartArCoder_Still(&ar_coder);  

    for ( j=y=y2=0; j<blky; j++, y+=bsize, y2+=mbsize ) 
    {
      for ( i=x=x2=0; i<blkx; i++, x+=bsize, x2+=mbsize ) 
      {
	/*-- Initialize BABs --*/
	q = y2*width2;
        for ( l=p=0; l<mbsize; l++, q+=width2 ) {
          for ( k=0; k<mbsize; k++, p++ ) {
	      if( y2+l < height2 && x2+k < width2)
                curr_bab[p]= (CurShape[ q+x2+k ] != 0);
	      else
                curr_bab[p]= 0;
	  }
	}


	q = y2*width;
        for ( l=p=0; l<mbsize; l++, q+=width ) {
          for ( k=0; k<bsize; k++, p++ ) {
	      if( y2+l < height2 && x+k < width)
                half_bab[p]= (HalfShape[ q+x+k ] != 0);
	      else
                half_bab[p]= 0;
	  }
	}


	q = y*width;
	for ( l=p=0; l<bsize; l++, q+=width ) {
	  for ( k=0; k<bsize; k++, p++ ) {
              if(  y+l < height && x+k < width )
                lower_bab[p] = (LowShape[ q+x+k ] != 0);
              else
                lower_bab[p] = 0;

          }
	}

	AddBorderToBABs(LowShape, HalfShape, CurShape,
			lower_bab, half_bab, curr_bab,
			bordered_lower_bab, bordered_half_bab,
			bordered_curr_bab,
			object_width, object_height,
			i, j, mbsize, blkx);

	scan_order = DecideScanOrder(bordered_lower_bab, mbsize); // SAIT_PDAM: ADDED by D.-S.Cho (Samsung AIT) 
	
	bab_type = DecideBABtype(bordered_lower_bab, bordered_half_bab,
				 bordered_curr_bab, mbsize,
				 scan_order // SAIT_PDAM ADDED by D.-S.Cho (Samsung AIT) 
				 );
	if(filter->DWT_Class==DWT_ODD_SYMMETRIC){
	  prob=scalable_bab_type_prob[0];
	} else if(filter->DWT_Class==DWT_EVEN_SYMMETRIC) {
	  prob=scalable_bab_type_prob[1];
	} else {
	  fprintf(stderr,"Error: filter type in ShapeEnhEncoding()!\n");
	  exit(0);
	}
	ArCodeSymbol_Still(&ar_coder, ShapeBitstream, bab_type, prob);

	/* Encode mask pixel values in the enhancement layer */
	ret = ShapeEnhContentEncode(bordered_lower_bab, 
				    bordered_half_bab,
				    bordered_curr_bab, 
				    bab_type,
					scan_order, // SAIT_PDAM: ADDED by D.-S.Cho (Samsung AIT)
				    mbsize, 
				    filter,
				    ShapeBitstream,	
				    &ar_coder);
	if( ret == Error )
	{
          fprintf(stderr,"\n SI arithmetic coding Error !\n");
          return  Error;
        }
      }
    }

    StopArCoder_Still(&ar_coder,ShapeBitstream);

    ShapeBitstreamLength = ShapeBitstream -> cnt;

    /*-- Memory free ---------------------------------------------------------*/
 
    free(lower_bab);
    free(bordered_lower_bab);
    free(half_bab);
    free(bordered_half_bab);
    free(curr_bab);
    free(bordered_curr_bab);

    return ( ShapeBitstreamLength );
}

/* Modified by shson */
Int CVTCEncoder::
DecideBABtype(UChar *bordered_lower_bab, 	
	      UChar *bordered_half_bab, 
	      UChar *bordered_curr_bab, 
	      Int mbsize,
		  Int scan_order // SAIT_PDAM: ADDED by D.-S.Cho (Samsung AIT)
		  )
{
	Int	i,j,i2,j2,k,l;
	Int	mborder = MBORDER;
	Int	mbsize_ext = mbsize+(mborder<<1);
	Int	border = BORDER;
	Int	bsize = mbsize >> 1;
	Int	bsize_ext = bsize+(border<<1);

	Int	b_differ,b_except,curr,prev,next;
	Int	bab_type;

	UChar	*lower_bab_data,
		*curr_bab_data, *half_bab_data;
	UChar *curr_bab_data_tr; // SAIT_PDAM: ADDED by D.-S.Cho (Samsung AIT) 
	
	lower_bab_data = bordered_lower_bab + border * bsize_ext + border;
	curr_bab_data = bordered_curr_bab + mborder * mbsize_ext + mborder;
	half_bab_data = bordered_half_bab + mborder * bsize_ext + border;
	/* P0, P1,
	   P2, P3 */

	/* compare P0 pixels in the current layer  with the pixels in the lower layer  and half layer  */
	/* SL: we need to take care of half layer even in transitional BAB 
	   case */
	b_differ=0;
        for(j=j2=k=l=0; j<bsize; j++, j2+=2, k+=(mbsize_ext<<1),
	      l+=bsize_ext)
	{
           for(i=i2=0; i<bsize; i++, i2+=2)
	   {
		if( curr_bab_data[k+i2] != lower_bab_data[l+i] )
		{
			b_differ = 1;	/* 010 case */
			break;
		}
	   }
	   if( b_differ ) break;
	}
	/* SL added for every line*/
	if(!b_differ) {
	  for(j=k=l=0; j<bsize; j++, k+=mbsize_ext,
	        l+=bsize_ext)
	    {
	      for(i=i2=0; i<bsize; i++, i2+=2)
		{
		  if( curr_bab_data[k+i2] != half_bab_data[l+i] )
		    {
		      b_differ = 1;	/* 010 case */
		      break;
		    }
		}
	      if( b_differ ) break;
	    }
	}

	// SAIT_PDAM: BEGIN - ADDED by D.-S.Cho (Samsung AIT) 
	if (scan_order == 1) {
		curr_bab_data_tr = (UChar *)calloc(mbsize_ext*mbsize_ext, sizeof(UChar));
		for (j=0; j<mbsize_ext; j++) 
			for (i=0; i<mbsize_ext; i++)
				curr_bab_data_tr[j*mbsize_ext+i] = bordered_curr_bab[i*mbsize_ext+j];
		curr_bab_data = curr_bab_data_tr + mborder * mbsize_ext + mborder;
		// memory free ??
	}
	// SAIT_PDAM: END - ADDED by D.-S.Cho (Samsung AIT) 

	/* 000 111 110 100 001 011 and 101 cases */
	if(!b_differ) {
	   /* check wheather there are some exceptional samples or not */
	   b_except=0;
	   /* check for P1 pixel decoding */
	   for(j2=k=0; j2<mbsize; j2+=2, k+=(mbsize_ext<<1) )
	   {
	      for(i2=1; i2<mbsize; i2+=2)
              {
		prev= curr_bab_data[k+i2-1];
		curr= curr_bab_data[k+i2];
                next= curr_bab_data[k+i2+1];

		if((prev==next) && (curr!=prev)) 
		{
			b_except = 1;   	/*101 case*/
			break;
		}
	      }
	      if(b_except) break;
	   }

	   if(!b_except)
	   {
		/*-- check for P2/P3 pixel decoding --*/
		for(j2=1,k=mbsize_ext; j2<mbsize; j2+=2, k+=(mbsize_ext<<1) )
		{
		   for(i2=0; i2<mbsize; i2++)
		   {
			prev= curr_bab_data[k-mbsize_ext+i2];
			curr= curr_bab_data[k+i2]; 
			next= curr_bab_data[k+mbsize_ext+i2];
 
		        if((prev==next) && (curr!=prev)) 
			{
			   b_except = 1; 	/*101 case */
			   break;
			}
		    }
		    if(b_except) break;
		}
	   }
	} else {
	   b_except = 1;
	} 

	if(b_except)	bab_type = 1; /* full_coded */
	else		bab_type = 0; /* xor_coded (Modified SISC) */
	
	if (scan_order == 1) free(curr_bab_data_tr); // SAIT_PDAM: ADDED by D.-S.Cho (Samsung AIT)
        /* 0: XOR_coded, 1: Full_coded, 2:XOR+P0  */
	return bab_type;
}

/***********************************************************CommentBegin******
 *
 * -- ShapeEnhContentEncode -- Encodes a binary alpha block using SI.
 *
 * Author :		
 *	Dae-Sung Cho (Samsung AIT)
 *
 * Created :		
 *	09-Feb-98
 * 
 * Arguments: 	
 *
 *
 * Return values :	
 *
 * Side effects :	
 *	-
 *
 * Description :	A binary alpha block will be coded using bac.
 *			These bits are added to the <shape_stream>. 
 *
 * See also :
 *
 ***********************************************************CommentEnd********/

Int	CVTCEncoder::
ShapeEnhContentEncode(UChar *bordered_lower_bab, 
		      UChar *bordered_half_bab, 
		      UChar *bordered_curr_bab, 
			Int bab_type, 
			Int scan_order, // SAIT_PDAM: ADDED by D.-S.Cho (Samsung AIT) 
			Int mbsize,
				FILTER *filter,
			BSS *bitstream,	
			ArCoder *ar_coder)
{
	if (bab_type==0) 		/* Interleaved Scan-Line (ISL) coding */
	{  
	      ExclusiveORencoding (bordered_lower_bab,
				   bordered_half_bab,
				   bordered_curr_bab,
				   mbsize,
				   scan_order, // SAIT_PDAM: ADDED by D.-S.Cho (Samsung AIT) 
				   bitstream,
				   ar_coder);

	} else if(bab_type ==1)		/* Raster Scan-Line (RSL) coding */
	{	

	  FullEncoding (bordered_lower_bab,
			    bordered_half_bab,
			    bordered_curr_bab,
				mbsize,
			        filter,
				bitstream,
				ar_coder);
	} else 
	{
	      fprintf(stderr,"BAB type[%d] ERROR in Enhancement layer coding!\n", bab_type);
	}

        return 0;
}
	     
Void CVTCEncoder::
ExclusiveORencoding (UChar *bordered_lower_bab,
		     UChar *bordered_half_bab,
		     UChar *bordered_curr_bab,
		     Int mbsize,
			 Int scan_order, // SAIT_PDAM: ADDED by D.-S.Cho (Samsung AIT) 
		     BSS *bitstream, 
		     ArCoder *ar_coder)
{
	Int             i2,j2,k,curr,prev,next;
	Int				i,j;	// SAIT_PDAM: ADDED by D.-S.Cho (Samsung AIT) 
	Int             mborder = MBORDER;
	Int             mbsize_ext = mbsize+(mborder<<1);
	Int             border = BORDER;
	Int             bsize = mbsize >> 1;
	Int             bsize_ext = bsize+(border<<1);
	Int             context, prob=0;
	Int		start_bit, end_bit, bitnum=0;
	UChar           *lower_bab_data,
                        *curr_bab_data;
	UChar			*curr_bab_data_tr;	// SAIT_PDAM: ADDED by D.-S.Cho (Samsung AIT) 

        lower_bab_data = bordered_lower_bab + border * bsize_ext + border;
		// SAIT_PDAM: BEGIN - ADDED by D.-S.Cho (Samsung AIT) 
		if (scan_order == 1) {
			curr_bab_data_tr = (UChar *)calloc(mbsize_ext*mbsize_ext, sizeof(UChar));
			for(j=0; j<mbsize_ext; j++)
				for(i=0; i<mbsize_ext; i++)
					curr_bab_data_tr[j*mbsize_ext+i]=bordered_curr_bab[i*mbsize_ext+j];
			curr_bab_data = curr_bab_data_tr + mborder * mbsize_ext + mborder;
		} else
		// SAIT_PDAM: END - ADDED by D.-S.Cho (Samsung AIT) 
        curr_bab_data= bordered_curr_bab + mborder * mbsize_ext + mborder;

	start_bit = bitstream->cnt;


	/*-- P1 pixels encoding --*/
	// SAIT_PDAM BEGIN - MODIFIED by D.-S.Cho (Samsung AIT) 
	//for(j2=k=0; j2<mbsize; j2+=2, k+=(mbsize_ext<<1) )
    //    {
	//   for(i2=1; i2<mbsize; i2+=2)
	//   {
	   for(i2=1; i2<mbsize; i2+=2)
	   {
	for(j2=k=0; j2<mbsize; j2+=2, k+=(mbsize_ext<<1) )
        {
	// SAIT_PDAM END - MODIFIED by D.-S.Cho (Samsung AIT) 
		curr= curr_bab_data[k+i2];
		prev= curr_bab_data[k+i2-1];
		next= curr_bab_data[k+i2+1];
                       
		if(prev!=next) 
		{
		   context = GetContextEnhBAB_XOR(curr_bab_data,
					i2, 
					j2, 
					mbsize_ext, 
					0); /* pixel type : 0-P1, 1-P2/P3 */

		   prob=scalable_xor_prob_1[context];
		   ArCodeSymbol_Still(ar_coder, bitstream, curr, prob);

		} 
		else 
		{
		   if(prev!=curr)
		   {
			fprintf(stderr, "Error: BAB coding mode mismatch in XOR coding : P1!\n");
			fprintf(stderr, "Error: P1[%d,%d,%d]!\n",prev,curr,next);
			fprintf(stderr,"1, j2=%d i2=%d prev=%d curr=%d next=%d context=%d bits=%d\n", 
				j2, i2, prev, curr, next, context, bitstream->cnt);
			exit(0);
		   }
		}
	   }
	}

	/*-- P2/P3 pixel coding --*/
        for(j2=1,k=mbsize_ext; j2<mbsize; j2+=2, k+=(mbsize_ext<<1) )
        {
	   for(i2=0; i2<mbsize; i2++)
	   {
		curr= curr_bab_data[k+i2];
		prev= curr_bab_data[k-mbsize_ext+i2];	
		next= curr_bab_data[k+mbsize_ext+i2];	

		if(prev!=next) 
		{
		   context = GetContextEnhBAB_XOR(curr_bab_data,
					i2, 
					j2, 
					mbsize_ext, 
					1);	/* pixel type : 0-P1, 1-P2/P3 */

		   prob=scalable_xor_prob_23[context];
		   ArCodeSymbol_Still(ar_coder, bitstream, curr, prob);
		} 
		else 
		{
		   if(prev!=curr)
		   {
			fprintf(stderr, "Error: BAB coding mode mismatch in XOR coding : P2, P3!\n");
			exit(0);
		   }
		}
	   }
	}

	if(scan_order==1) free(curr_bab_data_tr); // SAIT_PDAM: ADDED by D.-S.Cho (Samsung AIT) 
	end_bit = bitstream->cnt;
	bitnum = end_bit - start_bit;

}

/* Modified by shson */
Void CVTCEncoder::
FullEncoding (UChar *bordered_lower_bab,
	      UChar *bordered_half_bab,
	      UChar *bordered_curr_bab,
	      Int mbsize,
				FILTER *filter,
			BSS *bitstream, 
			ArCoder *ar_coder)
{
	Int		i,j,i2,j2,k,l,curr;

	Int		mborder = MBORDER;
	Int		mbsize_ext = mbsize+(mborder<<1);
	Int		border = BORDER;
	Int		bsize = mbsize >> 1;
	Int		bsize_ext = bsize+(border<<1);
//	Int		not_coded, low_value;
	Int		context, prob=0;
	Int		start_bit, end_bit, bitnum=0;

	UChar		*lower_bab_data,
	  *half_bab_data,			
	  *curr_bab_data;

	lower_bab_data = bordered_lower_bab + border * bsize_ext + border;
	half_bab_data= bordered_half_bab + mborder * bsize_ext + border;
	curr_bab_data= bordered_curr_bab + mborder * mbsize_ext + mborder;

	start_bit = bitstream->cnt;
	/* vertical pass first for half-higher layer encoding*/

	for(j2=k=0; j2<mbsize; j2+=2, k+=2*bsize_ext)
	{
	   for(i=0; i<bsize; i++)
	   {
	     j = j2>>1;
	     l = j*bsize_ext;

	     /* T1 */
	     curr = half_bab_data[k+i];
	     context =  (half_bab_data[k-bsize_ext+i]<<7) /* T9*/
	       | ( half_bab_data[k-bsize_ext+i+1] <<6) /* T8 */
	       | (half_bab_data[k+bsize_ext+i-1] <<5) /* T7 */
	       | (half_bab_data[k+i-1] <<4) /* T6 */
	       | (lower_bab_data[l+i] <<3) /* T5 */
	       | (lower_bab_data[l+i+1] <<2) /* T4 */
	       | (lower_bab_data[l+bsize_ext+i] <<1) /* T3 */
	       | (lower_bab_data[l+bsize_ext+i+1]); /* T2 */

	     if(filter->DWT_Class==DWT_ODD_SYMMETRIC){
	       prob=prob_odd0[context];
	     } else if(filter->DWT_Class==DWT_EVEN_SYMMETRIC) {
	       prob=prob_even0[context];
	     } else {
	       fprintf(stderr,"Error: filter type in FullEncoding() !\n");
	       exit(0);
	     }
	     ArCodeSymbol_Still(ar_coder, bitstream, curr, prob);

	       /* T0 */
	     curr = half_bab_data[k+bsize_ext+i];
	     context =  (half_bab_data[k+i]<<7) /* T1*/
	       | ( lower_bab_data[l+bsize_ext+i-1] <<6) /* T10 */
	       | (half_bab_data[k+bsize_ext+i-1] <<5) /* T7 */
	       | (half_bab_data[k+i-1] <<4) /* T6 */
	       | (lower_bab_data[l+i] <<3) /* T5 */
	       | (lower_bab_data[l+i+1] <<2) /* T4 */
	       | (lower_bab_data[l+bsize_ext+i] <<1) /* T3 */
	       | (lower_bab_data[l+bsize_ext+i+1]); /* T2 */

	     if(filter->DWT_Class==DWT_ODD_SYMMETRIC){
	       prob=prob_odd1[context];
	     } else if(filter->DWT_Class==DWT_EVEN_SYMMETRIC) {
	       prob=prob_even1[context];
	     } else {
	       fprintf(stderr,"Error: filter type in FullEncoding() !\n");
	       exit(0);
	     }
	     ArCodeSymbol_Still(ar_coder, bitstream, curr, prob);
	   }
	}

	/* horizontal */
	for(i2=0; i2<mbsize; i2+=2)
	  {
	    for(j=k=0; j<mbsize; j++, k+=mbsize_ext)
	      {
	   
		i = i2>>1;
		l = j*bsize_ext;
		/* T1 */
		curr = curr_bab_data[k+i2];
		context =  (curr_bab_data[k+i2-1]<<7) /* T9*/
		  | ( curr_bab_data[k+mbsize_ext+i2-1] <<6) /* T8 */
		  | (curr_bab_data[k-mbsize_ext+i2+1] <<5) /* T7 */
		  | (curr_bab_data[k-mbsize_ext+i2] <<4) /* T6 */
		  | (half_bab_data[l+i] <<3) /* T5 */
		  | (half_bab_data[l+bsize_ext+i] <<2) /* T4 */
		  | (half_bab_data[l+i+1] <<1) /* T3 */
		  | (half_bab_data[l+bsize_ext+i+1]); /* T2 */

		if(filter->DWT_Class==DWT_ODD_SYMMETRIC){
		  prob=prob_odd0[context];
		} else if(filter->DWT_Class==DWT_EVEN_SYMMETRIC) {
		  prob=prob_even0[context];
		} else {
		  fprintf(stderr,"Error: filter type in FullEncoding() !\n");
		  exit(0);
		}
		ArCodeSymbol_Still(ar_coder, bitstream, curr, prob);
		/* T0 */
		curr = curr_bab_data[k+i2+1];
		context =  (curr_bab_data[k+i2]<<7) /* T1*/
		  | ( half_bab_data[l-bsize_ext+i+1] <<6) /* T10 */
		  | (curr_bab_data[k-mbsize_ext+i2+1] <<5) /* T7 */
		  | (curr_bab_data[k-mbsize_ext+i2] <<4) /* T6 */
		  | (half_bab_data[l+i] <<3) /* T5 */
		  | (half_bab_data[l+bsize_ext+i] <<2) /* T4 */
		  | (half_bab_data[l+i+1] <<1) /* T3 */
		  | (half_bab_data[l+bsize_ext+i+1]); /* T2 */

		if(filter->DWT_Class==DWT_ODD_SYMMETRIC){
		  prob=prob_odd1[context];
		} else if(filter->DWT_Class==DWT_EVEN_SYMMETRIC) {
		  prob=prob_even1[context];
		} else {
		  fprintf(stderr,"Error: filter type in FullEncoding() !\n");
		  exit(0);
		}
		ArCodeSymbol_Still(ar_coder, bitstream, curr, prob);
	      }
	  }

	end_bit = bitstream->cnt;
	bitnum = end_bit - start_bit;

}

/*********************************************************************************
 *
 *      Bitstream Manipulation  
 *
*********************************************************************************/
/* Merge Shape Bitstream into main bit stream */
Void CVTCEncoder::
MergeEnhShapeBitstream()
{
  if(ShapeBitstream==NULL) {
    fprintf(stderr,"EnhShapeBitStream Not Available\n");
    exit(1);
  }
  InitBitstream(0,ShapeBitstream);
  BitStreamMerge(ShapeBitstreamLength, ShapeBitstream);
 
  free(ShapeBitstream->bs);
  free(ShapeBitstream);
  ShapeBitstream = NULL;
}
 
