/************************************************************************
 *
 *  coder.c, main coding engine of tmn (TMN encoder)
 *
 *  Copyright (C) 1997  University of BC, Canada
 *
 *  Contacts: 
 *  Michael Gallant                   <mikeg@ee.ubc.ca>
 *  Guy Cote                          <guyc@ee.ubc.ca>
 *  Berna Erol                        <bernae@ee.ubc.ca>
 *
 *  UBC Image Processing Laboratory   http://www.ee.ubc.ca/image
 *  2356 Main Mall                    tel.: +1 604 822 4051
 *  Vancouver BC Canada V6T1Z4        fax.: +1 604 822 5949
 *
 *  Copyright (C) 1995, 1996  Telenor R&D, Norway
 *  
 *  Contacts: 
 *  Robert Danielsen                  <Robert.Danielsen@nta.no>
 *
 *  Telenor Research and Development  http://www.nta.no/brukere/DVC/
 *  P.O.Box 83                        tel.:   +47 63 84 84 00
 *  N-2007 Kjeller, Norway            fax.:   +47 63 81 00 76
 *  
 ************************************************************************/

/*
 * Disclaimer of Warranty
 *
 * These software programs are available to the user without any
 * license fee or royalty on an "as is" basis. The University of
 * British Columbia disclaims any and all warranties, whether
 * express, implied, or statuary, including any implied warranties
 * or merchantability or of fitness for a particular purpose.  In no
 * event shall the copyright-holder be liable for any incidental,
 * punitive, or consequential damages of any kind whatsoever arising
 * from the use of these programs.
 *
 * This disclaimer of warranty extends to the user of these programs
 * and user's customers, employees, agents, transferees, successors,
 * and assigns.
 *
 * The University of British Columbia does not represent or warrant
 * that the programs furnished hereunder are free of infringement of
 * any third-party patents.
 *
 * Commercial implementations of H.263, including shareware, are
 * subject to royalty fees to patent holders.  Many of these patents
 * are general enough such that they are unavoidable regardless of
 * implementation design.
 *
*/


/*****************************************************************
 *
 * Modified by Pat Mulroy, BT Labs to run syntax based arithmetic
 * coding.  SAC option, H.263 (Annex E).
 *
 *****************************************************************/


#include"sim.h"

/**********************************************************************
 *
 *	Name:        CodeOneIntra
 *	Description:	codes one image intra
 *	
 *	Input:        pointer to image, QP
 *        
 *	Returns:	pointer to reconstructed image
 *	Side effects:	memory is allocated to recon image
 *
 *	Date: 940110	Author:	Karl.Lillevold@nta.no
 *
 ***********************************************************************/


PictImage *CodeOneIntra(PictImage *curr, int QP, Bits *bits, Pict *pic)
{
  PictImage *recon;
  MB_Structure *data = (MB_Structure *)malloc(sizeof(MB_Structure));
  int *qcoeff, *pcoeff, *rcoeff, *coeff;
  int Mode = MODE_INTRA;
  int CBP,COD;
  int i,j,k;
  int *store_coeff, *store_rcoeff; /* used to do prediction in advanced intra coding */
  int newgob = 0;

  pic ->Intra_Mode = 0;
  recon = InitImage(pels*lines);
  ZeroBits(bits);
  pic->QUANT = QP;
  
  if (EPTYPE)
     pic->UFEP = ON;   /* Update full extended PTYPE is set for Intra pictures */
  if (advanced_intra_coding)
  {
     pic->UFEP = ON;   /* Update full extended PTYPE is set for Intra pictures */
     /* store the qcoeff for the frame */
     if ((store_rcoeff=(int *)malloc(sizeof(int)*384*(pels/MB_SIZE)*
          (lines/MB_SIZE))) == 0) 
     {
        fprintf(stderr,"coder(): Couldn't allocate store_rcoeff.\n");
        exit(-1);
     }
     if ((store_coeff=(int *)malloc(sizeof(int)*384*(pels/MB_SIZE)*
          (lines/MB_SIZE))) == 0) 
     {
        fprintf(stderr,"coder(): Couldn't allocate store_coeff.\n");
        exit(-1);
     }
     if ((pcoeff=(int *)malloc(sizeof(int)*384)) == 0) 
     {
        fprintf(stderr,"coder(): Couldn't allocate pcoeff.\n");
        exit(-1);
     }
  } 
  if ((qcoeff=(int *)malloc(sizeof(int)*384)) == 0) {
    fprintf(stderr,"coder(): Couldn't allocate qcoeff.\n");
    exit(-1);
  }
  if ((rcoeff = (int *)malloc(sizeof(int)*384)) == NULL) {
    fprintf(stderr,"coder: Could not allocate space for rcoeff\n");
    exit(-1);
  } 

  bits->header += CountBitsPicture(pic);

  COD = 0; /* Every block is coded in Intra frame */
  for ( j = 0; j < lines/MB_SIZE; j++) {

    /* insert sync in *every* GOB if use_gobsync is chosen */
    if (pic->use_gobsync && j != 0)
    {
      bits->header += CountBitsGOB(j,QP,pic);
      newgob = 1;
    }
    for ( i = 0; i < pels/MB_SIZE; i++) {

      pic->MB = i + j * (pels/MB_SIZE);
      bits->no_intra++;
      FillLumBlock(i*MB_SIZE, j*MB_SIZE, curr, data);
      FillChromBlock(i*MB_SIZE, j*MB_SIZE, curr, data);

      coeff = MB_Encode(data);
      /* store the QP for every macroblock */
      quant_map[j+1][i+1] = QP;
      
      if (advanced_intra_coding) 
      {
          /* store the DCT coefficients for encoding */
          memcpy( (void *) (store_coeff + (i + j*pels/MB_SIZE)*384), (void *) coeff, sizeof(int) * 384);
          /* Do Intra mode prediction */
          pic->Intra_Mode = Choose_Intra_Mode(coeff, store_coeff, i, j, newgob);
          for (k=0;k<6;k++) 
          {
          
            Intra_AC_DC_Encode(coeff, store_rcoeff, pic->Intra_Mode, i, j, newgob,k);
            Quant_blk(coeff,pcoeff,QP,Mode,k);
            Dequant(pcoeff, rcoeff, QP, Mode,k);
            Intra_AC_DC_Decode(rcoeff, store_rcoeff, pic->Intra_Mode, i, j, newgob,k);
          }
          MB_Decode(rcoeff, data);
          Scan(pcoeff, pic->Intra_Mode); 
          CBP = FindCBP(pcoeff,Mode,64);
          if (!syntax_arith_coding) 
          {
            CountBitsMB(Mode,COD,CBP,0,pic,bits,0);
            CountBitsCoeff(pcoeff, Mode, CBP,bits,64);
          } 
          else 
          {
            Count_sac_BitsMB(Mode,COD,CBP,0,pic,bits);
            Count_sac_BitsCoeff(pcoeff, Mode, CBP,bits,64);
          }
      }
      else
      {
          for (k=0;k<6;k++)
            Quant_blk(coeff,qcoeff,QP,Mode,k);
          Scan(qcoeff,0);
          CBP = FindCBP(qcoeff,Mode,64);
          if (!syntax_arith_coding) 
          {
            CountBitsMB(Mode,COD,CBP,0,pic,bits,0);
            CountBitsCoeff(qcoeff, Mode, CBP,bits,64);
          } 
          else 
          {
            Count_sac_BitsMB(Mode,COD,CBP,0,pic,bits);
            Count_sac_BitsCoeff(qcoeff, Mode, CBP,bits,64);
          }
          DeScan(qcoeff,0);
          for (k=0;k<6;k++)
            Dequant(qcoeff, rcoeff, QP, Mode,k);
          MB_Decode(rcoeff, data);
      }
      Clip(data);
      ReconImage(i,j,data,recon);

      /* every block is coded */     
      coded_map[j+1][i+1] = 2;
      /* Initialize the intra_mb_refresh rate randomly after I-frame */
      if (intra_mb_refresh)
        intra_refresh[j+1][i+1] = (rand()%(intra_mb_refresh+1));
       free(coeff);      
    }
  }
  pic->QP_mean = (float)QP;
  
  if (deblocking_filter) {
    EdgeFilter(recon,pic);
  }

  if (advanced_intra_coding)
  {
    free(store_coeff);
    free(store_rcoeff);
    free(pcoeff);
  }
  free(qcoeff);
  free(data);
  free(rcoeff);
  return recon;
}

