/************************************************************************
 *
 *  ring_buf.c, Buffer functions used for Reference Picture Section Mode.
 *
 *  Copyright (C) 1997  University of BC, Canada
 *
 *  Contacts: 
 *  Guy Cote                          <guyc@ee.ubc.ca>
 *  Michael Gallant                   <mikeg@ee.ubc.ca>
 *  Berna Erol                        <bernae@ee.ubc.ca>
 *
 *  UBC Image Processing Laboratory   http://www.ee.ubc.ca/image
 *  2356 Main Mall                    tel.: +1 604 822 4051
 *  Vancouver BC Canada V6T1Z4        fax.: +1 604 822 5949
 *
 ************************************************************************/

/*
 * Disclaimer of Warranty
 *
 * These software programs are available to the user without any
 * license fee or royalty on an "as is" basis. The University of
 * British Columbia disclaims any and all warranties, whether
 * express, implied, or statuary, including any implied warranties
 * or merchantability or of fitness for a particular purpose.  In no
 * event shall the copyright-holder be liable for any incidental,
 * punitive, or consequential damages of any kind whatsoever arising
 * from the use of these programs.
 *
 * This disclaimer of warranty extends to the user of these programs
 * and user's customers, employees, agents, transferees, successors,
 * and assigns.
 *
 * The University of British Columbia does not represent or warrant
 * that the programs furnished hereunder are free of infringement of
 * any third-party patents.
 *
 * Commercial implementations of H.263, including shareware, are
 * subject to royalty fees to patent holders.  Many of these patents
 * are general enough such that they are unavoidable regardless of
 * implementation design.
 *
*/

#include <stdlib.h>
#include <string.h>
#include "config.h"
#include "tmndec.h"
#include "global.h"

#define RING_SIZE 8

int  get_reference_picture(void);
void store_picture(int quality);
int get_reference_gob(void);
void store_gob(int quality);

int   ring_pointer;                           /* pointer to last picture        */
void  *ring_lum[RING_SIZE];                   /* Ring buffer                    */
void  *ring_Cr[RING_SIZE];
void  *ring_Cb[RING_SIZE];
int   ring_temporal_reference[RING_SIZE];     /* TR values for the pictures     */
int   ring_quality[RING_SIZE];                /* Picture Quality                */  


/**********************************************************************
 *
 *	Name:         get_reference_picture
 *	Description:  gets the requested prediction picture from
 *                the ring buffer.
 *	
 *	Input:        tr, orig, recon
 *        
 *	Returns:      0
 *	Side effects: 
 *
 *	Date: 980610  Author: Guy Cote <guyc@ece.ubc.ca>
 *
 ***********************************************************************/
int get_reference_picture(void)
{
  int i,diff_tr;
  
  if (!TRPI) 
  {
    if (!quiet)
      fprintf(stderr,"getrefpic: TR=%d - I-frame\n",temp_ref);
    return 0;
  }
  for (i = ring_pointer; i != (ring_pointer+1)%RING_SIZE;
	 i = (i+RING_SIZE-1)%RING_SIZE) 
   {
     diff_tr =  temporal_reference_for_prediction - ring_temporal_reference[i];
     if (diff_tr > 128)  diff_tr -= 256;
     if (diff_tr < -128) diff_tr += 256;
     if (diff_tr >= 0)  break;
   }
   if (ring_temporal_reference[ring_pointer] == temp_ref &&
     ring_quality[i]+diff_tr >= ring_quality[ring_pointer]) 
   {
     return -1; /* don't decode this sync frame (redundant) */
   }
   if (ring_lum[i]) 
   {
     memcpy(prev_I_P_frame[0],ring_lum[i], coded_picture_height*coded_picture_width);
     memcpy(prev_I_P_frame[1],ring_Cr[i], coded_picture_height*coded_picture_width/4);
     memcpy(prev_I_P_frame[2],ring_Cb[i], coded_picture_height*coded_picture_width/4);
   }
   if (diff_tr && !quiet)
     fprintf(stderr,"getrefpic: TR=%d, TRP=%d, available %d, q=%d+%d\n",
     temp_ref,temporal_reference_for_prediction,
     ring_temporal_reference[i],ring_quality[i],diff_tr);
   return ring_quality[i]+diff_tr;
   
}
/**********************************************************************
 *
 *	Name:         store_picture
 *	Description:  Stores a picture into the ring buffer.                  
 *	
 *	Input:        tr, orig, recon
 *        
 *	Returns:      0
 *	Side effects: 
 *
 *	Date: 980610  Author: Guy Cote <guyc@ece.ubc.ca>
 *
 ***********************************************************************/

void store_picture(int quality)
{
  ring_pointer = (ring_pointer+1)%RING_SIZE;
  if (!ring_lum[ring_pointer]) {
    ring_lum[ring_pointer] = malloc(coded_picture_height*coded_picture_width);
    ring_Cr[ring_pointer]  = malloc(coded_picture_height*coded_picture_width/4);
    ring_Cb[ring_pointer]  = malloc(coded_picture_height*coded_picture_width/4);
  }
  memcpy(ring_lum[ring_pointer],current_frame[0], coded_picture_height*coded_picture_width);
  memcpy(ring_Cr[ring_pointer],current_frame[1], coded_picture_height*coded_picture_width/4);
  memcpy(ring_Cb[ring_pointer],current_frame[2], coded_picture_height*coded_picture_width/4);
  ring_temporal_reference[ring_pointer] = temp_ref;
  ring_quality[ring_pointer] = quality;
}



/**********************************************************************
 *
 *	Name:         get_reference_gob
 *	Description:  gets the requested prediction gob from
 *                the ring buffer.
 *	
 *	Input:        tr, orig, recon
 *        
 *	Returns:      0
 *	Side effects: 
 *
 *	Date: 980610  Author: Guy Cote <guyc@ece.ubc.ca>
 *
 ***********************************************************************/

int get_reference_gob(void)
{
}

/**********************************************************************
 *
 *	Name:         store_gob
 *	Description:  Stores a gob into the ring buffer.                  
 *	
 *	Input:        tr, orig, recon
 *        
 *	Returns:      0
 *	Side effects: 
 *
 *	Date: 980610  Author: Guy Cote <guyc@ece.ubc.ca>
 *
 ***********************************************************************/

void store_gob(int quality)
{
}


