/*****************************************************************************
 *                                                                          
 * This software module was originally developed by 
 *
 * J. Ignacio Ronda (UPM-GTI / ACTS-MoMuSys)
 *                                                      
 * and edited by                                        
 *                                                      
 * Martina Eckert (UPM-GTI / ACTS-MoMuSys)
 *
 * in the course of development of the MPEG-4 Video (ISO/IEC 14496-2) standard.
 * This software module is an implementation of a part of one or more MPEG-4 
 * Video (ISO/IEC 14496-2) tools as specified by the MPEG-4 Video (ISO/IEC 
 * 14496-2) standard. 
 *
 * ISO/IEC gives users of the MPEG-4 Video (ISO/IEC 14496-2) standard free 
 * license to this software module or modifications thereof for use in hardware
 * or software products claiming conformance to the MPEG-4 Video (ISO/IEC 
 * 14496-2) standard. 
 *
 * Those intending to use this software module in hardware or software products
 * are advised that its use may infringe existing patents. The original 
 * developer of this software module and his/her company, the subsequent 
 * editors and their companies, and ISO/IEC have no liability for use of this 
 * software module or modifications thereof in an implementation. Copyright is 
 * not released for non MPEG-4 Video (ISO/IEC 14496-2) Standard conforming 
 * products. 
 *
 * ACTS-MoMuSys partners retain full right to use the code for his/her own 
 * purpose, assign or donate the code to a third party and to inhibit third 
 * parties from using the code for non MPEG-4 Video (ISO/IEC 14496-2) Standard
 * conforming products. This copyright notice must be included in all copies or
 * derivative works. 
 *
 * Copyright (c) 1997
 *
 *****************************************************************************/


/***********************************************************HeaderBegin*******
 *                                                                         
 * File:        rc_total_bits_upm.c
 *
 * Author:      J. Ignacio Ronda, UPM-GTI
 *
 * Created:     18-06-97
 *                                                                         
 * Description: Functions to decide the total number of bits for the next frame
 *
 * Flags:       -D_RC_DEBUG_  -  RC debugging   
 *
 * Modified:
 *      13.11.97  Martina Eckert: Headers, comments, cleaning
 *
 ***********************************************************HeaderEnd*********/

/************************    INCLUDE FILES    ********************************/

#include "momusys.h"
#include "rc.h"

/***********************************************************CommentBegin******
 *
 * -- rc_total_bits_init_upm --
 *
 * Author : 
 *      J. Ignacio Ronda, UPM-GTI     
 *
 * Created :            
 *      18-06-97
 *
 * Purpose :
 *      Initialization, to be called once at the beginning
 *
 * Arguments in :       
 *      RC_TB_PARS *pars        -  Parameter struct
 *      Double      bits_frame  -  Bits per frame 
 *      Int         buffer_size -  Buffer size 
 *
 * Modified : 
 *
 *
 ***********************************************************CommentEnd********/

void rc_total_bits_init_upm(
                            RC_TB_PARS *pars,
                            Int         bits_frame, /* Bits per frame */
                            Int         buffer_size /* Buffer size */
                            )
{
   pars->bits_frame   = bits_frame;
   pars->buffer_size  = buffer_size;
   pars->target_level = buffer_size/2;
   pars->N = 10;
}

/***********************************************************CommentBegin******
 *
 * -- rc_total_bits_upm --
 *
 * Author : 
 *      J. Ignacio Ronda, UPM-GTI     
 *
 * Created :            
 *      18-06-97
 *
 * Purpose :
 *      Calculation of total bits available for next coding (target)
 *
 * Arguments in :       
 *      RC_TB_PARS *pars         -  Parameter struct
 *      VOConfig   *vo_list      -  List of VOs
 *      Int         buffer_occup -  Buffer occupancy
 *
 * Return values :      
 *      Int         target       -  new target bit rate
 *
 * Modified : 
 *  21.01.99  M. Eckert: Passing frame_type
 *
 *
 ***********************************************************CommentEnd********/

Int rc_total_bits_upm(
                      RC_TB_PARS *pars,
                      VOConfig   *vo_list,
                      Int         buffer_occup, /* Buffer occupancy */
                      Int         frame_type
                      )
{
  RC_UPM_DATA *rcd;
  Int i, vo_i, vol_i, actual_frame_type;
  VOConfig  *vo_config;
  VolConfig *vol_config;
  Double target_bits, bits_frame;
  Double sum_meanB=0, sum_meanB_tot_pond=0;
  Float   next_coding_time, end_time; /* meb 04.08.99 */
   
  vo_config = vo_list;

  /* Independent I,B,P control :*/

  /* for all actual VOs: (while loop)*/

   while (vo_config != NULL)
   {
     vo_i = GetVOConfigId(vo_config);
     vol_config = GetVOConfigLayers(vo_config);
     while (vol_config != NULL)
     {
       /* meb 04.08.99: */
       next_coding_time = GetVolConfigNextCodingTime(vol_config);
       end_time = GetVolConfigEndTime(vol_config);
       if(next_coding_time <= end_time) /* VO in process */
       {
	 vol_i = GetVolConfigId(vol_config);
	 rcd = get_rcd(vo_i, vol_i);

         for (i=0; i<3; i++)
         {
           sum_meanB_tot_pond += rcd_get_propC(rcd, i) * rcd_get_meanB(rcd, i);
#ifdef _RC_DEBUG_
           printf("%d: propC= %f, meanB=%f \n",i,rcd_get_propC(rcd, i),rcd_get_meanB(rcd, i) );
           printf("Sum of all meanB pond = %f \n",sum_meanB_tot_pond);
#endif
	 }

         actual_frame_type = rc_get_ActFrameType(vol_config, rcd_get_total_frames(rcd));

         sum_meanB += rcd_get_meanB(rcd, frame_type);
#ifdef _RC_DEBUG_
	 /*         
         printf("Sum of meanB = %f (%d:%d) \n",sum_meanB, frame_type, actual_frame_type);
	 */
#endif
       }
       vol_config = GetVolConfigNext(vol_config);
     }
     vo_config = GetVOConfigNext(vo_config);
   }


  bits_frame = pars->bits_frame * (sum_meanB / sum_meanB_tot_pond);

#ifdef _RC_DEBUG_
  /*
    printf("bits_frame = %f \n",bits_frame);
  */
#endif
  target_bits = (pars->target_level - buffer_occup) / pars->N + bits_frame;


#if _RC_DEBUG_
   WRITE_INT("Rt_script",(Int) target_bits);
#endif

  return (Int)target_bits;

}

/*********************************************************** End of file ***/
