/*****************************************************************************
 *                                                                          
 * This software module was originally developed by 
 *
 * J. Ignacio Ronda (UPM-GTI / ACTS-MoMuSys)
 *                                                      
 * and edited by                                        
 *                                                      
 * Martina Eckert (UPM-GTI / ACTS-MoMuSys)
 *
 * in the course of development of the MPEG-4 Video (ISO/IEC 14496-2) standard.
 * This software module is an implementation of a part of one or more MPEG-4 
 * Video (ISO/IEC 14496-2) tools as specified by the MPEG-4 Video (ISO/IEC 
 * 14496-2) standard. 
 *
 * ISO/IEC gives users of the MPEG-4 Video (ISO/IEC 14496-2) standard free 
 * license to this software module or modifications thereof for use in hardware
 * or software products claiming conformance to the MPEG-4 Video (ISO/IEC 
 * 14496-2) standard. 
 *
 * Those intending to use this software module in hardware or software products
 * are advised that its use may infringe existing patents. The original 
 * developer of this software module and his/her company, the subsequent 
 * editors and their companies, and ISO/IEC have no liability for use of this 
 * software module or modifications thereof in an implementation. Copyright is 
 * not released for non MPEG-4 Video (ISO/IEC 14496-2) Standard conforming 
 * products. 
 *
 * ACTS-MoMuSys partners retain full right to use the code for his/her own 
 * purpose, assign or donate the code to a third party and to inhibit third 
 * parties from using the code for non MPEG-4 Video (ISO/IEC 14496-2) Standard
 * conforming products. This copyright notice must be included in all copies or
 * derivative works. 
 *
 * Copyright (c) 1997
 *
 *****************************************************************************/


/***********************************************************HeaderBegin*******
 *                                                                         
 * File:        rc_buffer.c
 *
 * Author:      J. I. Ronda, UPM-GTI
 *
 * Created:     04-07-97
 *                                                                         
 * Description: Buffer control functions 
 *
 * Notes:       Data type BUFFER to simulate the channel adaptation buffer
 *
 * Flags:       -D_RC_DEBUG_  -  RC debugging   
 *
 * Modified:
 *      12.11.97 Martina Eckert: Headers, comments, cleaning
 *                                 
 ***********************************************************HeaderEnd*********/

/************************    INCLUDE FILES    ********************************/

#include <stdlib.h>
#include <stdio.h>
#include "momusys.h"

#include "rc.h"

static Int count_frames;

/***********************************************************CommentBegin******
 *
 * -- buffer_init --
 *
 * Author : 
 *      J. Ignacio Ronda, UPM-GTI     
 *
 * Created :            
 *      18-06-97
 *
 * Purpose :
 *      Initializes buffer.
 *      To be called once at the beginning. Only one buffer for all the VOs
 *
 * Arguments in :       
 *      BUFFER    *buffer        -  channel buffer 
 *      Int       size           -  Buffer size
 *      Int       init_occup     -  Initial occupancy
 *      Int       frame_bit_rate -  Bit rate per frame
 *
 * Modified : 
 *
 *
 ***********************************************************CommentEnd********/

void buffer_init(
                 BUFFER *buffer,
                 Int     size,           /* Buffer size */
                 Int     init_occup,     /* Initial occupancy */
                 Int     frame_bit_rate  /* Bit rate per frame */
                )
{
   buffer->size = size;
   buffer->occup = init_occup;
   buffer->frame_bit_rate = frame_bit_rate;
}

/***********************************************************CommentBegin******
 *
 * -- buffer_put --
 *
 * Author : 
 *      J. Ignacio Ronda, UPM-GTI     
 *
 * Created :            
 *      18-06-97
 *
 * Purpose :
 *      Actualization of buffer.
 *      To be called after all VOPs of a frame have been encoded
 *
 * Arguments in :       
 *      BUFFER    *buffer        -  channel buffer 
 *      Int       num_bits       -  number of bits to introduce in buffer
 *
 * Modified : 
 *
 *
 ***********************************************************CommentEnd********/

void buffer_put(
                BUFFER *buffer,
                Int     num_bits /* TOTAL number of bits */
               )
{

 Int new_occup = buffer->occup + num_bits - buffer->frame_bit_rate;

   if (new_occup > buffer->size)
     {
#ifdef _RC_DEBUG_
     fprintf(stdout, "buffer_put: Warning: buffer overflow\n");
#endif
     new_occup = buffer->size;
     }
   else if (new_occup < 0)
     {
#ifdef _RC_DEBUG_
     fprintf(stdout, "buffer_put: Warning: buffer underflow\n");
#endif
     new_occup = 0;
     }

#ifdef _RC_DEBUG_
     fprintf(stdout, ">>>>> Buffer occupancy: %d \n",new_occup);
#endif 
     buffer->occup = new_occup;

#ifdef _RC_DEBUG_
     WRITE_INT("buffer_script", buffer->occup);
#endif

     count_frames++; /* Intern frame counter */


}


Int get_num_frames()
{

  return count_frames;
}
/*********************************************************** End of file ***/
