/******************************************************************************
 *                                                                          
 * This software module was originally developed by 
 *
 * Robert Danielsen (Telenor / ACTS-MoMuSys). 	    	              	
 *
 * and edited by 
 *
 * Minhua Zhou (HHI / ACTS-MoMuSys).   	  	 	              	
 * Luis Ducla-Soares (IST / ACTS-MoMuSys).     	           	   	
 *
 * in the course of development of the MPEG-4 Video (ISO/IEC 14496-2) standard.
 * This software module is an implementation of a part of one or more MPEG-4 
 * Video (ISO/IEC 14496-2) tools as specified by the MPEG-4 Video (ISO/IEC 
 * 14496-2) standard. 
 *
 * ISO/IEC gives users of the MPEG-4 Video (ISO/IEC 14496-2) standard free 
 * license to this software module or modifications thereof for use in hardware
 * or software products claiming conformance to the MPEG-4 Video (ISO/IEC 
 * 14496-2) standard. 
 *
 * Those intending to use this software module in hardware or software products
 * are advised that its use may infringe existing patents. The original 
 * developer of this software module and his/her company, the subsequent 
 * editors and their companies, and ISO/IEC have no liability for use of this 
 * software module or modifications thereof in an implementation. Copyright is 
 * not released for non MPEG-4 Video (ISO/IEC 14496-2) standard conforming 
 * products. 
 *
 * ACTS-MoMuSys partners retain full right to use the code for his/her own 
 * purpose, assign or donate the code to a third party and to inhibit third 
 * parties from using the code for non MPEG-4 Video (ISO/IEC 14496-2) standard
 * conforming products. This copyright notice must be included in all copies or
 * derivative works. 
 *
 * Copyright (c) 1997
 *
 *****************************************************************************/


/***********************************************************HeaderBegin*******
 *                                                                         
 * File:	vlc.h
 *
 * Author:	Robert Danielsen
 * Created:	07.06.96
 *                                                                         
 * Description: vlc tables for encoder
 *
 * Notes: 	Idea taken from MPEG-2 software simulation group
 *
 * Modified:	
 *	28.10.96 Robert Danielsen: Added tables for Intra luminance
 *			coefficients
 *      01.05.97 Luis Ducla-Soares: added VM7.0 Reversible VLC tables (RVLC).
 *      13.05.97 Minhua Zhou: added cbpy_tab3,cbpy_tab2
 *
 ***********************************************************HeaderEnd*********/

/************************    INCLUDE FILES    ********************************/

#ifndef _VLC_H_
#define _VLC_H_

/* type definitions for variable length code table entries */

typedef struct
{
  U_Int code; /* right justified */
  Int len;
} VLCtable;


/* DC prediction sizes */
extern VLCtable DCtab_lum[13];
extern VLCtable DCtab_chrom[13];

/* Motion vectors */
extern VLCtable mvtab[33];

/* MCBPC Indexing by cbpc in first two bits, mode in last two.
 CBPC as in table 4/H.263, MB type (mode): 3 = 01, 4 = 10.
 Example: cbpc = 01 and mode = 4 gives index = 0110 = 6. */
extern VLCtable mcbpc_intra_tab[15];

/* MCBPC inter.
   Addressing: 5 bit ccmmm (cc = CBPC, mmm = mode (1-4 binary)) */
extern VLCtable mcbpc_inter_tab[29];
extern VLCtable mcbpc_sprite_tab[31];

/* MODB table, MW 18-MAY-1998 */
extern VLCtable modb_tab[3];

#if 0
/* MCBPC for separate mode */
extern VLCtable mcbpc_sep_tab[9];
#endif

/* CBPY. Straightforward indexing */
extern VLCtable cbpy_tab[16];
extern VLCtable cbpy_tab3[8]; 
extern VLCtable cbpy_tab2[4]; 

/* DCT coefficients. Four tables, two for last = 0, two for last = 1.
   the sign bit must be added afterwards. */

/* first part of coeffs for last = 0. Indexed by [run][level-1] */
extern VLCtable coeff_tab0[2][12];

/* rest of coeffs for last = 0. indexing by [run-2][level-1] */
extern VLCtable coeff_tab1[25][4];

/* first coeffs of last = 1. indexing by [run][level-1] */
extern VLCtable coeff_tab2[2][3];

/* rest of coeffs for last = 1. indexing by [run-2] */
extern VLCtable coeff_tab3[40];

/* New tables for Intra luminance coefficients. Same codewords,
   different meaning */

/* Coeffs for last = 0, run = 0. Indexed by [level-1] */
extern VLCtable coeff_tab4[27];

/* Coeffs for last = 0, run = 1. Indexed by [level-1] */
extern VLCtable coeff_tab5[10];

/* Coeffs for last = 0, run = 2 -> 9. Indexed by [run-2][level-1] */
extern VLCtable coeff_tab6[8][5];

/* Coeffs for last = 0, run = 10 -> 14. Indexed by [run-10] */
extern VLCtable coeff_tab7[5];

/* Coeffs for last = 1, run = 0. Indexed by [level-1] */
extern VLCtable coeff_tab8[8];

/* Coeffs for last = 1, run = 1 -> 6. Indexed by [run-1][level-1] */
extern VLCtable coeff_tab9[6][3];

/* Coeffs for last = 1, run = 7 -> 20. Indexed by [run-7] */
extern VLCtable coeff_tab10[14];


/* RVLC tables */
/* DCT coefficients. Four tables, two for last = 0, two for last = 1.
   the sign bit must be added afterwards. */

/* DCT  coeffs (intra) for last = 0.  */

/* Indexed by [level-1] */

extern VLCtable coeff_RVLCtab1[27];
extern VLCtable coeff_RVLCtab2[13];
extern VLCtable coeff_RVLCtab3[11];
extern VLCtable coeff_RVLCtab4[9];
extern VLCtable coeff_RVLCtab5[2][6];
extern VLCtable coeff_RVLCtab6[2][5];
extern VLCtable coeff_RVLCtab7[2][4];
extern VLCtable coeff_RVLCtab8[3][2];
extern VLCtable coeff_RVLCtab9[7];
extern VLCtable coeff_RVLCtab10[2][5];
extern VLCtable coeff_RVLCtab11[3];
extern VLCtable coeff_RVLCtab12[11][2];
extern VLCtable coeff_RVLCtab13[32];
extern VLCtable coeff_RVLCtab14[19];
extern VLCtable coeff_RVLCtab15[10];
extern VLCtable coeff_RVLCtab16[2][7];
extern VLCtable coeff_RVLCtab17[5];
extern VLCtable coeff_RVLCtab18[3][4];
extern VLCtable coeff_RVLCtab19[2][3];
extern VLCtable coeff_RVLCtab20[8][2];
extern VLCtable coeff_RVLCtab21[21];
extern VLCtable coeff_RVLCtab22[2][5];
extern VLCtable coeff_RVLCtab23[3];
extern VLCtable coeff_RVLCtab24[11][2];
extern VLCtable coeff_RVLCtab25[32];


#endif /* _VLC_H */





