/******************************************************************************
 *                                                                          
 * This software module was originally developed by 
 *
 * Cor Quist (KPN / ACTS-MoMuSys).     			              	
 *
 * in the course of development of the MPEG-4 Video (ISO/IEC 14496-2) standard.
 * This software module is an implementation of a part of one or more MPEG-4 
 * Video (ISO/IEC 14496-2) tools as specified by the MPEG-4 Video (ISO/IEC 
 * 14496-2) standard. 
 *
 * ISO/IEC gives users of the MPEG-4 Video (ISO/IEC 14496-2) standard free 
 * license to this software module or modifications thereof for use in hardware
 * or software products claiming conformance to the MPEG-4 Video (ISO/IEC 
 * 14496-2) standard. 
 *
 * Those intending to use this software module in hardware or software products
 * are advised that its use may infringe existing patents. The original 
 * developer of this software module and his/her company, the subsequent 
 * editors and their companies, and ISO/IEC have no liability for use of this 
 * software module or modifications thereof in an implementation. Copyright is 
 * not released for non MPEG-4 Video (ISO/IEC 14496-2) standard conforming 
 * products. 
 *
 * ACTS-MoMuSys partners retain full right to use the code for his/her own 
 * purpose, assign or donate the code to a third party and to inhibit third 
 * parties from using the code for non MPEG-4 Video (ISO/IEC 14496-2) standard
 * conforming products. This copyright notice must be included in all copies or
 * derivative works. 
 *
 * Copyright (c) 1997
 *
 *****************************************************************************/



/***********************************************************HeaderBegin*******
 *                                                                         
 * File:	text_bits.h
 *
 * Author:	Cor Quist
 * Created:	April 10, 1996
 *                                                                         
 * Description: 
 *
 * Notes: 	
 *
 * Modified:	21.04.96 Robert Danielsen: New header.
 *              23.04.96 Bruno Loret: Non reentrant ifndef
 *		        12.03.97 Minhua Zhou: added B_vops	
 *              11.12.97 Bob Eifrig: added interlaced statistics
 *              21.05.98 Ji Heon Kweon (HYUNDAI) : support for grayscale coding 
 *		03.03.99 Seishi TAKAMURA (NTT): added GMC coding
 *
 ***********************************************************HeaderEnd*********/


#ifndef _TEXT_BITS_H_
#define _TEXT_BITS_H_


#include "momusys.h"
#include "text_defs.h"



/* struct for counting bits */

typedef struct {
  Int Y;
  Int C;
  Int vec;
  Int CBPY;
  Int CBPC; 
  Int MCBPC;
  Int MODB;
  Int CBPB;
  Int MBTYPE;
  Int COD;
  Int MB_Mode; 
  Int header;
  Int DQUANT;
  Int total;
  Int no_inter;
  Int no_inter4v;
  Int no_intra;
  Int no_GMC;	/* NTT for GMC coding */
  Int ACpred_flag;
  Int G;	/* HYUNDAI : (Grayscale) */
  Int CODA;	/* HYUNDAI : (Grayscale) */
  Int CBPA;	/* HYUNDAI : (Grayscale) */
  Int g_ACpred_flag;	/* HYUNDAI : (Grayscale) */
  Int no_field;
  Int no_skipped;
  Int no_Pskip;
  Int no_noDCT;
  Int fieldDCT;
  Int interlaced;
  Int Btype[7];
  Int Nmvs[3];
} Bits;
#include "text_bits.p"


#endif /* _TEXT_BITS_H_ */
