/*****************************************************************************
 *
 * This software module was originally developed by
 *
 *   Dietmar Zaig (Siemens AG / ACTS-MoMuSyS)
 *
 * and edited by
 * 
 *   Paulo Nunes (IST / ACTS-MoMuSyS)
 *
 * in the course of development of the MPEG-4 Video (ISO/IEC 14496-2) standard.
 * This software module is an implementation of a part of one or more MPEG-4
 * Video (ISO/IEC 14496-2) tools as specified by the MPEG-4 Video (ISO/IEC
 * 14496-2) standard.
 *
 * ISO/IEC gives users of the MPEG-4 Video (ISO/IEC 14496-2) standard free
 * license to this software module or modifications thereof for use in hardware
 * or software products claiming conformance to the MPEG-4 Video (ISO/IEC
 * 14496-2) standard.
 *
 * Those intending to use this software module in hardware or software products
 * are advised that its use may infringe existing patents. The original
 * developer of this software module and his/her company, the subsequent
 * editors and their companies, and ISO/IEC have no liability for use of this
 * software module or modifications thereof in an implementation. Copyright is
 * not released for non MPEG-4 Video (ISO/IEC 14496-2) Standard conforming
 * products.
 *
 * ACTS-MoMuSys partners retain full right to use the code for his/her own
 * purpose, assign or donate the code to a third party and to inhibit third
 * parties from using the code for non MPEG-4 Video (ISO/IEC 14496-2) Standard
 * conforming products. This copyright notice must be included in all copies or
 * derivative works.
 *
 * Copyright (c) 1996
 *
 *****************************************************************************/

/***********************************************************HeaderBegin*******
 *                                                                         
 * File:	mot_get_mvnum.c
 *
 * Author:	Dietmar Zaig (Siemens AG)
 * Created:	27-Feb-96
 *                                                                         
 * Description: Variable length decoding.
 *
 * Notes: 	based on tmndecode, (C) 1995 Telenor R&D.
 *
 * Modified:	8-May-96 Paulo Nunes: Reformatted. New headers.
 *	03.03.99 Seishi TAKAMURA (NTT): added GMC coding
 *
 ***********************************************************HeaderEnd*********/

/************************    INCLUDE FILES    ********************************/

#include "momusys.h"
#include "mot_get_mvnum.h"


/***********************************************************CommentBegin******
 *
 * -- GetMVnum -- Decodes number of vectors per MB (0,1,4) for separate motion case 
 *
 * Author :		
 *	Dietmar Zaig (Siemens AG)
 *
 * Created :		
 *	27-Feb-96
 *
 * Purpose :		
 *	To decode the number of vectors per MB (0,1,4) for separate motion
 *	case.
 * 
 * Arguments in : 	
 *	Bitstream vop_bitstream,	bitstream to be parsed.
 *
 *
 * Arguments in/out :	
 *	
 *
 * Arguments out :	
 *	
 *
 * Return values :	
 *	The number of vectors (0,1,4).
 *
 *
 * Side effects :	
 *	
 *
 * Description :	
 *	
 *
 * See also :
 *	
 *
 * Modified :		
 *	
 *
 ***********************************************************CommentEnd********/

Int
GetMVnum (Bitstream * vop_bitstream, Trace *trace)

{
  if (!BitstreamReadBits (vop_bitstream, 1,"vector_number_code",trace,MARK))
    {
      if (trace->trace)
	fprintf (trace->fp_trace, "  >> 1 MV per MB\n");
      return 1;
    }

  if (BitstreamReadBits (vop_bitstream, 1,"vector_number_code",trace,MARK))
    {
      if (trace->trace)
	fprintf (trace->fp_trace, "  >> 0 MV per MB\n");
      return 0;
    }
  else
    {
      if (trace->trace)
	fprintf (trace->fp_trace, "  >> 4 MV per MB\n");
      return 4;
    }

}
				/* GetMVnum */
				
				
				
Int
GetSpriteMVnum (Bitstream * vop_bitstream, Trace *trace)

{
  if (!BitstreamReadBits (vop_bitstream, 1,"vector_number_code",trace,MARK))
    {
      if (trace->trace)
	fprintf (trace->fp_trace, "  >> 1 MV per MB\n");
      return 1;
    }

  if (BitstreamReadBits (vop_bitstream, 1,"vector_number_code",trace,MARK))
    {
      if (trace->trace)
	fprintf (trace->fp_trace, "  >> 0 MV per MB\n");
      return 0;
    }
  else
  if (BitstreamReadBits (vop_bitstream, 1,"vector_number_code",trace,MARK))
    {
      if (trace->trace)
/* modified by NTT for GMC coding : start
	fprintf (trace->fp_trace, "  >> DYN_SP MB\n");
*/
	fprintf (trace->fp_trace, "  >> GMC MB\n");
/* modified by NTT for GMC coding : end */
      return 0;
    }
  else    
    {
      if (trace->trace)
	fprintf (trace->fp_trace, "  >> 4 MV per MB\n");
      return 4;
    }

}				/* GetSpriteMVnum */
