/*****************************************************************************
 "This software module was originally developed by:
 
	Dae-Sung Cho (Samsung AIT),
 
        and edited by:

	Dae-Sung Cho (Samsung AIT)
 
        in the course of development of the <MPEG-4 Video(ISO/IEC 14496-2)>. This
  software module is an implementation of a part of one or more <MPEG-4 Video
  (ISO/IEC 14496-2)> tools as specified by the <MPEG-4 Video(ISO/IEC 14496-2)
  >. ISO/IEC gives users of the <MPEG-4 Video(ISO/IEC 14496-2)> free license
  to this software module or modifications thereof for use in hardware or
  software products claiming conformance to the <MPEG-4 Video(ISO/IEC 14496-2
  )>. Those intending to use this software module in hardware or software
  products are advised that its use may infringe existing patents. The
  original developer of this software module and his/her company, the
  subsequent editors and their companies, and ISO/IEC have no liability for
  use of this software module or modifications thereof in an implementation.
  Copyright is not released for non <MPEG-4 Video(ISO/IEC 14496-2)>
  conforming products. Samsung AIT (SAIT) retains full right to use the code
  for his/her own purpose, assign or donate the code to a third party and to
  inhibit third parties from using the code for non <MPEG-4 Video(ISO/IEC
  14496-2)> conforming products. This copyright notice must be included in
  all copies or derivative works. Copyright (c)1997, 1998".
 *****************************************************************************/

#include <stdio.h>
#ifndef WIN32
#include <values.h>
#endif
#include <sys/stat.h>
#include <string.h>
#include "momusys.h"
#include "mom_structs.h"
#include "mom_bitstream_d.h"
#include "mom_vol.h"
#include "vm_dec_defs.h"
#include "alp_common_def.h"
#include "alp_common_cae.h"
#include "alp_common_si.h"
#include "bin_ar_decode.h"
#include "alp_dec_si.h"
#include "alp_dec_mom.h"
#include "alp_common_util.h"
#include "alp_dec_util.h"
#include "si_intra.h"
#include "shape_def.h"

/***********************************************************HeaderBegin*******
 *
 * File:        alp_dec_si.c
 *
 * Author:      Samsung AIT (SAIT)
 * Created:     13-Oct-97
 *
 * Description: Scalable shape coder using scan interleaving (SI)
 *
 * Copyright (C) 1996 Samsung AIT All Rights Reserved.                
 *
 ***********************************************************HeaderEnd*********/

/***********************************************************CommentBegin******
 *
 * -- ShapeDecodingSI -- Decodes a binary alpha block using intraCAE.
 *
 * Author :		
 *	Dae-Sung Cho (Samsung AIT)
 *
 * Created :		
 *	11-04-97
 * 
 * Arguments: 	
 *			stream  	: input bitstream
 *			alpha_dmb	: reconstructed alpha block 
 *			alpha_mb_comp,	:	MC alpha block
 * 			rec_curr_alpha  : reconstructed alpha plane
 * 			rec_up_alpha    : upsampled  alpha plane
 *			x,y		:	address of binary alpha block in pixels
 *			offsetx, offsety: offset address of start position from upsampled vop 
 *
 * Return values :	
 *
 * Side effects :	
 *	-
 *
 * Description : 
 *
 * See also :
 *
 * Modified:
 *
 ***********************************************************CommentEnd********/
Int 
ShapeDecodingSI(Bitstream *stream,
		Vop *rec_curr, /*OBSSFIX_MODE3-add-*/
		Vop *rec_up,
		UChar *alpha_dmb, 
		Image *rec_curr_alpha, 
		Image *rec_up_alpha, 
		Image *rec_spos_alpha,
		Image *alpha_rec_packet,
		Int x, 
		Int y, 
		Int offsetx,
		Int offsety,
		Int error_res_disable,
		Trace *trace,
		Int *error_flag)
{
        Image *top_border = AllocImage(MB_SIZE+4,2,SHORT_TYPE),
              *left_border = AllocImage(2,MB_SIZE,SHORT_TYPE),
	      *bottom_border = AllocImage(MB_SIZE+4,2,SHORT_TYPE),
              *right_border = AllocImage(2,MB_SIZE,SHORT_TYPE),
              *bordered_smb=NULL,
              *bordered_smb_v=NULL;

        Image *mblock_up;
        UChar alpha_smb[MB_SIZE*MB_SIZE];
        Int i, j, ret=0, ret_mb, mb_s;
        Int st;
        SInt *p;
        SInt *a_mb_up;

	Int v,h;

	Image *mblock_spos;
	SInt *a_mb_spos;

	UChar alpha_mb_spos[MB_SIZE*MB_SIZE];
	UChar alpha_mb_spos_h[MB_SIZE];
	UChar alpha_mb_spos_v[MB_SIZE];

	Double v_factor;
	Int v_factor_int;
	Double h_factor;
	Int h_factor_int;
        
	Int hor_res_scan, ver_res_scan;
	Int hor_loop_num, ver_loop_num;
/*OBSSFIX_MODE3-start-(MODE1?)*/        
	Int shape_ver_sampling_factor_m = GetVopShapeVerSampM(rec_curr);
	Int shape_ver_sampling_factor_n = GetVopShapeVerSampN(rec_curr);
	Int shape_hor_sampling_factor_m = GetVopShapeHorSampM(rec_curr);
	Int shape_hor_sampling_factor_n = GetVopShapeHorSampN(rec_curr);
/*	Int shape_ver_sampling_factor_m = GetVopShapeVerSampM(rec_up);*/
/*	Int shape_ver_sampling_factor_n = GetVopShapeVerSampN(rec_up);*/
/*	Int shape_hor_sampling_factor_m = GetVopShapeHorSampM(rec_up);*/
/*	Int shape_hor_sampling_factor_n = GetVopShapeHorSampN(rec_up);*/
/*OBSSFIX_MODE3-end-(MODE1?)*/        

#ifdef	_DEBUG_OBSS_
fprintf(stderr,">>>ShapeDecodingSI()==>\n");
#endif

        for( i=0; i<MB_SIZE; i++ )
                for( j=0; j<MB_SIZE; j++ ) alpha_smb[i*MB_SIZE+j] = 0;

        mb_s = MB_SIZE;
        mblock_up = AllocImage(mb_s,mb_s,SHORT_TYPE);
        a_mb_up      = (SInt *)GetImageData(mblock_up);

	mblock_spos = AllocImage(MB_SIZE,MB_SIZE,SHORT_TYPE);
	a_mb_spos = (SInt *) GetImageData(mblock_spos);

        GetSubImage(rec_spos_alpha,mblock_spos,x,y);
        for( v=0; v<MB_SIZE; v++) for( h=0; h<MB_SIZE; h++ ) {
           alpha_mb_spos[v*MB_SIZE+h] = (UChar)a_mb_spos[v*MB_SIZE+h];
        }

        p = (SInt *)GetImageData(rec_up_alpha);
        for (i=0;i<MB_SIZE;i++) {
          for (j=0;j<MB_SIZE;j++,a_mb_up++) {
	    if(a_mb_spos[i*MB_SIZE+j]==1) {
		  *a_mb_up=(p[(offsety+y+i)*GetImageSizeX(rec_up_alpha)+(offsetx+x+j)]>0);
	    } else {
		  *a_mb_up=0;
	    }
          }
	}

        /* decode header */
        /* construct the bordered and subsampled MB */
        bordered_smb = AllocImage(mb_s+4,mb_s+4,SHORT_TYPE);

	h_factor = log((Double)shape_hor_sampling_factor_n/shape_hor_sampling_factor_m)/log(2.);
	v_factor = log((Double)shape_ver_sampling_factor_n/shape_ver_sampling_factor_m)/log(2.);
	h_factor_int = (Int)floor(h_factor+0.000001);
	v_factor_int = (Int)floor(v_factor+0.000001);
 
	hor_res_scan = (h_factor-h_factor_int>0.000001) ? 1 : 0;
	ver_res_scan = (v_factor-v_factor_int>0.000001) ? 1 : 0;
	hor_loop_num = h_factor_int;
	ver_loop_num = v_factor_int;

/*
#ifdef  _DEBUG_OBSS_
	fprintf(stderr,"hor_res_scan=%d\n",hor_res_scan);
	fprintf(stderr,"ver_res_scan=%d\n",ver_res_scan);
	fprintf(stderr,"hor_loop_num=%d\n",hor_loop_num);
	fprintf(stderr,"ver_loop_num=%d\n",ver_loop_num);
#endif
*/

       	if (y>1) GetSubImage(rec_curr_alpha,top_border,x-2,y-2);
       	else     SetConstantImage(top_border,0);
       	if (x>1) GetSubImage(rec_curr_alpha,left_border,x-2,y);
       	else     SetConstantImage(left_border,0);

        if (y+MB_SIZE<GetImageSizeY(rec_curr_alpha)-1)
                GetSubImage(rec_up_alpha,bottom_border,x+offsetx-2,y+offsety+MB_SIZE);
        else SetConstantImage(bottom_border,0);
        if (x+MB_SIZE<GetImageSizeX(rec_curr_alpha)-1)
                GetSubImage(rec_up_alpha,right_border,x+offsetx+MB_SIZE,y+offsety);
        else SetConstantImage(right_border,0);

        BinariseImage(top_border);
        BinariseImage(left_border);
        BinariseImage(bottom_border);
        BinariseImage(right_border);

	PutSubImage(bordered_smb,top_border,0,0);
	PutSubImage(bordered_smb,left_border,0,2);

	/* right-bottom bordering from reference VOP */
	PutSubImage(bordered_smb,bottom_border,0,MB_SIZE+2);
	PutSubImage(bordered_smb,right_border,MB_SIZE+2,2);

        FreeImage(top_border);
        FreeImage(left_border);
        FreeImage(bottom_border);
        FreeImage(right_border);

        PutSubImage(bordered_smb,mblock_up,2,2);
        FreeImage(mblock_up);

	/* reconstructing vertical sampling position */
	for( v=0; v<MB_SIZE; v++) {
           i = 0;
           for (h=0; h<MB_SIZE; h++) {
                if( alpha_mb_spos[v*MB_SIZE+h] > 0 ) i = 1;
                if( i==1 ) break;
           }
           alpha_mb_spos_v[v] = i;
	}
        
	/* reconstructing vertical sampling position */
	for( h=0; h<MB_SIZE; h++) {
           j = 0;
           for (v=0; v<MB_SIZE; v++) {
                if( alpha_mb_spos[v*MB_SIZE+h] > 0 ) j = 1;
                if( j==1 )  break;
           }
           alpha_mb_spos_h[h] = j;
	}

/*
#ifdef  _DEBUG_OBSS_
fprintf(stderr,"alpha_mb_spos\n");
for(v=0;v<MB_SIZE;v++) {
  for(h=0;h<MB_SIZE;h++) fprintf(stderr,"%d", alpha_mb_spos_v[v*MB_SIZE+h]);
  fprintf(stderr,"\n");
}
fprintf(stderr,"alpha_mb_spos_v\n");
for(v=0;v<MB_SIZE;v++) fprintf(stderr,"%d", alpha_mb_spos_v[v]);
fprintf(stderr,"\nalpha_mb_spos_h\n");
for(h=0;h<MB_SIZE;h++) fprintf(stderr,"%d", alpha_mb_spos_h[h]);
getchar();
#endif
*/

	/* decode the subsampled MB */
        if( shape_hor_sampling_factor_n==2*shape_hor_sampling_factor_m &&
                shape_ver_sampling_factor_n==2*shape_ver_sampling_factor_m )
        {
	st = DecideScanOrderSI(bordered_smb,MB_SIZE);
	} else st=1;

        if (st==1)
	{
                ret_mb = SI_Decode(stream, 
					bordered_smb, 
                                                alpha_mb_spos_h,
                                                alpha_mb_spos_v,
                                                hor_loop_num,
                                                ver_loop_num,
                                                hor_res_scan,
                                                ver_res_scan,
					error_res_disable, 
					trace, 
					error_flag);
        } else 
	{
                bordered_smb_v = AllocSameImage(bordered_smb);
                TransposeImage(bordered_smb,bordered_smb_v);
#ifdef	_DEBUG_OBSS_
	fprintf(stderr,">>>>>Transposed input bordered_smb>>>>>>>>>>>>>\n");
	p = (SInt *)GetImageData(bordered_smb_v);
  	for (i=0;i<mb_s+4;i++)
	{
  		for (j=0;j<mb_s+4;j++) fprintf(stderr,"%d",(*(p++)>0) );
		fprintf(stderr,"\n");
	}
	fprintf(stderr,"\n"); 
#endif
                ret_mb = SI_Decode(stream, 
					bordered_smb_v, 
                                                alpha_mb_spos_h,
                                                alpha_mb_spos_v,
                                                hor_loop_num,
                                                ver_loop_num,
                                                hor_res_scan,
                                                ver_res_scan,
					error_res_disable, 
					trace, 
					error_flag); 
#ifdef	_DEBUG_OBSS_
	fprintf(stderr,">>>>>Transposed output bordered_smb>>>>>>>>>>>>>\n");
	p = (SInt *)GetImageData(bordered_smb_v);
  	for (i=0;i<mb_s+4;i++)
	{
  		for (j=0;j<mb_s+4;j++) fprintf(stderr,"%d",(*(p++)>0) );
		fprintf(stderr,"\n");
	}
	fprintf(stderr,"\n"); 
#endif

                TransposeImage(bordered_smb_v,bordered_smb);
                FreeImage(bordered_smb_v);
        }

        ret += ret_mb;

#ifdef	_DEBUG_OBSS_
	fprintf(stderr,">>>>>Output bordered_smb>>>>>>>>>>>>>\n");
	fprintf(stderr,"Scan order=%d (0-transpose, 1-none) !\n", st);
	p = (SInt *)GetImageData(bordered_smb);
  	for (i=0;i<mb_s+4;i++)
	{
  		for (j=0;j<mb_s+4;j++) fprintf(stderr,"%d", (*(p++)>0) );
		fprintf(stderr,"\n");
	}
	fprintf(stderr,"\n"); 
#endif

        /* extract alpha_smb and upsample it */
        p = (SInt *) GetImageData(bordered_smb) + 2*GetImageSizeX(bordered_smb) + 2;
        for( i=0; i<mb_s; i++, p+=GetImageSizeX(bordered_smb)-mb_s )
	{
                for( j=0; j<mb_s; j++, p++ )
                {
                        alpha_smb[i*mb_s+j] = (UChar) (*p);
                }
	}

        for( i=0; i<mb_s*mb_s; i++ ) alpha_dmb[i] = alpha_smb[i];

        for( i=0; i<MB_SIZE; i++ )
                for( j=0; j<MB_SIZE; j++ )
                        alpha_dmb[i*MB_SIZE+j] = f8bit(alpha_dmb[i*MB_SIZE+j]);

        FreeImage(bordered_smb);
	FreeImage(mblock_spos); /* added by D.S.CHO (Samsung AIT) (2000/02/25) */

        return ret;
}

Int SI_Decode(Bitstream *bitstream, 
		Image *bordered_smb, 
		UChar *alpha_mb_spos_h,
		UChar *alpha_mb_spos_v,
		Int hor_loop_num,
		Int ver_loop_num,
		Int hor_res_scan,
		Int ver_res_scan,
		Int error_res_disable,
		Trace *trace, 
		Int *error_flag)
{
	Int prob, si_bab_type;
	ArDecoder 	ar_decoder;

#ifdef	_DEBUG_OBSS_
fprintf(stderr,">>>SI_Decode()==>\n");
#endif

	StartArDecoder(&ar_decoder,error_res_disable,bitstream,error_flag); 

	prob=si_babtype_prob[0];
	si_bab_type=ArDecodeSymbol(prob,&ar_decoder,bitstream,trace,error_flag); 

#ifdef  _DEBUG_OBSS_
fprintf(stderr,">>>>>si_bab_type=%d (0:transitional bab,1:exceptional bab)\n",si_bab_type);
#endif

	if(si_bab_type==0)	/* Transitional Bab */
	{
		/*
		DecodeTransitionalBab(bordered_smb,
					&ar_decoder,
					bitstream,
					trace,
					error_flag);
		*/
		DecodeTransitionalBab_AR (bordered_smb,
					alpha_mb_spos_h,
					alpha_mb_spos_v,
					hor_loop_num,
					ver_loop_num,
					hor_res_scan,
					ver_res_scan,
					&ar_decoder,
					bitstream,
					trace,
					error_flag);
	} else			/* Exceptional Bab */
	{
		/*
		DecodeExceptionalBab(bordered_smb,
					&ar_decoder,
					bitstream,
					trace,
					error_flag);
		*/
		DecodeExceptionalBab_AR (bordered_smb,
					alpha_mb_spos_h,
					alpha_mb_spos_v,
					hor_loop_num,
					ver_loop_num,
					hor_res_scan,
					ver_res_scan,
					&ar_decoder,
					bitstream,
					trace,
					error_flag);
	}

	StopArDecoder(&ar_decoder,bitstream,trace,error_flag); 
				
	return 0;
} 

Int DecodeTransitionalBab(Image *bordered_smb, 
			ArDecoder *ar_decoder, 
			Bitstream *bitstream, 
			Trace *trace,
			Int *error_flag)
{
        Int i, j;
	Int context,prob;
        Int width=GetImageSizeX(bordered_smb),
            height=GetImageSizeY(bordered_smb);
        Int curr,prev,next;
        SInt *smb_data;

        smb_data = (SInt *)GetImageData(bordered_smb) + 2*width + 2;
      
#ifdef	_DEBUG_OBSS_
fprintf(stderr,">>>>>DecodeTransitionalBab()==>\n");
fprintf(stderr,">>>>>Vertical Scanning\n");
#endif

	/* Vertical scanning */
        for(j=0;j<width-4;j+=2) 
	{
                for(i=1;i<height-4;i+=2) 
		{
                        prev=*(smb_data+i*width+j-1);
                        if(j==width-1) next=prev;
                        else           next=*(smb_data+i*width+j+1);

/*
#ifdef  _DEBUG_OBSS_
fprintf(stderr,">>>>>(%d,%d):prev=%d,next=%d\n",i,j,prev,next);
#endif
*/
                        if(prev==next) *(smb_data+i*width+j)=prev;
			else 
			{
                                context = GetContextSI_VS(smb_data, 
							j, 
							i, 
 		                                        	0,
                                                        	width-5,
                                                        	0,
                                                        	height-5,
							width); 

				prob = si_intra_vs_prob[context];
				curr = ArDecodeSymbol(prob,
							ar_decoder,
							bitstream,
							trace,
							error_flag);

                                *(smb_data+i*width+j) = curr;

/*
#ifdef  _DEBUG_OBSS_
fprintf(stderr,">>>>>ar_decoder->L:%d,ar_decoder->R:%d\n",ar_coder->L,ar_coder->R);
fprintf(stderr,">>>>>curr=%d, context=%d, prob=%d\n",curr,context,prob);
#endif
*/
                        }
#ifdef  _DEBUG_OBSS_
if(prev==next) fprintf(stderr,"- ");
else	       fprintf(stderr,"%3d ", context);
#endif
                }
#ifdef  _DEBUG_OBSS_
fprintf(stderr,"\n");
#endif
	}

#ifdef	_DEBUG_OBSS_
fprintf(stderr,">>>>>Horizontal Scanning\n");
#endif

	/* Horizontal scanning */
        for(i=0;i<height-4;i+=2) 
	{
                for(j=0;j<width-4;j++) 
		{
                        prev=*(smb_data+(i-1)*width+j);
                        if(i==height-1)	next=prev;
                        else 		next=*(smb_data+(i+1)*width+j);

/*
#ifdef  _DEBUG_OBSS_
fprintf(stderr,">>>>>(%d,%d):prev=%d,next=%d\n",i,j,prev,next);
#endif
*/
                        if(prev==next) *(smb_data+i*width+j)=prev;
			else
			{
                                context = GetContextSI_HS(smb_data, 
						j, 
						i, 
 		                                       	0,
                                                       	width-5,
                                                       	0,
                                                       	height-5,
						width); 
			
				prob = si_intra_hs_prob[context];
				curr = ArDecodeSymbol(prob,
							ar_decoder,
							bitstream,
							trace,
							error_flag);

                                *(smb_data+i*width+j) = curr;

/*
#ifdef  _DEBUG_OBSS_
fprintf(stderr,">>>>>ar_decoder->L:%d,ar_decoder->R:%d\n",ar_coder->L,ar_coder->R);
fprintf(stderr,">>>>>curr=%d, context=%d, prob=%d\n",curr,context,prob);
#endif
*/
                        }
#ifdef  _DEBUG_OBSS_
if(prev==next) fprintf(stderr,"- ");
else	       fprintf(stderr,"%3d ", context);
#endif
                }
#ifdef  _DEBUG_OBSS_
fprintf(stderr,"\n");
#endif
        }

	return 0;
}

Int DecodeExceptionalBab(Image *bordered_smb,
			ArDecoder *ar_decoder, 
			Bitstream *bitstream, 
			Trace *trace,
			Int *error_flag)
{
        Int i, j;
	Int context,prob;
        Int width=GetImageSizeX(bordered_smb),
            height=GetImageSizeY(bordered_smb);
        Int curr;
        SInt *smb_data;

        smb_data = (SInt *)GetImageData(bordered_smb) + 2*width + 2;

#ifdef	_DEBUG_OBSS_
fprintf(stderr,">>>DecodeExceptionalBab()==>\n");
fprintf(stderr,">>>>>Vertical Scanning\n");
#endif

	/* Vertical scanning */
        for(j=0;j<width-4;j+=2)
	{
                for(i=1;i<height-4;i+=2)
		{
/*
#ifdef  _DEBUG_OBSS_
fprintf(stderr,">>>>>(%d,%d)\n",i,j);
#endif
*/
			context = GetContextSI_VS(smb_data, 
						j, 
						i, 
 		                                       	0,
                                                       	width-5,
                                                       	0,
                                                       	height-5,
						width);

			prob = si_intra_vs_prob[context];
			curr = ArDecodeSymbol(prob,
						ar_decoder,
						bitstream,
						trace,
						error_flag);
			
			*(smb_data+i*width+j) = curr;

/*
#ifdef  _DEBUG_OBSS_
fprintf(stderr,">>>>>ar_decoder->L:%d,ar_decoder->R:%d\n",ar_coder->L,ar_coder->R);
fprintf(stderr,">>>>>curr=%d, context=%d, prob=%d\n",curr,context,prob);
#endif
*/

#ifdef  _DEBUG_OBSS_
fprintf(stderr,"%3d ", context);
#endif
                } 
#ifdef  _DEBUG_OBSS_
fprintf(stderr,"\n");
#endif
        }

#ifdef	_DEBUG_OBSS_
fprintf(stderr,">>>>>Horizontal Scanning\n");
#endif
 
	/* Horizontal scanning */
        for(i=0;i<height-4;i+=2)
	{
                for(j=0;j<width-4;j++)
		{
/*
#ifdef  _DEBUG_OBSS_
fprintf(stderr,">>>>>(%d,%d)\n",i,j);
#endif
*/
			context = GetContextSI_HS(smb_data, 
						j, 
						i, 
 		                                       	0,
                                                       	width-5,
                                                       	0,
                                                       	height-5,
						width);
			
			prob = si_intra_hs_prob[context];
			curr = ArDecodeSymbol(prob,
						ar_decoder,
						bitstream,
						trace, 
						error_flag);

			*(smb_data+i*width+j) = curr;

/*
#ifdef  _DEBUG_OBSS_
fprintf(stderr,">>>>>ar_decoder->L:%d,ar_decoder->R:%d\n",ar_coder->L,ar_coder->R);
fprintf(stderr,">>>>>curr=%d, context=%d, prob=%d\n",curr,context,prob);
#endif
*/
#ifdef  _DEBUG_OBSS_
fprintf(stderr,"%3d ", context);
#endif
		}
#ifdef  _DEBUG_OBSS_
fprintf(stderr,"\n");
#endif
        }

	return 0;
}


Int DecodeTransitionalBab_AR (Image *bordered_smb, 
			UChar *alpha_mb_spos_h,
			UChar *alpha_mb_spos_v,
			Int hor_loop_num,
			Int ver_loop_num,
			Int hor_res_scan,
			Int ver_res_scan,
			ArDecoder *ar_decoder, 
			Bitstream *bitstream, 
			Trace *trace,
			Int *error_flag)
{
        Int i, j;
	Int context,prob;
        Int width=GetImageSizeX(bordered_smb),
            height=GetImageSizeY(bordered_smb);
        Int curr,prev,next;
        Int skip_upper=0,skip_bottom=0,skip_hor=0,skip_ver=0,skip_left=0,skip_right=0;
        Int start_v=0,start_h=0;
        Int h_scan_freq=1,v_scan_freq=1;
        Int tmp;

        SInt *smb_data;

        smb_data = (SInt *)GetImageData(bordered_smb) + 2*width + 2;

      
#ifdef  _DEBUG_OBSS_
fprintf(stderr,">>>>>DecodeTransitionalBab_AR ()==>\n");
fprintf(stderr,">>>horizontal sampling position !\n");
for(i=0; i<MB_SIZE; i++) fprintf(stderr,"%d",alpha_mb_spos_h[i]);
fprintf(stderr,"\n>>>vertical sampling position !\n");
for(i=0; i<MB_SIZE; i++) fprintf(stderr,"%d",alpha_mb_spos_v[i]);
fprintf(stderr,"\n");
fprintf(stderr,">>>>>Vertical Scanning\n");
#endif

	/* Vertical scanning */
        if(hor_res_scan) {
#ifdef  _DEBUG_OBSS_
fprintf(stderr,">>>>>residual encoding\n"); 
#endif
	   i=0;
	   while(alpha_mb_spos_h[i]==1) i++;
	   while(alpha_mb_spos_h[i]==0) i++;
	   tmp = i;

	   start_v = start_h = 0;
	   h_scan_freq = skip_hor = 1 << hor_loop_num;
	   v_scan_freq = 1 << ver_loop_num;
 
	   if (tmp-(1<<hor_loop_num)>=0)                start_h = tmp - (1<<hor_loop_num);
	   else if (tmp+(1<<hor_loop_num)<MB_SIZE)      start_h = tmp + (1<<hor_loop_num);
	   else {
                fprintf(stderr,"Error:out of sampling ratio !\n");
                exit(1);
	   }
 
	   i=0;
	   while(alpha_mb_spos_v[i]==0) i++;
	   start_v = i;

	   for(j=start_h;j<(width-4);j+=h_scan_freq) {
		if ( alpha_mb_spos_h[j] == 0 ) {
                   skip_upper = start_v+1;
                   for(i=start_v;i<(height-4);i+=v_scan_freq) {
                      if ( alpha_mb_spos_v[i] == 1 ) {
                        if (i+v_scan_freq > 15) skip_bottom=MB_SIZE+1-i;
                        else {
                           if ( alpha_mb_spos_v[i+v_scan_freq] == 0 ) {
                                if (i+v_scan_freq*2 > 15) skip_bottom=MB_SIZE+1-i;
                                else  skip_bottom=v_scan_freq*2;
                           } else  skip_bottom = v_scan_freq;
                        }
 
                        if (j-h_scan_freq < -2) prev = *(smb_data+i*width-2);
                        else    prev = *(smb_data+i*width+j-h_scan_freq);
                        if (j+h_scan_freq > 17) next = *(smb_data+i*width+17);
                        else    next = *(smb_data+i*width+j+h_scan_freq);
 
                        if (j-skip_hor<0)       skip_left = j+2;
                        else                    skip_left = skip_hor;
                        if (j+skip_hor>15)      skip_right = MB_SIZE+1-j;
                        else                    skip_right = skip_hor;

			if(prev==next) {
				*(smb_data+i*width+j)=prev;
#ifdef  _DEBUG_OBSS_
fprintf(stderr,">>>>>(%d,%d):prev=%d,next=%d\n",i,j,prev,next);
#endif
			} else {
                                context = GetContextSI_VS_AR (smb_data,
                                                                j,
                                                                i,
                                                                skip_right,
                                                                skip_left,
                                                                skip_upper,
                                                                skip_bottom,
                                                                width);
 
                                prob = si_intra_vs_prob[context];

				curr = ArDecodeSymbol(prob,
							ar_decoder,
							bitstream,
							trace,
							error_flag);

                                *(smb_data+i*width+j) = curr;

#ifdef  _DEBUG_OBSS_
fprintf(stderr,">>>>>(%d,%d):prev=%d,next=%d--curr=%d, context=%d, prob=%d (skip_right=%d left=%d upper=%d bottom=%d\n", i,j,prev,next,curr,context,prob,skip_right,skip_left,skip_upper,skip_bottom);
/*fprintf(stderr,">>>>>ar_decoder->L:%d,ar_decoder->R:%d\n",ar_decoder->L,ar_decoder->R);*/
#endif

			}
 
                        if (skip_bottom == v_scan_freq) skip_upper = v_scan_freq;
                        else                            skip_upper = 2*v_scan_freq;
                      }
                   }
                
		}
	   }
        }

	i=0;
	while(alpha_mb_spos_h[i]==1) i++;
	while(alpha_mb_spos_h[i]==0) i++;
	if(i>start_h && hor_res_scan) tmp=start_h;
	else	tmp = i;

#ifdef  _DEBUG_OBSS_
fprintf(stderr,">>>>>k-loop encoding-hor_loop_num=%d\n",hor_loop_num); 
/*getchar();*/
#endif

	while (hor_loop_num>0) {

	   start_v = start_h = 0;
	   h_scan_freq = 1<<hor_loop_num;
	   v_scan_freq = 1<<ver_loop_num;
	   skip_hor = 1<<(hor_loop_num-1);

	   if (tmp-(1<<(hor_loop_num-1))>=0)	tmp = start_h = tmp - (1<<(hor_loop_num-1));
	   else				start_h = tmp + (1<<(hor_loop_num-1));
		
	   i=0;
	   while (alpha_mb_spos_v[i]==0)	i++;
	   start_v = i;

	   for (j=start_h; j<(width-4); j+=h_scan_freq) {
		skip_upper = start_v + 1;
		for (i=start_v; i<(height-4); i+=v_scan_freq) {
		   if (alpha_mb_spos_v[i]==1) {
		      if (i+v_scan_freq > 15) skip_bottom=MB_SIZE+1-i;
		      else {
			  if ( alpha_mb_spos_v[i+v_scan_freq] == 0 ) {
				if (i+v_scan_freq*2 > 15) skip_bottom=MB_SIZE+1-i;
				else			  skip_bottom=v_scan_freq*2;
			  } else	skip_bottom = v_scan_freq;
		      }

		      if (j-(1<<(hor_loop_num-1))<-2) prev = *(smb_data+i*width-2);
		      else	prev = *(smb_data+i*width+j-(1<<(hor_loop_num-1)));
		      if (j+(1<<(hor_loop_num-1))>17) next = *(smb_data+i*width+17); 
		      else	next = *(smb_data+i*width+j+(1<<(hor_loop_num-1)));

		      if (j-skip_hor<0)	skip_left = j+2;
		      else			skip_left = skip_hor;
		      if (j+skip_hor>15)	skip_right = MB_SIZE+1-j;
		      else  		skip_right = skip_hor;

		      if(prev==next) {
				*(smb_data+i*width+j)=prev;
#ifdef  _DEBUG_OBSS_
fprintf(stderr,">>>>>(%d,%d):prev=%d,next=%d\n",i,j,prev,next);
#endif
		      } else {
                                context = GetContextSI_VS_AR (smb_data,
                                                                j,
                                                                i,
                                                                skip_right,
                                                                skip_left,
                                                                skip_upper,
                                                                skip_bottom,
                                                                width);
 
                                prob = si_intra_vs_prob[context];

				curr = ArDecodeSymbol(prob,
							ar_decoder,
							bitstream,
							trace,
							error_flag);

                                *(smb_data+i*width+j) = curr;

#ifdef  _DEBUG_OBSS_
fprintf(stderr,">>>>>(%d,%d):prev=%d,next=%d--curr=%d, context=%d, prob=%d (skip_right=%d left=%d upper=%d bottom=%d\n", i,j,prev,next,curr,context,prob,skip_right,skip_left,skip_upper,skip_bottom);
/*fprintf(stderr,">>>>>ar_decoder->L:%d,ar_decoder->R:%d\n",ar_decoder->L,ar_decoder->R);*/
#endif
		      }

		      if (skip_bottom == v_scan_freq)	skip_upper = v_scan_freq;
		      else				skip_upper = 2*v_scan_freq;
		   } 
		}
	   }
	   hor_loop_num--;
	}

#ifdef  _DEBUG_OBSS_
fprintf(stderr,">>>>>Horizontal Scanning\n");
#endif

	if(ver_res_scan) {
#ifdef  _DEBUG_OBSS_
fprintf(stderr,">>>>>residual encoding\n"); 
#endif
	   i=0;
	   while(alpha_mb_spos_v[i]==1) i++;
	   while(alpha_mb_spos_v[i]==0) i++;
	   tmp = i;
	      start_v = start_h = 0;
	      v_scan_freq = 1 << ver_loop_num;
	      h_scan_freq = 1;
	      skip_ver = v_scan_freq;

	      if (tmp-(1<<ver_loop_num)>=0)		start_v = tmp - (1<<ver_loop_num);
	      else if (tmp+(1<<ver_loop_num)<MB_SIZE) 	start_v = tmp + (1<<ver_loop_num);
	      else {
		fprintf(stderr,"Error:out of sampling ratio !\n");
		exit(1);
	      }
	
              for(i=start_v;i<(height-4);i+=v_scan_freq) {
		if( alpha_mb_spos_v[i]== 0 ) {
                   for(j=start_h;j<(width-4);j+=h_scan_freq) {
   
		      if (i-v_scan_freq < -2)	prev = *(smb_data-2*width+j);
		      else			prev = *(smb_data+(i-v_scan_freq)*width+j);
		      if (i+v_scan_freq > 17)	next = *(smb_data+17*width+j); 
		      else			next = *(smb_data+(i+v_scan_freq)*width+j);

		      if (i-skip_ver<0)		skip_upper = i+2;
		      else			skip_upper = skip_ver;
		      if (i+skip_ver>15)	skip_bottom = MB_SIZE+1-i;
		      else 	      		skip_bottom = skip_ver;

                      if(prev==next){
			 *(smb_data+i*width+j)=prev;
#ifdef  _DEBUG_OBSS_
fprintf(stderr,">>>>>(%d,%d):prev=%d,next=%d\n",i,j,prev,next);
#endif
		      } else {
			 context = GetContextSI_HS_AR (smb_data,
							j,
							i,
							skip_upper,
							skip_bottom,
							width);
			
			 prob = si_intra_hs_prob[context];
			 curr = ArDecodeSymbol(prob,
							ar_decoder,
							bitstream,
							trace,
							error_flag);

                         *(smb_data+i*width+j) = curr;
#ifdef  _DEBUG_OBSS_
fprintf(stderr,">>>>>(%d,%d):prev=%d,next=%d--curr=%d, context=%d, prob=%d (skip_upper=%d bottom=%d\n", i,j,prev,next,curr,context,prob,skip_upper,skip_bottom);
/*fprintf(stderr,">>>>>ar_decoder->L:%d,ar_decoder->R:%d\n",ar_decoder->L,ar_decoder->R);*/
#endif
                      }
		   }
		}
	      }
	}

	i=0;
	while(alpha_mb_spos_v[i]==1) i++;
	while(alpha_mb_spos_v[i]==0) i++;
	if(i>start_v && ver_res_scan) tmp=start_v;
	else	tmp = i;

#ifdef  _DEBUG_OBSS_
fprintf(stderr,">>>>>k-loop encoding-ver_loop_num=%d\n",ver_loop_num); 
/*getchar();*/
#endif

	while (ver_loop_num>0) {
	   start_v = start_h = 0;
	   v_scan_freq = 1<<ver_loop_num;
	   h_scan_freq = 1;

	   if (tmp-(1<<(ver_loop_num-1))>=0)	tmp = start_v = tmp - (1<<(ver_loop_num-1));
	   else				start_v = tmp + (1<<(ver_loop_num-1));
	   skip_ver = 1<<(ver_loop_num-1);

	   for (i=start_v; i<(height-4); i+=v_scan_freq) {
	   	for (j=start_h; j<(width-4); j+=h_scan_freq) {
		   if (i-skip_ver<-2) prev = *(smb_data-2*width+j);
		   else	prev = *(smb_data+(i-skip_ver)*width+j);
		   if (i+skip_ver>17) next = *(smb_data+17*width+j); 
		   else	next = *(smb_data+(i+skip_ver)*width+j);

		   if (i-skip_ver<0)	skip_upper = i+2;
		   else			skip_upper = skip_ver;
		   if (i+skip_ver>15)	skip_bottom = MB_SIZE+1-i;
		   else 	      	skip_bottom = skip_ver;

                   if(prev==next) {
			 *(smb_data+i*width+j)=prev;
#ifdef  _DEBUG_OBSS_
fprintf(stderr,">>>>>(%d,%d):prev=%d,next=%d\n",i,j,prev,next);
#endif
		   } else {
			 context = GetContextSI_HS_AR (smb_data,
							j,
							i,
							skip_upper,
							skip_bottom,
							width);
			
			 prob = si_intra_hs_prob[context];
			 curr = ArDecodeSymbol(prob,
							ar_decoder,
							bitstream,
							trace,
							error_flag);

                         *(smb_data+i*width+j) = curr;

#ifdef  _DEBUG_OBSS_
fprintf(stderr,">>>>>(%d,%d):prev=%d,next=%d--curr=%d, context=%d, prob=%d (skip_upper=%d bottom=%d\n", i,j,prev,next,curr,context,prob,skip_upper,skip_bottom);
/*fprintf(stderr,">>>>>ar_decoder->L:%d,ar_decoder->R:%d\n",ar_decoder->L,ar_decoder->R);*/
#endif
                   }
		}
	   }
	   ver_loop_num--;
	}

	return 0;
}

Int DecodeExceptionalBab_AR (Image *bordered_smb,
			UChar *alpha_mb_spos_h,
			UChar *alpha_mb_spos_v,
			Int hor_loop_num,
			Int ver_loop_num,
			Int hor_res_scan,
			Int ver_res_scan,
			ArDecoder *ar_decoder, 
			Bitstream *bitstream, 
			Trace *trace,
			Int *error_flag)
{

        Int i, j;
	Int context,prob;
        Int width=GetImageSizeX(bordered_smb),
            height=GetImageSizeY(bordered_smb);
        Int curr;
        Int skip_upper=0,skip_bottom=0,skip_hor=0,skip_ver=0,skip_left=0,skip_right=0;
        Int start_v=0,start_h=0;
        Int h_scan_freq=1,v_scan_freq=1;
        Int tmp;

        SInt *smb_data;

        smb_data = (SInt *)GetImageData(bordered_smb) + 2*width + 2;

#ifdef  _DEBUG_OBSS_
fprintf(stderr,">>>DecodeExceptionalBab()==>\n");
fprintf(stderr,">>>horizontal sampling position !\n");
for(i=0; i<MB_SIZE; i++) fprintf(stderr,"%d",alpha_mb_spos_h[i]);
fprintf(stderr,"\n>>>vertical sampling position !\n");
for(i=0; i<MB_SIZE; i++) fprintf(stderr,"%d",alpha_mb_spos_v[i]);
fprintf(stderr,"\n");
fprintf(stderr,">>>>>Vertical Scanning\n");
#endif
	/* Vertical scanning */
        if(hor_res_scan) {
#ifdef  _DEBUG_OBSS_
fprintf(stderr,">>>>>residual encoding\n"); 
#endif
           i=0;
           while(alpha_mb_spos_h[i]==1) i++;
           while(alpha_mb_spos_h[i]==0) i++;
           tmp = i;

           start_v = start_h = 0;
           h_scan_freq = skip_hor = 1 << hor_loop_num;
           v_scan_freq = 1 << ver_loop_num;
 
           if (tmp-(1<<hor_loop_num)>=0)                start_h = tmp - (1<<hor_loop_num);
           else if (tmp+(1<<hor_loop_num)<MB_SIZE)      start_h = tmp + (1<<hor_loop_num);
           else {
                fprintf(stderr,"Error:out of sampling ratio !\n");
                exit(1);
           }
 
           i=0;
           while(alpha_mb_spos_v[i]==0) i++;
           start_v = i;

           for(j=start_h;j<(width-4);j+=h_scan_freq) {
                if ( alpha_mb_spos_h[j] == 0 ) {
                   skip_upper = start_v+1;
                   for(i=start_v;i<(height-4);i+=v_scan_freq) {
                      if ( alpha_mb_spos_v[i] == 1 ) {
                        if (i+v_scan_freq > 15) skip_bottom=MB_SIZE+1-i;
                        else {
                           if ( alpha_mb_spos_v[i+v_scan_freq] == 0 ) {
                                if (i+v_scan_freq*2 > 15) skip_bottom=MB_SIZE+1-i;
                                else  skip_bottom=v_scan_freq*2;
                           } else  skip_bottom = v_scan_freq;
                        }
 
                        if (j-skip_hor<0)       skip_left = j+2;
                        else                    skip_left = skip_hor;
                        if (j+skip_hor>15)      skip_right = MB_SIZE+1-j;
                        else                    skip_right = skip_hor;

                        context = GetContextSI_VS_AR (smb_data,
							j,
							i,
							skip_right,
							skip_left,
							skip_upper,
							skip_bottom,
							width);
 
                        prob = si_intra_vs_prob[context];

			curr = ArDecodeSymbol(prob,
						ar_decoder,
						bitstream,
						trace,
						error_flag);

                        *(smb_data+i*width+j) = curr;

#ifdef  _DEBUG_OBSS_
fprintf(stderr,">>>>>(%d,%d):curr=%d, context=%d, prob=%d (skip_right=%d left=%d upper=%d bottom=%d)\n", i,j,curr,context,prob,skip_right,skip_left,skip_upper,skip_bottom);
/*fprintf(stderr,">>>>>ar_decoder->L:%d,ar_decoder->R:%d\n",ar_decoder->L,ar_decoder->R);*/
#endif
                        if (skip_bottom == v_scan_freq) skip_upper = v_scan_freq;
                        else                            skip_upper = 2*v_scan_freq;
                      }
                   }
                }
           }
        }

	i=0;
	while(alpha_mb_spos_h[i]==1) i++;
	while(alpha_mb_spos_h[i]==0) i++;
	if(i>start_h && hor_res_scan) tmp=start_h;
	else	tmp = i;

#ifdef  _DEBUG_OBSS_
fprintf(stderr,">>>>>k-loop encoding- hor_loop_num=%d\n",hor_loop_num); 
/*getchar();*/
#endif
	while (hor_loop_num>0) {
	   start_v = start_h = 0;
	   h_scan_freq = 1<<hor_loop_num;
	   v_scan_freq = 1<<ver_loop_num;
	   skip_hor = 1<<(hor_loop_num-1);

	   if (tmp-(1<<(hor_loop_num-1))>=0)	tmp = start_h = tmp - (1<<(hor_loop_num-1));
	   else				start_h = tmp + (1<<(hor_loop_num-1));
		
	   i=0;
	   while (alpha_mb_spos_v[i]==0)	i++;
	   start_v = i;

	   for (j=start_h; j<(width-4); j+=h_scan_freq) {
		skip_upper = start_v + 1;
		for (i=start_v; i<(height-4); i+=v_scan_freq) {
		   if (alpha_mb_spos_v[i]==1) {
		      if (i+v_scan_freq > 15) skip_bottom=MB_SIZE+1-i;
		      else {
			  if ( alpha_mb_spos_v[i+v_scan_freq] == 0 ) {
				if (i+v_scan_freq*2 > 15) skip_bottom=MB_SIZE+1-i;
				else			  skip_bottom=v_scan_freq*2;
			  } else	skip_bottom = v_scan_freq;
		      }

		      if (j-skip_hor<0)	skip_left = j+2;
		      else			skip_left = skip_hor;
		      if (j+skip_hor>15)	skip_right = MB_SIZE+1-j;
		      else  		skip_right = skip_hor;

                                
		      context = GetContextSI_VS_AR (smb_data,
                                                                j,
                                                                i,
                                                                skip_right,
                                                                skip_left,
                                                                skip_upper,
                                                                skip_bottom,
                                                                width);
 
		      prob = si_intra_vs_prob[context];
		      curr = ArDecodeSymbol(prob,
							ar_decoder,
							bitstream,
							trace,
							error_flag);

                      *(smb_data+i*width+j) = curr;
#ifdef  _DEBUG_OBSS_
fprintf(stderr,">>>>>(%d,%d):curr=%d, context=%d, prob=%d (skip_right=%d left=%d upper=%d bottom=%d)\n", i,j,curr,context,prob,skip_right,skip_left,skip_upper,skip_bottom);
/*fprintf(stderr,">>>>>ar_decoder->L:%d,ar_decoder->R:%d\n",ar_decoder->L,ar_decoder->R);*/
#endif
		      if (skip_bottom == v_scan_freq)	skip_upper = v_scan_freq;
		      else				skip_upper = 2*v_scan_freq;
		   } 
		}
	   }
	   hor_loop_num--;
	}

#ifdef  _DEBUG_OBSS_
fprintf(stderr,">>>>>Horizontal Scanning\n");
#endif

	if(ver_res_scan) {

#ifdef  _DEBUG_OBSS_
fprintf(stderr,">>>>>residual encoding\n"); 
#endif

	   i=0;
	   while(alpha_mb_spos_v[i]==1) i++;
	   while(alpha_mb_spos_v[i]==0) i++;
	   tmp = i;

	   start_v = start_h = 0;
	   v_scan_freq = 1 << ver_loop_num;
	   h_scan_freq = 1;
	   skip_ver = v_scan_freq;

	   if (tmp-(1<<ver_loop_num)>=0)		start_v = tmp - (1<<ver_loop_num);
	   else if (tmp+(1<<ver_loop_num)<MB_SIZE) 	start_v = tmp + (1<<ver_loop_num);
	   else {
		fprintf(stderr,"Error:out of sampling ratio !\n");
		exit(1);
	   }
	
	   for(i=start_v;i<(height-4);i+=v_scan_freq) {
		if( alpha_mb_spos_v[i]== 0 ) {
                   for(j=start_h;j<(width-4);j+=h_scan_freq) {
   
		      if (i-skip_ver<0)		skip_upper = i+2;
		      else			skip_upper = skip_ver;
		      if (i+skip_ver>15)	skip_bottom = MB_SIZE+1-i;
		      else 	      		skip_bottom = skip_ver;

		      context = GetContextSI_HS_AR (smb_data,
							j,
							i,
							skip_upper,
							skip_bottom,
							width);
			
		      prob = si_intra_hs_prob[context];
		      curr = ArDecodeSymbol(prob,
						ar_decoder,
						bitstream,
						trace,
						error_flag);
#ifdef  _DEBUG_OBSS_
fprintf(stderr,">>>>>(%d,%d):curr=%d, context=%d, prob=%d (skip_upper=%d bottom=%d)\n", i,j,curr,context,prob,skip_upper,skip_bottom);
/*fprintf(stderr,">>>>>ar_decoder->L:%d,ar_decoder->R:%d\n",ar_decoder->L,ar_decoder->R);*/
#endif
                      *(smb_data+i*width+j) = curr;
		   }
		}
	   }
	}

	i=0;
	while(alpha_mb_spos_v[i]==1) i++;
	while(alpha_mb_spos_v[i]==0) i++;
	if(i>start_v && ver_res_scan) tmp=start_v;
	else	tmp = i;

#ifdef  _DEBUG_OBSS_
fprintf(stderr,">>>>>k-loop encoding- ver_loop_num=%d\n",ver_loop_num); 
/*getchar();*/
#endif

	while (ver_loop_num>0) {
	   start_v = start_h = 0;
	   v_scan_freq = 1<<ver_loop_num;
	   h_scan_freq = 1;

	   if (tmp-(1<<(ver_loop_num-1))>=0)	tmp = start_v = tmp - (1<<(ver_loop_num-1));
	   else				start_v = tmp + (1<<(ver_loop_num-1));
	   skip_ver = 1<<(ver_loop_num-1);

	   for (i=start_v; i<(height-4); i+=v_scan_freq) {
	   	for (j=start_h; j<(width-4); j+=h_scan_freq) {

		   if (i-skip_ver<0)	skip_upper = i+2;
		   else			skip_upper = skip_ver;
		   if (i+skip_ver>15)	skip_bottom = MB_SIZE+1-i;
		   else 	     	skip_bottom = skip_ver;

		   context = GetContextSI_HS_AR (smb_data,
							j,
							i,
							skip_upper,
							skip_bottom,
							width);
			
		   prob = si_intra_hs_prob[context];
		   curr = ArDecodeSymbol(prob,
							ar_decoder,
							bitstream,
							trace,
							error_flag);

                   *(smb_data+i*width+j) = curr;

#ifdef  _DEBUG_OBSS_
fprintf(stderr,">>>>>(%d,%d):curr=%d, context=%d, prob=%d (skip_upper=%d bottom=%d)\n", i,j,curr,context,prob,skip_upper,skip_bottom);
/*fprintf(stderr,">>>>>ar_decoder->L:%d,ar_decoder->R:%d\n",ar_decoder->L,ar_decoder->R);*/
#endif

		}
	   }
	   ver_loop_num--;
	}

	return 0;

}



