/******************************************************************************
 *
 * This software module was originally developed by
 *
 *      Ji Heon Kweon (HYUNDAI)
 *
 * in the course of development of the MPEG-4 Video (ISO/IEC 14496-2) standard.
 * This software module is an implementation of a part of one or more MPEG-4
 * Video (ISO/IEC 14496-2) tools as specified by the MPEG-4 Video (ISO/IEC
 * 14496-2) standard.
 *
 * ISO/IEC gives users of the MPEG-4 Video (ISO/IEC 14496-2) standard free
 * license to this software module or modifications thereof for use in hardware
 * or software products claiming conformance to the MPEG-4 Video (ISO/IEC
 * 14496-2) standard.
 *
 * Those intending to use this software module in hardware or software products
 * are advised that its use may infringe existing patents. The original
 * developer of this software module and his/her company, the subsequent
 * editors and their companies, and ISO/IEC have no liability for use of this
 * software module or modifications thereof in an implementation. Copyright is
 * not released for non MPEG-4 Video (ISO/IEC 14496-2) standard conforming
 * products.
 *
 * ACTS-MoMuSys partners retain full right to use the code for his/her own
 * purpose, assign or donate the code to a third party and to inhibit third
 * parties from using the code for non MPEG-4 Video (ISO/IEC 14496-2) standard
 * conforming products. This copyright notice must be included in all copies or
 * derivative works.
 *
 * Copyright (c) 1998
 *
 *****************************************************************************/

/***********************************************************HeaderBegin*******
 *
 * File:        alp_dec_grey.c
 *
 * Author:      HYUNDAI - Ji Hweon Kweon
 * Created:     21-05-98
 *
 * Description:
 *
 * Notes:
 *
 * Modified: 
 * 18.06.98 A. Sandvand: Modified function calls to VlcGetBlock and BlockDequantH263
 * 16.08.99 Shigeru Fukunaga (Oki): added newpred_d.h for NEWPRED
 *
 ***********************************************************HeaderEnd*********/

#include <sys/stat.h>
#include <stdio.h>
#include "mom_bitstream_d.h"
#include "newpred_d.h"	/** added for NEWPRED (Oki) 16-AUG-1999 **/
#include "combined_decode.h"
#include "momusys.h"
#include "mom_access.h"
#include "mom_image.h"
#include "vm_enc_defs.h"
#include "vm_common_defs.h"
#include "mot_est.h"            /* because of MBM_INTRA */
#include "mom_bitstream_i.h"
#include "text_util.h"
#include "text_bits.h"
#include "text_quant.h"
#include "putvlc.h"
#include "text_code_mb.h"
#include "alp_code_grey.h"
#include "zigzag.h"             /* added 14-NOV-1996 MW */
/* 09.02.99 HHI Schueuer */
#include "sadct_bsnrmem.h"
#include "sadct.h"
#include "sadct_s_k.h"
#include "sadct_momusys.h"
#include "sadct_momusys_kaup.h"
#include "sadct_momusys_s_k.h"
/* end HHI */

#define OPAQUE 255
#define MIDOPAQUE 128

Void GetMBgraydata(Int transp_pattern[],
                    Int intra_dcpred_disable,
                    Int quant_step,
                    Bitstream *texture_bits,
                    Int mbnum,
                    Trace *trace,
                    SInt *g_mblock,
                    Int MB_width,
                    Int ***DC_store,
                    SInt *QP_store,
                    Int *error_flag,
                    UInt mode,
                    Vop *rec_vop,
		    Short *alpha)
{
  Int  comp;
  Int  DCT_block[B_SIZE * B_SIZE];
  Int  q_block[B_SIZE * B_SIZE];
  Int  r_block[B_SIZE * B_SIZE];
  Int  r_block_2D[B_SIZE][B_SIZE];
  Int  pcoeff[B_SIZE * B_SIZE];
  Int  pred_DC_coeff;
  Int  x_pos = mbnum % MB_width;
  Int  y_pos = mbnum / MB_width;
  Int  m, n;
  Int  CBPA;
  Int ACpred_flag = -1;
  Int QP;
  /* 09.02.99 HHI Schueuer */
  Int sadct_used = 0;
  UChar disable_sadct = GetVopSADCTDisable(rec_vop);
  /* variables because of contour-adaptive DCT */
  Int i, j;
  Short alpha_block[4][8][8];
  Short nrpix = MB_width * MB_SIZE;
  /* SInt mb_shape[6][64],mb_dct_bf_iq[6][64],mb_dct_iq[6][64],mb_idct[6][64]; */
  /* end HHI */

  /* 09.02.99 HHI Schueuer */
  if (disable_sadct==0) {
    for (i = 0; i < 8; i++) {
      for (j = 0; j < 8; j++) {
	alpha_block[0][i][j] = alpha[(y_pos*MB_SIZE + i)*nrpix + (x_pos*MB_SIZE + j)];
	alpha_block[1][i][j] = alpha[(y_pos*MB_SIZE + i)*nrpix + (x_pos*MB_SIZE + 8 + j)];
	alpha_block[2][i][j] = alpha[(y_pos*MB_SIZE + 8 + i)*nrpix + (x_pos*MB_SIZE + j)];
	alpha_block[3][i][j] = alpha[(y_pos*MB_SIZE + 8 + i)*nrpix + (x_pos*MB_SIZE + 8 + j)];
      }
    }
  }
  
	
  /* end HHI */
      
  

  if ((mode == MODE_INTRA || mode == MODE_INTRA_Q) && (intra_dcpred_disable == 0))
    {
       ACpred_flag = BitstreamReadBits(texture_bits,1,"ACpred_flag",trace,FLAG);
    }


  QP = quant_step;

  g_MBvalue (g_mblock, 0);

  CBPA = VlcDecCBPY (texture_bits, 0, transp_pattern,error_flag, trace);
  if (*error_flag == RETURN)
    {
       printf ("Error decoding CBPA of grayscale alpha block %d\n", (Int)mbnum);
       return;
    }

  /*****
   *
   *      Decoding of the 4 GREY_SCALE blocks (depending on transparent pattern)
   *
   *****/

  if (mode == MODE_INTRA || mode == MODE_INTRA_Q) {
    for (comp=0; comp<4; comp++)
     {   
        Bzero (q_block);
	/* 10.02.99 HHI Schueuer */
	if (!disable_sadct) {
	  sadct_rowlength_out(comp, alpha_block[comp], 8, 8);
	  SADCT_Used_Decision_d (comp, &sadct_used);
	}
	/* end HHI */

        if(transp_pattern[comp]!=1) /* No decoding of transparent Y blocks */
        {

                /* This must be Int not UInt MW 15-NOV-1996 */
                  pred_DC_coeff = DecodePredictedIntraDC(comp,
                                                         texture_bits,
                                                         trace,
                                                         NUM);
                  q_block[0] = pred_DC_coeff;
 
          if ((CBPA>>(3-comp)) & 1) {
 
            VlcGetBlock(texture_bits, q_block, INTRA,
                      trace, error_flag, 1, GetVopReverseVlc(rec_vop),0,0);
          }
 
          /* Do the DC/AC prediction, changing the qcoeff values as
             appropriate */
          if (intra_dcpred_disable == 0)
              doDCACrecon(q_block, 64, DC_store, QP_store, QP,
                          x_pos, y_pos, MB_width, ACpred_flag, 
			  /*GetVopAlternateScan(rec_vop)*/ 0, comp, MIDOPAQUE, sadct_used); /* SB, 08.10.98 */
	  /* 29.01.99 HHI Schueuer */
          else {
	    
	    /* Ordinary inverse zigzag-scanning */
	    /* 10.02.99 HHI Schueuer */
	    if (sadct_used == 0) {
	      for (m = 0; m < 64; m++)
		pcoeff[m] = q_block[zigzag[m]];
	    }
	    else {
	      SADCT_Inverse_Scan(q_block, pcoeff, comp, 0);
	    }
	    for (m = 0; m < 8; m++)
	      for (n = 0; n < 8; n++)
		q_block[m*8+n] = pcoeff[m*8+n];
 
          }
 
          /* Store the qcoeff-values needed later for prediction */
          DC_store[mbnum][comp][0] = q_block[0]*cal_dc_scaler(QP,1);
 
          for (m = 1; m < 8; m++)
            DC_store[mbnum][comp][m] = q_block[m];

          for (m = 0; m < 7; m++)
            DC_store[mbnum][comp][m+8] = q_block[(m+1)*8];
   
 
              /* MW 22-APR-1997 Changes for MPEG dequantization */
          if(GetVopQuantType(rec_vop))
            BlockDequantMPEG(q_block,quant_step,INTRA,1,
                             GetVopIntraQuantMat(rec_vop),DCT_block,2);
          else
            BlockDequantH263(q_block,quant_step,INTRA,1,DCT_block,2,0, GetVopBitsPerPixel(rec_vop));

	  /* 10.02.99 HHI Schueuer */
	  if ( disable_sadct || (sadct_used == 0))
	    BlockIDCT(DCT_block, r_block_2D, OPAQUE);
	  else
	    BlockSAIDCT_s_k(DCT_block, r_block_2D, alpha_block[comp]);
 
          for (m = 0; m < B_SIZE; m++)
            for (n = 0; n < B_SIZE; n++)
              r_block[m*B_SIZE+n] = r_block_2D[m][n];
 
        }
      else /* clear r_block if transparent block */
        {
          Bzero(r_block);
 
          /* Fill DC_store with default coeff values */
          DC_store[mbnum][comp][0] = MIDOPAQUE*8;
          for(n=1; n<15; n++)
            DC_store[mbnum][comp][n] = 0;
        }
         
      PutBlockG (comp, r_block, g_mblock);
    }
  }  
  else /* MODE INTER */
    {
      for (comp=0; comp<4; comp++) {
 
	Bzero (q_block);

	/* 10.02.99 HHI Schueuer */
	if (!disable_sadct) {
	  sadct_rowlength_out(comp, alpha_block[comp], 8, 8);
	  SADCT_Used_Decision_d (comp, &sadct_used);
	}
	/* end HHI */
 
	if(transp_pattern[comp]!=1) { /* No decoding of transparent Y blocks */
	  if ((CBPA>>(3-comp)) & 1) {
	    VlcGetBlock (texture_bits, q_block, INTER, trace,
			 error_flag, 0, GetVopReverseVlc(rec_vop),0,0);
	  }
 
	  /* Inverse zigzag-scanning also here 12-11-96 MW */
	  /* 10.02.99 HHI Schueuer */
	  if (sadct_used == 0) {
	    for (m = 0; m < 64; m++)
	      pcoeff[m] = q_block[zigzag[m]];
	  }
	  else {
	    SADCT_Inverse_Scan(q_block, pcoeff, comp, 0);
	  }
 
	  for (m = 0; m < 8; m++)
	    for (n = 0; n < 8; n++)
	      q_block[m*8+n] = pcoeff[m*8+n];
 
	  /* Fill DC_store with default coeff values */
	  DC_store[mbnum][comp][0] = MIDOPAQUE*8;
	  for (n = 1; n < 15; n++)
	    DC_store[mbnum][comp][n] = 0;
 
	  /* MW 22-APR-1997 Changes for MPEG dequantization */
	  if(GetVopQuantType(rec_vop))
	    BlockDequantMPEG(q_block,quant_step,INTER,1,
                       GetVopNonintraQuantMat(rec_vop),DCT_block,2);
	  else
	    BlockDequantH263(q_block,quant_step,INTER,1,DCT_block,2,0, GetVopBitsPerPixel(rec_vop));

	  /* 10.02.99 HHI Berlin */
	  if (disable_sadct || (sadct_used == 0))
	    BlockIDCT(DCT_block, r_block_2D, OPAQUE);
	  else
	    BlockSAIDCT_Kaup (DCT_block, r_block_2D, alpha_block[comp]);
	  /* end HHI */
 
	  for (m = 0; m < B_SIZE; m++)
	    for (n = 0; n < B_SIZE; n++)
	      r_block[m*B_SIZE+n] = r_block_2D[m][n];
	}
	else /* clear r_block if transparent block */
	  {  
	    Bzero(r_block);
 
	    /* Fill DC_store with default coeff values */
	    DC_store[mbnum][comp][0] = MIDOPAQUE*8;
	    for(n=1; n<15; n++)
	      DC_store[mbnum][comp][n] = 0;
	  }
       
	PutBlockG (comp, r_block, g_mblock);
      }
    }
 
  if ((mode == MODE_INTRA)||(mode == MODE_INTRA_Q))
      g_MB_clip (g_mblock);
}                               /* GetMBgraydata */
 
 
Void B_GetMBgraydata(Int transp_pattern[],
                    Int quant_step,
                    Bitstream *texture_bits,
                    Int mbnum,
                    Trace *trace,
                    SInt *g_mblock,
                    Int MB_width,
                    Int *error_flag,
                    Vop *rec_vop,
		    Short *alpha)
{
  Int  comp;
  Int  DCT_block[B_SIZE * B_SIZE];
  Int  q_block[B_SIZE * B_SIZE];
  Int  r_block[B_SIZE * B_SIZE];
  Int  r_block_2D[B_SIZE][B_SIZE];
  Int  pcoeff[B_SIZE * B_SIZE];
  Int  m, n;
  Int  CBPA;
  /* 10.02.99 HHI Schueuer */
  Int sadct_used = 0;
  UChar disable_sadct = GetVopSADCTDisable(rec_vop);
  /* variables because of SA-DCT */
  Int  x_pos = mbnum % MB_width;
  Int  y_pos = mbnum / MB_width;
  Int i, j;
  Short alpha_block[4][8][8];
  Short nrpix = MB_width * MB_SIZE;
  /* SInt mb_shape[6][64],mb_dct_bf_iq[6][64],mb_dct_iq[6][64],mb_idct[6][64]; */
  /* end HHI */

  /* 09.02.99 HHI Schueuer */
  if (disable_sadct==0) {
    for (i = 0; i < 8; i++) {
      for (j = 0; j < 8; j++) {
	alpha_block[0][i][j] = alpha[(y_pos*MB_SIZE + i)*nrpix + (x_pos*MB_SIZE + j)];
	alpha_block[1][i][j] = alpha[(y_pos*MB_SIZE + i)*nrpix + (x_pos*MB_SIZE + 8 + j)];
	alpha_block[2][i][j] = alpha[(y_pos*MB_SIZE + 8 + i)*nrpix + (x_pos*MB_SIZE + j)];
	alpha_block[3][i][j] = alpha[(y_pos*MB_SIZE + 8 + i)*nrpix + (x_pos*MB_SIZE + 8 + j)];
      }
    }
  }
  /* end HHI */  
  
  g_MBvalue (g_mblock, 0);
 
  CBPA = VlcDecCBPY (texture_bits, 0, transp_pattern,error_flag, trace);
  if (*error_flag == RETURN)
    {
       printf ("Error decoding CBPA of grayscale alpha block %d\n", (Int)mbnum);
       return;
    }
 
  /*****
   *
   *      Decoding of the 4 GREY_SCALE blocks (depending on transparent pattern)
   *
   *****/
 
 
  for (comp=0; comp<4; comp++) {
 
      Bzero (q_block);

      /* 10.02.99 HHI Schueuer */
      if (!disable_sadct) {
	sadct_rowlength_out(comp, alpha_block[comp], 8, 8);
	SADCT_Used_Decision_d (comp, &sadct_used);
      }
      /* end HHI */
 
      if(transp_pattern[comp]!=1) { /* No decoding of transparent Y blocks */
        if ((CBPA>>(3-comp)) & 1) {
           VlcGetBlock (texture_bits, q_block, INTER, trace,
                        error_flag, 0, GetVopReverseVlc(rec_vop),0,0);
        }
 
      /* Inverse zigzag-scanning also here 12-11-96 MW */
	/* 10.02.99 HHI Schueuer */
	if (sadct_used == 0) {
	  for (m = 0; m < 64; m++)
	    pcoeff[m] = q_block[zigzag[m]];
	}
	else {
	  SADCT_Inverse_Scan(q_block, pcoeff, comp, 0);
	}
 
	for (m = 0; m < 8; m++)
	  for (n = 0; n < 8; n++)
	    q_block[m*8+n] = pcoeff[m*8+n];
 
	/* MW 22-APR-1997 Changes for MPEG dequantization */
	if(GetVopQuantType(rec_vop))
	  BlockDequantMPEG(q_block,quant_step,INTER,1,
			   GetVopNonintraQuantMat(rec_vop),DCT_block,2);
	else
	  BlockDequantH263(q_block,quant_step,INTER,1,DCT_block,2,0, GetVopBitsPerPixel(rec_vop));

	/* 10.02.99 HHI Berlin */
	if (disable_sadct || (sadct_used == 0))
	  BlockIDCT(DCT_block, r_block_2D, OPAQUE);
	else
	  BlockSAIDCT_Kaup (DCT_block, r_block_2D, alpha_block[comp]);
	/* end HHI */
 
	for (m = 0; m < B_SIZE; m++)
	  for (n = 0; n < B_SIZE; n++)
	    r_block[m*B_SIZE+n] = r_block_2D[m][n];
      }
      else /* clear r_block if transparent block */
	Bzero(r_block);
      
      
      PutBlockG (comp, r_block, g_mblock);
  }
}                               /* GetMBgraydata */
