/*****************************************************************************
 *
 * This software module was originally developed by
 *
 *   Karl Lillevold (Telenor / ACTS-MoMuSyS)
 *
 * and edited by
 * 
 *   Paulo Nunes (IST / ACTS-MoMuSyS)
 *
 * in the course of development of the MPEG-4 Video (ISO/IEC 14496-2) standard.
 * This software module is an implementation of a part of one or more MPEG-4
 * Video (ISO/IEC 14496-2) tools as specified by the MPEG-4 Video (ISO/IEC
 * 14496-2) standard.
 *
 * ISO/IEC gives users of the MPEG-4 Video (ISO/IEC 14496-2) standard free
 * license to this software module or modifications thereof for use in hardware
 * or software products claiming conformance to the MPEG-4 Video (ISO/IEC
 * 14496-2) standard.
 *
 * Those intending to use this software module in hardware or software products
 * are advised that its use may infringe existing patents. The original
 * developer of this software module and his/her company, the subsequent
 * editors and their companies, and ISO/IEC have no liability for use of this
 * software module or modifications thereof in an implementation. Copyright is
 * not released for non MPEG-4 Video (ISO/IEC 14496-2) Standard conforming
 * products.
 *
 * ACTS-MoMuSys partners retain full right to use the code for his/her own
 * purpose, assign or donate the code to a third party and to inhibit third
 * parties from using the code for non MPEG-4 Video (ISO/IEC 14496-2) Standard
 * conforming products. This copyright notice must be included in all copies or
 * derivative works.
 *
 * Copyright (c) 1996
 *
 *****************************************************************************/

/***********************************************************HeaderBegin*******
 *                                                                         
 * File:	text_decode.h
 *
 * Author:	
 * Created:	
 *                                                                         
 * Description: 
 *
 * Notes:	based on tmndecode 
 * 		Written by Karl Olav Lillevold <kol@nta.no>,
 *		1995 Telenor R&D.
 * 		Donated to the Momusys-project as background code by
 *		Telenor. 
 *
 *		based on mpeg2decode, (C) 1994, MPEG Software Simulation
 *		Group and mpeg2play, (C) 1994 Stefan Eckart 
 *                         <stefan@lis.e-technik.tu-muenchen.de>
 *
 *
 * Modified:	9-May-96 Paulo Nunes: Reformatted. New headers.
 *
 ***********************************************************HeaderEnd*********/
/************************    INCLUDE FILES    ********************************/

#ifndef _TEXT_DECODE_H_
#define _TEXT_DECODE_H_

#include "momusys.h"
#include "mom_bitstream_d.h"

#define mmax(a, b)  	((a) > (b) ? (a) : (b))
#define mmin(a, b)  	((a) < (b) ? (a) : (b))
#define mnint(a)        ((a) < 0 ? (Int)(a - 0.5) : (Int)(a + 0.5))


#define RETURN 				1


#include "vm_dec_defs.h"

#define BLOCK_CNT			6

#define ESCAPE                          7167
#define ESCAPE_INDEX                    102

#define INTER                       1
#define INTRA                       0
#define ON                              1
#define OFF                             0

#define B_SIZE				8

#include "mot_decode.h"
#include "text_util.h"
#include "text_decode_mb.h"

#include "text_decode.p"

#endif /* _TEXTDEC_H_ */
