/****************************************************************************/
/*   MPEG4 Visual Texture Coding (VTC) Mode Software                        */
/*                                                                          */
/*   This software was jointly developed by the following participants:     */
/*                                                                          */
/* In the course of development of the MPEG-4 standard, this software       */
/* module is an implementation of a part of one or more MPEG-4 tools as     */
/* specified by the MPEG-4 standard.                                        */
/*                                                                          */
/* The copyright of this software belongs to ISO/IEC. ISO/IEC gives use     */
/* of the MPEG-4 standard free license to use this  software module or      */
/* modifications thereof for hardware or software products claiming         */
/* conformance to the MPEG-4 standard.                                      */
/*                                                                          */
/* Those intending to use this software module in hardware or software      */
/* products are advised that use may infringe existing  patents. The        */
/* original developers of this software module and their companies, the     */
/* subsequent editors and their companies, and ISO/IEC have no liability    */
/* and ISO/IEC have no liability for use of this software module or         */
/* modification thereof in an implementation.                               */
/*                                                                          */
/* Permission is granted to MPEG members to use, copy, modify,              */
/* and distribute the software modules ( or portions thereof )              */
/* for standardization activity within ISO/IEC JTC1/SC29/WG11.              */
/*                                                                          */
/* Copyright 1995, 1996, 1997, 1998, 1999 ISO/IEC                           */
/****************************************************************************/

#include	<limits.h>
#include        "momusys.h"
#include        "shape_def.h"

/**************  Code Book for shape MMR coding  ******************/

Int		LMMR_first_shape_code_I [81][3] = {
	{ 1, 2, 2 },	{ 2, 2, 1 },	{ 2, 2, 1 },/*0*/
	{ 1, 2, 2 },	{ 1, 2, 2 },	{ 1, 2, 2 },/*1*/
	{ 1, 2, 2 },	{ 1, 2, 2 },	{ 2, 2, 1 },/*2*/
	{ 2, 2, 1 },	{ 1, 2, 2 },	{ 1, 2, 2 },/*3*/
	{ 2, 2, 1 },	{ 1, 2, 2 },	{ 2, 1, 2 },/*4*/
	{ 2, 2, 1 },	{ 1, 2, 2 },	{ 1, 2, 2 },/*5*/
	{ 2, 2, 1 },	{ 1, 2, 2 },	{ 2, 2, 1 },/*6*/
	{ 2, 2, 1 },	{ 1, 2, 2 },	{ 2, 2, 1 },/*7*/
	{ 2, 2, 1 },	{ 2, 2, 1 },	{ 2, 2, 1 },/*8*/
	{ 1, 2, 2 },	{ 1, 2, 2 },	{ 1, 2, 2 },/*9*/
	{ 1, 2, 2 },	{ 1, 2, 2 },	{ 1, 2, 2 },/*10*/
	{ 1, 2, 2 },	{ 1, 2, 2 },	{ 2, 2, 1 },/*11*/
	{ 1, 2, 2 },	{ 2, 2, 1 },	{ 2, 2, 1 },/*12*/
	{ 1, 2, 2 },	{ 2, 1, 2 },	{ 2, 2, 1 },/*13*/
	{ 1, 2, 2 },	{ 2, 1, 2 },	{ 2, 2, 1 },/*14*/
	{ 1, 2, 2 },	{ 2, 2, 1 },	{ 2, 2, 1 },/*15*/
	{ 1, 2, 2 },	{ 2, 2, 1 },	{ 2, 2, 1 },/*16*/
	{ 1, 2, 2 },	{ 2, 1, 2 },	{ 2, 2, 1 },/*17*/
	{ 1, 2, 2 },	{ 2, 2, 1 },	{ 2, 2, 1 },/*18*/
	{ 1, 2, 2 },	{ 1, 2, 2 },	{ 1, 2, 2 },/*19*/
	{ 1, 2, 2 },	{ 1, 2, 2 },	{ 2, 2, 1 },/*20*/
	{ 1, 2, 2 },	{ 2, 2, 1 },	{ 2, 2, 1 },/*21*/
	{ 2, 2, 1 },	{ 2, 1, 2 },	{ 2, 1, 2 },/*22*/
	{ 2, 2, 1 },	{ 2, 1, 2 },	{ 2, 2, 1 },/*23*/
	{ 1, 2, 2 },	{ 2, 2, 1 },	{ 2, 2, 1 },/*24*/
	{ 2, 2, 1 },	{ 2, 1, 2 },	{ 2, 2, 1 },/*25*/
	{ 1, 2, 2 },	{ 2, 1, 2 },	{ 2, 2, 1 },/*26*/
};

U_Int	CMMR_first_shape_code_I [81][3] = {
	{ 0, 3, 2 },	{ 3, 2, 0 },	{ 2, 3, 0 },/*0*/
	{ 0, 3, 2 },	{ 0, 2, 3 },	{ 0, 2, 3 },/*1*/
	{ 0, 3, 2 },	{ 0, 2, 3 },	{ 2, 3, 0 },/*2*/
	{ 3, 2, 0 },	{ 0, 2, 3 },	{ 0, 2, 3 },/*3*/
	{ 3, 2, 0 },	{ 0, 2, 3 },	{ 2, 0, 3 },/*4*/
	{ 3, 2, 0 },	{ 0, 2, 3 },	{ 0, 2, 3 },/*5*/
	{ 2, 3, 0 },	{ 0, 2, 3 },	{ 3, 2, 0 },/*6*/
	{ 2, 3, 0 },	{ 0, 2, 3 },	{ 3, 2, 0 },/*7*/
	{ 2, 3, 0 },	{ 3, 2, 0 },	{ 3, 2, 0 },/*8*/
	{ 0, 2, 3 },	{ 0, 2, 3 },	{ 0, 2, 3 },/*9*/
	{ 0, 2, 3 },	{ 0, 2, 3 },	{ 0, 2, 3 },/*10*/
	{ 0, 2, 3 },	{ 0, 2, 3 },	{ 3, 2, 0 },/*11*/
	{ 0, 2, 3 },	{ 3, 2, 0 },	{ 3, 2, 0 },/*12*/
	{ 0, 2, 3 },	{ 3, 0, 2 },	{ 3, 2, 0 },/*13*/
	{ 0, 2, 3 },	{ 3, 0, 2 },	{ 3, 2, 0 },/*14*/
	{ 0, 2, 3 },	{ 3, 2, 0 },	{ 2, 3, 0 },/*15*/
	{ 0, 2, 3 },	{ 3, 2, 0 },	{ 2, 3, 0 },/*16*/
	{ 0, 3, 2 },	{ 3, 0, 2 },	{ 2, 3, 0 },/*17*/
	{ 0, 3, 2 },	{ 2, 3, 0 },	{ 2, 3, 0 },/*18*/
	{ 0, 2, 3 },	{ 0, 2, 3 },	{ 0, 2, 3 },/*19*/
	{ 0, 2, 3 },	{ 0, 2, 3 },	{ 2, 3, 0 },/*20*/
	{ 0, 2, 3 },	{ 3, 2, 0 },	{ 3, 2, 0 },/*21*/
	{ 2, 3, 0 },	{ 3, 0, 2 },	{ 3, 0, 2 },/*22*/
	{ 2, 3, 0 },	{ 3, 0, 2 },	{ 3, 2, 0 },/*23*/
	{ 0, 3, 2 },	{ 3, 2, 0 },	{ 2, 3, 0 },/*24*/
	{ 2, 3, 0 },	{ 3, 0, 2 },	{ 3, 2, 0 },/*25*/
	{ 0, 3, 2 },	{ 3, 0, 2 },	{ 3, 2, 0 },/*26*/
};

Int LCR[5] = { 0, 1, 2, 0, 2 };
U_Int CCR[5]= { 0x00, 0x00, 0x02, 0x00, 0x03 };
Int LST = 1;

/*  Probability Tables for Shape Coding (CAE)  */

U_Int	intra_prob[1024] = {
65267, 16468, 65003, 17912, 64573,  8556, 64252,  5653,
40174,  3932, 29789,   277, 45152,  1140, 32768,  2043,
 4499,    80,  6554,  1144, 21065,   465, 32768,   799,
 5482,   183,  7282,   264,  5336,    99,  6554,   563,
54784, 30201, 58254,  9879, 54613,  3069, 32768, 58495,
32768,32768,32768,2849,58982,54613,32768,12892,
31006,1332,49152,3287,60075,350,32768,712,
39322,760,32768,354,52659,432,61854,150,
64999,28362,65323,42521,63572,32768,63677,18319,
4910,32768,64238,434,53248,32768,61865,13590,
16384,32768,13107,333,32768,32768,32768,32768,
32768,32768,1074,780,25058,5461,6697,233,
62949,30247,63702,24638,59578,32768,32768,42257,
32768,32768,49152,546,62557,32768,54613,19258,
62405,32569,64600,865,60495,10923,32768,898,
34193,24576,64111,341,47492,5231,55474,591,
65114,60075,64080,5334,65448,61882,64543,13209,
54906,16384,35289,4933,48645,9614,55351,7318,
49807,54613,32768,32768,50972,32768,32768,32768,
15159,1928,2048,171,3093,8,6096,74,
32768,60855,32768,32768,32768,32768,32768,32768,
32768,32768,32768,32768,32768,55454,32768,57672,
32768,16384,32768,21845,32768,32768,32768,32768,
32768,32768,32768,5041,28440,91,32768,45,
65124,10923,64874,5041,65429,57344,63435,48060,
61440,32768,63488,24887,59688,3277,63918,14021,
32768,32768,32768,32768,32768,32768,32768,32768,
690,32768,32768,1456,32768,32768,8192,728,
32768,32768,58982,17944,65237,54613,32768,2242,
32768,32768,32768,42130,49152,57344,58254,16740,
32768,10923,54613,182,32768,32768,32768,7282,
49152,32768,32768,5041,63295,1394,55188,77,
63672,6554,54613,49152,64558,32768,32768,5461,
64142,32768,32768,32768,62415,32768,32768,16384,
1481,438,19661,840,33654,3121,64425,6554,
4178,2048,32768,2260,5226,1680,32768,565,
60075,32768,32768,32768,32768,32768,32768,32768,
32768,32768,32768,32768,32768,32768,32768,32768,
16384,261,32768,412,16384,636,32768,4369,
23406,4328,32768,524,15604,560,32768,676,
49152,32768,49152,32768,32768,32768,64572,32768,
32768,32768,54613,32768,32768,32768,32768,32768,
4681,32768,5617,851,32768,32768,59578,32768,
32768,32768,3121,3121,49152,32768,6554,10923,
32768,32768,54613,14043,32768,32768,32768,3449,
32768,32768,32768,32768,32768,32768,32768,32768,
57344,32768,57344,3449,32768,32768,32768,3855,
58982,10923,32768,239,62259,32768,49152,85,
58778,23831,62888,20922,64311,8192,60075,575,
59714,32768,57344,40960,62107,4096,61943,3921,
39862,15338,32768,1524,45123,5958,32768,58982,
6669,930,1170,1043,7385,44,8813,5011,
59578,29789,54613,32768,32768,32768,32768,32768,
32768,32768,32768,32768,58254,56174,32768,32768,
64080,25891,49152,22528,32768,2731,32768,10923,
10923,3283,32768,1748,17827,77,32768,108,
62805,32768,62013,42612,32768,32768,61681,16384,
58982,60075,62313,58982,65279,58982,62694,62174,
32768,32768,10923,950,32768,32768,32768,32768,
5958,32768,38551,1092,11012,39322,13705,2072,
54613,32768,32768,11398,32768,32768,32768,145,
32768,32768,32768,29789,60855,32768,61681,54792,
32768,32768,32768,17348,32768,32768,32768,8192,
57344,16384,32768,3582,52581,580,24030,303,
62673,37266,65374,6197,62017,32768,49152,299,
54613,32768,32768,32768,35234,119,32768,3855,
31949,32768,32768,49152,16384,32768,32768,32768,
24576,32768,49152,32768,17476,32768,32768,57445,
51200,50864,54613,27949,60075,20480,32768,57344,
32768,32768,32768,32768,32768,45875,32768,32768,
11498,3244,24576,482,16384,1150,32768,16384,
7992,215,32768,1150,23593,927,32768,993,
65353,32768,65465,46741,41870,32768,64596,59578,
62087,32768,12619,23406,11833,32768,47720,17476,
32768,32768,2621,6554,32768,32768,32768,32768,
32768,32768,5041,32768,16384,32768,4096,2731,
63212,43526,65442,47124,65410,35747,60304,55858,
60855,58982,60075,19859,35747,63015,64470,25432,
58689,1118,64717,1339,24576,32768,32768,1257,
53297,1928,32768,33,52067,3511,62861,453,
64613,32768,32768,32768,64558,32768,32768,2731,
49152,32768,32768,32768,61534,32768,32768,35747,
32768,32768,32768,32768,13107,32768,32768,32768,
32768,32768,32768,32768,20480,32768,32768,32768,
32768,32768,32768,54613,40960,5041,32768,32768,
32768,32768,32768,3277,64263,57592,32768,3121,
32768,32768,32768,32768,32768,10923,32768,32768,
32768,8192,32768,32768,5461,6899,32768,1725,
63351,3855,63608,29127,62415,7282,64626,60855,
32768,32768,60075,5958,44961,32768,61866,53718,
32768,32768,32768,32768,32768,32768,6554,32768,
32768,32768,32768,32768,2521,978,32768,1489,
58254,32768,58982,61745,21845,32768,54613,58655,
60075,32768,49152,16274,50412,64344,61643,43987,
32768,32768,32768,1638,32768,32768,32768,24966,
54613,32768,32768,2427,46951,32768,17970,654,
65385,27307,60075,26472,64479,32768,32768,4681,
61895,32768,32768,16384,58254,32768,32768,6554,
37630,3277,54613,6554,4965,5958,4681,32768,
42765,16384,32768,21845,22827,16384,32768,6554,
65297,64769,60855,12743,63195,16384,32768,37942,
32768,32768,32768,32768,60075,32768,62087,54613,
41764,2161,21845,1836,17284,5424,10923,1680,
11019,555,32768,431,39819,907,32768,171,
65480,32768,64435,33803,2595,32768,57041,32768,
61167,32768,32768,32768,32768,32768,32768,1796,
60855,32768,17246,978,32768,32768,8192,32768,
32768,32768,14043,2849,32768,2979,6554,6554,
65507,62415,65384,61891,65273,58982,65461,55097,
32768,32768,32768,55606,32768,2979,3745,16913,
61885,13827,60893,12196,60855,53248,51493,11243,
56656,783,55563,143,63432,7106,52429,445,
65485,1031,65020,1380,65180,57344,65162,36536,
61154,6554,26569,2341,63593,3449,65102,533,
47827,2913,57344,3449,35688,1337,32768,22938,
25012,910,7944,1008,29319,607,64466,4202,
64549,57301,49152,20025,63351,61167,32768,45542,
58982,14564,32768,9362,61895,44840,32768,26385,
59664,17135,60855,13291,40050,12252,32768,7816,
25798,1850,60495,2662,18707,122,52538,231,
65332,32768,65210,21693,65113,6554,65141,39667,
62259,32768,22258,1337,63636,32768,64255,52429,
60362,32768,6780,819,16384,32768,16384,4681,
49152,32768,8985,2521,24410,683,21535,16585,
65416,46091,65292,58328,64626,32768,65016,39897,
62687,47332,62805,28948,64284,53620,52870,49567,
65032,31174,63022,28312,64299,46811,48009,31453,
61207,7077,50299,1514,60047,2634,46488,235
};

/* SAIT_V2 begin : added by Samsung AIT (99/02/23) */

/*  Probability Tables for Enhancement Layer Shape Coding (SI)  */
/* Proability Tables for Shape Mode Coding */
U_Int	SI_bab_type_prob[1] = {59808};	/* for odd filter */
U_Int	sto_SI_bab_type_prob_even[1] = {44651};

/* Probability Tables of Context for Transitional BAB */
/* Vertical Scanning Case of SI */
U_Int si_intra_vs_prob[128] = {
65476,64428,62211,63560,52253,58271,38098,31981, 
50087,41042,54620,31532,8382,10754,3844,6917, 
63834,50444,50140,63043,58093,45146,36768,13351, 
17594,28777,39830,38719,9768,21447,12340,9786, 
60461,41489,27433,53893,47246,11415,13754,24965,
51620,28011,11973,29709,13878,22794,24385,1558, 
57065,41918,25259,55117,48064,12960,19929,5937, 
25730,22366,5204,32865,3415,14814,6634,1155, 
64444,62907,56337,63144,38112,56527,40247,37088, 
60326,45675,51248,15151,18868,43723,14757,11721,
62436,50971,51738,59767,49927,50675,38182,24724, 
48447,47316,56628,36336,12264,25893,24243,5358, 
58717,56646,48302,60515,36497,26959,43579,40280, 
54092,20741,10891,7504,8109,30840,6772,4090, 
59810,61410,53216,64127,32344,12462,23132,19270,
32232,24774,9615,17750,1714,6539,3237,152 
};

/* Horizontal Scanning Case of SI */
U_Int si_intra_hs_prob[128] = {
65510,63321,63851,62223,64959,62202,63637,48019, 
57072,33553,37041,9527,53190,50479,54232,12855, 
62779,63980,49604,31847,57591,64385,40657,8402, 
33878,54743,17873,8707,34470,54322,16702,2192, 
58325,48447,7345,31317,45687,44236,16685,24144, 
34327,18724,10591,24965,9247,7281,3144,5921, 
59349,33539,11447,5543,58082,48995,35630,10653,  
7123,15893,23830,800,3491,15792,8930,905, 
65209,63939,52634,62194,64937,53948,60081,46851, 
56157,50930,35498,24655,56331,59318,32209,6872, 
59172,64273,46724,41200,53619,59022,37941,20529, 
55026,52858,26402,45073,57740,55485,20533,6288, 
64286,55438,16454,55656,61175,45874,28536,53762, 
58056,21895,5482,39352,32635,21633,2137,4016, 
58490,14100,18724,10461,53459,15490,57992,15128, 
12034,4340,6761,1859,5794,6785,2412,35
};

/* Probability Tables of Context for Exceptional BAB */
U_Int sto_enh_odd_prob0[256]={
65536,65536,65536,65536,65536,65536,65536,65536,
25682,29649,83,1096,28876,19253,2320,292,
65536,65536,65536,65536,65536,65536,65536,65536,
20597,40071,1,1476,6971,9466,4033,314,
65536,65536,65536,65536,65536,65536,65536,65536,
34822,58944,1049,888,47296,38677,478,14,
65536,65536,65536,65536,65536,65536,65536,65536,
21384,35003,26,7,9600,13044,44,1,
65536,65536,65536,65536,65536,65536,65536,65536,
66,13653,1,1,25105,19008,285,31,
65536,65536,65536,65536,65536,65536,65536,65536,
1057,27888,1,2521,4252,15367,1,751,
65536,65536,65536,65536,65536,65536,65536,65536,
290,17476,1,1,8625,20056,121,3,
65536,65536,65536,65536,65536,65536,65536,65536,
1960,15984,1,1,4747,16480,110,9,
65536,65536,65536,65536,65536,65536,65536,65536,
87,140,1,55,1205,1864,1,1,
65536,65536,65536,65536,65536,65536,65536,65536,
549,2823,1,1,1902,782,1285,130,
65536,65536,65536,65536,65536,65536,65536,65536,
290,6665,1,1,15984,8656,1,244,
65536,65536,65536,65536,65536,65536,65536,65536,
63,2114,1,3,2138,1560,69,1,
65536,65536,65536,65536,65536,65536,65536,65536,
1,3178,1,218,160,66,1,2,
65536,65536,65536,65536,65536,65536,65536,65536,
35,7047,366,180,34,113,1,9,
65536,65536,65536,65536,65536,65536,65536,65536,
837,15124,1,1,5571,3236,1,2,
65536,65536,65536,65536,65536,65536,65536,65536,
14,1538,1,14,31,115,1,1
};

U_Int sto_enh_even_prob0[256]={
65536,65536,65536,65536,65536,65536,65536,65536,
25542,38525,48333,53517,26541,23214,61559,59853,
65536,65536,65536,65536,65536,65536,65536,65536, 
7151,31006,33480,29879,2609,4142,16384,11884, 
65536,65536,65536,65536,65536,65536,65536,65536, 
44817,65535,56097,64984,40735,47710,43386,52046, 
65536,65536,65536,65536,65536,65536,65536,65536, 
17545,29626,37308,42263,4196,13552,7199,7230, 
65536,65536,65536,65536,65536,65536,65536,65536, 
1,1,1,39322,13578,17416,29218,31831, 
65536,65536,65536,65536,65536,65536,65536,65536, 
1311,65535,32768,7282,1,3048,25206,19935, 
65536,65536,65536,65536,65536,65536,65536,65536, 
1,32768,17873,61861,3417,14895,4541,5293, 
65536,65536,65536,65536,65536,65536,65536,65536, 
4819,32768,39950,43523,1148,4021,12072,5436, 
65536,65536,65536,65536,65536,65536,65536,65536, 
1,1,134,1,1,55,5461,2849, 
65536,65536,65536,65536,65536,65536,65536,65536, 
24,5243,590,1079,86,95,14564,7159, 
65536,65536,65536,65536,65536,65536,65536,65536, 
328,1,2564,14919,21845,1,9362,15880, 
65536,65536,65536,65536,65536,65536,65536,65536, 
43,362,150,1179,752,529,683,331, 
65536,65536,65536,65536,65536,65536,65536,65536, 
1,1,700,862,25,24,1317,558, 
65536,65536,65536,65536,65536,65536,65536,65536, 
1,1,1,172,2,4,793,342, 
65536,65536,65536,65536,65536,65536,65536,65536,
572,1,1928,43080,3337,1680,1401,2131, 
65536,65536,65536,65536,65536,65536,65536,65536,
18,1,366,7456,8,18,40,8};

U_Int sto_enh_odd_prob1[256]={
65536,65536,54236,62309,65536,65536,39146,32459,
0,0,0,0,0,0,0,0,
65536,65536,3293,20806,65536,65536,20132,22080, 
0,0,0,0,0,0,0,0,
65536,65536,62837,40750,65536,65536,36528,20960,
0,0,0,0,0,0,0,0,
65536,65536,46875,21025,65536,65536,35747,30778,
0,0,0,0,0,0,0,0,
65536,65536,63956,52735,65536,65536,32974,6233,
0,0,0,0,0,0,0,0,
65536,65536,39449,40885,65536,65536,23406,10898,
0,0,0,0,0,0,0,0,
65536,65536,62156,12655,65536,65536,23973,3451,
0,0,0,0,0,0,0,0,
65536,65536,31892,3756,65536,65536,24045,14281,
0,0,0,0,0,0,0,0,
65537,65537,65537,65537,65537,65537,65537,65537, 
51966,33057,1,6782,62238,32046,5919,418, 
65537,65537,65537,65537,65537,65537,65537,65537, 
64435,18941,1224,7203,52134,4674,6753,1113, 
65537,65537,65537,65537,65537,65537,65537,65537, 
62703,34133,16705,28007,31477,15453,21558,6073, 
65537,65537,65537,65537,65537,65537,65537,65537, 
61951,29954,4826,6481,12288,2410,4466,228, 
65537,65537,65537,65537,65537,65537,65537,65537, 
1789,23069,726,7470,30386,26721,9811,1446, 
65537,65537,65537,65537,65537,65537,65537,65537, 
45333,28672,21363,26870,41125,9455,25752,12372, 
65537,65537,65537,65537,65537,65537,65537,65537, 
46324,37071,4994,5136,18879,28687,9330,366, 
65537,65537,65537,65537,65537,65537,65537,65537, 
31745,26116,346,397,2900,13830,361,8
};

U_Int sto_enh_even_prob1[256]={
65536,65536,65536,65536,65536,65536,65536,65536,
0,0,0,0,0,0,0,0,
65536,65536,65536,65536,65536,65536,65536,65536,
0,0,0,0,0,0,0,0,
65536,65536,65536,65536,65536,65536,65536,65536,
0,0,0,0,0,0,0,0,
65536,65536,65536,65536,65536,65536,65536,65536,
0,0,0,0,0,0,0,0,
65536,65536,65536,65536,65536,65536,65536,65536,
0,0,0,0,0,0,0,0,
65536,65536,65536,65536,65536,65536,65536,65536,
0,0,0,0,0,0,0,0,
65536,65536,65536,65536,65536,65536,65536,65536,
0,0,0,0,0,0,0,0,
65536,65536,65536,65536,65536,65536,65536,65536,
0,0,0,0,0,0,0,0,
65537,65537,65537,65537,65537,65537,65537,65537, 
54018,8704,1,903,61648,31196,327,575, 
65537,65537,65537,65537,65537,65537,65537,65537, 
64400,36956,1673,9758,52289,4361,659,1433, 
65537,65537,65537,65537,65537,65537,65537,65537, 
56482,65535,1,1,11905,3034,1,1, 
65537,65537,65537,65537,65537,65537,65537,65537, 
61103,56650,925,8814,11845,2075,828,223, 
65537,65537,65537,65537,65537,65537,65537,65537, 
4161,1,494,5041,52508,32195,11005,2463, 
65537,65537,65537,65537,65537,65537,65537,65537, 
63286,32768,39133,49486,53351,8541,37603,15011, 
65537,65537,65537,65537,65537,65537,65537,65537, 
18805,13107,1039,1214,5060,21845,3830,387, 
65537,65537,65537,65537,65537,65537,65537,65537, 
31654,32951,490,1496,2535,11699,328,13
};
/* SAIT_V2 end */

/* SAIT_V2 begin : added by Samsung AIT (99/02/23) */
/* Probability model for bab type (0-odd, 1-even) */
/* begin: modified by Samsung AIT for Conformance on 2000/02/02 */
/*unsigned int scalable_bab_type_prob[2]={57203,36882};*/
unsigned int scalable_bab_type_prob[2]={59808,44651};
/* end: modified by Samsung AIT for Conformance on 2000/02/02 */
 
/* Probability model for P1 pixel of Interleaved Scan-Line (ISL) coding */
unsigned int scalable_xor_prob_1[128]={
65476,64428,62211,63560,52253,58271,38098,31981,
50087,41042,54620,31532,8382,10754,3844,6917,
63834,50444,50140,63043,58093,45146,36768,13351,
17594,28777,39830,38719,9768,21447,12340,9786,
60461,41489,27433,53893,47246,11415,13754,24965,
51620,28011,11973,29709,13878,22794,24385,1558,
57065,41918,25259,55117,48064,12960,19929,5937,
25730,22366,5204,32865,3415,14814,6634,1155,
64444,62907,56337,63144,38112,56527,40247,37088,
60326,45675,51248,15151,18868,43723,14757,11721,
62436,50971,51738,59767,49927,50675,38182,24724,
48447,47316,56628,36336,12264,25893,24243,5358,
58717,56646,48302,60515,36497,26959,43579,40280,
54092,20741,10891,7504,8109,30840,6772,4090,
59810,61410,53216,64127,32344,12462,23132,19270,
32232,24774,9615,17750,1714,6539,3237,152
};
 
/* Probability model for P2/P3 pixels of Interleaved Scan-Line (ISL) coding */
unsigned int scalable_xor_prob_23[128]={
65510,63321,63851,62223,64959,62202,63637,48019,
57072,33553,37041,9527,53190,50479,54232,12855,
62779,63980,49604,31847,57591,64385,40657,8402,
33878,54743,17873,8707,34470,54322,16702,2192,
58325,48447,7345,31317,45687,44236,16685,24144,
34327,18724,10591,24965,9247,7281,3144,5921,
59349,33539,11447,5543,58082,48995,35630,10653,
7123,15893,23830,800,3491,15792,8930,905,
65209,63939,52634,62194,64937,53948,60081,46851,
56157,50930,35498,24655,56331,59318,32209,6872,
59172,64273,46724,41200,53619,59022,37941,20529,
55026,52858,26402,45073,57740,55485,20533,6288,
64286,55438,16454,55656,61175,45874,28536,53762,
58056,21895,5482,39352,32635,21633,2137,4016,
58490,14100,18724,10461,53459,15490,57992,15128,
12034,4340,6761,1859,5794,6785,2412,35
};
/* Probability model for Raster Scan-Line (RSL) coding (odd filter) */
unsigned int scalable_full_odd_prob[256]={
65535,32768,32768,32768,32768,32768,32768,32768,
32768,32768,32768,32768,32768,32768,32768,32768,
63094,32768,32768,32768,32768,32768,32768,32768,
32768,32768,32768,32768,32768,32768,32768,32768,
62401,45272,32768,32768,32768,32768,32768,32768,
43096,25726,32768,32768,32768,32768,32768,32768,
55308,17735,32768,32768,32768,32768,32768,32768,
47493,17490,32768,32768,32768,32768,32768,32768,
59542,32768,60740,32768,23847,32768,49123,32768,
36976,32768,44280,32768,24293,32768,26276,32768,
58543,32768,50320,32768,25766,32768,11486,32768,
58465,32768,51357,32768,22795,32768,11805,32768,
49265,12891,27134,10923,20307,32768,12170,7016,
48182,33695,30544,32433,28855,32768,24901,32768,
46015,19178,28001,9729,25880,32768,5913,3070,
33736,32373,33972,21627,26263,32768,19795,32768,
59127,36942,44697,9709,46286,32740,28555,8727,
63736,52206,29927,26312,60272,32005,44761,9988,
47369,17677,48608,19114,19581,30088,25936,24690,
52287,35610,27173,20869,30916,23533,38614,10446,
22346,40972,22360,9590,7680,20243,1983,1754,
48889,45804,22662,27924,28868,9882,14438,1369,
25195,25948,21631,13785,10822,22192,5742,11770,
36752,23147,11313,20607,40693,5351,25436,2752,
44934,6118,32944,12477,26847,28553,32857,12688,
28532,12091,43573,30108,35939,14785,45888,5319,
33566,8681,19072,16384,19175,30670,24431,13374,
28505,28099,44921,39479,39766,19313,18418,4159,
9896,10051,6277,10190,8937,14547,7725,4412,
15503,20210,17744,27014,23609,6523,34098,2309,
7797,4278,2573,5564,11111,18030,2225,2277,
9345,12206,15307,19068,40775,3644,23776,171
};
/* Probability model for Raster Scan-Line (RSL) coding (even filter) */
unsigned int scalable_full_even_prob[256]={
32768,32768,32768,32768,32768,32768,32768,32768,
32768,32768,32768,32768,32768,32768,32768,32768,
32768,32768,32768,32768,32768,32768,32768,32768,
32768,32768,32768,32768,32768,32768,32768,32768,
32768,32768,32768,32768,32768,32768,32768,32768,
32768,32768,32768,32768,32768,32768,32768,32768,
32768,32768,32768,32768,32768,32768,32768,32768,
32768,32768,32768,32768,32768,32768,32768,32768,
32768,32768,32768,32768,32768,32768,32768,32768,
32768,32768,32768,32768,32768,32768,32768,32768,
32768,32768,32768,32768,32768,32768,32768,32768,
32768,32768,32768,32768,32768,32768,32768,32768,
32768,32768,32768,32768,32768,32768,32768,32768,
32768,32768,32768,32768,32768,32768,32768,32768,
32768,32768,32768,32768,32768,32768,32768,32768,
32768,32768,32768,32768,32768,32768,32768,32768,
62895,39067,48704,11763,59082,16056,35655,2552,
65472,58570,43137,54459,63589,30402,51995,8506,
48059,25600,39891,20480,48289,20480,33704,862,
65398,61538,32768,56173,63332,33544,48817,6824,
61680,46422,20947,16531,30989,2969,5053,776,
64799,44586,34078,38272,54776,7627,40104,780,
61189,32780,58998,18264,30111,2006,35761,1711,
62403,22718,58513,35075,61813,4541,54577,1947,
51659,5136,57698,11683,42523,3223,40941,2976,
63801,16281,60527,34885,56447,13256,45226,3402,
49905,9884,61363,20249,31043,3318,33591,1543,
63194,42118,62721,56056,52039,25321,20015,5030,
46814,6017,19267,4864,32768,3855,13296,652,
56912,23661,34133,21197,31232,7271,39021,1022,
52334,8542,36773,4841,15334,1219,4704,568,
55692,15947,43184,25700,43772,3666,17184,182
};
/* SAIT_V2 end */
