#include "momusys.h"
#include "sadct_vec.h"

Double f0_2 = 0.707107;
Double f0_3 = 0.577350, f1_3 = 0.707107, f2_3 = 0.408248, f3_3 = 0.816497;
Double f0_4 = 0.500000, f1_4 = 0.653281, f2_4 = 0.270598;
Double f0_5 = 0.447214, f1_5 = 0.601501, f2_5 = 0.371748, f3_5 = 0.511667;
Double f4_5 = 0.195440, f5_5 = 0.632456;
Double f0_6 = 0.408248, f1_6 = 0.557678, f2_6 = 0.500000; 
Double f3_6 = 0.288675, f4_6 = 0.149429, f5_6 = 0.577350;
Double f0_7 = 0.377964, f1_7 = 0.521121, f2_7 = 0.481588, f3_7 = 0.417907;
Double f4_7 = 0.333269, f5_7 = 0.231921, f6_7 = 0.118942, f7_7 = 0.534522;
Double f0_8 = 0.7071068, f1_8 = 0.4903926, f2_8 = 0.4619398, f3_8 = 0.4157348;
Double f4_8 = 0.3535534, f5_8 = 0.2777851, f6_8 = 0.1913417, f7_8 = 0.0975452;


Int dct_vec2 (Double *vec, Double *coeff)
{

  coeff[0] = (vec[0] + vec[1]) * f0_2;
  coeff[1] = (vec[0] - vec[1]) * f0_2;

  return 0;
}


Int dct_vec3 (Double *vec, Double *coeff)
{
  Double b;

  b = vec[0] + vec[2];

  coeff[0] = (vec[1] + b) * f0_3;
  coeff[1] = (vec[0] - vec[2]) * f1_3;
  coeff[2] = b * f2_3 -  vec[1] * f3_3;

  return 0;
}
  

Int dct_vec4 (Double *vec, Double *coeff)
{
  Double b[4];

  /* stage 1 */
  b[0] = vec[0] + vec[3];
  b[1] = vec[1] + vec[2];
  b[2] = vec[1] - vec[2];
  b[3] = vec[0] - vec[3];

  /* stage 2 */
  coeff[0] = (b[0] + b[1]) * f0_4;
  coeff[2] = (b[0] - b[1]) * f0_4;
  coeff[1] = b[2] * f2_4 + b[3] * f1_4;
  coeff[3] = b[3] * f2_4 - b[2] * f1_4;

  return 0;
}

Int dct_vec5 (Double *vec, Double *coeff)
{
  Double b[5];

  b[0] = vec[0] + vec[4];
  b[1] = vec[0] - vec[4];
  b[2] = vec[1] + vec[3];
  b[3] = vec[1] - vec[3];
  b[4] = vec[2] * f5_5;

  coeff[0] = (b[0] + b[2] + vec[2]) * f0_5;
  coeff[1] = b[1] * f1_5 + b[3] * f2_5;
  coeff[2] = b[0] * f3_5 - b[2] * f4_5 - b[4];
  coeff[3] = b[1] * f2_5 - b[3] * f1_5;
  coeff[4] = b[0] * f4_5 - b[2] * f3_5 + b[4];

  return 0;
}

Int dct_vec6 (Double *vec, Double *coeff)
{
  Double b[8];

  /* stage 1 */
  b[0] = vec[0] + vec[5];
  b[1] = vec[0] - vec[5];
  b[2] = vec[1] + vec[4];
  b[3] = vec[1] - vec[4];
  b[4] = vec[2] + vec[3];
  b[5] = vec[2] - vec[3];
  b[6] = b[3] * f0_6;
  b[7] = b[0] + b[4];

  /* stage 2 */
  coeff[0] = (b[7] + b[2]) * f0_6;
  coeff[1] = b[1] * f1_6 + b[5] * f4_6 + b[6];
  coeff[2] = (b[0] - b[4]) * f2_6;
  coeff[3] = (b[1] - b[3] -b[5]) * f0_6;
  coeff[4] = b[7] * f3_6 - b[2] * f5_6;
  coeff[5] = b[1] * f4_6 + b[5] * f1_6 - b[6];

  return 0;
}

Int dct_vec7 (Double *vec, Double *coeff)
{
  Double b[7];

  b[0] = vec[0] + vec[6];
  b[1] = vec[0] - vec[6];
  b[2] = vec[1] + vec[5];
  b[3] = vec[1] - vec[5];
  b[4] = vec[2] + vec[4];
  b[5] = vec[2] - vec[4];
  b[6] = vec[3] * f7_7;

  coeff[0] = (b[0] + b[2] + b[4] + vec[3]) * f0_7;
  coeff[1] = b[1] * f1_7 + b[3] * f3_7 + b[5] * f5_7;
  coeff[2] = b[0] * f2_7 + b[2] * f6_7 - b[4] * f4_7 - b[6];
  coeff[3] = b[1] * f3_7 - b[3] * f5_7 - b[5] * f1_7;
  coeff[4] = b[0] * f4_7 - b[2] * f2_7 - b[4] * f6_7 + b[6];
  coeff[5] = b[1] * f5_7 - b[3] * f1_7 + b[5] * f3_7;
  coeff[6] = b[0] * f6_7 - b[2] * f4_7 + b[4] * f2_7 - b[6];
  
  return 0;
}
  
Int dct_vec8  (Double *vec, Double *coeff)
{
  Int   j1, j;
  Double b[8];
  Double b1[8];

  /* stage 1 */
  for (j = 0; j < 4; j++)
    {
      j1 = 7 - j;
      b1[j] = vec[j] + vec[j1];
      b1[j1] = vec[j] - vec[j1];
    }

  /* stage 2 */
  b[0] = b1[0] + b1[3];
  b[1] = b1[1] + b1[2];
  b[2] = b1[1] - b1[2];
  b[3] = b1[0] - b1[3];
  b[4] = b1[4];
  b[5] = (b1[6] - b1[5]) * f0_8;
  b[6] = (b1[6] + b1[5]) * f0_8;
  b[7] = b1[7];

  /* stage 3/4 for the coeff. 0,2,4,6 */
  coeff[0] = (b[0] + b[1]) * f4_8;
  coeff[4] = (b[0] - b[1]) * f4_8;
  coeff[2] = b[2] * f6_8 + b[3] * f2_8;
  coeff[6] = b[3] * f6_8 - b[2] * f2_8;

  /* stage 3 */
  b1[4] = b[4] + b[5];
  b1[7] = b[7] + b[6];
  b1[5] = b[4] - b[5];
  b1[6] = b[7] - b[6];

  /* stage 4 for coeff. 1,3,5,7 */
  coeff[1] = b1[4] * f7_8 + b1[7] * f1_8;
  coeff[5] = b1[5] * f3_8 + b1[6] * f5_8;
  coeff[7] = b1[7] * f7_8 - b1[4] * f1_8;
  coeff[3] = b1[6] * f3_8 - b1[5] * f5_8;
    
  return 0;
}


Int dct_ref (Double *vec, Double *coeff, Int N)
{
  Int i,p,k;
  Double d[8];
  Double scale;

  for (p = 0; p < N; p++) {
    d[p] = 0.0;
    for (k = 0; k < N; k++) {
      scale = M_PI / (Double) N;
       d[p] += vec[k] * cos ((Double) p * ( (Double) k + 0.5) * scale);
    }
    d[p] *= sqrt (2.0 / (Double) N);
    if ( p == 0)
      d[p] /= sqrt (2.0);
  }
  for (i = 0; i < N; i++)
    /* coeff[i] = (Int)(floor(d[i] + 0.499999)); */
    coeff[i] = d[i];

  return 0;
  
} 


Int idct_vec2 (Double *in, Double *out)
{

  out[0] = (in[0] + in[1]) * f0_2;
  out[1] = (in[0] - in[1]) * f0_2;

  return 0;
}


Int idct_vec3 (Double *in, Double *out)
{
  Double b[3];

  b[0] = in[0] * f0_3;
  b[1] = b[0] + in[2] * f2_3;
  b[2] = in[1] * f1_3;

  out[0] = b[1] + b[2];
  out[2] = b[1] - b[2];
  out[1] = b[0] - in[2] * f3_3;

  return 0;
}

  
Int idct_vec4 (Double *in, Double *out)
{
  Double b[4];

  /* stage 1 */

  b[0] = (in[0] + in[2]) * f0_4;
  b[1] = (in[0] - in[2]) * f0_4;
  b[2] = in[1] * f2_4 - in[3] * f1_4;
  b[3] = in[3] * f2_4 + in[1] * f1_4;

  /* stage 2 */
  out[0] = b[0] + b[3];
  out[1] = b[1] + b[2];
  out[2] = b[1] - b[2];
  out[3] = b[0] - b[3];

  return 0;
}


Int idct_vec5 (Double *in, Double *out)
{
  Double b[5];

  b[0] = in[0] * f0_5;
  b[1] = b[0] + in[2] * f3_5 + in[4] * f4_5;
  b[2] = in[1] * f1_5 + in[3] * f2_5;
  b[3] = b[0] - in[4] * f3_5 - in[2] * f4_5;
  b[4] = in[1] * f2_5 - in[3] * f1_5;

  out[0] = b[1] + b[2];
  out[1] = b[3] + b[4];
  out[2] = b[0] + (in[4] - in[2]) * f5_5;
  out[3] = b[3] - b[4];
  out[4] = b[1] - b[2];

  return 0;
}

Int idct_vec6 (Double *in, Double *out)
{
  Double b[10];
  Double b1[7];

  /* stage 1 */
  b[0] = in[0] * f0_6;
  b[1] = in[1] * f1_6;
  b[2] = in[2] * f2_6;
  b[3] = in[3] * f0_6;
  b[4] = in[4] * f3_6;
  b[5] = in[5] * f4_6;
  b[6] = (in[1] - in[5]) * f0_6;
  b[7] = in[1] * f4_6;
  b[8] = in[4] * f5_6;
  b[9] = in[5] * f1_6;

  /* stage 2 */
  b1[0] = b[0] + b[4];
  b1[1] = b1[0] + b[2];
  b1[2] = b[1] + b[3] + b[5];
  b1[3] = b[0] - b[8];
  b1[4] = b[6] - b[3];
  b1[5] = b1[0] - b[2];
  b1[6] = b[7] - b[3] + b[9];

  /* stage 3 */
  out[0] = b1[1] + b1[2];
  out[1] = b1[3] + b1[4];
  out[2] = b1[5] + b1[6];
  out[3] = b1[5] - b1[6];
  out[4] = b1[3] - b1[4];
  out[5] = b1[1] - b1[2];

  return 0;
}


Int idct_vec7 (Double *in, Double *out)
{
  Double b[20];
  Double b1[6];

  /* stage 1 */
  b[0] = in[0] * f0_7;
  b[1] = in[1] * f1_7;
  b[2] = in[1] * f3_7;
  b[3] = in[1] * f5_7;
  b[4] = in[2] * f2_7;
  b[5] = in[2] * f6_7;
  b[6] = in[2] * f4_7;
  b[7] = in[3] * f3_7;
  b[8] = in[3] * f5_7;
  b[9] = in[3] * f1_7;
  b[10] = in[4] * f4_7;
  b[11] = in[4] * f2_7;
  b[12] = in[4] * f6_7;
  b[13] = in[5] * f5_7;
  b[14] = in[5] * f1_7;
  b[15] = in[5] * f3_7;
  b[16] = in[6] * f6_7;
  b[17] = in[6] * f4_7;
  b[18] = in[6] * f2_7;
  b[19] = (in[4] - in[2] - in[6]) * f7_7;
  
  /* stage 2 */
  b1[0] = b[0] + b[4] + b[10] + b[16];
  b1[1] = b[1] + b[7] + b[13];
  b1[2] = b[0] + b[5] - b[11] - b[17];
  b1[3] = b[2] - b[8] - b[14];
  b1[4] = b[0] - b[6] - b[12] + b[18];
  b1[5] = b[3] - b[9] + b[15];

  /* stage 3 */

  out[0] = b1[0] + b1[1];
  out[1] = b1[2] + b1[3];
  out[2] = b1[4] + b1[5];
  out[3] = b[0] + b[19];
  out[4] = b1[4] - b1[5];
  out[5] = b1[2] - b1[3];
  out[6] = b1[0] - b1[1];  
  
  return 0;
}


Int idct_vec8 (Double *in, Double *out)
{

  Int j1, j;
  Double tmp[8], tmp1[8];
  Double e, f, g, h;

  /* stage 1 for k = 4,5,6,7 */
  e = in[1] * f7_8 - in[7] * f1_8;
  h = in[7] * f7_8 + in[1] * f1_8;
  f = in[5] * f3_8 - in[3] * f5_8;
  g = in[3] * f3_8 + in[5] * f5_8;

  /* stage 1+2 for k = 0,1,2,3 */
  tmp1[0] = (in[0] + in[4]) * f4_8;
  tmp1[1] = (in[0] - in[4]) * f4_8;
  tmp1[2] = in[2] * f6_8 - in[6] * f2_8;
  tmp1[3] = in[6] * f6_8 + in[2] * f2_8;

  tmp[4] = e + f;
  tmp1[5] = e - f;
  tmp1[6] = h - g;
  tmp[7] = h + g;
  
  tmp[5] = (tmp1[6] - tmp1[5]) * f0_8;
  tmp[6] = (tmp1[6] + tmp1[5]) * f0_8;
  tmp[0] = tmp1[0] + tmp1[3];
  tmp[1] = tmp1[1] + tmp1[2];
  tmp[2] = tmp1[1] - tmp1[2];
  tmp[3] = tmp1[0] - tmp1[3];

  /* stage 4 */
  for (j = 0; j < 4; j++) {
    j1 = 7 - j;
    out[j] = tmp[j] + tmp[j1];
    out[j1] = tmp[j] - tmp[j1];
  }
  
  return 0;
}
