/************************************************************************/
/*                                                     			*/
/* This software module was originally developed by              	*/
/*                                                               	*/
/* Stefan Rauthenberg (HHI / ACTS-MoMuSys).     	              	*/
/*                                                               	*/
/* and edited by                                                	*/
/*                                                               	*/
/* Jan De Lameillieure (HHI / ACTS-MoMuSys).     	              	*/
/*                                                               	*/
/* in the course of development of the MPEG-4 Video (ISO/IEC 14496-2).	*/
/* This software module is an implementation of a part of one or 	*/
/* more MPEG-4 Video (ISO/IEC 14496-2) tools as specified by the        */
/* MPEG-4 Video (ISO/IEC 14496-2). ISO/IEC gives users of the MPEG-4    */
/* Video free license to this software module or modifications thereof 	*/
/* for use in hardware or software products claiming conformance to the */
/* MPEG-4 Video (ISO/IEC 14496-2). Those intending to use this software */
/* module in hardware or software products are advised that its use may */
/* infringe existing patents. The original developer of this software  	*/
/* module and his/her company, the subsequent editors and their     	*/
/* companies, and ISO/IEC have no liability for use of this software    */
/* module or modifications thereof in an implementation. Copyright is   */
/* not released for non MPEG-4 Video (ISO/IEC 14496-2) conforming 	*/
/* products. ACTS-MoMuSys partners retain full right to use  the code   */
/* for their own purposes, assign or donate the code to a third party   */
/* and to inhibit third parties from using the code for non MPEG-4    	*/
/* Video (ISO/IEC 14496-2) conforming products. This copyright notice 	*/
/* must be included in all copies or derivative works.                  */
/* Copyright (c)1997                                            	*/
/*                                                               	*/
/************************************************************************/

/***********************************************************HeaderBegin*******
 *                                                                         
 * File: sadct_fprintf_mat.c 
 * 
 * Author: Stefan Rauthenberg (HHI)
 *
 * Created:
 *                                                                         
 * Description: 
 *
 * Notes:  
 *
 * Modified: 
 *      20-MAR-97 Jan De Lameillieure (HHI) : left out the function
 *			fprintf_cmat(), added this MoMuSys-header
 *     16-JUN-97 Jan De Lameillieure : renaming some include files to sadct_*
 *
 ***********************************************************HeaderEnd*********/

/************************    INCLUDE FILES    ********************************/

#include <stdio.h>
#include "sadct_bsprint.h"

Void fprintf_dmat(File *fp, const Char *s, Double **mat,
		  Int iys, Int ixs, Int iyl, Int ixl, const Char *fmt)
{
  Int ix, iy;

  fprintf(fp, "%s\n", s);
  for (iy=iys; iy<=iyl; iy++) {
    for (ix=ixs; ix<=ixl; ix++)
      fprintf(fp, fmt, mat[iy][ix]);
    fputc('\n', fp);
  }
  fflush(fp);
}

Void fprintf_smat(File *fp, const Char *s, SInt **mat,
		  Int iys, Int ixs, Int iyl, Int ixl, const Char *fmt)
{
  Int ix, iy;

  fprintf(fp, "%s\n", s);
  for (iy=iys; iy<=iyl; iy++) {
    for (ix=ixs; ix<=ixl; ix++)
      fprintf(fp, fmt, (int)mat[iy][ix]);
    fputc('\n', fp);
  }
  fflush(fp);
}

Void fprintf_dmataddr(File *fp, const Char *s, Double ***mat,
		      Int iys, Int ixs, Int iyl, Int ixl, const Char *fmt,
		      Double *addroffs)
{
  Int ix, iy;

  fprintf(fp, "%s\n", s);
  for (iy=iys; iy<=iyl; iy++) {
    for (ix=ixs; ix<=ixl; ix++)
      fprintf(fp, fmt, mat[iy][ix]-addroffs);
    fputc('\n', fp);
  }
  fflush(fp);
}

Void
fprintf_ivec(File *fp, const Char *s, Int *vec, Int inds, Int indl,
	     const Char *fmt)
{
  Int i;

  fprintf(fp, "%s\n", s);
  vec += inds;
  for (i=inds; i<=indl; i++)
    fprintf(fp, fmt, *vec++);

  fputc('\n', fp);
  fflush(fp);
}
