/* $Id: read_control_file.c,v 1.29 1998/07/20 18:33:23 hatrack Exp $ */
/****************************************************************************/
/*   MPEG4 Visual Texture Coding (VTC) Mode Software                        */
/*                                                                          */
/*   This software was jointly developed by the following participants:     */
/*                                                                          */
/*   Single-quant,  multi-quant and flow control                            */
/*   are provided by  Sarnoff Corporation                                   */
/*     Iraj Sodagar   (iraj@sarnoff.com)                                    */
/*     Hung-Ju Lee    (hjlee@sarnoff.com)                                   */
/*     Paul Hatrack   (hatrack@sarnoff.com)                                 */
/*     Shipeng Li     (shipeng@sarnoff.com)                                 */
/*     Bing-Bing Chai (bchai@sarnoff.com)                                   */
/*     B.S. Srinivas  (bsrinivas@sarnoff.com)                               */
/*                                                                          */
/*   Bi-level is provided by Texas Instruments                              */
/*     Jie Liang      (liang@ti.com)                                        */
/*                                                                          */
/*   Shape Coding is provided by  OKI Electric Industry Co., Ltd.           */
/*     Zhixiong Wu    (sgo@hlabs.oki.co.jp)                                 */
/*     Yoshihiro Ueda (yueda@hlabs.oki.co.jp)                               */
/*     Toshifumi Kanamaru (kanamaru@hlabs.oki.co.jp)                        */
/*                                                                          */
/*   OKI, Sharp, Sarnoff, TI and Microsoft contributed to bitstream         */
/*   exchange and bug fixing.                                               */
/*                                                                          */
/*                                                                          */
/* In the course of development of the MPEG-4 standard, this software       */
/* module is an implementation of a part of one or more MPEG-4 tools as     */
/* specified by the MPEG-4 standard.                                        */
/*                                                                          */
/* The copyright of this software belongs to ISO/IEC. ISO/IEC gives use     */
/* of the MPEG-4 standard free license to use this  software module or      */
/* modifications thereof for hardware or software products claiming         */
/* conformance to the MPEG-4 standard.                                      */
/*                                                                          */
/* Those intending to use this software module in hardware or software      */
/* products are advised that use may infringe existing  patents. The        */
/* original developers of this software module and their companies, the     */
/* subsequent editors and their companies, and ISO/IEC have no liability    */
/* and ISO/IEC have no liability for use of this software module or         */
/* modification thereof in an implementation.                               */
/*                                                                          */
/* Permission is granted to MPEG members to use, copy, modify,              */
/* and distribute the software modules ( or portions thereof )              */
/* for standardization activity within ISO/IEC JTC1/SC29/WG11.              */
/*                                                                          */
/* Copyright 1995, 1996, 1997, 1998 ISO/IEC                                 */
/****************************************************************************/


/************************************************************/
/*     Sarnoff Very Low Bit Rate Still Image Coder          */
/*     Copyright 1995, 1996, 1997, 1998 Sarnoff Corporation */
/************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "dataStruct.h"
#include "errorHandler.h"
#include "msg.h"

/* SAIT_V2 begin : modified by Samsung AIT (99/02/23) */
/**
extern Int STO_const_alpha;
extern UChar STO_const_alpha_value;
**/
Int STO_const_alpha;
UChar STO_const_alpha_value;
/* SAIT_V2 end */
static Char *hasIntFmt(Char *s)
{
  if ((s=strchr(s,'%'))!=NULL)
  {
    ++s;
    while (*s >= '0' && *s <= '9')
      s++;
    
    s = (*s == 'd') ? (s+1) : NULL;
  }

  return s;
}

static Void checkParams(SOL_PARAMETERS *vm_param)
{
  Char *s;

  /* Check parameters */
  if (vm_param->quantization_type==1 && vm_param->scan_direction==0
      && vm_param->SNR_start_code_enable==1)
  {
    noteWarning("Single-Quant Tree-Depth has no start codes. " \
		"Turning start code off.");
    vm_param->SNR_start_code_enable=0;
  }

  if (vm_param->acm_order)
  {
    noteWarning("Currently only zeroth order model enabled");
    vm_param->acm_order=0;
  }

  /* check first bit file */
  if (strchr(vm_param->bitFile,'%') != NULL)
    errorHandler("'%s' is an invalid 'first' bitfile name. '%%' not allowed.",
		 vm_param->bitFile);

  if (vm_param->singleBitFile==0)
    if (vm_param->quantization_type==1 || vm_param->quantization_type==2)
    {
      /* bitFileAC must exist and have two %d's */
      if ((s=hasIntFmt(vm_param->bitFileAC))==NULL)
	errorHandler("'%s' is an invalid AC bitfile format for "\
		     "multiple files option in single and multi-quant.\n"\
		     "\tSNR start code is enabled - need two "\
		     "Integer formats.", vm_param->bitFileAC);
  }
}


/*--------------------------------------------------------------------
  read_control_file()
  
  Return Values
  -------------
  None.
  
  Comments
  --------
  Exits if error occurs.
  --------------------------------------------------------------------*/

Void read_control_file(Char *ctlfname, SOL_PARAMETERS *vm_param)
{
  File *vminfp;
  Char *garbage=(Char *)malloc(sizeof(Char)*80);
  Int  spa_lev,snr_lev,col;
  Int  SNR_scalability_levels;
  
  if (garbage==NULL)
    errorHandler("Malloc error \n");
  
  if ( (vminfp = fopen(ctlfname,"r")) == NULL) 
    errorHandler("Can't open the control file '%s'\n",ctlfname);
  
  /* read the path to the source image */
  if ((vm_param->ImagePath = (Char *)malloc(sizeof(Char)*100)) == NULL)
    errorHandler("error allocating memory \n");
  fscanf(vminfp,"%s",vm_param->ImagePath);
  fgets(garbage,80,vminfp);

  /* read alpha channel: 0-rectangular  1-arbitrary  */
  fscanf(vminfp,"%d",&vm_param->sa_dwt);
  fgets(garbage,80,vminfp);

  /* read the path to the segmentation map of the source image */
  if ((vm_param->SegPath = (Char *)malloc(sizeof(Char)*100)) == NULL)
    errorHandler("error allocating memory \n");
  fscanf(vminfp,"%s",vm_param->SegPath);
  fgets(garbage,80,vminfp);

  /* read alpha threshold for shape coding */
  fscanf(vminfp,"%d",&vm_param->alphaTH);
  fgets(garbage,80,vminfp);

  /* read hange_CR_disable for shape coding */
  fscanf(vminfp,"%d",&vm_param->change_CR_disable);
  fgets(garbage,80,vminfp);


  /*read the output bitstream filename */
  if ((vm_param->bitFile = (Char *)malloc(sizeof(Char)*100)) == NULL)
    errorHandler("Allocating memory.");
  fscanf(vminfp,"%d %s",&vm_param->singleBitFile,vm_param->bitFile);
  if (vm_param->singleBitFile==0)
  {
    if ((vm_param->bitFileAC = (Char *)malloc(sizeof(Char)*100)) == NULL)
      errorHandler("Allocating memory.");

    fscanf(vminfp,"%s",vm_param->bitFileAC);
  }
  fgets(garbage,80,vminfp);


  /*read the number of color components of the source image */
  fscanf(vminfp,"%d",&vm_param->colors);
  fgets(garbage,80,vminfp);

  if ((vm_param->Image = 
       (PICTURE *)malloc(sizeof(PICTURE)*vm_param->colors)) == NULL)
    errorHandler("error allocating memory \n");

  if ((vm_param->SegImage = 
       (PICTURE *)malloc(sizeof(PICTURE)*1)) == NULL)
    errorHandler("error allocating memory \n");

  /* read the bit-depth of the source image */
  fscanf(vminfp,"%d",&vm_param->bit_depth);
  fgets(garbage,80,vminfp);
  
  /* read the width of the source image */
  fscanf(vminfp,"%d",&vm_param->Image[0].width);
  fgets(garbage,80,vminfp);
  /* vm_param->Image[0].width = width; */
  
  /* read the height of the source image */
  fscanf(vminfp,"%d",&vm_param->Image[0].height);
  fgets(garbage,80,vminfp);
  
  /* read filter type, currently, there are 10 filters available in
     default.h */
  fscanf(vminfp,"%d",&vm_param->wvtType);
  fgets(garbage,80,vminfp);
  
  /* read wavelet decomposition levels */
  fscanf(vminfp,"%d",&vm_param->wvtDecompLev);
  fgets(garbage,80,vminfp);

  /*** SL: added to handle non-uniform downloadable filters : BEGIN ****/
  /* read wavelet downloadable or default */
  fscanf(vminfp,"%d",&vm_param->wvtDownload);
  fgets(garbage,80,vminfp);

  /* read wavelet uniform or not */
  fscanf(vminfp,"%d",&vm_param->wvtUniform);
  fgets(garbage,80,vminfp);
  /* default wavelet filters are uniform */
  if(!vm_param->wvtDownload) vm_param->wvtUniform=1;
  if(vm_param->wvtUniform)
    vm_param->wvtFilters = (Int *)malloc(sizeof(Int));
  else
    vm_param->wvtFilters = (Int *)malloc(sizeof(Int)*vm_param->wvtDecompLev);
  
  if(vm_param->wvtFilters==NULL) 
    errorHandler("error allocating memory:  vm_param->wvtFilters\n");
  /* read in filter numbers if applicable */
  /* for int type filter: 0, 2, 4 */
  /* for float type: 1, 3, 5-10 */
  
  if(!vm_param->wvtDownload) {
    if(vm_param->wvtType==0)
       vm_param->wvtFilters[0]=0;
    else
       vm_param->wvtFilters[0]=1;
  }
  else  if(vm_param->wvtUniform) {
    fscanf(vminfp,"%d", vm_param->wvtFilters);
    /* check to see if the filters match its type */
    if(vm_param->wvtFilters[0] !=0 
       && vm_param->wvtFilters[0] !=2
       && vm_param->wvtFilters[0] !=4) {
      if(vm_param->wvtType==0)
	errorHandler("Filter %d is not integer filter.\n", vm_param->wvtFilters[0]);
    }
    else {
      if(vm_param->wvtType!=0)
	errorHandler("Filter %d is not float filter.\n", vm_param->wvtFilters[0]);
    }
  }
  else {
    for(spa_lev=0; spa_lev<vm_param->wvtDecompLev; spa_lev++) {
      fscanf(vminfp,"%d", vm_param->wvtFilters+spa_lev);
      /* check to see if the filters match its type */
      if(vm_param->wvtFilters[spa_lev] !=0 
	 && vm_param->wvtFilters[spa_lev] !=2
	 && vm_param->wvtFilters[spa_lev] !=4) {
	if(vm_param->wvtType==0)
	  errorHandler("Filter %d is not integer filter.\n", vm_param->wvtFilters[spa_lev]);
      }
      else {
	if(vm_param->wvtType!=0)
	  errorHandler("Filter %d is not float filter.\n", vm_param->wvtFilters[spa_lev]);
      }
    }
  }
  fgets(garbage,80,vminfp); 
  /*** SL: added to handle non-uniform downloadable filters : END****/
  
  /* read quantization type */
  fscanf(vminfp,"%d",&vm_param->quantization_type);
  fgets(garbage,80,vminfp);

  /* read scan order */
  fscanf(vminfp,"%d",&vm_param->scan_direction); 
  fgets(garbage,80,vminfp);

  /* read  SNR start code enable*/
  fscanf(vminfp,"%d",&vm_param->SNR_start_code_enable);
  fgets(garbage,80,vminfp);
  
  
  fscanf(vminfp,"%d",&vm_param->target_bitrate);
  fgets(garbage,80,vminfp);
  
  fscanf(vminfp,"%d",&vm_param->target_spatial_levels);
  fgets(garbage,80,vminfp);
  
  fscanf(vminfp,"%d",&vm_param->target_snr_levels);
  fgets(garbage,80,vminfp);
  
  /* Read in deringing parameters. If either is zero deringing is disabled */
  fscanf(vminfp,"%d %d",
         &vm_param->deringWindowSize,&vm_param->deringThreshold);
  fgets(garbage,80,vminfp);

  /* read in arith coder order */
  fscanf(vminfp, "%d",&vm_param->acm_order);
  fgets(garbage,80,vminfp);

  /* read in user defined max_freq */
  fscanf(vminfp, "%d",&vm_param->acm_max_freq_chg);
  fgets(garbage,80,vminfp);
  if(vm_param->acm_max_freq_chg !=0){
     Int i;
     fgets(garbage,80,vminfp);
     fgets(garbage,80,vminfp);
    vm_param->acm_maxf=(Int *)malloc(6*sizeof(Int));
    for(i=0;i<6;i++){
      fscanf(vminfp, "%d",&vm_param->acm_maxf[i]);
      fgets(garbage,80,vminfp);
    }
  }
  else
    vm_param->acm_maxf=NULL;

  /* Read in DC Lum Quant */
  fscanf(vminfp,"%d",&vm_param->QdcY);
  fgets(garbage,80,vminfp);
  if (vm_param->colors != MONO) { 
    /* Read in DC Chroma Quant */
    fscanf(vminfp,"%d",&vm_param->QdcUV);
    fgets(garbage,80,vminfp);
  }
  
  /* Read in the spatial scalability levels */
  fscanf(vminfp,"%d",&vm_param->spatial_scalability_levels);
  
  /* add for mq spatial layer flexability * - ph 7/16 */
  if (vm_param->quantization_type == 2)
  {
      if (vm_param->spatial_scalability_levels != vm_param->wvtDecompLev)
      {
	/* read in usedefault */
	fscanf(vminfp,"%d",&vm_param->defaultSpatialScale);
	if (vm_param->defaultSpatialScale==0)
	{
	  /* read in spatial layer info */
	  for (spa_lev=0; spa_lev<vm_param->spatial_scalability_levels-1; 
	       ++spa_lev)   
	    fscanf(vminfp,"%d",&vm_param->lastWvtDecompInSpaLayer[spa_lev]);
	}
      }
  }
  fgets(garbage,80,vminfp);

  /* special code to take care of SQ band by band, b.b. Chai, 4/27/98 */
  if(vm_param->quantization_type == 1 && vm_param->scan_direction == 1){
    vm_param->spatial_scalability_levels=vm_param->wvtDecompLev;
    noteWarning("SQ, band-by-band mode has %d spatial layers, ignore this" \
		" field.",vm_param->wvtDecompLev);

    for (col=0; col<vm_param->colors; col++) {
      if ((vm_param->SPlayer[col] = (SNR_PARAM *)malloc(sizeof(SNR_PARAM)*
			       vm_param->wvtDecompLev )) == NULL)
	errorHandler("error allocating memory \n");
    }

    fscanf(vminfp,"%d",&SNR_scalability_levels);
    for(spa_lev=0;spa_lev<vm_param->wvtDecompLev; spa_lev++) {
      for (col=0; col<vm_param->colors; col++){
	vm_param->SPlayer[col][spa_lev].SNR_scalability_levels =1;
	if ((vm_param->SPlayer[col][spa_lev].Quant = 
	     (Int *)malloc(sizeof(Int)))==NULL)
	  errorHandler("error allocating memory \n");
      }
    }
    fscanf(vminfp,"%d",&vm_param->SPlayer[0][0].Quant[0]);
    if (vm_param->colors != MONO) { 
      fscanf(vminfp,"%d",&vm_param->SPlayer[1][0].Quant[0]);
      vm_param->SPlayer[2][0].Quant[0] =
	vm_param->SPlayer[1][0].Quant[0];
    }
  }
  else{/* other cases */
    for (col=0; col<vm_param->colors; col++) {
      if ((vm_param->SPlayer[col] = (SNR_PARAM *)malloc(sizeof(SNR_PARAM)*
			    vm_param->spatial_scalability_levels )) == NULL)
	errorHandler("error allocating memory \n");
    }

    for (spa_lev=0; spa_lev<vm_param->spatial_scalability_levels; spa_lev++) {
      fscanf(vminfp,"%d",&SNR_scalability_levels);
      
      for (col=0; col<vm_param->colors; col++) {
	vm_param->SPlayer[col][spa_lev].SNR_scalability_levels = 
	  SNR_scalability_levels;
	if ((vm_param->SPlayer[col][spa_lev].Quant = 
	     (Int *)malloc(sizeof(Int)*SNR_scalability_levels))==NULL)
	  errorHandler("error allocating memory \n");
      }
      
      for (snr_lev=0; snr_lev<SNR_scalability_levels; snr_lev++) {
	fscanf(vminfp,"%d",&vm_param->SPlayer[0][spa_lev].Quant[snr_lev]);
	if (vm_param->colors != MONO) { 
	  fscanf(vminfp,"%d",&vm_param->SPlayer[1][spa_lev].Quant[snr_lev]);
	  vm_param->SPlayer[2][spa_lev].Quant[snr_lev] =
	    vm_param->SPlayer[1][spa_lev].Quant[snr_lev];
	}
      }
      
    fgets(garbage,80,vminfp);
    }
  }
  fclose(vminfp);
  free(garbage);
  /* need to read the following from the  parameter file */
  /*  vm_param->alphaTH = 0;  
   vm_param->change_CR_disable = 1;  */
  STO_const_alpha=vm_param->STO_const_alpha = 1;
  STO_const_alpha_value = vm_param->STO_const_alpha_value = 0xff;
  checkParams(vm_param);
}

/*--------------------------------------------------------------------
  read_control_file_dec()
  
  Return Values
  -------------
  None.
  
  Comments
  --------
  Exits if error occurs.
  --------------------------------------------------------------------*/

Void read_control_file_dec(Char *ctlfname, SOL_PARAMETERS_DEC *vm_param)
{
  File *vminfp;
  Char *garbage=(Char *)malloc(sizeof(Char)*80);
  
  if (garbage==NULL)
    errorHandler("Malloc error \n");
  
  if ( (vminfp = fopen(ctlfname,"r")) == NULL) 
    errorHandler("can't find the control file %s\n",ctlfname);
  
  /* Throw away line: read the path to the source image */
  fgets(garbage,80,vminfp);

  /* read alpha channel: 0-rectangular  1-arbitrary  */
  /* fscanf(vminfp,"%ld",&vm_param->sa_dwt); */
  fgets(garbage,80,vminfp);


  /* read the path to the segmentation map of the source image */
  /*  if ((vm_param->SegPath = (Char *)malloc(sizeof(Char)*100)) == NULL)
      errorHandler("error allocating memory \n");
  fscanf(vminfp,"%s",vm_param->SegPath);*/
  fgets(garbage,80,vminfp);

  /* read alpha threshold for shape coding */
  /* fscanf(vminfp,"%ld",&vm_param->alphaTH); */
  fgets(garbage,80,vminfp);

  /* read hange_CR_disable for shape coding */
  /* fscanf(vminfp,"%ld",&vm_param->change_CR_disable); */
  fgets(garbage,80,vminfp);


  /*read the number of color components of the source image */
  if ((vm_param->bitFile = (Char *)malloc(sizeof(Char)*100)) == NULL)
    errorHandler("Allocating memory.");
  fscanf(vminfp,"%d %s",&vm_param->singleBitFile,vm_param->bitFile);
  if (vm_param->singleBitFile==0)
  {
    if ((vm_param->bitFileAC = (Char *)malloc(sizeof(Char)*100)) == NULL)
      errorHandler("Allocating memory.");

    fscanf(vminfp,"%s",vm_param->bitFileAC);
  }
  fgets(garbage,80,vminfp);


  /* Throw away line: read the number of color components of the source 
     image */
  fscanf(vminfp,"%d",&vm_param->colors);
  fgets(garbage,80,vminfp);

  if ((vm_param->SegImage = 
       (PICTURE *)malloc(sizeof(PICTURE)*1)) == NULL)
    errorHandler("error allocating memory \n");

  /* read the bit-depth of the source image */
  fscanf(vminfp,"%d",&vm_param->bit_depth);
  fgets(garbage,80,vminfp);
  
  /* Throw away line: read the width of the source image */
  fscanf(vminfp,"%d",&vm_param->width);
  fgets(garbage,80,vminfp);
  
  /*  Throw away line: read the height of the source image */
  fscanf(vminfp,"%d",&vm_param->height);
  fgets(garbage,80,vminfp);
  
  /* read filter type */
  fgets(garbage,80,vminfp);
  
  /*  Throw away line: read wavelet decomposition levels */
  fscanf(vminfp,"%d",&vm_param->wvtDecompLev);
  fgets(garbage,80,vminfp);
  fgets(garbage,80,vminfp);
  fgets(garbage,80,vminfp);
  fgets(garbage,80,vminfp);
  
  /*  Throw away line: read quantization type */
  fgets(garbage,80,vminfp);
  
  /*  Throw away line: read scan direction */
  fgets(garbage,80,vminfp);
  
  /*  Throw away line: read  SNR start code enable*/
  fgets(garbage,80,vminfp);
  
  
  fscanf(vminfp,"%d",&vm_param->target_bitrate);
  fgets(garbage,80,vminfp);
  
  fscanf(vminfp,"%d",&vm_param->target_spatial_levels);
  fgets(garbage,80,vminfp);
  
  fscanf(vminfp,"%d",&vm_param->target_snr_levels);
  fgets(garbage,80,vminfp);
  
  /* Read in deringing parameters. If either is zero deringing is disabled */
  fscanf(vminfp,"%d %d",
         &vm_param->deringWindowSize,&vm_param->deringThreshold);
  fgets(garbage,80,vminfp);

  /* read in arith coder order */
  fscanf(vminfp, "%d",&vm_param->acm_order);
  fgets(garbage,80,vminfp);

  /* read in user defined max_freq */
  fscanf(vminfp, "%d",&vm_param->acm_max_freq_chg);
  fgets(garbage,80,vminfp);
  if(vm_param->acm_max_freq_chg !=0){
    Int i;
    fgets(garbage,80,vminfp);
    fgets(garbage,80,vminfp);
    vm_param->acm_maxf=(Int *)malloc(6*sizeof(Int));
    for(i=0;i<6;i++){
      fscanf(vminfp, "%d",&vm_param->acm_maxf[i]);
      fgets(garbage,80,vminfp);
    }
  }
  else
    vm_param->acm_maxf=NULL;

  /*  Throw away line: Read in DC Lum Quant */
  fgets(garbage,80,vminfp);
  if (vm_param->colors != MONO) { 
    /*  Throw away line: Read in DC Chroma Quant */
    fgets(garbage,80,vminfp);
  }
  
  fclose(vminfp);
  free(garbage);

  /*checkParams(vm_param);*/
}

Void free_vm_param(SOL_PARAMETERS* vm_param)
{
  Int col, spa_lev;

  if (vm_param->ImagePath) free(vm_param->ImagePath);
  if (vm_param->SegPath) free(vm_param->SegPath);
  if (vm_param->bitFile) free(vm_param->bitFile);
  if (vm_param->singleBitFile==0) free(vm_param->bitFileAC);
  if (vm_param->SegImage) free(vm_param->SegImage);
  
  free(vm_param->wvtFilters);
  for (spa_lev=0; spa_lev<vm_param->spatial_scalability_levels; spa_lev++)
    for (col=0; col<vm_param->colors; col++)
         if (vm_param->SPlayer[col][spa_lev].Quant) 
	   free(vm_param->SPlayer[col][spa_lev].Quant);

  for (col=0; col<vm_param->colors; col++)
    if (vm_param->SPlayer[col]) free(vm_param->SPlayer[col]);
  
  if (vm_param) free(vm_param);
}

Void free_vm_param_dec(SOL_PARAMETERS_DEC *vm_param_dec)
{
  if (vm_param_dec->bitFile) free(vm_param_dec->bitFile);
  if (vm_param_dec->singleBitFile==0) free(vm_param_dec->bitFileAC);
  if (vm_param_dec->SegImage) free(vm_param_dec->SegImage);
  if (vm_param_dec->acm_maxf) free(vm_param_dec->acm_maxf);

  if (vm_param_dec) free(vm_param_dec);
}
