/*****************************************************************************
 *
 * This software module was originally developed by
 *
 *   Bruno Loret (CNET / ACTS-MoMuSyS)
 *
 * and edited by
 * 
 *   Michael Wollborn (TUH / ACTS-MoMuSyS)                  
 *   Fujitsu Laboratories Ltd. (contact: Eishi Morimatsu)
 *
 * in the course of development of the MPEG-4 Video (ISO/IEC 14496-2) standard.
 * This software module is an implementation of a part of one or more MPEG-4
 * Video (ISO/IEC 14496-2) tools as specified by the MPEG-4 Video (ISO/IEC
 * 14496-2) standard.
 *
 * ISO/IEC gives users of the MPEG-4 Video (ISO/IEC 14496-2) standard free
 * license to this software module or modifications thereof for use in hardware
 * or software products claiming conformance to the MPEG-4 Video (ISO/IEC
 * 14496-2) standard.
 *
 * Those intending to use this software module in hardware or software products
 * are advised that its use may infringe existing patents. The original
 * developer of this software module and his/her company, the subsequent
 * editors and their companies, and ISO/IEC have no liability for use of this
 * software module or modifications thereof in an implementation. Copyright is
 * not released for non MPEG-4 Video (ISO/IEC 14496-2) Standard conforming
 * products.
 *
 * ACTS-MoMuSys partners retain full right to use the code for his/her own
 * purpose, assign or donate the code to a third party and to inhibit third
 * parties from using the code for non MPEG-4 Video (ISO/IEC 14496-2) Standard
 * conforming products. This copyright notice must be included in all copies or
 * derivative works.
 *
 * Copyright (c) 1996
 *
 *****************************************************************************/


/***********************************************************HeaderBegin*******
 *
 * File :       mom_trace.c
 *
 * Author :	Bruno LORET  <Loret@issy.cnet.fr>
 *
 * Created :	22-May-1996
 *
 * Description :
 *
 * Notes :
 *
 * Modified : 04.11.96 M.Wollborn: Extenden buffer_btos[32] to 33 elements
 *				   otherwise memory fault for format=32
 *	      06.09.99 Eishi Morimatsu (Fujitsu Labs.): added DRC support
 *
 ***********************************************************HeaderEnd*********/


/*******************        INCLUDE FILES       *******************************/
#include "mom_bitstream_d.h"
#include "mom_trace.h"
#include "string.h"




Char	bool[2][4]= {"NO " , "YES"};


Trace *
allocate_trace_file(Char *filename, Char *open_mode)
{
    Trace *trace;

    trace = (Trace *) malloc( sizeof(Trace) );

    if( strcmp(filename, "stdout"))
        trace->fp_trace = fopen(filename, open_mode);
    else    
        trace->fp_trace = stdout;
    

    trace->trace = 0;
    
    return (trace);
}

Void
free_trace_file(Trace *trace)
{
    fclose(trace->fp_trace);

    free(trace);
}




Void
trace_routine(Char *description, Int code, Char *codeword, Trace *trace, Int mode)
{
#ifdef _DEBUG_
  if(trace->trace)
  {
      switch (mode)
      {
          case CODE:

              fprintf(trace->fp_trace, "%-24.24s: 0x%-8x  : %32s\n", description, (int)code, codeword);
              break;

          case NUM:

              fprintf(trace->fp_trace, "%-24.24s: %-8d    : %32s\n", description, (int)code, codeword);
              break;

          case FLAG:

              fprintf(trace->fp_trace, "%-24.24s: %-8s    : %32s\n", description, bool[code], codeword);
              break;

          case MARK:

              fprintf(trace->fp_trace, "%-24.24s: %-8s    : %32s\n", description, "-", codeword);
              break;

          default:

              fprintf(trace->fp_trace, "ERROR: Undefined Trace mode\n");
              break;
      }
  }
  
  fflush(trace->fp_trace);
  
#endif
}

/****************************************************************************/
Void
BitstreamTraceVLC(VLCtab vlc, Char *s, Trace *trace)
{
    trace_routine(s, vlc.val, btos(vlc.val, vlc.len), trace, CODE);
}
/****************************************************************************/
Void
BitstreamTrace(Char *codeword, Char *s, Trace *trace)
{
    trace_routine(s, 0, codeword, trace, MARK);
}
/****************************************************************************/
Void
TraceBreakLine(Trace *trace)
{
#ifdef _DEBUG_
   if(trace->trace)
   {
       fprintf(trace->fp_trace, "************************************************************************\n");
   }
#endif
}

/****************************************************************************/
Char *
btos (Int n, Int format)
{
    static const long long tab_format[33] = {	 /* conversion longeur-> masque de bits 	 */
	0,
	1, 2, 4, 8, 16, 32, 64, 128,
	256, 512, 1024, 2048, 4096, 8192, 16384, 32768,
	65536, 131072, 262144, 524288, 1048576, 2097152, 4194304, 8388608,
	16777216, 33554432, 67108864, 134217728, 268435456, 536870912, 1073741824,
        (1<<31)  /*2147483648L*/
    };
	
    static Char     buffer_btos[33];	 /* buffer de pour stocker la chaine		 */
    register Char  *s = buffer_btos;	 /* s pointe au debut du buffer			 */

    while (format)
        *s++ = (tab_format[format--] & n) ? '1' : '0';	/* conversion bin>ASCII 	*/
		
    *s = 0;                             /* car de fin de chaine		*/
    return (buffer_btos); 		/* renvoie le debut de chaine	*/
}





/***********************************************************CommentBegin******
 *
 * -- SetTraceLevelsDefault -- set all trace levels to their default values
 *
 * Author :		
 *      Michael Wollborn (TUH)
 *
 * Created :		
 *	20.06.97
 *
 * Purpose :
 *	
 * Arguments in : 
 *	Trace *trace		trace information
 *
 * Arguments in/out :	
 *
 * Arguments out :	
 *	
 * Return values :	
 *	
 * Side effects :	
 *	
 * Description :
 *	
 * See also :
 *	
 * Modified : 
 *	
 ***********************************************************CommentEnd********/

Void SetTraceLevelsDefault(Trace *trace)
{
  /* Level 1 data */
  trace->VO_header  = trace->VO_header_def;
  trace->VOL_header = trace->VOL_header_def;
  trace->VOP_header = trace->VOP_header_def;
  
  /* Level 2 data */
  trace->MB_header  = trace->MB_header_def;
  trace->MB_motion  = trace->MB_motion_def;
  trace->MB_shape   = trace->MB_shape_def;
  trace->MB_texture = trace->MB_texture_def;
  
  /* Level 3 data */
  trace->MB_sdata               = trace->MB_sdata_def;
  trace->MB_tdata_before_IQ     = trace->MB_tdata_before_IQ_def;
  trace->MB_tdata_after_IQ      = trace->MB_tdata_after_IQ_def;
  trace->MB_tdata_after_IDCT    = trace->MB_tdata_after_IDCT_def;
  trace->MB_tdata_predicted     = trace->MB_tdata_predicted_def;
  trace->MB_tdata_reconstructed = trace->MB_tdata_reconstructed_def;
}




/***********************************************************CommentBegin******
 *
 * -- SetTraceLevelsFull -- set all trace levels to "1" (enabled)
 *
 * Author :		
 *      Michael Wollborn (TUH)
 *
 * Created :		
 *	20.06.97
 *
 * Purpose :
 *	
 * Arguments in : 
 *	Trace *trace		trace information
 *
 * Arguments in/out :	
 *
 * Arguments out :	
 *	
 * Return values :	
 *	
 * Side effects :	
 *	
 * Description :
 *	
 * See also :
 *	
 * Modified : 
 *	
 ***********************************************************CommentEnd********/

Void SetTraceLevelsFull(Trace *trace)
{
  /* Level 1 data */
  trace->VO_header  = 1;
  trace->VOL_header = 1;
  trace->VOP_header = 1;
  
  /* Level 2 data */
  trace->MB_header  = 1;
  trace->MB_motion  = 1;
  trace->MB_shape   = 1;
  trace->MB_texture = 1;
  
  /* Level 3 data */
  trace->MB_sdata               = 1;
  trace->MB_tdata_before_IQ     = 1;
  trace->MB_tdata_after_IQ      = 1;
  trace->MB_tdata_after_IDCT    = 1;
  trace->MB_tdata_predicted     = 1;
  trace->MB_tdata_reconstructed = 1;
}

/***********************************************************CommentBegin******
 *
 * -- SetTraceLevelsDeafultZero -- set all trace levels to "0" (disabled)
 *
 * Author :		
 *      Minhua Zhou (HHI)
 *
 * Created :		
 *	19.08.1997
 *
 * Purpose :
 *	
 * Arguments in : 
 *	Trace *trace		trace information
 *
 * Arguments in/out :	
 *
 * Arguments out :	
 *	
 * Return values :	
 *	
 * Side effects :	
 *	
 * Description :
 *	
 * See also :
 *	
 * Modified : 
 *	
 ***********************************************************CommentEnd********/

Void SetTraceLevelsDefaultZero(Trace *trace)
{
  trace->trace=0;
  /* Level 1 data */
  trace->VO_header_def  = 0;
  trace->VOL_header_def = 0;
  trace->VOP_header_def = 0;
  
  /* Level 2 data */
  trace->MB_header_def  = 0;
  trace->MB_motion_def  = 0;
  trace->MB_shape_def   = 0;
  trace->MB_texture_def = 0;
  
  /* Level 3 data */
  trace->MB_sdata_def               = 0;
  trace->MB_tdata_before_IQ_def     = 0;
  trace->MB_tdata_after_IQ_def      = 0;
  trace->MB_tdata_after_IDCT_def    = 0;
  trace->MB_tdata_predicted_def     = 0;
  trace->MB_tdata_reconstructed_def = 0;
}

/***********************************************************CommentBegin******
 *
 * -- SetTraceLevelsZero -- set all trace levels to "0" (disabled)
 *
 * Author :		
 *      Minhua Zhou (HHI)
 *
 * Created :		
 *	19.08.1997
 *
 * Purpose :
 *	
 * Arguments in : 
 *	Trace *trace		trace information
 *
 * Arguments in/out :	
 *
 * Arguments out :	
 *	
 * Return values :	
 *	
 * Side effects :	
 *	
 * Description :
 *	
 * See also :
 *	
 * Modified : 
 *	
 ***********************************************************CommentEnd********/

Void SetTraceLevelsZero(Trace *trace)
{
  trace->trace=0;
  /* Level 1 data */
  trace->VO_header  = 0;
  trace->VOL_header = 0;
  trace->VOP_header = 0;
  
  /* Level 2 data */
  trace->MB_header  = 0;
  trace->MB_motion  = 0;
  trace->MB_shape   = 0;
  trace->MB_texture = 0;
  
  /* Level 3 data */
  trace->MB_sdata               = 0;
  trace->MB_tdata_before_IQ     = 0;
  trace->MB_tdata_after_IQ      = 0;
  trace->MB_tdata_after_IDCT    = 0;
  trace->MB_tdata_predicted     = 0;
  trace->MB_tdata_reconstructed = 0;
}

/***********************************************************CommentBegin******
 *
 * -- PrintOutMBData -- print out the 3rd level trace data
 *
 * Author :		
 *      Minhua Zhou (HHI)
 *
 * Created :		
 *	23.06.97
 *
 * Purpose :
 *	
 * Arguments in : 
 *	Char *data_type
 *      SInt **mb_mask
 *      Sint **mb_data
 *      FILE *fout
 *
 * Arguments in/out :	
 *
 * Arguments out :	
 *	
 * Return values :	
 *	
 * Side effects :	
 *	
 * Description :
 *	
 * See also :
 *	
 * Modified :  06.09.99 Eishi Morimatsu (Fujitsu Labs.): created PrintOutMBData_32 for DRC
 *	      
 *	
 ***********************************************************CommentEnd********/

Void PrintOutMBData(
	Char *data_type,
        SInt mb_mask[6][64],
        SInt mb_data[6][64],
        FILE *fout
        )  
{
Int i,j,k,transparent[6];

fprintf(fout,"%s:\n",data_type);
 for (i=0;i<4;i++) {
  transparent[i]=1;
  for (j=0;j<64;j++)
   if (mb_mask[i][j]) {
     transparent[i]=0;
     continue;
    }
 } 
 transparent[4]=transparent[5]=0;
    

 if (strcmp(data_type,"MB_shape_data")
     &&strcmp(data_type,"MB_tdata_before_IQ")
     &&strcmp(data_type,"MB_tdata_after_IQ"))
 for (i=0;i<3;i++) {
   for (k=0;k<8;k++) {
      for(j=0;j<16;j++) {
       if (mb_mask[2*i+j/8][k*8+j%8])
        fprintf(fout," %3d",mb_data[2*i+j/8][k*8+j%8]);
         else 
          fprintf(fout,"   -");
       if (j==7) fprintf(fout,"   ");
      }
    fprintf(fout,"\n");
    }
    fprintf(fout,"\n");
   }
  else
  for (i=0;i<3;i++) {
    for (k=0;k<8;k++) {
      for(j=0;j<16;j++) {
        if (!transparent[2*i+j/8])
         fprintf(fout," %3d",mb_data[2*i+j/8][k*8+j%8]);
        else
         fprintf(fout,"   -"); 
        if (j==7) fprintf(fout,"   ");
      }
    fprintf(fout,"\n");
    }
    fprintf(fout,"\n");
   }


}
   
/* >>> added for DRC by Fujitsu (top)    <<< */

Void PrintOutMBData_32(
	Char *data_type,
        SInt mb_mask[6][256],
        SInt mb_data[6][256],
        FILE *fout
        )  
{
Int i,j,k,transparent[6];

fprintf(fout,"%s:\n",data_type);
 for (i=0;i<4;i++) {
  transparent[i]=1;
  for (j=0;j<256;j++)
   if (mb_mask[i][j]) {
     transparent[i]=0;
     continue;
    }
 } 
 transparent[4]=transparent[5]=0;
    

 if (strcmp(data_type,"MB_shape_data")
     &&strcmp(data_type,"MB_tdata_before_IQ")
     &&strcmp(data_type,"MB_tdata_after_IQ"))
 for (i=0;i<3;i++) {
   for (k=0;k<16;k++) {
      for(j=0;j<32;j++) {
       if (mb_mask[2*i+j/16][k*16+j%16])
        fprintf(fout," %3d",mb_data[2*i+j/16][k*16+j%16]);
         else 
          fprintf(fout,"   -");
       if (j==31) fprintf(fout,"   ");
      }
    fprintf(fout,"\n");
    }
    fprintf(fout,"\n");
   }
  else
  for (i=0;i<3;i++) {
    for (k=0;k<16;k++) {
      for(j=0;j<32;j++) {
        if (!transparent[2*i+j/16])
         fprintf(fout," %3d",mb_data[2*i+j/16][k*16+j%16]);
        else
         fprintf(fout,"   -"); 
        if (j==31) fprintf(fout,"   ");
      }
    fprintf(fout,"\n");
    }
    fprintf(fout,"\n");
   }


}
   
/* >>> added for DRC by Fujitsu (bottom) <<< */


