/* $Id: main.c,v 1.88 1998/09/04 19:08:06 hjlee Exp $ */
/****************************************************************************/
/*   MPEG4 Visual Texture Coding (VTC) Mode Software                        */
/*                                                                          */
/*   This software was jointly developed by the following participants:     */
/*                                                                          */
/*   Single-quant,  multi-quant and flow control                            */
/*   are provided by  Sarnoff Corporation                                   */
/*     Iraj Sodagar   (iraj@sarnoff.com)                                    */
/*     Hung-Ju Lee    (hjlee@sarnoff.com)                                   */
/*     Paul Hatrack   (hatrack@sarnoff.com)                                 */
/*     Shipeng Li     (shipeng@sarnoff.com)                                 */
/*     Bing-Bing Chai (bchai@sarnoff.com)                                   */
/*     B.S. Srinivas  (bsrinivas@sarnoff.com)                               */
/*                                                                          */
/*   Bi-level is provided by Texas Instruments                              */
/*     Jie Liang      (liang@ti.com)                                        */
/*                                                                          */
/*   Shape Coding is provided by  OKI Electric Industry Co., Ltd.           */
/*     Zhixiong Wu    (sgo@hlabs.oki.co.jp)                                 */
/*     Yoshihiro Ueda (yueda@hlabs.oki.co.jp)                               */
/*     Toshifumi Kanamaru (kanamaru@hlabs.oki.co.jp)                        */
/*                                                                          */
/*   OKI, Sharp, Sarnoff, TI and Microsoft contributed to bitstream         */
/*   exchange and bug fixing.                                               */
/*                                                                          */
/*                                                                          */
/* In the course of development of the MPEG-4 standard, this software       */
/* module is an implementation of a part of one or more MPEG-4 tools as     */
/* specified by the MPEG-4 standard.                                        */
/*                                                                          */
/* The copyright of this software belongs to ISO/IEC. ISO/IEC gives use     */
/* of the MPEG-4 standard free license to use this  software module or      */
/* modifications thereof for hardware or software products claiming         */
/* conformance to the MPEG-4 standard.                                      */
/*                                                                          */
/* Those intending to use this software module in hardware or software      */
/* products are advised that use may infringe existing  patents. The        */
/* original developers of this software module and their companies, the     */
/* subsequent editors and their companies, and ISO/IEC have no liability    */
/* and ISO/IEC have no liability for use of this software module or         */
/* modification thereof in an implementation.                               */
/*                                                                          */
/* Permission is granted to MPEG members to use, copy, modify,              */
/* and distribute the software modules ( or portions thereof )              */
/* for standardization activity within ISO/IEC JTC1/SC29/WG11.              */
/*                                                                          */
/* Copyright 1995, 1996, 1997, 1998 ISO/IEC                                 */
/****************************************************************************/


/************************************************************/
/*     Sarnoff Very Low Bit Rate Still Image Coder          */
/*     Copyright 1995, 1996, 1997, 1998 Sarnoff Corporation */
/************************************************************/

/****************************************************************************/
/*     Texas Instruments Predictive Embedded Zerotree (PEZW) Image Codec    */
/*     Copyright 1996, 1997, 1998 Texas Instruments	      		    */
/****************************************************************************/

#include <stdio.h>
#include <math.h>
#include <sys/stat.h>
#include "vm_config.h"  /* new */

/* #include <sys/times.h> */
#include <time.h>
#include <stdlib.h>

#include <sys/types.h> /* added by Sharp (99/2/16) */
#include <sys/stat.h> /* added by Sharp (99/2/16) */

#define DEFINE_GLOBALS

#include "dataStruct.h"
#include "globals.h"

#include "Utils.h"
#include "QM.h"
#include "errorHandler.h"
#include "startcode.h"
#include "states.h"

#include "bitpack.h"
#include "ac.h"
#include "ztscan.h"

#include "dwt.h"
#include "default.h"
#include "download_filter.h"

#include "main.h" 
#include "ShapeCodec.h"

#include "imagebox.h"	/* FPDAM: added by SAIT (99/09/03) */

/* added for bilevel quantization mode (PEZW) */
extern int PEZW_target_spatial_levels;
extern int PEZW_target_snr_levels;
extern int PEZW_target_bitrate;
#include "wvtPEZW.h"

/* Sven Brandau - 22-Nov-99: added for function declarations */
#include "PEZW_mpeg4.h"
#include "QMUtils.h"
#include "PEZW_textureLayerBQ.h"
#include "ztscanUtil.h"
#include "dwtmask.h"

#ifdef _CHECK_BITS_
File *fpe;
#endif

#ifdef _CHECK_HI_LO_
extern File *acfp;
#endif

/* new */
static Void TextureObjectLayer_dec(SOL_PARAMETERS_DEC *vm_param_dec, 
				   Int  target_spatial_levels, Int  target_snr_levels, FILTER ***pwvtfilter, 
				   Int  iTile, 
				   Int  count,	/* FPDAM : added by SAIT (99/09/03) */
				   FILE *bitfile, Int **table); /* modified by Sharp (99/2/16) */

static Void texture_packet_header_Dec(SOL_PARAMETERS_DEC *vm_param_dec, FILTER ***wvtfilter,
				      PICTURE **Image, Int *header_size);


 /* new */
Int  decoder;  /* new */


/* Argument variables - set defaults */
#if 0
static Char *parmFileDef      = "VTC_param.ctl";
#endif
static Char *statsFileDef     = "stat";
static Char *decRecImgFileDef = "decRec.yuv";
static Char *encRecImgFileDef = "encRec.yuv";

#if 0
static Char *parmFile;
#endif
static Char *statsFile;
static Char *decRecImgFile;
static Char *encRecImgFile;
static Char *recImgFile;
static Char fname[100];

static Char *bitFile;
static Char *bitFileAC;
static Int singleBitFile;

static Int shape_bits=0; /*FPDAM (99/09/03) */

/*begin: added by Sharp (99/2/16)*/
/* proto types */
static Void set_decode_tile_id_and_position(Int *iNumOfTile, Int **jump_table,
                                            Int **decode_tile_id, Int *table, Int header_size);
static Void header_Dec(SOL_PARAMETERS_DEC *vm_param_dec, FILTER ***wvtfilter, PICTURE **Image, Int *header_size);
static Void header_Dec_Common(SOL_PARAMETERS_DEC *vm_param_dec, FILTER ***wvtfilter, PICTURE **Image, Int *header_size, Int SkipShape); /* @@@@@@ */
static Void header_Enc_Common(FILTER **wvtfilter, SOL_PARAMETERS *vm_param, Int SkipShape); /* @@@@@ */
/* FPDAM begin: modified by SAIT (99/09/03) */
/*static Void tile_header_Dec();*/
static Void tile_header_Dec(SOL_PARAMETERS_DEC *vm_param_dec, FILTER **wvtfilter,Int iTile,Int count,Int TileX,Int TileY);
/* FPDAM end: modified by SAIT (99/09/03) */
static Void tile_table_Dec(Int *table);
static Void clear_coeffinfo();
static Int emit_bits_local( UShort data, Int size, FILE *fp );

/* static variable for tiling */
static Int used_bits;
/*end: added by Sharp (99/2/16)*/

static void getSpatialLayerDims()
{
  Int i, shift;

  /* Calc widths and heights for all spatial layers */
  for (i=0; i<mzte_codec.spatial_scalability_levels; ++i)
  {
    shift=mzte_codec.wvtDecompLev-mzte_codec.lastWvtDecompInSpaLayer[i][0]-1;
    mzte_codec.spaLayerWidth[i][0]=mzte_codec.width>>shift;
    mzte_codec.spaLayerHeight[i][0]=mzte_codec.height>>shift;

    if (mzte_codec.lastWvtDecompInSpaLayer[i][1]<0)
    {
       mzte_codec.spaLayerWidth[i][1]=mzte_codec.dcWidth;
       mzte_codec.spaLayerHeight[i][1]=mzte_codec.dcHeight;
    }
    else
    {
      shift=mzte_codec.wvtDecompLev-mzte_codec.lastWvtDecompInSpaLayer[i][1]-1;
      mzte_codec.spaLayerWidth[i][1]=mzte_codec.width>>shift;
      mzte_codec.spaLayerHeight[i][1]=mzte_codec.height>>shift;
    }

    if (mzte_codec.lastWvtDecompInSpaLayer[i][2]<0)
    {
       mzte_codec.spaLayerWidth[i][2]=mzte_codec.dcWidth;
       mzte_codec.spaLayerHeight[i][2]=mzte_codec.dcHeight;
    }
    else
    {
      shift=mzte_codec.wvtDecompLev-mzte_codec.lastWvtDecompInSpaLayer[i][2]-1;
      mzte_codec.spaLayerWidth[i][2]=mzte_codec.width>>shift;
      mzte_codec.spaLayerHeight[i][2]=mzte_codec.height>>shift;
    }
  }
}

static void setSpatialLayerDimsSQ(Int band)
{
  /* added for compatability for new MQ spatial layer flexability - ph 7/16 */
  Int i;
  
  if (band) /* BAND - wvtDecompLev spatial layers */
  {
    for (i=0; i<mzte_codec.wvtDecompLev; ++i)
    {
      mzte_codec.lastWvtDecompInSpaLayer[i][0] = i;
      mzte_codec.lastWvtDecompInSpaLayer[i][1]
	=mzte_codec.lastWvtDecompInSpaLayer[i][2] = i-1;
    }

    mzte_codec.spatial_scalability_levels=mzte_codec.wvtDecompLev;
  }
  else /* TREE - 1 spatial layer */
  {
    mzte_codec.lastWvtDecompInSpaLayer[0][0] = mzte_codec.wvtDecompLev-1;
    mzte_codec.lastWvtDecompInSpaLayer[0][1]
      =mzte_codec.lastWvtDecompInSpaLayer[0][2] = mzte_codec.wvtDecompLev-2;

    mzte_codec.spatial_scalability_levels=1;
  }

  getSpatialLayerDims();
}

/*********************************************************************/
/*********************************************************************/
/*                          ENCODING                                 */
/*********************************************************************/
/*********************************************************************/

/*******************************************************/
/*  Flush buffer and close file. Only and must be used */
/*   by encoder to close bitstream file                */
/*******************************************************/
static Void flush_buffer_file()
{
  flush_bits();
  flush_bytes();
}

static Void close_buffer_file(File *fp)
{
  flush_buffer_file();
  fclose(fp);
}

/*begin: added by Sharp (99/2/16)*/
/* FPDAM begin: modified by SAIT (99/09/03) */
/*static Void tile_header_Enc(Int tile_id)*/
static Void tile_header_Enc(FILTER **wvtfilter, SOL_PARAMETERS *vm_param,Int tile_id)
/* FPDAM end: modified by SAIT (99/09/03) */
{
  if ( mzte_codec.tiling_disable == 0 ){
    emit_bits((UShort)(TEXTURE_TILE_START_CODE>>16), 16);
    emit_bits((UShort)TEXTURE_TILE_START_CODE, 16);
    emit_bits((UShort)tile_id, 16);

    if ( mzte_codec.extension_type == 1 ){
      emit_bits((UShort)1, 16); /* reference tile_id1 */
      emit_bits((UShort)1, 16); /* reference tile_id2 */
    }
  }
/* FPDAM begin : added by SAIT (99/09/03) */
  if ( !mzte_codec.error_res_flag ) {
    if(mzte_codec.sa_dwt) {
      emit_bits((UShort)MARKER_BIT, 1);
      emit_bits((UShort)mzte_codec.texture_tile_type, 2);
      emit_bits((UShort)MARKER_BIT, 1);
#ifdef	_FPDAM_DBG_
fprintf(stderr,".............texture_tile_type=%d\n",mzte_codec.texture_tile_type);
#endif
    }
    if (mzte_codec.sa_dwt && mzte_codec.texture_tile_type == BOUNDA_TILE) {
      noteProgress("Encoding Tile Shape Bitstream ....");
/* FPDAM begin (99/09/03) */
      shape_bits +=
/* FPDAM end (99/09/03) */
      ShapeEnCoding(mzte_codec.Image[0].mask,
			mzte_codec.width,
			mzte_codec.height,
			mzte_codec.wvtDecompLev,
			vm_param->alphaTH,
			vm_param->change_CR_disable,
			vm_param->STO_const_alpha,
			vm_param->STO_const_alpha_value,
/*			vm_param->STO_shape_scalable =1,*/	/* FPDAM : deleted by SAIT (99/09/03) */
			vm_param->SNR_start_code_enable,
			wvtfilter);
    }
  }
/* FPDAM end : added by SAIT (99/09/03) */
}
/*end: added by Sharp (99/2/16)*/

/* begin: modified by D.-S.Cho, Samsung AIT (99/04/13) */
#if 0
Void texture_packet_header_Enc(FILTER **wvtfilter, SOL_PARAMETERS *vm_param) /* modified by Sharp (99/2/16) */
#endif
static Void texture_packet_header_Enc(FILTER **wvtfilter, SOL_PARAMETERS *vm_param) /* modified by Sharp (99/2/16) */
/* end: modified by D.-S.Cho, Samsung AIT (99/04/13) */
{
  Int  texture_object_id=0;

/* begin: added by Rockwell (99/3/3) */
/* IM: VTC error res */ 
  if (mzte_codec.error_res_flag)
    {
  /* make MSB=1 for error resilience, bbc, 11/5/98 */
	texture_object_id=1<<15;
/*  Int  texture_object_id=0;*/
    }
/* end: added by Rockwell (99/3/3) */

  /*------- Write header info to bitstream file -------*/
/* begin: added by Rockwell (99/3/3) */
  /* IM: VTC error res */ 
  /* write error res flag as byte because it is followed by texture marker, 
     which needs to be byte aligned */
  /* texture_err_res_disable = 0 => error res ON
     texture_err_res_disable = 1 => error res OFF */
  /* emit_bits((UShort)(mzte_codec.error_res_flag==0?(1<<7):0), 8); */
	flush_bits();

  if (mzte_codec.error_res_flag)
    noteProgress("--- ST Error Resilience ON ---");
	
/* begin: added by Rockwell (99/3/3) */
/* IM: VTC error res */ 
  if (mzte_codec.error_res_flag) {
		/* for error resilience, also refer to write_packet_header_to_file() */
		/* bbc, 11/5/98 */
		prev_TU_first=prev_TU_last=prev_TU_err=-1;
		flush_bytes(); /* to get alignment in buffer */
		emit_bits((UShort)1,2); /* first bit dummy, second bit HEC=1 */
		packet_size=0;
		/* end for error resilience, bbc, 11/5/98 */
	}
/* end: added by Rockwell (99/3/3) */
	
	header_Enc_Common(wvtfilter, vm_param, 1); /* @@@@@ */

/* begin: added by Rockwell (99/3/3) */
/* IM: VTC error res */ 
  if (mzte_codec.error_res_flag)
    {
	/* segment threshold, bbc, 11/16/98 */
      emit_bits(mzte_codec.segment_thresh,16);
/* begin: added for FDAM1 by Samsung AIT (2000/01/10) */
      emit_bits((UShort)MARKER_BIT, 1);
/* end: added for FDAM1 by Samsung AIT (2000/01/10) */
    }
/* end: added by Rockwell (99/3/3) */
}

static Void header_Enc_V1(FILTER **wvtfilter, SOL_PARAMETERS *vm_param)
{
  Int  texture_object_id=0;
  Int  texture_object_layer_shape=vm_param->sa_dwt;
  Int  wavelet_stuffing = 0x0f;
  Int  wavelet_upload;
  Int  wavelet_uniform;
  Int i;
  /*------- Write header info to bitstream file -------*/
  emit_bits((UShort)(STILL_TEXTURE_OBJECT_START_CODE>>16), 16);
  emit_bits((UShort)STILL_TEXTURE_OBJECT_START_CODE, 16);
  emit_bits((UShort)texture_object_id, 16);
  emit_bits((UShort)MARKER_BIT, 1);
  emit_bits((UShort)(vm_param->wvtType==0?0:1), 1);
  wavelet_upload=vm_param->wvtDownload!=0?1:0;
  emit_bits((UShort)wavelet_upload, 1);
  /* change #bits from 8 to 4 ph 7/16 */
  emit_bits((UShort)mzte_codec.wvtDecompLev, 4);
  /* new wavelet download SL: 17/07/98*/

  emit_bits((UShort)mzte_codec.scan_direction,1);
  emit_bits((UShort)mzte_codec.SNR_start_code_enable, 1);

  emit_bits((UShort)texture_object_layer_shape, 2);
  emit_bits((UShort)mzte_codec.quantization_type, 2);

  /* added for spatial layer flexability - ph 7/16 */
  if (mzte_codec.quantization_type==2) /* MQ */
  {
    Int i;

    emit_bits((UShort)mzte_codec.spatial_scalability_levels, 4);
    /* Calc number decomp layers for all spatial layers */
    if (mzte_codec.spatial_scalability_levels == 1)
    {
      mzte_codec.lastWvtDecompInSpaLayer[0][0]=mzte_codec.wvtDecompLev-1;
    }
    else if (mzte_codec.spatial_scalability_levels != mzte_codec.wvtDecompLev)
    {
      emit_bits((UShort)mzte_codec.defaultSpatialScale, 1);
      if (mzte_codec.defaultSpatialScale==0)
      {
	/* For the 1st spatial_scalability_levels-1 layers the luma componant
	   of lastWvtDecompInSpaLayer should have been filled in from the 
	   parameter file. */
	for (i=0; i<mzte_codec.spatial_scalability_levels-1; ++i)
	  emit_bits((UShort)mzte_codec.lastWvtDecompInSpaLayer[i][0], 4);

	mzte_codec.lastWvtDecompInSpaLayer\
	  [mzte_codec.spatial_scalability_levels-1][0]
	  =mzte_codec.wvtDecompLev-1;
      }
      else
      {
	Int sp0;

	sp0=mzte_codec.wvtDecompLev-mzte_codec.spatial_scalability_levels;
	mzte_codec.lastWvtDecompInSpaLayer[0][0]=sp0;
	  
	for (i=1; i<mzte_codec.spatial_scalability_levels; ++i)
	  mzte_codec.lastWvtDecompInSpaLayer[i][0]=sp0+i;
      }
    }
    else
    {
      for (i=0; i<mzte_codec.spatial_scalability_levels; ++i)
	mzte_codec.lastWvtDecompInSpaLayer[i][0]=i;
    }
    
    /* Calculate for chroma (one less than luma) */
    for (i=0; i<mzte_codec.spatial_scalability_levels; ++i)
      mzte_codec.lastWvtDecompInSpaLayer[i][1]
	=mzte_codec.lastWvtDecompInSpaLayer[i][2]
	=mzte_codec.lastWvtDecompInSpaLayer[i][0]-1;
  }
  
  if(wavelet_upload) {
    wavelet_uniform = (vm_param->wvtUniform!=0)?1:0;
    emit_bits((UShort)wavelet_uniform, 1);
    if(wavelet_uniform) {
      upload_wavelet_filters(wvtfilter[0]);
    }
    else {
      for(i=0;i<vm_param->wvtDecompLev;i++) 
	upload_wavelet_filters(wvtfilter[i]);
    }
  }



  emit_bits((UShort)wavelet_stuffing, 3);

  if (texture_object_layer_shape == 0x00) {
    emit_bits((UShort)mzte_codec.real_width, 15);
    emit_bits((UShort)MARKER_BIT, 1);
    emit_bits((UShort)mzte_codec.real_height, 15);
    emit_bits((UShort)MARKER_BIT, 1);
  }
  else { /* Arbitrary shape info, SL */
    /*horizontal_ref */
    emit_bits((UShort)mzte_codec.origin_x, 15);
    /* marker_bit */
    emit_bits((UShort)MARKER_BIT, 1);
    /*vertical_ref */
    emit_bits((UShort)mzte_codec.origin_y, 15);
    /* marker_bit */
    emit_bits((UShort)MARKER_BIT, 1);
    /* object_width */
    emit_bits((UShort)mzte_codec.width, 15);
     /* marker_bit */
    emit_bits((UShort)MARKER_BIT, 1);
    /* object_height */
    emit_bits((UShort)mzte_codec.height, 15);
    /* marker_bit */
    emit_bits((UShort)MARKER_BIT, 1);
    /* merge shape bitstream Into the main bitstream */
    noteProgress("Merge Shape Bitstream ....");
/*		This function is replaced with ShapeEnCoding()*/
/*    MergeShapeBitstream();*/
/* begin : modified by D.-S.Cho, Samsung AIT (99/04/13) */
    /*
    ShapeEnCoding(mzte_codec.Image[0].mask, mzte_codec.width, mzte_codec.height,
                  mzte_codec.wvtDecompLev,
			vm_param->alphaTH,
			vm_param->change_CR_disable,
                  vm_param->STO_const_alpha,
                  vm_param->STO_const_alpha_value,
                  vm_param->STO_shape_scalable =1,
                  vm_param->SNR_start_code_enable,
                  wvtfilter);
    */
    ShapeEnCoding_V1(mzte_codec.Image[0].mask, 
			mzte_codec.width, 
			mzte_codec.height,
			vm_param->alphaTH,
			vm_param->change_CR_disable,
                  	vm_param->STO_const_alpha,
                  	vm_param->STO_const_alpha_value);
/* end : modified by D.-S.Cho, Samsung AIT (99/04/13) */
  }
}
static long header_Enc(FILTER **wvtfilter, SOL_PARAMETERS *vm_param) /* modified by Sharp (99/2/16) */
{
  Int i;
  long tile_table_position = 0; /* added by Sharp (99/2/16) */

#if 0	/* deleted by Sharp(99/4/7), This part is moved to the texture_packet_header_Enc() */
/* begin: added by Rockwell (99/3/3) */
/* IM: VTC error res */ 
  if (mzte_codec.error_res_flag)
    {
  /* make MSB=1 for error resilience, bbc, 11/5/98 */
	texture_object_id=1<<15;
/*  Int  texture_object_id=0;*/
    }
/* end: added by Rockwell (99/3/3) */
#endif

  /*------- Write header info to bitstream file -------*/
  emit_bits((UShort)(STILL_TEXTURE_OBJECT_START_CODE>>16), 16);
  emit_bits((UShort)STILL_TEXTURE_OBJECT_START_CODE, 16);

  emit_bits((UShort)mzte_codec.tiling_disable, 1); /* added by Sharp (99/2/16) */

/* begin: added by Rockwell (99/3/3) */
  /* IM: VTC error res */ 
  /* write error res flag as byte because it is followed by texture marker, 
     which needs to be byte aligned */
  /* texture_err_res_disable = 0 => error res ON
     texture_err_res_disable = 1 => error res OFF */
  /* emit_bits((UShort)(mzte_codec.error_res_flag==0?(1<<7):0), 8); */
  emit_bits((UShort)(mzte_codec.error_res_flag==0?1:0), 1);

#if 0	/* deleted by Sharp(99/4/7), This part is moved to the texture_packet_header_Enc() */
	if ( mzte_codec.error_res_flag )
		flush_bits();

  if (mzte_codec.error_res_flag)
    noteProgress("--- ST Error Resilience ON ---");
#endif
	
/*	if (!mzte_codec.error_res_flag)*/ /* @@@@@@ */
		header_Enc_Common(wvtfilter, vm_param, 0); /* @@@@@@ */

/* end: added by Rockwell (99/3/3) */

/* begin: added by Sharp (99/2/16) */
  if ( mzte_codec.tiling_disable == 0 ){
/*		header_Enc_Common(wvtfilter, vm_param);*/

    emit_bits((UShort)mzte_codec.tile_width, 15); /* modified by Sharp (99/11/16) */
		emit_bits((UShort)1, 1);    /* marker_bit */
    emit_bits((UShort)mzte_codec.tile_height, 15);/* modified by Sharp (99/11/16) */
		emit_bits((UShort)1, 1);
    emit_bits((UShort)mzte_codec.iNumOfTile, 16);
    emit_bits((UShort)1, 1);    /* marker_bit */

/*		mzte_codec.tiling_jump_table_enable = 0;*/
		emit_bits((UShort)mzte_codec.tiling_jump_table_enable, 1);    /* tiling_jump_table_enable */
		mzte_codec.extension_type = 0;  /* extension_type is fixed to 0 */
		used_bits = current_put_bits() % 8;
    flush_bytes();
		if ( mzte_codec.tiling_jump_table_enable == 1 ){
			tile_table_position = current_fp();
			printf("tile_table_position = %ld\n", tile_table_position);
			for ( i=0; i<mzte_codec.iNumOfTile; i++ ) {
				emit_bits((UShort)1, 34);   /* 34 = 16(tile_w) + 1(marker) + 16(tile_h) + 1(marker) */
			}
		}
		/* next_start_code */
		emit_bits(0, 1);
		{
			Int bits, data;
			bits = current_put_bits();
			bits = 8 - (bits % 8);
			if (bits != 0 && bits != 8) {
					data = (1 << bits) - 1;
					emit_bits(data, bits);
			}
		}
  }
  return tile_table_position;
/* end: added by Sharp (99/2/16) */
}

/* begin: added by Sharp (99/2/16) */
static Void header_Enc_Common(FILTER **wvtfilter, SOL_PARAMETERS *vm_param, Int SkipShape) /* @@@@@ */
{
  Int  texture_object_id=0;
  Int  texture_object_layer_shape=vm_param->sa_dwt;
  Int  wavelet_stuffing = 0x0f;
  Int  wavelet_upload;
  Int  wavelet_uniform;
  Int i;


/*begin: deleted by Sharp (99/4/7), this part is moved to texture_packet_header_Enc()*/
#if 0
/* begin: added by Rockwell (99/3/3) */
/* IM: VTC error res */ 
  if (mzte_codec.error_res_flag)
    {
	/* for error resilience, also refer to write_packet_header_to_file() */
	/* bbc, 11/5/98 */
	prev_TU_first=prev_TU_last=prev_TU_err=-1;
	flush_bytes(); /* to get alignment in buffer */
	emit_bits((UShort)1,2); /* first bit dummy, second bit HEC=1 */
	packet_size=0;
	/* end for error resilience, bbc, 11/5/98 */
    }
/* end: added by Rockwell (99/3/3) */
#endif
/*end: deleted by Sharp (99/4/7), this part is moved to texture_packet_header_Enc()*/

  /*------- Write header info to bitstream file -------*/
  emit_bits((UShort)texture_object_id, 16);
  emit_bits((UShort)MARKER_BIT, 1);
  emit_bits((UShort)(vm_param->wvtType==0?0:1), 1);
  wavelet_upload=vm_param->wvtDownload!=0?1:0;
  emit_bits((UShort)wavelet_upload, 1);
  /* change #bits from 8 to 4 ph 7/16 */
  emit_bits((UShort)mzte_codec.wvtDecompLev, 4);
  /* new wavelet download SL: 17/07/98*/

  emit_bits((UShort)mzte_codec.scan_direction,1);
  emit_bits((UShort)mzte_codec.SNR_start_code_enable, 1);

  emit_bits((UShort)texture_object_layer_shape, 2);
  emit_bits((UShort)mzte_codec.quantization_type, 2);

  /* added for spatial layer flexability - ph 7/16 */
  if (mzte_codec.quantization_type==2) /* MQ */
  {
    Int i;

    emit_bits((UShort)mzte_codec.spatial_scalability_levels, 4);
    /* Calc number decomp layers for all spatial layers */
    if (mzte_codec.spatial_scalability_levels == 1)
    {
      mzte_codec.lastWvtDecompInSpaLayer[0][0]=mzte_codec.wvtDecompLev-1;
    }
    else if (mzte_codec.spatial_scalability_levels != mzte_codec.wvtDecompLev)
    {
      emit_bits((UShort)mzte_codec.defaultSpatialScale, 1);
      if (mzte_codec.defaultSpatialScale==0)
      {
	/* For the 1st spatial_scalability_levels-1 layers the luma componant
	   of lastWvtDecompInSpaLayer should have been filled in from the 
	   parameter file. */
	for (i=0; i<mzte_codec.spatial_scalability_levels-1; ++i)
	  emit_bits((UShort)mzte_codec.lastWvtDecompInSpaLayer[i][0], 4);

	mzte_codec.lastWvtDecompInSpaLayer\
	  [mzte_codec.spatial_scalability_levels-1][0]
	  =mzte_codec.wvtDecompLev-1;
      }
      else
      {
	Int sp0;

	sp0=mzte_codec.wvtDecompLev-mzte_codec.spatial_scalability_levels;
	mzte_codec.lastWvtDecompInSpaLayer[0][0]=sp0;
	  
	for (i=1; i<mzte_codec.spatial_scalability_levels; ++i)
	  mzte_codec.lastWvtDecompInSpaLayer[i][0]=sp0+i;
      }
    }
    else
    {
      for (i=0; i<mzte_codec.spatial_scalability_levels; ++i)
	mzte_codec.lastWvtDecompInSpaLayer[i][0]=i;
    }
    
    /* Calculate for chroma (one less than luma) */
    for (i=0; i<mzte_codec.spatial_scalability_levels; ++i)
      mzte_codec.lastWvtDecompInSpaLayer[i][1]
	=mzte_codec.lastWvtDecompInSpaLayer[i][2]
	=mzte_codec.lastWvtDecompInSpaLayer[i][0]-1;
  }
  
  if(wavelet_upload) {
    wavelet_uniform = (vm_param->wvtUniform!=0)?1:0;
    emit_bits((UShort)wavelet_uniform, 1);
    if(wavelet_uniform) {
      upload_wavelet_filters(wvtfilter[0]);
    }
    else {
      for(i=0;i<vm_param->wvtDecompLev;i++) 
	upload_wavelet_filters(wvtfilter[i]);
    }
  }

  emit_bits((UShort)wavelet_stuffing, 3);

/* begin: added for FDAM1 by Samsung AIT (2000/01/10) */
  if (mzte_codec.error_res_flag && SkipShape==0)
    {
      emit_bits(mzte_codec.segment_thresh,16);
      emit_bits((UShort)MARKER_BIT, 1);
    }
/* end: added for FDAM1 by Samsung AIT (2000/01/10) */

  if (texture_object_layer_shape == 0x00) {
/*begin: delted by Sharp (99/2/16)*/
/*			emit_bits((UShort)mzte_codec.real_width, 15);
			emit_bits((UShort)MARKER_BIT, 1);
			emit_bits((UShort)mzte_codec.real_height, 15);
			emit_bits((UShort)MARKER_BIT, 1); */
/*end: delted by Sharp (99/2/16)*/
/* begin: added by Sharp (99/2/16) */
		emit_bits((UShort)mzte_codec.display_width, 15);
		emit_bits((UShort)MARKER_BIT, 1);
		emit_bits((UShort)mzte_codec.display_height, 15);
		emit_bits((UShort)MARKER_BIT, 1);
/* end: added by Sharp (99/2/16) */
  }
  else { /* Arbitrary shape info, SL */
/* FPDAM begin: modified by SAIT (99/09/03) */
#if 0
    /*horizontal_ref */
    emit_bits((UShort)mzte_codec.origin_x, 15);
    /* marker_bit */
    emit_bits((UShort)MARKER_BIT, 1);
    /*vertical_ref */
    emit_bits((UShort)mzte_codec.origin_y, 15);
    /* marker_bit */
    emit_bits((UShort)MARKER_BIT, 1);
    /* object_width */
    emit_bits((UShort)mzte_codec.width, 15);
     /* marker_bit */
    emit_bits((UShort)MARKER_BIT, 1);
    /* object_height */
    emit_bits((UShort)mzte_codec.height, 15);
    /* marker_bit */
    emit_bits((UShort)MARKER_BIT, 1);
#endif
    /*horizontal_ref */
    emit_bits((UShort)mzte_codec.object_origin_x, 15);
    /* marker_bit */
    emit_bits((UShort)MARKER_BIT, 1);
    /*vertical_ref */
    emit_bits((UShort)mzte_codec.object_origin_y, 15);
    /* marker_bit */
    emit_bits((UShort)MARKER_BIT, 1);
    /* object_width */
    emit_bits((UShort)mzte_codec.object_width, 15);
     /* marker_bit */
    emit_bits((UShort)MARKER_BIT, 1);
    /* object_height */
    emit_bits((UShort)mzte_codec.object_height, 15);
    /* marker_bit */
    emit_bits((UShort)MARKER_BIT, 1);
/* FPDAM end: modified by SAIT (99/09/03) */
    /* merge shape bitstream Into the main bitstream */
/* SAIT_V2 begin : modified by Samsung AIT (99/02/23) */
#if 0
    noteProgress("Merge Shape Bitstream ....");
    MergeShapeBitstream();
#endif
/* FPDAM begin : added by SAIT (99/09/03) */
    if(mzte_codec.tiling_disable==1 && SkipShape == 0) { /* @@@@@ */
/* FPDAM end : added by SAIT (99/09/03) */
    noteProgress("Encoding Shape Bitstream ....");
/* FPDAM begin (99/09/03) */
    shape_bits +=
/* FPDAM end (99/09/03) */
    ShapeEnCoding(mzte_codec.Image[0].mask, mzte_codec.width, mzte_codec.height,
                  mzte_codec.wvtDecompLev,
			vm_param->alphaTH,
			vm_param->change_CR_disable,
                  vm_param->STO_const_alpha,
                  vm_param->STO_const_alpha_value,
/*                  vm_param->STO_shape_scalable =1,*/	/* FPDAM : deleted by SAIT (99/09/03) */
                  vm_param->SNR_start_code_enable,
                  wvtfilter);
/* FPDAM begin : added by SAIT (99/09/03) */
    } 
/* FPDAM end : added by SAIT (99/09/03) */
/* SAIT_V2 end */
  }

/* @@@@@@ */
  if ( mzte_codec.tiling_disable == 0 && SkipShape == 1){
    emit_bits((UShort)mzte_codec.tile_width, 15); /* modified by Sharp (99/11/29) */
		emit_bits((UShort)1, 1);    /* marker_bit */
    emit_bits((UShort)mzte_codec.tile_height, 15); /* modified by Sharp (99/11/29) */
		emit_bits((UShort)1, 1);
	}

/* This part is moved to packet_texture_header_Enc() */
#if 0
/* begin: added by Rockwell (99/3/3) */
/* IM: VTC error res */ 
  if (mzte_codec.error_res_flag)
    {
	/* segment threshold, bbc, 11/16/98 */
      emit_bits(mzte_codec.segment_thresh,16);
    }
/* end: added by Rockwell (99/3/3) */
#endif

}
/* end: added by Sharp (99/2/16) */


/* put  quant value and maximums on the bitstream */
static Void Put_Quant_and_Max(SNR_IMAGE *snr_image, Int spaLayer, Int color)
{
    /* put  quant value and maximums on the bitstream */
    put_param(snr_image->quant, 7);
    /*    emit_bits((UShort)MARKER_BIT, 1); */ /* 1124 */
    {
      Int l;
      
      for (l=0; l<=mzte_codec.lastWvtDecompInSpaLayer[spaLayer][color];++l)
      {
		/* put_param(snr_image->wvtDecompNumBitPlanes[l],5); */
		emit_bits((UShort)snr_image->wvtDecompNumBitPlanes[l],5);

		if (((l+1) % 4) == 0)
		  emit_bits((UShort)MARKER_BIT, 1);
      }
    }

}

/* put  quant value and maximums on the bitstream */
static Void Put_Quant_and_Max_SQBB(SNR_IMAGE *snr_image, Int spaLayer,
				   Int color)
{
    /* put  quant value and maximums on the bitstream */
  if ((color==0 && spaLayer==0) || (color>0 && spaLayer==1))
    put_param(snr_image->quant, 7);


  if (color==0)
    /* put_param(snr_image->wvtDecompNumBitPlanes[spaLayer],5); */
    emit_bits((UShort)snr_image->wvtDecompNumBitPlanes[spaLayer],5); 
  else if (spaLayer)
    /* put_param(snr_image->wvtDecompNumBitPlanes[spaLayer-1],5); */
    emit_bits((UShort)snr_image->wvtDecompNumBitPlanes[spaLayer-1],5);


}



static Void textureLayerDC_Enc()
{
  Int col, err;

  noteProgress("Encoding DC coefficients....");

  for (col=0; col<mzte_codec.colors; col++) 
  {
    /* Set global color variable */
    mzte_codec.curColor=col;

    /* initialize DC coefficient info */
    if ((err=ztqInitDC(0, col)))
      errorHandler("ztqInitDC");

    /* quantize DC coefficients */
    if ((err=encQuantizeDC(col)))
      errorHandler("encQuantizeDC");

    /* losslessly encoding DC coefficients */
    wavelet_dc_encode(col);

    /* writeStats(); */  /* new */
  }  
  noteProgress("Completed encoding DC coefficients.");
}


/*******************************************************
  The following two routines are for single quant
  band by band scan order.
*******************************************************/
static Void TextureSpatialLayerSQNSC_enc(Int spa_lev)
{
  Int col;
  SNR_IMAGE *snr_image;
	
  /* hjlee 0901 */
  /* hjlee 0827 */
    for (col=0; col<mzte_codec.colors; col++) {
      snr_image = &(mzte_codec.SPlayer[col].SNRlayer.snr_image);
      Put_Quant_and_Max_SQBB(snr_image, spa_lev, col);
    }
	for (col=0; col<mzte_codec.colors; col++) {
        noteProgress("Single-Quant Mode (Band by Band) - Spatial %d, SNR 0, "\
	              "Color %d",spa_lev,col);

        mzte_codec.curColor = col;
	    if (spa_lev !=0 || col ==0) {
            wavelet_higher_bands_encode_SQ_band(col);
	    }
    }

	
} 



static Void TextureSpatialLayerSQ_enc(Int spa_lev, File *bitfile)
{
  /*------- AC: Open and initialize bitstream file -------*/
  if (singleBitFile==0)
  {
    sprintf(fname,bitFileAC,spa_lev,0);
    if ((bitfile=fopen(fname,"wb"))==NULL)
      errorHandler("Can't open file '%s' for writing.",fname);
  }
 
/* begin: added by Rockwell (99/3/3) */ 
  /* initialize the buffer */
  /* IM: quick fix for error res */
  /* init_bit_packing_fp(bitfile,1); */
/* end: added by Rockwell (99/3/3) */

  /*------- AC: Write header info to bitstream file -------*/
  emit_bits(TEXTURE_SPATIAL_LAYER_START_CODE >> 16, 16);
  emit_bits(TEXTURE_SPATIAL_LAYER_START_CODE, 16);
  emit_bits(spa_lev, 5);


  TextureSpatialLayerSQNSC_enc(spa_lev);
  
  /*------- AC: Close bitstream file -------*/
  if (singleBitFile) {
/* begin: added by Rockwell (99/3/3) */ 
    /* IM: quick fix for error res */
    if (mzte_codec.error_res_flag) {
      flush_bits();
      /* flush_buffer_file(); */
    }
    else
      flush_buffer_file(); 
  }
/* end: added by Rockwell (99/3/3) */
  else
    close_buffer_file(bitfile);
}




static Void textureLayerSQ_Enc(File *bitfile)
{
  Int col, err, spa_lev;
  SNR_IMAGE *snr_image;
    
  noteProgress("Encoding AC coefficients - Single-Quant Mode....");
  
  /*------- AC: Set spatial and SNR levels to zero -------*/
  mzte_codec.curSpatialLev = 0;
  mzte_codec.curSNRLev = 0;

  /* added for compatability with MQ spatial layer flexability - ph 7/16 */
  setSpatialLayerDimsSQ(0);

  for (col=0; col<mzte_codec.colors; col++)
  {     
    snr_image=&(mzte_codec.SPlayer[col].SNRlayer.snr_image);
    
    /* Set global color variable */
    mzte_codec.curColor = col;
    snr_image->quant = mzte_codec.Qinfo[col][0].Quant[0];
    
    /* initialization of spatial dimensions for each color component */
    setSpatialLevelAndDimensions(0, col);
    
    /* initialize AC coefficient info for each color component */
    if ((err=ztqInitAC(0, col)))
      errorHandler("ztqInitAC");
    
    /* quantize and mark zerotree structure for AC coefficients */
    if ((err=encQuantizeAndMarkAC(col)))
      errorHandler("encQuantizeAndMarkAC");
  }
  

  /*------- AC: encode all color components -------*/
  if (mzte_codec.scan_direction==0) /* tree-depth scan */
  {
    /* put  quant value and maximums on the bitstream */
    for(col=0;col<mzte_codec.colors; col++){
      snr_image=&(mzte_codec.SPlayer[col].SNRlayer.snr_image);
      Put_Quant_and_Max(snr_image,0,col);
    }
    
    /* losslessly encoding AC coefficients */
    wavelet_higher_bands_encode_SQ_tree();      
  }
  else  /* band by band scan */
  {

    /* hjlee 0827 */
    /* put  quant value and maximums on the bitstream */
	  /*
     for(col=0;col<mzte_codec.colors; col++){
      snr_image=&(mzte_codec.SPlayer[col].SNRlayer.snr_image);
      Put_Quant_and_Max_SQBB(snr_image,0,col);
    }
    */

    /* hjlee 0827 */
    /*------- DC: Close bitstream file -------*/
    /* if (snrStartCode) {
      if(singleBitFile) 
	flush_buffer_file(); 
      else  
	close_buffer_file(bitfile); 
    }
    */


   
    /* added for compatability with MQ spatial layer flexability - ph 7/16 */
    setSpatialLayerDimsSQ(1);

    /* Assumes all three color components have the same number of SNR 
       levels */
    for (col=0; col<mzte_codec.colors; col++)
      mzte_codec.SPlayer[col].SNR_scalability_levels = 1;
    
    /* Loop through spatial layers */
    for (spa_lev=0; spa_lev<mzte_codec.spatial_scalability_levels; 
         spa_lev++)
    {

	  /* hjlee 0901 */
	  /*
      if (spa_lev)
      {
	    for (col=0;col<mzte_codec.colors; col++)
		{
	      snr_image=&(mzte_codec.SPlayer[col].SNRlayer.snr_image);
	      Put_Quant_and_Max_SQBB(snr_image,spa_lev,col);
		}
      }
	  */

      mzte_codec.curSpatialLev=spa_lev;
      for (col=0; col<mzte_codec.colors; col++)
   	      setSpatialLevelAndDimensions(spa_lev,col);

      /*----- AC: Set global spatial layer. -----*/
      mzte_codec.curSpatialLev = spa_lev;
      
      /* Update spatial level coeff info if changing spatial levels.
            Do this for all color components */
      if (snrStartCode)
	     TextureSpatialLayerSQ_enc(spa_lev,bitfile);
      else
	     TextureSpatialLayerSQNSC_enc(spa_lev);
    }
  }
  
  /* store the max snr_lev and spa_lev so that the decoder can
     decode the bitstream up to the max level. */ 
  mzte_codec.target_spatial_levels = 1;
  mzte_codec.target_snr_levels = 1;
  
  noteProgress("Completed encoding AC coefficients - Single-Quant Mode.");
}



static Void TextureSNRLayerMQ_encode(Int spa_lev, Int snr_lev, File *fp)
{
  SNR_IMAGE *snr_image;
  Int col;
  static Int texture_snr_layer_id=0;

  if(snrStartCode){
    noteProgress("Encoding Multi-Quant Mode Layer with SNR start code....");
    /* header */  
    emit_bits((UShort)texture_snr_layer_start_code>>16,16);
    emit_bits((UShort)texture_snr_layer_start_code,16);
    emit_bits((UShort)texture_snr_layer_id++,5);
  }
  else
    noteProgress("Encoding Multi-Quant Mode Layer without SNR start code....");

  noteProgress("Multi-Quant Mode - Spatial %d, SNR %d", spa_lev,snr_lev);

  for(col=0;col < NCOL; col++)
  {
    noteDetail("width=%d  height=%d",mzte_codec.SPlayer[col].width,
	      mzte_codec.SPlayer[col].height);    

    /* Set global color variable */
    mzte_codec.curColor = col;
    
    /* Set quant value */
    snr_image=&(mzte_codec.SPlayer[col].SNRlayer.snr_image);
    snr_image->quant = mzte_codec.Qinfo[col][spa_lev].Quant[snr_lev];
    noteDebug("AC quant=%d", 
               mzte_codec.Qinfo[col][spa_lev].Quant[snr_lev]);
        
    /* initialization of spatial dimensions for each color component */
    if (snr_lev==0) 
      setSpatialLevelAndDimensions(spa_lev, col);

    /* get maximum residual value - this one is derived from user Q inputs not 
       actual values. Also assign skip modes. */
    updateResidMaxAndAssignSkips(col);
    noteDebug("resid_max=%d\n",snr_image->residual_max);

    /* quantize and mark zerotree structure for AC coefficients */
    if (encQuantizeAndMarkAC(col))
      errorHandler("encQuantizeAndMarkAC");

    Put_Quant_and_Max(snr_image,spa_lev,col);
  }

  wavelet_higher_bands_encode_MQ(mzte_codec.scan_direction);    

  for(col=0; col < NCOL; col++)
  {
    /* Set global color variable */
    mzte_codec.curColor = col;
    
    /* Update states of AC coefficients */
    if (encUpdateStateAC(mzte_codec.curColor))
      errorHandler("encUpdateStateAC");
  }
}
 
static Void textureLayerMQ_Enc(File *bitfile)
{
  Int err, spa_lev, snr_lev=0, snr_scalability_levels;

  /* removed - ph 7/16
  emit_bits((UShort)mzte_codec.spatial_scalability_levels, 5); */
 
  /* hjlee 0827 */
  /*
  if (snrStartCode)
    flush_buffer_file();
    */

  
  /* added for spatial layer flexability - ph 7/16 */
  getSpatialLayerDims();

  /*------- AC: Initialize QList Structure -------*/
  if ((err=ztqQListInit()))
    errorHandler("Allocating memory for QList information.");
  
  /* Initialize coeffs */
  setSpatialLevelAndDimensions(0,0);
  if ((err=ztqInitAC(0,0)))
    errorHandler("ztqInitAC");
  
  if (mzte_codec.colors > 1)
  {
    if (mzte_codec.lastWvtDecompInSpaLayer[0][1]<0)
      setSpatialLevelAndDimensions(1,1);
    else
      setSpatialLevelAndDimensions(0,1);
    if ((err=ztqInitAC(0,1)))
      errorHandler("ztqInitAC");
  }
  if (mzte_codec.colors > 2)
  {
    if (mzte_codec.lastWvtDecompInSpaLayer[0][2]<0)
      setSpatialLevelAndDimensions(1,2);
    else
      setSpatialLevelAndDimensions(0,2);
    if ((err=ztqInitAC(0,2)))
      errorHandler("ztqInitAC");
  }

  /* Loop through spatial layers */
  for (spa_lev=0; spa_lev<mzte_codec.spatial_scalability_levels; 
       spa_lev++)
  {
    /*----- AC: Set global spatial layer and SNR scalability level. -----*/
    /* Assumes all three color components have the same number of SNR 
       levels */
    mzte_codec.curSpatialLev = spa_lev;
    mzte_codec.SPlayer[0].SNR_scalability_levels = 
      mzte_codec.Qinfo[0][spa_lev].SNR_scalability_levels;
    snr_scalability_levels = mzte_codec.SPlayer[0].SNR_scalability_levels;
    
    /* Update spatial level coeff info if changing spatial levels.
       Do this for all color components. */
    if (spa_lev != 0)
    {
      for (mzte_codec.curColor = 0; mzte_codec.curColor<mzte_codec.colors;
	   mzte_codec.curColor++) 
      {
	setSpatialLevelAndDimensions(mzte_codec.curSpatialLev, 
				     mzte_codec.curColor);
	if (mzte_codec.lastWvtDecompInSpaLayer[spa_lev-1][mzte_codec.curColor]
	    >=0)
	  spatialLayerChangeUpdate(mzte_codec.curColor);
      }
    }
    
    if (!snrStartCode)
      /*------- AC: Write header info to bitstream file -------*/
      emit_bits(snr_scalability_levels, 5);    
    
    /* Loop through SNR layers */      
    for (snr_lev=0; snr_lev<snr_scalability_levels; snr_lev++) 
    {
      /*----- AC: Set global SNR layer -----*/
      mzte_codec.curSNRLev = snr_lev;
      
      if (snrStartCode)
      {
		/*------- AC: Open and initialize bitstream file -------*/
		if (singleBitFile==0)
		{
		  sprintf(fname,bitFileAC,
			  mzte_codec.curSpatialLev, mzte_codec.curSNRLev);
		  if ((bitfile=fopen(fname,"wb"))==NULL)
			errorHandler("Can't open file '%s' for writing.",fname);
		}
	
		/* initialize the buffer */
		init_bit_packing_fp(bitfile,1);
		
		if (snr_lev==0) {
		  /*------- AC: Write header info to bitstream file -------*/
		  emit_bits(TEXTURE_SPATIAL_LAYER_START_CODE >> 16, 16);
		  emit_bits(TEXTURE_SPATIAL_LAYER_START_CODE, 16);
		  emit_bits(spa_lev, 5);
		  emit_bits(snr_scalability_levels, 5);
		  flush_bits();     /* byte alignment before snr start code */
		}
	
      }
      
      /*------- AC: Quantize and encode all color components -------*/
      TextureSNRLayerMQ_encode(spa_lev, snr_lev, bitfile);
      if (snrStartCode)
      {
		if (singleBitFile)
		  flush_buffer_file();
		else
		  close_buffer_file(bitfile);
      }
      
      
    } /* snr_lev */
    
  }  /* spa_lev */
  
  /* store the max snr_lev and spa_lev so that the decoder can
     decode the bitstream up to the max level. */ 
  mzte_codec.target_spatial_levels = spa_lev;
  mzte_codec.target_snr_levels = snr_lev;
  
  /*------- AC: Free Qlist structure -------*/
  ztqQListExit();
  
}

#ifdef _MBQ_
#include "MBQEnc.c"
#endif

static Void TextureObjectLayer_enc_V1(FILTER **wvtfilter, SOL_PARAMETERS *vm_param)
{
  File *bitfile;

  /*-------------------------------------------------*/
  /*--------- DC (and overall header info) ----------*/
  /*-------------------------------------------------*/

  /*------- DC: Open and initialize bitstream file -------*/
  if ((bitfile=fopen(bitFile,"wb"))==NULL)
    errorHandler("Can't open file '%s' for writing.",bitFile);

  /* initialize variables */
  init_bit_packing_fp(bitfile,1);

  /* Write header info to bitstream */
  header_Enc_V1(wvtfilter, vm_param);

  /*------- DC: Quantize and encode all color components -------*/
  textureLayerDC_Enc();

  /*------- DC: Close bitstream file -------*/
  /* hjlee 0827 */
  if (snrStartCode){
    if(singleBitFile) 
      flush_buffer_file(); 
    else  
      close_buffer_file(bitfile); 
  }
  


  /*-------------------------------------------------*/
  /*--------------------- AC ------------------------*/
  /*-------------------------------------------------*/

  /*------- AC: SINGLE-QUANT MODE -------*/
  if (mzte_codec.quantization_type == SINGLE_Q)
    textureLayerSQ_Enc(bitfile);
  /*------- AC: MULTI-QUANT MODE -------*/
  else if (mzte_codec.quantization_type == MULTIPLE_Q)
    textureLayerMQ_Enc(bitfile);
  /*------- AC: BILEVEL-QUANT MODE -------*/
  else if (mzte_codec.quantization_type == BILEVEL_Q)
    textureLayerBQ_Enc(bitfile);
#ifdef _MBQ_
  else if (mzte_codec.quantization_type == MULTBUF_Q)
    textureLayerMBQ_Enc(bitfile);
#endif

  if (singleBitFile){
    if(!snrStartCode)
      close_buffer_file(bitfile);
    else
      fclose(bitfile);
  }
}

static Void TextureObjectLayer_enc(FILTER **wvtfilter, SOL_PARAMETERS *vm_param, FILE *bitfile) /* modified by Sharp (99/4/7) */
{
/*  File *bitfile;*/
/*  Char filename[100]; */ /* added by Sharp(99/2/16) */

/* FPDAM begin: added by SAIT (99/09/03) */
  if(mzte_codec.tiling_disable!=0 || !mzte_codec.sa_dwt || mzte_codec.texture_tile_type!=TRANSP_TILE) {
/* FPDAM end: added by SAIT (99/09/03) */

  /*-------------------------------------------------*/
  /*--------- DC (and overall header info) ----------*/
  /*-------------------------------------------------*/

/* This part is moved to encode() */
/*begin: deleted by Sharp (99/4/7)*/
#if 0
  /*------- DC: Open and initialize bitstream file -------*/
  if ( iTile == 0 ){ /*added by Sharp (99/2/16)*/
		if ((bitfile=fopen(bitFile,"wb"))==NULL)
			errorHandler("Can't open file '%s' for writing.",bitFile);

/*begin: added by Sharp (99/2/16)*/
	}
	else {
    /*    sprintf(filename,"%s%d",bitFile,iTile);*/
    if ((bitfile=fopen(bitFile,"ab"))==NULL)
      errorHandler("Can't open file '%s' for writing.",bitFile);

    fseek(bitfile,0,SEEK_END);
  }
/*end: added by Sharp (99/2/16)*/

  /* initialize variables */
  init_bit_packing_fp(bitfile,1);

  /* Write header info to bitstream */
/*  header_Enc(wvtfilter, vm_param); deleted by Sharp (99/2/16)*/

/*begin: added by Sharp (99/2/16)*/
	if ( mzte_codec.tiling_disable == 0 ){
		if ( iTile == 0 ){
				*tile_table = header_Enc(wvtfilter, vm_param);
		}
		tile_header_Enc(iTile);
	}
	if ( mzte_codec.tiling_disable == 1 ){
		header_Enc(wvtfilter, vm_param);
		header_Enc_Common(wvtfilter, vm_param);
	}
/*end: added by Sharp (99/2/16)*/
#endif
/*end: deleted by Sharp (99/4/7)*/

/* begin: added by Rockwell (99/3/3) */ 
  /* IM: VTC error res */ 
  /* reset packet_size */
  packet_size = 0;
/* end: added by Rockwell (99/3/3) */

  /*------- DC: Quantize and encode all color components -------*/
  textureLayerDC_Enc();

  /*------- DC: Close bitstream file -------*/
  /* hjlee 0827 */
  if (snrStartCode){
    if(singleBitFile) {
/* begin: added by Rockwell (99/3/3) */
     /* IM: quick fix for error res */
      if (mzte_codec.error_res_flag) {
	flush_bits();
	/* flush_buffer_file(); */
      }
      else
/* end: added by Rockwell (99/3/3) */
      flush_buffer_file(); 
    }
    else  
      close_buffer_file(bitfile); 
  }
  


  /*-------------------------------------------------*/
  /*--------------------- AC ------------------------*/
  /*-------------------------------------------------*/

  /*------- AC: SINGLE-QUANT MODE -------*/
  if (mzte_codec.quantization_type == SINGLE_Q)
    textureLayerSQ_Enc(bitfile);
  /*------- AC: MULTI-QUANT MODE -------*/
  else if (mzte_codec.quantization_type == MULTIPLE_Q)
    textureLayerMQ_Enc(bitfile);
  /*------- AC: BILEVEL-QUANT MODE -------*/
  else if (mzte_codec.quantization_type == BILEVEL_Q)
    textureLayerBQ_Enc(bitfile);
#ifdef _MBQ_
  else if (mzte_codec.quantization_type == MULTBUF_Q)
    textureLayerMBQ_Enc(bitfile);
#endif

/* FPDAM begin: added by SAIT (99/09/03) */
  } else {
    if (snrStartCode){
      if(singleBitFile)
        flush_buffer_file();
      else
        close_buffer_file(bitfile);
    }
  }
/* FPDAM end: added by SAIT (99/09/03) */

/*begin: added by Sharp (99/4/7)*/
	if ( mzte_codec.tiling_disable == 0 ){
		/* next_start_code */
		emit_bits(0, 1);
		{
			Int bits, data;
			bits = current_put_bits();
			bits = 8 - (bits % 8);
			if (bits != 0 && bits != 8) {
					data = (1 << bits) - 1;
					emit_bits(data, bits);
			}
		}
	}
/*end: added by Sharp (99/4/7)*/

  if (singleBitFile){
    if(!snrStartCode)
      close_buffer_file(bitfile);
    else
      fclose(bitfile);
  }
}

/* static Void VTC_Encode() */ /* new */
Void VTC_Encode(VTCConfig *vtc)

{
  Int col,y, i, spa_lev;
  Int width,height;
  FILTER **anafilter,**synfilter;
  SOL_PARAMETERS *vm_param;

/*begin: added by Sharp (99/2/16)*/
  Int iTile = 1;
  SOL_PARAMETERS *vm_param_org;
  Int tile_width, tile_height;
  long tile_table_pos, garbage;
  Int *table;
  FILE *bitfile;
/*end: added by Sharp (99/2/16)*/
/*begin: added by Sharp (99/4/7)*/
	struct stat file_info;
	int init_size;
/*end: added by Sharp (99/4/7)*/

  noteProgress("\n----- MPEG-4 Visual Texture Coding: Encoding -----\n");

	mzte_codec.visual_object_verid = vtc->version_id; /* added by Sharp (99/11/18) */
/*	mzte_codec.visual_object_verid = BITSTREAM_VERSION;*/ /* version indicator */ /* modified by Sharp (99/5/10) */ /* deleted by Sharp (99/11/18) */

	if ( mzte_codec.visual_object_verid != 1 ){
  /* new */
  statsFile     = statsFileDef;  /* new */
  encRecImgFile = encRecImgFileDef; /* new */
  decRecImgFile = decRecImgFileDef; /* new */
  recImgFile = decRecImgFile; /* new */


  /* read the control file */
  /* noteProgress("Reading input parameters from '%s'....", parmFile);*/
  if ((vm_param = (SOL_PARAMETERS *)malloc(sizeof(SOL_PARAMETERS)*1)) == NULL)
    errorHandler("Allocating memory for parameters.");

  /* read_control_file(parmFile, vm_param);*/ /* new */
  /* noteProgress("Completed reading input parameters."); */ /* new */
  
  if ((vm_param->Image = 
       (PICTURE *)malloc(sizeof(PICTURE)*3)) == NULL)
    errorHandler("error allocating memory \n"); /* new */

  if ((vm_param->SegImage = 
       (PICTURE *)malloc(sizeof(PICTURE)*1)) == NULL)
    errorHandler("error allocating memory \n"); /* new */

  if (vtc->scan_direction == 0 && vtc->quantization_type == 1) /* new */
    vtc->SNR_start_code_enable = 0;

  /* copy Momusys parameters to VM_PARAMETERS */  /* new */
  vm_param->singleBitFile              = 1;   /* single file */
  vm_param->bitFile                    = vtc->bitstream;
  vm_param->id                         = vtc->id; 
  vm_param->Image[0].width             = vtc->width;
  vm_param->Image[0].height            = vtc->height;
  vm_param->ImagePath                  = vtc->image_file;
  vm_param->SegPath                    = vtc->shape_file;
  encRecImgFile                        = vtc->rec_file;
  recImgFile                           = encRecImgFile;
  vm_param->bit_depth                  = vtc->bit_depth;
  vm_param->colors                     = 3;
  vm_param->sa_dwt                     = vtc->sa_dwt;
  vm_param->wvtType                    = vtc->wvtType;
  vm_param->wvtDecompLev               = vtc->wvtDecompLev;
  vm_param->wvtUniform                 = vtc->wvtUniform; /* new */
  vm_param->wvtDownload                = vtc->wvtDownload; /* new */
  vm_param->wvtFilters                 = vtc->wvtFilters; /* new */
  vm_param->QdcY                       = vtc->QdcY;
  vm_param->QdcUV                      = vtc->QdcUV;
  vm_param->spatial_scalability_levels = vtc->spatial_scalability_levels;
  vm_param->quantization_type          = vtc->quantization_type;
  vm_param->scan_direction             = vtc->scan_direction;
  vm_param->SNR_start_code_enable      = vtc->SNR_start_code_enable;
  vm_param->target_bitrate             = vtc->target_bitrate;
	/* SAIT_V2 begin : added by Samsung AIT (99/02/23) */
	vm_param->target_shape_levels  = vtc->target_shape_levels;
	vm_param->full_size_out        = vtc->full_size_out;
	/* SAIT_V2 end */
  vm_param->target_spatial_levels      = vtc->target_spatial_levels;
  vm_param->target_snr_levels          = vtc->target_snr_levels;
  vm_param->deringWindowSize           = vtc->deringWindowSize;
  vm_param->deringThreshold            = vtc->deringThreshold;
  vm_param->defaultSpatialScale        = vtc->defaultSpatialScale; /* new */
  vm_param->acm_max_freq_chg =0; /* new */
/*begin: added by Sharp (99/2/16)*/
  vm_param->tiling_disable           = vtc->tiling_disable;
  vm_param->extension_type          = 0;
  vm_param->tile_width              = vtc->tile_width;
  vm_param->tile_height             = vtc->tile_height;
  vm_param->target_tile_id_from     = vtc->target_tile_id_from;
  vm_param->target_tile_id_to       = vtc->target_tile_id_to;
	vm_param->tiling_jump_table_enable   = vtc->tiling_jump_table_enable;

	if ( vm_param->tiling_disable == 0 )
  noteProgress("target_tile_id: from %d to %d\n", vtc->target_tile_id_from, vtc->target_tile_id_to);
/*end: added by Sharp (99/2/16)*/

  if (vtc->defaultSpatialScale==0) /* new */
  {
    /* read in spatial layer info */
    for (spa_lev=0; spa_lev<vtc->spatial_scalability_levels-1; 
	 ++spa_lev)   
      vm_param->lastWvtDecompInSpaLayer[spa_lev]=
	vtc->lastWvtDecompInSpaLayer[spa_lev];

  }

/* begin: added by Rockwell (99/3/3) */ 
  /* IM: VTC error res */  
  vm_param->error_res_flag = vtc->error_res_flag;
  vm_param->packet_size = vtc->packet_size; 
  vm_param->segment_thresh = vtc->segment_thresh;
/* end: added by Rockwell (99/3/3) */

  vm_param->alphaTH = vtc->alphaTH;
  vm_param->change_CR_disable=vtc->change_CR_disable;
  for (col=0; col<vm_param->colors; col++)
    vm_param->SPlayer[col]     = vtc->SPlayer[col];
  
	/* SAIT_V2 begin: added by Samsung AIT (99/02/23) */
	vm_param->STO_const_alpha = 1;
	vm_param->STO_const_alpha_value = 0xff;
	/* SAIT_V2 end */

  /* initialize filters */
  anafilter = (FILTER **) malloc(sizeof(FILTER *)*vm_param->wvtDecompLev);
  synfilter = (FILTER **) malloc(sizeof(FILTER *)*vm_param->wvtDecompLev);
  if(anafilter == NULL || synfilter == NULL) 
    errorHandler("Error allocating memory for filters\n");
  for(i=0;i<vm_param->wvtDecompLev; i++) {
    choose_wavelet_filter(&(anafilter[i]),
			  &(synfilter[vm_param->wvtDecompLev-1-i]),
			  vm_param->wvtFilters[vm_param->wvtUniform?0:i]);
  }

  /* read the source image */
  noteProgress("Reading in image '%s'....", vm_param->ImagePath);
  read_image(vm_param->ImagePath, vm_param->Image[0].width, 
             vm_param->Image[0].height, vm_param->colors, 
             vm_param->bit_depth, vm_param->Image); 
  noteProgress("Completed reading in image.");

  /* read the segmentation map of the source image */
  if (vm_param->sa_dwt) {
    noteProgress("Reading in seg map '%s'....", vm_param->SegPath);
    (Void)read_segimage(vm_param->SegPath, 
			vm_param->Image[0].width, 
			vm_param->Image[0].height, vm_param->colors, 
			vm_param->Image); 
    noteProgress("Completed reading in seg map.");
  }

/*begin: added by Sharp (99/2/16)*/
  mzte_codec.display_width = vm_param->Image[0].width;
  mzte_codec.display_height = vm_param->Image[0].height;
  tile_width = mzte_codec.tile_width = vm_param->tile_width;
  tile_height = mzte_codec.tile_height = vm_param->tile_height;
  mzte_codec.extension_type = vm_param->extension_type;
  mzte_codec.tiling_disable = vm_param->tiling_disable;
  mzte_codec.target_tile_id_from = vm_param->target_tile_id_from;
  mzte_codec.target_tile_id_to = vm_param->target_tile_id_to;

  if ( mzte_codec.tiling_disable == 0 ) {

		if ((vm_param_org = (SOL_PARAMETERS *)malloc(sizeof(SOL_PARAMETERS)*1)) == NULL)
				errorHandler("Allocating memory for parameters.");
/* FPDAM begin : added by SAIT (99/09/03) */
  		get_real_image(vm_param->Image, vm_param->wvtDecompLev, 
			vm_param->sa_dwt, vm_param->colors, 
			vm_param->alphaTH, vm_param->change_CR_disable, 
			vm_param->STO_const_alpha,
			vm_param->STO_const_alpha_value,
			anafilter[0]);
		for(col=0; col<3; col++) {
  			vm_param->Image[col].width = (mzte_codec.width+(col>0))>>(col>0);
  			vm_param->Image[col].height = (mzte_codec.height+(col>0))>>(col>0);
		}
/* FPDAM end : added by SAIT (99/09/03) */

		/* change the members of vm_param to handle tiled image */
		init_tile(vm_param, vm_param_org, tile_width, tile_height);

/* begin: modified by Sharp (99/5/10) */
		mzte_codec.iNumOfTile = 
 			((vm_param_org->Image[0].width)/tile_width + (((vm_param_org->Image[0].width)%tile_width)?1:0)) *
 			((vm_param_org->Image[0].height)/tile_height + (((vm_param_org->Image[0].height)%tile_height)?1:0));
 		table = (Int *)malloc(sizeof(Int)*mzte_codec.iNumOfTile+1);
#ifdef	_FPDAM_DBG_
fprintf(stderr,"....... org width=%d org height=%d iNumOfTile=%d\n",
	vm_param_org->Image[0].width, vm_param_org->Image[0].height, mzte_codec.iNumOfTile);
getchar();
#endif 
/*		mzte_codec.iNumOfTile = (vm_param_org->Image[0].width)/tile_width **/
/*				(vm_param_org->Image[0].height)/tile_height;*/
/*		table = (Int *)malloc(sizeof(Int)*mzte_codec.iNumOfTile);*/
/* end: modified by Sharp (99/5/10) */

  } else {
      mzte_codec.iNumOfTile = 1;
  }

/*end: added by Sharp (99/2/16)*/

/*  for ( iTile = 0; iTile<mzte_codec.iNumOfTile; iTile++ ) deleted by Sharp (99/4/7)*/

  get_virtual_image(vm_param->Image, vm_param->wvtDecompLev, 
/* FPDAM begin: modified by SAIT(99/09/03) */
		    /*vm_param->sa_dwt,*/ 
		    ((mzte_codec.tiling_disable==0) ? 0 : vm_param->sa_dwt),
/* FPDAM end: modified by SAIT(99/09/03) */
		    vm_param->colors,
		    vm_param->alphaTH, vm_param->change_CR_disable, 
			vm_param->STO_const_alpha,              /* SAIT_V2 : added by Samsung AIT (99/02/23) */
			vm_param->STO_const_alpha_value,        /* SAIT_V2 : added by Samsung AIT (99/02/23) */
		    anafilter[0]);

/* FPDAM begin: added by SAIT(99/09/03) */
  if(mzte_codec.tiling_disable==1) {
  	mzte_codec.object_width=mzte_codec.width;
  	mzte_codec.object_height=mzte_codec.height;
  	mzte_codec.object_origin_x=mzte_codec.origin_x;
  	mzte_codec.object_origin_y=mzte_codec.origin_y;
  }
/* FPDAM end: added by SAIT(99/09/03) */
 
  /* fill in encoding/decoding parameters */
  mzte_codec.Image                      = vm_param->Image;
  mzte_codec.wvtDecompLev               = vm_param->wvtDecompLev; 
  mzte_codec.wvtType                    = vm_param->wvtType; 
  mzte_codec.sa_dwt                     = vm_param->sa_dwt; 
  if (mzte_codec.sa_dwt)
     mzte_codec.SegImage                = vm_param->SegImage;
	/* SAIT_V2 begin: added by Samsung AIT (99/02/23)  */
	mzte_codec.STO_const_alpha = vm_param->STO_const_alpha; 
	mzte_codec.STO_const_alpha_value = vm_param->STO_const_alpha_value;
	/* SAIT_V2 end */
  mzte_codec.spatial_scalability_levels = vm_param->spatial_scalability_levels;
  mzte_codec.quantization_type          = vm_param->quantization_type;
  mzte_codec.scan_direction              = vm_param->scan_direction;
  mzte_codec.SNR_start_code_enable       = vm_param->SNR_start_code_enable;
  mzte_codec.colors                     = vm_param->colors;
  mzte_codec.bit_depth                  = vm_param->bit_depth;
  mzte_codec.deringWindowSize           = vm_param->deringWindowSize;
  mzte_codec.deringThreshold            = vm_param->deringThreshold;
	/* SAIT_V2 begin: added by Samsung AIT (99/02/23)  */
	mzte_codec.target_shape_levels = vm_param->target_shape_levels;
	mzte_codec.full_size_out = vm_param->full_size_out;
	/* SAIT_V2 end */

/* begin: added by Rockwell (99/3/3) */ 
  /* IM: VTC error res */ 
  mzte_codec.error_res_flag             = vm_param->error_res_flag;   
  targetPacketLength                    = vm_param->packet_size;
  mzte_codec.segment_thresh             = vm_param->segment_thresh;   
/* end: added by Rockwell (99/3/3) */

  mzte_codec.target_spatial_levels      = vm_param->target_spatial_levels; 
  mzte_codec.target_snr_levels          = vm_param->target_snr_levels; 
	mzte_codec.tiling_jump_table_enable   = vm_param->tiling_jump_table_enable; /* added by Sharp (99/2/16) */

  /* PEZW - SNR_start_code_enable is always enabled */
  if (mzte_codec.quantization_type == BILEVEL_Q)
    mzte_codec.SNR_start_code_enable       = 1;

#if 0
  mzte_codec.defaultSpatialScale        = vm_param->defaultSpatialScale;
  if (vm_param->defaultSpatialScale==0)
  {
    /* read in spatial layer info */
    for (spa_lev=0; spa_lev<vtc->spatial_scalability_levels-1; 
	 ++spa_lev)   
      mzte_codec.lastWvtDecompInSpaLayer[spa_lev]=
	vm_param->lastWvtDecompInSpaLayer[spa_lev];

  }
#endif

  mzte_codec.Qdc[0]                     = vm_param->QdcY;
  if (vm_param->colors != MONO) {
    mzte_codec.Qdc[1]                   = vm_param->QdcUV;
    mzte_codec.Qdc[2]                   = vm_param->QdcUV;
  }
  for (col=0; col<vm_param->colors; col++)
    mzte_codec.Qinfo[col]      = vm_param->SPlayer[col];
  mzte_codec.dcHeight          = mzte_codec.height >> mzte_codec.wvtDecompLev;
  mzte_codec.dcWidth           = mzte_codec.width >> mzte_codec.wvtDecompLev;
  for (col=0; col<mzte_codec.colors; col++) {
    mzte_codec.Image[col].height = mzte_codec.height >> (col>0);
    mzte_codec.Image[col].width  = mzte_codec.width >> (col>0);
  }
			printf("------------%d %d\n", mzte_codec.width, mzte_codec.height);
  mzte_codec.acm_order = vm_param->acm_order;
  if((mzte_codec.acm_max_freq_chg = vm_param->acm_max_freq_chg) != 0)
    mzte_codec.acm_maxf = vm_param->acm_maxf;

  /* add for mq spatial layer flexability * - ph 7/16 */
  if (vm_param->quantization_type == 2)
  {
    if (vm_param->spatial_scalability_levels != vm_param->wvtDecompLev)
    {
      /* read in usedefault */
      mzte_codec.defaultSpatialScale=vm_param->defaultSpatialScale;
      
      if (vm_param->defaultSpatialScale==0)
      {
	int spa_lev;

	/* read in spatial layer info */
	for (spa_lev=0; spa_lev<vm_param->spatial_scalability_levels-1; 
	     ++spa_lev)   
	  mzte_codec.lastWvtDecompInSpaLayer[spa_lev][0]
	    =vm_param->lastWvtDecompInSpaLayer[spa_lev];
      }
    }
  }

  mzte_codec.acm_order = vm_param->acm_order = 0; /* new */
   vm_param->acm_maxf=(Int *)malloc(6*sizeof(Int)); /* new */
  for(i=0;i<6;i++)
    vm_param->acm_maxf[i] = 16383; /* new */
  mzte_codec.acm_maxf = vm_param->acm_maxf;   /* new */
  init_acm_maxf_enc();

  singleBitFile = vm_param->singleBitFile;
  bitFile = vm_param->bitFile;
  bitFileAC = vm_param->bitFileAC;
  /* singleBitFile = 1; */  /* hjlee 0827 */

/*begin: added by Sharp (99/4/7)*/
  noteDetail("Completed creating and initializing data structures.");

	if ((bitfile=fopen(bitFile,"wb"))==NULL)
		errorHandler("Can't open file '%s' for writing.",bitFile);
	init_bit_packing_fp(bitfile,1);
	tile_table_pos = header_Enc(synfilter, vm_param);

/* @@@@@ */
/* begin: deleted for FDAM1 by Samsung AIT (2000/01/10) */
/* if (mzte_codec.error_res_flag)
		emit_bits(mzte_codec.segment_thresh,16); */
/* end: deleted for FDAM1 by Samsung AIT (2000/01/10) */

/*end: added by Sharp (99/4/7)*/

  for ( iTile = 0; iTile<mzte_codec.iNumOfTile; iTile++ ){ /* added by SHarp (99/4/7) */

/*begin: added by Sharp (99/4/7)*/
		if ( mzte_codec.tiling_disable == 0 ){
/* begin: added by Sharp (99/5/10) */
/*FPDAM begin: modified by SAIT(99/09/03)  */
			/*cut_tile_image(vm_param->Image, vm_param_org->Image, iTile, vm_param->colors, tile_width, tile_height);*/
			printf("------------%d %d\n", mzte_codec.width, mzte_codec.height);
			cut_tile_image(vm_param->Image, vm_param_org->Image, iTile, vm_param->colors, tile_width, tile_height, anafilter[0]);
/*FPDAM end: modified by SAIT(99/09/03)  */
/* end: added by Sharp (99/5/10) */

/* FPDAM begin : added by SAIT(99/09/03)  */
			if (mzte_codec.sa_dwt)
			    mzte_codec.texture_tile_type
					= CheckTextureTileType (vm_param->Image[0].mask,
								mzte_codec.width, 
								mzte_codec.height,
								mzte_codec.real_width, 
								mzte_codec.real_height);
/* FPDAM end : added by SAIT (99/09/03) */

			if ( iTile != 0 ){
				/*    sprintf(filename,"%s%d",bitFile,iTile);*/
				if ((bitfile=fopen(bitFile,"ab"))==NULL)
					errorHandler("Can't open file '%s' for writing.",bitFile);

				fseek(bitfile,0,SEEK_END);
				/* initialize variables */
				init_bit_packing_fp(bitfile,1);
			}

			/* Write TILE header info to bitstream */
/* FPDAM begin : modified by SAIT (99/09/03) */
			/* tile_header_Enc(iTile); */
			tile_header_Enc(synfilter,vm_param,iTile);
/* FPDAM end : modified by SAIT (99/09/03) */
		}
		
		if (mzte_codec.error_res_flag)
			texture_packet_header_Enc(synfilter, vm_param);
/*end: added by Sharp (99/4/7)*/

		for (col=0; col<mzte_codec.colors; col++) {
			height = mzte_codec.Image[col].height; 
			width  = mzte_codec.Image[col].width;
			
/* FPDAM begin : added by SAIT (99/09/03) */
			if(mzte_codec.tiling_disable!=0 || !mzte_codec.sa_dwt || mzte_codec.texture_tile_type!=TRANSP_TILE) {
/* FPDAM end : added by SAIT (99/09/03) */

			/*--------- create coeffinfo structure ----------*/
			if ((mzte_codec.SPlayer[col].coeffinfo = 
		 (COEFFINFO **)calloc(height, sizeof(COEFFINFO *))) == NULL)
				errorHandler("Allocating memory for coefficient structure (I).");

			if ((mzte_codec.SPlayer[col].coeffinfo[0] = 
		 (COEFFINFO *)calloc(height*width, sizeof(COEFFINFO))) == NULL)
				errorHandler("Allocating memory for coefficient structure (II).");
			
			for (y = 1; y < height; ++y)
				mzte_codec.SPlayer[col].coeffinfo[y] = mzte_codec.SPlayer[col].coeffinfo[y-1]+width;
/* FPDAM begin : added by SAIT (99/09/03) */
			}
/* FPDAM end : added by SAIT (99/09/03) */
		}

  /* DISCRETE WAVELET TRANSFORM */
		noteProgress("Wavelet Transform....");  
/*begin: added by Sharp(99/2/16)*/

/*begin : deleted by Sharp (99/5/10)*/
/*		if(mzte_codec.tiling_disable == 0)*/
/*			perform_DWT_Tile(anafilter, vm_param_org->Image, iTile);*/
/*		else*/
/*end : deleted by Sharp (99/5/10)*/
/* FPDAM begin : added by SAIT (99/09/03) */
		if(mzte_codec.tiling_disable!=0 || !mzte_codec.sa_dwt || mzte_codec.texture_tile_type!=TRANSP_TILE)
/* FPDAM end : added by SAIT (99/09/03) */
			perform_DWT(anafilter);
/*end: added by Sharp(99/2/16)*/
/*  perform_DWT(anafilter); deleted by Sharp (99/2/16)*/
		noteProgress("Completed wavelet transform.");
  
#ifdef _WRITE_WAVELET_COEFFS_
  {
    int x,y;
    FILE *fp;

    fp=fopen("wvtc","w");
    for (y=0; y<mzte_codec.height; ++y)
    {
      for (x=0; x<mzte_codec.width; ++x)
	fprintf(fp,"%d ",COEFF_ORGVAL(x,y,0));
      fprintf(fp,"\n");
    }
    fclose(fp);
    exit(0);
  }
#endif

#ifdef _CHECK_BITS_
  fpe=fopen("encode_bits","wb");
#endif

/*begin: added by Sharp (99/4/7)*/
		if (mzte_codec.tiling_disable == 0){
			stat(bitFile, &file_info);
			init_size = file_info.st_size;
		}

		TextureObjectLayer_enc(synfilter, vm_param, bitfile);

		if (mzte_codec.tiling_disable == 0 && mzte_codec.tiling_jump_table_enable == 1 ){
			if (iTile==0){
/*				printf("Header = %d\n", tile_table_pos);*/
				stat(bitFile, &file_info);
/*				printf("%d\n", file_info.st_size);*/
				table[0] = file_info.st_size - tile_table_pos - (34 * mzte_codec.iNumOfTile + used_bits + 8)/8;
			} else {
				stat(bitFile, &file_info);
/*          printf("%d\n", file_info.st_size);*/
				table[iTile] = file_info.st_size - init_size;
			}
		}
/*end: added by Sharp (99/4/7)*/

/*begin: deleted by Sharp (99/4/7)*/
#if 0
/*begin: added by Sharp(99/2/16)*/
  if (mzte_codec.tiling_disable == 0){
      struct stat file_info;

			if ( mzte_codec.tiling_jump_table_enable == 1 ){
      if (iTile==0){
          TextureObjectLayer_enc(synfilter,vm_param, iTile, &tile_table_pos);
					printf("Header = %d\n", tile_table_pos);
          stat(bitFile, &file_info);
          printf("%d\n", file_info.st_size);
          table[0] = file_info.st_size - tile_table_pos
              - (34 * mzte_codec.iNumOfTile + used_bits + 8)/8;
      } else {
          int init_size;
          stat(bitFile, &file_info);
          init_size = file_info.st_size;

          TextureObjectLayer_enc(synfilter,vm_param, iTile, &garbage);
          stat(bitFile, &file_info);
          /*          printf("%d\n", file_info.st_size);*/
          table[iTile] = file_info.st_size - init_size;
      }
      printf("Encoded Table[%d] = %d\n", iTile, table[iTile]);
			}
			else
          TextureObjectLayer_enc(synfilter,vm_param, iTile, &garbage);

  } else {
      TextureObjectLayer_enc(synfilter,vm_param, iTile, &garbage);
  }
#endif
/*end: deleted by Sharp (99/4/7)*/

/*end: added by Sharp(99/2/16)*/

/*  TextureObjectLayer_enc(synfilter,vm_param); deleted by Sharp (99/2/16) */

#ifdef _CHECK_BITS_
  fclose(fpe);
#endif

/*begin: added by Sharp(99/2/16)*/
		} /* each tile */

fprintf(stderr,"..... Total Shape Bits = %d\n", shape_bits); 

		/* overwrite tile table */
		if (mzte_codec.tiling_disable == 0 && mzte_codec.tiling_jump_table_enable == 1){
				bitfile = fopen(bitFile,"r+b");
				garbage = ftell(bitfile);
				if (fseek(bitfile, tile_table_pos, SEEK_SET)!=0){
						fprintf(stderr, "rewind failed\n");
						exit(111);
				}
				garbage = ftell(bitfile);
				{
					unsigned char byte_buf;
					Int bits;

					fread(&byte_buf, sizeof(char), 1, bitfile);
					fflush(bitfile);
					fseek(bitfile, -1, SEEK_CUR);
					byte_buf = (byte_buf >> (8 - used_bits));
					bits = emit_bits_local ( byte_buf, used_bits, bitfile );
					for (iTile=0; iTile<mzte_codec.iNumOfTile; iTile++) {
						bits = emit_bits_local ( (table[iTile]>>16), 16, bitfile );
						bits = emit_bits_local ( 1, 1, bitfile );
						bits = emit_bits_local ( (table[iTile]&0xffff), 16, bitfile );
						bits = emit_bits_local ( 1, 1, bitfile );
					}
					fflush(bitfile);
					fread(&byte_buf, sizeof(char), 1, bitfile);
					fflush(bitfile);
					fseek(bitfile, -1, SEEK_CUR);
					emit_bits_local ( byte_buf, bits, bitfile );
				}
				fclose(bitfile);
		}
/*end: added by Sharp(99/2/16)*/
	}
	else { /* Version 1 code is described here */

  statsFile     = statsFileDef;  /* new */
  encRecImgFile = encRecImgFileDef; /* new */
  decRecImgFile = decRecImgFileDef; /* new */
  recImgFile = decRecImgFile; /* new */


  /* read the control file */
  /* noteProgress("Reading input parameters from '%s'....", parmFile);*/
  if ((vm_param = (SOL_PARAMETERS *)malloc(sizeof(SOL_PARAMETERS)*1)) == NULL)
    errorHandler("Allocating memory for parameters.");

  /* read_control_file(parmFile, vm_param);*/ /* new */
  /* noteProgress("Completed reading input parameters."); */ /* new */
  
  if ((vm_param->Image = 
       (PICTURE *)malloc(sizeof(PICTURE)*3)) == NULL)
    errorHandler("error allocating memory \n"); /* new */

  if ((vm_param->SegImage = 
       (PICTURE *)malloc(sizeof(PICTURE)*1)) == NULL)
    errorHandler("error allocating memory \n"); /* new */

  if (vtc->scan_direction == 0 && vtc->quantization_type == 1) /* new */
    vtc->SNR_start_code_enable = 0;

  /* copy Momusys parameters to VM_PARAMETERS */  /* new */
  vm_param->singleBitFile              = 1;   /* single file */
  vm_param->bitFile                    = vtc->bitstream;
  vm_param->id                         = vtc->id; 
  vm_param->Image[0].width             = vtc->width;
  vm_param->Image[0].height            = vtc->height;
  vm_param->ImagePath                  = vtc->image_file;
  vm_param->SegPath                    = vtc->shape_file;
  encRecImgFile                        = vtc->rec_file;
  recImgFile                           = encRecImgFile;
  vm_param->bit_depth                  = vtc->bit_depth;
  vm_param->colors                     = 3;
  vm_param->sa_dwt                     = vtc->sa_dwt;
  vm_param->wvtType                    = vtc->wvtType;
  vm_param->wvtDecompLev               = vtc->wvtDecompLev;
  vm_param->wvtUniform                 = vtc->wvtUniform; /* new */
  vm_param->wvtDownload                = vtc->wvtDownload; /* new */
  vm_param->wvtFilters                 = vtc->wvtFilters; /* new */
  vm_param->QdcY                       = vtc->QdcY;
  vm_param->QdcUV                      = vtc->QdcUV;
  vm_param->spatial_scalability_levels = vtc->spatial_scalability_levels;
  vm_param->quantization_type          = vtc->quantization_type;
  vm_param->scan_direction             = vtc->scan_direction;
  vm_param->SNR_start_code_enable      = vtc->SNR_start_code_enable;
  vm_param->target_bitrate             = vtc->target_bitrate;
  vm_param->target_spatial_levels      = vtc->target_spatial_levels;
  vm_param->target_snr_levels          = vtc->target_snr_levels;
  vm_param->deringWindowSize           = vtc->deringWindowSize;
  vm_param->deringThreshold            = vtc->deringThreshold;
  vm_param->defaultSpatialScale        = vtc->defaultSpatialScale; /* new */
  vm_param->acm_max_freq_chg =0; /* new */

  if (vtc->defaultSpatialScale==0) /* new */
  {
    /* read in spatial layer info */
    for (spa_lev=0; spa_lev<vtc->spatial_scalability_levels-1; 
	 ++spa_lev)   
      vm_param->lastWvtDecompInSpaLayer[spa_lev]=
	vtc->lastWvtDecompInSpaLayer[spa_lev];

  }
  vm_param->alphaTH = vtc->alphaTH;
  vm_param->change_CR_disable=vtc->change_CR_disable;
  for (col=0; col<vm_param->colors; col++)
    vm_param->SPlayer[col]     = vtc->SPlayer[col];
  

  /* initialize filters */
  anafilter = (FILTER **) malloc(sizeof(FILTER *)*vm_param->wvtDecompLev);
  synfilter = (FILTER **) malloc(sizeof(FILTER *)*vm_param->wvtDecompLev);
  if(anafilter == NULL || synfilter == NULL) 
    errorHandler("Error allocating memory for filters\n");
  for(i=0;i<vm_param->wvtDecompLev; i++) {
    choose_wavelet_filter(&(anafilter[i]),
			  &(synfilter[vm_param->wvtDecompLev-1-i]),
			  vm_param->wvtFilters[vm_param->wvtUniform?0:i]);
  }
  /* read the source image */
  noteProgress("Reading in image '%s'....", vm_param->ImagePath);
  read_image(vm_param->ImagePath, vm_param->Image[0].width, 
             vm_param->Image[0].height, vm_param->colors, 
             vm_param->bit_depth, vm_param->Image); 
  noteProgress("Completed reading in image.");

  /* read the segmentation map of the source image */
  if (vm_param->sa_dwt) {
    noteProgress("Reading in seg map '%s'....", vm_param->SegPath);
    (Void)read_segimage(vm_param->SegPath, 
			vm_param->Image[0].width, 
			vm_param->Image[0].height, vm_param->colors, 
			vm_param->Image); 
    noteProgress("Completed reading in seg map.");
  }

/* this function is replaced with new one */
  get_virtual_image(vm_param->Image, vm_param->wvtDecompLev, 
		    vm_param->sa_dwt, vm_param->colors, 
		    vm_param->alphaTH, vm_param->change_CR_disable, 
			vm_param->STO_const_alpha,              /* SAIT_V2 : added by Samsung AIT (99/02/23) */
			vm_param->STO_const_alpha_value,        /* SAIT_V2 : added by Samsung AIT (99/02/23) */
		    anafilter[0]);
/*
  get_virtual_image_V1(vm_param->Image, vm_param->wvtDecompLev, 
		    vm_param->sa_dwt, vm_param->colors, 
		    vm_param->alphaTH, vm_param->change_CR_disable, anafilter[0]); 
*/
 
  /* fill in encoding/decoding parameters */
  mzte_codec.Image                      = vm_param->Image;
  mzte_codec.wvtDecompLev               = vm_param->wvtDecompLev; 
  mzte_codec.wvtType                    = vm_param->wvtType; 
  mzte_codec.sa_dwt                     = vm_param->sa_dwt; 
  if (mzte_codec.sa_dwt)
     mzte_codec.SegImage                = vm_param->SegImage;
  mzte_codec.spatial_scalability_levels = vm_param->spatial_scalability_levels;
  mzte_codec.quantization_type          = vm_param->quantization_type;
  mzte_codec.scan_direction              = vm_param->scan_direction;
  mzte_codec.SNR_start_code_enable       = vm_param->SNR_start_code_enable;
  mzte_codec.colors                     = vm_param->colors;
  mzte_codec.bit_depth                  = vm_param->bit_depth;
  mzte_codec.deringWindowSize           = vm_param->deringWindowSize;
  mzte_codec.deringThreshold            = vm_param->deringThreshold;
  mzte_codec.target_spatial_levels      = vm_param->target_spatial_levels; 
  mzte_codec.target_snr_levels          = vm_param->target_snr_levels; 

  /* PEZW - SNR_start_code_enable is always enabled */
  if (mzte_codec.quantization_type == BILEVEL_Q)
    mzte_codec.SNR_start_code_enable       = 1;

#if 0
  mzte_codec.defaultSpatialScale        = vm_param->defaultSpatialScale;
  if (vm_param->defaultSpatialScale==0)
  {
    /* read in spatial layer info */
    for (spa_lev=0; spa_lev<vtc->spatial_scalability_levels-1; 
	 ++spa_lev)   
      mzte_codec.lastWvtDecompInSpaLayer[spa_lev]=
	vm_param->lastWvtDecompInSpaLayer[spa_lev];

  }
#endif

  mzte_codec.Qdc[0]                     = vm_param->QdcY;
  if (vm_param->colors != MONO) {
    mzte_codec.Qdc[1]                   = vm_param->QdcUV;
    mzte_codec.Qdc[2]                   = vm_param->QdcUV;
  }
  for (col=0; col<vm_param->colors; col++)
    mzte_codec.Qinfo[col]      = vm_param->SPlayer[col];
  mzte_codec.dcHeight          = mzte_codec.height >> mzte_codec.wvtDecompLev;
  mzte_codec.dcWidth           = mzte_codec.width >> mzte_codec.wvtDecompLev;
  for (col=0; col<mzte_codec.colors; col++) {
    mzte_codec.Image[col].height = mzte_codec.height >> (col>0);
    mzte_codec.Image[col].width  = mzte_codec.width >> (col>0);
  }
  mzte_codec.acm_order = vm_param->acm_order;
  if((mzte_codec.acm_max_freq_chg = vm_param->acm_max_freq_chg) != 0)
    mzte_codec.acm_maxf = vm_param->acm_maxf;

  /* add for mq spatial layer flexability * - ph 7/16 */
  if (vm_param->quantization_type == 2)
  {
    if (vm_param->spatial_scalability_levels != vm_param->wvtDecompLev)
    {
      /* read in usedefault */
      mzte_codec.defaultSpatialScale=vm_param->defaultSpatialScale;
      
      if (vm_param->defaultSpatialScale==0)
      {
	int spa_lev;

	/* read in spatial layer info */
	for (spa_lev=0; spa_lev<vm_param->spatial_scalability_levels-1; 
	     ++spa_lev)   
	  mzte_codec.lastWvtDecompInSpaLayer[spa_lev][0]
	    =vm_param->lastWvtDecompInSpaLayer[spa_lev];
      }
    }
  }

  mzte_codec.acm_order = vm_param->acm_order = 0; /* new */
   vm_param->acm_maxf=(Int *)malloc(6*sizeof(Int)); /* new */
  for(i=0;i<6;i++)
    vm_param->acm_maxf[i] = 16383; /* new */
  mzte_codec.acm_maxf = vm_param->acm_maxf;   /* new */
  init_acm_maxf_enc();

  singleBitFile = vm_param->singleBitFile;
  bitFile = vm_param->bitFile;
  bitFileAC = vm_param->bitFileAC;
  /* singleBitFile = 1; */  /* hjlee 0827 */

  noteDetail("Completed creating and initializing data structures.");

  for (col=0; col<mzte_codec.colors; col++) {
    height = mzte_codec.Image[col].height; 
    width  = mzte_codec.Image[col].width;
    
    /*--------- create coeffinfo structure ----------*/
    if ((mzte_codec.SPlayer[col].coeffinfo = 
	 (COEFFINFO **)calloc(height, sizeof(COEFFINFO *))) == NULL)
      errorHandler("Allocating memory for coefficient structure (I).");

    if ((mzte_codec.SPlayer[col].coeffinfo[0] = 
	 (COEFFINFO *)calloc(height*width, sizeof(COEFFINFO))) == NULL)
      errorHandler("Allocating memory for coefficient structure (II).");
    
    for (y = 1; y < height; ++y)
      mzte_codec.SPlayer[col].coeffinfo[y] = 
	mzte_codec.SPlayer[col].coeffinfo[y-1]+width;
  }

  /* DISCRETE WAVELET TRANSFORM */
  noteProgress("Wavelet Transform....");  
  perform_DWT(anafilter);
  noteProgress("Completed wavelet transform.");
  
#ifdef _WRITE_WAVELET_COEFFS_
  {
    int x,y;
    FILE *fp;

    fp=fopen("wvtc","w");
    for (y=0; y<mzte_codec.height; ++y)
    {
      for (x=0; x<mzte_codec.width; ++x)
	fprintf(fp,"%d ",COEFF_ORGVAL(x,y,0));
      fprintf(fp,"\n");
    }
    fclose(fp);
    exit(0);
  }
#endif

#ifdef _CHECK_BITS_
  fpe=fopen("encode_bits","wb");
#endif

  TextureObjectLayer_enc_V1(synfilter,vm_param);  

#ifdef _CHECK_BITS_
  fclose(fpe);
#endif

	} /* end of version 1 encode */

  /* new */
  noteProgress("\n----- Encoding Completed. -----\n");


  /*   decoding part */
  {
    SOL_PARAMETERS_DEC *vm_param_dec;
    FILTER **wvtfilter;
/*begin: added by Sharp(99/2/16)*/
    Int     header_size, target_iNum, iNumOfTile;
    Int     *jump_table, *decode_tile_id;
		UChar    *frm[3]; /* modified by Sharp (99/5/10) */
	UChar *frm_mask[3]; /* FPDAM: added by SAIT (99/09/03) */
    Int     id_to, ii;
/*end: added by Sharp(99/2/16)*/
		Int TileX, TileY; /* added by Sharp (99/5/10) */
		Int MinLevel; /* added by Sharp (99/5/10) */
    
    noteProgress("\n----- MPEG-4 Visual Texture Coding: Decoding -----\n");

/* begin: added by Sharp (99/11/18) */
  if ( strstr(vm_param->bitFile, "v1") != NULL || strstr(vm_param->bitFile, "V1") != NULL )
    mzte_codec.visual_object_verid = 1;
  else
    mzte_codec.visual_object_verid = 2;
/* end: added by Sharp (99/11/18) */

		if ( mzte_codec.visual_object_verid != 1 ){

			printf("Version 2 bitstream\n"); /* added by Sharp (99/11/18)*/
/* begin: added by Rockwell (99/3/3) */ 
/* IM: VTC error res */ 
		/* error resilience, bbc, 11/5/98 */
		errSignal=errWarnSignal=errMagSignal=0;
/* end: added by Rockwell (99/3/3) */
    
    /* Read in decoding parameters */
    if ((vm_param_dec = 
         (SOL_PARAMETERS_DEC *)malloc(sizeof(SOL_PARAMETERS_DEC)*1)) == NULL)
      errorHandler("Allocating memory for parameters.");

    vm_param_dec->height  = mzte_codec.height;
    vm_param_dec->width   = mzte_codec.width; 
    vm_param_dec->wvtType = mzte_codec.wvtType;
    vm_param_dec->SegPath = vm_param->SegPath;
/* FPDAM begin : modified by SAIT (99/09/03) */    
    /* vm_param_dec->width = mzte_codec.width;
    vm_param_dec->height = mzte_codec.height; */
    vm_param_dec->height  = mzte_codec.display_height;
    vm_param_dec->width   = mzte_codec.display_width;
/* FPDAM end : modified by SAIT (99/09/03) */
    vm_param_dec->colors = mzte_codec.colors=3;
    vm_param_dec->bit_depth =mzte_codec.bit_depth=8;
    vm_param_dec->wvtDecompLev = mzte_codec.wvtDecompLev;
    vm_param_dec->acm_order = mzte_codec.acm_order = 0;
    vm_param_dec->acm_maxf=(Int *)malloc(6*sizeof(Int));
    for(i=0;i<6;i++)
      vm_param_dec->acm_maxf[i] = 16383;
    mzte_codec.acm_maxf = vm_param_dec->acm_maxf;

/*begin: added by Sharp(99/2/16)*/
    vm_param_dec->tiling_disable = mzte_codec.tiling_disable;
    vm_param_dec->tile_width = mzte_codec.tile_width;
    vm_param_dec->tile_height = mzte_codec.tile_height;
    vm_param_dec->extension_type = 0;
		if ( mzte_codec.tiling_disable == 0 ) /* added by Sharp (99/5/10) */
    printf("target_tile_id: from %d to %d\n", mzte_codec.target_tile_id_from, mzte_codec.target_tile_id_to);

    vm_param_dec->target_tile_id_from = mzte_codec.target_tile_id_from;
    vm_param_dec->target_tile_id_to = mzte_codec.target_tile_id_to;
    vm_param_dec->iNumOfTile = mzte_codec.iNumOfTile;
/*end: added by Sharp(99/2/16)*/
    
    /*  init_acm_maxf_dec(); */ /* new */
    singleBitFile = 1;
    bitFile = vm_param->bitFile;
    decoder=0; /* new */
    mzte_codec.target_spatial_levels = vtc->target_spatial_levels;  /* new */
/*begin: modified by Sharp (99/5/10)*/
    mzte_codec.target_snr_levels = vtc->target_snr_levels; /* new */
/*    mzte_codec.target_spatial_levels = vtc->target_spatial_levels;*/ /* new */
/*end: modified by Sharp (99/5/10)*/

/* SAIT_V2 begin: added by Samsung AIT (99/02/23)  */
		vm_param_dec->target_shape_levels = mzte_codec.target_shape_levels;
		vm_param_dec->full_size_out = mzte_codec.full_size_out;
		vm_param_dec->target_spatial_levels = mzte_codec.target_spatial_levels;
/* SAIT_V2 end */

/*begin: added by Sharp(99/2/16)*/
		if ((bitfile=fopen(bitFile,"rb"))==NULL)
		errorHandler("Can't open file '%s' for reading.",bitFile);

		init_bit_packing_fp(bitfile,1);
		header_Dec(vm_param_dec, &wvtfilter, NULL, &header_size);

/* @@@@@@@@@ */
/* begin: deleted for FDAM1 by Samsung AIT (2000/01/10) */
		/* if (mzte_codec.error_res_flag)
			mzte_codec.segment_thresh=get_X_bits(16);*/
/* end: deleted for FDAM1 by Samsung AIT (2000/01/10) */
  
		if ( mzte_codec.tiling_disable == 0){
/*begin: modified by Sharp (99/5/10)*/
 			if ( mzte_codec.iNumOfTile > vm_param_dec->target_tile_id_from )
 				mzte_codec.target_tile_id_from = vm_param_dec->target_tile_id_from;
 			else
 				mzte_codec.target_tile_id_from = mzte_codec.iNumOfTile;
 			if ( mzte_codec.iNumOfTile > vm_param_dec->target_tile_id_to )
 				mzte_codec.target_tile_id_to = vm_param_dec->target_tile_id_to;
 			else
/* FPDAM begin: modified by SAIT (99/09/03) */
/* 				mzte_codec.target_tile_id_to = mzte_codec.iNumOfTile;*/
 				mzte_codec.target_tile_id_to = mzte_codec.iNumOfTile - 1;
/* FPDAM end: modified by SAIT (99/09/03) */

/*			mzte_codec.target_tile_id_from = vm_param_dec->target_tile_id_from;*/
/*			mzte_codec.target_tile_id_to = vm_param_dec->target_tile_id_to;*/
/*end: modified by Sharp (99/5/10)*/

			target_iNum = mzte_codec.target_tile_id_to + 1 - mzte_codec.target_tile_id_from;
/*begin: added by Sharp (99/5/10)*/
 			if ( mzte_codec.iNumOfTile < target_iNum )
 				iNumOfTile = mzte_codec.iNumOfTile;
 			else
/*end: added by Sharp (99/5/10)*/
			iNumOfTile = target_iNum;

		} else {
			iNumOfTile = 1;
		}

  if (mzte_codec.tiling_disable == 0) {
/*    Int TileX, TileY; */ /* deleted by Sharp (99/5/10) */
    Int FromX, ToX, FromY, ToY;
/*    table = (Int *)malloc(sizeof(Int)*mzte_codec.iNumOfTile); */ /* table is already malloced */
/*begin: modified by Sharp (99/5/10)*/
    jump_table = (Int *)malloc(sizeof(Int)*mzte_codec.iNumOfTile+1);
    decode_tile_id = (Int *)malloc(sizeof(Int)*mzte_codec.iNumOfTile+1);
/*    jump_table = (Int *)malloc(sizeof(Int)*mzte_codec.iNumOfTile);*/
/*    decode_tile_id = (Int *)malloc(sizeof(Int)*mzte_codec.iNumOfTile);*/
/*end: modified by Sharp (99/5/10)*/
		if ( mzte_codec.tiling_jump_table_enable == 1 )
			tile_table_Dec(table);

/*begin: modified by Sharp (99/5/10)*/
/* FPDAM begin : modified by SAIT (99/09/03) */
		/*
		TileX = mzte_codec.display_width/mzte_codec.tile_width+((mzte_codec.display_width%mzte_codec.tile_width)?1:0);
		TileY = mzte_codec.display_height/mzte_codec.tile_height+((mzte_codec.display_height%mzte_codec.tile_height)?1:0);
		*/
	TileX = mzte_codec.object_width/mzte_codec.tile_width+((mzte_codec.object_width%mzte_codec.tile_width)?1:0);
	TileY = mzte_codec.object_height/mzte_codec.tile_height+((mzte_codec.object_height%mzte_codec.tile_height)?1:0);
/* FPDAM end : modified by SAIT (99/09/03) */
/*    TileX = mzte_codec.display_width / mzte_codec.tile_width;*/
/*    TileY = mzte_codec.display_height / mzte_codec.tile_height;*/
/*end: modified by Sharp (99/5/10)*/

    FromX = mzte_codec.target_tile_id_from % TileX;
    ToX = mzte_codec.target_tile_id_to % TileX;
    FromY = mzte_codec.target_tile_id_from / TileX;
    ToY = mzte_codec.target_tile_id_to / TileX;
    set_decode_tile_id_and_position(&iNumOfTile, &jump_table, &decode_tile_id, table, header_size);

/*begin: modified by Sharp (99/5/10)*/
/* FPDAM begin : modified by SAIT (99/09/03) */
		/*
		if ( ToX == TileX-1 )
			mzte_codec.display_width -= FromX*mzte_codec.tile_width;
		else
			mzte_codec.display_width = (ToX-FromX+1)*mzte_codec.tile_width;
		if ( ToY == TileY-1 )
			mzte_codec.display_height -= FromY*mzte_codec.tile_height;
		else
			mzte_codec.display_height = (ToY-FromY+1)*mzte_codec.tile_height;
		*/
		if ( ToX == TileX-1 )
			mzte_codec.object_width -= FromX*mzte_codec.tile_width;
		else
			mzte_codec.object_width = (ToX-FromX+1)*mzte_codec.tile_width;
		if ( ToY == TileY-1 )
			mzte_codec.object_height -= FromY*mzte_codec.tile_height;
		else
			mzte_codec.object_height = (ToY-FromY+1)*mzte_codec.tile_height;

		mzte_codec.object_origin_x += FromX*mzte_codec.tile_width;
		mzte_codec.object_origin_y += FromY*mzte_codec.tile_height;
/* FPDAM end : modified by SAIT (99/09/03) */
		
    if(mzte_codec.quantization_type==2) {
      Int target_spatial_levels;
      target_spatial_levels=MIN(mzte_codec.spatial_scalability_levels,
                            mzte_codec.target_spatial_levels);
      MinLevel =  mzte_codec.wvtDecompLev -1- 
	mzte_codec.lastWvtDecompInSpaLayer[target_spatial_levels-1][0];
    }
    else {
      MinLevel = mzte_codec.spatial_scalability_levels -
        mzte_codec.target_spatial_levels;
    }
    if(MinLevel <0) MinLevel=0;
/* FPDAM begin : modified by SAIT (99/09/03) */
		/*
		mzte_codec.display_width = mzte_codec.display_width>>MinLevel;
		mzte_codec.display_height = mzte_codec.display_height>>MinLevel;
		*/
		mzte_codec.object_width = mzte_codec.object_width>>MinLevel;
		mzte_codec.object_height = mzte_codec.object_height>>MinLevel;
/* FPDAM end : modified by SAIT (99/09/03) */
/*    mzte_codec.display_width = (ToX-FromX+1)*mzte_codec.tile_width;*/
/*    mzte_codec.display_height = (ToY-FromY+1)*mzte_codec.tile_height;*/

    /* allocate full frame buffer to store wvt coefficients */
/* FPDAM begin : modified by SAIT (99/09/03) */
    /*
    frm[0]=(UChar *)malloc(sizeof(UChar)*mzte_codec.display_width*mzte_codec.display_height);
    frm[1]=(UChar *)malloc(sizeof(UChar)*(mzte_codec.display_width>>1)*(mzte_codec.display_height>>1));
    frm[2]=(UChar *)malloc(sizeof(UChar)*(mzte_codec.display_width>>1)*(mzte_codec.display_height>>1));
    */
    frm[0]=(UChar *)calloc(mzte_codec.object_width*mzte_codec.object_height,sizeof(UChar));
    frm[1]=(UChar *)calloc((mzte_codec.object_width>>1)*(mzte_codec.object_height>>1),sizeof(UChar));
    frm[2]=(UChar *)calloc((mzte_codec.object_width>>1)*(mzte_codec.object_height>>1),sizeof(UChar));
    frm_mask[0]=(UChar *)calloc(mzte_codec.object_width*mzte_codec.object_height,sizeof(UChar));
    frm_mask[1]=(UChar *)calloc((mzte_codec.object_width>>1)*(mzte_codec.object_height>>1),sizeof(UChar));
    frm_mask[2]=(UChar *)calloc((mzte_codec.object_width>>1)*(mzte_codec.object_height>>1),sizeof(UChar));
/* FPDAM end : modified by SAIT (99/09/03) */
/*    frm[0]=(DATA *)malloc(sizeof(DATA)*mzte_codec.display_width*mzte_codec.display_height);*/
/*    frm[1]=(DATA *)malloc(sizeof(DATA)*(mzte_codec.display_width>>1)*(mzte_codec.display_height>>1));*/
/*    frm[2]=(DATA *)malloc(sizeof(DATA)*(mzte_codec.display_width>>1)*(mzte_codec.display_height>>1));*/
/*begin: modified by Sharp (99/5/10)*/

    /* set last tile_id */
    if (mzte_codec.extension_type == 1) {
      id_to = mzte_codec.target_tile_id_to + (mzte_codec.display_width / mzte_codec.tile_width) + 1;
      if (id_to >= mzte_codec.iNumOfTile)
        id_to = mzte_codec.iNumOfTile -1;
    } else {
      id_to = mzte_codec.target_tile_id_to;
    }
  }

	for ( ii=0; ii<iNumOfTile; ii++ ){

/* begin: added by Sharp(99/4/7) */
		if ( mzte_codec.tiling_disable == 0 ){
			if ( mzte_codec.tiling_jump_table_enable == 1 ){
				noteProgress("%d bytes jump\n", jump_table[ii]);
				relative_jump(jump_table[ii]);
			}
			else
				search_tile(decode_tile_id[ii]);

/* FPDAM begin: modified by SAIT (99/09/03) */
			/*get_virtual_tile_mask(vm_param_dec, ii, TileX, TileY);*/ /* added by Sharp (99/5/10) */
			/*tile_header_Dec();*/
			tile_header_Dec(vm_param_dec, wvtfilter, decode_tile_id[ii], ii, TileX, TileY); 
/* FPDAM end: modified by SAIT (99/09/03) */
		}
		if ( mzte_codec.error_res_flag )
			texture_packet_header_Dec(vm_param_dec, &wvtfilter, NULL, &header_size); 
/* end: added by Sharp(99/4/7) */

/*FPDAM begin : modified by SAIT (99/09/03) */
/*		TextureObjectLayer_dec(vm_param_dec, mzte_codec.target_spatial_levels,
          mzte_codec.target_snr_levels,&wvtfilter, ii, bitfile, &table);*/
		TextureObjectLayer_dec(vm_param_dec, mzte_codec.target_spatial_levels,
          mzte_codec.target_snr_levels,&wvtfilter, (mzte_codec.tiling_disable?ii:decode_tile_id[ii]), ii, bitfile, &table);
/*FPDAM end : modified by SAIT (99/09/03) */

/*begin: added by Sharp (99/5/10)*/
		noteProgress("\nInverse Wavelet Transform....");
/* FPDAM begin: modified by SAIT(99/09/03)  */
		/*
		if ( mzte_codec.tiling_disable == 0 )
			perform_IDWT_Tile(vm_param_dec, wvtfilter, frm, ii, TileX);
		else
			perform_IDWT(vm_param_dec, wvtfilter, recImgFile);
		*/
		if ( mzte_codec.tiling_disable == 0 ) {
		    if(!mzte_codec.sa_dwt || mzte_codec.texture_tile_type!=TRANSP_TILE)
			perform_IDWT_Tile(vm_param_dec, wvtfilter, frm, frm_mask, ii, TileX);
		} else {
			perform_IDWT(vm_param_dec, wvtfilter, recImgFile);
		}
/* FPDAM end: modified by SAIT (99/09/03) */
		noteProgress("Completed inverse wavelet transform.");
/*end: added by Sharp (99/5/10)*/
		
		if ( mzte_codec.tiling_disable == 0 ){
/*      copy_coeffs(ii, frm);*/ /* deleted by Sharp (99/5/10) */
      align_byte();
      clear_coeffinfo();
		}
  }
/*begin: added by Sharp (99/5/10)*/
/* FPDAM begin: modified by SAIT (99/09/03)*/
	if ( mzte_codec.tiling_disable == 0 )
/*		write_image_tile(recImgFile, frm);*/
        	write_image(recImgFile, mzte_codec.colors,
              		mzte_codec.object_width, mzte_codec.object_height,
              		mzte_codec.display_width, mzte_codec.display_height,
              		mzte_codec.object_origin_x, mzte_codec.object_origin_y,
              		frm, frm_mask,
              		mzte_codec.sa_dwt,
              		mzte_codec.STO_const_alpha,             /* SAIT_V2: added by Samsung AIT (99/02/23) */
              		mzte_codec.STO_const_alpha_value,       /* SAIT_V2: added by Samsung AIT (99/02/23) */
              		FULLSIZE, MinLevel);
/* FPDAM end: modified by SAIT (99/09/03)*/
/*end: added by Sharp (99/5/10)*/

/*begin: deleted by Sharp (99/4/7)*/
#if 0
  if ( mzte_codec.tiling_disable == 0 ){
    for ( ii=0; ii<iNumOfTile; ii++ ){

			if ( mzte_codec.tiling_jump_table_enable == 1 ){
				noteProgress("%d bytes jump\n", jump_table[ii]);
				relative_jump(jump_table[ii]);
			}
			else
				search_tile(decode_tile_id[ii]);

      TextureObjectLayer_dec(vm_param_dec, mzte_codec.target_spatial_levels,
          mzte_codec.target_snr_levels,&wvtfilter, ii, bitfile, &table);
      copy_coeffs(ii, frm);

      align_byte();
      clear_coeffinfo();

/*      noteDetail("Freeing up decoding data structures....");*/
/*      for (col=0; col<mzte_codec.colors; col++) {*/
/*        free(mzte_codec.SPlayer[col].coeffinfo[0]);*/
/*        free(mzte_codec.SPlayer[col].coeffinfo);*/
/*      }*/
/*      noteDetail("Completed freeing up decoding data structures.");*/
    }
  } else {
		header_Dec_Common(vm_param_dec, &wvtfilter, NULL, &header_size, 0); /* @@@@@ */
    TextureObjectLayer_dec(vm_param_dec, mzte_codec.target_spatial_levels,
        mzte_codec.target_snr_levels,&wvtfilter, 0, bitfile, &table);
  }
/*end: added by Sharp(99/2/16)*/
#endif
/*end: deleted by Sharp (99/4/7)*/

/*    TextureObjectLayer_dec(vm_param_dec, mzte_codec.target_spatial_levels,*/
/*                           mzte_codec.target_snr_levels, &wvtfilter); deleted by Sharp (99/2/16)*/
    
/*begin: deleted by Sharp (99/5/10)*/
/*    noteProgress("\nInverse Wavelet Transform....");*/
/*begin: added by Sharp(99/2/16)*/
/*    if (mzte_codec.tiling_disable == 0)*/
/*			perform_IDWT_Tile(vm_param_dec,wvtfilter,recImgFile,frm);*/
/*		else*/
/*end: added by Sharp(99/2/16)*/
/*			perform_IDWT(vm_param_dec, wvtfilter,  recImgFile);*/
/*    noteProgress("Completed inverse wavelet transform.");*/
/*end: deleted by Sharp (99/5/10)*/
    
  /*----- free up coeff data structure -----*/
  noteDetail("Freeing up encoding data structures....");
  for (col=0; col<mzte_codec.colors; col++) {
    free(mzte_codec.SPlayer[col].coeffinfo[0]);
    free(mzte_codec.SPlayer[col].coeffinfo);
  }
  noteDetail("Completed freeing up encoding data structures.");

  noteProgress("\n----- Encoding Completed. -----\n");
  free(anafilter);
  free(synfilter);
/* begin: added by Rockwell (99/3/3) */ 
/* IM: hack to fix core dump */
  /* free_vm_param(vm_param); */
/* end: added by Rockwell (99/3/3) */
	}
	else { /* version 1 */
    SOL_PARAMETERS_DEC *vm_param_dec;
    FILTER **wvtfilter;
    
/*    noteProgress("\n----- MPEG-4 Visual Texture Coding: Decoding -----\n");*/
		printf("Version 1 bitstream\n"); /* added by Sharp (99/11/18) */
    
    /* Read in decoding parameters */
    if ((vm_param_dec = 
         (SOL_PARAMETERS_DEC *)malloc(sizeof(SOL_PARAMETERS_DEC)*1)) == NULL)
      errorHandler("Allocating memory for parameters.");
    
    vm_param_dec->height  = mzte_codec.height;
    vm_param_dec->width   = mzte_codec.width;
    vm_param_dec->wvtType = mzte_codec.wvtType;
    vm_param_dec->SegPath = vm_param->SegPath;
    vm_param_dec->width = mzte_codec.width;
    vm_param_dec->height = mzte_codec.height;
    vm_param_dec->colors = mzte_codec.colors=3;
    vm_param_dec->bit_depth =mzte_codec.bit_depth=8;
    vm_param_dec->wvtDecompLev = mzte_codec.wvtDecompLev;
    vm_param_dec->acm_order = mzte_codec.acm_order = 0;
    vm_param_dec->acm_maxf=(Int *)malloc(6*sizeof(Int));
    for(i=0;i<6;i++)
      vm_param_dec->acm_maxf[i] = 16383;
    mzte_codec.acm_maxf = vm_param_dec->acm_maxf;
    
    /*  init_acm_maxf_dec(); */ /* new */
    singleBitFile = 1;
    bitFile = vm_param->bitFile;
    decoder=0; /* new */
     mzte_codec.target_spatial_levels = vtc->target_spatial_levels;  /* new */
     mzte_codec.target_spatial_levels = vtc->target_spatial_levels; /* new */

     TextureObjectLayer_dec_V1(vm_param_dec, mzte_codec.target_spatial_levels,
                           mzte_codec.target_snr_levels, &wvtfilter); 
    
    noteProgress("\nInverse Wavelet Transform....");
    perform_IDWT(vm_param_dec, wvtfilter,  recImgFile);
    noteProgress("Completed inverse wavelet transform.");
    
 
		/*----- free up coeff data structure -----*/
		noteDetail("Freeing up encoding data structures....");
		for (col=0; col<mzte_codec.colors; col++) {
			free(mzte_codec.SPlayer[col].coeffinfo[0]);
			free(mzte_codec.SPlayer[col].coeffinfo);
		}
		noteDetail("Completed freeing up encoding data structures.");

		noteProgress("\n----- Encoding Completed. -----\n");
		free(anafilter);
		free(synfilter);
		free_vm_param(vm_param);
	}
	}
}


/*********************************************************************/
/*********************************************************************/
/*                          DECODING                                 */
/*********************************************************************/
/*********************************************************************/

static Void texture_packet_header_Dec(SOL_PARAMETERS_DEC *vm_param_dec, FILTER ***wvtfilter,
                               PICTURE **Image, Int *header_size) /* modified by Sharp (99/2/16) */
{  
/* begin: added by Rockwell (99/3/3) */ 
/* IM: VTC error res */ 
  /* bbc, 11/5/98 */
	prev_TU_first=prev_TU_last=prev_TU_err=-1;
	TU_first=TU_last=TU_max=TU_max_dc=0;
/* end: added by Rockwell (99/3/3) */

/* begin: added by Rockwell (99/3/3) */
  /* IM: VTC error res */ 
  /* texture_err_res_disable = 0 => error res ON
     texture_err_res_disable = 1 => error res OFF */
  /* mzte_codec.error_res_flag = !(get_X_bits(8)>>7); */
/*  mzte_codec.error_res_flag = !(get_X_bits(1)); This part is moved to header_Enc*/
	if ( mzte_codec.error_res_flag ) /* added by Sharp (99/4/1) */
		align_byte ();

  if (mzte_codec.error_res_flag)
    noteProgress("--- ST Error Resilience ON ---");

/* IM: VTC error res */ 
	/* error resilience, bbc, 11/5/98 */
  if (mzte_codec.error_res_flag)
    {
	get_err_resilience_header();
	if(TU_first !=0)
		errorHandler("Reading incorrected TU_first in the first packet.\n");
	if(get_X_bits(1) != 1)
		errorHandler("Reading incorrected HEC in the first packet.\n");

	if(mzte_codec.scan_direction==1) /* BB */
	/* set_prev_good_TU_height(0,0) */;
	else
		set_prev_good_TD_segment(-1,0,0);
	/* error resilience, bbc, 11/5/98 */
    }
/* end: added by Rockwell (99/3/3) */

	header_Dec_Common( vm_param_dec, wvtfilter, Image, header_size, 1);/* @@@@@ */ 

/* begin: added by Rockwell (99/3/3) */
/* IM: VTC error res */ 
    if (mzte_codec.error_res_flag)
      {
	/* segment threshold, bbc, 11/16/98 */
	mzte_codec.segment_thresh=get_X_bits(16);
/* begin: added for FDAM1 by Samsung AIT (2000/01/10) */
  	get_X_bits(1);
/* end: added for FDAM1 by Samsung AIT (2000/01/10) */
      }
/* end: added by Rockwell (99/3/3) */
}

static Void header_Dec_V1(SOL_PARAMETERS_DEC *vm_param_dec, FILTER ***wvtfilter,
		       PICTURE **Image)
{
  Int  texture_object_id;
  Int  marker_bit;
  Int  wavelet_download=0;
  Int  wavelet_uniform=1;
  Int  wavelet_type;
  Int  texture_object_layer_shape;
  Int  wavelet_stuffing;
  Int  still_texture_object_start_code;
  Int i;
  FILTER **filters;

  still_texture_object_start_code = get_X_bits(32);
  if (still_texture_object_start_code != STILL_TEXTURE_OBJECT_START_CODE)
    errorHandler("Wrong texture_object_layer_start_code.");

  texture_object_id = get_X_bits(16);
  marker_bit = get_X_bits(1);
  vm_param_dec->wvtType=wavelet_type = get_X_bits(1);
  vm_param_dec->wvtDownload=wavelet_download = get_X_bits(1);
  /* change #bits from 8 to 4 ph 7/16 */
  vm_param_dec->wvtDecompLev=mzte_codec.wvtDecompLev = get_X_bits(4);
  mzte_codec.scan_direction=get_X_bits(1);
  mzte_codec.SNR_start_code_enable = get_X_bits(1);


  texture_object_layer_shape = get_X_bits(2);
  mzte_codec.quantization_type = get_X_bits(2);

  /* PEZW: always enabled */
  if(mzte_codec.quantization_type == BILEVEL_Q)
    mzte_codec.SNR_start_code_enable = 1;

  /* added for spatial layer flexability - ph 7/16 */
  if (mzte_codec.quantization_type==2) /* MQ */
  {
    Int i;

    mzte_codec.spatial_scalability_levels = get_X_bits(4);
    /* Get/Calc number decomp layers for all spatial layers */
    if (mzte_codec.spatial_scalability_levels == 1)
    {
      mzte_codec.lastWvtDecompInSpaLayer[0][0]=mzte_codec.wvtDecompLev-1;
    }
    else if (mzte_codec.spatial_scalability_levels != mzte_codec.wvtDecompLev)
    {
      mzte_codec.defaultSpatialScale = get_X_bits(1);
      if (mzte_codec.defaultSpatialScale==0)
      {
	/* Fill in the luma componant of lastWvtDecompInSpaLayer. */
	for (i=0; i<mzte_codec.spatial_scalability_levels-1; ++i)
	  mzte_codec.lastWvtDecompInSpaLayer[i][0]=get_X_bits(4);
	
	mzte_codec.lastWvtDecompInSpaLayer\
	  [mzte_codec.spatial_scalability_levels-1][0]
	  =mzte_codec.wvtDecompLev-1;
      }
      else
      {
	Int sp0;

	sp0=mzte_codec.wvtDecompLev-mzte_codec.spatial_scalability_levels;
	mzte_codec.lastWvtDecompInSpaLayer[0][0]=sp0;
	  
	for (i=1; i<mzte_codec.spatial_scalability_levels; ++i)
	  mzte_codec.lastWvtDecompInSpaLayer[i][0]=sp0+i;
      }
    }
    else
    {
      for (i=0; i<mzte_codec.spatial_scalability_levels; ++i)
	mzte_codec.lastWvtDecompInSpaLayer[i][0]=i;
    }
    
    /* Calculate for chroma (one less than luma) */
    for (i=0; i<mzte_codec.spatial_scalability_levels; ++i)
      mzte_codec.lastWvtDecompInSpaLayer[i][1]
	=mzte_codec.lastWvtDecompInSpaLayer[i][2]
	=mzte_codec.lastWvtDecompInSpaLayer[i][0]-1;
  }

 
  /* new wavelet download SL: 07/17 */
  filters = (FILTER **)malloc(sizeof(FILTER *)*mzte_codec.wvtDecompLev);
  if(filters==NULL)  
    errorHandler("Memory allocation error\n");
  if (wavelet_download == 1) {
    vm_param_dec->wvtUniform=wavelet_uniform = get_X_bits(1);
    if(wavelet_uniform) {
      download_wavelet_filters(&(filters[0]), wavelet_type);
    }
    else {
      for(i=0;i< mzte_codec.wvtDecompLev; i++) {
	download_wavelet_filters(&(filters[mzte_codec.wvtDecompLev-1-i]), wavelet_type);
      }
    }
  }
  else if(wavelet_type==0){
    mzte_codec.wvtType = 0;
    filters[0]=&DefaultSynthesisFilterInt;
  }
  else{
    mzte_codec.wvtType = 1;
    filters[0]=&DefaultSynthesisFilterDbl;
  }

  if(wavelet_uniform) {
     for(i=1;i< mzte_codec.wvtDecompLev; i++) {
       filters[i] = filters[0];
     }
  }

  *wvtfilter = filters;
  /* new wavelet download end SL*/
  wavelet_stuffing = get_X_bits(3);

  if (texture_object_layer_shape==0) {
    mzte_codec.sa_dwt       = 0; 
    mzte_codec.width = get_X_bits(15);
    marker_bit = get_X_bits(1);
    mzte_codec.height = get_X_bits(15);
    marker_bit = get_X_bits(1);
    vm_param_dec->width  = mzte_codec.width;  /* new */
    vm_param_dec->height = mzte_codec.height; /* new */
  }
  else { /* Arbitrary shape header */
    mzte_codec.sa_dwt       = 1; 
    mzte_codec.origin_x = get_X_bits(15);
    marker_bit = get_X_bits(1);
    mzte_codec.origin_y = get_X_bits(15);
    marker_bit = get_X_bits(1);
    mzte_codec.width = get_X_bits(15);
    marker_bit = get_X_bits(1);
    mzte_codec.height = get_X_bits(15);
    marker_bit = get_X_bits(1);
    mzte_codec.real_width = vm_param_dec->width;
    mzte_codec.real_height = vm_param_dec->height;
  }

  /* decode the shape info from bitstream */
  mzte_codec.colors=3;   /* new */
  mzte_codec.bit_depth=8;  /* new */
  if(mzte_codec.sa_dwt)
    noteProgress("Decoding Shape Information...");
  *Image = (PICTURE *)malloc(sizeof(PICTURE)*3);
  
/* begin : modified by D.-S.Cho, Samsung AIT (99/04/13) */
  /*
  get_virtual_mask(*Image, mzte_codec.wvtDecompLev,
		   mzte_codec.width, mzte_codec.height, 
		   mzte_codec.sa_dwt, vm_param_dec->colors, filters);
  */
  get_virtual_mask_V1(*Image, 
			mzte_codec.wvtDecompLev,
		   	mzte_codec.width, 
			mzte_codec.height, 
		   	mzte_codec.sa_dwt, 
			vm_param_dec->colors, 
			filters);
/* end : modified by D.-S.Cho, Samsung AIT (99/04/13) */
}

static Void header_Dec(SOL_PARAMETERS_DEC *vm_param_dec, FILTER ***wvtfilter,
		       PICTURE **Image, Int *header_size) /* modified by Sharp (99/2/16) */
{
  Int  still_texture_object_start_code;
  Int h_size = 0; /* added by Sharp (99/2/16) */

/* begin: added by Rockwell (99/3/3) */ 
/* IM: VTC error res */ 
  /* bbc, 11/5/98 */
	prev_TU_first=prev_TU_last=prev_TU_err=-1;
	TU_first=TU_last=TU_max=TU_max_dc=0;
/* end: added by Rockwell (99/3/3) */

  still_texture_object_start_code = get_X_bits(32);
  if (still_texture_object_start_code != STILL_TEXTURE_OBJECT_START_CODE)
    errorHandler("Wrong texture_object_layer_start_code.");
	h_size += 32;

  mzte_codec.tiling_disable = get_X_bits(1);
  h_size += 1;

/* begin: added by Sharp (99/4/7) */
  mzte_codec.error_res_flag = !(get_X_bits(1));
  h_size += 1;

/*	if ( !mzte_codec.error_res_flag )*/ /* @@@@@ */
		header_Dec_Common( vm_param_dec, wvtfilter, Image, header_size, 0);/* @@@@@ */
/* end: added by Sharp (99/4/7) */

/*begin: added by Sharp (99/2/16)*/
  if ( mzte_codec.tiling_disable == 0 ){
/*		header_Dec_Common( vm_param_dec, wvtfilter, Image, header_size);*/

    mzte_codec.width = mzte_codec.tile_width = get_X_bits(15); /* modified by Sharp (99/11/16) */
		get_X_bits(1);
    mzte_codec.tile_height = mzte_codec.height = get_X_bits(15); /* modified by Sharp (99/11/16) */
		get_X_bits(1);
    mzte_codec.iNumOfTile = get_X_bits(16);
    get_X_bits(1);
		mzte_codec.tiling_jump_table_enable = get_X_bits(1);
		mzte_codec.extension_type = 0;
		h_size += 50; /* modified by Sharp (99/11/16) */
/*deleted by Sharp (99/4/7)*/
/*    mzte_codec.iNumOfTile = mzte_codec.display_width/mzte_codec.tile_width*mzte_codec.display_height/mzte_codec.tile_height;*/
		*header_size += h_size; /* by bits (not by bytes) */
  }

/*end: added by Sharp (99/2/16)*/

/*begin: deleted by Sharp (99/2/16)*/
  /* decode the shape info from bitstream */
/*
  mzte_codec.colors=3;
  mzte_codec.bit_depth=8;
  if(mzte_codec.sa_dwt)
    noteProgress("Decoding Shape Information...");
  *Image = (PICTURE *)malloc(sizeof(PICTURE)*3);
  
  get_virtual_mask(*Image, mzte_codec.wvtDecompLev,
		   mzte_codec.width, mzte_codec.height, 
		   mzte_codec.sa_dwt, vm_param_dec->colors, filters); */
/*end: deleted by Sharp (99/2/16)*/
}

static Void header_Dec_Common(SOL_PARAMETERS_DEC *vm_param_dec, FILTER ***wvtfilter,
		       PICTURE **Img, Int *header_size, Int SkipShape) /* modified by Sharp (99/2/16) */ /* @@@@@@ */
{
  Int  texture_object_id;
  Int  marker_bit;
  Int  wavelet_download=0;
  Int  wavelet_uniform=1;
  Int  wavelet_type;
  Int  texture_object_layer_shape;
  Int  wavelet_stuffing;
  Int i;
  FILTER **filters;
  Int h_size = 0; /* added by Sharp (99/2/16) */
/*begin: added by Sharp (99/4/7)*/
	PICTURE *Image;
	Int target_spatial_layer, target_shape_layer; /* SAIT_V2: added by Samsung AIT (99/02/23) */
/*end: added by Sharp (99/4/7)*/

/* This part is moved to the textur_packet_header_Dec() */
#if 0
/* begin: added by Rockwell (99/3/3) */
  /* IM: VTC error res */ 
  /* texture_err_res_disable = 0 => error res ON
     texture_err_res_disable = 1 => error res OFF */
  /* mzte_codec.error_res_flag = !(get_X_bits(8)>>7); */
/*  mzte_codec.error_res_flag = !(get_X_bits(1)); This part is moved to header_Enc*/
	if ( mzte_codec.error_res_flag ) /* added by Sharp (99/4/1) */
		align_byte ();

  if (mzte_codec.error_res_flag)
    noteProgress("--- ST Error Resilience ON ---");

/* IM: VTC error res */ 
	/* error resilience, bbc, 11/5/98 */
  if (mzte_codec.error_res_flag)
    {
	get_err_resilience_header();
	if(TU_first !=0)
		errorHandler("Reading incorrected TU_first in the first packet.\n");
	if(get_X_bits(1) != 1)
		errorHandler("Reading incorrected HEC in the first packet.\n");

	if(mzte_codec.scan_direction==1) /* BB */
	/* set_prev_good_TU_height(0,0) */;
	else
		set_prev_good_TD_segment(-1,0,0);
	/* error resilience, bbc, 11/5/98 */
    }
/* end: added by Rockwell (99/3/3) */
#endif

  texture_object_id = get_X_bits(16);
  marker_bit = get_X_bits(1);
  vm_param_dec->wvtType=wavelet_type = get_X_bits(1);
  vm_param_dec->wvtDownload=wavelet_download = get_X_bits(1);
  /* change #bits from 8 to 4 ph 7/16 */
  vm_param_dec->wvtDecompLev=mzte_codec.wvtDecompLev = get_X_bits(4);
  mzte_codec.scan_direction=get_X_bits(1);
  mzte_codec.SNR_start_code_enable = get_X_bits(1);

  texture_object_layer_shape = get_X_bits(2);
  mzte_codec.quantization_type = get_X_bits(2);
  h_size += 16+1+1+1+4+1+1+2+2; /* added by Sharp (99/2/16) */

  /* PEZW: always enabled */
  if(mzte_codec.quantization_type == BILEVEL_Q)
    mzte_codec.SNR_start_code_enable = 1;

  /* added for spatial layer flexability - ph 7/16 */
  if (mzte_codec.quantization_type==2) /* MQ */
  {
    Int i;

    mzte_codec.spatial_scalability_levels = get_X_bits(4);
		h_size += 4; /* added by Sharp (99/2/16) */
    /* Get/Calc number decomp layers for all spatial layers */
    if (mzte_codec.spatial_scalability_levels == 1)
    {
      mzte_codec.lastWvtDecompInSpaLayer[0][0]=mzte_codec.wvtDecompLev-1;
    }
    else if (mzte_codec.spatial_scalability_levels != mzte_codec.wvtDecompLev)
    {
      mzte_codec.defaultSpatialScale = get_X_bits(1);
			h_size += 1; /* added by Sharp (99/2/16) */
      if (mzte_codec.defaultSpatialScale==0)
      {
	/* Fill in the luma componant of lastWvtDecompInSpaLayer. */
	for (i=0; i<mzte_codec.spatial_scalability_levels-1; ++i){
	  mzte_codec.lastWvtDecompInSpaLayer[i][0]=get_X_bits(4);
		h_size += 4; /* added by Sharp (99/2/16) */
	}
	
	mzte_codec.lastWvtDecompInSpaLayer\
	  [mzte_codec.spatial_scalability_levels-1][0]
	  =mzte_codec.wvtDecompLev-1;
      }
      else
      {
	Int sp0;

	sp0=mzte_codec.wvtDecompLev-mzte_codec.spatial_scalability_levels;
	mzte_codec.lastWvtDecompInSpaLayer[0][0]=sp0;
	  
	for (i=1; i<mzte_codec.spatial_scalability_levels; ++i)
	  mzte_codec.lastWvtDecompInSpaLayer[i][0]=sp0+i;
      }
    }
    else
    {
      for (i=0; i<mzte_codec.spatial_scalability_levels; ++i)
	mzte_codec.lastWvtDecompInSpaLayer[i][0]=i;
    }
    
    /* Calculate for chroma (one less than luma) */
    for (i=0; i<mzte_codec.spatial_scalability_levels; ++i)
      mzte_codec.lastWvtDecompInSpaLayer[i][1]
	=mzte_codec.lastWvtDecompInSpaLayer[i][2]
	=mzte_codec.lastWvtDecompInSpaLayer[i][0]-1;
  }

 
  /* new wavelet download SL: 07/17 */
  filters = (FILTER **)malloc(sizeof(FILTER *)*mzte_codec.wvtDecompLev);
  if(filters==NULL)  
    errorHandler("Memory allocation error\n");
  if (wavelet_download == 1) {
    vm_param_dec->wvtUniform=wavelet_uniform = get_X_bits(1);
		h_size += 1; /* added by Sharp (99/2/16) */
    if(wavelet_uniform) {
      download_wavelet_filters(&(filters[0]), wavelet_type);
    }
    else {
      for(i=0;i< mzte_codec.wvtDecompLev; i++) {
	download_wavelet_filters(&(filters[mzte_codec.wvtDecompLev-1-i]), wavelet_type);
      }
    }
  }
  else if(wavelet_type==0){
    mzte_codec.wvtType = 0;
    filters[0]=&DefaultSynthesisFilterInt;
  }
  else{
    mzte_codec.wvtType = 1;
    filters[0]=&DefaultSynthesisFilterDbl;
  }

  if(wavelet_uniform) {
     for(i=1;i< mzte_codec.wvtDecompLev; i++) {
       filters[i] = filters[0];
     }
  }

  *wvtfilter = filters;

  /* new wavelet download end SL*/
  wavelet_stuffing = get_X_bits(3);
	h_size += 3; /* added by Sharp (99/2/16) */

/* begin: added for FDAM1 by Samsung AIT (2000/01/10) */
    if (mzte_codec.error_res_flag && SkipShape==0)
      {
	mzte_codec.segment_thresh=get_X_bits(16);
        marker_bit = get_X_bits(1);
	h_size += 16+1;
      }
/* end: added for FDAM1 by Samsung AIT (1999/12/24) */

  if (texture_object_layer_shape==0) {

/*begin: added by Sharp (99/2/16)*/
		mzte_codec.sa_dwt       = 0; 
		mzte_codec.width = mzte_codec.display_width = get_X_bits(15);
		marker_bit = get_X_bits(1);
		mzte_codec.height = mzte_codec.display_height = get_X_bits(15);
		marker_bit = get_X_bits(1);
		h_size += 15+1+15+1; /* added by Sharp (99/2/16) */
/* FPDAM begin : added by SAIT (99/09/03)*/
    mzte_codec.object_origin_x = 0;
    mzte_codec.object_origin_y = 0;
    mzte_codec.object_width = mzte_codec.display_width;
    mzte_codec.object_height = mzte_codec.display_height;
/* FPDAM end : added by SAIT (99/09/03)*/
/*end: added by Sharp (99/2/16)*/
/*begin: deleted by Sharp (99/2/16)*/
/*			mzte_codec.sa_dwt       = 0; 
			mzte_codec.width = get_X_bits(15);
			marker_bit = get_X_bits(1);
			mzte_codec.height = get_X_bits(15);
			marker_bit = get_X_bits(1); */
/*end: deleted by Sharp (99/2/16)*/
    vm_param_dec->width  = mzte_codec.width;  /* new */
    vm_param_dec->height = mzte_codec.height; /* new */
  }
  else { /* Arbitrary shape header */
/* FPDAM begin : modified by SAIT (99/09/03)*/
/*
    mzte_codec.sa_dwt       = 1; 
    mzte_codec.origin_x = get_X_bits(15);
    marker_bit = get_X_bits(1);
    mzte_codec.origin_y = get_X_bits(15);
    marker_bit = get_X_bits(1);
    mzte_codec.width = get_X_bits(15);
    marker_bit = get_X_bits(1);
    mzte_codec.height = get_X_bits(15);
    marker_bit = get_X_bits(1);
    mzte_codec.real_width = vm_param_dec->width;
    mzte_codec.real_height = vm_param_dec->height;
*/
    mzte_codec.sa_dwt       = 1; 
    mzte_codec.origin_x = mzte_codec.object_origin_x = get_X_bits(15);
    marker_bit = get_X_bits(1);
    mzte_codec.origin_y = mzte_codec.object_origin_y = get_X_bits(15);
    marker_bit = get_X_bits(1);
    mzte_codec.width = mzte_codec.object_width = get_X_bits(15);
    marker_bit = get_X_bits(1);
    mzte_codec.height = mzte_codec.object_height = get_X_bits(15);
    marker_bit = get_X_bits(1);
    mzte_codec.real_width = mzte_codec.display_width = vm_param_dec->width;
    mzte_codec.real_height = mzte_codec.display_height = vm_param_dec->height;

    vm_param_dec->width  = mzte_codec.object_width;
    vm_param_dec->height = mzte_codec.object_height;
/* FPDAM end : modified by SAIT (99/09/03)*/
		h_size += 15+1+15+1+15+1+15+1; /* added by Sharp (99/2/16) */
  }

/* FPDAM begin : added by SAIT (99/09/03)*/
  if (mzte_codec.tiling_disable && SkipShape == 0) { /* @@@@@ */
/* FPDAM end : added by SAIT (99/09/03)*/

/*begin: added by Sharp (99/4/7)*/
  if(mzte_codec.sa_dwt)
  noteProgress("Decoding Shape Information...");
  Image = (PICTURE *)malloc(sizeof(PICTURE)*3);
	
/* SAIT_V2 begin : added by Samsung AIT (99/02/23)*/
  vm_param_dec->target_spatial_levels 
    = MIN(mzte_codec.spatial_scalability_levels, vm_param_dec->target_spatial_levels);
  vm_param_dec->target_shape_levels 
    = MIN(mzte_codec.spatial_scalability_levels, vm_param_dec->target_shape_levels);

  if(mzte_codec.quantization_type == 2) {
    target_spatial_layer = mzte_codec.wvtDecompLev -1-
      mzte_codec.lastWvtDecompInSpaLayer[vm_param_dec->target_spatial_levels-1][0];
    target_shape_layer = mzte_codec.wvtDecompLev -1-
      mzte_codec.lastWvtDecompInSpaLayer[vm_param_dec->target_shape_levels-1][0];
  }
  else {
    target_spatial_layer 
      = mzte_codec.spatial_scalability_levels - vm_param_dec->target_spatial_levels;
    target_shape_layer 
      = mzte_codec.spatial_scalability_levels - vm_param_dec->target_shape_levels;
  }
/* SAIT_V2 end */

/* FPDAM begin: modified by SAIT(99/09/03) */
#if 0
/*begin: added by Sharp (99/5/10)*/
	if ( decoder == 0 && mzte_codec.tiling_disable == 0 ){
		if ( mzte_codec.Image[0].mask) free(mzte_codec.Image[0].mask);
		if ( mzte_codec.Image[1].mask) free(mzte_codec.Image[1].mask);
		if ( mzte_codec.Image[2].mask) free(mzte_codec.Image[2].mask);
		ImagePtr = mzte_codec.Image;
	} else 
		ImagePtr = Image;
/*end: added by Sharp (99/5/10)*/
  
  get_virtual_mask(ImagePtr, mzte_codec.wvtDecompLev, /* modified by Sharp (99/5/10) */
    mzte_codec.width, mzte_codec.height,
    mzte_codec.sa_dwt, vm_param_dec->colors, 
	&target_shape_layer,			/* SAIT_V2: added by Samsung AIT (99/02/23) */
	mzte_codec.SNR_start_code_enable,	/* SAIT_V2: added by Samsung AIT (99/02/23) */
    *wvtfilter);
#endif
  get_virtual_mask(Image, mzte_codec.wvtDecompLev, 
    mzte_codec.width, mzte_codec.height,
    mzte_codec.sa_dwt, vm_param_dec->colors, 
	&target_shape_layer,			/* SAIT_V2: added by Samsung AIT (99/02/23) */
	mzte_codec.SNR_start_code_enable,	/* SAIT_V2: added by Samsung AIT (99/02/23) */
    *wvtfilter);
/* FPDAM end: modified by SAIT(99/09/03) */

/* SAIT_V2 begin: added by Samsung AIT (99/02/23) */
  if(target_shape_layer > target_spatial_layer) {
    noteWarning("Shape has less spatial layers than target,\n forced to  use shape spatial layers.\n");
    if(mzte_codec.quantization_type == 2) {
      for(i=0;i< mzte_codec.spatial_scalability_levels;i++) {
        if( mzte_codec.lastWvtDecompInSpaLayer[i][0] > mzte_codec.wvtDecompLev -1 - target_shape_layer){
          mzte_codec.target_spatial_levels 
		= vm_param_dec->target_spatial_levels = i;
          mzte_codec.lastWvtDecompInSpaLayer[i][0] 
		= mzte_codec.wvtDecompLev -1 - target_shape_layer;
          break;
        }
      }
    }
    else
      mzte_codec.target_spatial_levels 
		= vm_param_dec->target_spatial_levels 
		= mzte_codec.spatial_scalability_levels - target_shape_layer;
  }
/* SAIT_V2 end */
  if (decoder==1) /* new */
     mzte_codec.Image = Image;
/*end: added by Sharp (99/4/7)*/

/* FPDAM begin : added by SAIT (99/09/03)*/
  } /* if (mzte_codec.tiling_disable) */
/* FPDAM end : added by SAIT (99/09/03)*/
/* @@@@ */
  if ( mzte_codec.tiling_disable == 0 && SkipShape == 1){
    mzte_codec.width = mzte_codec.tile_width = get_X_bits(15); /* modified by Sharp (99/11/16) */
		get_X_bits(1);
    mzte_codec.tile_height = mzte_codec.height = get_X_bits(15); /* modified by Sharp (99/11/16) */
		get_X_bits(1);
		h_size += 2;
	}


	*header_size = h_size;

/*This part is moved to the texture_packet_header*/
#if 0
/* begin: added by Rockwell (99/3/3) */
/* IM: VTC error res */ 
    if (mzte_codec.error_res_flag)
      {
	/* segment threshold, bbc, 11/16/98 */
	mzte_codec.segment_thresh=get_X_bits(16);
      }
/* end: added by Rockwell (99/3/3) */
#endif

}


/* Read quant value from bitstream */
static Void Get_Quant_and_Max(SNR_IMAGE *snr_image, Int spaLayer, Int color)
{
  snr_image->quant     = get_param(7);
  /*  marker_bit=get_X_bits(1);
  if (marker_bit != 1)
     noteError("marker_bit should be 1"); */  /* 1124 */
  {
    Int l;
    
    for (l=0; l<=mzte_codec.lastWvtDecompInSpaLayer[spaLayer][color];++l)
    {
      snr_image->wvtDecompNumBitPlanes[l] = get_X_bits(5);
      
      if (((l+1) % 4) == 0)
	get_X_bits(1);
    }
  }

}

static Void Get_Quant_and_Max_SQBB(SNR_IMAGE *snr_image, Int spaLayer, 
				   Int color)
{
  if ((color==0 && spaLayer==0) || (color>0 && spaLayer==1))
    snr_image->quant = get_param(7);


  if (color==0)
    snr_image->wvtDecompNumBitPlanes[spaLayer] = get_X_bits(5);
  else if (spaLayer)
    snr_image->wvtDecompNumBitPlanes[spaLayer-1] = get_X_bits(5);

}


static Void textureLayerDC_Dec()
{
  Int col, err;

  noteProgress("Decoding DC coefficients....");
  for (col=0; col<mzte_codec.colors; col++) 
  {
    /* initilize all wavelet coefficients */
    mzte_codec.curColor=col;
    err=ztqInitDC(1, col);

    /* losslessly decoding DC coefficients */
    wavelet_dc_decode(col);

    /* dequantize DC coefficients */
    err=decIQuantizeDC(col);
  }  
  noteProgress("Completed decoding of DC coefficients.");
}


/*******************************************************
  The following two routines are for single quant 
  band by band scan order.
*******************************************************/
static Void TextureSpatialLayerSQNSC_dec(Int spa_lev)
{
  Int col;

    /* hjlee 0901 */
   SNR_IMAGE *snr_image;
/*
	if (spa_lev==0) {
  	  for (col=0; col<mzte_codec.colors; col++) {
	      snr_image = &(mzte_codec.SPlayer[col].SNRlayer.snr_image);
	      Get_Quant(snr_image, 0, col);
	  }
	  mzte_codec.curColor = col = 0;
      snr_image = &(mzte_codec.SPlayer[col].SNRlayer.snr_image);
      Get_MaxBitplane(snr_image, 0, col);
	  noteProgress("Single-Quant Mode (Band by Band) - Spatial %d, SNR 0, "\
	                "Color %d",spa_lev,col); fflush(stderr);
      wavelet_higher_bands_decode_SQ_band(col);
	}
	else if (spa_lev>0) {
	  for (col=0; col<mzte_codec.colors; col++) {
	      snr_image = &(mzte_codec.SPlayer[col].SNRlayer.snr_image);
          Get_MaxBitplane(snr_image, (col==0?spa_lev:spa_lev-1), col);
	  }
	  for (col=0; col<mzte_codec.colors; col++) {
		  mzte_codec.curColor = col;
	      noteProgress("Single-Quant Mode (Band by Band) - Spatial %d, SNR 0, "\
	                "Color %d",spa_lev,col); fflush(stderr);
		  wavelet_higher_bands_decode_SQ_band(col);
	  }
	}
*/

  /* hjlee 0901 */
  /* hjlee 0827 */
    for (col=0; col<mzte_codec.colors; col++) {
      snr_image = &(mzte_codec.SPlayer[col].SNRlayer.snr_image);
      Get_Quant_and_Max_SQBB(snr_image,spa_lev, col);
    }
 
  for (col=0; col<mzte_codec.colors; col++){
    noteProgress("Single-Quant Mode (Band by Band) - Spatial %d, SNR 0, "\
	       "Color %d",spa_lev,col); fflush(stderr);

    mzte_codec.curColor = col;
    if(spa_lev !=0 || col == 0){
      wavelet_higher_bands_decode_SQ_band(col);
      if(decIQuantizeAC_spa(spa_lev,col)) 
	errorHandler("decIQuantizeAC_spa");
    }
  }
  
} 



static Void TextureSpatialLayerSQ_dec(Int spa_lev,File *bitfile)
{
  Int texture_spatial_layer_start_code,texture_spatial_layer_id;

  /*------- AC: Open and initialize bitstream file -------*/
  if (singleBitFile==0)
  {
    sprintf(fname,bitFileAC,spa_lev,0);
    if ((bitfile=fopen(fname,"rb"))==NULL)
      errorHandler("Can't open file '%s' for reading.",fname);
    init_bit_packing_fp(bitfile,1);
  }
  else
    init_bit_packing_fp(bitfile,0);

  /* header info */
  texture_spatial_layer_start_code = get_X_bits(32);
  if (texture_spatial_layer_start_code != 
      TEXTURE_SPATIAL_LAYER_START_CODE)
    errorHandler("Wrong texture_spatial_layer_start_code %x.",
		 texture_spatial_layer_start_code);
  
  texture_spatial_layer_id = get_X_bits(5);
  if (texture_spatial_layer_id != spa_lev)
    errorHandler("Incorrect texture_spatial_layer_id");
  mzte_codec.SPlayer[0].SNR_scalability_levels = 1;



  TextureSpatialLayerSQNSC_dec(spa_lev);

  align_byte();
  if(singleBitFile==0)
    fclose(bitfile);
}




static Void textureLayerSQ_Dec(File *bitfile)
{
  Int col, err, spa_lev;
  SNR_IMAGE *snr_image;

  noteProgress("Decoding AC coefficients - Single-Quant Mode....");

  /* added for compatability with MQ spatial layer flexability - ph 7/16 */
  setSpatialLayerDimsSQ(0);

  
  /*------- AC: Set spatial and SNR levels to zero -------*/
  mzte_codec.curSpatialLev = 0;
  mzte_codec.curSNRLev = 0;
  
  for (col=0; col<mzte_codec.colors; col++) 
  {     
    
    /* initialization of spatial dimensions for each color component */
    setSpatialLevelAndDimensions(0, col);
    
    /* initialize AC coefficient info */
    if ((err=ztqInitAC(1, col)))
      errorHandler("ztqInitAC");
    
    snr_image=&(mzte_codec.SPlayer[col].SNRlayer.snr_image);
  }
  
  
  /*------- AC: Decode and inverse quantize all color components -------*/
  if (mzte_codec.scan_direction==0) /* tree-depth scan */
  {  
    /* Read quant value from bitstream */
    for(col=0;col<mzte_codec.colors;col++){
      snr_image=&(mzte_codec.SPlayer[col].SNRlayer.snr_image);
      Get_Quant_and_Max(snr_image,0,col);
    }

    /* losslessly decoding AC coefficients */
    wavelet_higher_bands_decode_SQ_tree();
    
    for (col=0; col<mzte_codec.colors; col++) 
    {  	
      /* Inverse quantize AC coefficients */
      if ((err=decIQuantizeAC(col)))
	errorHandler("decIQuantizeAC");
    }
    
  }
  else  /* SQ band by band */
  {
    /* hjlee 0827 */
    /* Read quant value from bitstream */
    /*
    for(col=0;col<mzte_codec.colors;col++){
      snr_image=&(mzte_codec.SPlayer[col].SNRlayer.snr_image);
      Get_Quant_and_Max_SQBB(snr_image,0,col);
    }
    */

    /* hjlee 0827 */
    /*
    if (snrStartCode) {
      align_byte();
      if(!singleBitFile)
	fclose(bitfile);
    }
    */

    /* added for compatability with MQ spatial layer flexability - ph 7/16 */
    setSpatialLayerDimsSQ(1);

    /* Assumes all three color components have the same number of SNR
       levels */
    for (col=0; col<mzte_codec.colors; col++)
      mzte_codec.SPlayer[col].SNR_scalability_levels = 1;

    /* Loop through spatial layers */
/* SAIT_V2 begin : modified by Samsung AIT (99/02/23) */
    /* for (spa_lev=0; spa_lev<mzte_codec.spatial_scalability_levels; 
         spa_lev++)*/
    for (spa_lev=0; spa_lev<mzte_codec.target_spatial_levels; spa_lev++)
/* SAIT_V2 end */
    {

	  /* hjlee 0901 */
	  /*
      if (spa_lev)
      {
  	     for(col=0;col<mzte_codec.colors; col++)
		 {
	       snr_image=&(mzte_codec.SPlayer[col].SNRlayer.snr_image);
	       Get_Quant_and_Max_SQBB(snr_image,spa_lev,col);
		 }
      }
	  */

      for (col=0; col<mzte_codec.colors; col++)
	     setSpatialLevelAndDimensions(spa_lev, col);

      /*----- AC: Set global spatial layer. -----*/
      mzte_codec.curSpatialLev = spa_lev;
      
      /* Update spatial level coeff info if changing spatial levels.
         Do this for all color components */
      if (snrStartCode) {
	     TextureSpatialLayerSQ_dec(spa_lev,bitfile);
      }
      else
	     TextureSpatialLayerSQNSC_dec(spa_lev);
    }
  }
  
  noteProgress("Completed decoding AC coefficients - Single-Quant Mode.");
}


static Void TextureSNRLayerMQ_decode(Int spa_lev, Int snr_lev,File *fp)
{
  SNR_IMAGE *snr_image;
  Int col;
  Int texture_snr_layer_id;

  mzte_codec.curSpatialLev=spa_lev;

  if(snrStartCode){
    noteProgress("Decoding Multi-Quant Mode Layer with SNR start code....");
    /* header info */
    if(get_X_bits(32) != texture_snr_layer_start_code)
      errorHandler("Error in decoding texture_snr_layer_start_code");
    texture_snr_layer_id=get_X_bits(5);
  }
  else 
    noteProgress("Decoding Multi-Quant Mode Layer without SNR start code....");

  noteProgress("Multi-Quant Mode - Spatial %d, SNR %d", spa_lev,snr_lev);

  for(col=0;
      col < NCOL;
      col++)
  {        
    /* Set global color variable */
    mzte_codec.curColor = col;
    
    /* initialization of spatial dimensions for each color component  */
    setSpatialLevelAndDimensions(mzte_codec.curSpatialLev, col);
    
    snr_image=&(mzte_codec.SPlayer[col].SNRlayer.snr_image);

    Get_Quant_and_Max(snr_image,spa_lev,col);

    updateResidMaxAndAssignSkips(col);
    noteDebug("resid_max=%d\n",snr_image->residual_max);
  }

  wavelet_higher_bands_decode_MQ(mzte_codec.scan_direction);
 
  for(col=0;
      col < NCOL;      
      col++)
  {        
    /* Set global color variable */
    mzte_codec.curColor = col;

    /* quantize and mark zerotree structure for AC coefficients */
    if (decIQuantizeAC(col))
      errorHandler("decQuantizeAndMarkAC");

    noteDebug("max_root=%d max_valz=%d max_valnz=%d max_resi=%d",
	      ROOT_MAX(col),VALZ_MAX(col),VALNZ_MAX(col),
	      RESID_MAX(col));
    
    /* Update states of ac coefficients */
    if (decUpdateStateAC(col))
      errorHandler("decUpdateStateAC");
  }
}

#define SNR_INFINITY 99

static Void textureLayerMQ_Dec(File *bitfile, 
			       Int  target_spatial_levels,
			       Int  target_snr_levels,
			       FILTER **wvtfilter)
{
  Int  err, spa_lev, snr_lev, snr_scalability_levels;
  Int  texture_spatial_layer_start_code;
  Int  texture_spatial_layer_id;

  /* removed - ph 7/16
  mzte_codec.spatial_scalability_levels = get_X_bits(5); */

  /* hjlee 0827 */
  /*
  if (snrStartCode)
    align_byte();
    */


  /* added for spatial layer flexability - ph 7/16 */
  getSpatialLayerDims();

  /*------- AC: Initialize QList Structure -------*/
  if ((err=ztqQListInit()))
    errorHandler("Allocating memory for QList information.");
 
  /* Initialize coeffs */
  setSpatialLevelAndDimensions(0,0);
  if ((err=ztqInitAC(1,0)))
    errorHandler("ztqInitAC");
  
  if (mzte_codec.lastWvtDecompInSpaLayer[0][1]<0)
    setSpatialLevelAndDimensions(1,1);
  else
    setSpatialLevelAndDimensions(0,1);
  if ((err=ztqInitAC(1,1)))
    errorHandler("ztqInitAC");
  
  if (mzte_codec.lastWvtDecompInSpaLayer[0][2]<0)
    setSpatialLevelAndDimensions(1,2);
  else
    setSpatialLevelAndDimensions(0,2);
  if ((err=ztqInitAC(1,2)))
    errorHandler("ztqInitAC");

  /* Loop through spatial layers */
  target_spatial_levels=MIN(mzte_codec.spatial_scalability_levels,
			    target_spatial_levels);
  for (spa_lev=0; spa_lev<target_spatial_levels; spa_lev++)
  {
    /*----- AC: Set global spatial layer and SNR scalability level. -----*/
    /* Assumes all three color components have the same number of SNR 
       levels */
    mzte_codec.curSpatialLev = spa_lev;
    mzte_codec.SPlayer[0].SNR_scalability_levels = SNR_INFINITY;
    snr_scalability_levels = mzte_codec.SPlayer[0].SNR_scalability_levels;

    /* Update spatial level coeff info if changing spatial levels.
       Do this for all color components. */
    if (spa_lev != 0)
    {
      for (mzte_codec.curColor = 0; mzte_codec.curColor<mzte_codec.colors;
	   mzte_codec.curColor++) 
      {
	setSpatialLevelAndDimensions(mzte_codec.curSpatialLev, 
				     mzte_codec.curColor);
	if (mzte_codec.lastWvtDecompInSpaLayer[spa_lev-1][mzte_codec.curColor]
	    >=0)
	  spatialLayerChangeUpdate(mzte_codec.curColor);
      }
    }
           
    if (!snrStartCode)
    {
      snr_scalability_levels = get_X_bits(5);  
      mzte_codec.SPlayer[0].SNR_scalability_levels = snr_scalability_levels;
    }

    /* Loop through SNR layers */      
    for (snr_lev=0; snr_lev<snr_scalability_levels; snr_lev++) 
    {
      if (spa_lev==target_spatial_levels-1 && snr_lev==target_snr_levels)
	break;

      /*----- AC: Set global SNR layer -----*/
      mzte_codec.curSNRLev = snr_lev;
             
      if (snrStartCode)
      {
	/*------- AC: Open and initialize bitstream file -------*/
	if (singleBitFile==0)
	{
	  sprintf(fname,bitFileAC,
		  mzte_codec.curSpatialLev,mzte_codec.curSNRLev);
	  if ((bitfile=fopen(fname,"rb"))==NULL)
	    errorHandler("Can't open file '%s' for reading.",fname);
	  
	  /* initialize the buffer */
	  init_bit_packing_fp(bitfile,1);
	}
	else
	  init_bit_packing_fp(bitfile,0);
       	
	if (snr_lev==0) {
	  /*------- AC: Read header info to bitstream file -------*/
	  texture_spatial_layer_start_code = get_X_bits(32);
	  if (texture_spatial_layer_start_code != 
	      TEXTURE_SPATIAL_LAYER_START_CODE)
	    errorHandler("Wrong texture_spatial_layer_start_code3 %x.",
			 texture_spatial_layer_start_code);
	  
	  texture_spatial_layer_id = get_X_bits(5);
	  if(texture_spatial_layer_id !=spa_lev)
	    errorHandler("Incorrect texture_spatial_layer_id");
	  snr_scalability_levels = get_X_bits(5);  
	  mzte_codec.SPlayer[0].SNR_scalability_levels = 
	    snr_scalability_levels;
	  align_byte();  /* byte alignment before start code */
	}	
	
      }
      
      /*------- AC: Decode and inverse quantize all color components ------*/
      TextureSNRLayerMQ_decode(spa_lev, snr_lev, bitfile);   
      if (snrStartCode){
	align_byte();  /* byte alignment before start code */
	if (singleBitFile==0)
	  fclose(bitfile);
      }
      

      
    } /* snr_lev */
    
  }  /* spa_lev */
 
  /*------- AC: Free Qlist structure -------*/
  ztqQListExit();
}

#ifdef _MBQ_
#include "MBQDec.c"
#endif

Void TextureObjectLayer_dec_V1(SOL_PARAMETERS_DEC *vm_param_dec,
                               Int  target_spatial_levels,
                               Int  target_snr_levels, FILTER ***pwvtfilter)
{
  File *bitfile;
  Int  x,y,w,h,k;
  FILTER **wvtfilter;
  UChar *inmask[3], *outmask[3];
  Int nLevels[3], ret;
  Int Width[3], Height[3];
  Int Nx[3], Ny[3];
  Int usemask;
  Int useInt=1;
  PICTURE *Image;
  Int col;


  /*-------------------------------------------------*/
  /*--------- DC (and overall header info) ----------*/
  /*-------------------------------------------------*/

  /*------- DC: Open and initialize bitstream file -------*/
  if ((bitfile=fopen(bitFile,"rb"))==NULL)
    errorHandler("Can't open file '%s' for reading.",bitFile);

  /* initialize variables */
  init_bit_packing_fp(bitfile,1);

  /*------- DC: Read header info from bitstream file -------*/
  header_Dec_V1(vm_param_dec, pwvtfilter, &Image);
  wvtfilter = *pwvtfilter;
  /*--------------- CREATE DATA STRUCTURES -----------------*/
  noteDetail("Creating and initializing data structures....");
  mzte_codec.colors=3;  /* hard code */

  /* ph 980831 - moved from VTC_Decode - needs header info from bitstream */
  init_acm_maxf_dec();

  for (col=0; col<mzte_codec.colors; col++) {

    h = mzte_codec.height >> (col>0);
    w  = mzte_codec.width  >> (col>0);

   /*--------- create coeffinfo structure ----------*/
    if ((mzte_codec.SPlayer[col].coeffinfo = 
	 (COEFFINFO **)calloc(h, sizeof(COEFFINFO *))) == NULL)
       errorHandler("Allocating memory for coefficient structure (I).");

    if ((mzte_codec.SPlayer[col].coeffinfo[0] = 
	 (COEFFINFO *)calloc(h*w, sizeof(COEFFINFO))) == NULL)
      errorHandler("Allocating memory for coefficient structure (II).");
   
    for (y = 1; y < h; ++y)
      mzte_codec.SPlayer[col].coeffinfo[y] = 
	mzte_codec.SPlayer[col].coeffinfo[y-1]+w;
  }
  noteDetail("Completed creating and initializing data structures.");

  mzte_codec.dcHeight  = mzte_codec.height >> mzte_codec.wvtDecompLev;
  mzte_codec.dcWidth   = mzte_codec.width >> mzte_codec.wvtDecompLev;

  mzte_codec.colors = vm_param_dec->colors;
  /* mzte_codec.colors = 3;  comment for JPEG2000 */
  mzte_codec.bit_depth = 8;  

  usemask = mzte_codec.sa_dwt;
  useInt =1;
  /* copy over the inmask[0] */

  Width[0] = mzte_codec.width;
  Width[1] = Width[2] = (Width[0] >> 1);
  Height[0] = mzte_codec.height;
  Height[1] = Height[2] = (Height[0] >> 1);
  nLevels[0] = mzte_codec.wvtDecompLev ;
  nLevels[1] = nLevels[2] = nLevels[0]-1;
  
  Nx[0] = Ny[0]=2;
  for(col=1;col<3;col++) Nx[col]=Ny[col]=1;
  
  if (decoder==1) /* new */
     mzte_codec.Image = Image;

  for (col=0; col<mzte_codec.colors; col++) {
    mzte_codec.Image[col].height = mzte_codec.height >> (col>0);
    mzte_codec.Image[col].width  = mzte_codec.width >> (col>0);

    inmask[col] = mzte_codec.Image[col].mask; 
    outmask[col] = (UChar *)malloc(sizeof(UChar)*
					   Width[col]*Height[col]);
    ret = do_DWTMask(inmask[col], outmask[col], 
		     Width[col], Height[col], 
		     nLevels[col], &(wvtfilter[col==0?0:1])); 
    if (ret!= DWT_OK) 
      errorHandler("DWT Error Code %d\n", ret);
    
    for (k=0,y=0; y<Height[col]; y++)
      for (x=0; x<Width[col]; x++) 
	COEFF_MASK(x,y,col) = outmask[col][k++];
    free(outmask[col]);
    
  }

  /* Bi-level mode - PEZW */
  PEZW_target_spatial_levels = target_spatial_levels;
  PEZW_target_bitrate  =       vm_param_dec->target_bitrate;
  PEZW_target_snr_levels  =    target_snr_levels;

  if (target_spatial_levels<=0 || target_snr_levels<= 0)
    errorHandler("Neither target_spatial_levels nor target_snr_levels" \
		 "can be zero");


  /*------- DC: Decode and inverse quantize all color components -------*/
  textureLayerDC_Dec();


  /*------- DC: Close bitstream file -------*/
  /* hjlee 0827 */ 
  if (snrStartCode){
    align_byte();
    if(!singleBitFile)
      fclose(bitfile);
  }
  

  /*-------------------------------------------------*/
  /*--------------------- AC ------------------------*/
  /*-------------------------------------------------*/

  
  /*------- AC: SINGLE-QUANT MODE -------*/
  if (mzte_codec.quantization_type == SINGLE_Q) 
    textureLayerSQ_Dec(bitfile);
  /*------- AC: MULTI-QUANT MODE -------*/
  else if (mzte_codec.quantization_type == MULTIPLE_Q)
    textureLayerMQ_Dec(bitfile, target_spatial_levels, target_snr_levels,
		       wvtfilter);
  /*------- AC: BILEVEL-QUANT MODE -------*/
  else if (mzte_codec.quantization_type == BILEVEL_Q)
    textureLayerBQ_Dec(bitfile);
#ifdef _MBQ_
  else if (mzte_codec.quantization_type == MULTBUF_Q)
    textureLayerMBQ_Dec(bitfile, target_spatial_levels, target_snr_levels,
			wvtfilter);
#endif

  for(col=0; col< mzte_codec.colors; col++)
    free(Image[col].mask);
  free(Image);

  if (singleBitFile==0){
    if(!snrStartCode)
      align_byte();
    fclose(bitfile);
  }
} 

static Void TextureObjectLayer_dec(SOL_PARAMETERS_DEC *vm_param_dec,
				   Int  target_spatial_levels,
				   Int  target_snr_levels, FILTER ***pwvtfilter,
  Int iTile, Int count, FILE *bitfile, Int **table )  /* modified by Sharp (99/2/16) */ /* FPDAM : modified by SAIT (99/09/03)*/
{
/*  File *bitfile; deleted by Sharp (99/2/16)*/
  Int  x,y,w,h,k;
  FILTER **wvtfilter;
  UChar *inmask[3], *outmask[3];
  Int nLevels[3], ret;
  Int Width[3], Height[3];
  Int Nx[3], Ny[3];
  Int usemask;
  Int useInt=1;
  Int col;


/* FPDAM begin: added by SAIT (99/09/03)*/
	if(!mzte_codec.sa_dwt || mzte_codec.tiling_disable==1 || mzte_codec.texture_tile_type!=TRANSP_TILE) {
/* FPDAM end: added by SAIT (99/09/03)*/
  /*-------------------------------------------------*/
  /*--------- DC (and overall header info) ----------*/
  /*-------------------------------------------------*/

  /*------- DC: Open and initialize bitstream file -------*/
/*begin: added by Sharp (99/2/16)*/
#if 0
  if ( mzte_codec.tiling_disable == 0 ) /* added by Sharp (99/4/7) */
		tile_header_Dec();
#endif

/* This part is moved to the header_Dec_common() by Sharp (99/4/7) */
#if 0
  if(mzte_codec.sa_dwt)
  noteProgress("Decoding Shape Information...");
  Image = (PICTURE *)malloc(sizeof(PICTURE)*3);

/* SAIT_V2 begin : added by Samsung AIT (99/02/23)*/
  vm_param_dec->target_spatial_levels 
    = MIN(mzte_codec.spatial_scalability_levels, vm_param_dec->target_spatial_levels);
  vm_param_dec->target_shape_levels 
    = MIN(mzte_codec.spatial_scalability_levels, vm_param_dec->target_shape_levels);

  if(mzte_codec.quantization_type == 2) {
    target_spatial_layer = mzte_codec.wvtDecompLev -1-
      mzte_codec.lastWvtDecompInSpaLayer[vm_param_dec->target_spatial_levels-1][0];
    target_shape_layer = mzte_codec.wvtDecompLev -1-
      mzte_codec.lastWvtDecompInSpaLayer[vm_param_dec->target_shape_levels-1][0];
  }
  else {
    target_spatial_layer 
      = mzte_codec.spatial_scalability_levels - vm_param_dec->target_spatial_levels;
    target_shape_layer 
      = mzte_codec.spatial_scalability_levels - vm_param_dec->target_shape_levels;
  }
/* SAIT_V2 end */

  get_virtual_mask(Image, mzte_codec.wvtDecompLev,
    mzte_codec.width, mzte_codec.height,
    mzte_codec.sa_dwt, vm_param_dec->colors, 
	&target_shape_layer,			/* SAIT_V2: added by Samsung AIT (99/02/23) */
	mzte_codec.SNR_start_code_enable,	/* SAIT_V2: added by Samsung AIT (99/02/23) */
    *pwvtfilter);

/* SAIT_V2 begin: added by Samsung AIT (99/02/23) */
  if(target_shape_layer > target_spatial_layer) {
    noteWarning("Shape has less spatial layers than target,\n forced to  use shape spatial layers.\n");
    if(mzte_codec.quantization_type == 2) {
      for(i=0;i< mzte_codec.spatial_scalability_levels;i++) {
        if( mzte_codec.lastWvtDecompInSpaLayer[i][0] > mzte_codec.wvtDecompLev -1 - target_shape_layer){
          mzte_codec.target_spatial_levels 
		= vm_param_dec->target_spatial_levels = i;
          mzte_codec.lastWvtDecompInSpaLayer[i][0] 
		= mzte_codec.wvtDecompLev -1 - target_shape_layer;
          break;
        }
      }
    }
    else
      mzte_codec.target_spatial_levels 
		= vm_param_dec->target_spatial_levels 
		= mzte_codec.spatial_scalability_levels - target_shape_layer;
  }
/* SAIT_V2 end */
#endif

/*end: added by Sharp (99/2/16)*/
#if 0
  if ((bitfile=fopen(bitFile,"rb"))==NULL)
    errorHandler("Can't open file '%s' for reading.",bitFile);

  /* initialize variables */
  init_bit_packing_fp(bitfile,1);

  /*------- DC: Read header info from bitstream file -------*/
  header_Dec(vm_param_dec, pwvtfilter, &Image);
#endif
  wvtfilter = *pwvtfilter;
  /*--------------- CREATE DATA STRUCTURES -----------------*/
  noteDetail("Creating and initializing data structures....");
  mzte_codec.colors=3;  /* hard code */

  /* ph 980831 - moved from VTC_Decode - needs header info from bitstream */
  init_acm_maxf_dec();

/*	if ( iTile == 0 ) {*/ /* added by Sharp (99/2/16) *//* FPDAM : deleted by SAIT (99/09/03) */
	if ( count == 0 ) { /* FPDAM : added by SAIT (99/09/03) */
  for (col=0; col<mzte_codec.colors; col++) {

    h = mzte_codec.height >> (col>0);
    w  = mzte_codec.width  >> (col>0);

   /*--------- create coeffinfo structure ----------*/
    if ((mzte_codec.SPlayer[col].coeffinfo = 
	 (COEFFINFO **)calloc(h, sizeof(COEFFINFO *))) == NULL)
       errorHandler("Allocating memory for coefficient structure (I).");

    if ((mzte_codec.SPlayer[col].coeffinfo[0] = 
	 (COEFFINFO *)calloc(h*w, sizeof(COEFFINFO))) == NULL)
      errorHandler("Allocating memory for coefficient structure (II).");
   
    for (y = 1; y < h; ++y)
      mzte_codec.SPlayer[col].coeffinfo[y] = 
	mzte_codec.SPlayer[col].coeffinfo[y-1]+w;
  }
  noteDetail("Completed creating and initializing data structures.");
	} /* added by Sharp (99/2/16) */

  mzte_codec.dcHeight  = mzte_codec.height >> mzte_codec.wvtDecompLev;
  mzte_codec.dcWidth   = mzte_codec.width >> mzte_codec.wvtDecompLev;

  mzte_codec.colors = vm_param_dec->colors;
  /* mzte_codec.colors = 3;  comment for JPEG2000 */
  mzte_codec.bit_depth = 8;  

  usemask = mzte_codec.sa_dwt;
  useInt =1;
  /* copy over the inmask[0] */

  Width[0] = mzte_codec.width;
  Width[1] = Width[2] = (Width[0] >> 1);
  Height[0] = mzte_codec.height;
  Height[1] = Height[2] = (Height[0] >> 1);
  nLevels[0] = mzte_codec.wvtDecompLev ;
  nLevels[1] = nLevels[2] = nLevels[0]-1;
  
  Nx[0] = Ny[0]=2;
  for(col=1;col<3;col++) Nx[col]=Ny[col]=1;
  
/*This part is moved to the header_Dec_Common()*/
#if 0
  if (decoder==1) /* new */
     mzte_codec.Image = Image;
#endif

  for (col=0; col<mzte_codec.colors; col++) {
    mzte_codec.Image[col].height = mzte_codec.height >> (col>0);
    mzte_codec.Image[col].width  = mzte_codec.width >> (col>0);

    inmask[col] = mzte_codec.Image[col].mask; 
    outmask[col] = (UChar *)malloc(sizeof(UChar)*
					   Width[col]*Height[col]);
    ret = do_DWTMask(inmask[col], outmask[col], 
		     Width[col], Height[col], 
		     nLevels[col], &(wvtfilter[col==0?0:1])); 
    if (ret!= DWT_OK) 
      errorHandler("DWT Error Code %d\n", ret);
    
    for (k=0,y=0; y<Height[col]; y++)
      for (x=0; x<Width[col]; x++) 
	COEFF_MASK(x,y,col) = outmask[col][k++];
    free(outmask[col]);
    
  }

/* SAIT_V2 begin: added by Samsung AIT (99/02/23) */
  /* override using the value from header decode ( shape decode) */
  target_spatial_levels = mzte_codec.target_spatial_levels;
/* SAIT_V2 end */

  /* Bi-level mode - PEZW */
  PEZW_target_spatial_levels = target_spatial_levels;
  PEZW_target_bitrate  =       vm_param_dec->target_bitrate;
  PEZW_target_snr_levels  =    target_snr_levels;

  if (target_spatial_levels<=0 || target_snr_levels<= 0)
    errorHandler("Neither target_spatial_levels nor target_snr_levels" \
		 "can be zero");

/* begin: added by Rockwell (99/3/3) */
  /* IM: VTC error res */ 
  /* reset packet_size */
  packet_size = 0;
/* end: added by Rockwell (99/3/3) */

  /*------- DC: Decode and inverse quantize all color components -------*/
  textureLayerDC_Dec();


  /*------- DC: Close bitstream file -------*/
  /* hjlee 0827 */ 
  if (snrStartCode){
    align_byte();
    if(!singleBitFile)
      fclose(bitfile);
  }
  

  /*-------------------------------------------------*/
  /*--------------------- AC ------------------------*/
  /*-------------------------------------------------*/

/* begin: added by Rockwell (99/3/3) */
/* IM: VTC error res */ 
  error_bits_stat(0); /* register the DC part as no error, bbc, 11/5/98 */
/* end: added by Rockwell (99/3/3) */
  
  /*------- AC: SINGLE-QUANT MODE -------*/
  if (mzte_codec.quantization_type == SINGLE_Q) 
    textureLayerSQ_Dec(bitfile);
  /*------- AC: MULTI-QUANT MODE -------*/
  else if (mzte_codec.quantization_type == MULTIPLE_Q)
    textureLayerMQ_Dec(bitfile, target_spatial_levels, target_snr_levels,
		       wvtfilter);
  /*------- AC: BILEVEL-QUANT MODE -------*/
  else if (mzte_codec.quantization_type == BILEVEL_Q)
    textureLayerBQ_Dec(bitfile);
#ifdef _MBQ_
  else if (mzte_codec.quantization_type == MULTBUF_Q)
    textureLayerMBQ_Dec(bitfile, target_spatial_levels, target_snr_levels,
			wvtfilter);
#endif

#if 0
  for(col=0; col< mzte_codec.colors; col++)
    free(Image[col].mask);
  free(Image);
#endif
/* FPDAM begin: added by SAIT (99/09/03) */
	} else {

/*	if ( iTile == 0 ) {*/ /* added by Sharp (99/2/16) *//* FPDAM: deleted by SAIT (99/09/03) */
	if ( count == 0 ) { /* FPDAM: added by SAIT (99/09/03) */
  for (col=0; col<mzte_codec.colors; col++) {

    h = mzte_codec.height >> (col>0);
    w  = mzte_codec.width  >> (col>0);

   /*--------- create coeffinfo structure ----------*/
    if ((mzte_codec.SPlayer[col].coeffinfo = 
	 (COEFFINFO **)calloc(h, sizeof(COEFFINFO *))) == NULL)
       errorHandler("Allocating memory for coefficient structure (I).");

    if ((mzte_codec.SPlayer[col].coeffinfo[0] = 
	 (COEFFINFO *)calloc(h*w, sizeof(COEFFINFO))) == NULL)
      errorHandler("Allocating memory for coefficient structure (II).");
   
    for (y = 1; y < h; ++y)
      mzte_codec.SPlayer[col].coeffinfo[y] = 
	mzte_codec.SPlayer[col].coeffinfo[y-1]+w;
  }
  noteDetail("Completed creating and initializing data structures.");
	} /* added by Sharp (99/2/16) */

  if (snrStartCode){
    align_byte();
    if(!singleBitFile)
      fclose(bitfile);
  }
	}
/* FPDAM end: added by SAIT (99/09/03) */

/* SAIT_V2 begin: modified by Samsung AIT (99/02/23) */
  /*if (singleBitFile==0){*/
/*  if (singleBitFile==1){ Modified by Sharp (99/4/1) */
  if (singleBitFile==0){
/* SAIT_V2 end */
    if(!snrStartCode)
      align_byte();
    fclose(bitfile);
  }
} 

/* static Void VTC_Decode() */ /* new */
Void VTC_Decode(Char bitstream[],
           Char rec_filename[],
           Char shape_filename[],
           Int  shape_width,
           Int  shape_height,
           Int  target_bitrate, 
		Int     target_shape_level,     /* SAIT_V2: added by Samsung AIT (99/02/23) */
           Int  target_spatial_level, 
           Int  target_snr_level,
                Int  target_tile_id_from,
                Int  target_tile_id_to) /* modified by Sharp (99/2/16) */
{
  Int col,i;
  SOL_PARAMETERS_DEC *vm_param_dec;
  FILTER **wvtfilter;
/*begin: added by Sharp(99/2/16)*/
  Int iNumOfTile;
  Int target_iNum;
  FILE *bitfile;
/*  DATA *frm[3]; */ /* FPDAM: deleted by SAIT (99/09/03) */
	UChar *frm[3],*frm_mask[3]; /* FPDAM: added by SAIT (99/09/03) */
  Int ii;
  Int id_to;
  Int *table;
  Int *jump_table;
  Int *decode_tile_id;
  Int header_size;
/*end: added by Sharp(99/2/16)*/

/* begin: added by Sharp (99/5/10) */
	Int TileX, TileY;
	Int MinLevel;
/* end: added by Sharp (99/5/10) */

  decoder=1; /* new */
  decRecImgFile = rec_filename; /* new */
  recImgFile    = decRecImgFile; /* new */

  noteProgress("\n----- MPEG-4 Visual Texture Coding: Decoding -----\n");
	mzte_codec.visual_object_verid = BITSTREAM_VERSION; /* modified by Sharp (99/5/10) */
/* begin: added by Sharp (99/11/18) */
  if ( strstr(bitstream, "v1") != NULL || strstr(bitstream, "V1") != NULL )
    mzte_codec.visual_object_verid = 1;
  else
    mzte_codec.visual_object_verid = 2;
/* end: added by Sharp (99/11/18) */

	if ( mzte_codec.visual_object_verid != 1 ){ /* version 2 */
/* begin: added by Rockwell (99/3/3) */
/* IM: VTC error res */ 
  /* error resilience, bbc, 11/5/98 */
	errSignal=errWarnSignal=errMagSignal=0;
/* end: added by Rockwell (99/3/3) */

  /* Read in decoding parameters */
  /* noteProgress("Reading input parameters from '%s'....", parmFile); */
  if ((vm_param_dec = 
       (SOL_PARAMETERS_DEC *)malloc(sizeof(SOL_PARAMETERS_DEC)*1)) == NULL)
    errorHandler("Allocating memory for parameters.");

  /* read_control_file_dec(parmFile, vm_param_dec); */ /* new */
  /* noteProgress("Completed reading input parameters."); */  /* new */


#ifdef _CHECK_BITS_
  fpe=fopen("decode_bits","wb");
#endif

  printf("\ndecode bitstream file: %s\n",bitstream);

  vm_param_dec->bitFile               = bitstream;/* new */
  vm_param_dec->SegPath               = shape_filename;  /* new */
  vm_param_dec->width                 = shape_width;  /* new */
  vm_param_dec->height                = shape_height;  /* new */
  vm_param_dec->target_snr_levels     = target_snr_level;  /* new */
  vm_param_dec->target_spatial_levels = target_spatial_level;  /* new */
	vm_param_dec->target_shape_levels  = target_shape_level;        /* SAIT_V2: added by Samsung AIT (99/02/23) */
  vm_param_dec->target_bitrate        = target_bitrate;  /* new */


  mzte_codec.target_spatial_levels = vm_param_dec->target_spatial_levels;
  mzte_codec.target_snr_levels = vm_param_dec->target_snr_levels;
/*begin: added by Sharp (99/2/16)*/
  vm_param_dec->target_tile_id_from = target_tile_id_from;
  vm_param_dec->target_tile_id_to   = target_tile_id_to;
/*end: added by Sharp (99/2/16)*/

#ifdef _DECODER_
  mzte_codec.acm_order = vm_param_dec->acm_order;
  if((mzte_codec.acm_max_freq_chg = vm_param_dec->acm_max_freq_chg) != 0)
    mzte_codec.acm_maxf = vm_param_dec->acm_maxf;
#endif

  mzte_codec.colors=vm_param_dec->colors;
  mzte_codec.acm_order = vm_param_dec->acm_order = 0; /* new */
  mzte_codec.acm_order = vm_param_dec->acm_order = 0; /* new */
  vm_param_dec->acm_maxf=(Int *)malloc(6*sizeof(Int)); /* new */
  for(i=0;i<6;i++)
    vm_param_dec->acm_maxf[i] = 16383; /* new */
  mzte_codec.acm_maxf = vm_param_dec->acm_maxf; /* new */

  mzte_codec.colors=vm_param_dec->colors=3;

  /*  ph 980831 - put in TextureObjectLayer_dec function. Needs header info 
      init_acm_maxf_dec(); */
  
  singleBitFile = vm_param_dec->singleBitFile=1;
  bitFile = vm_param_dec->bitFile;
  bitFileAC = vm_param_dec->bitFileAC;

/*begin: added by Sharp (99/2/16)*/
  if ((bitfile=fopen(bitFile,"rb"))==NULL)
  errorHandler("Can't open file '%s' for reading.",bitFile);

  init_bit_packing_fp(bitfile,1);
  header_Dec(vm_param_dec, &wvtfilter, NULL, &header_size);
/* @@@@@@@@@ */
/* begin: deleted for FDAM1 by Samsung AIT (2000/01/10) */
	/* if (mzte_codec.error_res_flag)
		mzte_codec.segment_thresh=get_X_bits(16);*/
/* end: deleted for FDAM1 by Samsung AIT (2000/01/10) */
 	

  if ( mzte_codec.tiling_disable == 0){

/* begin: modified by Sharp (99/5/10) */
	if ( mzte_codec.iNumOfTile > vm_param_dec->target_tile_id_from )
		mzte_codec.target_tile_id_from = vm_param_dec->target_tile_id_from;
	else
		mzte_codec.target_tile_id_from = mzte_codec.iNumOfTile;
	if ( mzte_codec.iNumOfTile > vm_param_dec->target_tile_id_to )
		mzte_codec.target_tile_id_to = vm_param_dec->target_tile_id_to;
	else
/* FPDAM begin : modified by SAIT (99/09/03) */
/*		mzte_codec.target_tile_id_to = mzte_codec.iNumOfTile;*/	
		mzte_codec.target_tile_id_to = mzte_codec.iNumOfTile - 1;
/* FPDAM end : modified by SAIT (99/09/03) */
/*    mzte_codec.target_tile_id_from = vm_param_dec->target_tile_id_from;*/
/*    mzte_codec.target_tile_id_to = vm_param_dec->target_tile_id_to;*/
/* end: modified by Sharp (99/5/10) */

    target_iNum = mzte_codec.target_tile_id_to + 1 - mzte_codec.target_tile_id_from;
/* begin: added by Sharp (99/5/10) */
		if ( mzte_codec.iNumOfTile < target_iNum )
			iNumOfTile = mzte_codec.iNumOfTile;
		else
/* end: added by Sharp (99/5/10) */
    iNumOfTile = target_iNum;

  } else {
    iNumOfTile = 1;
  }

  if (mzte_codec.tiling_disable == 0) {
/*    Int TileX, TileY;*/ /* deleted by Sharp (99/5/10) */
    Int FromX, ToX, FromY, ToY;

/* begin: modified by Sharp (99/5/10) */
    table = (Int *)malloc(sizeof(Int)*mzte_codec.iNumOfTile+1);
    jump_table = (Int *)malloc(sizeof(Int)*mzte_codec.iNumOfTile+1);
    decode_tile_id = (Int *)malloc(sizeof(Int)*mzte_codec.iNumOfTile+1);
/* end: modified by Sharp (99/5/10) */
		if ( mzte_codec.tiling_jump_table_enable == 1 )
			tile_table_Dec(table);

/* begin: modified by Sharp (99/5/10) */
/* FPDAM begin: modified by SAIT (99/09/03) */
		/*
		TileX = mzte_codec.display_width / mzte_codec.tile_width + ((mzte_codec.display_width%mzte_codec.tile_width)?1:0);
		TileY = mzte_codec.display_height / mzte_codec.tile_height+((mzte_codec.display_height%mzte_codec.tile_height)?1:0);
		*/
	TileX = mzte_codec.object_width / mzte_codec.tile_width + ((mzte_codec.object_width%mzte_codec.tile_width)?1:0);
	TileY = mzte_codec.object_height / mzte_codec.tile_height+((mzte_codec.object_height%mzte_codec.tile_height)?1:0);
/* FPDAM end: modified by SAIT (99/09/03) */

/*    TileX = mzte_codec.display_width / mzte_codec.tile_width;*/
/*    TileY = mzte_codec.display_height / mzte_codec.tile_height;*/
/* end: modified by Sharp (99/5/10) */

    FromX = mzte_codec.target_tile_id_from % TileX;
    ToX = mzte_codec.target_tile_id_to % TileX;
    FromY = mzte_codec.target_tile_id_from / TileX;
    ToY = mzte_codec.target_tile_id_to / TileX;
    set_decode_tile_id_and_position(&iNumOfTile, &jump_table, &decode_tile_id, table, header_size);

/* begin: modified by Sharp (99/5/10) */
/* FPDAM begin : modified by SAIT (99/09/03) */
		/*
		if ( ToX == TileX-1 )
			mzte_codec.display_width -= FromX*mzte_codec.tile_width;
		else
			mzte_codec.display_width = (ToX-FromX+1)*mzte_codec.tile_width;
		if ( ToY == TileY-1 )
			mzte_codec.display_height -= FromY*mzte_codec.tile_height;
		else
			mzte_codec.display_height = (ToY-FromY+1)*mzte_codec.tile_height;
		*/
		if ( ToX == TileX-1 )
			mzte_codec.object_width -= FromX*mzte_codec.tile_width;
		else
			mzte_codec.object_width = (ToX-FromX+1)*mzte_codec.tile_width;
		if ( ToY == TileY-1 )
			mzte_codec.object_height -= FromY*mzte_codec.tile_height;
		else
			mzte_codec.object_height = (ToY-FromY+1)*mzte_codec.tile_height;
                
		mzte_codec.object_origin_x += FromX*mzte_codec.tile_width;
		mzte_codec.object_origin_y += FromY*mzte_codec.tile_height;
/* FPDAM end : modified by SAIT (99/09/03) */
		
		if(mzte_codec.quantization_type==2) {
			Int target_spatial_levels;
			target_spatial_levels=MIN(mzte_codec.spatial_scalability_levels,
														mzte_codec.target_spatial_levels);
			MinLevel =  mzte_codec.wvtDecompLev -1- 
	mzte_codec.lastWvtDecompInSpaLayer[target_spatial_levels-1][0];
		}
		else {
			MinLevel = mzte_codec.spatial_scalability_levels -
				mzte_codec.target_spatial_levels;
		}
		if(MinLevel <0) MinLevel=0;
/* FPDAM begin: modified by SAIT(99/09/03) */
		/* mzte_codec.display_width = mzte_codec.display_width>>MinLevel;
		mzte_codec.display_height = mzte_codec.display_height>>MinLevel;*/
                mzte_codec.object_width = mzte_codec.object_width>>MinLevel;
                mzte_codec.object_height = mzte_codec.object_height>>MinLevel;
/* FPDAM end: modified by SAIT(99/09/03) */
/*    mzte_codec.display_width = (ToX-FromX+1)*mzte_codec.tile_width;*/
/*    mzte_codec.display_height = (ToY-FromY+1)*mzte_codec.tile_height;*/
/* end: modified by Sharp (99/5/10) */

    /* allocate full frame buffer to store wvt coefficients */
/* begin: modified by Sharp (99/5/10) */
/* FPDAM begin : modified by SAIT (99/09/03) */
    /*
    frm[0]=(UChar *)malloc(sizeof(UChar)*mzte_codec.display_width*mzte_codec.display_height);
    frm[1]=(UChar *)malloc(sizeof(UChar)*(mzte_codec.display_width>>1)*(mzte_codec.display_height>>1));
    frm[2]=(UChar *)malloc(sizeof(UChar)*(mzte_codec.display_width>>1)*(mzte_codec.display_height>>1));
    */
    frm[0]=(UChar *)calloc(mzte_codec.object_width*mzte_codec.object_height,sizeof(UChar));
    frm[1]=(UChar *)calloc((mzte_codec.object_width>>1)*(mzte_codec.object_height>>1),sizeof(UChar));
    frm[2]=(UChar *)calloc((mzte_codec.object_width>>1)*(mzte_codec.object_height>>1),sizeof(UChar));
    frm_mask[0]=(UChar *)calloc(mzte_codec.object_width*mzte_codec.object_height,sizeof(UChar));
    frm_mask[1]=(UChar *)calloc((mzte_codec.object_width>>1)*(mzte_codec.object_height>>1),sizeof(UChar));
    frm_mask[2]=(UChar *)calloc((mzte_codec.object_width>>1)*(mzte_codec.object_height>>1),sizeof(UChar));
/* FPDAM end : modified by SAIT (99/09/03) */
/*    frm[0]=(DATA *)malloc(sizeof(DATA)*mzte_codec.display_width*mzte_codec.display_height);*/
/*    frm[1]=(DATA *)malloc(sizeof(DATA)*(mzte_codec.display_width>>1)*(mzte_codec.display_height>>1));*/
/*    frm[2]=(DATA *)malloc(sizeof(DATA)*(mzte_codec.display_width>>1)*(mzte_codec.display_height>>1));*/
/* end: modified by Sharp (99/5/10) */

/*    set_decode_tile_id_and_position(&iNumOfTile, &jump_table, &decode_tile_id, table, header_size);*/
    /* set last tile_id */
    if (mzte_codec.extension_type == 1) {
      id_to = mzte_codec.target_tile_id_to + (mzte_codec.display_width / mzte_codec.tile_width) + 1;
      if (id_to >= mzte_codec.iNumOfTile)
        id_to = mzte_codec.iNumOfTile -1;
    } else {
      id_to = mzte_codec.target_tile_id_to;
    }
  }
/*  if ( mzte_codec.tiling_disable == 0 ){ deleted by Sharp (99/4/7)*/
	for ( ii=0; ii<iNumOfTile; ii++ ){


/* begin: added by Sharp(99/4/7) */
		if ( mzte_codec.tiling_disable == 0 ){
			if ( mzte_codec.tiling_jump_table_enable == 1 ){
				noteProgress("%d bytes jump\n", jump_table[ii]);
				relative_jump(jump_table[ii]);
			}
			else
				search_tile(decode_tile_id[ii]);
/* FPDAM begin: modified by SAIT (99/09/03) */
			/*
			get_virtual_tile_mask(vm_param_dec, decode_tile_id[ii], TileX, TileY);
			tile_header_Dec();
			*/
			tile_header_Dec(vm_param_dec, wvtfilter, decode_tile_id[ii], ii, TileX, TileY);
/* FPDAM end: modified by SAIT (99/09/03) */
		}

		if ( mzte_codec.error_res_flag )
			texture_packet_header_Dec(vm_param_dec, &wvtfilter, NULL, &header_size); 
/* end: added by Sharp(99/4/7) */

/* begin : modified by Sharp (99/5/10) */
/*		TextureObjectLayer_dec(vm_param_dec, mzte_codec.target_spatial_levels,*/
/*				mzte_codec.target_snr_levels,&wvtfilter, ii, bitfile, &table);*/
/* FPDAM begin : modified by SAIT (99/09/03) */
/*		TextureObjectLayer_dec(vm_param_dec, mzte_codec.target_spatial_levels,
				mzte_codec.target_snr_levels,&wvtfilter, (mzte_codec.tiling_disable?ii:decode_tile_id[ii]), bitfile, &table); */
		TextureObjectLayer_dec(vm_param_dec, mzte_codec.target_spatial_levels,
				mzte_codec.target_snr_levels,&wvtfilter, (mzte_codec.tiling_disable?ii:decode_tile_id[ii]), ii, bitfile, &table);
/* FPDAM end : modified by SAIT (99/09/03) */
  /* DISCRETE INVERSE WAVELET TRANSFORM */

		noteProgress("\nInverse Wavelet Transform....");
/* FPDAM begin: modified by SAIT (99/09/03) */
		/*
		if ( mzte_codec.tiling_disable == 0 )
			perform_IDWT_Tile(vm_param_dec, wvtfilter, frm, decode_tile_id[ii], TileX);
		else
			perform_IDWT(vm_param_dec, wvtfilter, recImgFile );
		*/
		if ( mzte_codec.tiling_disable == 0 ) {
		    if(!mzte_codec.sa_dwt || mzte_codec.texture_tile_type!=TRANSP_TILE) 
			perform_IDWT_Tile(vm_param_dec, wvtfilter, frm, frm_mask, decode_tile_id[ii], TileX);
		} else {
			perform_IDWT(vm_param_dec, wvtfilter, recImgFile );
		}
/* FPDAM end: modified by SAIT (99/09/03) */
		noteProgress("Completed inverse wavelet transform.");
/* end : modified by Sharp (99/5/10) */
		
		if ( mzte_codec.tiling_disable == 0 ){
/*			copy_coeffs(ii, frm);*/ /* deleted by Sharp (99/5/10) */
/*      copy_coeffs(decode_tile_id[ii], frm);*/
			align_byte();
			clear_coeffinfo();
		}

/*      noteDetail("Freeing up decoding data structures....");*/
/*      for (col=0; col<mzte_codec.colors; col++) {*/
/*        free(mzte_codec.SPlayer[col].coeffinfo[0]);*/
/*        free(mzte_codec.SPlayer[col].coeffinfo);*/
/*      }*/
/*      noteDetail("Completed freeing up decoding data structures.");*/

		}

/* begin: added by Sharp (99/5/10) */
/* FPDAM begin: modified by SAIT (99/09/03) */
	if ( mzte_codec.tiling_disable == 0 )
/*		write_image_tile(recImgFile, frm);*/ 
        	write_image(recImgFile, mzte_codec.colors,
              		mzte_codec.object_width, mzte_codec.object_height,
              		mzte_codec.display_width, mzte_codec.display_height,
              		mzte_codec.object_origin_x, mzte_codec.object_origin_y,
              		frm, frm_mask,
              		mzte_codec.sa_dwt,
              		mzte_codec.STO_const_alpha,             /* SAIT_V2: added by Samsung AIT (99/02/23) */
              		mzte_codec.STO_const_alpha_value,       /* SAIT_V2: added by Samsung AIT (99/02/23) */
              		FULLSIZE, MinLevel);
/* FPDAM end: modified by SAIT (99/09/03) */
/* end: added by Sharp (99/5/10) */

/*begin: deleted by Sharp (99/4/7)	*/
#if 0
  } else {
		header_Dec_Common(vm_param_dec, &wvtfilter, NULL, &header_size, 0); /* @@@@@ */
    TextureObjectLayer_dec(vm_param_dec, mzte_codec.target_spatial_levels,
        mzte_codec.target_snr_levels,&wvtfilter, 0, bitfile, &table);
  }
#endif
/*begin: deleted by Sharp (99/4/7)	*/

/*end: added by Sharp (99/2/16)*/


/*begin: deleted by Sharp (99/2/16)*/
  /* singleBitFile = 1; */  /* hjlee 0827 */
/*
  TextureObjectLayer_dec(vm_param_dec, mzte_codec.target_spatial_levels,
			 mzte_codec.target_snr_levels,&wvtfilter); 
*/
/*end: deleted by Sharp (99/2/16)*/

#ifdef  _CHECK_BITS_
  fclose(fpe);
#endif

/*begin: deleted by Sharp (99/5/10)*/
  /* DISCRETE INVERSE WAVELET TRANSFORM */
/*begin: added by Sharp (99/2/16)*/
/*  noteProgress("\nInverse Wavelet Transform....");*/
/*  if (mzte_codec.tiling_disable == 0)*/
/*    perform_IDWT_Tile(vm_param_dec,wvtfilter,recImgFile,frm);*/
/*end: added by Sharp (99/2/16)*/
/*  else*/
/*		perform_IDWT(vm_param_dec, wvtfilter, recImgFile);*/
/*  noteProgress("Completed inverse wavelet transform.");*/
/*end: deleted by Sharp (99/5/10)*/
  
  noteDetail("Freeing up decoding data structures....");
  for (col=0; col<mzte_codec.colors; col++) {
    free(mzte_codec.SPlayer[col].coeffinfo[0]);
    free(mzte_codec.SPlayer[col].coeffinfo);
  }
  noteDetail("Completed freeing up decoding data structures.");

  noteProgress("\n----- Decoding Completed. -----\n");
  /* free downloaded filter(s) */
  if(vm_param_dec->wvtDownload==1) {
    if(vm_param_dec->wvtUniform) {
      free(wvtfilter[0]->LPCoeff);
      free(wvtfilter[0]->HPCoeff);
      free(wvtfilter[0]);
    }
    else {
      int i;
      for(i=0;i<vm_param_dec->wvtDecompLev;i++) {
	 free(wvtfilter[i]->LPCoeff);
	 free(wvtfilter[i]->HPCoeff);
	 free(wvtfilter[i]);
      }
    }
  }
  free(wvtfilter);
/* begin: added by Rockwell (99/3/3) */
  /* IM: hack to fix core dump */
  /* free_vm_param_dec(vm_param_dec); */
/* end: added by Rockwell (99/3/3) */
	}
	else { /* version 1 */

  /* Read in decoding parameters */
  /* noteProgress("Reading input parameters from '%s'....", parmFile); */
  if ((vm_param_dec = 
       (SOL_PARAMETERS_DEC *)malloc(sizeof(SOL_PARAMETERS_DEC)*1)) == NULL)
    errorHandler("Allocating memory for parameters.");

  /* read_control_file_dec(parmFile, vm_param_dec); */ /* new */
  /* noteProgress("Completed reading input parameters."); */  /* new */


#ifdef _CHECK_BITS_
  fpe=fopen("decode_bits","wb");
#endif

  printf("\ndecode bitstream file: %s\n",bitstream);

  vm_param_dec->bitFile               = bitstream;/* new */
  vm_param_dec->SegPath               = shape_filename;  /* new */
  vm_param_dec->width                 = shape_width;  /* new */
  vm_param_dec->height                = shape_height;  /* new */
  vm_param_dec->target_snr_levels     = target_snr_level;  /* new */
  vm_param_dec->target_spatial_levels = target_spatial_level;  /* new */
  vm_param_dec->target_bitrate        = target_bitrate;  /* new */


  mzte_codec.target_spatial_levels = vm_param_dec->target_spatial_levels;
  mzte_codec.target_snr_levels = vm_param_dec->target_snr_levels;

#ifdef _DECODER_
  mzte_codec.acm_order = vm_param_dec->acm_order;
  if((mzte_codec.acm_max_freq_chg = vm_param_dec->acm_max_freq_chg) != 0)
    mzte_codec.acm_maxf = vm_param_dec->acm_maxf;
#endif

  mzte_codec.colors=vm_param_dec->colors;
  mzte_codec.acm_order = vm_param_dec->acm_order = 0; /* new */
  mzte_codec.acm_order = vm_param_dec->acm_order = 0; /* new */
  vm_param_dec->acm_maxf=(Int *)malloc(6*sizeof(Int)); /* new */
  for(i=0;i<6;i++)
    vm_param_dec->acm_maxf[i] = 16383; /* new */
  mzte_codec.acm_maxf = vm_param_dec->acm_maxf; /* new */

  mzte_codec.colors=vm_param_dec->colors=3;



  /*  ph 980831 - put in TextureObjectLayer_dec function. Needs header info 
      init_acm_maxf_dec(); */
  
  singleBitFile = vm_param_dec->singleBitFile=1;
  bitFile = vm_param_dec->bitFile;
  bitFileAC = vm_param_dec->bitFileAC;

  /* singleBitFile = 1; */  /* hjlee 0827 */
  TextureObjectLayer_dec_V1(vm_param_dec, mzte_codec.target_spatial_levels,
			 mzte_codec.target_snr_levels,&wvtfilter); 

#ifdef  _CHECK_BITS_
  fclose(fpe);
#endif

  /* DISCRETE INVERSE WAVELET TRANSFORM */
  noteProgress("\nInverse Wavelet Transform....");
  perform_IDWT(vm_param_dec, wvtfilter, recImgFile);
  noteProgress("Completed inverse wavelet transform.");
  
  noteDetail("Freeing up decoding data structures....");
  for (col=0; col<mzte_codec.colors; col++) {
    free(mzte_codec.SPlayer[col].coeffinfo[0]);
    free(mzte_codec.SPlayer[col].coeffinfo);
  }
  noteDetail("Completed freeing up decoding data structures.");

  noteProgress("\n----- Decoding Completed. -----\n");
  /* free downloaded filter(s) */
  if(vm_param_dec->wvtDownload==1) {
    if(vm_param_dec->wvtUniform) {
      free(wvtfilter[0]->LPCoeff);
      free(wvtfilter[0]->HPCoeff);
      free(wvtfilter[0]);
    }
    else {
      int i;
      for(i=0;i<vm_param_dec->wvtDecompLev;i++) {
	 free(wvtfilter[i]->LPCoeff);
	 free(wvtfilter[i]->HPCoeff);
	 free(wvtfilter[i]);
      }
    }
  }
  free(wvtfilter);
  free_vm_param_dec(vm_param_dec);

	}
}

/*begin: added by Sharp (99/2/16)*/
static Void set_decode_tile_id_and_position(Int *iNumOfTile, Int **jump_table,
                                            Int **decode_tile_id, Int *table, Int header_size)
{
  Int *jt_pos;
  Int *ti_pos;
  Int FromX, ToX;
  Int TileX;
  Int FromY, ToY, TileY;
  Int i,ii;
  Int max_tile_id;
	Int k; /* added by Sharp (99/5/10) */

  jt_pos = *jump_table;
  ti_pos = *decode_tile_id;

  if ( mzte_codec.extension_type == 0 ){
/*begin: modified by Sharp (99/5/10)*/
/* FPDAM begin: modified by SAIT (99/09/03) */
		/*
		TileX = mzte_codec.display_width / mzte_codec.tile_width + ((mzte_codec.display_width%mzte_codec.tile_width)?1:0);
		TileY = mzte_codec.display_height / mzte_codec.tile_height+ ((mzte_codec.display_height%mzte_codec.tile_height)?1:0);
		*/
	TileX = mzte_codec.object_width / mzte_codec.tile_width + ((mzte_codec.object_width%mzte_codec.tile_width)?1:0);
	TileY = mzte_codec.object_height / mzte_codec.tile_height+ ((mzte_codec.object_height%mzte_codec.tile_height)?1:0);
/* FPDAM end: modified by SAIT (99/09/03) */
/*    TileX = mzte_codec.display_width / mzte_codec.tile_width;*/
/*    TileY = mzte_codec.display_height / mzte_codec.tile_height;*/
/*end: modified by Sharp (99/5/10)*/

    FromX = mzte_codec.target_tile_id_from % TileX;
    ToX = mzte_codec.target_tile_id_to % TileX;
    FromY = mzte_codec.target_tile_id_from / TileX;
    ToY = mzte_codec.target_tile_id_to / TileX;
#ifdef	_FPDAM_DBG_
fprintf(stderr,".........TileX=%d TileY=%d - FromX=%d ToX=%d FromY=%d ToY=%d\n",
	TileX,TileY,FromX,ToX,FromY,ToY);
#endif
  } else {
    TileX = mzte_codec.display_width / mzte_codec.tile_width;
    TileY = mzte_codec.display_height / mzte_codec.tile_height;

    FromX = mzte_codec.target_tile_id_from % TileX;
    if ( FromX > 0 ) FromX--;
    ToX = mzte_codec.target_tile_id_to % TileX;
    if ( ToX < TileX-1 ) ToX++;
    FromY = mzte_codec.target_tile_id_from / TileX;
    if ( FromY > 0 ) FromY--;
    ToY = mzte_codec.target_tile_id_to / TileX;
    if ( ToY < TileY-1 ) ToY++;
  }

  mzte_codec.target_tile_id_to = TileX * ToY + ToX;
  max_tile_id = mzte_codec.target_tile_id_to > mzte_codec.iNumOfTile ? mzte_codec.iNumOfTile : mzte_codec.target_tile_id_to;

/*begin: modified by Sharp (99/5/10)*/
  for ( i=0; i<max_tile_id+1; i++ ){
    jt_pos[i] = 0;
    /*    printf("table[%d] = %d\n", i, table[i]);*/
  }
	table[0] = ((header_size + mzte_codec.iNumOfTile * 34) + 8)/8;
/*        jt_pos[0] = ((header_size + mzte_codec.iNumOfTile * 34) + 8)/8;*/

  ii = 0;
  for ( i=0; i<max_tile_id+1; i++ ){
    if ( (i % TileX) >= FromX && (i % TileX) <= ToX && (i / TileX) >= FromY && (i / TileX) <= ToY ){
      ti_pos[ii] = i;
			for (k=0; k<=i; k++ )
				jt_pos[ii] += table[k];
      /*      printf("%d %d\n", ti_pos[ii], jt_pos[ii]);*/
      /*      printf("jump table[%d] = %d\n", i, jt_pos[ii]);*/
      ii++;
/*      jt_pos[ii] = jt_pos[ii-1];*/
    }
/*    jt_pos[ii] += table[i];*/
  }
/*end: modified by Sharp (99/5/10)*/
  *iNumOfTile = ii;
}

/* FPDAM begin: modified by SAIT (99/09/03) */
/*static Void tile_header_Dec()*/
static Void tile_header_Dec(SOL_PARAMETERS_DEC *vm_param_dec, FILTER **wvtfilter,Int iTile,Int count,Int TileX,Int TileY)
/* FPDAM end: modified by SAIT (99/09/03) */
{
  Int tile_id;
  Int ref_tile_id1;
  Int ref_tile_id2;
  Int still_tile_start_code;
/* FPDAM begin : added by SAIT (99/09/03) */
	Int i,col,h,w;
	Int target_spatial_layer, target_shape_layer;
	PICTURE *Image;
/* FPDAM end : added by SAIT (99/09/03) */

/*  if ( mzte_codec.tiling_disable == 0 ){*/
    still_tile_start_code = get_X_bits(32);
    if (still_tile_start_code != TEXTURE_TILE_START_CODE) {

            printf("code = %d\n", still_tile_start_code);

      errorHandler("Wrong texture_tile_start_code.");
        }

    tile_id = get_X_bits(16);
    printf("Current Tile ID is '%d'\n", tile_id);
    if ( mzte_codec.extension_type == 1 ){
      ref_tile_id1 = get_X_bits(16);
      ref_tile_id2 = get_X_bits(16);
    }
/*  }*/

/* FPDAM begin: added by SAIT (99/09/03) */
    if ( !mzte_codec.error_res_flag ) {
      if(mzte_codec.sa_dwt) {
        get_X_bits(1);
        mzte_codec.texture_tile_type = get_X_bits(2);
        get_X_bits(1);
#ifdef	_FPDAM_DBG_
fprintf(stderr,"..............texture_tile_type=%d\n",mzte_codec.texture_tile_type);
#endif
      }

      if(mzte_codec.sa_dwt)
	noteProgress("Decoding Tile Shape Information...");

      if ( count == 0 ) {
	if( decoder==1 ) { 
	   Image = (PICTURE *)malloc(sizeof(PICTURE)*mzte_codec.colors);

    	   mzte_codec.origin_x = 0;
	   mzte_codec.origin_y = 0;
    	   ExtendImageSize(mzte_codec.tile_width, mzte_codec.tile_height,
                  2, 2, &(mzte_codec.width), &(mzte_codec.height), mzte_codec.wvtDecompLev);

	   for (col=0; col<mzte_codec.colors; col++) {
    	     h = mzte_codec.height >> (col>0);
    	     w = mzte_codec.width  >> (col>0);
	     
	     if ((Image[col].data = (Void *) malloc(sizeof(UChar)*h*w)) == NULL)
    		errorHandler("Couldn't allocate memory to image data\n");
	     if ((Image[col].mask = (UChar *) malloc(sizeof(UChar)*h*w)) == NULL)
    		errorHandler("Couldn't allocate memory to image mask\n");
	   }

	   mzte_codec.Image = Image;
	}
      }

      vm_param_dec->target_spatial_levels 
    	  = MIN(mzte_codec.spatial_scalability_levels, vm_param_dec->target_spatial_levels);
      vm_param_dec->target_shape_levels 
    	  = MIN(mzte_codec.spatial_scalability_levels, vm_param_dec->target_shape_levels);

      if(mzte_codec.quantization_type == 2) {
    	  target_spatial_layer = mzte_codec.wvtDecompLev -1-
      	    mzte_codec.lastWvtDecompInSpaLayer[vm_param_dec->target_spatial_levels-1][0];
    	  target_shape_layer = mzte_codec.wvtDecompLev -1-
      	    mzte_codec.lastWvtDecompInSpaLayer[vm_param_dec->target_shape_levels-1][0];
      }
      else {
    	  target_spatial_layer 
      	    = mzte_codec.spatial_scalability_levels - vm_param_dec->target_spatial_levels;
    	  target_shape_layer 
      	    = mzte_codec.spatial_scalability_levels - vm_param_dec->target_shape_levels;
      }

      get_virtual_tile_mask(vm_param_dec,/* FPDAM: added by SAIT (99/09/03) */
			mzte_codec.Image,  mzte_codec.wvtDecompLev,
                        mzte_codec.object_width, mzte_codec.object_height,
                        mzte_codec.tile_width, mzte_codec.tile_height,
                        iTile, TileX, TileY,
                        mzte_codec.sa_dwt, mzte_codec.texture_tile_type, 
			vm_param_dec->colors, &target_shape_layer, 
			mzte_codec.SNR_start_code_enable, wvtfilter);
	
      if(target_shape_layer > target_spatial_layer) {
        noteWarning("Shape has less spatial layers than target,\n forced to  use shape spatial layers.\n");
        if(mzte_codec.quantization_type == 2) {
          for(i=0;i< mzte_codec.spatial_scalability_levels;i++) {
            if( mzte_codec.lastWvtDecompInSpaLayer[i][0] > mzte_codec.wvtDecompLev -1 - target_shape_layer){
              mzte_codec.target_spatial_levels 
		/*= vm_param_dec->target_spatial_levels */ = i;
              mzte_codec.lastWvtDecompInSpaLayer[i][0] 
		= mzte_codec.wvtDecompLev -1 - target_shape_layer;
              break;
          }
        }
      }
      else
        mzte_codec.target_spatial_levels 
		/* = vm_param_dec->target_spatial_levels */
		= mzte_codec.spatial_scalability_levels - target_shape_layer;
      }
    }
/* FPDAM end: added by SAIT */
}

static Void tile_table_Dec(Int *table)
{
    Int i;
    Int tmp;

    for ( i=0; i<mzte_codec.iNumOfTile; i++ ){
        tmp = (get_X_bits(16) << 16);
        get_X_bits(1);
        tmp += get_X_bits(16);
        get_X_bits(1);
        table[i+1] = tmp; /* modified by Sharp (99/5/10) */
/*    printf("Decoded Table[%d] = %d\n", i, table[i]);*/
    }
    align_byte1();
}

/* clear coeffinfo.quantized_value */
static Void clear_coeffinfo()
{
    int a, b;
    int w, h;

/* FPDAM begin : modified by SAIT (99/09/03) */
    /* w = mzte_codec.tile_width;
    h = mzte_codec.tile_height; */
    w = mzte_codec.width;
    h = mzte_codec.height;
/* FPDAM end : modified by SAIT (99/09/03)  */
    for(a=0; a<h; a++) {
        for(b=0; b<w; b++) {
            COEFF_RECVAL(b,a,0) = 0;
            COEFF_VAL(b,a,0) = 0;
            /*       COEFF_STATE(b,a,0)=0; */
            /*       COEFF_TYPE(b,a,0)=0; */
            /*       COEFF_SKIP(b,a,0)=0; */
            /*       COEFF_QSTATE(b,a,0).residualValue=0; */
            /*       COEFF_QSTATE(b,a,0).partitionType=0; */
        }
    }
    if(mzte_codec.colors==3){
        w = w>>1;
        h = h>>1;
        for(a=0; a<h; a++) {
            for(b=0; b<w; b++) {
                COEFF_RECVAL(b,a,1) = 0;
                COEFF_VAL(b,a,1) = 0;
            }
        }
        for(a=0; a<h; a++) {
            for(b=0; b<w; b++) {
                COEFF_RECVAL(b,a,2) = 0;
                COEFF_VAL(b,a,2) = 0;
            }
        }
    }
}

static Int emit_bits_local( UShort data, Int size, FILE *fp )
{
    static Int remain_bits = 0;
    static U_Int buf = 0;
    U_Int put_buffer = data;
    unsigned char c;

    /* Mask off any excess bits in code */
    put_buffer &= (((Int)1) << size) - 1;

    /* new number of bits in buffer */
    remain_bits += size;

    /* align incoming bits */
    put_buffer <<= 24 - remain_bits;

    /* and merge with old buffer contents */
    put_buffer |= buf;

    while (remain_bits >= 8) {
        c = (unsigned char) ((put_buffer >> 16) & 0xFF);
        fwrite(&c, sizeof(char), 1, fp);
        put_buffer <<= 8;
        remain_bits    -= 8;
    }
    buf = put_buffer;

    return remain_bits;
}

/*endif: added by Sharp (99/2/16)*/


#if 0
/***********************************************************************/
/***********************************************************************/
/*                              MAIN                                   */
/***********************************************************************/
/***********************************************************************/
/*DEBUGFILE *debfp;*/

main(Int argc, Char *argv[])
{
  Int i;
/*  struct tms start,end;*/

  /* Set defaults */
  parmFile      = parmFileDef;
  statsFile     = statsFileDef;
  encRecImgFile = encRecImgFileDef;
  decRecImgFile = decRecImgFileDef;

  /*----------------- Process arguments -----------------*/
  /* Parse command line */
  for (i=1; i<argc; ++i)
    if (argv[i][0]=='-' && argv[i][2]=='\0')
      {
	if (argv[i][1]=='p') /* parm file */
	  parmFile = argv[++i];
	else if (argv[i][1]=='s')
	  statsFile = argv[++i];
	else if (argv[i][1]=='d')
	  decRecImgFile= argv[++i];
	else if (argv[i][1]=='e')
	  encRecImgFile = argv[++i];
	else
	  goto USAGE;
      }
    else
      goto USAGE;
  /*----------------- End of process arguments -----------------*/
  
  /* Open statistics file. All subsequent calls to noteStat will write
     to this file. */
  if ((sfp=fopen(statsFile,"w"))==NULL)
     errorHandler("Couldn't open stat file '%s' for write.", statsFile);  

#ifndef _DECODER_
  /*DEBUGdebfp=fopen("enc","w");*/
  VTC_Encode();
  /*DEBUGfclose(debfp);*/
  recImgFile = encRecImgFile;
#else
  recImgFile = decRecImgFile;
#endif

 /* times(&start); */
  /*DEBUGdebfp=fopen("dec","w");*/
  VTC_Decode();
  /*DEBUGfclose(debfp);*/
 /* times(&end);
  noteProgress(" Decode in %.3fu %.3fs\n",
	       (float)(end.tms_utime-start.tms_utime)
	       /(float)CLK_TCK,
	       (float)(end.tms_stime-start.tms_stime)/(float)CLK_TCK);
*/

  /*  close statistics file */
  fclose(sfp);

  return 0;

USAGE:
  fprintf(stderr,"\n%s - compiled on %s", argv[0], __DATE__);
  fprintf(stderr,"\n\nUsage: %s"\
	  "\n\t[-p ParameterFile]"\
	  "\n\t[-s StatisticsFile]"\
	  "\n\t[-e EncoderReconstructedImageFile]"\
	  "\n\t[-d DecoderReconstructedImageFile]"\
	  "\n\t[-h (usage message)]",
	  argv[0]);
  fprintf(stderr,"\n\nDefaults: %s"\
	  "\n\t-p %s"\
	  "\n\t-s %s"\
	  "\n\t-e %s"\
	  "\n\t-d %s\n",
	  argv[0],parmFileDef,statsFileDef,encRecImgFileDef,decRecImgFileDef);
  
  return -1;
}

#endif
