/*****************************************************************************/
/*                                                            		     */
/* Copyright (c) 1996 ISO/IEC All Rights Reserved                	     */
/*                                                            		     */
/* This software module was originally developed by                          */
/*                                                            		     */
/* M. Eckert (UPM / ACTS-MoMuSyS)        	                	     */
/*                                                            		     */
/* and edited by                                                             */
/*                                                            		     */
/* Fernando Jaureguizar (UPM / ACTS-MoMuSyS)        	                     */
/* Robert Danielsen (Telenor / ACTS-MoMuSyS)                    	     */
/*                                                            		     */
/* in the course of development of the MPEG-4 standard. This software        */
/* module is an implementation of a part of one or more MPEG-4 tools as      */
/* specified by the MPEG-4 standard.             			     */
/*                                                            		     */
/* The copyright of this software belongs to ISO/IEC. ISO/IEC gives use      */
/* of the MPEG-4 standard free license to use this  software module or       */
/* modifications thereof for hardware or software products claiming          */
/* conformance to the MPEG-4 standard        				     */
/*                                                            		     */
/* Those intending to use this software module in hardware or software       */
/* products are advised that use may infringe existing  patents. The         */
/* original developers of this software module and their companies, the      */
/* subsequent editors and their companies, and ISO/IEC have no liability     */
/* and ISO/IEC have no liability for use of this software module or          */
/* modification thereof in an implementation.                                */
/*                                                            		     */
/*****************************************************************************/

/***********************************************************HeaderBegin*******
 *
 * File:        io_raw.c
 *
 * Author:      UPM - M. Eckert
 * Created:     12.03.96
 *
 * Description: IO-Functions to read and write a VOP in raw format
 *
 * Notes:
 *
 * Modified:    21.03.96 UPM - F. Jaureguizar: several modifications added.
 *              21.04.96 Robert Danielsen: Reformatted. New headers.
 *              02.07.96 UPM - F. Jaureguizar: Reformatted.
 *
 ***********************************************************HeaderEnd*********/

/************************    INCLUDE FILES    ********************************/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include "momusys.h"
#include "mom_structs.h"
#include "mom_vop.h"
#include "io_yuv.h"

/***********************************************************CommentBegin******
 *
 * -- ReadVopYUV --
 *
 * Author :
 *      UPM - M. Eckert
 *
 * Created :
 *      12.03.96
 *
 * Purpose :
 *
 *
 * Arguments in :
 *
 *
 * Arguments in/out :
 *
 *
 * Arguments out :
 *
 *
 * Return values :
 *
 *
 * Side effects :
 *
 *
 * Description :
 *
 *
 * See also :
 *
 *
 * Modified :
 *      21.03.96 UPM - F. Jaureguizar.
 *
 ***********************************************************CommentEnd********/

Void
ReadVopYUV(Char   *y_file,
           Char   *u_file,
           Char   *v_file,
           Char   *alpha_file,
           Int    frame,
           Char   *format,     /* always ignored  */
           Vop    *vop)
{
  FILE   *fichero;
  Byte   *data;
  Int    i, j, error;
  Int    height, width;
  Int    size_y, size_uv, framesize;
  Char   filename[80];

  height = vop->y_chan->y;
  width  = vop->y_chan->x;

  size_y  = width * height;
  size_uv = size_y / 4;
  framesize = size_y + 2 * size_uv;

#ifdef _DEBUG_
  fprintf(stdout,"\t\t - READING INPUT FILES - \n");
#endif
  
  data = (Byte *)malloc(framesize * sizeof(Byte));

  /************************** Y_Data ***************************/

  sprintf(filename,"%s%d.Y",y_file,frame);  

  if((fichero = fopen (filename,"rb"))==NULL)
    {
    fprintf(stderr," - ERROR: can not open Y file %s \n", filename);
    return;
    }

#ifdef SKIP
  /* No. of bits we have to skip to reach the frame */

  if (strcmp(y_file,u_file) == 0)
    skip = frame * framesize;
  else
    skip = frame * size_y;

  error = fseek (fichero, skip, SEEK_SET);
#endif

  /* The data */

  error = fread ((Char*)data, size_y, 1, fichero);
  if (error == 0)
    fprintf(stderr," - ERROR: input Y-Data incomplete\n");

  for(i = 0; i < height; i++)
    for(j = 0; j < width; j++)
      vop->y_chan->data->s[i*width + j] = (Byte) data[i*width + j];

#ifdef _DEBUG_
  fprintf(stdout,"\t\t - Read Y-Data\n");
#endif

  fclose (fichero);

  /************************** U_Data ***************************/

  sprintf(filename,"%s%d.U",u_file,frame);  

  if( (fichero = fopen (filename,"rb"))==NULL)
    {
    fprintf(stderr," - ERROR: can not open U file%s\n", filename);
    return;
    }

#ifdef SKIP
  /* No. of bits we have to skip to reach the frame */
  if (strcmp(y_file,u_file) == 0)
    skip = size_y + frame * framesize;
  else
    skip = frame * size_uv;

  error = fseek (fichero, skip, SEEK_SET);
#endif

  /* The data */

  error = fread ((Char*)data, size_uv, 1, fichero);
  if (error == 0)
    fprintf(stderr," - ERROR: input U-Data incomplete\n");

  for(i = 0; i < height/2; i++)
    for(j = 0; j < width/2; j++)
      vop->u_chan->data->s[i*width/2 + j]= (Byte) data[i*width/2 + j];

#ifdef _DEBUG_
  fprintf(stdout,"\t\t - Read U-Data\n");
#endif

  fclose (fichero);

  /************************** V_Data ***************************/

  sprintf(filename,"%s%d.V",v_file,frame);  
  if( (fichero = fopen (filename,"rb"))==NULL)
    {
    fprintf(stderr," - ERROR: can not open V file %s\n", filename);
    return;
    }

#ifdef SKIP
  /* No. of bits we have to skip to reach the frame */

  if (strcmp(y_file,u_file) == 0)
    skip = size_y + size_uv + frame * framesize;
  else
    skip = frame * size_uv;

  error = fseek (fichero, skip, SEEK_SET);
#endif

  /* The data */

  error = fread ((Char*)data, size_uv, 1, fichero);
  if (error == 0)
    fprintf(stderr," - ERROR: input V-Data incomplete\n");

  for(i = 0; i < height/2; i++)
    for(j = 0; j < width/2; j++)
      vop->v_chan->data->s[i*width/2 + j] = (Byte) data[i*width/2 + j];

#ifdef _DEBUG_
  fprintf(stdout,"\t\t - Read V-Data\n");
#endif

  fclose (fichero);

  /************************** Alpha_Data ***********************/
  if (strcmp(alpha_file,"null")) {
   
    sprintf(filename,"%s%d.seg",alpha_file,frame);  
    if( (fichero = fopen (filename,"rb"))==NULL)
      {
      fprintf(stderr," - ERROR: can not open Alpha file %s \n", filename);
      return;
      }


#ifdef SKIP
  /* No. of bits we have to skip to reach the frame */

  skip = frame * size_y;
  error = fseek (fichero, skip, SEEK_SET);
#endif

  /* The data */

  error = fread ((Char*)data, size_y, 1, fichero);
  if (error == 0)
     fprintf(stderr," - ERROR: input Alpha-Data incomplete\n");

  }

  if (strcmp(alpha_file,"null")) {
    for(i = 0; i < height; i++)
      for(j = 0; j < width; j++)
        vop->a_chan->data->s[i*width + j] = (Short) data[i*width + j];
  } else {
    for(i = 0; i < height; i++)
      for(j = 0; j < width; j++)
        vop->a_chan->data->s[i*width + j] = (Short) 255;
  }

#ifdef _DEBUG_
    fprintf(stdout,"\t\t - Read Alpha-Data\n");
#endif

  if (strcmp(alpha_file,"null")) {
   fclose (fichero);
  }

free((Char*)data);
}

/***********************************************************CommentBegin******
 *
 * -- WriteVopYUV --
 *
 * Author :
 *      UPM - M. Eckert
 *
 * Created :
 *      12.03.96
 *
 * Purpose :
 *
 *
 * Arguments in :
 *
 *
 * Arguments in/out :
 *
 *
 * Arguments out :
 *
 *
 * Return values :
 *
 *
 * Side effects :
 *
 *
 * Description :
 *
 *
 * See also :
 *
 *
 * Modified :
 *      21.03.96 UPM - F. Jaureguizar.
 *
 ***********************************************************CommentEnd********/

Void
WriteVopYUV(Vop    *vop,
            Char   *y_file,
            Char   *u_file,
            Char   *v_file,
            Char   *alpha_file,
            Int    number, 
            Char   *format,
            Char   *mode,
            Int    write_alpha)
{
  FILE   *fichero;
  Int    height    = vop->a_chan->y;
  Int    width     = vop->a_chan->x;
  Int    height_uv = vop->a_chan->y/2;
  Int    width_uv  = vop->a_chan->x/2;
  Int    i, j;
  Char   *datayuv;
  SInt   *data;
  Int    overwrite_mode=0;
  Char   filename[80];

  overwrite_mode=1;
    

  /************************** Y_Data ***************************/
  sprintf(filename,"%s%d.Y",y_file,number);

  if((fichero = fopen (filename,"wb"))==NULL) {
      fprintf(stderr," - ERROR: can not create Y file\n");
      return;
    }


  data = vop->y_chan->data->s;

  if ( (datayuv = malloc(height*width*sizeof(Char))) == NULL ) {
    printf("\nAllocation1 Failed in WriteYUV Image\n");
  }

  for(i = 0; i < height; i++)
    for(j = 0; j < width; j++)
      datayuv[i*width+j] = (Char)data[i*width+j];
      
  fwrite(datayuv, height*width , sizeof(Char), fichero);
  free(datayuv);

  fclose (fichero);

  /************************** U_Data ***************************/
  sprintf(filename,"%s%d.U",u_file,number);
  if((fichero = fopen (filename,"wb"))==NULL)
    {
    fprintf(stderr," - ERROR: can not create U file\n");
    return;
    }

  data = vop->u_chan->data->s;

  if ( (datayuv = malloc(height_uv*width_uv*sizeof(Char))) == NULL ) {
    printf("\nAllocation2 Failed in WriteYUV Image\n");
  }

  for(i = 0; i < height_uv; i++)
    for(j = 0; j < width_uv; j++)
      datayuv[i*width_uv+j] = (Char)data[i*width_uv+j];

  fwrite(datayuv, height_uv*width_uv , sizeof(Char), fichero);
  free(datayuv);

  fclose (fichero);

  /************************** V_Data ***************************/

  sprintf(filename,"%s%d.V",v_file,number);
  if((fichero = fopen (filename,"wb"))==NULL)
    {
    fprintf(stderr," - ERROR: can not create V file error\n");
    return;
    }

  data = vop->v_chan->data->s;

  if ( (datayuv = malloc(height_uv*width_uv*sizeof(Char))) == NULL ) {
    printf("\nAllocation3 Failed in WriteYUV Image\n");
  }

  for(i = 0; i < height_uv; i++)
    for(j = 0; j < width_uv; j++)
      datayuv[i*width_uv+j] = (Char)data[i*width_uv+j];

  fwrite(datayuv, height_uv*width_uv , sizeof(Char), fichero);
  free(datayuv);


  fclose (fichero);

  /************************ Alpha_Data *************************/

  if (write_alpha) {
     sprintf(filename,"%s%d.seg",alpha_file,number);
      if((fichero = fopen (filename,"wb"))==NULL)
        {
        fprintf(stderr," - ERROR: can not create Alpha file\n");
        return;
        }

    data = vop->a_chan->data->s;

    if ( (datayuv = malloc(height*width*sizeof(Char))) == NULL ) {
      printf("\nAllocation1 Failed in WriteYUV Image\n");
    }
    
    for(i = 0; i < height; i++)
      for(j = 0; j < width; j++)
	datayuv[i*width+j] = (Char)data[i*width+j];
    
    fwrite(datayuv, height*width , sizeof(Char), fichero);
    free(datayuv);

    fclose (fichero);
    }
}
/***********************************************************CommentBegin******/
