/*****************************************************************************/
/*                                                            		     */
/* Copyright (c) 1996 ISO/IEC All Rights Reserved                	     */
/*                                                            		     */
/* This software module was originally developed by                          */
/*                                                            		     */
/* Noel Brady (Teltec DCU / ACTS-MoMuSyS)        	                     */
/*                                                            		     */
/* and edited by                                                             */
/*                                                            		     */
/* Robert Danielsen (Telenor / ACTS-MoMuSyS)                    	     */
/*                                                            		     */
/* in the course of development of the MPEG-4 standard. This software        */
/* module is an implementation of a part of one or more MPEG-4 tools as      */
/* specified by the MPEG-4 standard.             			     */
/*                                                            		     */
/* The copyright of this software belongs to ISO/IEC. ISO/IEC gives use      */
/* of the MPEG-4 standard free license to use this  software module or       */
/* modifications thereof for hardware or software products claiming          */
/* conformance to the MPEG-4 standard        				     */
/*                                                            		     */
/* Those intending to use this software module in hardware or software       */
/* products are advised that use may infringe existing  patents. The         */
/* original developers of this software module and their companies, the      */
/* subsequent editors and their companies, and ISO/IEC have no liability     */
/* and ISO/IEC have no liability for use of this software module or          */
/* modification thereof in an implementation.                                */
/*                                                            		     */
/*****************************************************************************/

/***********************************************************HeaderBegin*******
 *                                                                         
 * File:	io_generic.c
 *
 * Author:	Noel Brady
 * Created:	6-Feb-96
 *                                                                         
 * Description: 
 *
 * Notes: 	
 *
 * Modified:	21.04.96 Robert Danielsen: Reformatted. New headers.
 *
 ***********************************************************HeaderEnd*********/

/************************    INCLUDE FILES    ********************************/

#include "io_generic.h"
#include "io_yuv.h"
/***********************************************************CommentBegin******
 *
 * -- ReadVopGeneric -- This function enables reading of a Vop from disk.
 *
 * Author :		
 *	
 *
 * Created :		
 *	
 *
 * Purpose :		
 *	
 * 
 * Arguments in : 	
 *	Char *y_file - the pathname for the file storing the Y image
 *	Char *u_file - the pathname for the file storing the U image
 *	Char *v_file - the pathname for the file storing the V image
 *	Char *alpha_file - the pathname for the file storing the 
 *			alpha image
 *	Int number - the number of the image to be read from each file
 *	Char *format - a string to enable choice of file format at 
 *			run-time. Use the default IO_FORMAT
 *
 * Arguments in/out :	
 *	Vop *vop_out - the data read from disk will be stored
 *			in the vop structure.
 *
 * Arguments out :	
 *	
 *
 * Return values :	
 *	
 *
 * Side effects :	
 *	
 *
 * Description :
 *	#include "io_generic.h"
 *	
 *	The function calls a sub-function which is specific
 *	for a given file format. For example, if the source is 
 * 	compiled with the directive -D_DCUIO_, then a call to this
 *	function will assume that the Vops are stored in the DCU 
 *	format. This function source can be extended to support
 *	any other formats.
 *
 * See also :
 *	WriteVopGeneric()
 *
 * Modified :		
 *	
 *
 ***********************************************************CommentEnd********/
 
Void
ReadVopGeneric(Char *y_file,
	       Char *u_file, 
	       char *v_file,
	       Char *alpha_file,
               Char g_files[MAX_MAC][100],
               Int  aux_comp_count,
	       Int  number, 
	       Char *format,  
	       Vop  *vop_out)
{
#ifdef _YUVIO_
  ReadVopYUV(y_file,u_file,v_file,alpha_file,number,format,vop_out);
#endif

#ifdef _RAWIO_
  ReadVopRAW(y_file,u_file,v_file,alpha_file,g_files,aux_comp_count,number,format,vop_out);
#endif

#ifdef _DCUIO_
  ReadVopDCU(y_file,u_file,v_file,alpha_file,number,format,vop_out);
#endif

#ifdef _GTIIO_
  ReadVopGTI(y_file,u_file,v_file,alpha_file,number,format,vop_out);
#endif

#ifdef _KPNIO_
  ReadVopKPN(y_file,u_file,v_file,alpha_file,number,format,vop_out);
#endif

#ifdef _UPCIO_
  ReadVopUPC(y_file,u_file,v_file,alpha_file,number,format,vop_out);
#endif

#ifdef _LEPIO_
  ReadVopRAW(y_file,u_file,v_file,alpha_file,number,format,vop_out);
#endif

#ifdef _HHIIO_
  ReadVopHHI(y_file,u_file,v_file,alpha_file,number,format,vop_out);
#endif

#ifdef _TUHIO_
  ReadVopTUH(y_file,u_file,v_file,alpha_file,number,format,vop_out);
#endif

#ifdef _DTAGIO_
  ReadVopDTAG(y_file,u_file,v_file,alpha_file,number,format,vop_out);
#endif

#ifdef _ISTIO_
  ReadVopIST(y_file,u_file,v_file,alpha_file,number,format,vop_out);
#endif

#ifdef _TELENORIO_
  ReadVopTELENOR(y_file,u_file,v_file,alpha_file,number,format,vop_out);
#endif
}

/***********************************************************CommentBegin******
 *
 * -- WriteVopGeneric -- This function enables writing a Vop to disk.
 *
 * Author :		
 *	
 *
 * Created :		
 *	
 *
 * Purpose :		
 *	This function enables writing a Vop to disk.
 * 
 * Arguments in : 	
 *	Vop *vop_in - the data read from disk will be stored
 *				in the vop structure.
 *
 * Arguments in/out :	
 *	Char *y_file - the pathname for the file to store the Y image
 *	Char *u_file - the pathname for the file to store the U image
 *	Char *v_file - the pathname for the file to store the V image
 *	Char *alpha_file - the pathname for the file to store the 
 *					alpha image
 *	Int number - the number of the image to be written to each 
 *				file
 *	Char *format - a string to enable choice of file format at 
 *				run-time. (use the default IO_FORMAT)
 *	Char *mode - a string specifying append or overwrite 
 *			(use IO_APPEND or IO_OVERWRITE)
 *	Int	write_alpha - Flag indicating whether or not to write alpha
 *										channel to disk.
 *
 * Arguments out :	
 *	
 *
 * Return values :	
 *	
 *
 * Side effects :	
 *	
 *
 * Description :	
 *	#include "io_generic.h"
 *
 *	The function calls a sub-function which is specific
 *	for a given file format. For example, if the source is 
 * 	compiled with the directive -D_DCUIO_, then a call to this
 *	function will assume that the Vops are be stored in the DCU 
 *	format. This function source can be extended to support
 *	any other formats.
 *
 * See also :
 *	ReadVopGeneric()
 *
 * Modified :		
 *	
 *
 ***********************************************************CommentEnd********/
 
Void
WriteVopGeneric(Vop *vop_in,
		Char *y_file,
		Char *u_file, 
		char *v_file,
		Char *alpha_file,
                Char g_files[MAX_MAC][100],
                Int  aux_comp_count,
		Int  number, 
		Char *format,
		Char *mode,
		Int	 write_alpha)
{

#ifdef _YUVIO_
 WriteVopYUV(vop_in,y_file,u_file,v_file,alpha_file,number,format,mode,write_alpha); 
#endif

#ifdef _RAWIO_
  WriteVopRAW(vop_in,y_file,u_file,v_file,alpha_file,g_files,aux_comp_count,number,format,mode,write_alpha);
#endif

  /* DCU format supported */

#ifdef _DCUIO_
  WriteVopDCU(vop_in,y_file,u_file,v_file,alpha_file,number,format,mode,write_alpha);
#endif

  /* UPM format supported */

#ifdef _GTIIO_
  WriteVopGTI(vop_in,y_file,u_file,v_file,alpha_file,number,format,mode,write_alpha);
#endif

  /* KPN format supported */

#ifdef _KPNIO_
  WriteVopKPN(vop_in,y_file,u_file,v_file,alpha_file,number,format,mode,write_alpha);
#endif

  /* and so on */
#ifdef _UPCIO_
  WriteVopUPC(vop_in,y_file,u_file,v_file,alpha_file,number,format,mode,write_alpha);
#endif

#ifdef _LEPIO_
  WriteVopLEP(vop_in,y_file,u_file,v_file,alpha_file,number,format,mode,write_alpha);
#endif

#ifdef _TUHIO_
  WriteVopTUH(vop_in,y_file,u_file,v_file,alpha_file,number,format,mode,write_alpha);
#endif

#ifdef _HHIIO_
  WriteVopHHI(vop_in,y_file,u_file,v_file,alpha_file,number,format,mode,write_alpha);
#endif

#ifdef _DTAGIO_
  WriteVopDTAG(vop_in,y_file,u_file,v_file,alpha_file,number,format,mode,write_alpha);
#endif

#ifdef _ISTIO_
  WriteVopIST(vop_in,y_file,u_file,v_file,alpha_file,number,format,mode,write_alpha);
#endif

#ifdef _TELENORIO_
  WriteVopTELENOR(vop_in,y_file,u_file,v_file,alpha_file,number,format,mode,write_alpha);
#endif
}

