/******************************************************************************
 *
 * This software module was originally developed by
 *
 *	Ji Heon Kweon (HYUNDAI)
 *
 * in the course of development of the MPEG-4 Video (ISO/IEC 14496-2) standard.
 * This software module is an implementation of a part of one or more MPEG-4
 * Video (ISO/IEC 14496-2) tools as specified by the MPEG-4 Video (ISO/IEC
 * 14496-2) standard.
 *
 * ISO/IEC gives users of the MPEG-4 Video (ISO/IEC 14496-2) standard free
 * license to this software module or modifications thereof for use in hardware
 * or software products claiming conformance to the MPEG-4 Video (ISO/IEC
 * 14496-2) standard.
 *
 * Those intending to use this software module in hardware or software products
 * are advised that its use may infringe existing patents. The original
 * developer of this software module and his/her company, the subsequent
 * editors and their companies, and ISO/IEC have no liability for use of this
 * software module or modifications thereof in an implementation. Copyright is
 * not released for non MPEG-4 Video (ISO/IEC 14496-2) standard conforming
 * products.
 *
 * ACTS-MoMuSys partners retain full right to use the code for his/her own
 * purpose, assign or donate the code to a third party and to inhibit third
 * parties from using the code for non MPEG-4 Video (ISO/IEC 14496-2) standard
 * conforming products. This copyright notice must be included in all copies or
 * derivative works.
 *
 * Copyright (c) 1998
 *
 *****************************************************************************/

/***********************************************************HeaderBegin*******
 *                                                                         
 * File:	boundary.c
 *
 * Author:	HYUNDAI - Ji Hweon Kweon 
 * Created:	07-05-98 
 *                                                                         
 * Description: 
 *
 * Notes: 	
 *
 * Modified:
 *
 ***********************************************************HeaderEnd*********/

#include <stdio.h>
#include <stdlib.h>
#include "mot_util.h" 
#include "text_util.h"
#include "boundary.h"

Void BoundaryCheck(SInt *alpha_rec, Int start_pos, Int width, Int MB_transp_pattern[], Int boundaryM[])
{
    Int pos;
 
    /* Horizontal Scan */
    pos = start_pos;
    if(MB_transp_pattern[0]==4 && MB_transp_pattern[1]==4) 
      if(MPixelCheck(alpha_rec, pos, width, 0, 8))
        {boundaryM[0] = MB_transp_pattern[1] = 1; boundaryM[1]=2;}
    pos = start_pos+(8*width);
    if(MB_transp_pattern[2]==4 && MB_transp_pattern[3]==4) 
      if(MPixelCheck(alpha_rec, pos, width, 0, 8))
        {boundaryM[0] = MB_transp_pattern[3] = 1; boundaryM[3]=4;}
 
    /* Vertical Scan */
    if(boundaryM[0]==0) {
      pos = start_pos;
      if(MB_transp_pattern[0]==4 && MB_transp_pattern[2]==4) 
        if(MPixelCheck(alpha_rec, pos, width, 8, 0))
          {boundaryM[0] = MB_transp_pattern[2] = 1; boundaryM[1]=3;}
      pos = start_pos+8;
      if(MB_transp_pattern[1]==4 && MB_transp_pattern[3]==4) 
        if(MPixelCheck(alpha_rec, pos, width, 8, 0))
          {boundaryM[0] = MB_transp_pattern[3] = 1; boundaryM[2]=4;}
    }    
 
    /* Diagonal Scan */
    if(boundaryM[0]==0) {
      pos = start_pos;
      if(MB_transp_pattern[0]==4 && MB_transp_pattern[3]==4) 
        if(MPixelCheck(alpha_rec, pos, width, 8, 8))
          {boundaryM[0] = MB_transp_pattern[3] = 1; boundaryM[1]=4;}
      pos = start_pos+8;
      if(MB_transp_pattern[1]==4 && MB_transp_pattern[2]==4) 
        if(MPixelCheck(alpha_rec, pos, width, 8, -8))
          {boundaryM[0] = MB_transp_pattern[2] = 1; boundaryM[2]=3;}
    }  
}

Int MPixelCheck(SInt *alpha_rec, Int pos, Int width, Int i_inc, Int j_inc)
{
    Int i, j;

    for(i=0; i<8; i++)
      for(j=0; j<8; j++)
        if(*(alpha_rec+pos+(7-i)*width+(7-j)) && *(alpha_rec+pos+(i+i_inc)*width+j+j_inc))
          return 0;
    return 1;
}


Void BoundaryMS(Vop *curr, Vop *rec_curr, SInt *alpha_rec, Int start_pos, Int width, Int boundaryM[])
{
    SInt *current=NULL, *recon=NULL;
    SInt *g_current=NULL, *g_recon=NULL;
    Int k, n, i_inc=0, j_inc=0;

    if(boundaryM[0]==1) 
      current = (SInt *)GetImageData(GetVopY(curr));

    if(boundaryM[0]==2) 
      recon = (SInt *)GetImageData(GetVopY(rec_curr));

    /*  MAC (SB) 12-Nov-99
    if(GetVopShape(curr) == GREY_SCALE) {
      if(boundaryM[0]==1)
        g_current = (SInt *)GetImageData(GetVopG(curr));
 
      if(boundaryM[0]==2)
        g_recon = (SInt *)GetImageData(GetVopG(rec_curr));
    }
    */

    for(k=1; k<4; k++)
      if(boundaryM[k]) {
        if(k==1) 
          switch (boundaryM[k]) {
           case 2: 
                i_inc = 0; 
		j_inc = 8;
		break;
           case 3: 
                i_inc = 8; 
		j_inc = 0;
		break;
           case 4: 
                i_inc = 8; 
		j_inc = 8;
		break;
           default: 
	  	break;
          }
       else if(k==2) 
          switch (boundaryM[k]) {
           case 3: 
 		start_pos += 8;
                i_inc = 8; 
		j_inc = -8;
		break;
           case 4: 
 		start_pos += 8;
                i_inc = 8; 
		j_inc = 0;
		break;
           default: 
	  	break;
          }
       else {     /* k==3 */ 
		start_pos += 8*width;
                i_inc = 0; 
		j_inc = 8;
       }

        if(boundaryM[0]==1) 
	  BoundaryM(current, alpha_rec, start_pos, width, i_inc, j_inc);

        if(boundaryM[0]==2) 
	  BoundaryS(recon, start_pos, width, i_inc, j_inc);

 
        if(GetVopShape(curr) == GREY_SCALE) {

          if(boundaryM[0]==1)
            for(n=0;n<GetVopAuxCompCount(curr);n++) {/* MAC (SB) 12-Nov-99 */
              g_current = (SInt *)GetImageData(GetVopG(n,curr));
              BoundaryM(g_current, alpha_rec, start_pos, width, i_inc, j_inc);
            }

          if(boundaryM[0]==2)
            for(n=0;n<GetVopAuxCompCount(curr);n++) {/* MAC (SB) 12-Nov-99 */
              g_recon = (SInt *)GetImageData(GetVopG(n,rec_curr));
              BoundaryS(g_recon, start_pos, width, i_inc, j_inc);
            }
        }
    }
}

Void BoundaryM(SInt *current, SInt *alpha_rec, Int pos, Int width, Int i_inc, Int j_inc) 
{ 
    Int i, j; 
  
    for(i=0; i<8; i++) 
      for(j=0; j<8; j++) 
        if(*(alpha_rec+pos+(i+i_inc)*width+j+j_inc)) { 
          *(current+pos+(7-i)*width+7-j) = *(current+pos+(i+i_inc)*width+j+j_inc); 
        } 
        else if(*(alpha_rec+pos+(7-i)*width+(7-j))==0) { 
          *(current+pos+(7-i)*width+7-j) += *(current+pos+(i+i_inc)*width+j+j_inc); 
          *(current+pos+(7-i)*width+7-j) /= 2; 
        } 
}         
  
Void BoundaryS(SInt *recon, Int pos, Int width, Int i_inc, Int j_inc) 
{ 
    Int i, j; 
  
    for(i=0; i<8; i++) 
      for(j=0; j<8; j++) 
          *(recon+pos+(i+i_inc)*width+j+j_inc) = *(recon+pos+(7-i)*width+7-j); 
} 


Void DecoderBoundaryS(Macroblock *mblock, SInt *g_mblock, Int boundaryM[],Int grayscale)
{
    Int k, i, j, y_pos=0, x_pos=0, i_inc=0, j_inc=0;

    for(k=1; k<4; k++)
      if(boundaryM[k]) {
        if(k==1)
          switch (boundaryM[k]) {
           case 2:
                y_pos = 0;
                x_pos = 0;
                i_inc = 0;
                j_inc = 8;
                break;
           case 3:
                y_pos = 0;
                x_pos = 0;
                i_inc = 8;
                j_inc = 0;
                break;
           case 4:
                y_pos = 0;
                x_pos = 0;
                i_inc = 8;
                j_inc = 8;
                break;
           default:
                break;
          }
        else if(k==2)
          switch (boundaryM[k]) {
           case 3:
                y_pos = 0;
                x_pos = 8;
                i_inc = 8;
                j_inc = -8;
                break;
           case 4:
                y_pos = 0;
                x_pos = 8;
                i_inc = 8;
                j_inc = 0;
                break;
           default:
                break;
          }
        else {   /* k==3 */
                y_pos = 8;
                x_pos = 0;
                i_inc = 0;
                j_inc = 8;
        }

        for(i=0; i<8; i++)
          for(j=0; j<8; j++)
              mblock->lum[y_pos+i+i_inc][x_pos+j+j_inc] = mblock->lum[y_pos+7-i][x_pos+7-j];

        if(grayscale == 1)
          for(i=0; i<8; i++)
            for(j=0; j<8; j++)
              *(g_mblock+(y_pos+i+i_inc)*MB_SIZE+x_pos+j+j_inc)
                = *(g_mblock+(y_pos+7-i)*MB_SIZE + x_pos+7-j);
    }
}

