/* $Id: Utils.c,v 1.23 1998/08/07 16:12:09 hatrack Exp $ */
/****************************************************************************/
/*   MPEG4 Visual Texture Coding (VTC) Mode Software                        */
/*                                                                          */
/*   This software was jointly developed by the following participants:     */
/*                                                                          */
/*   Single-quant,  multi-quant and flow control                            */
/*   are provided by  Sarnoff Corporation                                   */
/*     Iraj Sodagar   (iraj@sarnoff.com)                                    */
/*     Hung-Ju Lee    (hjlee@sarnoff.com)                                   */
/*     Paul Hatrack   (hatrack@sarnoff.com)                                 */
/*     Shipeng Li     (shipeng@sarnoff.com)                                 */
/*     Bing-Bing Chai (bchai@sarnoff.com)                                   */
/*     B.S. Srinivas  (bsrinivas@sarnoff.com)                               */
/*                                                                          */
/*   Bi-level is provided by Texas Instruments                              */
/*     Jie Liang      (liang@ti.com)                                        */
/*                                                                          */
/*   Shape Coding is provided by  OKI Electric Industry Co., Ltd.           */
/*     Zhixiong Wu    (sgo@hlabs.oki.co.jp)                                 */
/*     Yoshihiro Ueda (yueda@hlabs.oki.co.jp)                               */
/*     Toshifumi Kanamaru (kanamaru@hlabs.oki.co.jp)                        */
/*                                                                          */
/*   OKI, Sharp, Sarnoff, TI and Microsoft contributed to bitstream         */
/*   exchange and bug fixing.                                               */
/*                                                                          */
/*                                                                          */
/* In the course of development of the MPEG-4 standard, this software       */
/* module is an implementation of a part of one or more MPEG-4 tools as     */
/* specified by the MPEG-4 standard.                                        */
/*                                                                          */
/* The copyright of this software belongs to ISO/IEC. ISO/IEC gives use     */
/* of the MPEG-4 standard free license to use this  software module or      */
/* modifications thereof for hardware or software products claiming         */
/* conformance to the MPEG-4 standard.                                      */
/*                                                                          */
/* Those intending to use this software module in hardware or software      */
/* products are advised that use may infringe existing  patents. The        */
/* original developers of this software module and their companies, the     */
/* subsequent editors and their companies, and ISO/IEC have no liability    */
/* and ISO/IEC have no liability for use of this software module or         */
/* modification thereof in an implementation.                               */
/*                                                                          */
/* Permission is granted to MPEG members to use, copy, modify,              */
/* and distribute the software modules ( or portions thereof )              */
/* for standardization activity within ISO/IEC JTC1/SC29/WG11.              */
/*                                                                          */
/* Copyright 1995, 1996, 1997, 1998 ISO/IEC                                 */
/****************************************************************************/

/************************************************************/
/*     Sarnoff Very Low Bit Rate Still Image Coder          */
/*     Copyright 1995, 1996, 1997, 1998 Sarnoff Corporation */
/************************************************************/

#include <stdio.h>
#include "dataStruct.h"
#include "globals.h"
#include "Utils.h"

Void setSpatialLevelAndDimensions(Int spLayer, Int c)
{
  mzte_codec.curSpatialLev=spLayer;
  mzte_codec.SPlayer[c].height
    =mzte_codec.spaLayerHeight[spLayer][c];
  mzte_codec.SPlayer[c].width
    =mzte_codec.spaLayerWidth[spLayer][c];
}

Void updateResidMaxAndAssignSkips(Int c)
{
  Int rLev;
  Int i;
  Int x, y, spX, spY, spHeight, spWidth;

  WVTDECOMP_RES_NUMBITPLANES(c)=0;

  for (i = 0; i <= mzte_codec.curSpatialLev; ++i)
  {
    prevQList2[c][i] = prevQList[c][i];

    if (prevQList[c][i] == 0)
      prevQList[c][i] = USER_Q(c);

    rLev=quantRefLev(USER_Q(c), prevQList[c]+i, scaleLev[c][i]++)-1;

    {
      extern Int ceilLog2(Int x); /* defined in encQM.c */
      Int v;

      v = ceilLog2(rLev+1);
      if (v > WVTDECOMP_RES_NUMBITPLANES(c))
	WVTDECOMP_RES_NUMBITPLANES(c) = v;
    }

    /*--- Set skip mode all coefficients in spatial level ---*/
    if (i < mzte_codec.curSpatialLev)
    {
      /* Get spatial level dimensions of i^{th} spatial layer */
      spHeight = mzte_codec.spaLayerHeight[i][c];
      spWidth  = mzte_codec.spaLayerWidth[i][c];

      if (i==0)
      {
        spY = mzte_codec.dcHeight;
        spX = mzte_codec.dcWidth;
      }
      else
      {
	spY = mzte_codec.spaLayerHeight[i-1][c];
	spX = mzte_codec.spaLayerWidth[i-1][c];
      }

      /* HL */
      for (y = 0; y < spY; ++y)
	for (x = spX; x < spWidth; ++x)
	{
	  if (rLev > 0)
	    COEFF_SKIP(x,y,c) = 0;
	  else if (COEFF_SKIP(x,y,c)==0)	    
	    COEFF_SKIP(x,y,c)=1;
	}
      
      /* LH */
      for (y = spY; y < spHeight; ++y)
	for (x = 0; x < spX; ++x)
	{
	  if (rLev > 0)
	    COEFF_SKIP(x,y,c) = 0;
	  else if (COEFF_SKIP(x,y,c)==0)	    
	    COEFF_SKIP(x,y,c)=1;
	}
      
      /* HH */
      for (y = spY; y < spHeight; ++y)
	for (x = spX; x < spWidth; ++x)
	{
	  if (rLev > 0)
	    COEFF_SKIP(x,y,c) = 0;
	  else if (COEFF_SKIP(x,y,c)==0)	    
	    COEFF_SKIP(x,y,c)=1;
	}
    } 
  }
}


Int xy2wvtDecompLev(Int x, Int y)
{
  register Int i;

  for (i=0; i<mzte_codec.wvtDecompLev; ++i)
    if (x < (mzte_codec.dcWidth<<i) && y < (mzte_codec.dcHeight<<i))
      break;

  return i-1;
}


#ifdef _WRITE_COEFF_MAP_
/* 
   Function Name
   -------------
   Void dumpACMap(Char *fn, Int c)

   Arguments 
   ---------
   Char *fn - Name of file to dump the map to.
   Int c - Color component to dump.

   Description
   -----------
   dumpACMap will append the current value, state, and type of all coefficients
   in all AC bands to the file poInted to by 'fn'. It will overwrite any
   existing file.

   Functions Called
   ----------------
   none.

   Return Value
   ------------
   none.

   Source File
   -----------
   Utils.c
*/

Void dumpACMap(Char *fn, Int c)
{
  File *fp;
  Int x,y;
  Int err;
  Char fname[256];

  /* dump map of coeffinfo */
  if (fn == NULL)
    noteProgress("Note: No QM map written (disabled).");
  else
  {
    /* form file name suffix */
    sprIntf(fname, "%sAC.%02d.%02d.%d", fn, mzte_codec.curSpatialLev, 
	    mzte_codec.curSNRLev, mzte_codec.curColor);
    fn = fname;

    if ((fp = fopen(fn,"w")) == NULL)
    {
      noteError("Can't open map file '%s' for writing in QM", fn);
      err = ERR_QM_MAP_WRITE;
    }
    else
    {	
      noteProgress("Writing QM map to '%s'....", fn);
     
      /* Write 'header' info */
      fprIntf(fp, "\n----- AC Band: Spatial Layer %3d, SNR Layer %3d, "\
	      "Color %3d -----\n\n", 
	      mzte_codec.curSpatialLev, mzte_codec.curSNRLev, 
	      mzte_codec.curColor);
      fprIntf(fp, "Width = %5d, Height = %5d\n\n", 
	      mzte_codec.SPlayer[c].width, mzte_codec.SPlayer[c].height);

      /* Write coeffinfo */
      for (y = 0; y < mzte_codec.SPlayer[c].height; ++y)
	for (x = 0; x < mzte_codec.SPlayer[c].width; ++x)
	  if (x >= mzte_codec.dcWidth || y >=  mzte_codec.dcHeight)
	    fprIntf(fp,"%5d, %5d: %6d %11s %11s  %s\n",
		    x, y, COEFF_VAL(x,y,c),
		    mapStateToText[COEFF_STATE(x, y, c)],
		    mapTypeToText[COEFF_TYPE(x, y, c)],
		    COEFF_SKIP(x,y,c) ? "Skipped" : "");

      fclose(fp);
      noteProgress("Writing of QM map finished.");
    }
  }
}


/* 
   Function Name
   -------------
   Void dumpDCMap(Char *fn, Int c)

   Arguments 
   ---------
   Char *fn - Name of file to dump the map to.
   Int c - Color component to dump.

   Description
   -----------
   dumpDCMap will write the current value, state, and type of all coefficients
   in the DC band to the file poInted to by 'fn'. It will overwrite any
   existing file.

   Functions Called
   ----------------
   none.

   Return Value
   ------------
   none.

   Source File
   -----------
   Utils.c
*/

Void dumpDCMap(Char *fn, Int c)
{
  File *fp;
  Int x,y;
  Int err;
  Char fname[256];

  /* dump map of coeffinfo */
  if (fn == NULL)
    noteProgress("Note: No QM map written (disabled).");
  else
  {
    /* form file name suffix */
    sprIntf(fname, "%sDC.%d", fn, mzte_codec.curColor);
    fn = fname;

    if ((fp = fopen(fn,"w")) == NULL)
    {
      noteError("Can't open map file '%s' for writing in QM", fn);
      err = ERR_QM_MAP_WRITE;
    }
    else
    {	
      noteProgress("Writing QM map to '%s'....", fn);
     
      /* Write 'header' info */
      fprIntf(fp, 
	      "\n----- DC Band: Color %3d -----\n\n", mzte_codec.curColor);
      fprIntf(fp, "Width = %5d, Height = %5d\n\n", 
	      mzte_codec.dcWidth,mzte_codec.dcHeight);

      /* Write coeffinfo */
      for (y = 0; y < mzte_codec.dcHeight; ++y)
	for (x = 0; x < mzte_codec.dcWidth; ++x)
	  fprIntf(fp,"%5d, %5d: %6d %11s %11s\n",
		  x, y, COEFF_VAL(x,y,c),
		  mapStateToText[COEFF_STATE(x, y,c)],
		  mapTypeToText[COEFF_TYPE(x, y,c)]);

      fclose(fp);
      noteProgress("Writing of QM map finished.");
    }
  }
}

#endif _WRITE_COEFF_MAP_

#ifdef _WRITE_ORV_MAP_

Void dumpACORVMap(Char *fn, Int c, Int rec)
{
  File *fp;
  Int x,y;
  Int err;
  Char fname[256];

  /* dump map of coeffinfo */
  if (fn == NULL)
    noteProgress("Note: No ORV map written (disabled).");
  else
  {
    /* form file name suffix */
    sprIntf(fname, "%sAC.ORV.%02d.%02d.%d", fn, mzte_codec.curSpatialLev, 
	    mzte_codec.curSNRLev, mzte_codec.curColor);
    fn = fname;

    if ((fp = fopen(fn,"w")) == NULL)
    {
      noteError("Can't open map file '%s' for writing.", fn);
      err = ERR_QM_MAP_WRITE;
    }
    else
    {	
      noteProgress("Writing ORV map to '%s'....", fn);
     
      /* Write 'header' info */
      fprIntf(fp, 
	      "\n----- AC Band: Spatial Layer %3d, SNR Layer %3d, Color %3d \
-----\n\n", 
	      mzte_codec.curSpatialLev, mzte_codec.curSNRLev, 
	      mzte_codec.curColor);
      fprIntf(fp, "Width = %5d, Height = %5d\n\n", 
	      mzte_codec.SPlayer[c].width, mzte_codec.SPlayer[c].height);

      /* Write coeffinfo */
      for (y = 0; y < mzte_codec.SPlayer[c].height; ++y)
	for (x = 0; x < mzte_codec.SPlayer[c].width; ++x)
	  if (x >= mzte_codec.dcWidth || y >=  mzte_codec.dcHeight)
	    fprIntf(fp,"%5d, %5d: %6d\n",
		    x, y, rec ? COEFF_RECVAL(x,y,c) : COEFF_ORGVAL(x,y,c));

      fclose(fp);
      noteProgress("Writing of ORV map finished.");
    }
  }
}



Void dumpDCORVMap(Char *fn, Int c, Int rec)
{
  File *fp;
  Int x,y;
  Int err;
  Char fname[256];

  /* dump map of coeffinfo */
  if (fn == NULL)
    noteProgress("Note: No ORV map written (disabled).");
  else
  {
    /* form file name suffix */
    sprIntf(fname, "%s.ORV.DC.%d", fn, mzte_codec.curColor);
    fn = fname;

    if ((fp = fopen(fn,"w")) == NULL)
    {
      noteError("Can't open ORV map file '%s' for writing.", fn);
      err = ERR_QM_MAP_WRITE;
    }
    else
    {	
      noteProgress("Writing ORV map to '%s'....", fn);
     
      /* Write 'header' info */
      fprIntf(fp, 
	      "\n----- DC Band: Color %3d -----\n\n", mzte_codec.curColor);
      fprIntf(fp, "Width = %5d, Height = %5d\n\n", 
	      mzte_codec.dcWidth,mzte_codec.dcHeight);

      /* Write coeffinfo */
      for (y = 0; y < mzte_codec.dcHeight; ++y)
	for (x = 0; x < mzte_codec.dcWidth; ++x)
	  fprIntf(fp,"%5d, %5d: %6d\n",
		  x, y, rec ? COEFF_RECVAL(x,y,c) : COEFF_ORGVAL(x,y,c));

      fclose(fp);
      noteProgress("Writing of ORV map finished.");
    }
  }
}

#endif _WRITE_ORV_MAP_
