/****************************************************************************/
/*   MPEG4 Visual Texture Coding (VTC) Mode Software                        */
/*                                                                          */
/*   This software was jointly developed by the following participants:     */
/*                                                                          */
/*   Single-quant,  multi-quant and flow control                            */
/*   are provided by  Sarnoff Corporation                                   */
/*     Iraj Sodagar   (iraj@sarnoff.com)                                    */
/*     Hung-Ju Lee    (hjlee@sarnoff.com)                                   */
/*     Paul Hatrack   (hatrack@sarnoff.com)                                 */
/*     Shipeng Li     (shipeng@sarnoff.com)                                 */
/*     Bing-Bing Chai (bchai@sarnoff.com)                                   */
/*     B.S. Srinivas  (bsrinivas@sarnoff.com)                               */
/*                                                                          */
/*   Bi-level is provided by Texas Instruments                              */
/*     Jie Liang      (liang@ti.com)                                        */
/*                                                                          */
/*   Shape Coding is provided by  OKI Electric Industry Co., Ltd.           */
/*     Zhixiong Wu    (sgo@hlabs.oki.co.jp)                                 */
/*     Yoshihiro Ueda (yueda@hlabs.oki.co.jp)                               */
/*     Toshifumi Kanamaru (kanamaru@hlabs.oki.co.jp)                        */
/*                                                                          */
/*   OKI, Sharp, Sarnoff, TI and Microsoft contributed to bitstream         */
/*   exchange and bug fixing.                                               */
/*                                                                          */
/*                                                                          */
/* In the course of development of the MPEG-4 standard, this software       */
/* module is an implementation of a part of one or more MPEG-4 tools as     */
/* specified by the MPEG-4 standard.                                        */
/*                                                                          */
/* The copyright of this software belongs to ISO/IEC. ISO/IEC gives use     */
/* of the MPEG-4 standard free license to use this  software module or      */
/* modifications thereof for hardware or software products claiming         */
/* conformance to the MPEG-4 standard.                                      */
/*                                                                          */
/* Those intending to use this software module in hardware or software      */
/* products are advised that use may infringe existing  patents. The        */
/* original developers of this software module and their companies, the     */
/* subsequent editors and their companies, and ISO/IEC have no liability    */
/* and ISO/IEC have no liability for use of this software module or         */
/* modification thereof in an implementation.                               */
/*                                                                          */
/* Permission is granted to MPEG members to use, copy, modify,              */
/* and distribute the software modules ( or portions thereof )              */
/* for standardization activity within ISO/IEC JTC1/SC29/WG11.              */
/*                                                                          */
/* Copyright 1995, 1996, 1997, 1998 ISO/IEC                                 */
/****************************************************************************/

#include <stdio.h>
#include <math.h>
#include <malloc.h>	/* SAIT_V2 */
#include "typedef.h"
#include "bitpack.h"
#include "ShapeCommon.h"
#include "BinArCodec.h"

/***************************/
/*      ArCodec            */
/***************************/


Void
StartArCoder_Still(ArCoder *coder) 
{
    coder -> L = 0;
    coder -> R = HALF-1;
    coder -> bits_to_follow = 0;
    coder -> first_bit = 1;
    coder -> nzeros = MAXHEADING;
    coder -> nonzero = 0;
}

Void
StopArCoder_Still(ArCoder *coder,BSS *bitstream)
{
    Int a = ( coder -> L )              >> ( CODE_BITS - 3 );
    Int b = ( coder -> R + coder -> L ) >> ( CODE_BITS - 3 );

    Int nbits, bits, i;

    if ( b == 0 ) b = 8;

    if ( b-a >= 4 || (b-a == 3 && (a & 1) == 1 ) ) {
        nbits = 2;
        bits  = (a>>1) + 1;
    } else {
        nbits = 3;
        bits  = a + 1;
    }
  
    for ( i=1; i<=nbits; i++ ) {
        BitPlusFollow_Still ( ((bits >> (nbits-i)) & 1), coder, bitstream );
    }
	
    if ( coder -> nzeros < MAXMIDDLE-MAXTRAILING || coder -> nonzero == 0 ) {
        BitPlusFollow_Still( 1, coder, bitstream );
    }

    return;
}

/* ENCODE A BINARY SYMBOL */

Void
ArCodeSymbol_Still(ArCoder *coder,BSS *bitstream,UChar bit,U_Int c0)
{
	U_Int	c1   = (1<<16) - c0;
  
	UChar	LPS  = (c0 > c1);
	U_Int	cLPS = (LPS) ? c1 : c0;

	unsigned long rLPS;
	rLPS = ((coder -> R) >> 16) * cLPS;
  
	if (bit == LPS) {
		coder -> L += coder->R - rLPS;
		coder -> R  = rLPS;
	} else {
		coder -> R -= rLPS;
	}

	EncRenormalize( coder, bitstream );
}

Void
EncRenormalize(ArCoder *coder,BSS *bitstream)
{
    while ( coder -> R < QUARTER ) {
        if( coder -> L >= HALF ) {				 
            BitPlusFollow_Still( 1, coder, bitstream );
            coder -> L -= HALF;
        } else {
            if ( coder -> L + coder -> R <= HALF ) {
                BitPlusFollow_Still( 0, coder, bitstream );
            } else {				 
                coder -> bits_to_follow++;		 
                coder -> L -= QUARTER;		 
            }
        }
        coder -> L += coder -> L;				 
        coder -> R += coder -> R;				 
    }
}

Void
BitByItself_Still(Int bit,ArCoder *coder,BSS *bitstream) 
{
    BitstreamPutBit_Still( bit, bitstream );	/* Output the bit */
    if ( bit == 0 ) {
        coder -> nzeros --;
        if ( coder -> nzeros == 0 ) {
            BitstreamPutBit_Still( 1, bitstream );
            coder -> nonzero = 1;
            coder -> nzeros  = MAXMIDDLE;
        }
    } else {
        coder -> nonzero = 1;
        coder -> nzeros  = MAXMIDDLE;
    }
}

/* OUTPUT BITS PLUS FOLLOWING OPPOSITE BITS */

Void
BitPlusFollow_Still(Int bit,ArCoder *coder,BSS *bitstream)
{
	if ( ! coder -> first_bit )
		BitByItself_Still( bit, coder, bitstream );
	else
		coder -> first_bit = 0;
	while ( (coder -> bits_to_follow) > 0 ) {
		BitByItself_Still( !bit, coder, bitstream );
		coder -> bits_to_follow -= 1;
	}
}


/*  Bitstream operation function in CAE */

Void
BitstreamPutBit_Still(Int bit,BSS *bitstream)
{
	Int		res = bitstream -> res;
	UChar	*p  = bitstream -> ptr;

	*p |= (UChar)( ( bit & 1 ) << ( 7 - res ) );
	res ++;
	if ( res == 8 ) {
		*(++p) = (UChar)0;
		res    = 0;
	}
	bitstream -> ptr = p;
	bitstream -> res = res;
	bitstream -> cnt ++;
}

/***************************/
/*      Decoder            */
/***************************/

Void
StartArDecoder_Still(ArDecoder *decoder) 
{
	Int		i, j;
  
	decoder -> V			= 0;
	decoder -> extrabits	= 0;
	decoder -> nzerosf		= MAXHEADING;

	for ( i=1; i<CODE_BITS; i++ ) {
		j = BitstreamLookBit( i + decoder -> extrabits);
		decoder -> V += decoder -> V + j;
		if ( j == 0 ) {
			decoder -> nzerosf--;
			if (decoder -> nzerosf == 0) {
				decoder -> extrabits ++;
				decoder -> nzerosf   = MAXMIDDLE;
			}
		} else {
			decoder -> nzerosf = MAXMIDDLE;
		}
	}

	decoder -> L				= 0;
	decoder -> R				= HALF - 1;
	decoder -> bits_to_follow	= 0;
	decoder -> arpipe			= decoder -> V;
	decoder -> nzeros			= MAXHEADING;
	decoder -> nonzero			= 0;

	return;
}

  
Void
StopArDecoder_Still(ArDecoder *decoder) 
{
	Int		a = ( decoder -> L >> ( CODE_BITS - 3 ) );
	Int		b = ( decoder -> R + decoder -> L ) >> ( CODE_BITS - 3 );

	Int		nbits, i;

	if (b == 0) {
		b =  8;
	}

	if ( (b-a) >= 4 || ( (b-a) == 3 && (a & 1) == 1 ) )	nbits = 2;
	else												nbits = 3;

	for ( i=1; i<nbits; i++ )
		AddNextInputBit_Still( decoder);	
  
	if ( decoder->nzeros<MAXMIDDLE-MAXTRAILING || decoder->nonzero==0 ) {
		BitstreamFlushBits_Still( 1);
		nbits ++;
	}

	return;
}


UChar
ArDecodeSymbol_Still(ArDecoder *decoder,U_Int c0)
{
	Int		bit;
	U_Int	c1		= (1<<16) - c0;
	UChar	LPS		= (c0 > c1);
	U_Int	cLPS	= LPS ? c1 : c0;
	U_Int	rLPS;

	rLPS = (decoder -> R >> 16) * cLPS;
	if ( (decoder -> V - decoder -> L) >= (decoder -> R - rLPS) ) {
		bit			  = LPS;
		decoder -> L += decoder -> R - rLPS;
		decoder -> R  = rLPS;
	} else {
		bit			  = (1-LPS);
		decoder -> R -= rLPS;
	}
	DecRenormalize( decoder);

	return (bit);
}


Void
AddNextInputBit_Still(ArDecoder *decoder)
{
	Int		i;

	if ( ((decoder -> arpipe >> (CODE_BITS - 2)) & 1) == 0 ) {
		decoder -> nzeros--;
		if ( decoder -> nzeros == 0 ) {
			BitstreamFlushBits_Still( 1);
			decoder -> extrabits--;
			decoder -> nzeros	= MAXMIDDLE;
			decoder -> nonzero	= 1;
		}
	} else {
		decoder -> nzeros	= MAXMIDDLE;
		decoder -> nonzero	= 1;
	}

	BitstreamFlushBits_Still( 1);

	i = BitstreamLookBit( (CODE_BITS-1+decoder->extrabits));

	decoder -> V		+= decoder -> V + i;
	decoder -> arpipe	+= decoder -> arpipe + i;

	if ( i == 0 ) {
		decoder -> nzerosf--;
		if (decoder -> nzerosf == 0) {
			decoder -> nzerosf = MAXMIDDLE;
			decoder -> extrabits++;
		}
	} else {
		decoder -> nzerosf = MAXMIDDLE;
	}
	return;

}

Void
DecRenormalize(ArDecoder *decoder)
{
	while ( decoder -> R < QUARTER ) {
		if (decoder -> L >= HALF) {
			decoder -> V -= HALF;
			decoder -> L -= HALF;
			decoder -> bits_to_follow = 0;
		} else {
			if (decoder -> L + decoder -> R <= HALF) {
				decoder -> bits_to_follow = 0;
			} else {
				decoder -> V -= QUARTER;
				decoder -> L -= QUARTER;
				(decoder -> bits_to_follow)++;
			}
		}
		decoder -> L += decoder -> L;	
		decoder -> R += decoder -> R;
		AddNextInputBit_Still( decoder );
	}
	return;
}

/*  Bitstream Operation Functions */

/* SAIT_V2 begin : added by Samsung AIT (99/02/23) */
BSS *
AllocBitstream(Int size)
{
  	BSS *bitstream;

  	bitstream = (BSS *)malloc(sizeof(BSS));
  	if(bitstream==NULL) {
      		fprintf(stderr,"Memory allocation failed\n");
      		exit(0);
  	}
  	bitstream->bs = (UChar *)malloc(sizeof(UChar)*size);
  	if(bitstream->bs==NULL) {
      		fprintf(stderr,"Memory allocation failed\n");
      		exit(0);
  	}
  	/* clear the output buffer */
  	memset(bitstream->bs, (UChar )0, size);

	return bitstream;
}
Void
FreeBitstream(BSS *bitstream)
{
	free(bitstream->bs);
	free(bitstream);
	bitstream = NULL;
}
/* SAIT_V2 end */

Void
InitBitstream(Int flag,BSS *bitstream)
{
	bitstream -> ptr = bitstream->bs;
	bitstream -> cnt = 0;
	bitstream -> res = 0;
	if ( flag == 1 )
	*bitstream -> ptr = (UChar)0;
}

Int
ByteAlignmentEnc()
{
  flush_bits();
  return(0);
}

/* SAIT_V2 begin : added by Samsung AIT (99/02/23) */
Int
ByteAlignmentEncCopy(BSS *bitstream)
{
/*  flush_bits(); */
  Int stored_bit_rate = get_total_bit_rate();
  Int i=(stored_bit_rate+bitstream->cnt)%8;
  UShort        usflush;

  usflush = (0x7F >> i);
  PutBitstoStream(8-i,usflush,bitstream);
  return(0);
}
/* SAIT_V2 end */

Int
ByteAlignmentDec()
{
  align_byte();
  return(0);
}

Void
PutBitstoStream(Int bits,U_Int code,BSS *bitstream)
{
	UChar	*p	= bitstream -> ptr;
	Int		res	= bitstream -> res;
	bitstream -> cnt += bits;
	while ( bits > 0 ) {
		*p |= (UChar) ( ((code >> (bits-1)) & 1) << (7-res) );
		res ++;
		bits--;
		if ( res == 8 ) {
			*(++p) = (UChar)0;
			res    = 0;
		}
	}
	bitstream -> ptr  = p;
	bitstream -> res  = res;

	return;
}
Void
PutBitstoStreamMerge(Int bits,U_Int code)
{
  while(bits>16) {
    emit_bits((UShort)(code>>(bits-16)), 16);
    bits-=16;
  }
  
  emit_bits((UShort)code, bits);
  return;
}

Void
BitstreamFlushBits_Still(Int i)
{
  get_X_bits(i);
  return;
}


Int
BitstreamLookBit(Int pos)
{
  return((Int )(LookBitFromStream(pos) &1 ) );
}

U_Int
GetBitsFromStream(Int bits)
{
  U_Int code;
  code = get_X_bits(bits);
  return ( code );
}

Void
BitstreamFlushBitsCopy(Int i,BSS *bitstream)
{
	Int		mdl = 0;
	Int		res = bitstream -> res + i;

	while ( res >= 8 ) {
		mdl ++;
		res -= 8;
	}
	bitstream -> ptr	+= mdl;
	bitstream -> cnt	+= i;
	bitstream -> res	 = res;

	return;
}

Int
BitstreamLookBitCopy(Int pos,BSS *bitstream)
{
	UChar	*ptr = bitstream -> ptr;
	Int		res  = bitstream -> res + pos - 1;

	while ( res >= 8 ) {
		ptr ++;
		res -= 8;
	}

	return( (Int)( ( (*ptr) >> (7 - res) ) & 1 ) );
}

U_Int
LookBitsFromStreamCopy(Int bits,BSS *bitstream)
{
    Int	i;
    U_Int code=0;

    for ( i=1; i<=bits; i++ ) {
        code = (code << 1) + ( BitstreamLookBitCopy( i, bitstream ) & 1 );
    }
    return ( code );
}

U_Int
LookBitsFromStream(Int bits)
{
    Int	i;
    U_Int code=0;

    for ( i=1; i<=bits; i++ ) {
        code = (code << 1) + ( BitstreamLookBit(i) & 1 );
    }
    return ( code );
}

U_Int
GetBitsFromStreamCopy(Int bits,BSS *bitstream)
{
    U_Int code;
    code = LookBitsFromStreamCopy(bits,bitstream);
    BitstreamFlushBitsCopy(bits,bitstream);
    return ( code );
}

Void
BitStreamCopy(Int cnt,BSS *bitstream1,BSS *bitstream2)
{
    U_Int code;
    Int	bits;

    while ( cnt>=32 ) {
        bits  = 32;
        code  = GetBitsFromStreamCopy ( bits, bitstream1 );
                PutBitstoStream   ( bits, code, bitstream2 );
        cnt  -= 32;
    }
    if ( cnt>0 ) {
        code  = GetBitsFromStreamCopy ( cnt, bitstream1 );
                PutBitstoStream   ( cnt, code, bitstream2 );
    }

    return;
}

Void
BitStreamMerge(Int cnt,BSS *bitstream)
{
  U_Int code;
  Int	bits;

  while ( cnt>=32 ) {
    bits  = 32;
    code  = GetBitsFromStreamCopy ( bits, bitstream );
    PutBitstoStreamMerge  ( bits, code);
    cnt  -= 32;
  }
  if ( cnt>0 ) {
        code  = GetBitsFromStreamCopy ( cnt, bitstream );
	PutBitstoStreamMerge   ( cnt, code );
  }

  return;
}



