/* $Id: ztscan.h,v 1.13 1998/09/25 13:17:22 hatrack Exp $ */
/****************************************************************************/
/*   MPEG4 Visual Texture Coding (VTC) Mode Software                        */
/*                                                                          */
/*   This software was jointly developed by the following participants:     */
/*                                                                          */
/*   Single-quant,  multi-quant and flow control                            */
/*   are provided by  Sarnoff Corporation                                   */
/*     Iraj Sodagar   (iraj@sarnoff.com)                                    */
/*     Hung-Ju Lee    (hjlee@sarnoff.com)                                   */
/*     Paul Hatrack   (hatrack@sarnoff.com)                                 */
/*     Shipeng Li     (shipeng@sarnoff.com)                                 */
/*     Bing-Bing Chai (bchai@sarnoff.com)                                   */
/*     B.S. Srinivas  (bsrinivas@sarnoff.com)                               */
/*                                                                          */
/*   Bi-level is provided by Texas Instruments                              */
/*     Jie Liang      (liang@ti.com)                                        */
/*                                                                          */
/*   Shape Coding is provided by  OKI Electric Industry Co., Ltd.           */
/*     Zhixiong Wu    (sgo@hlabs.oki.co.jp)                                 */
/*     Yoshihiro Ueda (yueda@hlabs.oki.co.jp)                               */
/*     Toshifumi Kanamaru (kanamaru@hlabs.oki.co.jp)                        */
/*                                                                          */
/*   OKI, Sharp, Sarnoff, TI and Microsoft contributed to bitstream         */
/*   exchange and bug fixing.                                               */
/*                                                                          */
/*                                                                          */
/* In the course of development of the MPEG-4 standard, this software       */
/* module is an implementation of a part of one or more MPEG-4 tools as     */
/* specified by the MPEG-4 standard.                                        */
/*                                                                          */
/* The copyright of this software belongs to ISO/IEC. ISO/IEC gives use     */
/* of the MPEG-4 standard free license to use this  software module or      */
/* modifications thereof for hardware or software products claiming         */
/* conformance to the MPEG-4 standard.                                      */
/*                                                                          */
/* Those intending to use this software module in hardware or software      */
/* products are advised that use may infringe existing  patents. The        */
/* original developers of this software module and their companies, the     */
/* subsequent editors and their companies, and ISO/IEC have no liability    */
/* and ISO/IEC have no liability for use of this software module or         */
/* modification thereof in an implementation.                               */
/*                                                                          */
/* Permission is granted to MPEG members to use, copy, modify,              */
/* and distribute the software modules ( or portions thereof )              */
/* for standardization activity within ISO/IEC JTC1/SC29/WG11.              */
/*                                                                          */
/* Copyright 1995, 1996, 1997, 1998 ISO/IEC                                 */
/****************************************************************************/

/************************************************************/
/*     Sarnoff Very Low Bit Rate Still Image Coder          */
/*     Copyright 1995, 1996, 1997, 1998 Sarnoff Corporation */
/************************************************************/

/************************************************************/
/*  Filename: ztscan.h                                      */
/*  Author: Bing-Bing Chai                                  */
/*  Date: January 29, 1998                                  */
/*                                                          */
/*  Descriptions:                                           */
/*    This is the header file for both ztscan_enc.c and     */
/*    ztscan_dec.c. Which contains the functions that will  */
/*    be called by functions in other files.                */
/*                                                          */
/************************************************************/
#ifndef _ZTSCAN_
#define _ZTSCAN_

/* function prototype declarations */
#ifdef _DECLARE_PROTOTYPES_

/* encoding routines */
extern Void wavelet_dc_encode(Int c);
extern Void wavelet_higher_bands_encode_SQ_band(Int col);
extern Void wavelet_higher_bands_encode_SQ_tree();
extern Void wavelet_higher_bands_encode_MQ(Int scanDirection);
extern Void init_acm_maxf_enc();
/* decoding routines */
extern Void wavelet_dc_decode(Int c);
extern Void wavelet_higher_bands_decode_SQ_band(Int col);
extern Void wavelet_higher_bands_decode_SQ_tree();
extern Void wavelet_higher_bands_decode_MQ(Int scanDirection);
extern Void init_acm_maxf_dec();


#else _DECLARE_PROTOTYPES_

#include "ztscan_enc.p"
#include "ztscan_dec.p"

#endif _DECLARE_PROTOTYPES_

#endif 
