/****************************************************************************/
/*   MPEG4 Visual Texture Coding (VTC) Mode Software                        */
/*                                                                          */
/*   This software was jointly developed by the following participants:     */
/*                                                                          */
/*   Single-quant,  multi-quant and flow control                            */
/*   are provided by  Sarnoff Corporation                                   */
/*     Iraj Sodagar   (iraj@sarnoff.com)                                    */
/*     Hung-Ju Lee    (hjlee@sarnoff.com)                                   */
/*     Paul Hatrack   (hatrack@sarnoff.com)                                 */
/*     Shipeng Li     (shipeng@sarnoff.com)                                 */
/*     Bing-Bing Chai (bchai@sarnoff.com)                                   */
/*     B.S. Srinivas  (bsrinivas@sarnoff.com)                               */
/*                                                                          */
/*   Bi-level is provided by Texas Instruments                              */
/*     Jie Liang      (liang@ti.com)                                        */
/*                                                                          */
/*   Shape Coding is provided by  OKI Electric Industry Co., Ltd.           */
/*     Zhixiong Wu    (sgo@hlabs.oki.co.jp)                                 */
/*     Yoshihiro Ueda (yueda@hlabs.oki.co.jp)                               */
/*     Toshifumi Kanamaru (kanamaru@hlabs.oki.co.jp)                        */
/*                                                                          */
/*   OKI, Sharp, Sarnoff, TI and Microsoft contributed to bitstream         */
/*   exchange and bug fixing.                                               */
/*                                                                          */
/*                                                                          */
/* In the course of development of the MPEG-4 standard, this software       */
/* module is an implementation of a part of one or more MPEG-4 tools as     */
/* specified by the MPEG-4 standard.                                        */
/*                                                                          */
/* The copyright of this software belongs to ISO/IEC. ISO/IEC gives use     */
/* of the MPEG-4 standard free license to use this  software module or      */
/* modifications thereof for hardware or software products claiming         */
/* conformance to the MPEG-4 standard.                                      */
/*                                                                          */
/* Those intending to use this software module in hardware or software      */
/* products are advised that use may infringe existing  patents. The        */
/* original developers of this software module and their companies, the     */
/* subsequent editors and their companies, and ISO/IEC have no liability    */
/* and ISO/IEC have no liability for use of this software module or         */
/* modification thereof in an implementation.                               */
/*                                                                          */
/* Permission is granted to MPEG members to use, copy, modify,              */
/* and distribute the software modules ( or portions thereof )              */
/* for standardization activity within ISO/IEC JTC1/SC29/WG11.              */
/*                                                                          */
/* Copyright 1995, 1996, 1997, 1998 ISO/IEC                                 */
/****************************************************************************/

#ifndef _SHAPE_DEF_H_
#define _SHAPE_DEF_H_
#include	<limits.h>
/*#include	"BinArCodec.h"*/

#define		ALL0			0
#define		ALL255			1
#define		BORDER			2

#define		CR1_1			2
#define		CR1_2			3
#define		CR1_4			4

/* SAIT_V2 begin : added by Samsung AIT (99/02/23) */
#define         TEXTURE_SPATIAL_START_CODE      (0x1BF)
#define         TEXTURE_SHAPE_START_CODE        0x1C2/*(0x1C1)*/	/* modified by D.-S.Cho, Samsung AIT (99/04/13) */
#define         MARKER_BIT                      1

#define		BBORDER			1
#define		MBORDER      		2

#define		TRANSITIONAL		0
#define		EXCEPTIONAL		1
/* SAIT_V2 end */

/**************  Code Book for shape MMR coding  ******************/

extern Int	LMMR_first_shape_code_I [81][3];
extern U_Int	CMMR_first_shape_code_I [81][3];
extern Int 	LCR[5];
extern U_Int 	CCR[5];
extern Int 	LST;

/*  Probability Tables for Shape Coding (CAE)  */
extern U_Int	intra_prob[1024];

/* SAIT_V2 begin : added by Samsung AIT (99/02/23) */

/*  Probability Tables for Enhancement Layer Shape Coding (SI)  */
/* Proability Tables for Shape Mode Coding */
extern U_Int	SI_bab_type_prob[1];
extern U_Int	sto_SI_bab_type_prob_even[1];

/* Probability Tables of Context for Transitional BAB */
/* Vertical Scanning Case of SI */
extern U_Int 	si_intra_vs_prob[128];

/* Horizontal Scanning Case of SI */
extern U_Int 	si_intra_hs_prob[128];

/* Probability Tables of Context for Exceptional BAB */
extern U_Int sto_enh_odd_prob0[256];
extern U_Int sto_enh_even_prob0[256];
extern U_Int sto_enh_odd_prob1[256];
extern U_Int sto_enh_even_prob1[256];
/* SAIT_V2 end */

/* SAIT_V2 begin : added by Samsung AIT (99/02/23) */
/* Probability model for bab type (0-odd, 1-even) */
extern  UInt scalable_bab_type_prob[2];
 
/* Probability model for P1 pixel of Interleaved Scan-Line (ISL) coding */
extern  UInt scalable_xor_prob_1[128];
 
/* Probability model for P2/P3 pixels of Interleaved Scan-Line (ISL) coding */
extern  UInt scalable_xor_prob_23[128];

/* Probability model for Raster Scan-Line (RSL) coding (odd filter) */
extern  UInt scalable_full_odd_prob[256];

/* Probability model for Raster Scan-Line (RSL) coding (even filter) */
extern  UInt scalable_full_even_prob[256];
/* SAIT_V2 end */

#endif
