/*****************************************************************************
 *
 * This software module was originally developed by
 *
 *   Noel Brady (Teltec DCU / ACTS-MoMuSyS)
 *   Michael Wollborn (TUH / ACTS-MoMuSyS)
 *
 * and edited by
 * 
 *   Robert Danielsen (Telenor / ACTS-MoMuSyS)
 *
 * in the course of development of the MPEG-4 Video (ISO/IEC 14496-2) standard.
 * This software module is an implementation of a part of one or more MPEG-4
 * Video (ISO/IEC 14496-2) tools as specified by the MPEG-4 Video (ISO/IEC
 * 14496-2) standard.
 *
 * ISO/IEC gives users of the MPEG-4 Video (ISO/IEC 14496-2) standard free
 * license to this software module or modifications thereof for use in hardware
 * or software products claiming conformance to the MPEG-4 Video (ISO/IEC
 * 14496-2) standard.
 *
 * Those intending to use this software module in hardware or software products
 * are advised that its use may infringe existing patents. The original
 * developer of this software module and his/her company, the subsequent
 * editors and their companies, and ISO/IEC have no liability for use of this
 * software module or modifications thereof in an implementation. Copyright is
 * not released for non MPEG-4 Video (ISO/IEC 14496-2) Standard conforming
 * products.
 *
 * ACTS-MoMuSys partners retain full right to use the code for his/her own
 * purpose, assign or donate the code to a third party and to inhibit third
 * parties from using the code for non MPEG-4 Video (ISO/IEC 14496-2) Standard
 * conforming products. This copyright notice must be included in all copies or
 * derivative works.
 *
 * Copyright (c) 1996
 *
 *****************************************************************************/

/***********************************************************HeaderBegin*******
 *                                                                         
 * File:	mom_image.h
 *
 * Author:	Noel Brady
 * Created:	20-Feb-96    
 *                                                                         
 * Description: 
 *
 * Notes: 	
 *
 * Modified:	21.04.96 Robert Danielsen: New header.
 *
 ***********************************************************HeaderEnd*********/

#ifndef _MOM_IMAGE_H_
#define _MOM_IMAGE_H_

   #   ifdef __cplusplus
       extern "C" {
   #   endif /* __cplusplus */

#include "momusys.h"



   #   ifdef __cplusplus
       }
   #   endif /* __cplusplus  */ 

#include "mom_image.p"

#endif
/*****************************************************************************/
/* CREATED BY :  Michael Wollborn -- 27-Feb-96                               */
/*****************************************************************************/
/***********/
/* HISTORY */
/***********/
/*
 * $Log: mom_image.h,v $
 * Revision 6.0  1997/03/18 09:56:26  rid
 * VM 6.0 pre-release
 *
 * Revision 6.0  1997/02/27 06:48:31  rid
 * VM 6.0 pre-release
 *
 * Revision 5.0  1997/02/11 20:00:00  rid
 * VM 5.0 pre-release
 *
 * Revision 2.0  1997/02/02 10:33:17  sand
 * VM 5.0 pre-release
 *
 * Revision 1.0  1997/01/31 08:13:47  sand
 * VM 5.0 pre-release
 *
 * Revision 4.1  1997/01/28 09:47:38  rid
 * VM 3.1 pre-release
 *
 * Revision 4.1  1997/01/24 08:21:04  rid
 * VM 3.1 pre-release
 *
 * Revision 4.1  1997/01/14 10:05:33  rid
 * VM 3.1 pre-release
 *
 * Revision 4.0  1996/11/08 07:41:09  rid
 * VM 3.1 pre-release
 *
 *
 */

/*****************************************************************************/


/*****
*
*     This is the header file for the TUH toolbox functions.
*     This file should be included in each source file where
*     the toolbox functions are used. Since all required prototypes 
*     are included here, only this file must be included, not
*     the ".proto" file.
*
*     V 1.00 / 07-FEB-1996 / TUH (M. Wollborn)
*
*****/

#ifndef _TUH_TOOLBOX_H
#define _TUH_TOOLBOX_H

   #   ifdef __cplusplus
       extern "C" {
   #   endif /* __cplusplus */

#define MAX_UCHAR_VAL	255
#define MAX_SHORT_VAL	32767
#define MAX_FLOAT_VAL	2000000000

#ifndef SIGN0
#define SIGN0(a)    	( ((a)<0) ? -1 : (((a)>0) ? 1  : 0) )
#endif

#ifndef SIGN
#define SIGN(a)         ((a)<0 ? (-1) : (1))
#endif

#ifndef ROUND
#define ROUND(x)        ( (Int) ((x) + SIGN0(x)*0.5) )
#endif

#include "mom_structs.h"
/* #include "alp_code.h" */
#include "mom_image.p"


   #   ifdef __cplusplus
       }
   #   endif /* __cplusplus  */ 

#endif  /* ifndef _TUH_TOOLBOX_H */
