/* $Id: main.h,v 1.12 1998/07/17 21:59:12 shipeng Exp $ */
/****************************************************************************/
/*   MPEG4 Visual Texture Coding (VTC) Mode Software                        */
/*                                                                          */
/*   This software was jointly developed by the following participants:     */
/*                                                                          */
/*   Single-quant,  multi-quant and flow control                            */
/*   are provided by  Sarnoff Corporation                                   */
/*     Iraj Sodagar   (iraj@sarnoff.com)                                    */
/*     Hung-Ju Lee    (hjlee@sarnoff.com)                                   */
/*     Paul Hatrack   (hatrack@sarnoff.com)                                 */
/*     Shipeng Li     (shipeng@sarnoff.com)                                 */
/*     Bing-Bing Chai (bchai@sarnoff.com)                                   */
/*     B.S. Srinivas  (bsrinivas@sarnoff.com)                               */
/*                                                                          */
/*   Bi-level is provided by Texas Instruments                              */
/*     Jie Liang      (liang@ti.com)                                        */
/*                                                                          */
/*   Shape Coding is provided by  OKI Electric Industry Co., Ltd.           */
/*     Zhixiong Wu    (sgo@hlabs.oki.co.jp)                                 */
/*     Yoshihiro Ueda (yueda@hlabs.oki.co.jp)                               */
/*     Toshifumi Kanamaru (kanamaru@hlabs.oki.co.jp)                        */
/*                                                                          */
/*   OKI, Sharp, Sarnoff, TI and Microsoft contributed to bitstream         */
/*   exchange and bug fixing.                                               */
/*                                                                          */
/*                                                                          */
/* In the course of development of the MPEG-4 standard, this software       */
/* module is an implementation of a part of one or more MPEG-4 tools as     */
/* specified by the MPEG-4 standard.                                        */
/*                                                                          */
/* The copyright of this software belongs to ISO/IEC. ISO/IEC gives use     */
/* of the MPEG-4 standard free license to use this  software module or      */
/* modifications thereof for hardware or software products claiming         */
/* conformance to the MPEG-4 standard.                                      */
/*                                                                          */
/* Those intending to use this software module in hardware or software      */
/* products are advised that use may infringe existing  patents. The        */
/* original developers of this software module and their companies, the     */
/* subsequent editors and their companies, and ISO/IEC have no liability    */
/* and ISO/IEC have no liability for use of this software module or         */
/* modification thereof in an implementation.                               */
/*                                                                          */
/* Permission is granted to MPEG members to use, copy, modify,              */
/* and distribute the software modules ( or portions thereof )              */
/* for standardization activity within ISO/IEC JTC1/SC29/WG11.              */
/*                                                                          */
/* Copyright 1995, 1996, 1997, 1998 ISO/IEC                                 */
/****************************************************************************/

/************************************************************/
/*     Sarnoff Very Low Bit Rate Still Image Coder          */
/*     Copyright 1995, 1996, 1997, 1998 Sarnoff Corporation */
/************************************************************/

#ifndef _MAIN_H_
#define _MAIN_H_

#ifndef _DATA_STRUCT_H_
#include "dataStruct.h"
#endif _DATA_STRUCT_H


/* function protottype declarations */
#ifdef _DECLARE_PROTOTYPES_

/*--- read_control_file.c ---*/
Void read_control_file(Char *ctlfname, SOL_PARAMETERS *vm_param);
Void read_control_file_dec(Char *ctlfname, SOL_PARAMETERS_DEC *vm_param);
Void free_vm_param( SOL_PARAMETERS *vm_param);
Void free_vm_param_dec( SOL_PARAMETERS_DEC *vm_param_dec);

/*--- read_image.c ---*/
Void read_image(Char *img_path, Int img_width, Int img_height, 
		Int img_colors, Int img_bit_depth,
		PICTURE *img);

/*--- write_image.c ---*/
Void write_image(Char *recImgFile, Int colors,
		 Int width, Int height,
		 Int real_width, Int real_height,
		 Int rorigin_x, Int rorigin_y,
		 UChar *outimage[3], UChar *outmask[3],
		 Int usemask,
		Int STO_const_alpha,   /* SAIT_V2: added by Samsung AIT (99/02/23) */
		UChar STO_const_alpha_value, /* SAIT_V2: added by Samsung AIT (99/02/23) */
		 Int fullsize, Int MinLevel);

/*--- seg.c ---*/
Int read_segimage(Char *seg_path, Int seg_width, Int seg_height, 
		  Int img_colors, 
		  PICTURE *image);

/* begin : modified by D.-S.Cho, Samsung AIT (99/04/13) */
/*
Void get_virtual_image(PICTURE *Image, Int wvtDecompLev, 
		       Int usemask, Int colors, Int alphaTH, 
		       Int change_CR_disable, FILTER *filter);
Void get_virtual_mask(PICTURE *Image, Int wvtDecompLev, 
		      Int w, Int h, Int usemask, Int colors, FILTER **filters);
*/
Void get_virtual_image(PICTURE *Image, Int wvtDecompLev, 
		       Int usemask, Int colors, Int alphaTH, 
		       Int change_CR_disable, 
		       Int STO_const_alpha,
		       Int STO_const_alpha_value,
		       FILTER *filter);
Void get_virtual_mask(PICTURE *Image, Int wvtDecompLev, 
		      Int w, Int h, Int usemask, Int colors, 
		      Int *target_levels,
		      Int startCodeEnable,
		      FILTER **filters);
Void get_virtual_mask_V1(PICTURE *Image, Int wvtDecompLev, 
		      Int w, Int h, Int usemask, Int colors, FILTER **filters);
/* end : added by D.-S.Cho, Samsung AIT (99/04/13) */

/*--- wavelet.c ---*/
Void choose_wavelet_filter(FILTER **anafilter,FILTER **synfilter,
			   Int type);
Void perform_DWT(FILTER **wvtfilter);
Void perform_layer_IDWT(Int spa_lev, Int snr_lev, Int usemask, Int colors,
			Int wvtDecompLev,  FILTER **wvtfilter, Int fullsize,
			Char *recImgFile);
Void perform_IDWT(SOL_PARAMETERS_DEC *vm_param, FILTER **wvtfilter,
		  Char *recImgFile);

/*--- computePSNR.c ---*/
Void ComputePSNR(UChar *orgY, UChar *recY, 
		 UChar *maskY,
		 UChar *orgU, UChar *recU, 
		 UChar *maskU,
		 UChar *orgV, UChar *recV, 
		 UChar *maskV,
		 Int width, Int height, Int stat);

#else _DECLARE_PROTOTYPES_

#include "read_control_file.p"
#include "read_image.p"
#include "write_image.p"
#include "seg.p"
#include "wavelet.p"
#include "computePSNR.p"

#include "vm_config.h"
#include "main.p"

#endif _DECLARE_PROTOTYPES_

#endif _MAIN_H_
