/* $Id: dwt.h,v 1.13 1998/07/17 22:01:13 shipeng Exp $ */
/****************************************************************************/
/*   MPEG4 Visual Texture Coding (VTC) Mode Software                        */
/*                                                                          */
/*   This software was jointly developed by the following participants:     */
/*                                                                          */
/*   Single-quant,  multi-quant and flow control                            */
/*   are provided by  Sarnoff Corporation                                   */
/*     Iraj Sodagar   (iraj@sarnoff.com)                                    */
/*     Hung-Ju Lee    (hjlee@sarnoff.com)                                   */
/*     Paul Hatrack   (hatrack@sarnoff.com)                                 */
/*     Shipeng Li     (shipeng@sarnoff.com)                                 */
/*     Bing-Bing Chai (bchai@sarnoff.com)                                   */
/*     B.S. Srinivas  (bsrinivas@sarnoff.com)                               */
/*                                                                          */
/*   Bi-level is provided by Texas Instruments                              */
/*     Jie Liang      (liang@ti.com)                                        */
/*                                                                          */
/*   Shape Coding is provided by  OKI Electric Industry Co., Ltd.           */
/*     Zhixiong Wu    (sgo@hlabs.oki.co.jp)                                 */
/*     Yoshihiro Ueda (yueda@hlabs.oki.co.jp)                               */
/*     Toshifumi Kanamaru (kanamaru@hlabs.oki.co.jp)                        */
/*                                                                          */
/*   OKI, Sharp, Sarnoff, TI and Microsoft contributed to bitstream         */
/*   exchange and bug fixing.                                               */
/*                                                                          */
/*                                                                          */
/* In the course of development of the MPEG-4 standard, this software       */
/* module is an implementation of a part of one or more MPEG-4 tools as     */
/* specified by the MPEG-4 standard.                                        */
/*                                                                          */
/* The copyright of this software belongs to ISO/IEC. ISO/IEC gives use     */
/* of the MPEG-4 standard free license to use this  software module or      */
/* modifications thereof for hardware or software products claiming         */
/* conformance to the MPEG-4 standard.                                      */
/*                                                                          */
/* Those intending to use this software module in hardware or software      */
/* products are advised that use may infringe existing  patents. The        */
/* original developers of this software module and their companies, the     */
/* subsequent editors and their companies, and ISO/IEC have no liability    */
/* and ISO/IEC have no liability for use of this software module or         */
/* modification thereof in an implementation.                               */
/*                                                                          */
/* Permission is granted to MPEG members to use, copy, modify,              */
/* and distribute the software modules ( or portions thereof )              */
/* for standardization activity within ISO/IEC JTC1/SC29/WG11.              */
/*                                                                          */
/* Copyright 1995, 1996, 1997, 1998 ISO/IEC                                 */
/****************************************************************************/

/************************************************************/
/*     Sarnoff Very Low Bit Rate Still Image Coder          */
/*     Copyright 1995, 1996, 1997, 1998 Sarnoff Corporation */
/************************************************************/

/* DWT and inverse DWT header file 
   Created by Shipeng Li, Sarnoff Corporation, Jan. 1998
   Copyright (c) Sarnoff Corporation
*/
#ifndef _DWT_H_
#define _DWT_H_
#define UChar UChar

#ifdef DATA
#undef DATA
#endif
#define DATA Int  
#ifdef INT
#undef INT
#endif
#define INT Int

#define ROUNDDIV(x, y) ((x)>0?(Int)(((Int)(x)+((y)>>1))/(y)):(Int)(((Int)(x)-((y)>>1)) /(y)))
enum {  /* DWT or IDWT return values */
  DWT_OK,
  DWT_FILTER_UNSUPPORTED,
  DWT_MEMORY_FAILED,
  DWT_COEFF_OVERFLOW,
  DWT_INVALID_LEVELS,
  DWT_INVALID_WIDTH,
  DWT_INVALID_HEIGHT,
  DWT_INTERNAL_ERROR,
  DWT_NOVALID_PIXEL
};

/* begin: modified for bug fixing by Samsung AIT (1999-12-17) */
/*
#ifdef RECTANGULAR
#undef RECTANGULAR
#endif
#define RECTANGULAR -1
*/
#define RECTANGLE -1
/* end: modified for bug fixing by Samsung AIT (1999-12-17) */

/* Image data type */
enum { 
  UCHAR_ENUM,
  USHORT_ENUM
};
enum { /* filter class */
  ODD_SYMMETRIC,
  EVEN_SYMMETRIC,
  ORTHORGONAL
};

enum {
  EVEN,
  ODD
};

enum {
  HORIZONTAL,
  VERTICAL
};

enum {
  NONZERO_HIGH,
  ZERO_HIGH,
  ALL_ZERO
};

#define  OUT0 0
#define  IN   1
#define  OUT1 2
#define  OUT2 3
#define  OUT3 4

enum { /* filter type */
  INT_TYPE,
  DBL_TYPE
};

typedef struct {
  INT Class; 
  /* 0: Odd Symmetric 1: Even Symmetric 2: Orthogonal (not supported)
   Note: This is not defined by MPEG4-CD syntax but should be, since different 
   wavelets corresponds to different extension. 
   Ref. "Shape Adpative Discrete Wavelet Transform for Arbitrarily-Shaped 
   Visual Object Coding" S. Li and W. Li (submitted to IEEE T-CSVT) 
   */
  INT Type;
  /* 0: Short Coeff; 1: Double Coeff */
  INT HPLength;
  INT LPLength;
  Void *HPCoeff;
  Void *LPCoeff;
  INT Scale;
} FILTER;


/* function prototype declarations */
#ifdef _DECLARE_PROTOTYPES_

/* Mask Decomposition function used by Decoder */
INT do_DWTMask(UChar *InMask, UChar *OutMask, INT Width, INT Height, 
	     INT nLevels, FILTER **Filter);
/* SAIT_V2 begin: added by Samsung AIT (99/02/23) */
/* Mask Synthesis function used by decoder */
Int do_iDWTMask(UChar *InMask, UChar *OutMask, Int Width,
               Int Height, Int curlevel, Int dstlevel, FILTER **filter, Int UpdateInput,
               Int FullSizeOut);
Int SynthesizeMaskHalfLevel(UChar *OutMask, Int Width,
                                  Int Height, Int level, FILTER *Filter,
                                  Int ZeroHigh, Int Direction);
/* SAIT_V2 end */
/* Wavelet Decomposition function used by encoder */
INT do_DWT(Void *InData, UChar *InMask, INT Width, INT Height, INT nLevels,
	 INT InDataType, FILTER **Filter,  DATA *OutCoeff, UChar *OutMask);
/* Wavelet Synthesis function used by decoder */
INT do_iDWT(DATA *InCoeff, UChar *InMask, INT Width, INT Height, INT CurLevel, 
	  INT DstLevel, INT OutDataType, FILTER **Filter, Void *OutData, 
	  UChar *OutMask, INT UpdateInput, INT FullSizeOut); 
/* Remove DC Mean */
INT RemoveDCMean(DATA *Coeff, UChar *Mask, INT Width, INT Height, INT nLevels, INT Tiling); /* modified by Sharp (99/2/16) */
/* Addback DC Mean */
Void AddDCMean(DATA *Coeff, UChar *Mask, INT Width, 
	       INT Height, INT nLevels, INT DCMean);
INT GetBox(Void *InImage, Void **OutImage, 
	   INT RealWidth, INT RealHeight, 
	   INT VirtualWidth, INT VirtualHeight, 
	   INT OriginX, INT OriginY, INT DataType);
INT GetMaskBox(UChar *InMask,  UChar **OutMask, 
	       INT RealWidth, INT RealHeight, 
	       INT Nx, INT Ny,
	       INT *VirtualWidth, INT *VirtualHeight, 
	       INT *OriginX, INT *OriginY,  INT Shape, INT nLevels);
INT PutBox(Void *InImage, UChar *InMask, Void *OutImage, UChar *OutMask, 
	   INT RealWidth, INT RealHeight, 
	   INT VirtualWidth, INT VirtualHeight, 
	   INT OriginX, INT OriginY, INT DataType, INT Shape, INT OutValue);
Void  SubsampleMask(UChar *InMask, UChar **OutMask, 
		    INT Width, INT Height,
		    FILTER *filter);
INT ExtendMaskBox(UChar *InMask,  UChar **OutMask, 
		  INT InWidth, INT InHeight, 
		  INT Nx, INT Ny,
		  INT *OutWidth, INT *OutHeight, 
		  INT nLevels);

#else _DECLARE_PROTOTYPES_

#include "dwt.p"

#endif _DECLARE_PROTOTYPES_


#endif /*_DWT_H_ */
