/****************************************************************************/
/*   MPEG4 Visual Texture Coding (VTC) Mode Software                        */
/*                                                                          */
/*   This software was jointly developed by the following participants:     */
/*                                                                          */
/*   Single-quant,  multi-quant and flow control                            */
/*   are provided by  Sarnoff Corporation                                   */
/*     Iraj Sodagar   (iraj@sarnoff.com)                                    */
/*     Hung-Ju Lee    (hjlee@sarnoff.com)                                   */
/*     Paul Hatrack   (hatrack@sarnoff.com)                                 */
/*     Shipeng Li     (shipeng@sarnoff.com)                                 */
/*     Bing-Bing Chai (bchai@sarnoff.com)                                   */
/*     B.S. Srinivas  (bsrinivas@sarnoff.com)                               */
/*                                                                          */
/*   Bi-level is provided by Texas Instruments                              */
/*     Jie Liang      (liang@ti.com)                                        */
/*                                                                          */
/*   Shape Coding is provided by  OKI Electric Industry Co., Ltd.           */
/*     Zhixiong Wu    (sgo@hlabs.oki.co.jp)                                 */
/*     Yoshihiro Ueda (yueda@hlabs.oki.co.jp)                               */
/*     Toshifumi Kanamaru (kanamaru@hlabs.oki.co.jp)                        */
/*                                                                          */
/*   Scalable shape coding is provided by Samsung AIT                       */
/*     Dae-Sung Cho (dscho@sait.samsung.co.kr)                              */
/*     Se-Hoon Son (shson@sait.samsung.co.kr)                               */
/*                                                                          */
/*   OKI, Sharp, Sarnoff, TI and Microsoft contributed to bitstream         */
/*   exchange and bug fixing.                                               */
/*                                                                          */
/*                                                                          */
/* In the course of development of the MPEG-4 standard, this software       */
/* module is an implementation of a part of one or more MPEG-4 tools as     */
/* specified by the MPEG-4 standard.                                        */
/*                                                                          */
/* The copyright of this software belongs to ISO/IEC. ISO/IEC gives use     */
/* of the MPEG-4 standard free license to use this  software module or      */
/* modifications thereof for hardware or software products claiming         */
/* conformance to the MPEG-4 standard.                                      */
/*                                                                          */
/* Those intending to use this software module in hardware or software      */
/* products are advised that use may infringe existing  patents. The        */
/* original developers of this software module and their companies, the     */
/* subsequent editors and their companies, and ISO/IEC have no liability    */
/* and ISO/IEC have no liability for use of this software module or         */
/* modification thereof in an implementation.                               */
/*                                                                          */
/* Permission is granted to MPEG members to use, copy, modify,              */
/* and distribute the software modules ( or portions thereof )              */
/* for standardization activity within ISO/IEC JTC1/SC29/WG11.              */
/*                                                                          */
/* Copyright 1995, 1996, 1997, 1998 ISO/IEC                                 */
/****************************************************************************/

#ifndef _SHAPE_CODEC_H
#define _SHAPE_CODEC_H
#include <stdlib.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* SAIT_V2 begin: added by Samsung AIT (99/02/23) */
#include "ShapeCommon.h"
#include "BinArCodec.h"
#include "dwt.h"
/* SAIT_V2 end */

/* function prototype declarations */
#ifdef _DECLARE_PROTOTYPES_

/* SAIT_V2 begin: added by Samsung AIT (99/02/23) */
  /* shape/src/ShapeEnCoding.c */
/* begin: added by Samsung AIT (99/04/13) */
Int ShapeEnCoding_V1(UChar *inmask, 
			Int object_width, 
			Int object_height,
			Int alphaTH, 
			Int change_CR_disable,
			Int constAlpha,
			UChar constAlphaValue
		);
/* end: added by Samsung AIT (99/04/13) */
Int ShapeEnCoding(UChar *inmask, 
			Int width, 
			Int height,
			Int levels,
			Int alphaTH, 
			Int change_CR_disable,
			Int constAlpha,
			UChar constAlphaValue,
			Int shapeScalable,
			Int startCodeEnable,
			FILTER **filter
		);
Int EncodeShapeHeader(Int change_CR_disable,
			Int constAlpha,
			UChar constAlphaValue,
			Int shapeScalable,
			BSS *shape_bitstream
		);
Int EncodeShapeBaseLayer(UChar *outmask, 
			Int alphaTH, 
			Int change_CR_disable,
			Int object_width, 
			Int object_height, 
			Int levels, 
			BBS *shape_bitstream
		);
Int ShapeBaseLayerModeEncode(Int **shape_mode,
			Int *CR_store,
			Int *ST_store,
			Int i,
			Int j,
			Int blkx,
			Int CR,
			Int change_CR_disable,
			BSS *shape_bitstream
		);
Int ShapeBaseLayerContentEncode(Int i,
			Int j,
			Int bsize,
			UChar **BAB,
			BSS *shape_bitstream
		);
Int CheckBABstatus(Int blkn,
			UChar **BAB1,
			UChar **BAB2,
			Int alphaTH
		);
Int CheckMB_Gray(Int BABsize,
			UChar **BAB
		);
Int decide_CR(Int x,
			Int y,
			Int blkn,
			Int coded_width,
			Int coded_height,
			Int blkx, 
			UChar **BAB_org,
			UChar **BAB_dwn,
			Int change_CR_disable,
			Int alphaTH,
			UChar **shape
		);
Int QuantizeShape(UChar *inmask, 
			Int width, 
			Int height, 
			Int alphaTH
		);

Int EncodeShapeEnhancedLayer(UChar *outmask,
			Int object_width,
			Int object_height,
			Int levels,
			Int startCodeEnable,
			FILTER *filter,
			BSS *shape_bitstream
		);

Int DecideEnhLayerBabType(UChar *bordered_lower_bab,
			UChar *bordered_half_bab,
			UChar *bordered_curr_bab,
			Int mbsize,
			Int scan_order
		);

Int EncodeEnhancedLayerBAB(ArCoder *coder,
			UChar *bordered_lower_bab,
			UChar *bordered_half_bab,
			UChar *bordered_curr_bab,
			Int bab_type,
			Int scan_order,
			Int mbsize,
			FILTER *filter,
			BSS *shape_bitstream
		);

Void EncodeTransitionalBAB (ArCoder *coder,
			UChar *bordered_lower_bab,
			UChar *bordered_curr_bab,
			Int mbsize,
			Int scan_order,
			BSS *shape_bitstream 
		);

Void EncodeExceptionalBAB (ArCoder *coder,
			UChar *bordered_lower_bab,
			UChar *bordered_half_bab,
			UChar *bordered_curr_bab,
			Int mbsize,
			FILTER *filter,
			BSS *shape_bitstream 
		);

/* shape/src/ShapeDeCoding.c */
/* begin: added by Samsung AIT (99/04/13) */
Int ShapeDeCoding_V1(UChar *outmask, 
			Int object_width, 
			Int object_height,
			Int *constAlpha,
			UChar *constAlphaValue
		);
/* end: added by Samsung AIT (99/04/13) */
Int ShapeDeCoding(UChar *mask, 
			Int width, 
			Int height,
			Int levels,  
			Int *targetLevel,
			Int *constAlpha,
			UChar *constAlphaValue,
			Int startCodeEnable,
			Int fullSizeOut,
			FILTER **filter
		);
Int DecodeShapeHeader(Int *change_CR_disable, 
			Int *constAlpha, 
			UChar *constAlphaValue,
			Int *shapeScalable
		);
Int DecodeShapeBaseLayer(UChar *outmask,
                        Int change_CR_disable,
                        Int object_width, 
			Int object_height
		);

Int ShapeBaseLayerModeDecode(Int **shape_mode,
			Int *CR_store,  
			Int *ST_store, 
			Int i,
			Int j,
			Int change_CR_disable, 
			Int blkx
		);
Int ShapeBaseLayerContentDecode(Int i,
			Int j,
			Int bsize,
			Int ST,
			UChar **BAB
		);
Int DecodeShapeEnhancedLayer(UChar *outmask,
			Int object_width,
			Int object_height,
			Int levels,
			Int startCodeEnable,
			FILTER *filter
		);
Int DecodeEnhLayerBabType(ArDecoder *decoder, 
			FILTER *filter
		);
Int DecodeEnhancedLayerBAB(ArDecoder *decoder,
			UChar *bordered_lower_bab,
			UChar *bordered_half_bab,	
			UChar *bordered_curr_bab,
			Int bab_type,
			Int mbsize,
			FILTER *filter
		);
Void DecodeTransitionalBAB (ArDecoder *decoder,
			UChar *bordered_lower_bab,
			UChar *bordered_half_bab,
			UChar *bordered_curr_bab,
			Int mbsize,
			Int scan_order
		);
Void DecodeExceptionalBAB (ArDecoder *decoder,
			UChar *bordered_lower_bab,
			UChar *bordered_half_bab,
			UChar *bordered_curr_bab,
			Int mbsize,
			FILTER *filter
		);

/* SAIT_V2 end: added by Samsung AIT (99/02/23) */

#else _DECLARE_PROTOTYPES_

#include "ShapeDeCoding.p"
#include "ShapeEnCoding.p"

#endif _DECLARE_PROTOTYPES_

#ifdef __cplusplus
}
#endif /* __cplusplus  */ 

#endif /* _SHAPE_CODEC_H */


