/****************************************************************************/
/*   MPEG4 Visual Texture Coding (VTC) Mode Software                        */
/*                                                                          */
/*   This software was jointly developed by the following participants:     */
/*                                                                          */
/*   Single-quant,  multi-quant and flow control                            */
/*   are provided by  Sarnoff Corporation                                   */
/*     Iraj Sodagar   (iraj@sarnoff.com)                                    */
/*     Hung-Ju Lee    (hjlee@sarnoff.com)                                   */
/*     Paul Hatrack   (hatrack@sarnoff.com)                                 */
/*     Shipeng Li     (shipeng@sarnoff.com)                                 */
/*     Bing-Bing Chai (bchai@sarnoff.com)                                   */
/*     B.S. Srinivas  (bsrinivas@sarnoff.com)                               */
/*                                                                          */
/*   Bi-level is provided by Texas Instruments                              */
/*     Jie Liang      (liang@ti.com)                                        */
/*                                                                          */
/*   Shape Coding is provided by  OKI Electric Industry Co., Ltd.           */
/*     Zhixiong Wu    (sgo@hlabs.oki.co.jp)                                 */
/*     Yoshihiro Ueda (yueda@hlabs.oki.co.jp)                               */
/*     Toshifumi Kanamaru (kanamaru@hlabs.oki.co.jp)                        */
/*                                                                          */
/*   OKI, Sharp, Sarnoff, TI and Microsoft contributed to bitstream         */
/*   exchange and bug fixing.                                               */
/*                                                                          */
/*                                                                          */
/* In the course of development of the MPEG-4 standard, this software       */
/* module is an implementation of a part of one or more MPEG-4 tools as     */
/* specified by the MPEG-4 standard.                                        */
/*                                                                          */
/* The copyright of this software belongs to ISO/IEC. ISO/IEC gives use     */
/* of the MPEG-4 standard free license to use this  software module or      */
/* modifications thereof for hardware or software products claiming         */
/* conformance to the MPEG-4 standard.                                      */
/*                                                                          */
/* Those intending to use this software module in hardware or software      */
/* products are advised that use may infringe existing  patents. The        */
/* original developers of this software module and their companies, the     */
/* subsequent editors and their companies, and ISO/IEC have no liability    */
/* and ISO/IEC have no liability for use of this software module or         */
/* modification thereof in an implementation.                               */
/*                                                                          */
/* Permission is granted to MPEG members to use, copy, modify,              */
/* and distribute the software modules ( or portions thereof )              */
/* for standardization activity within ISO/IEC JTC1/SC29/WG11.              */
/*                                                                          */
/* Copyright 1995, 1996, 1997, 1998 ISO/IEC                                 */
/****************************************************************************/

#ifndef _BINARCODEC_H_
#define _BINARCODEC_H_
#define		CODE_BITS		32
#define 	HALF			((unsigned) 1 << (CODE_BITS-1))
#define 	QUARTER			((unsigned) 1 << (CODE_BITS-2))
#define		BSBUFSIZE		512

#define		MAXHEADING		3
#define		MAXMIDDLE		10
#define		MAXTRAILING	 2	

struct arcodec {
    U_Int L; /* lower bound */
    U_Int R; /* code range */
    U_Int V; /* current code value */
    U_Int arpipe;
    Int	bits_to_follow; /* follow bit count */
    Int	first_bit;
    Int	nzeros;
    Int	nonzero;
    Int	nzerosf;
    Int	extrabits;
};

struct armodel {
    Int	type;
    Int	ctx_num;
    Int	adapt;
    U_Int *table;
    U_Int *c0;
    U_Int *cnt;
};

typedef	struct arcodec ArCoder;	
typedef	struct arcodec ArDecoder;
typedef	struct armodel ArModel;

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/* function prototype declarations */
#ifdef _DECLARE_PROTOTYPES_

/* shape/src/BinArCodec.c */
Void  	BinArCodeSymbol (	ArCoder *coder,
			BSS *bitstream,
			UChar bit,
			ArModel *model,
			Int ctx
	);
UChar  	BinArDecodeSymbol (	ArDecoder *decoder,
			ArModel *model,
			Int ctx
	);

Void  	StartArCoder_Still (	ArCoder *coder
	);
Void  	StopArCoder_Still (	ArCoder *coder,
			BSS *bitstream
	);
Void  	ArCodeSymbol_Still (	ArCoder *coder,
			BSS *bitstream,
			UChar bit,
			U_Int c0
	);
Void  	EncRenormalize (	ArCoder *coder,
			BSS *bitstream
	);
Void  	BitByItself_Still (	Int bit,
			ArCoder *coder,
			BSS *bitstream
	);
Void  	BitPlusFollow_Still (	Int bit,
			ArCoder *coder,
			BSS *bitstream
	);
Void  	BitstreamPutBit_Still (	Int bit,
			BSS *bitstream
	);
Void  	StartArDecoder_Still (	ArDecoder *decoder
	);
Void  	StopArDecoder_Still (	ArDecoder *decoder
	);
UChar  	ArDecodeSymbol_Still (	ArDecoder *decoder,
			U_Int c0
	);
Void  	AddNextInputBit_Still (	ArDecoder *decoder
	);
Void  	DecRenormalize (	ArDecoder *decoder
	);
/* SAIT_V2 begin: added by Samsung AIT (99/02/23) */
BSS*	AllocBitstream ( Int size
	);
Void	FreeBitstream( BSS *bitstream
	);
/* SAIT_V2 end */
Void  	InitBitstream (	Int flag,
			BSS *bitstream
	);
Int  	ByteAlignmentEnc (
	);
/* SAIT_V2 begin: added by Samsung AIT (99/02/23) */
Int  	ByteAlignmentEncCopy ( BSS *bitstream
	);
/* SAIT_V2 end */
Int  	ByteAlignmentDec (
	);
Void  	PutBitstoStream (	Int bits,
			U_Int code,
			BSS *bitstream
	);
Void  	BitstreamFlushBits_Still (	Int i
	);
Int  	BitstreamLookBit (	Int pos
	);
U_Int  	LookBitsFromStream (	Int bits
	);
U_Int  	LookBitsFromStream1 (	Int bits
	);
U_Int  	GetBitsFromStream (	Int bits
	);
Void  	BitStreamCopy (	Int cnt,
			BSS *bitstream1,
			BSS *bitstream2
	);
Void  	BitstreamFlushBitsCopy (	Int i,
			BSS *bitstream
	);
Int  	BitstreamLookBitCopy (	Int pos,
			BSS *bitstream
	);
U_Int  	LookBitsFromStreamCopy (	Int bits,
			BSS *bitstream
	);
U_Int  	GetBitsFromStreamCopy (	Int bits,
			BSS *bitstream
	);
Void  	BitStreamMerge (	Int cnt,
			BSS *bitstream
	);
Void  PutBitstoStreamMerge(Int bits,U_Int code);


#else _DECLARE_PROTOTYPES_

#include "BinArCodec.p"

#endif _DECLARE_PROTOTYPES_


#ifdef __cplusplus
}



#endif /* __cplusplus  */ 
#endif /* _BINARCODEC_H_  */ 

