/******************************************************************************
 *                                                                          
 * This software module was originally developed by 
 *
 * Noel O'Connor (TELTEC IRELAND / ACTS-MoMuSys).                   	
 *
 * and edited by 
 *
 * Aasmund Sandvand (Telenor / ACTS-MoMuSys). 	    	              	
 * J. Ignacio Ronda (UPM / ACTS-MoMuSys).   	  	              	
 * Cecile Dufour (LEP / ACTS-MoMuSys).     		              	
 * Minhua Zhou (HHI / ACTS-MoMuSys).   	  	 	              	
 * Fernando Jaureguizar (UPM / ACTS-MoMuSys).   	              	
 * Luis Ducla-Soares (IST / ACTS-MoMuSys).     	           	   	
 * Martina Eckert (UPM / ACTS-MoMuSys).   	  	              	
 * Noel Brady (TELTEC IRELAND / ACTS-MoMuSys).                   	
 * Angel Pacheco (UPM / ACTS-MoMuSys).     		              	
 * Michael Wollborn (TUH / ACTS-MoMuSys).
 * Bob Eifrig (NextLevel Systems)
 * Michael Frater (UNSW)
 * Ji Heon Kweon (HYUNDAI)
 * Jong Deuk Kim (HYUNDAI)
 * Marc Mongenet (EPFL)
 * Seishi TAKAMURA (NTT)
 * U. Benzler
 * Oki Electric Industry Co., Ltd. (contact: Shigeru Fukunaga)
 * Fujitsu Laboratories Ltd. (contact: Eishi Morimatsu)
 * Dae-Sung Cho (Samsung AIT)
 * Massimo Ravasi (EPFL)
 *
 * in the course of development of the MPEG-4 Video (ISO/IEC 14496-2) standard.
 * This software module is an implementation of a part of one or more MPEG-4 
 * Video (ISO/IEC 14496-2) tools as specified by the MPEG-4 Video (ISO/IEC 
 * 14496-2) standard. 
 *
 * ISO/IEC gives users of the MPEG-4 Video (ISO/IEC 14496-2) standard free 
 * license to this software module or modifications thereof for use in hardware
 * or software products claiming conformance to the MPEG-4 Video (ISO/IEC 
 * 14496-2) standard. 
 *
 * Those intending to use this software module in hardware or software products
 * are advised that its use may infringe existing patents. The original 
 * developer of this software module and his/her company, the subsequent 
 * editors and their companies, and ISO/IEC have no liability for use of this 
 * software module or modifications thereof in an implementation. Copyright is 
 * not released for non MPEG-4 Video (ISO/IEC 14496-2) standard conforming 
 * products. 
 *
 * ACTS-MoMuSys partners retain full right to use the code for his/her own 
 * purpose, assign or donate the code to a third party and to inhibit third 
 * parties from using the code for non MPEG-4 Video (ISO/IEC 14496-2) standard
 * conforming products. This copyright notice must be included in all copies or
 * derivative works. 
 *
 * Copyright (c) 1997
 *
 *****************************************************************************/

/***********************************************************HeaderBegin*******
 *                                                                         
 * File: vm_vop_code.c
 *
 * Author: Noel O'Connor Teltec Irl.
 * Created: 11-03-96
 *                                                                         
 * Description: 
 *
 * Notes:  
 *
 * Modified:
 * 21.04.96 Robert Danielsen: Reformatted. New headers.
 * 08.05.96 Noel O'Connor: New data structure for vop 
 *          configuration information.
 * 31.07.96 Noel O'Connor: Modified VopProcess to comply with
 *          high level changes for VM 3.0 syntax
 * 30-Aug-96 Jan De Lameillieure (HHI): MMR Coding
 * 23.09.96 Noel O'Connor: Some changes to allow coding of multiple VOs
 * 23.10.96 Robert Danielsen: Some changes to implement DC/AC prediction
 * 23.10.96 Aasmund.Sandvand@fou.telenor.no: Modified to support
 *          deblock filtering
 * 27.11.96 Noel O'Connor: Changed all instances of time variables to be
 * floating point (except in "BitstreamPutVopHeader()").
 * 2-Dec-96 Jan De Lameillieure (HHI): calculate SNR only in pels that belong
 *          to original AND reconstructed segment mask
 * 14.01.97 Luis Ducla-Soares: enabled byte alignment in function VopProcess()
 *          by removing comment around NextStartCode() function call.
 * 31.01.97 Aasmund Sandvand: Moved deblock filter out of the loop
 * 04.02.97 Noel O'Connor: removed all assert() calls
 * 07.02.97 J. Ignacio Ronda: VopCode() and VopProcess() modifications
 * 20.02.97 Cecile Dufour : including STATIC SPRITE
 * 20-MAR-97 Jan De Lameillieure (HHI) : added shape argument to SubsampleAlphaMap()
 * 11.03.97 Minhua Zhou   : added B-VOPs
 * 21.03.97 Cecile Dufour : including ONLINE SPRITE
 * 23.04.97 Michael Wollborn: changed "...GLQuantUpdate" 
 *			      -> "...DisableGrayQuantUpdate"
 * 26.04.97 Luis Ducla-Soares: added the error resilient mode with data partitioning.
 * 06.05.97 Noel Brady: added calls for VM7(CAE) binary shape coding.
 * 09.05.97 Minhua Zhou: added Group_of_GOPs 
 * 15.05.97 Luis Ducla-Soares: corrected the remultiplexing of the DCT data
 *                             in the combined error resilient mode with 
 *                             data partitioning.
 *
 * 15.05.97 Minhua Zhou      : modification for encoding empty VOP 
 * 16.06.97 Angel Pacheco: unified the TRANSPARENT modes.
 * 07.07.97 Martina Eckert: Introduction of global rate control 
 *          functions and parameters
 * 18.07.97 Ulrike Pestel-Schiller: Added spatial scalability
 * 01.08.97 Fernando Jaureguizar: Added enable_8x8_mv => Motion Vectors for
 *          8x8 blocks are allowed. This is allways set to 1 except for
 *          spatial scalability.
 *          WARNING!! Advanced prediction only means overlapped motion
 *          compensation.
 * 04.08.97 Minhua Zhou: rename obmc_disable   
 * 28.08.97 Osamu Sunohara(Sony): modified to calclate modulo_time_base in
 *                                spatial scalability exactly. 
 * 08.09.97 Cecile Dufour :modified vop_header and VOP_prediction for STATIC SP.
 * 27.11.97 M. Eckert: Changes for independent frame rate type control
 * 04.01.98 Michael Frater: Support for non-8-bit video
 * 16.01.98 M. Eckert: Changes concerning parameter-ctl-string for RC
 * 27.01.98 M. Eckert and F. Jaureguizar: VopCode() modifications for RC
 * 07.05.98 Jong Deuk Kim (jdkim97@hei.co.kr, HYUNDAI) : interlaced tools 
 * 21.05.98 Ji Heon Kweon (HYUNDAI) : support for grayscale coding
 * 09.06.98 Marc Mongenet (EPFL): added Complexity Estimation syntax support
 * 31.08.98 Guido Heising (HHI): non version 1 items deleted
 * 15.02.99 U. Benzler : added quarter pel support
 * 03.03.99 Seishi TAKAMURA (NTT): added GMC coding
 * 29.07.99 U. Benzler : included the combined_decode.c-patch 28.10.98 - Shinya Kadono (SB) also for the encoder
 * 16.08.99 Shigeru Fukunaga (Oki): added modules for NEWPRED
 * 06.09.99 Eishi Morimatsu (Fujitsu Labs.): added DRC support
 * 26.10.99 Massimo Ravasi (EPFL): added Complexity Estimation syntax support
 *                                 Update version 2
 * 14.12.99 Eishi Morimatsu (Fujitsu Labs.): bug fix for DRC
 *
 ***********************************************************HeaderEnd*********/

/************************    INCLUDE FILES    ********************************/
#include <sys/stat.h>

#include "vm_config.h"
#include "vm_vop_code.h"
#include "vm_enc_defs.h"
#include "io_generic.h"
#include "mom_bitstream_i.h"
#include "vm_vop_bound.h"
#include "vm_compos.h"
#include "mot_comp.h"
#include "mot_padding.h"
#include "mom_putbits.h"
#include "alp_code_grey.h"
#include "mot_util.h"
#include "mot_est.h"
#include "sprite_util.h"
#include "sprite_enc_util.h"
#include "sprite_enc_piece.h"
#include "alp_code_mom.h"
#include "alp_code_header.h"
#include "alp_common_util.h"
#include "alp_code_mc.h" /* added for OBSS by Samsung AIT (1999-09-29) */
#include "newpred.h"	/** added for NEWPRED (Oki) 16-AUG-1999 **/

/* Due to N2171 Cl. 2.5.3 MW 28-MAR-1998 */
#include "vm_enc_main.h"

/* for TPS */
#include "enhance_vop.h"
#include "tm5rc.h"


#include "meitca_wrapper.h"
#include "sait_rc.h"


/* inserted by SAMSUNG AIT */
#include "rc_mvo.h"	
extern Int TextureBits;
extern Int FirstInterFrame;
extern RC_MVO rc_mvo;
/* inserted by SAMSUNG AIT */

#include "gme_for_iso.h"	/* modified by NTT for GMC coding */

#include "drc_util_enc.h"
#include "drc_util_common.h"


Int 	total_first_bits[3]={0,0,0},
			total_second_bits[3]={0,0,0},
			total_amv_bits[3]={0,0,0},
			total_cae_bits[3]={0,0,0},
			total_cae_intra_bits[3]={0,0,0},
			total_cae_inter_bits[3]={0,0,0},
			total_coded_mbs[3]={0,0,0},
			total_coded_intra_mbs[3]={0,0,0},
			total_coded_inter_mbs[3]={0,0,0},
			curr_first_bits,
			curr_second_bits,
			curr_amv_bits,
						curr_cae_bits,
						curr_cae_intra_bits,
						curr_cae_inter_bits,
						curr_coded_mbs,
						curr_coded_intra_mbs,
						curr_coded_inter_mbs;

Int ce_coded_frames[3],
		ce_bits_for_shape[3],
		ce_bits_for_vop;
/* for TPS */
Int	back_base_exist;

Int	for_shape_width ,          for_shape_height ,
	for_shape_hor_spat_ref ,   for_shape_ver_spat_ref;
Int	back_shape_width ,         back_shape_height ,
	back_shape_hor_spat_ref ,  back_shape_ver_spat_ref;
 
Image *for_first_shape_code_bitstream,   
      *for_shape_bitstream,          
      *back_first_shape_code_bitstream,   
      *back_shape_bitstream;
/**/

Int total_shape_bits = 0;


/***********************************************************CommentBegin******
 *
 * -- VopProcess -- Sets up and codes a vop, updates vop store
 *
 * Author :  
 * Noel O'Connor Teltec Irl.
 *
 * Created :  
 * 11-03-96
 *
 * Purpose :  
 * This function sets up a vop to be coded  (fills
 * vop syntax fields, etc.), and codes the vop. This is the main 
 *  "coding engine" of the implementation.
 * 
 * Arguments in :  
 * Vop *curr_vop_in - pointer to current vop to be coded
 *        (ASSUMED BOUNDED)
 * Vop *prev_vop - previous original Vop
 * Vop *prev_rec_vop - previous coded Vop
 * Float time - Time of coding
 * Int prev_time - Previous time of coding
 * VolConfig *vol_cfg - data structure containing extra configuration
 *        information for the VOL, specifically the file 
 *        names of the coded vop on disk.
 * Int vop_has_content - flag indicating whether Vop actually has
 *        content and needs to be coded or whether it is enough to send Vop
 *        header.
 * Int vo_id - current VO Id
 *
 * Arguments in/out : 
 * BitCount num_bits[][] - array of BitCount structures 
 *
 * Arguments out : 
 * -
 *
 * Return values : 
 * Vop *rec_curr - reconstructed current Vop
 *
 * Side effects : 
 * -
 *
 * Description : 
 *
 * See also :
 * file "README_ENCODER"
 *
 * Modified :  
 * 04.09.96 Cor Quist: added intra_dcpred_disable
 * 23.09.96 Noel O'Connor: some changes to allow coding of multiple VOs.
 * 09.10.96 Noel O'Connor: added call to NextStartCode()
 * 14.01.97 Luis Ducla-Soares: enabled byte alignment by removing
 *          comment around NextStartCode() function call.
 * 21.01.97 Removed bytealignment here. Done elsewhere. Fix by Luis.
 * 04.02.97 Noel O'Connor: mods for non unique VOL Ids
 * 07.02.97 J. Ignacio Ronda: now BitstreamPutVopHeader() is called inside
 *          VopCode() => VopCode() with new parameters.
 *          New variable rc_type
 * 20.02.97 Cecile Dufour : to include STATIC SPRITE 
 * 11.03.97 Minhua Zhou   : added B-VOPs
 * 26.04.97 Luis Ducla-Soares: added data_partitioning enable to VOP.
 * 09.05.97 Minhua Zhou      : added call of BitstreamPutGOV
 * 15.05.97 Minhua Zhou      : modification for encoding empty VOP
 * 07.07.97 Martina Eckert: Introduction of global rate control 
 *              functions and parameters
 * 31.07.97 Fernando Jaureguizar: added GetVopScalability() (SpSc)
 * 01.08.97 Fernando Jaureguizar: Added enable_8x8_mv => Motion Vectors for
 *          8x8 blocks are allowed. This is allways set to 1 except for
 *          spatial scalability.
 * 27.11.97 M. Eckert: Changes for independent frame rate type control
 * 11.12.97 Bob Eifrig: Modification for interlaced video coding
 * 14.05.98 M. Wollborn: added call to update TM5 RC after VopCode()
 * 21.05.98 Ji Heon Kweon (HYUNDAI) : support for grayscale coding
 * 09.06.98 Marc Mongenet (EPFL): added Complexity Estimation syntax support
 * 28.01.99 Yoshinori Suzuki (Hitachi, Ltd.): added rounding control parameters
 * 15.02.99 U. Benzler : added quarter pel support
 * 03.03.99 Seishi TAKAMURA (NTT): added GMC coding
 * 01.04.99 Yoshinori Suzuki (Hitachi, Ltd.): TM5 initialization patch
 * 16.08.99 Shigeru Fukunaga (Oki): added modules for NEWPRED
 * 06.09.99 Eishi Morimatsu (Fujitsu Labs.): added DRC support
 * 09.29.99 Dae-Sung Cho (Samsung AIT): added support for OBSS
 * 10.15.99 Dae-Sung Cho (Samsung AIT): added support for OBSS
 * 26.10.99 Massimo Ravasi (EPFL): added Complexity Estimation syntax support
 *                                 Update version 2
 *
 ***********************************************************CommentEnd********/
/*TPS*/
Vop *
VopProcess(Vop *curr_vop_bb,
	   Vop *prev_vop,
	   Vop *prev_rec_vop,
	   Vop *next_vop,
	   Vop *next_rec_vop,
	   Float time,
	   VolConfig *vol_config,
	   Int vop_has_content,
	   Int vo_id, Int TRB, Int TRD,
	   VOConfig *vo_config_list, /* UPM Global RC */
	   Int rc_type,              /* UPM Global RC */
	   Int rc_algorithm,         /* hjlee */
	   BitCount num_bits[MAX_NUM_VOS][MAX_NUM_VOLS],
	   Vop *no_padding_vop,
	   Int temporal_scalability)
     /**/
{
  Vop *rec_curr = NULL;			/* Reconstructed vop */

  Int vol_id,
    aux,
    QP,
    Intra_QP,
    shape_effects,
    obmc_disable,
    unrestricted_motion_mode,
    quarter_pel,		/* MW QPEL 07-JUL-1998 */
    acdc_pred_disable,
    quant_precision,
    bits_per_pixel,
    error_res_disable,
    data_partitioning,

#ifndef NLSSTATS
    iAuxComp,
#endif

    reversible_vlc,
    /* 01.02.99 HHI Schueuer */
    sadct_disable,
    /* end HHI */
    sr_for,	   
    sr_back,
    num_vop_code_inc=0,
    alpha_th,
    change_CR_disable,
    gl_quantizer,
    disable_gray_quant_update,
    *qmat_vop, *qmat_vol,
    
    vop_spat_scal=0;
  
  /*** 10/27 TPS */
  Int  vop_temp_scal = 0;	
  Int  modulo_tps    = 0;
  /* 10/27 TPS ***/
  
  Int		i;
  TrajPoint	*tmp_refpoint;



  Int enable_8x8_mv = 1; /*SpSc*/
  
  Int	newpred_enable;	/** added for NEWPRED (Oki) 16-AUG-1999 **/
  Int	newpred_segment_type;	/** added for NEWPRED (Oki) 16-AUG-1999 **/


  vol_id = GetVolConfigId(vol_config);
    
  /* Getting the VOP ScalType, for spat scal (UPS)*/
  /*** 10/27 TPS */
  if(GetVopScalability(curr_vop_bb) ==1){ 
    /*SpSc*/
    if (( GetVopPredictionType(curr_vop_bb)==P_VOP 
	  && GetVopRefSelCode(curr_vop_bb) ==3)
	|| ( GetVopPredictionType(curr_vop_bb)==B_VOP 
	     && GetVopRefSelCode(curr_vop_bb) ==0))
      vop_spat_scal=1;
    /* TPS */
    else if(GetVopPredictionType(curr_vop_bb)==P_VOP &&
	    (GetVopRefSelCode(curr_vop_bb) == 0 ||
	     GetVopRefSelCode(curr_vop_bb) == 1 ||
	     GetVopRefSelCode(curr_vop_bb) == 2)        )
      vop_temp_scal = 3;       /* P_VOP        : TPS */    
    else if(GetVopPredictionType(curr_vop_bb) == B_VOP){
      if(GetVopRefSelCode(curr_vop_bb) == 3)
	vop_temp_scal = 1;   /* B_VOP_TYPE_1 : TPS */    
      else if(GetVopRefSelCode(curr_vop_bb) == 1)
	vop_temp_scal = 2;   /* B_VOP_TYPE_2 : TPS */    
    }
  }
  /* 10/27 TPS ***/

/* begin: added for OBSS by Samsung AIT (1999-09-29) */
  if(vop_spat_scal==1) {
	back_base_exist = 1;
/* begin: added for OBSS by Samsung AIT (1999-10-15) */
	/*PutVopBackComp(0, curr_vop_bb);*/	/* BGC is not performed for partial enhanced VOP in OBSS for the time being */
        PutVopBackComp(1, curr_vop_bb);
        /* BGC is set to 1 for partial enhanced VOP in OBSS. It could be disabled */
/* end: added for OBSS by Samsung AIT (1999-10-15) */
  }
/* end: added for OBSS by Samsung AIT (1999-09-29) */
      
  /* Set up the vop coding parameters */
  /* Vop type */
  /*** 10/27 TPS */
  if(!vop_spat_scal                                 /* not spatial scalability         */
     && (vop_temp_scal == 0 || vop_temp_scal == 3 ))  /* not temporal_scalability(B_VOP) */
    /* 10/27 TPS ***/
    {
	if ( (GetVolConfigSpriteUsage(vol_config) == STATIC_SPRITE)&&
	     ( GetVolConfigWarpParamCounter(vol_config)!= -1 ))
	  {
	    if (GetVolConfigCheckStaticSpritePrediction(vol_config))
	      {
		PutVopPredictionType(SPRITE_VOP,curr_vop_bb);
		fprintf(stdout, "==> prediction type set to SPRITE_VOP \n");
	      }
	    else
	      {
		/* Vop_prediction Type set before the Vop_process call in sprite_enc_piece.c */
	      }
	  }
	else 
	  if ((TRD>1)&&(TRB!=0))
	    PutVopPredictionType(B_VOP,curr_vop_bb);
      /* for TPS */
      /*else 
	if (  (prev_vop != NULL) &&
	((vol_config->frame - vol_config->start_frame - vol_config->frame_skip)%(vol_config->frame_skip * vol_config->intra_period)!=0) )*/
	  else 
	    if (  (prev_vop != NULL) &&
		  (((vol_config->frame - vol_config->start_frame - GetVolConfigM(vol_config)*vol_config->frame_skip)%(vol_config->frame_skip * vol_config->intra_period)!=0) || ( GetVopScalability(curr_vop_bb))))
	      {
		PutVopPredictionType(DEFAULT_PRED_TYPE,curr_vop_bb);
		num_vop_code_inc = 0;
		if (GetVopWidth(prev_vop)==0) 
                  PutVopPredictionType(I_VOP,curr_vop_bb);
		/* added by Minhua Zhou 15-05-97 */
	      }
	    else
	      {
		if (rc_type >= TM5_RATE_CONTROL) {
                  Int nppic, npic = (vol_config->end_frame - curr_vop_bb->frame) / vol_config->frame_skip + 1; /* 05-06-99 U. Benzler */
		  if (prev_vop == NULL) {
		    if (npic > (vol_config->intra_period - GetVolConfigM(vol_config) + 1))
		      npic = vol_config->intra_period - GetVolConfigM(vol_config) + 1;
		  } else {
		    npic += GetVolConfigM(vol_config) - 1;
		    if (npic > vol_config->intra_period)
		      npic = vol_config->intra_period;
		  }
		  nppic = (npic + GetVolConfigM(vol_config) - 1) / GetVolConfigM(vol_config) - 1;
		  tm5rc_init_GOP(nppic, npic - nppic - 1, vol_config->rcdata);
		}
		PutVopPredictionType(I_VOP,curr_vop_bb);
		num_vop_code_inc = 1;
	      }
    }
  if (rc_type >= TM5_RATE_CONTROL) { 
    Int quant;

    tm5rc_init_pict(curr_vop_bb, vol_config->rcdata);
    quant = tm5rc_start_mb(vol_config->rcdata);
    switch (GetVopPredictionType(curr_vop_bb)) {
    case I_VOP: PutVopIntraQuantizer(quant, curr_vop_bb); break;
    case P_VOP: PutVopQuantizer     (quant, curr_vop_bb); break;
    case B_VOP: PutVopBQuantizer    (quant, curr_vop_bb); break;
    }
  }

/* modified by NTT for GMC coding : start */
  if (GetVolConfigSpriteUsage(vol_config) == GMC_SPRITE &&
      GetVopPredictionType(curr_vop_bb) == P_VOP) {
      PutVopPredictionType(SPRITE_VOP,curr_vop_bb);
  }
/* modified by NTT for GMC coding : end */

/* >>> added for DRC by Fujitsu (top)    <<< */
    if(GetVolConfigDrcEnable(vol_config)!=0) {
	DecideReducedResolution(prev_vop,curr_vop_bb,vol_config->bit_rate,
				GetVolConfigDrcSwitchingMode(vol_config));
    } else {
	PutVopReducedResolution(0,curr_vop_bb);
	PutVopDctCoefMask(8,curr_vop_bb);
        PutVopSwitchingFlag(0,curr_vop_bb);
    }
/* >>> added for DRC by Fujitsu (bottom) <<< */

  /* Set vop_rounding_type */
  if ( GetVopPredictionType(curr_vop_bb)==P_VOP ||
       ( GetVolConfigSpriteUsage(vol_config) != STATIC_SPRITE &&
	 GetVopPredictionType(curr_vop_bb)==SPRITE_VOP)) 
    {
      if(GetVolConfigRoundingControlDisable(vol_config)){
	PutVopRoundingType(GetVolConfigInitialRoundingType(vol_config),curr_vop_bb);
      }else{
        if (GetVopPredictionType(prev_vop)== I_VOP )
	  PutVopRoundingType(GetVolConfigInitialRoundingType(vol_config),curr_vop_bb);
        else{
	  if (!GetVopRoundingType(prev_vop))
	    PutVopRoundingType(1,curr_vop_bb);
	  else
	    PutVopRoundingType(0,curr_vop_bb);
        }
      }
    }
  else
    PutVopRoundingType(0,curr_vop_bb);
  
  if(rc_type < TM5_RATE_CONTROL){ /* TM5 initialization patch, Yoshinori Suzuki 990401 */

    /* Vop quantizer - INTER */
    QP = GetVolConfigQuantizer(vol_config); 
    PutVopQuantizer(QP,curr_vop_bb);

    /* Vop quantizer - INTER B */
    QP = GetVolConfigBQuantizer(vol_config); 
    PutVopBQuantizer(QP,curr_vop_bb);


    /* Vop quantizer - INTRA */
    Intra_QP = GetVolConfigIntraQuantizer(vol_config);


    if (RCQ2_MVO_CHECK() >= RCQ2_MVO_HVS)  
      Intra_QP = GetMBQuant(vo_id, 0);



    PutVopIntraQuantizer(Intra_QP,curr_vop_bb);
  } /* TM5 initialization patch, Yoshinori Suzuki 990401 */	



  /* HYUNDAI (Grayscale) */
  disable_gray_quant_update =
    GetVolConfigDisableGrayQuantUpdate(vol_config);
  PutVopDisableGrayQuantUpdate(disable_gray_quant_update, curr_vop_bb);

  /* Vop quantizer type (H.263 or MPEG) */
  PutVopQuantType(GetVolConfigQuantType(vol_config),curr_vop_bb);
  PutVopTimeIncrementResolution(GetVolConfigTimeIncrementResolution(vol_config),curr_vop_bb); 

  /* Added MPEG-like quantization parameters to VOP, 24-APR-1997 MW */
  if(GetVopQuantType(curr_vop_bb))
    {
      /* intra quant. matrix */
      PutVopLoadIntraQuantMat(GetVolConfigLoadIntraQuantMat(vol_config),
			      curr_vop_bb);

      qmat_vol = GetVolConfigIntraQuantMat(vol_config);
      qmat_vop = GetVopIntraQuantMat(curr_vop_bb);

      for(i=0; i<64; i++)
	qmat_vop[i] = qmat_vol[i];

      /* nonintra quant. matrix */
      PutVopLoadNonintraQuantMat(GetVolConfigLoadNonintraQuantMat(vol_config),curr_vop_bb);

      qmat_vol = GetVolConfigNonintraQuantMat(vol_config);
      qmat_vop = GetVopNonintraQuantMat(curr_vop_bb);

      for(i=0; i<64; i++)
	qmat_vop[i] = qmat_vol[i];


      for(aux=0;aux<GetVolConfigAuxCompCount(vol_config);aux++) { 	/* MAC (SB) 17-Nov-99 */

        /* gray intra quant. matrix */
        PutVopLoadGrayIntraQuantMat(GetVolConfigLoadGrayIntraQuantMat(vol_config),aux,curr_vop_bb);

        qmat_vol = GetVolConfigGrayIntraQuantMat(vol_config);
        qmat_vop = GetVopGrayIntraQuantMat(aux,curr_vop_bb);

        for(i=0; i<64; i++)
          qmat_vop[i] = qmat_vol[i];
        
        /* gray nonintra quant. matrix */
        PutVopLoadGrayNonintraQuantMat(GetVolConfigLoadGrayNonintraQuantMat(vol_config),aux,curr_vop_bb);
        
        qmat_vol = GetVolConfigGrayNonintraQuantMat(vol_config);
        qmat_vop = GetVopGrayNonintraQuantMat(aux,curr_vop_bb);
        
        for(i=0; i<64; i++)
          qmat_vop[i] = qmat_vol[i];
      }
    } /* if(GetVopQuantType(curr_vop_bb)) */

   
  for(aux=0;aux<GetVolConfigAuxCompCount(vol_config);aux++) { /* MAC (SB) 17-Nov-99 */
    /* Set remaining vop fields */
    /* GL quantizer : P-VOPs*/

    gl_quantizer = GetVolConfigGLQuant(vol_config);
    PutVopGLQuantizer(gl_quantizer,aux,curr_vop_bb);

    /* HYUNDAI (Grayscale) : I-VOPs*/
    /* GL quantizer */
    gl_quantizer = GetVolConfigIntraGLQuant(vol_config);
    PutVopIntraGLQuantizer(gl_quantizer,aux,curr_vop_bb);
    
    /* HYUNDAI (Grayscale) */
    /* GL quantizer : B-VOPs*/
    gl_quantizer = GetVolConfigBGLQuant(vol_config);
    PutVopBGLQuantizer(gl_quantizer,aux,curr_vop_bb);
  }



#ifndef NLSSTATS
  /* Put some text for user */
  if (GetVolConfigSpriteUsage(vol_config) == SPRITE_NOT_USED) {

    if (GetVopPredictionType(curr_vop_bb)==I_VOP) 
      fprintf(stdout,"\t\tIntra Quantizer : %d\n",GetVopIntraQuantizer(curr_vop_bb));
    else if (GetVopPredictionType(curr_vop_bb)==P_VOP)
      fprintf(stdout,"\t\tP-VOP Quantizer : %d\n",GetVopQuantizer(curr_vop_bb));
    else if (GetVopPredictionType(curr_vop_bb)==B_VOP)
      fprintf(stdout,"\t\tB-VOP Quantizer : %d\n",GetVopBQuantizer(curr_vop_bb));

    /* HYUNDAI (Grayscale) */
    if (GetVopShape(curr_vop_bb)==GREY_SCALE) {
      for (iAuxComp=0; iAuxComp<GetVopAuxCompCount(curr_vop_bb); iAuxComp++ ) {
        if (GetVopPredictionType(curr_vop_bb)==I_VOP) 
          fprintf(stdout,"\t\tGrayscale Quantizer[%d] : %d\n",iAuxComp,GetVopIntraGLQuantizer(iAuxComp,curr_vop_bb));
        else if (GetVopPredictionType(curr_vop_bb)==P_VOP)
          fprintf(stdout,"\t\tGrayscale Quantizer[%d] : %d\n",iAuxComp,GetVopGLQuantizer(iAuxComp,curr_vop_bb));
        else if (GetVopPredictionType(curr_vop_bb)==B_VOP)
          fprintf(stdout,"\t\tGrayscale Quantizer[%d] : %d\n",iAuxComp,GetVopBGLQuantizer(iAuxComp,curr_vop_bb));
      }
    }

  }
#endif

  /* Shape effects */
  shape_effects = GetVolConfigShapeEffects(vol_config);
  PutVopShapeEffects(shape_effects,curr_vop_bb);

  /* advanced prediction dsiable */
  obmc_disable = GetVolConfigOBMCDisable(vol_config);
  PutVopOBMCDisable(obmc_disable,curr_vop_bb);


  /*>SpSc*/
  if(vop_spat_scal)
    enable_8x8_mv = 0;
  /*SpSc<*/

  change_CR_disable = GetVolConfigChangeCRDisable(vol_config);
  PutVopChangeCRDisable(change_CR_disable,curr_vop_bb);


  /* AC/DC prediction disable */
  acdc_pred_disable = GetVolConfigACDCPredDisable(vol_config);
  PutVopIntraACDCPredDisable(acdc_pred_disable,curr_vop_bb);

  /* variable quantizer precision */
  quant_precision = GetVolConfigQuantPrecision(vol_config);
  PutVopQuantPrecision(quant_precision,curr_vop_bb);

  /* variable quantizer precision */
  bits_per_pixel = GetVolConfigBitsPerPixel(vol_config);
  PutVopBitsPerPixel(bits_per_pixel,curr_vop_bb);
     
  /* MAC (SB) 11-Nov-99 */  
  PutVopAuxCompCount( GetVolConfigAuxCompCount(vol_config), curr_vop_bb );
      
  /* Error resilence disable */
  error_res_disable = GetVolConfigErrorResDisable(vol_config);
  PutVopErrorResDisable(error_res_disable,curr_vop_bb);

  /* Data Partitioning enable */
  data_partitioning = GetVolConfigDataPartEnable(vol_config);
  PutVopDataPartEnable(data_partitioning,curr_vop_bb);

  /* Reversible VLC flag */
  reversible_vlc = GetVolConfigReverseVlc(vol_config);
  PutVopReverseVlc(reversible_vlc,curr_vop_bb);

  /* 01.02.99 HHI Schueuer */
  /* SADCT disable */
  sadct_disable = GetVolConfigSADCTDisable(vol_config);
  PutVopSADCTDisable(sadct_disable,curr_vop_bb);
  /* end HHI */

  /** added for NEWPRED (Oki) 16-AUG-1999 **/
  /* NEWPRED enable */
  newpred_enable = GetVolConfigNewpredEnable(vol_config);
  PutVopNewpredEnable(newpred_enable,curr_vop_bb);

  /* NEWPRED segment type */
  newpred_segment_type = GetVolConfigNewpredSegmentType(vol_config);
  PutVopNewpredSegmentType(newpred_segment_type,curr_vop_bb);
  /** end of NEWPRED (Oki) 16-AUG-1999 **/

  /* intra_dc_vlc_thr */
  PutVopIntraDCVlcThr( GetVolConfigIntraDCVlcThr(vol_config), curr_vop_bb );

  /* MW QPEL 07-JUL-1998 */
  /* Quarter Pel */
  quarter_pel = GetVolConfigQuarterPel(vol_config);
  PutVopQuarterPel(quarter_pel,curr_vop_bb);

  /* sr_for */
  sr_for = GetVolConfigSearchRange(vol_config)*((TRB)?TRB:TRD); 
  PutVopSearchRangeFor(sr_for,curr_vop_bb);
  /* MW QPEL 07-JUL-1998 */
  PutVopFCodeFor(cal_fcode(sr_for,GetVopQuarterPel(curr_vop_bb)),curr_vop_bb);

  /* sr_back */
  sr_back = GetVolConfigSearchRange(vol_config)*(TRD-TRB); 
  PutVopSearchRangeBack(sr_back,curr_vop_bb);
  /* MW QPEL 07-JUL-1998 */
  PutVopFCodeBack(cal_fcode(sr_back,GetVopQuarterPel(curr_vop_bb)),curr_vop_bb);

  /* START: Complexity Estimation syntax support - Marc Mongenet (EPFL) - 9 Jun 1998 */
  PutVopComplexityEstimationDisable(GetVolConfigComplexityEstimationDisable(vol_config), curr_vop_bb);
  PutVopEstimationMethod(GetVolConfigEstimationMethod(vol_config), curr_vop_bb);
  PutVopShapeComplexityEstimationDisable(GetVolConfigShapeComplexityEstimationDisable(vol_config), curr_vop_bb);
  PutVopOpaque(GetVolConfigOpaque(vol_config), curr_vop_bb);
  PutVopDCECSOpaque(GetVolConfigDCECSOpaque(vol_config), curr_vop_bb);
  PutVopTransparent(GetVolConfigTransparent(vol_config), curr_vop_bb);
  PutVopDCECSTransparent(GetVolConfigDCECSTransparent(vol_config), curr_vop_bb);
  PutVopIntraCAE(GetVolConfigIntraCAE(vol_config), curr_vop_bb);
  PutVopDCECSIntraCAE(GetVolConfigDCECSIntraCAE(vol_config), curr_vop_bb);
  PutVopInterCAE(GetVolConfigInterCAE(vol_config), curr_vop_bb);
  PutVopDCECSInterCAE(GetVolConfigDCECSInterCAE(vol_config), curr_vop_bb);
  PutVopNoUpdate(GetVolConfigNoUpdate(vol_config), curr_vop_bb);
  PutVopDCECSNoUpdate(GetVolConfigDCECSNoUpdate(vol_config), curr_vop_bb);
  PutVopUpsampling(GetVolConfigUpsampling(vol_config), curr_vop_bb);
  PutVopDCECSUpsampling(GetVolConfigDCECSUpsampling(vol_config), curr_vop_bb);
  PutVopTextureComplexityEstimationSet1Disable(GetVolConfigTextureComplexityEstimationSet1Disable(vol_config), curr_vop_bb);
  PutVopIntraBlocks(GetVolConfigIntraBlocks(vol_config), curr_vop_bb);
  PutVopDCECSIntraBlocks(GetVolConfigDCECSIntraBlocks(vol_config), curr_vop_bb);
  PutVopInterBlocks(GetVolConfigInterBlocks(vol_config), curr_vop_bb);
  PutVopDCECSInterBlocks(GetVolConfigDCECSInterBlocks(vol_config), curr_vop_bb);
  PutVopInter4vBlocks(GetVolConfigInter4vBlocks(vol_config), curr_vop_bb);
  PutVopDCECSInter4vBlocks(GetVolConfigDCECSInter4vBlocks(vol_config), curr_vop_bb);
  PutVopNotCodedBlocks(GetVolConfigNotCodedBlocks(vol_config), curr_vop_bb);
  PutVopDCECSNotCodedBlocks(GetVolConfigDCECSNotCodedBlocks(vol_config), curr_vop_bb);
  PutVopTextureComplexityEstimationSet2Disable(GetVolConfigTextureComplexityEstimationSet2Disable(vol_config), curr_vop_bb);
  PutVopDCTCoefs(GetVolConfigDCTCoefs(vol_config), curr_vop_bb);
  PutVopDCECSDCTCoefs(GetVolConfigDCECSDCTCoefs(vol_config), curr_vop_bb);
  PutVopDCTLines(GetVolConfigDCTLines(vol_config), curr_vop_bb);
  PutVopDCECSDCTLines(GetVolConfigDCECSDCTLines(vol_config), curr_vop_bb);
  PutVopVLCSymbols(GetVolConfigVLCSymbols(vol_config), curr_vop_bb);
  PutVopDCECSVLCSymbols(GetVolConfigDCECSVLCSymbols(vol_config), curr_vop_bb);
  PutVopVLCBits(GetVolConfigVLCBits(vol_config), curr_vop_bb);
  PutVopDCECSVLCBits(GetVolConfigDCECSVLCBits(vol_config), curr_vop_bb);
  PutVopMotionCompensationComplexityDisable(GetVolConfigMotionCompensationComplexityDisable(vol_config), curr_vop_bb);
  PutVopAPM(GetVolConfigAPM(vol_config), curr_vop_bb);
  PutVopDCECSAPM(GetVolConfigDCECSAPM(vol_config), curr_vop_bb);
  PutVopNPM(GetVolConfigNPM(vol_config), curr_vop_bb);
  PutVopDCECSNPM(GetVolConfigDCECSNPM(vol_config), curr_vop_bb);
  PutVopInterpolateMCQ(GetVolConfigInterpolateMCQ(vol_config), curr_vop_bb);
  PutVopDCECSInterpolateMCQ(GetVolConfigDCECSInterpolateMCQ(vol_config), curr_vop_bb);
  PutVopForwBackMCQ(GetVolConfigForwBackMCQ(vol_config), curr_vop_bb);
  PutVopDCECSForwBackMCQ(GetVolConfigDCECSForwBackMCQ(vol_config), curr_vop_bb);
  PutVopHalfpel2(GetVolConfigHalfpel2(vol_config), curr_vop_bb);
  PutVopDCECSHalfpel2(GetVolConfigDCECSHalfpel2(vol_config), curr_vop_bb);
  PutVopHalfpel4(GetVolConfigHalfpel4(vol_config), curr_vop_bb);
  PutVopDCECSHalfpel4(GetVolConfigDCECSHalfpel4(vol_config), curr_vop_bb);

	/* START: Complexity Estimation syntax support - Update version 2 - Massimo Ravasi (EPFL) - 26 Oct 1999 */
  PutVopVersion2ComplexityEstimationDisable(GetVolConfigVersion2ComplexityEstimationDisable(vol_config), curr_vop_bb);
  PutVopSadct(GetVolConfigSadct(vol_config), curr_vop_bb);
  PutVopDCECSSadct(GetVolConfigDCECSSadct(vol_config), curr_vop_bb);
  PutVopQuarterpel(GetVolConfigQuarterpel(vol_config), curr_vop_bb);
  PutVopDCECSQuarterpel(GetVolConfigDCECSQuarterpel(vol_config), curr_vop_bb);
  /* END: Complexity Estimation syntax support - Update Version 2 */
  /* END: Complexity Estimation syntax support */



  PutVopInterlaced(vol_config->interlaced, curr_vop_bb);
  PutVopTopFieldFirst(vol_config->top_field_first, curr_vop_bb);
  PutVopAlternateScan(vol_config->alternate_scan, curr_vop_bb);
  curr_vop_bb->mvfileusage = vol_config->mvfileusage;
  curr_vop_bb->mvfile = vol_config->mvfile;
  curr_vop_bb->mvlinenop = &vol_config->mvlineno;
  curr_vop_bb->mvfilename = vol_config->mvfilename;
  curr_vop_bb->sr_direct = vol_config->sr_direct;
  curr_vop_bb->vo_id = vo_id;

  /* set default value for shape_coding_type */
/* begin: added for OBSS by Samsung AIT (1999-09-29) */
  if (!(GetVopScalability(curr_vop_bb) && !GetVopHierarchyType(curr_vop_bb) &&
        (!GetVopEnhanceType(curr_vop_bb) || !GetVopUseRefShape(curr_vop_bb))) &&
        !(GetVopScalability(curr_vop_bb) && GetVopShape(curr_vop_bb)==BINARY_SHAPE_ONLY) )
  {
/* end: added for OBSS by Samsung AIT (1999-09-29) */
  if (GetVopPredictionType(curr_vop_bb) == I_VOP) 		
    PutVopShapeCodingType(0,curr_vop_bb);
  else 
    PutVopShapeCodingType(1,curr_vop_bb);
/* begin: added for OBSS by Samsung AIT (1999-09-29) */
  } else if (GetVopShape(curr_vop_bb)==BINARY_SHAPE_ONLY ||
                !GetVopUseRefShape(curr_vop_bb)) 
  {    
    if (GetVopPredictionType(curr_vop_bb) == I_VOP ||
          GetVopPredictionType(curr_vop_bb) == P_VOP)
      PutVopShapeCodingType(0,curr_vop_bb);
    else
      PutVopShapeCodingType(1,curr_vop_bb);
  }
/* end: added for OBSS by Samsung AIT (1999-09-29) */

  /* under certain conditions this default is not used i.e. */

   if (  (GetVopShape(curr_vop_bb) != BINARY_SHAPE_ONLY) &&
         (!GetVopScalability(curr_vop_bb)) &&
         (!GetVopErrorResDisable(curr_vop_bb)) &&
         (GetVopShape(curr_vop_bb)) &&
         (GetVopPredictionType(curr_vop_bb) != I_VOP) &&
         (GetVopPredictionType(curr_vop_bb) != B_VOP))
      {
       if (((vol_config->frame - vol_config->start_frame -
             GetVolConfigM(vol_config) * vol_config->frame_skip) %
            (vol_config->frame_skip *
            GetVolConfigIntraShapePeriod(vol_config))) != 0)
         {
           PutVopShapeCodingType(1,curr_vop_bb);
         }
       else
         PutVopShapeCodingType(0,curr_vop_bb);
      }
  
  /* Sprite utilities */
  PutVopSpriteUsage(GetVolConfigSpriteUsage(vol_config), curr_vop_bb);
  if (GetVopSpriteUsage(curr_vop_bb) == STATIC_SPRITE)
    PutVopShapeCodingType(0,curr_vop_bb);
  PutVopBrightnessChangeFactor(1.0, curr_vop_bb);
  if (GetVolConfigSpriteUsage(vol_config) != SPRITE_NOT_USED)
    {
      PutVopSpriteHdim(GetVolConfigSpriteHdim(vol_config), curr_vop_bb);
      PutVopSpriteVdim(GetVolConfigSpriteVdim(vol_config), curr_vop_bb);
      PutVopSpriteLeftEdge(
			   GetVolConfigSpriteLeftEdge(vol_config), curr_vop_bb);
      PutVopSpriteTopEdge(
			  GetVolConfigSpriteTopEdge(vol_config), curr_vop_bb);
      PutVopSprite(GetVolConfigSprite(vol_config), curr_vop_bb);
      PutVopNoOfSpritePoints(
			     GetVolConfigNoOfSpritePoints(vol_config), curr_vop_bb);
      PutVopWarpingAccuracy(
			    GetVolConfigWarpingAccuracy(vol_config), curr_vop_bb);
      PutVopBrightnessChangeInSprite(
				     GetVolConfigBrightnessChangeInSprite(vol_config),curr_vop_bb);
      PutVopLowLatencySpriteEnable(
				   GetVolConfigLowLatencySpriteEnable(vol_config),curr_vop_bb);

      if (GetVolConfigNoOfSpritePoints(vol_config)
	  &&GetVopPredictionType(curr_vop_bb)==SPRITE_VOP) {
	tmp_refpoint = GetVolConfigRefPointCoord(vol_config);
	for (i=0 ; i<GetVolConfigNoOfSpritePoints(vol_config); i++)
	  {
	    tmp_refpoint[i].x = 
	      GetVopHorSpatRef(curr_vop_bb)+(i%2)*GetVopWidth(curr_vop_bb);
	    tmp_refpoint[i].y = 
	      GetVopVerSpatRef(curr_vop_bb)+(i>>1)*GetVopHeight(curr_vop_bb);
	  }
	PutVopRefPointCoord(tmp_refpoint, curr_vop_bb);
	PutVopRefPointCoord(tmp_refpoint, GetVolConfigSprite(vol_config));
      }
    }

  /* SONY 070498 - start */  
  if ((GetVolConfigGOVPeriod(vol_config))
      &&((vol_config->scalability==0)
         &&((vol_config->frame - vol_config->start_frame - vol_config->frame_skip*GetVolConfigM(vol_config))%
            (vol_config->frame_skip*GetVolConfigGOVPeriod(vol_config))==0))
      &&((GetVopPredictionType(curr_vop_bb)==I_VOP)||(GetVopPredictionType(curr_vop_bb)==SPRITE_VOP)))
    {
      num_bits[vo_id][vol_id].syntax +=
        BitstreamPutGOV(curr_vop_bb,vo_id,time,TRD,vol_config);
    }
  /* SONY 070498 - end */
  
  /* Don't attempt to code empty VOPs */
  if(vop_has_content)
    {
      /* Set up reconstructed vop */
      rec_curr = SetUpRecVop(curr_vop_bb);
	
      /*unrestricted_motion_mode = GetVopConfigUnrestrictedMotionMode(vop_cfg);*/

      /* Set to DEFAULT for time being */
      unrestricted_motion_mode = 1;	

      /* Set alpha coding threshold */
      if (RCQ2_MVO_CHECK() >= RCQ2_MVO_ENABLED) {
	if(vo_id==0) {
	  RCQ2_MVO_ShapeControl(vol_config);
	  alpha_th = GetVolConfigAlphaTh(vol_config);
	  rc_mvo.alphath = alpha_th;		    
	}
	else 
	  alpha_th = rc_mvo.alphath;
      }
      else
	alpha_th = GetVolConfigAlphaTh(vol_config); 


      /* Set RateControl type -> now passed as parameter! */
      /* rc_type = GetVolConfigRateControl(vol_config);*/

      /* Code the image data (YUVa) of the vop */
      /* TPS */



      VopCode(curr_vop_bb,
	      prev_vop,
	      prev_rec_vop,
	      next_vop,
	      next_rec_vop,
	      vo_id,
	      vol_id,
	      vo_config_list, /* UPM Global RC */
	      alpha_th,
	      obmc_disable,
	      unrestricted_motion_mode,
	      quarter_pel,		/* MW QPEL 07-JUL-1998 */
	      enable_8x8_mv,
	      rc_type,
	      rc_algorithm,  /* hjlee */
	      time,
	      vol_config, TRB, TRD,
	      rec_curr,
	      num_bits,
	      no_padding_vop,
	      temporal_scalability);

      /* Added call to TM5 RC update module */
      /* MW 14-MAY-1998 thanks to Uli */
      if (rc_type >= TM5_RATE_CONTROL)
	tm5rc_update_pict(curr_vop_bb, &num_bits[vo_id][vol_id], 
			  vol_config->rcdata);
    }
  /*** 10/27 TPS */
  else{
    if(GetVopScalability(curr_vop_bb))
      PutVopPredictionType(P_VOP,curr_vop_bb);

    if(temporal_scalability == 2 &&
       !GetVopScalability(curr_vop_bb) &&
       vop_has_content == 0){
      static Int prev_type = -1;
      if(prev_type == -1 || prev_type == B_VOP)
	PutVopPredictionType(P_VOP,curr_vop_bb);
      else if (prev_type == P_VOP)
	PutVopPredictionType(B_VOP,curr_vop_bb);
      
      prev_type = GetVopPredictionType(curr_vop_bb);
      fprintf(stderr,"PredictionType = %d\n",prev_type);

      if(!(prev_type == -1 || prev_type == B_VOP || prev_type == P_VOP)){
	fprintf(stderr,"-Error- PredictionType = %d\n",prev_type);
	exit(-1);
      }
    }
	    
    if((temporal_scalability == 2 || temporal_scalability == 5) &&
       GetVolConfigScalability(vol_config)==1 &&
       GetVopPredictionType(prev_rec_vop)!=B_VOP)
      modulo_tps = 1;
	    
    num_bits[vo_id][vol_id].syntax +=
      BitstreamPutVopHeader(curr_vop_bb,vo_id,time,TRB,vol_config,
			    num_bits,vo_config_list, rc_type,
			    modulo_tps);
  }
  /* 10/27 TPS ***/

  return(rec_curr);
}

/***********************************************************CommentBegin******
 *
 * -- VopCode -- Shape, texture and motion coding of the vop
 *
 * Author :
 * Noel O'Connor Teltec Irl.
 *
 * Created :
 * 11-03-96
 *
 * Purpose :
 * This function performs shape, texture and motion coding of the
 * vop passed to it. The input vop is assumed to be BOUNDED.
 * 
 * Arguments in : 
 * Vop *curr - pointer to vop to be coded
 * Vop *prev - pointer the last occurence of this vop
 * Vop *rec_prev - pointer to last coded occurence of this vop
 * Int vol_id - id of VOL to which this VOP belongs
 * Int alpha_th - shape coding threshold
 * Int obmc_disable - advanced motion mode flag
 * Int unrestricted_motion - unrestricted motion mode flag
 * Int enable_8x8_mv - 8x8 motion vectors flag (SpSc)
 * Int intra_dcpred_disable - disable intradc prediction
 * Int vo_id - current VO_ID
 * Int rc_type - rate control type
 * Float time -
 * VolConfig *vol_config -
 *
 * Arguments in/out :
 * Vop *rec_curr - coded vop
 * Bitcount num_bits[] - array of BitCount structures (one for
 *  each VOL).
 *
 * Arguments out :
 * -
 *
 * Return values :
 * none
 *
 * Side effects :
 * -
 *
 * Description :
 * -
 *
 * See also :
 * file "README_ALPHA"
 *
 * Modified :
 * 28.08.96 Noel O'Connor: added vol_id argument
 * 04.09.96 Cor Quist: added intra_dcpred_disable
 * 05.09.96 Jan De Lameillieure (HHI): inter shape coding
 * 23.09.96 Noel O'Connor: Some changes to allow coding of multiple VOs
 * 23.10.96 Robert Danielsen: Removed intra_dcpred_disable, get it from
 *          Vop-structure directly instead.
 * 23.10.96 Aasmund.Sandvand@fou.telenor.no: Modified to support deblock
 *          filtering
 * 06.11.96 Jan De Lameillieure: removed clamping after motion
 *          compensated prediction of alpha plane (obsolete since VM4.0)
 * 28.01.97 Robert Danielsen: Added freeing of comp. Bugfix from
 *          Noel O'Connor.
 * 04.02.97 Noel O'Connor: mods for non unique VOL Ids
 * 07.02.97 J. Ignacio Ronda: rc_type, time and vol_config input parameters
 *          added. Modification to allow VM5 rate control.
 *          BitstreamPutVopHeader() with updated quantizer in case of VM5
 *          rate control.
 * 11.03.97 Minhua Zhou: added B-VOPs
 * 21.04.97 Jan De Lameillieure : called grey level alpha coding with the 
 *          grey level (GL) quantiser
 * 26.04.97 Luis Ducla-Soares: added the error resilient combined mode with
 *          data partitioning.
 * 06.05.97 Noel Brady: Modified calls to VopShapeCode() for CAE.
 * 15.05.97 Luis Ducla-Soares: corrected the remultiplexing of DCT data in
 *          the combined error resilient mode with data partitioning.
 * 07.07.97 Martina Eckert: Introduction of global rate control 
 *          functions and parameters
 * 31.07.97 Fernando Jaureguizar: added GetVopScalability() (SpSc)
 * 01.08.97 Fernando Jaureguizar: added enable_8x8_mv parameter (SpSc)
 *          Changed in MotionEstimation() call its obmc_disable
 *          input parameter by enable_8x8_mv.
 * 06.08.97 Noel Brady: added mods for BINARY_SHAPE_ONLY
 * 08.09.97 Cecile Dufour: added arguments in VOPHeader for STATIC Sprite
 * 14.10.97 Noel Brady: ChangeMBType is not called when the decoded VOP is 
 *											a B-VOP
 * 14.10.97 Noel Brady: shape MC for B-VOPs uses the most recently decoded 
 *											I/P VOP i.e. the backward reference.
 * 19.11.97 Noel Brady: Several changes to do with error resilient shape
 * 27.11.97 M. Eckert: Changes for independent frame rate type control
 * 11.12.97 Bob Eifrig: Modifications for interlaced video coding
 * 13.01.97 Noel Brady: support for error resileint shape coding in B-VOPs
 * 27.01.98 M. Eckert and F. Jaureguizar: Updated the VopCodeTextInter()
 *          and RC_QuantAdjust() calls.
 *          Deleted PutVolConfig*Quantizer() and PutVop*Quantizer() calls
 *          because now they are called inside RC_QuantAdjust().
 * 27.03.98 M.Wollborn: Modified due to N2171 Cl. 2.5.3 intra_dc_vlc_thr
 * 07.05.98 Jong Deuk Kim (HYUNDAI) : field-based ME/MC padding
 * 21.05.98 Ji Heon Kweon (HYUNDAI) : support for grayscale coding
 * 09.12.98 Ulrich Benzler (University of Hannover) : added interlaced greyscale support
 * 15.02.99 U. Benzler : added quarter pel support
 * 03.03.99 Seishi TAKAMURA (NTT): added GMC coding
 * 07.04.99 Noboru Yamaguchi: revised HEC for shape
 * 29.07.99 U. Benzler : included the combined_decode.c-patch 28.10.98 - Shinya Kadono (SB) also for the encoder
 * 16.08.99 Shigeru FUkunaga (Oki): added modules for NEWPRED
 * 06.09.99 Eishi Morimatsu (Fujitsu Labs.): added DRC support
 * 09.29.99 Dae-Sung Cho (Samsung AIT): added support for OBSS
 * 14.12.99 Eishi Morimatsu (Fujitsu Labs.): bug fix for DRC
 *
 ***********************************************************CommentEnd********/
/* TPS */
Void VopCode(Vop *curr, 
	     Vop *prev, 
	     Vop *rec_prev,
             Vop *next_vop,
             Vop *next_rec_vop, 
	     Int vo_id, 
	     Int vol_id,
             VOConfig *vo_config_list, /* UPM Global RC */
	     Int alpha_th,
	     Int obmc_disable,
	     Int unrestricted_motion,
	     Int quarter_pel,	/* MW QPEL 07-JUL-1998 */
	     Int enable_8x8_mv, /*SpSc*/
	     Int rc_type,
	     Int rc_algorithm, /* hjlee */
	     Float time,
	     VolConfig *vol_config, Int TRB, Int TRD,
	     Vop *rec_curr,
	     BitCount num_bits[MAX_NUM_VOS][MAX_NUM_VOLS],
	     Vop *no_padding_vop,
	     Int temporal_scalability)
/**/
{
  Vop *ref_vop;
  Vop *up_vop=NULL;     /* added for OBSS by Samsung AIT (1999-09-29) */
  
  Image		*first_shape_code_bitstream,
		*shape_bitstream, 		/* Intermediate integer level  	 */
		*texture_bitstream,	 	/* bitstream data structures  	 */
		*motion_bitstream,		/* for shape, motion and texture  */
		*mottext_bitstream,
		*motion_comb_bitstream,
		*text_header_comb_bitstream,
		*text_data_comb_bitstream,
		*comb_bitstream,
		*aux_bitstream;

  ImageF	*mot_x, *mot_y;

  static ImageF *mot_x_P[MAX_NUM_VOS][MAX_NUM_VOLS], 
		*mot_y_P[MAX_NUM_VOS][MAX_NUM_VOLS];

  Image		**Shape_stream, **First_stream;

  static Image	*MB_decisions_P[MAX_NUM_VOS][MAX_NUM_VOLS];

  Image		*MB_decisions=NULL, *alpha_decisions=NULL,
		*alpha_sub_pad=NULL;
	
  Int		edge,f_code_for=1,f_code_back=1;

  Int		shape_bits=0;

  Vop		*comp = NULL, 
		*error_vop=NULL, 
		*rec_error;	/* will store motion compensated alpha plane */

  Int		num_pixels = GetVopWidth(curr);
  Int		num_lines = GetVopHeight(curr);
  Int		MB_width = num_pixels / 16;
  Int		MB_height = num_lines /16;
  Int		i,j,k,i_next,j_next;
  Int		vop_quantizer;

  /*  for error resilience */
  Int           num_bits_MB, num_bits_packet;
  
  /* Modified due to N2171 Cl. 2.5.3 MW 28-MAR-1998 */
  /* Int           index,time_modulo; */
  /* Int           bits; */
  /* Float         time_inc; */

  Int           first_marker, after_marker;
  Int           ***DC_store = NULL;
  Int           **slice_nb = NULL;
  Int           slice_counter;
  Int           resync_marker_length;
  Int           f_code_max;

  /* for sprite */
  Sprite_motion	*warp_param=NULL, *prev_warp_param=NULL;
#ifdef _SPRITE_ENC_
  TrajPoint	*traj=NULL, *qtraj=NULL, *difftraj=NULL, *halftraj=NULL;
#else
  TrajPoint	*traj=NULL, *qtraj=NULL, *difftraj=NULL;
#endif
  Int		warp_param_counter;
  Int		flag_static_sprite_piece=0;

  Float mad =0;

  Int MB_in_VOP = MB_width * MB_height;    /* number of MBs in one vop;
					      only used in error resilient mode */
  Int vop_spat_scal=0;
	
/*** 10/27 TPS */
  Int  modulo_tps     = 0;
  Int vop_temp_scal   = 0;
  Int ref_vol_id      = GetVolConfigRefId( vol_config );
/* 10/27 TPS ***/

  /*necessary bits needed to code the MB number */
  Int MB_in_VOP_length = (Int) ceil(log(MB_in_VOP)/log(2)); 

  Int ResetPredictor = 1;	/* U. Benzler 990729 - Patch corresponding to combined_decode.c-patch 28.10.98 - Shinya Kadono (SB) */

  UInt  num_pels_vop; /* UPM Global RC - Number of pixels of current VOP */        
	Int start_of_packet;
	Int first_bits;

  UChar first_stream[7], shape_stream[4096];
  Image *pi=0, *pi_grey[MAX_MAC],*modeA=0,*motA_x=0,*motA_y=0; /* U. Benzler 981209 : added interlaced greyscale support */
  Int RESYNC_MARKER_SPACING = GetVolConfigPacketSize(vol_config);

  /** added for NEWPRED (Oki) 16-AUG-1999 **/
  Int np_vop_id;
  Int np_seg_id;
  /** end of NEWPRED (Oki) 16-AUG-1999 **/

  Int aux; 	/* MAC (SB) 16-Nov-99 */

/* >>> added for DRC by Fujitsu (top)    <<< */
    Vop *reduced_res_curr=NULL, *reduced_res_rec_curr=NULL;
    Vop *reduced_res_error_vop=NULL, *reduced_res_rec_error=NULL;
    Image *mot_x_rr, *mot_y_rr;
    Int *cod_flag, cod_flag_mb;
    Int *vp_num; /* DRC 1999.12.14 */
    Int mb_size_variable;
    Int mba_scale;
/* >>> added for DRC by Fujitsu (bottom) <<< */

  /** added for NEWPRED (Oki) 16-AUG-1999 **/
  if(GetVopNewpredEnable(curr)){
    /* set vop_id for NEWPRED */
    np_vop_id = GetVopNewpredVopId(curr);
  }
  /** end of NEWPRED (Oki) 16-AUG-1999 **/

/* >>> added for DRC by Fujitsu (top)    <<< */
  if (GetVopReducedResolution(curr)==1) {
      MB_width = num_pixels / 32;
      MB_height = num_lines / 32;
      MB_in_VOP = MB_width * MB_height; 
      MB_in_VOP_length = (Int) ceil(log(MB_in_VOP*4)/log(2)); 
      mb_size_variable = MB_SIZE*2;
      mba_scale = 4;
  } else {
      mb_size_variable = MB_SIZE;
      mba_scale = 1;
  }      
/* >>> added for DRC by Fujitsu (bottom) <<< */

  /* set the flag_static_sprite */
  if (GetVopPredictionType(curr)==SPRITE_PIECE || 
      GetVopPredictionType(curr)==SPRITE_UPDATE) 
    {
      flag_static_sprite_piece = 1;
      if (GetVopPredictionType(curr)==SPRITE_PIECE)
	{
	  PutVopPredictionType(I_VOP, curr);
	  PutVopPredictionType(I_VOP, rec_curr);
	}
      else
	{
	  PutVopPredictionType(P_VOP, curr);
	  PutVopPredictionType(P_VOP, rec_curr);
	}
    }
   
  /* Getting the VOP ScalType, for spat scal (UPS)*/
  /*** 10/27 TPS */
  if((temporal_scalability == 2 || temporal_scalability == 5) &&
     GetVolConfigScalability(vol_config)==1 &&
     GetVopPredictionType(rec_prev)!=B_VOP)
    {
      modulo_tps = 1;
    }

  if(GetVopScalability(curr) ==1){ 
    /*SpSc*/
    if (( GetVopPredictionType(curr)==P_VOP 
	  && GetVopRefSelCode(curr) ==3)
	|| ( GetVopPredictionType(curr)==B_VOP 
	     && GetVopRefSelCode(curr) ==0))
      {
	vop_spat_scal=1;
      }
    /* TPS */
    else if(GetVopPredictionType(curr)==P_VOP &&
	    (GetVopRefSelCode(curr) == 0 ||
	     GetVopRefSelCode(curr) == 1 ||
	     GetVopRefSelCode(curr) == 2)        )
      {
	vop_temp_scal = 3;       /* P_VOP        : TPS */    
      }
    else if(GetVopPredictionType(curr) == B_VOP)
      {
	if(GetVopRefSelCode(curr) == 3)
	  vop_temp_scal = 1;   /* B_VOP_TYPE_1 : TPS */    
        else if(GetVopRefSelCode(curr) == 1)
	  vop_temp_scal = 2;   /* B_VOP_TYPE_2 : TPS */    
      }
    
    if(!vop_spat_scal && GetVopPredictionType(curr) != I_VOP &&
       temporal_scalability != vop_temp_scal)
    if(!((temporal_scalability == 4 || temporal_scalability == 5) &&
	 vop_temp_scal == 3))
      {
        fprintf(stderr,"\n-ERROR- tps_mode is right[%d] : wrong[%d]\n",
		temporal_scalability,
		vop_temp_scal);
	exit(-1);
      }
  }
  /* 10/27 TPS ***/

  
  /* Initialise the integer level intermediate bitstreams */
  first_shape_code_bitstream = BitstreamInit();
  shape_bitstream = BitstreamInit();
  texture_bitstream = BitstreamInit();
  motion_bitstream = BitstreamInit();
  mottext_bitstream = BitstreamInit();

  /* Allocate shape stream */
  First_stream = (Image **)calloc((GetVopWidth(curr)/MB_SIZE)*
				  (GetVopHeight(curr)/MB_SIZE), sizeof(Image *));
  Shape_stream = (Image **)calloc((GetVopWidth(curr)/MB_SIZE)*
				  (GetVopHeight(curr)/MB_SIZE), sizeof(Image *));

  for(i=0; i<(GetVopWidth(curr)/MB_SIZE)*(GetVopHeight(curr)/MB_SIZE); i++) 
    {
      First_stream[i] = BitstreamInit();
      Shape_stream[i] = BitstreamInit();
    }
  
   /* HYUNDAI (Grayscale) */
  /* if (GetVopShape(curr) == GREY_SCALE)
     CopyImage(GetVopA(curr),GetVopG(curr));*/ 	/* MAC (SB) 16-Nov-99 */

    ObtainSupport(curr->a_chan);


  /* Left in for the software, flag is no longer in syntax however */
  /* due to N2171. MW 27-MAR-1998				   */
  if (GetVopErrorResDisable(curr) != NON_ERROR_RESILIENT)
    {
      DC_store = (Int ***)calloc(MB_width*MB_height,sizeof(Int **));
      for (i = 0; i < MB_width*MB_height; i++)
	{
	  DC_store[i] = (Int **)calloc(6, sizeof(Int *));
	  for (j = 0; j < 6; j++)
	    DC_store[i][j] = (Int *)calloc(15, sizeof(Int));
	}
      
      slice_nb = (Int **)calloc(MB_width,sizeof(Int *));
      for (i = 0; i < MB_width; i++)
        slice_nb[i] = (Int *)calloc(MB_height, sizeof(Int));
    }

  if (GetVopPredictionType(curr) == SPRITE_VOP)
    {
      /* GET THE WARPING PARAMETERS */
      if (GetVolConfigSpriteUsage(vol_config) == STATIC_SPRITE)
	{
#ifdef _SPRITE_ENC_
          halftraj = ReadHalfTraj(GetVolConfigNoOfSpritePoints(vol_config),
                              curr->frame,
                              GetVolConfigWarpParamFile(vol_config));
#endif
	  warp_param_counter =
	    GetVolConfigWarpParamCounter(vol_config);
	  warp_param = ReadWarpingParameters(
	    GetVolConfigNoOfSpritePoints(vol_config),
	    warp_param_counter,
	    GetVolConfigWarpParamFile(vol_config));
	  warp_param_counter++;
	  PutVolConfigWarpParamCounter(warp_param_counter,vol_config);
	}/* CASE STATIC SPRITE */
/* modified by NTT for GMC coding : start */
      else if (GetVolConfigSpriteUsage(vol_config) == GMC_SPRITE) {
	  warp_param =
	      GlobalMotionEstimation(prev, curr, GetVolConfigNoOfSpritePoints(vol_config));
      }
/* modified by NTT for GMC coding : end */
      
      /* produce trajectories and quant the motion param.*/
      /* compute trajectories from global motion */
      if (GetVolConfigNoOfSpritePoints(vol_config))
	{
#ifdef _SPRITE_ENC_
	  traj = MakeTrajectories(warp_param,
				  GetVolConfigNoOfSpritePoints(vol_config),
				  GetVolConfigRefPointCoord(vol_config),
					halftraj);
	  free(halftraj);
#else
	  traj = MakeTrajectories(warp_param,
				  GetVolConfigNoOfSpritePoints(vol_config),
				  GetVolConfigRefPointCoord(vol_config));
#endif
	  PutVopTrajPointCoord(traj,GetVolConfigSprite(vol_config));
	  difftraj = MakeDiffTraj(GetVolConfigNoOfSpritePoints(vol_config), traj);
	  PutVopDiffTrajPointCoord(difftraj,curr);
	  
	  /* recompute global motion from trajectories */
	  qtraj = AddTraj( GetVolConfigNoOfSpritePoints(vol_config),difftraj);
	  PutVopTrajPointCoord(qtraj,curr);
	  PutVopTrajPointCoord(qtraj,rec_curr);
	}
      
      printf("\t\t param = %.4f   %.4f   %.4f \n \t\t\t %.4f   %.4f   %.4f\n \t\t\t %.8f   %.8f\n",
	     warp_param->a1,
	     warp_param->a2,
	     warp_param->a3,
	     warp_param->a4,
	     warp_param->a5,
	     warp_param->a6,
	     warp_param->a7,
	     warp_param->a8);
      
      PutVopWarpParam(warp_param, curr);
      PutVopWarpParam(warp_param, rec_curr);
      
    } /* CASE SPRITE_VOP */
  
  /* Decide what coding (INTRA/INTER) to perform on vop */
  if (GetVopPredictionType(curr) == I_VOP)  /* I-VOP, SPRITE PIECES */					/* I-VOP */
    {
      if (GetVopPredictionType(curr) == I_VOP && flag_static_sprite_piece!=1)
	{
	  /* RC-BIP: Independent rate control also for I-frames: */
	  if (RCQ2_MVO_CHECK() == RCQ2_MVO_HVS) 
	    SetFirstIntraQP(curr, vol_config, vo_id, vol_id);

	  if (rc_type == VM5_RATE_CONTROL)
	    {
	      if (prev != NULL) /* 1. frame */
	        mad = DSRC_compute_MAD(curr, &num_pels_vop); 
	      else
		{
		  mad = 1; /* dummy, not used for first call of RC_QuantAdjust */
		  num_pels_vop = GetVopWidth(curr) * GetVopHeight(curr);
		}

	      if (RCQ2_MVO_CHECK() >= RCQ2_MVO_ENABLED)  
	        ;
	      else 
		{
		  vop_quantizer = RC_QuantAdjust(vo_id, 
						 vol_id, 
						 vo_config_list, 
						 vol_config, 
						 (Double)mad, 
						 curr, 
						 error_vop, 
						 num_pels_vop,
						 GetVopPredictionType(curr));
		  
		  fprintf(stdout,"\t\tIntra Quantizer : %d\n", 
			  (int)vop_quantizer);
		}
	    }
	  
	  /* Write Vop Header bitstream to disk */
	  if (GetVolConfigSpriteUsage(vol_config) == STATIC_SPRITE) 
	    /* case of the first Sprite piece in VOL header */
	    num_bits[vo_id][vol_id].sprite_piece +=
	      BitstreamPutVopHeader(curr,vo_id,time,TRB,vol_config,
				    num_bits,vo_config_list, rc_type, 
				    modulo_tps);
	  else
	    num_bits[vo_id][vol_id].syntax +=
	      BitstreamPutVopHeader(curr,vo_id,time,TRB,vol_config,
				    num_bits,vo_config_list, rc_type, 
				    modulo_tps);
	}

      /* Put some text for user */
      if (GetVolConfigSpriteUsage(vol_config) == STATIC_SPRITE) {
        if (GetVolConfigLowLatencySpriteEnable(vol_config))
          fprintf(stdout,"\tI_VOP encoding of object-piece (low latency static sprite syntax)\n");
	else
          fprintf(stdout,"\tI_VOP encoding of the basic sprite \n");
      }

      /* for TPS and ssp */
/* begin: modified for OBSS by Samsung AIT (1999-09-29) */
      /* if ( GetVopScalability( curr ) ) */
      if ( GetVopScalability( curr ) && GetVopShape(curr) != BINARY_SHAPE_ONLY)
/* end: modified for OBSS by Samsung AIT (1999-09-29) */
        WriteBGCAlphaBitstream( curr , vo_id , vol_id , num_bits , back_base_exist );
      /**/
      
      /* only code shape if it is necessary */
      if ((GetVopShape(curr) == BINARY) || (GetVopShape(curr) == GREY_SCALE)
	  || (GetVopShape(curr) == BINARY_SHAPE_ONLY) )  /* BSO_NOEL */
	{
	  if (GetVopErrorResDisable(curr) == NON_ERROR_RESILIENT)
	    {
	      /* Put some text for user */
	      fprintf(stdout,"\t\tPerforming shape coding\n");
	      
	      ce_bits_for_shape[vol_id] = ce_bits_for_vop = 
		ce_coded_frames[vol_id] = 0;
	      

	      /* Code shape */
	      shape_bits = VopShapeCode(curr,
					rec_curr,
					(Vop *)NULL,
                                                (Vop *)NULL,    /* added for OBSS by Samsung AIT (1999-09-29) */
					vo_id,
					alpha_th,
					(Image *)NULL,
					(Image *)NULL,
					(Image *)NULL,
					(Image *)NULL,
					First_stream,
					Shape_stream
					);
	    }
	  else 
	    {
	      CopyImage(GetVopA(curr), GetVopA(rec_curr));
	    }
	  
	  SubsampleAlphaMap(GetVopA(rec_curr),GetVopAuv(rec_curr), 1,
		  	     GetVopInterlaced(rec_curr) /* HYUNDAI 980507 */);
	  SubsampleAlphaMap(GetVopA(curr),GetVopAuv(curr),1,
			     GetVopInterlaced(curr) /* HYUNDAI 980507 */);
	}
      else				/* RECTANGULAR SHAPE */
	{
	  /* Put some text for user */
	  fprintf(stdout,"\t\tNo shape coding required\n");

	  /* Must fill rec_curr alpha field */
	  CopyImage(GetVopA(curr),GetVopA(rec_curr)); 
          SetConstantImage(GetVopAuv(curr),255);
          SetConstantImage(GetVopAuv(rec_curr),255);
	}
		
      /* Put some text for user */
      fprintf(stdout,"\t\tCoding INTRA texture \n\n");
	
      /* The error-resilience-disable flag is no longer present in  */
      /* the syntax due to N2171 Cl. 2.5.14. However, the flag is   */
      /* still used in the encoder software to disable all error-   */
      /* resilience tools with one parameter and to use the part of */
      /* the software which is especially implemented for not using */
      /* error resilience tools.                                    */
      /*							    */
      /* The part of the software for the error-resilient encoding  */
      /* has not been used here, since there each time a video-     */
      /* packet header incl. header extension is sent, what is not  */
      /* necessarily required in non-error-resilient mode.          */
      /*							    */
      /* MW, 27-MAR-1998					    */

      if (GetVopErrorResDisable(curr) == NON_ERROR_RESILIENT)       /* non error resilient mode */
	{
	  /* Code Texture in Intra mode */
	  /* combined motion/texture mode */
/* >>> added for DRC by Fujitsu (top)    <<< */
 	  if (GetVopReducedResolution(curr)!=1) {
/* >>> added for DRC by Fujitsu (bottom) <<< */
	  VopCodeShapeTextIntraCom(curr,
				   First_stream,
				   Shape_stream,
				   rec_curr,
				   texture_bitstream,
				   &num_bits[vo_id][vol_id].text_bits,
				   rc_type,
				   vo_id,
				   vol_config);
/* >>> added for DRC by Fujitsu (top)    <<< */
	  } else {
	    VopCodeShapeTextIntraCom_ReducedRes(curr,
				   First_stream,
				   Shape_stream,
				   rec_curr,
				   texture_bitstream,
				   &num_bits[vo_id][vol_id].text_bits,
				   rc_type,
				   vo_id,
				   vol_config);
	  } 
/* >>> added for DRC by Fujitsu (bottom) <<< */
	  
				
	  if (GetVolConfigSpriteUsage(vol_config) == STATIC_SPRITE)
	    {
	      num_bits[vo_id][vol_id].sprite_piece += 
		BitstreamPut(first_shape_code_bitstream,vo_id,vol_id);
	      num_bits[vo_id][vol_id].sprite_piece += 
		BitstreamPut(shape_bitstream,vo_id,vol_id);
	      num_bits[vo_id][vol_id].sprite_piece += 
		BitstreamPut(texture_bitstream,vo_id,vol_id);
	    }
	  else
	    {	  
	      /* Write shape bitstream to disk */
	      num_bits[vo_id][vol_id].shape +=
		BitstreamPut(first_shape_code_bitstream,vo_id,vol_id); 
	      num_bits[vo_id][vol_id].shape +=
		BitstreamPut(shape_bitstream,vo_id,vol_id); 
	      
	      /* Write texture bitstream to disk */
	      num_bits[vo_id][vol_id].texture +=
		BitstreamPut(texture_bitstream,vo_id,vol_id);
	    } 
	  
	}   /* End non error resilient mode */
      else
	{      /* error resilient mode  */
	  resync_marker_length = 17;
	  
/* >>> added for DRC by Fujitsu (top)    <<< */
          if (GetVopReducedResolution(curr)==1) {
	    reduced_res_curr = AllocVop(num_pixels/2, num_lines/2, 0);
	    CopyVopNonImageField(curr,reduced_res_curr); 
	    reduced_res_rec_curr = AllocVop(num_pixels/2, num_lines/2, 0);
	    CopyVopNonImageField(rec_curr, reduced_res_rec_curr); 
            cod_flag = (Int*)malloc(num_pixels/32*num_lines/32*sizeof(Int)); 
            vp_num = (Int*)malloc(num_pixels/32*num_lines/32*sizeof(Int)); /* DRC 1999.12.14 */

	    SetConstantImage(GetVopA(reduced_res_curr),255);
	    SetConstantImage(GetVopAuv(reduced_res_curr),255);
	    SetConstantImage(GetVopA(reduced_res_rec_curr),255);
	    SetConstantImage(GetVopAuv(reduced_res_rec_curr),255);

	    DownSamplingTexture(curr, reduced_res_curr);
	  } else { /* DRC 1999.12.14 */
            vp_num = (Int*)malloc(num_pixels/16*num_lines/16*sizeof(Int)); /* DRC 1999.12.14 */
	  }
/* >>> added for DRC by Fujitsu (bottom) <<< */

	  if (GetVopShape(curr)) AllocShapePacket(curr);
	  
	  /* Code Texture in Intra mode */
	  
	  /* Data partitioning */
	  if (GetVopDataPartEnable(curr) 
	      && (GetVopShape(curr) != BINARY_SHAPE_ONLY))
	    {
	      slice_counter = 0;
	      num_bits_packet = 0;
	      first_marker = 1;
	      motion_comb_bitstream = BitstreamInit();
	      text_header_comb_bitstream = BitstreamInit();
	      text_data_comb_bitstream = BitstreamInit();
	      k=0;
	      start_of_packet = 1;
	      
/* >>> added for DRC by Fujitsu (top)    <<< */
/*
	      for (j = 0; j < num_lines/MB_SIZE; j++)
		{
		  for (i = 0; i < num_pixels/MB_SIZE; i++)
*/
	      for (j = 0; j < num_lines/mb_size_variable; j++)
		{
		  for (i = 0; i < num_pixels/mb_size_variable; i++)
/* >>> added for DRC by Fujitsu (bottom) <<< */
		    {
		      slice_nb[i][j] = slice_counter;
		      vp_num[i+j*num_pixels/mb_size_variable] = slice_counter+1; /* DRC 1999.12.14 */
		      
		      if ((GetVopShape(curr) == BINARY) || (GetVopShape(curr) == GREY_SCALE)
			  || (GetVopShape(curr) == BINARY_SHAPE_ONLY) ) 			  
			{
			  shape_bits = ShapeCodeMB(curr,
						   rec_curr,
						   NULL,
                                                   NULL,    /* added for OBSS by Samsung AIT (1999-09-29) */
						   vo_id,
						   j,
						   i,
						   alpha_th,
						   NULL,
						   NULL,
						   NULL,
						   NULL,
						   NULL,
						   NULL,
						   NULL,
						   &first_bits,
						   first_stream,
						   shape_stream,
						   start_of_packet
						   );
			  start_of_packet = 0;
			  BitstreamAppendTtoM(First_stream[k], first_stream, 
					      first_bits);
			  BitstreamAppendTtoM(Shape_stream[k], shape_stream, 
					      shape_bits);
			  k++;
			  total_shape_bits += shape_bits + first_bits;
			}
		      
		      /* combined motion/texture mode */
/* >>> added for DRC by Fujitsu (top)    <<< */
                      if (GetVopReducedResolution(curr)==1) {
		        MBCodeShapeTextIntraComErrRes(reduced_res_curr,
						    First_stream,
						    Shape_stream,
						    reduced_res_rec_curr,
						    motion_comb_bitstream,
						    text_header_comb_bitstream,
						    text_data_comb_bitstream,
						    i, j, &num_bits_MB,
						    DC_store, slice_nb,
						    &num_bits[vo_id][vol_id].text_bits);
                      } else {
/* >>> added for DRC by Fujitsu (bottom) <<< */
		      MBCodeShapeTextIntraComErrRes(curr,
						    First_stream,
						    Shape_stream,
						    rec_curr,
						    motion_comb_bitstream,
						    text_header_comb_bitstream,
						    text_data_comb_bitstream,
						    i, j, &num_bits_MB,
						    DC_store, slice_nb,
						    &num_bits[vo_id][vol_id].text_bits);
/* >>> added for DRC by Fujitsu (top)    <<< */
                      } 
/* >>> added for DRC by Fujitsu (bottom) <<< */
		      
		      num_bits_packet += num_bits_MB;
/* (Oki) 16-AUG-1999
 *		      if ((num_bits_packet >= RESYNC_MARKER_SPACING)
 *			  && ((j*MB_width+i) < (MB_height*MB_width-1)))
 */
		      /** modified for NEWPRED (Oki) 16-AUG-1999 **/
		      /*
		       *	I-VOP (Data Partitioning)
		       */
		      /* In resync slice mode, resync_marker is usually inserted
			 everywhere amount of slice bits is beyond the constant one.
			 In NEWPRED mode, when NEWPRED segment is Video Packet, resysnc_marker 
			 is inserted to the fixed position that is indicated in the control file. */
		      if((GetVopNewpredEnable(curr) && !GetVopNewpredSegmentType(curr) &&
			  ((j*MB_width+i != 0) && 
			   (j*MB_width+i+1 == vol_config->mba_segment[slice_counter+1]/mba_scale)) && /* >>> modified for DRC by Fujitsu <<< */
			  (j*MB_width+i < MB_height*MB_width-1)) ||
			 (((GetVopNewpredEnable(curr) && GetVopNewpredSegmentType(curr)) ||
			   !GetVopNewpredEnable(curr)) && /** Oki 26-AUG-1999 **/
			  (num_bits_packet >= RESYNC_MARKER_SPACING) &&
			  (j*MB_width+i < MB_height*MB_width-1)))
			/** end of NEWPRED (Oki) 16-AUG-1999 **/
			{
			  start_of_packet = 1;
			  
			  num_bits[vo_id][vol_id].mot_shape_text += 
			    BitstreamPut(motion_comb_bitstream,vo_id,vol_id);
			  BitstreamFree(motion_comb_bitstream);
			      
			  aux_bitstream = BitstreamInit();
			  BitstreamPutBits(aux_bitstream,DC_MARKER,DC_MARKER_LENGTH);

			  num_bits[vo_id][vol_id].syntax += 
			    BitstreamPut(aux_bitstream,vo_id,vol_id);
			  BitstreamFree(aux_bitstream);
			      
			  num_bits[vo_id][vol_id].mot_shape_text += 
			    BitstreamPut(text_header_comb_bitstream,vo_id,vol_id);
			  BitstreamFree(text_header_comb_bitstream);
			  
			  num_bits[vo_id][vol_id].mot_shape_text += 
			    BitstreamPut(text_data_comb_bitstream,vo_id,vol_id);
			  BitstreamFree(text_data_comb_bitstream);
			      
    /* revised HEC for shape due to N2693 */
			  aux_bitstream = BitstreamInit();
			  BitstreamPutBits(aux_bitstream,RESYNC_MARKER,resync_marker_length);
			  if (GetVopShape(curr) != RECTANGULAR) {
			    if (first_marker)
			      {
/*				first_marker = 0;*/
				/* Write the HEC-flag and then the HEC itself */
				BitstreamPutBits(aux_bitstream,1,1);
				BitstreamPutShapeHEC(vol_config, curr, aux_bitstream);

			      }
			    else
			      {  
				BitstreamPutBits(aux_bitstream,0,1);
			      }
			  }

			  BitstreamPutBits(aux_bitstream,j*MB_width+i+1,MB_in_VOP_length);
			  
			  if (GetVopShape(curr) != BINARY_SHAPE_ONLY)
			    BitstreamPutBits(aux_bitstream,GetVopIntraQuantizer(curr),
					     GetVopQuantPrecision(curr));
			      
			  if (first_marker)
			    {
			      first_marker = 0;
			      /* Write the HEC-flag and then the HEC itself */
			      if (GetVopShape(curr) == RECTANGULAR)
				BitstreamPutBits(aux_bitstream,1,1);
			      BitstreamPutHEC(vol_config, curr, time, aux_bitstream);

			    }
			  else
			    {  
			      if (GetVopShape(curr) == RECTANGULAR)
				BitstreamPutBits(aux_bitstream,0,1);
			    }

			  /** added for NEWPRED (Oki) 16-AUG-1999 **/
			  if(GetVopNewpredEnable(curr)){
			    /* insert additional syntax for NEWPRED */
			    BitstreamPutNEWPRED(vol_config, curr, np_vop_id, 
						slice_counter + 1, aux_bitstream, 0);
			  }
			  /** end of NEWPRED (Oki) 16-AUG-1999 **/

			  NextResyncMarker(vo_id,vol_id);
			  num_bits[vo_id][vol_id].syntax += 
			    BitstreamPut(aux_bitstream,vo_id,vol_id);
			  BitstreamFree(aux_bitstream);
			  
			  motion_comb_bitstream = BitstreamInit();
			  text_header_comb_bitstream = BitstreamInit();
			  text_data_comb_bitstream = BitstreamInit();
			  
			  num_bits_packet = 0;
			  slice_counter++;
			}
		    }
		}
	      
	      num_bits[vo_id][vol_id].mot_shape_text += 
		BitstreamPut(motion_comb_bitstream,vo_id,vol_id);
	      BitstreamFree(motion_comb_bitstream);
		  
	      aux_bitstream = BitstreamInit();
	      BitstreamPutBits(aux_bitstream,DC_MARKER,DC_MARKER_LENGTH);
	      num_bits[vo_id][vol_id].syntax += 
		BitstreamPut(aux_bitstream,vo_id,vol_id);
	      BitstreamFree(aux_bitstream);
		  
	      num_bits[vo_id][vol_id].mot_shape_text += 
		BitstreamPut(text_header_comb_bitstream,vo_id,vol_id);
	      BitstreamFree(text_header_comb_bitstream);
		
	      num_bits[vo_id][vol_id].mot_shape_text += 
		BitstreamPut(text_data_comb_bitstream,vo_id,vol_id);
	      BitstreamFree(text_data_comb_bitstream);
	    }
	  else /* No Data Partitioning */
	    {
	      slice_counter = 0;
	      num_bits_packet = 0;
	      start_of_packet = 1;
	      first_marker = 1;
	      comb_bitstream = BitstreamInit();
	      k=0;
		  
/* >>> added for DRC by Fujitsu (top)    <<< */
/*
	      for (j = 0; j < num_lines/MB_SIZE; j++)
		{
		  for (i = 0; i < num_pixels/MB_SIZE; i++)
*/
	      for (j = 0; j < num_lines/mb_size_variable; j++)
		{
		  for (i = 0; i < num_pixels/mb_size_variable; i++)
/* >>> added for DRC by Fujitsu (bottom) <<< */
		    {
		      slice_nb[i][j] = slice_counter;
		      vp_num[i+j*num_pixels/mb_size_variable] = slice_counter+1; /* DRC 1999.12.14 */
		      
		      if ((GetVopShape(curr) == BINARY) || (GetVopShape(curr) == GREY_SCALE)
			  || (GetVopShape(curr) == BINARY_SHAPE_ONLY) ) 			  
			{
			  shape_bits = ShapeCodeMB(curr,
						   rec_curr,
						   NULL,
							NULL, /* added for OBSS by Samsung AIT (1999-09-29) */
						   vo_id,
						   j, 
						   i,
						   alpha_th,
						   NULL,
						   NULL,
						   NULL,
						   NULL,
						   NULL,
						   NULL,
						   NULL,
						   &first_bits,
						   first_stream,
						   shape_stream,
						   start_of_packet
						   );
			  start_of_packet = 0;
			  BitstreamAppendTtoM(First_stream[k], first_stream, 
					      first_bits);
			  BitstreamAppendTtoM(Shape_stream[k], shape_stream, 
					      shape_bits);
			  k++;
			  total_shape_bits += shape_bits + first_bits;
			}
		      
		      /* combined motion/texture mode */
/* >>> added for DRC by Fujitsu (top)    <<< */
                      if (GetVopReducedResolution(curr)==1) {
		        MBCodeShapeTextIntraComErrRes(reduced_res_curr,
						    First_stream,
						    Shape_stream,
						    reduced_res_rec_curr,
						    comb_bitstream,
						    comb_bitstream,
						    comb_bitstream,
						    i, j, &num_bits_MB,
						    DC_store,slice_nb,
						    &num_bits[vo_id][vol_id].text_bits);
                      } else {
/* >>> added for DRC by Fujitsu (bottom) <<< */
		      MBCodeShapeTextIntraComErrRes(curr,
						    First_stream,
						    Shape_stream,
						    rec_curr,
						    comb_bitstream,
						    comb_bitstream,
						    comb_bitstream,
						    i, j, &num_bits_MB,
						    DC_store,slice_nb,
						    &num_bits[vo_id][vol_id].text_bits);
/* >>> added for DRC by Fujitsu (top)    <<< */
                      } 
/* >>> added for DRC by Fujitsu (bottom) <<< */
		      
		      num_bits_packet += num_bits_MB;
/* (Oki) 16-AUG-1999
 *		      if ((num_bits_packet >= RESYNC_MARKER_SPACING)
 *			  && ((j*MB_width+i) < (MB_height*MB_width-1)))
 */
		      /** modified for NEWPRED (Oki) 16-AUG-1999 **/
		      /*
		       *	I-VOP (non Data Partitioning)
		       */
		      /* In non NEWPRED on resync slice mode, resync_marker is inserted
			 everywhere amount of slice bits is beyond the constant one.
			 In NEWPRED mode, resysnc_marker is inserted to the fixed 
			 position that is indicated in the control file. */
		      if((GetVopNewpredEnable(curr) && !GetVopNewpredSegmentType(curr) &&
			  ((j*MB_width+i != 0) && 
			   (j*MB_width+i+1 == vol_config->mba_segment[slice_counter+1]/mba_scale)) && /* >>> modified for DRC by Fujitsu <<< */
			  (j*MB_width+i < MB_height*MB_width-1)) ||
			 (((GetVopNewpredEnable(curr) && GetVopNewpredSegmentType(curr)) ||
			   !GetVopNewpredEnable(curr)) && /** Oki 26-AUG-1999 **/
			  (num_bits_packet >= RESYNC_MARKER_SPACING) &&
			  (j*MB_width+i < MB_height*MB_width-1)))
			/** end of NEWPRED (Oki) 16-AUG-1999 **/
			{
			  start_of_packet = 1;
			  num_bits[vo_id][vol_id].mot_shape_text 
			    += BitstreamPut(comb_bitstream,vo_id,vol_id);
			  BitstreamFree(comb_bitstream);
			  
      /* revised HEC for shape due to N2693 */
			  aux_bitstream = BitstreamInit();
			  BitstreamPutBits(aux_bitstream,RESYNC_MARKER,resync_marker_length);
                          if (GetVopShape(curr) != RECTANGULAR) {
                            if (first_marker)
                              {
/*                                first_marker = 0;*/
                                /* Write the HEC-flag and then the HEC itself */
                                BitstreamPutBits(aux_bitstream,1,1);
                                BitstreamPutShapeHEC(vol_config, curr, aux_bitstream);

                              }
                            else
                              {  
                                BitstreamPutBits(aux_bitstream,0,1);
                              }
                          }

			  BitstreamPutBits(aux_bitstream,j*MB_width+i+1,MB_in_VOP_length);
			  
			  if (GetVopShape(curr) != BINARY_SHAPE_ONLY)
			    BitstreamPutBits(aux_bitstream,GetVopIntraQuantizer(curr),
					     GetVopQuantPrecision(curr));
			  
			  if (first_marker)
			    {
			      first_marker = 0;
			      /* Write the HEC-flag and then the HEC itself */
			      if (GetVopShape(curr) == RECTANGULAR)
				BitstreamPutBits(aux_bitstream,1,1);
			      BitstreamPutHEC(vol_config, curr, time, aux_bitstream);

			    }
			  else
			    {  
			      if (GetVopShape(curr) == RECTANGULAR)
				BitstreamPutBits(aux_bitstream,0,1);
			    }
			  
			  /** added for NEWPRED (Oki) 16-AUG-1999 **/
			  if(GetVopNewpredEnable(curr)){
			    /* insert additional syntax for NEWPRED */
			    BitstreamPutNEWPRED(vol_config, curr, np_vop_id, 
						slice_counter + 1, aux_bitstream, 0);
			  }
			  /** end of NEWPRED (Oki) 16-AUG-1999 **/

			  NextResyncMarker(vo_id,vol_id);
			  num_bits[vo_id][vol_id].syntax += 
			    BitstreamPut(aux_bitstream,vo_id,vol_id);
			  BitstreamFree(aux_bitstream);
			  
			  comb_bitstream = BitstreamInit();
			  
			  num_bits_packet = 0;
			  slice_counter++;
			}
		    }
		}
	      
	      num_bits[vo_id][vol_id].mot_shape_text 
		+= BitstreamPut(comb_bitstream,vo_id,vol_id);
	      BitstreamFree(comb_bitstream);
	    }
	  FreeShapePacket();
	  
/* >>> added for DRC by Fujitsu (top)    <<< */
        if (GetVopReducedResolution(curr)==1) {
          UpSamplingTexture(reduced_res_rec_curr, rec_curr); 
          CopyQPStore(reduced_res_rec_curr, rec_curr); 

          PutVopAverageQp(GetVopAverageQp(reduced_res_rec_curr),curr);

          /*** set all MB's cod flag to coded(=1) ***/
          for(i=0;i<(num_pixels/32*num_lines/32);i++)
            cod_flag[i] = 1;

          BlockBoundaryFilter(rec_curr, cod_flag, vp_num, (!GetVopNewpredEnable(curr))||(GetVopNewpredSegmentType(curr))); /* DRC 1999.12.14 */

          FreeVop(reduced_res_rec_curr);
          FreeVop(reduced_res_curr);
          free((Char*)cod_flag); /* DRC 1999.12.14 */
        }
        free((Char*)vp_num); /* DRC 1999.12.14 */
/* >>> added for DRC by Fujitsu (bottom) <<< */

	  printf("Shape-bits = %d\n",total_shape_bits);
	  
	  if (GetVolConfigSpriteUsage(vol_config) == STATIC_SPRITE)
	    {
	      num_bits[vo_id][vol_id].sprite_piece += 
		BitstreamPut(first_shape_code_bitstream,vo_id,vol_id);
	      num_bits[vo_id][vol_id].sprite_piece += 
		BitstreamPut(shape_bitstream,vo_id,vol_id);
	      num_bits[vo_id][vol_id].sprite_piece += 
		BitstreamPut(texture_bitstream,vo_id,vol_id);
	    }
	  else
	    {
	      /* Write shape bitstream to disk */
	      num_bits[vo_id][vol_id].shape +=
		BitstreamPut(first_shape_code_bitstream,vo_id,vol_id); 
	      num_bits[vo_id][vol_id].shape +=
		BitstreamPut(shape_bitstream,vo_id,vol_id); 

	      /* Write texture bitstream to disk */
	      num_bits[vo_id][vol_id].texture +=
		BitstreamPut(texture_bitstream,vo_id,vol_id); 
	    }
	} /* End error resilient mode */
    }/*end of I-VOP*/
  else
    if ( (GetVopPredictionType(curr) == SPRITE_VOP)&&
	 (GetVolConfigSpriteUsage(vol_config) == STATIC_SPRITE))	
    /* STATIC SPRITE-VOP */
      {
	/* Write Vop Header bitstream to disk */
	num_bits[vo_id][vol_id].syntax += 
	  BitstreamPutVopHeader(curr,vo_id,time,TRB,vol_config, 
				num_bits,vo_config_list, rc_type, 
				modulo_tps);

	PutVopBrightnessChangeFactor(GetVopBrightnessChangeFactor(curr), rec_curr);
	Compute_SpriteVop (rec_curr);
        SubsampleAlphaMap(GetVopA(curr),GetVopAuv(curr),1,
			   GetVopInterlaced(curr) /* HYUNDAI 980507 */);
      }
    else
    /* P-VOP  or  B_VOP or UPDATE_PIECES */  
      {
	if (GetVopErrorResDisable(curr) == NON_ERROR_RESILIENT)     /* non error resilient mode */
	  {
	    /* Must fill rec_curr alpha field */
	    CopyImage(GetVopA(curr),GetVopA(rec_curr));
	    
	    if (GetVopShape(curr) != BINARY_SHAPE_ONLY)  /* BSO_NOEL */
	      {
		if (unrestricted_motion)
		  edge = UNRESTRICTED_MV_RANGE;
		else
		  edge = 0;

		f_code_for = GetVopFCodeFor(curr);
		f_code_back = GetVopFCodeBack(curr);
		
		/* Put some text for user */
		if (GetVolConfigSpriteUsage(vol_config) == STATIC_SPRITE)
		  fprintf(stdout,"\tP_VOP encoding of update-piece (low latency static sprite syntax)\n");
	
		fprintf(stdout,"\t\tPerforming motion estimation\n");
		if(obmc_disable==0)
		  fprintf(stdout,"\t\t\t- OBMC mode ON\n");
		else
		  fprintf(stdout,"\t\t\t- OBMC mode OFF\n");
		if(enable_8x8_mv==1)
		  fprintf(stdout,"\t\t\t- 4 MV per MB mode ON\n");
		else
		  fprintf(stdout,"\t\t\t- 4 MV per MB mode OFF\n");
		if(unrestricted_motion)
		  fprintf(stdout,"\t\t\t- unrestricted mode ON\n");
		else
		  fprintf(stdout,"\t\t\t- unrestricted mode OFF\n");
		
		/* MW QPEL 07-JUL-1998 >> */
		if(quarter_pel)
		  fprintf(stdout,"\t\t\t- quarter pel mode ON\n");
                else
		  fprintf(stdout,"\t\t\t- quarter pel mode OFF\n");
		/* << MW QPEL 07-JUL-1998 */
	    
		/* Carry out motion estimation */
		if (GetVopPredictionType(curr)!=B_VOP) 	
/* >>> added for DRC by Fujitsu (top)    <<< */
		{	
			if (GetVopReducedResolution(curr)!=1) {
/* >>> added for DRC by Fujitsu (bottom) <<< */
		  MotionEstimation(curr,rec_curr,rec_prev,prev,
				   /*obmc_disable*//*1*/ enable_8x8_mv, /*SpSc*/
				   quarter_pel, /* MW QPEL 07-JUL-1998 */
				   edge ,f_code_for,
				   &mot_x,&mot_y,&MB_decisions,&alpha_decisions);

/* >>> added for DRC by Fujitsu (top)    <<< */
			} else {  
		           MotionEstimation(curr,rec_curr,rec_prev,prev,
				   /*obmc_disable*//*1*/ enable_8x8_mv, /*SpSc*/
				   quarter_pel, /* MW QPEL 07-JUL-1998 */
				   edge*2 ,f_code_for,
				   &mot_x,&mot_y,&MB_decisions,&alpha_decisions);
			}
		}
/* >>> added for DRC by Fujitsu (bottom) <<< */
		/*** 10/27 TPS */
		else  /* Motion Estimation for B-VOPs */
		  {
		    /* B_VOP for TPS */ 
		    if(!vop_spat_scal                        &&    /* not spatial scalability               */
		       GetVolConfigScalability( vol_config ) &&    /* ENHANCE VOP mode is B_VOP             */
		       (vop_temp_scal == 1 || vop_temp_scal == 2 ) /* temporal scalability B_VOP_TYPE1 or 2 */
		       )
		      {
			if (mot_x_P[vo_id][vol_id]!=NULL) FreeImage(mot_x_P[vo_id][vol_id]);
			if (mot_y_P[vo_id][vol_id]!=NULL) FreeImage(mot_y_P[vo_id][vol_id]);
			mot_x_P[vo_id][vol_id]=AllocImage(MB_width*2, MB_height*2, FLOAT_TYPE);
			mot_y_P[vo_id][vol_id]=AllocImage(MB_width*2, MB_height*2, FLOAT_TYPE);
			SetConstantImage (mot_x_P[vo_id][vol_id], +0.0);
			SetConstantImage (mot_y_P[vo_id][vol_id], +0.0);
		      }
	       
		    /* direct mode is used in B_VOP of temporal scalability Case1 */
		    if(GetVolConfigScalability( vol_config ) && vop_temp_scal == 1)
		      {
			B_MotionEstimation(curr,rec_curr,rec_prev,next_rec_vop,quarter_pel, /* MW QPEL 07-JUL-1998 */ 
					   f_code_for,f_code_back,TRB,TRD,
					   mot_x_P[vo_id][ref_vol_id],mot_y_P[vo_id][ref_vol_id],
					   MB_decisions_P[vo_id][ref_vol_id],
					   &mot_x,&mot_y,&MB_decisions,&alpha_decisions);
		      }
		    
		    /* direct mode is not used in B_VOP of temporal scalability Case2 */
		    else if(GetVolConfigScalability( vol_config ) && vop_temp_scal == 2)
		      {
			B_MotionEstimation(curr,rec_curr,rec_prev,next_rec_vop,quarter_pel, /* MW QPEL 07-JUL-1998 */
					   f_code_for,f_code_back,TRB,TRD,
					   mot_x_P[vo_id][vol_id],mot_y_P[vo_id][vol_id],
					   MB_decisions_P[vo_id][vol_id],
					   &mot_x,&mot_y,&MB_decisions,&alpha_decisions);
		      }
		    else
		      {
			B_MotionEstimation(curr,rec_curr,rec_prev,next_rec_vop,quarter_pel, /* MW QPEL 07-JUL-1998 */
					   f_code_for,f_code_back,TRB,TRD,
					   mot_x_P[vo_id][vol_id],mot_y_P[vo_id][vol_id],
					   MB_decisions_P[vo_id][vol_id],
					   &mot_x,&mot_y,&MB_decisions,&alpha_decisions);
		      }
		  }
		/* 10/27 TPS ***/
	      }  /* BSO_NOEL */



	    if (RCQ2_MVO_CHECK() >= RCQ2_MVO_ENABLED) /* hjlee */
	      {
		RCQ2_MVO_ComputeMMV(mot_x, mot_y, rec_curr->height/MB_SIZE, 
				    rec_curr->height/MB_SIZE, vo_id);
		
		if (RCQ2_MVO_CHECK() >= RCQ2_MVO_HVS)
		if (FirstInterFrame==1) {
		  SetFirstInterQP(curr, vol_config, vo_id, vol_id);
		}
	      }
	    
	    if ((GetVopShape(curr) == BINARY) || (GetVopShape(curr) == GREY_SCALE)
		|| (GetVopShape(curr) == BINARY_SHAPE_ONLY)) /* BSO_NOEL */
	      {
		/* Put some text for user */
		fprintf(stdout,"\t\tPerforming INTER Shape Coding\n");
		
		/* Code shape */

		/* Minhua Zhou - for B-VOPs shape prediction is from the 
		   closest decoded P/I-VOP */

/*** 4/19 changed by SHARP */
	/* << case2 of temporal scalability >> */
	/* next_rec_vop is --> Base Vop        */
	/* rec_prev     is --> enhance Vop     */
        if (temporal_scalability == 2 && GetVopScalability(rec_curr)){
          Int now, next, prev;
	  
	  now  = (vol_config->frame -   vol_config->frame_skip)/(Int)vol_config->frame_skip;
	  next = next_rec_vop->frame                           /(Int)vol_config->frame_skip;
	  if(now - 1 == next) prev = next - 1;
	  else                prev = now  - 1;
	  
	  TRD = abs(now - prev) +abs(now - next);
	  TRB = abs(now - prev);
	}
/*** 4/19 changed by SHARP */
		
/* begin: added for OBSS by Samsung AIT (1999-09-29) */
                if (!(GetVopScalability(curr) && !GetVopHierarchyType(curr) &&
                        (!GetVopEnhanceType(curr) || !GetVopUseRefShape(curr))) &&
                        !(GetVopScalability(curr) && GetVopShape(curr)==BINARY_SHAPE_ONLY))
                {
/* end: added for OBSS by Samsung AIT (1999-09-29) */
		if (SelectRefVop(rec_prev,rec_curr,next_rec_vop,TRB,TRD))
                  ref_vop = next_rec_vop;
                else
                  ref_vop = rec_prev;
/* begin: added for OBSS by Samsung AIT (1999-09-29) */
                } else if (GetVopShape(curr)==BINARY_SHAPE_ONLY || !GetVopUseRefShape(curr))       
                {
                        ref_vop = rec_prev;
                        if(GetVopPredictionType(curr)==P_VOP && GetVopRefSelCode(curr)==3)
                           up_vop = rec_prev;
                        else if(GetVopPredictionType(curr)==B_VOP && GetVopRefSelCode(curr)==0)
                           up_vop = next_rec_vop;
                        else {
                           printf("Error: There is no BASE LAYER !\n");
                           exit(0);
                        }
                }
/* end: added for OBSS by Samsung AIT (1999-09-29) */


		
		
		shape_bits = VopShapeCode(curr,
					  rec_curr,
					  ref_vop, 
						up_vop, /* added for OBSS by Samsung AIT (1999-09-29) */
					  vo_id,
					  alpha_th,
					  mot_x,
					  mot_y,
					  MB_decisions,  /* to be changed for B-VOPs*/
					  alpha_decisions,
					  First_stream,
					  Shape_stream);
		
		SubsampleAlphaMap(GetVopA(rec_curr),GetVopAuv(rec_curr),1,
				  GetVopInterlaced(rec_curr) /* HYUNDAI 980507 */);
		SubsampleAlphaMap(GetVopA(curr),GetVopAuv(curr),1,
				  GetVopInterlaced(curr) /* HYUNDAI 980507 */);
		/*apa alpha_decisions-> alpha with modes in blocks units */
		/*apa alpha_sub_pad  -> alpha with (trans-opaque-border) 
		  values in blocks units */ 
		
		if (1==0)
		  {
		    /* will be done in the next loop ...C.Dufour 18/09/97 */
		    if (GetVopShape(curr) != BINARY_SHAPE_ONLY)  /* BSO_NOEL */
		      {
			subsamp_alpha_with_modes((SInt*)GetImageData(GetVopA(rec_curr)),
						 (SInt*)GetImageData(MB_decisions),
						 GetVopWidth(rec_curr),
						 GetVopHeight(rec_curr),
						 (SInt*)GetImageData(alpha_decisions));
			alpha_sub_pad=AllocImage(GetImageSizeX(alpha_decisions),
						 GetImageSizeY(alpha_decisions),SHORT_TYPE);
			subsamp_alpha((SInt*)GetImageData(GetVopA(rec_curr)),
				      GetVopWidth(rec_curr),
				      GetVopHeight(rec_curr),
				      1,
				      (SInt*)GetImageData(alpha_sub_pad));
		      }
		  } /* 1==0 */
	      } 
	    else  
	      {  
		SetConstantImage(GetVopAuv(curr),255);
		SetConstantImage(GetVopAuv(rec_curr),255);
	      }

	    if (GetVopShape(curr) != BINARY_SHAPE_ONLY)  /* BSO_NOEL */
	      {
/* >>> added for DRC by Fujitsu (top)    <<< */
				if (GetVopReducedResolution(curr)==1) {
			subsamp_alpha_with_modes_RR((SInt*)GetImageData(GetVopA(rec_curr)),
				     (SInt*)GetImageData(MB_decisions),
				     GetVopWidth(rec_curr),
				     GetVopHeight(rec_curr),
				     (SInt*)GetImageData(alpha_decisions));
			alpha_sub_pad=AllocImage(GetImageSizeX(alpha_decisions),
				     GetImageSizeY(alpha_decisions),SHORT_TYPE);
			subsamp_alpha_RR((SInt*)GetImageData(GetVopA(rec_curr)),
			  GetVopWidth(rec_curr),
			  GetVopHeight(rec_curr),
               1,
               (SInt*)GetImageData(alpha_sub_pad));
				} else {
/* >>> added for DRC by Fujitsu (bottom) <<< */
		subsamp_alpha_with_modes((SInt*)GetImageData(GetVopA(rec_curr)),
					 (SInt*)GetImageData(MB_decisions),
					 GetVopWidth(rec_curr),
					 GetVopHeight(rec_curr),
					 (SInt*)GetImageData(alpha_decisions));
		alpha_sub_pad=AllocImage(GetImageSizeX(alpha_decisions),
					 GetImageSizeY(alpha_decisions),SHORT_TYPE);
		subsamp_alpha((SInt*)GetImageData(GetVopA(rec_curr)),
			      GetVopWidth(rec_curr),
			      GetVopHeight(rec_curr),
			      1,
			      (SInt*)GetImageData(alpha_sub_pad));
/* >>> added for DRC by Fujitsu (top)    <<< */
				} 
/* >>> added for DRC by Fujitsu (bottom) <<< */
	      }

	    /* Put some text for user */
	    fprintf(stdout,"\t\tCoding INTER texture \n\n");
	    /* Code motion and texture combined as in H.263 */

	     /*** 10/27 TPS */     
	     if(vop_temp_scal == 1)
	      VopCodeShapeMotTextInter(curr,
				       First_stream,
				       Shape_stream,
				       rec_prev, next_rec_vop,
				       mot_x,mot_y,
				       mot_x_P[vo_id][ref_vol_id],
				       mot_y_P[vo_id][ref_vol_id],
				       MB_decisions_P[vo_id][ref_vol_id],
				       TRB,TRD,
				       alpha_sub_pad,alpha_decisions, MB_decisions, 
				       f_code_for,f_code_back, quarter_pel, /* MW QPEL 07-JUL-1998 */
				       /* RC2 */ vo_id, vol_id, rc_type,
				       vo_config_list, /* UPM Global RC */
				       rec_curr,
				       /* RC2 */ &vop_quantizer,
				       mottext_bitstream,
				       &num_bits[vo_id][vol_id].text_bits,
				       vol_config,edge /* MW QPEL 07-JUL-1998 */);
	    else
	      /* 10/27 TPS ***/
	      VopCodeShapeMotTextInter(curr,
				       First_stream,
				       Shape_stream,
				       rec_prev, next_rec_vop,
				       mot_x,mot_y,mot_x_P[vo_id][vol_id],mot_y_P[vo_id][vol_id],
				       MB_decisions_P[vo_id][vol_id],
				       TRB,TRD,
				       alpha_sub_pad,alpha_decisions, MB_decisions, 
				       f_code_for,f_code_back, quarter_pel, /* MW QPEL 07-JUL-1998 */
				       /* RC2 */ vo_id, vol_id, rc_type,
				       vo_config_list, /* UPM Global RC */
				       rec_curr,
				       /* RC2 */ &vop_quantizer,
				       mottext_bitstream,
				       &num_bits[vo_id][vol_id].text_bits,
				       vol_config,edge /* MW QPEL 07-JUL-1998 */);

	    /* Put some text for user */
	    /* Replaced 16.9. by M.E. */
	    if (GetVolConfigSpriteUsage(vol_config) != STATIC_SPRITE)
	      num_bits[vo_id][vol_id].syntax +=
		BitstreamPutVopHeader(curr,vo_id,time,TRB,vol_config,
				      num_bits,vo_config_list, rc_type,
                                      modulo_tps);

	    /* for TPS and ssp*/ 
/* begin: modified for OBSS by Samsung AIT (1999-09-29) */
#if 0
	    if (GetVopScalability(curr))/* && !vop_spat_scal)*/ /*UPS*/
#endif
            if ( GetVopScalability( curr ) && GetVopShape(curr) != BINARY_SHAPE_ONLY)
/* end: modified for OBSS by Samsung AIT (1999-09-29) */
	      WriteBGCAlphaBitstream(curr, vo_id, vol_id, num_bits
				     , back_base_exist );
	    
	    /* Write combined bitstream to disk */
	    if (GetVolConfigSpriteUsage(vol_config) == STATIC_SPRITE)
	      num_bits[vo_id][vol_id].sprite_piece += 
		BitstreamPut(mottext_bitstream,vo_id,vol_id);
	    else
	      num_bits[vo_id][vol_id].mot_shape_text +=
		BitstreamPut(mottext_bitstream,vo_id,vol_id); 
	   
            FreeImage(alpha_decisions);
	    if(alpha_sub_pad!=NULL) FreeImage(alpha_sub_pad);

	  }    /* End of non error resilient mode */
	else
	  {    /* error resilient mode */

            /* Must fill rec_curr alpha field */
	    CopyImage(GetVopA(curr),GetVopA(rec_curr));
	    
	    if (unrestricted_motion)
	      edge = UNRESTRICTED_MV_RANGE;
	    else
	      edge = 0;

	    f_code_for = GetVopFCodeFor(curr);
	    f_code_back = GetVopFCodeBack(curr);
	    f_code_max = (f_code_for > f_code_back) ? f_code_for:f_code_back;

	    if (GetVopShape(curr) == BINARY_SHAPE_ONLY)
	      resync_marker_length = 17;
	    else if (GetVopPredictionType(curr) == B_VOP)
	      resync_marker_length = 16 + f_code_max + (quarter_pel ? 1 : 0); /* UB 990215 added quarter pel support (the 'real' f_code is one larger than the f_code in the VOP structure) */  
	    else
	      resync_marker_length = 16 + f_code_for + (quarter_pel ? 1 : 0);
	    
	    /* Put some text for user */
	    fprintf(stdout,"\t\tPerforming motion estimation (error resilient mode)\n");
	    if(obmc_disable==0)
	      fprintf(stdout,"\t\t\t- advanced mode ON\n");
	    else
	      fprintf(stdout,"\t\t\t- advanced mode OFF\n");
	    if(enable_8x8_mv)
	      fprintf(stdout,"\t\t\t- 4 MV per MB mode ON\n");
	    else
	      fprintf(stdout,"\t\t\t- 4 MV per MB mode OFF\n");
	    if(unrestricted_motion)
	      fprintf(stdout,"\t\t\t- unrestricted mode ON\n");
	    else
	      fprintf(stdout,"\t\t\t- unrestricted mode OFF\n");
	    /* MW QPEL 07-JUL-1998 >> */
	    if(quarter_pel)
	      fprintf(stdout,"\t\t\t- quarter pel mode ON\n");
	    else
	      fprintf(stdout,"\t\t\t- quarter pel mode OFF\n");
	    /* << MW QPEL 07-JUL-1998 */
		
	    /* Carry out motion estimation */
	    if (GetVopPredictionType(curr)!=B_VOP) 	
/* >>> added for DRC by Fujitsu (top)    <<< */
		{	
			if (GetVopReducedResolution(curr)!=1) {
/* >>> added for DRC by Fujitsu (bottom) <<< */
	      MotionEstimation(curr,rec_curr,rec_prev,prev,
			       /*obmc_disable*//*1*/ enable_8x8_mv, /*SpSc*/
			       quarter_pel, /* MW QPEL 07-JUL-1998 */
			       edge ,f_code_for,
			       &mot_x,&mot_y,&MB_decisions,&alpha_decisions);
/* >>> added for DRC by Fujitsu (top)    <<< */
			} else {  
	                   MotionEstimation(curr,rec_curr,rec_prev,prev,
			       /*obmc_disable*//*1*/ enable_8x8_mv, /*SpSc*/
			       quarter_pel, /* MW QPEL 07-JUL-1998 */
			       edge*2 ,f_code_for,
			       &mot_x,&mot_y,&MB_decisions,&alpha_decisions);
			}
		}
/* >>> added for DRC by Fujitsu (bottom) <<< */
	    else  /* Motion Estimation for B-VOPs */ 
	      B_MotionEstimation(curr,rec_curr,rec_prev,next_rec_vop,quarter_pel /* MW QPEL 07-JUL-1998 */, 
				 f_code_for,f_code_back,TRB,TRD,
				 mot_x_P[vo_id][vol_id],mot_y_P[vo_id][vol_id],
				 MB_decisions_P[vo_id][vol_id],
				 &mot_x,&mot_y,&MB_decisions,&alpha_decisions);

	    /*apa alpha_decisions-> alpha with modes in blocks units                        */
	    /*apa alpha_sub_pad  -> alpha with (trans-opaque-border) values in blocks units */
/* >>> added for DRC by Fujitsu (top)    <<< */
				if (GetVopReducedResolution(curr)==1) {
			subsamp_alpha_with_modes_RR((SInt*)GetImageData(GetVopA(rec_curr)),
				     (SInt*)GetImageData(MB_decisions),
				     GetVopWidth(rec_curr),
				     GetVopHeight(rec_curr),
				     (SInt*)GetImageData(alpha_decisions));
			alpha_sub_pad=AllocImage(GetImageSizeX(alpha_decisions),
				     GetImageSizeY(alpha_decisions),SHORT_TYPE);
			subsamp_alpha_RR((SInt*)GetImageData(GetVopA(rec_curr)),
			  GetVopWidth(rec_curr),
			  GetVopHeight(rec_curr),
               1,
               (SInt*)GetImageData(alpha_sub_pad));
				} else {
/* >>> added for DRC by Fujitsu (bottom) <<< */
	    subsamp_alpha_with_modes((SInt*)GetImageData(GetVopA(rec_curr)),
				     (SInt*)GetImageData(MB_decisions),
				     GetVopWidth(rec_curr),
				     GetVopHeight(rec_curr),
				     (SInt*)GetImageData(alpha_decisions));

	    alpha_sub_pad=AllocImage(GetImageSizeX(alpha_decisions),
				     GetImageSizeY(alpha_decisions),SHORT_TYPE);

	    subsamp_alpha((SInt*)GetImageData(GetVopA(rec_curr)),
			  GetVopWidth(rec_curr),
			  GetVopHeight(rec_curr),
			  1,
			  (SInt*)GetImageData(alpha_sub_pad));
/* >>> added for DRC by Fujitsu (top)    <<< */
				} 
/* >>> added for DRC by Fujitsu (bottom) <<< */
	    
	    if ((GetVopShape(curr) == BINARY) || (GetVopShape(curr) == GREY_SCALE)) 
	      {
		SubsampleAlphaMap(GetVopA(rec_curr),GetVopAuv(rec_curr),1,
				  GetVopInterlaced(rec_curr) /* HYUNDAI 980507 */);
		SubsampleAlphaMap(GetVopA(curr),GetVopAuv(curr),1,
				  GetVopInterlaced(curr) /* HYUNDAI 980507 */);

	      }
	    else
	      {
		SetConstantImage(GetVopAuv(curr),255);
		SetConstantImage(GetVopAuv(rec_curr),255);
	      }
	    
	    /* Code motion and texture combined as in H.263 */
	    error_vop = AllocVop(num_pixels, num_lines, GetVopAuxCompCount(curr));
	    
	    /* Need some fields of current vop when coding error vop
	       (specifically the quantizer) */
	    CopyVopNonImageField(curr,error_vop);
	    comp = CloneVop(rec_curr);
	    rec_error = AllocVop(num_pixels, num_lines, 0);
	    
/* >>> added for DRC by Fujitsu (top)    <<< */
    if(GetVopReducedResolution(curr)) {
	reduced_res_error_vop = AllocVop(num_pixels/2, num_lines/2, 0);
	CopyVopNonImageField(error_vop,reduced_res_error_vop); 
	mot_x_rr = AllocImage(num_pixels/16, num_lines/16, FLOAT_TYPE);
	mot_y_rr = AllocImage(num_pixels/16, num_lines/16, FLOAT_TYPE);
	reduced_res_rec_error = AllocVop(num_pixels/2, num_lines/2, 0);
        cod_flag = (Int*)malloc(num_pixels/32*num_lines/32*sizeof(Int)); 
        vp_num = (Int*)malloc(num_pixels/32*num_lines/32*sizeof(Int)); /* DRC 1999.12.14 */
    } else {
        cod_flag = (Int*)malloc(num_pixels/16*num_lines/16*sizeof(Int));
        vp_num = (Int*)malloc(num_pixels/16*num_lines/16*sizeof(Int)); /* DRC 1999.12.14 */
    }
/* >>> added for DRC by Fujitsu (bottom) <<< */

	    /** added for NEWPRED (Oki) 27-AUG-1999 **/
	    /* set NEWPRED enable flag and informations for NEWPRED segments */
	    if(GetVopNewpredEnable(curr)){
	      PutVopNewpredEnable(1,comp);
	      PutVopNewpredSegmentType(GetVopNewpredSegmentType(curr),comp); /** Oki 26-AUG-1999 **/
	      PutVopNewpredNumVps(GetVopNewpredNumVps(curr), comp);
	      for(np_seg_id = 0; np_seg_id <= GetVopNewpredNumVps(curr); np_seg_id++){
		PutVopNewpredMbaVp(GetVopNewpredMbaVp(curr, np_seg_id), comp, np_seg_id);
	      }
	    }
	    else{
	      PutVopNewpredEnable(0,comp);
	      PutVopNewpredSegmentType(0,comp);
	    }
	    /** end of NEWPRED (Oki) 27-AUG-1999 **/

	    if (GetVopPredictionType(curr)!=B_VOP && !GetVopShape(curr))
	      VopMotionCompensate(rec_prev, mot_x, mot_y, quarter_pel,MB_decisions,  /* MW QPEL 07-JUL-1998 */
				  alpha_decisions, comp,GetVopOBMCDisable(curr)); 
	    else if (GetVopPredictionType(curr) == B_VOP && !GetVopShape(curr))
	      B_VopMotionCompensation(curr,rec_prev,next_rec_vop,
				      mot_x, mot_y,
				      mot_x_P[vo_id][vol_id],
				      mot_y_P[vo_id][vol_id],
				      MB_decisions_P[vo_id][vol_id],
				      MB_decisions,
				      alpha_decisions, TRB,TRD, comp,quarter_pel,edge); /* MW QPEL 07-JUL-1998 */

	    if (!GetVopShape(curr))
	      {
		SubImage(curr->y_chan, comp->y_chan, error_vop->y_chan);
		SubImage(curr->u_chan, comp->u_chan, error_vop->u_chan);
		SubImage(curr->v_chan, comp->v_chan, error_vop->v_chan);
	      }
	    else
	      {
		AllocShapePacket(curr);
		
		if (GetVopShape(curr) != BINARY_SHAPE_ONLY 
		    && GetVopPredictionType(curr) != B_VOP)
		  {
		    /* MW QPEL 09-JUL-1998 >> */
		    if(!quarter_pel)
		      {
			/* << MW QPEL 09-JUL-1998 */
			pi  = AllocImage(GetVopWidth(rec_prev)*2, 
					 GetVopHeight(rec_prev)*2, 	
					 SHORT_TYPE);
			InterpolateImage(GetVopY(rec_prev), 
					 pi, 
					 GetVopRoundingType(rec_curr));
			/* MW QPEL 09-JUL-1998 >> */
 /* U. Benzler 981209 : added interlaced greyscale support >>*/
			if(GetVopShape(curr) == GREY_SCALE)
			  {
                            for(aux=0;aux<GetVopAuxCompCount(curr);aux++) {   /* MAC (SB) 16-Nov-99 */
                              pi_grey[aux]  = AllocImage(GetVopWidth(rec_prev)*2, 
                                                         GetVopHeight(rec_prev)*2, 	
                                                         SHORT_TYPE);
			    
                              InterpolateImage(GetVopG(aux,rec_prev), 
                                               pi_grey[aux], 
                                               GetVopRoundingType(rec_curr));
                            }
			  }
 /* U. Benzler 981209 : added interlaced greyscale support <<*/
		      }
		    /* << MW QPEL 09-JUL-1998 */
		    
		    Equalise1MVMBs(MB_decisions, mot_x, mot_y);
		  }
		
		/* Allocate shape ME/MC */
		modeA = AllocImage(GetVopWidth(curr)/MB_SIZE,
				   GetVopHeight(curr)/MB_SIZE,SHORT_TYPE);
		motA_x = AllocImage(GetVopWidth(curr)/MB_SIZE,
				    GetVopHeight(curr)/MB_SIZE,SHORT_TYPE);
		motA_y = AllocImage(GetVopWidth(curr)/MB_SIZE,
				    GetVopHeight(curr)/MB_SIZE,SHORT_TYPE);
	      }

	    CopyImage(rec_curr->a_chan, error_vop->a_chan);
	    CopyImage(rec_curr->a_chan, rec_error->a_chan);
	    CopyImage(rec_curr->a_uv_chan, error_vop->a_uv_chan);
	    CopyImage(rec_curr->a_uv_chan, rec_error->a_uv_chan);

/* >>> added for DRC by Fujitsu (top)    <<< */
            if(GetVopReducedResolution(curr)) {
	      SetConstantImage(GetVopA(reduced_res_error_vop),255);
	      SetConstantImage(GetVopA(reduced_res_rec_error),255);
	      SetConstantImage(GetVopAuv(reduced_res_error_vop),255);
	      SetConstantImage(GetVopAuv(reduced_res_rec_error),255);

	      DownSamplingTexture(error_vop, reduced_res_error_vop);
	      MotionVectorScalingDown(mot_x,mot_y,mot_x_rr,mot_y_rr); 
            }
/* >>> added for DRC by Fujitsu (bottom) <<< */

	    if ((GetVopDataPartEnable(curr)) && (GetVopPredictionType(curr)!=B_VOP))
	      {
		/* Put some text for user */
		fprintf(stdout,"\t\tCoding combined shape, motion and INTER texture\n\n");					    
		/* RC2: adding combined mode VM5.0 Rate Control */
		if (rc_type == VM5_RATE_CONTROL)
		  {
		    if (RCQ2_MVO_CHECK() >= RCQ2_MVO_ENABLED)
		      ;
		    else
		      mad = DSRC_compute_MAD(error_vop, &num_pels_vop);

		    if (RCQ2_MVO_CHECK() >= RCQ2_MVO_ENABLED)
		      ;
		    else
		      vop_quantizer = RC_QuantAdjust(vo_id, 
						     vol_id, 
						     vo_config_list, 
						     vol_config, 
						     (Double)mad, 
						     curr, 
						     error_vop, 
						     num_pels_vop,
						     GetVopPredictionType(curr));

		    /* RC2 */
		    fprintf(stdout,"\t\tInter Quantizer : %d\n", (int)vop_quantizer);
		  }
		    
		num_bits[vo_id][vol_id].syntax +=
		  BitstreamPutVopHeader(curr,vo_id,time,TRB,vol_config,
					num_bits,vo_config_list, rc_type,
					modulo_tps);
		    
		if (GetVopPredictionType(curr)!=B_VOP) 
		  {
		    slice_counter = 0;
		    num_bits_packet = 0;
		    first_marker = 1;
		    after_marker = 0;
		    start_of_packet = 1;
		    k = 0;
		    
		    motion_comb_bitstream = BitstreamInit();
		    text_header_comb_bitstream = BitstreamInit();
		    text_data_comb_bitstream = BitstreamInit();
		    
		    /* 	encode the 1st MB shape of the frame */  
		    /* 	In the following MB encoding loop, the shape coding is one MB
			ahead of the texture coding */
		    
		    if (GetVopShape(curr))
		      {
			shape_bits = ShapeCodeMB(curr,
						 rec_curr,
						 rec_prev,
                                                        NULL, /* added for OBSS by Samsung AIT (1999-09-29)*/
						 vo_id,
						 0,
						 0,
						 alpha_th,
						 modeA,
						 mot_x,
						 mot_y,
						 motA_x,
						 motA_y,
						 MB_decisions,
						 alpha_decisions,
						 &first_bits,
						 first_stream,
						 shape_stream,
						 start_of_packet
						 );
			BitstreamAppendTtoM(First_stream[k], first_stream, first_bits);
			BitstreamAppendTtoM(Shape_stream[k], shape_stream, shape_bits);
		      }
			
/* >>> added for DRC by Fujitsu (top)    <<< */
/*
		    for (j = 0; j < num_lines/MB_SIZE; j++) 
		      {
			for (i = 0; i < num_pixels/MB_SIZE; i++) 
*/
  	            for (j = 0; j < num_lines/mb_size_variable; j++)
		      {
		        for (i = 0; i < num_pixels/mb_size_variable; i++)
/* >>> added for DRC by Fujitsu (bottom) <<< */
			  {
			    slice_nb[i][j] = slice_counter;
			    vp_num[i+j*num_pixels/mb_size_variable] = slice_counter+1; /* DRC 1999.12.14 */
			    
			    if (GetVopShape(curr))
			      {
				if ((num_bits_packet+GetImageSizeX(First_stream[k])
				     +GetImageSizeX(Shape_stream[k])) > 		
				    RESYNC_MARKER_SPACING)
				  start_of_packet = 1;
				else 
				  start_of_packet = 0;

				/* encode the shape of the next MB */   
				
				if (i==(num_pixels/MB_SIZE-1)) 
							{
							  i_next = 0;
							  j_next = j+1;
							}
				else 
				  {
				    i_next = i+1;
				    j_next = j;
				  }
				
				if (j_next < num_lines/MB_SIZE)  /* check that the next MB exists */
				  {						
				    shape_bits = ShapeCodeMB(curr,
							     rec_curr,
							     rec_prev,
                                                                NULL, /* added for OBSS by Samsung AIT (1999-09-29) */
							     vo_id,
							     j_next,
							     i_next,
							     alpha_th,
							     modeA,
							     mot_x,
							     mot_y,
							     motA_x,
							     motA_y,
							     MB_decisions,
							     alpha_decisions,
							     &first_bits,
							     first_stream,
							     shape_stream,
							     start_of_packet
							     );
				    BitstreamAppendTtoM(First_stream[k+1], 
							first_stream, 
							first_bits);
				    BitstreamAppendTtoM(Shape_stream[k+1], 
							shape_stream, 
							shape_bits);
				    k++;
				  }
				
				if (GetVopShape(rec_curr)!=BINARY_SHAPE_ONLY)
				  {
                                    /* Mooshofer, 2000-03-15 */
				    /* CopyVopABlock(rec_curr, error_vop, i*MB_SIZE, j*MB_SIZE); */
				    CopyVopABlock(rec_curr, rec_error, i*MB_SIZE, j*MB_SIZE); 
				    /* CopyVopAuvBlock(rec_curr, error_vop , i*B_SIZE, j*B_SIZE); */
				    CopyVopAuvBlock(rec_curr, rec_error , i*B_SIZE, j*B_SIZE);
				    
				    MotionCompensateMB(rec_prev,pi,pi_grey,mot_x,mot_y,i,j,/* U. Benzler 981209 : added interlaced greyscale support */
						       GetVopOBMCDisable(curr),
						       alpha_decisions, MB_decisions, comp);
				    
				    
				    FillErrorMB(curr,rec_curr,comp,error_vop,i,j);
				    
				    PadMB(rec_curr,MB_decisions,error_vop,i,j);
				  }
			      }
			    
/* >>> added for DRC by Fujitsu (top)    <<< */
                            if (GetVopReducedResolution(curr)==1) {
			      MBShapeMotTextErrRes(reduced_res_error_vop, alpha_decisions, MB_decisions, 
						 mot_x_rr, mot_y_rr, quarter_pel, f_code_for, First_stream,  /* MW QPEL 07-JUL-1998 */
						 Shape_stream, 
						 GetVopIntraACDCPredDisable(curr),
						 GetVopDataPartEnable(curr),reduced_res_rec_error, 
						 motion_comb_bitstream,
						 text_header_comb_bitstream,
						 text_data_comb_bitstream,
						 i, j, &num_bits_MB,
						 after_marker,
						 DC_store, slice_nb,
                                                 &cod_flag_mb,
						 &num_bits[vo_id][vol_id].text_bits);

                              cod_flag[j*MB_width+i]= cod_flag_mb;
                            } else {
/* >>> added for DRC by Fujitsu (bottom) <<< */
			    MBShapeMotTextErrRes(error_vop, alpha_decisions, MB_decisions, 
						 mot_x, mot_y, quarter_pel, f_code_for, First_stream,  /* MW QPEL 07-JUL-1998 */
						 Shape_stream, 
						 GetVopIntraACDCPredDisable(curr),
						 GetVopDataPartEnable(curr),rec_error, 
						 motion_comb_bitstream,
						 text_header_comb_bitstream,
						 text_data_comb_bitstream,
						 i, j, &num_bits_MB,
						 after_marker,
						 DC_store, slice_nb,
/* >>> added for DRC by Fujitsu (top)    <<< */
                                                 &cod_flag_mb,
/* >>> added for DRC by Fujitsu (bottom) <<< */
						 &num_bits[vo_id][vol_id].text_bits);
/* >>> added for DRC by Fujitsu (top)    <<< */
                            } 
/* >>> added for DRC by Fujitsu (bottom) <<< */
			    
			    after_marker = 0;
			    num_bits_packet += num_bits_MB;
/* (Oki) 16-AUG-1999
 *			    if ((num_bits_packet >= RESYNC_MARKER_SPACING) && start_of_packet
 *				&& ((j*MB_width+i) < (MB_height*MB_width-1)))
 */
			    /** modified for NEWPRED (Oki) 16-AUG-1999 **/
			    /*
			     *	P-VOP (Data Partitioning)
			     */
			    /* In non NEWPRED on resync slice mode, resync_marker is inserted
			       everywhere amount of slice bits is beyond the constant one.
			       In NEWPRED mode, resysnc_marker is inserted to the fixed 
			       position that is indicated in the control file. */
			    if((GetVopNewpredEnable(curr) && !GetVopNewpredSegmentType(curr) &&
				((j*MB_width+i != 0) && 
				 (j*MB_width+i+1 == vol_config->mba_segment[slice_counter+1]/mba_scale)) && /* >>> modified for DRC by Fujitsu <<< */
				(j*MB_width+i < MB_height*MB_width-1)) ||
			       (((GetVopNewpredEnable(curr) && GetVopNewpredSegmentType(curr)) ||
				 !GetVopNewpredEnable(curr)) && /** Oki 26-AUG-1999 **/
				(num_bits_packet >= RESYNC_MARKER_SPACING) && 
				start_of_packet &&
				(j*MB_width+i < MB_height*MB_width-1)))
			      /** end of NEWPRED (Oki) 16-AUG-1999 **/
			      {
				if (GetVopShape(curr))
				  start_of_packet = 0;

				num_bits[vo_id][vol_id].mot_shape_text += 
				  BitstreamPut(motion_comb_bitstream,vo_id,vol_id);
				BitstreamFree(motion_comb_bitstream);
				    
				aux_bitstream = BitstreamInit();
				BitstreamPutBits(aux_bitstream,MOTION_MARKER_COMB,MOTION_MARKER_COMB_LENGTH);
				num_bits[vo_id][vol_id].syntax += 
				  BitstreamPut(aux_bitstream,vo_id,vol_id);
				BitstreamFree(aux_bitstream);
				    
				num_bits[vo_id][vol_id].mot_shape_text += 
				  BitstreamPut(text_header_comb_bitstream,vo_id,vol_id);
				BitstreamFree(text_header_comb_bitstream);
				
				num_bits[vo_id][vol_id].mot_shape_text += 
				  BitstreamPut(text_data_comb_bitstream,vo_id,vol_id);
				BitstreamFree(text_data_comb_bitstream);
				
      /* revised HEC for shape due to N2693 */
				aux_bitstream = BitstreamInit();
				BitstreamPutBits(aux_bitstream,RESYNC_MARKER,resync_marker_length);
				if (GetVopShape(curr) != RECTANGULAR) {
				  if (first_marker)
				    {
/*				      first_marker = 0;*/
				      /* Write the HEC-flag and then the HEC itself */
				      BitstreamPutBits(aux_bitstream,1,1);
				      BitstreamPutShapeHEC(vol_config, curr, aux_bitstream);				      
				    }
				  else
				    {  
				      BitstreamPutBits(aux_bitstream,0,1);
				    }
				}

				BitstreamPutBits(aux_bitstream,j*MB_width+i+1,MB_in_VOP_length);
				
				if (GetVopShape(curr) != BINARY_SHAPE_ONLY) 	    	
				  BitstreamPutBits(aux_bitstream,GetVopQuantizer(curr),
						   GetVopQuantPrecision(curr));
				
				if (first_marker)
				  {
				    first_marker = 0;
				    /* Write the HEC-flag and then the HEC itself */
				    if (GetVopShape(curr) == RECTANGULAR)
				      BitstreamPutBits(aux_bitstream,1,1);
				    BitstreamPutHEC(vol_config, curr, time, aux_bitstream);

				  }
				else
				  {  
				    if (GetVopShape(curr) == RECTANGULAR)
				      BitstreamPutBits(aux_bitstream,0,1);
				  }

				/** added for NEWPRED (Oki) 16-AUG-1999 **/
				if(GetVopNewpredEnable(curr)){
				  /* insert additional syntax for NEWPRED */
				  BitstreamPutNEWPRED(vol_config, curr, np_vop_id, 
						      slice_counter + 1, aux_bitstream, 1);
				}
				/** end of NEWPRED (Oki) 16-AUG-1999 **/

				NextResyncMarker(vo_id,vol_id);
				
				num_bits[vo_id][vol_id].syntax += 
				  BitstreamPut(aux_bitstream,vo_id,vol_id);
				BitstreamFree(aux_bitstream);
				    
				motion_comb_bitstream = BitstreamInit();
				text_header_comb_bitstream = BitstreamInit();
				text_data_comb_bitstream = BitstreamInit();
				    
				num_bits_packet = 0;
				after_marker = 1;
				slice_counter++;
			      }
			  }
		      }
		    
		    num_bits[vo_id][vol_id].mot_shape_text += 
		      BitstreamPut(motion_comb_bitstream,vo_id,vol_id);
		    BitstreamFree(motion_comb_bitstream);
			
		    aux_bitstream = BitstreamInit();
		    BitstreamPutBits(aux_bitstream,MOTION_MARKER_COMB,MOTION_MARKER_COMB_LENGTH);
		    
		    num_bits[vo_id][vol_id].syntax += 
		      BitstreamPut(aux_bitstream,vo_id,vol_id);
		    BitstreamFree(aux_bitstream);
			
		    num_bits[vo_id][vol_id].mot_shape_text += 
		      BitstreamPut(text_header_comb_bitstream,vo_id,vol_id);
		    BitstreamFree(text_header_comb_bitstream);
			
		    num_bits[vo_id][vol_id].mot_shape_text += 
		      BitstreamPut(text_data_comb_bitstream,vo_id,vol_id);
		    BitstreamFree(text_data_comb_bitstream);
		  }

/* >>> added for DRC by Fujitsu (top)    <<< */
                if(GetVopReducedResolution(curr)) {
	            UpSamplingTexture(reduced_res_rec_error, rec_error); 
                    CopyQPStore(reduced_res_rec_error, rec_error); 
                }
/* >>> added for DRC by Fujitsu (bottom) <<< */

		AddImage(comp->y_chan, rec_error->y_chan, rec_curr->y_chan);
		AddImage(comp->u_chan, rec_error->u_chan, rec_curr->u_chan);
		AddImage(comp->v_chan, rec_error->v_chan, rec_curr->v_chan);
		
		CopyImage(GetVopQP(rec_error), GetVopQP(rec_curr));
		    
/* >>> added for DRC by Fujitsu (top)    <<< */
                if(GetVopReducedResolution(curr)) {
                  PutVopAverageQp(GetVopAverageQp(reduced_res_rec_error),curr);
                } else {
                  PutVopAverageQp(GetVopAverageQp(rec_error),curr);
                }
/* >>> added for DRC by Fujitsu (bottom) <<< */

		ClipImage (rec_curr->y_chan,GetVopBrightWhite(rec_curr));
		ClipImage (rec_curr->u_chan,GetVopBrightWhite(rec_curr));
		ClipImage (rec_curr->v_chan,GetVopBrightWhite(rec_curr));
		    
/* >>> added for DRC by Fujitsu (top)    <<< */
               if(GetVopReducedResolution(curr)) {
                  BlockBoundaryFilter(rec_curr, cod_flag, vp_num, (!GetVopNewpredEnable(curr))||(GetVopNewpredSegmentType(curr))); /* DRC 1999.12.14 */
                  FreeVop(reduced_res_rec_error);
                }
/* >>> added for DRC by Fujitsu (bottom) <<< */

		FreeVop(error_vop);
		FreeVop(comp);
		FreeVop(rec_error);
	      }
	    else /* No Data Partitioning */
	      {
		fprintf(stdout,"\t\tCoding combined shape, motion and INTER texture\n\n");
		
		/* RC2: adding combined mode VM5.0 Rate Control */
		if (rc_type == VM5_RATE_CONTROL)
		  {
		    if (RCQ2_MVO_CHECK() >= RCQ2_MVO_ENABLED)
		      ;
		    else
		      mad = DSRC_compute_MAD(error_vop, &num_pels_vop);

		    if (RCQ2_MVO_CHECK() >= RCQ2_MVO_ENABLED)
		      ;
		    else
		      vop_quantizer = RC_QuantAdjust(vo_id, 
						     vol_id, 
						     vo_config_list, 
						     vol_config, 
						     (Double)mad, 
						     curr, 
						     error_vop, 
						     num_pels_vop,
						     GetVopPredictionType(curr));
		    
		    /* RC2 */
		    fprintf(stdout,"\t\tInter Quantizer : %d\n", (int)vop_quantizer);
		  }
		
		num_bits[vo_id][vol_id].syntax +=
		  BitstreamPutVopHeader(curr,vo_id,time,TRB,vol_config,
					num_bits,vo_config_list,
					rc_type, modulo_tps);
		
		if (GetVopPredictionType(curr)!=B_VOP) 
		  {
		    slice_counter = 0;
		    num_bits_packet = 0;
		    first_marker = 1;
		    after_marker = 0;
		    start_of_packet = 1;
		    k = 0;
		    comb_bitstream = BitstreamInit();
		    
		    /* 	encode the 1st MB shape of the frame */  
		    /* 	In the following MB encoding loop, the shape coding is one MB
			ahead of the texture coding */
		    
		    if (GetVopShape(curr))
		      {
			shape_bits = ShapeCodeMB(curr,
						 rec_curr,
						 rec_prev,
                                                        NULL, /* added for OBSS by Samsung AIT (1999-09-29) */
						 vo_id,
						 0,
						 0,
						 alpha_th,
						 modeA,
						 mot_x,
						 mot_y,
						 motA_x,
						 motA_y,
						 MB_decisions,
						 alpha_decisions,
						 &first_bits,
						 first_stream,
						 shape_stream,
						 start_of_packet
						 );
			BitstreamAppendTtoM(First_stream[k], first_stream, 
					    first_bits);
			BitstreamAppendTtoM(Shape_stream[k], shape_stream, 
					    shape_bits);
		      }
			
/* >>> added for DRC by Fujitsu (top)    <<< */
/*
		    for (j = 0; j < num_lines/MB_SIZE; j++) 
		      {
			for (i = 0; i < num_pixels/MB_SIZE; i++) 
*/
  	            for (j = 0; j < num_lines/mb_size_variable; j++)
		      {
		        for (i = 0; i < num_pixels/mb_size_variable; i++)
/* >>> added for DRC by Fujitsu (bottom) <<< */
			  {
			    slice_nb[i][j] = slice_counter;
			    vp_num[i+j*num_pixels/mb_size_variable] = slice_counter+1;  /* DRC 1999.12.14 */

			    if (GetVopShape(curr))
			      {
				if ((num_bits_packet+GetImageSizeX(First_stream[k])
				     +GetImageSizeX(Shape_stream[k])) > 
				    RESYNC_MARKER_SPACING)
				  start_of_packet = 1;
				else 
				start_of_packet = 0;

				/* encode the shape of the next MB */   
				
				if (i==(num_pixels/MB_SIZE-1)) 
				  {
				    i_next = 0;
				    j_next = j+1;
				  }
				else 
				  {
				    i_next = i+1;
				    j_next = j;
				  }
				
				if (j_next < num_lines/MB_SIZE)  /* check that the next MB exists */
				  {						
				    shape_bits = ShapeCodeMB(curr,
							     rec_curr,
							     rec_prev,
								NULL, /* added for OBSS by Samsung AIT (1999-09-29)*/
							     vo_id,
							     j_next,
							     i_next,
							     alpha_th,
							     modeA,
							     mot_x,
							     mot_y,
							     motA_x,
							     motA_y,
							     MB_decisions,
							     alpha_decisions,
							     &first_bits,
							     first_stream,
							     shape_stream,
							     start_of_packet
							     );
				    BitstreamAppendTtoM(First_stream[k+1], 
							first_stream, 
							first_bits);
				    BitstreamAppendTtoM(Shape_stream[k+1], 
							shape_stream, 
							shape_bits);
				    k++;
				  }
				if (GetVopShape(rec_curr)!=BINARY_SHAPE_ONLY)
				  {
				    /* Mooshofer, 2000-03-15 */ 
				    /* CopyVopABlock(rec_curr, error_vop, i*MB_SIZE, j*MB_SIZE); 
				    CopyVopAuvBlock(rec_curr, error_vop , i*B_SIZE, j*B_SIZE);  */
				    CopyVopABlock(rec_curr, rec_error, i*MB_SIZE, j*MB_SIZE); 
				    CopyVopAuvBlock(rec_curr, rec_error , i*B_SIZE, j*B_SIZE);

				    MotionCompensateMB(rec_prev,pi,pi_grey,mot_x,mot_y,i,j,/* U. Benzler 981209 : added interlaced greyscale support */
						       GetVopOBMCDisable(curr),
						       alpha_decisions, MB_decisions, comp);
				    
				    FillErrorMB(curr,rec_curr,comp,error_vop,i,j);
				    
				    PadMB(rec_curr,MB_decisions,error_vop,i,j);
				  }
			      }
			    
/* >>> added for DRC by Fujitsu (top)    <<< */
                            if (GetVopReducedResolution(curr)==1) {
			      MBShapeMotTextErrRes(reduced_res_error_vop, alpha_decisions, MB_decisions, 
						 mot_x_rr, mot_y_rr, quarter_pel, f_code_for, First_stream, /* MW QPEL 07-JUL-1998 */ 
						 Shape_stream, 
						 GetVopIntraACDCPredDisable(curr),
						 GetVopDataPartEnable(curr),reduced_res_rec_error, 
						 comb_bitstream,
						 comb_bitstream,
						 comb_bitstream,
						 i, j, &num_bits_MB,
						 after_marker,
						 DC_store, slice_nb,
                                                 &cod_flag_mb,
						 &num_bits[vo_id][vol_id].text_bits);

                              cod_flag[j*MB_width+i]= cod_flag_mb;
                            } else {
/* >>> added for DRC by Fujitsu (bottom) <<< */
			    MBShapeMotTextErrRes(error_vop, alpha_decisions, MB_decisions, 
						 mot_x, mot_y, quarter_pel, f_code_for, First_stream, /* MW QPEL 07-JUL-1998 */ 
						 Shape_stream, 
						 GetVopIntraACDCPredDisable(curr),
						 GetVopDataPartEnable(curr),rec_error, 
						 comb_bitstream,
						 comb_bitstream,
						 comb_bitstream,
						 i, j, &num_bits_MB,
						 after_marker,
						 DC_store, slice_nb,
/* >>> added for DRC by Fujitsu (top)    <<< */
                                                 &cod_flag_mb,
/* >>> added for DRC by Fujitsu (bottom) <<< */
						 &num_bits[vo_id][vol_id].text_bits);
/* >>> added for DRC by Fujitsu (top)    <<< */
                            } 
/* >>> added for DRC by Fujitsu (bottom) <<< */
				
			    after_marker = 0;
			    num_bits_packet += num_bits_MB;
/* (Oki) 16-AUG-1999
 *			    if ((num_bits_packet >= RESYNC_MARKER_SPACING) && start_of_packet
 *				&& ((j*MB_width+i) < (MB_height*MB_width-1)))
 */
			    /** modified for NEWPRED (Oki) 16-AUG-1999 **/
			    /*
			     *	P-VOP (non Data Partitioning)
			     */
			    /* In non NEWPRED on resync slice mode, resync_marker is inserted
			       everywhere amount of slice bits is beyond the constant one.
			       In NEWPRED mode, resysnc_marker is inserted to the fixed 
			       position that is indicated in the control file. */
			    if((GetVopNewpredEnable(curr) && !GetVopNewpredSegmentType(curr) &&
				((j*MB_width+i != 0) && 
				 (j*MB_width+i+1 == vol_config->mba_segment[slice_counter+1]/mba_scale)) && /* >>> modified for DRC by Fujitsu <<< */
				(j*MB_width+i < MB_height*MB_width-1)) ||
			       (((GetVopNewpredEnable(curr) && GetVopNewpredSegmentType(curr)) ||
				 !GetVopNewpredEnable(curr)) && /** Oki 26-AUG-1999 **/
				(num_bits_packet >= RESYNC_MARKER_SPACING) &&
				start_of_packet &&
				(j*MB_width+i < MB_height*MB_width-1)))
			      /** end of NEWPRED (Oki) 16-AUG-1999 **/
			      {
				if (GetVopShape(curr))
				start_of_packet = 0;
				
				num_bits[vo_id][vol_id].mot_shape_text += 	
				  BitstreamPut(comb_bitstream,vo_id,vol_id);
				BitstreamFree(comb_bitstream);
				    
 /* revised HEC for shape due to N2693 */
				aux_bitstream = BitstreamInit();
				BitstreamPutBits(aux_bitstream,RESYNC_MARKER,resync_marker_length);
				if (GetVopShape(curr) != RECTANGULAR) {
				  if (first_marker)
				    {
/*				      first_marker = 0;*/
				      /* Write the HEC-flag and then the HEC itself */
				      BitstreamPutBits(aux_bitstream,1,1);
				      BitstreamPutShapeHEC(vol_config, curr, aux_bitstream);

				    }
				  else
				    {  
				      BitstreamPutBits(aux_bitstream,0,1);
				    }
				}

				BitstreamPutBits(aux_bitstream,j*MB_width+i+1,MB_in_VOP_length);
				
				if (GetVopShape(curr) != BINARY_SHAPE_ONLY) 	
				  BitstreamPutBits(aux_bitstream,GetVopQuantizer(curr),
						   GetVopQuantPrecision(curr));
				    
				if (first_marker)
				  {
				    first_marker = 0;
				    /* Write the HEC-flag and then the HEC itself */
				    if (GetVopShape(curr) == RECTANGULAR)
				      BitstreamPutBits(aux_bitstream,1,1);
				    BitstreamPutHEC(vol_config, curr, time, aux_bitstream);


				  }
				else
				  {
				    if (GetVopShape(curr) == RECTANGULAR)
				      BitstreamPutBits(aux_bitstream,0,1);
				  }
				    
				/** added for NEWPRED (Oki) 16-AUG-1999 **/
				if(GetVopNewpredEnable(curr)){
				  /* insert additional syntax for NEWPRED */
				  BitstreamPutNEWPRED(vol_config, curr, np_vop_id, 
						      slice_counter + 1, aux_bitstream, 1);
				}
				/** end of NEWPRED (Oki) 16-AUG-1999 **/

				NextResyncMarker(vo_id,vol_id);
				num_bits[vo_id][vol_id].syntax += 
				  BitstreamPut(aux_bitstream,vo_id,vol_id);
				BitstreamFree(aux_bitstream);
				    
				comb_bitstream = BitstreamInit();
				
				num_bits_packet = 0;
				after_marker = 1;
				slice_counter++;
			      }
			  }
		      }
		    
		    num_bits[vo_id][vol_id].mot_shape_text += 
		      BitstreamPut(comb_bitstream,vo_id,vol_id);
		    BitstreamFree(comb_bitstream);
		  }
		else /* B_VOP */
		  {
		    /* encode B-VOPs */
		    slice_counter = 0;
		    num_bits_packet = 0;
		    first_marker = 1;
		    after_marker = 0;
		    start_of_packet = 1;
		    k = 0;
		    comb_bitstream = BitstreamInit();

		    /* MW 05-MAY-1998 bug fix by Luis D. Soares */
		    if (SelectRefVop(rec_prev,rec_curr,next_rec_vop,TRB,TRD))
		      ref_vop = next_rec_vop;
		    else
		      ref_vop = rec_prev;

		    /* 	encode the 1st MB shape of the frame */  
		    /* 	In the following MB encoding loop, the shape coding is one MB
			ahead of the texture coding */
		    if (GetVopShape(curr))
		      {
			shape_bits = ShapeCodeMB(curr,
						 rec_curr,
						 ref_vop,
						 /* rec_prev, */ /* MW 05-MAY-1998 */
							NULL, /* added for OBSS by Samsung AIT (1999-09-29) */
						 vo_id,
						 0,
						 0,
						 alpha_th,
						 modeA,
						 mot_x,
						 mot_y,
						 motA_x,
						 motA_y,
						 MB_decisions,
						 alpha_decisions,
						 &first_bits,
						 first_stream,
						 shape_stream,
						 start_of_packet
						 );
			BitstreamAppendTtoM(First_stream[k], first_stream, 
					    first_bits);
			BitstreamAppendTtoM(Shape_stream[k], shape_stream, 
					    shape_bits);
		      }
		    
		    for (j = 0; j < num_lines/MB_SIZE; j++) 
		      {
			for (i = 0; i < num_pixels/MB_SIZE; i++) 
			  {
			    slice_nb[i][j] = slice_counter;
			    
			    if (GetVopShape(curr))
					{
					  if ((num_bits_packet+GetImageSizeX(First_stream[k])
					       +GetImageSizeX(Shape_stream[k])) > 	
					      RESYNC_MARKER_SPACING)
					    start_of_packet = 1;
					  else 
					    start_of_packet = 0;

					  /* encode the shape of the next MB */   
					  
					  if (i==(num_pixels/MB_SIZE-1)) 
					    {
					      i_next = 0;
					      j_next = j+1;
					    }
					  else 
					    {
					      i_next = i+1;
					      j_next = j;
					    }
					  
					  if (j_next < num_lines/MB_SIZE)  /* check that the next MB exists */
					    {						
					      shape_bits = ShapeCodeMB(curr,
								       rec_curr,
								       ref_vop,
								       /* rec_prev, */ /* MW 05-MAY-1998 */
									NULL, /* added for OBSS by Samsung AIT (1999-09-29) */
								       vo_id,
								       j_next,
								       i_next,
								       alpha_th,
								       modeA,
								       mot_x,
								       mot_y,
								       motA_x,
								       motA_y,
								       MB_decisions,
								       alpha_decisions,
								       &first_bits,
								       first_stream,
								       shape_stream,
								       start_of_packet
								       );
					      BitstreamAppendTtoM(First_stream[k+1], 
								  first_stream, 
								  first_bits);
					      BitstreamAppendTtoM(Shape_stream[k+1], 
								  shape_stream, 
								  shape_bits);
					      k++;
					    }
					  
					  if (GetVopShape(rec_curr)!=BINARY_SHAPE_ONLY)
					    {
					      CopyVopABlock(rec_curr, rec_error, i*MB_SIZE, j*MB_SIZE); 
					      CopyVopAuvBlock(rec_curr, rec_error, i*B_SIZE, j*B_SIZE);
					      
					      B_MotionCompensateMB(i,j,curr,rec_prev,next_rec_vop,
								   mot_x, mot_y,
								   mot_x_P[vo_id][vol_id],
								   mot_y_P[vo_id][vol_id],
								   MB_decisions_P[vo_id][vol_id],
								   MB_decisions,
								   alpha_decisions, TRB,TRD, comp,
								   quarter_pel,edge); /* MW QPEL 07-JUL-1998 */
									
					      FillErrorMB(curr,rec_curr,comp,error_vop,i,j);

					      PadMB(rec_curr,MB_decisions,error_vop,i,j);
					    }
					}
			    
			    B_MBShapeMotTextErrRes(error_vop, alpha_decisions, MB_decisions, 
						   mot_x, mot_y,
						   f_code_for, f_code_back, First_stream, 
						   Shape_stream, 
						   rec_error, 
						   comb_bitstream,
						   i, j, &num_bits_MB,
						   slice_nb,
						   &num_bits[vo_id][vol_id].text_bits,
						   ResetPredictor); /* U. Benzler 990729 - Patch corresponding to combined_decode.c-patch  28.10.98 - Shinya Kadono (SB) */
			    ResetPredictor = 0;	/* U. Benzler 990729 - Patch corresponding to combined_decode.c-patch 28.10.98 - Shinya Kadono (SB) */
			    
			    after_marker = 0;
			    num_bits_packet += num_bits_MB;
			    if ((num_bits_packet >= RESYNC_MARKER_SPACING) && start_of_packet
				&& ((j*MB_width+i) < (MB_height*MB_width-1)))
			      {
				if (GetVopShape(curr))
				  start_of_packet = 0;
				    
				num_bits[vo_id][vol_id].mot_shape_text += 
				  BitstreamPut(comb_bitstream,vo_id,vol_id);
				BitstreamFree(comb_bitstream);
				    
/* revised HEC for shape due to N2693 */
				aux_bitstream = BitstreamInit();
				BitstreamPutBits(aux_bitstream,RESYNC_MARKER,resync_marker_length);
				if (GetVopShape(curr) != RECTANGULAR) {
				  if (first_marker)
				    {
/*				      first_marker = 0;*/
				      /* Write the HEC-flag and then the HEC itself */
				      BitstreamPutBits(aux_bitstream,1,1);
				      BitstreamPutShapeHEC(vol_config, curr, aux_bitstream);

				    }
				  else
				    {  
				      BitstreamPutBits(aux_bitstream,0,1);
				    }
				}

				BitstreamPutBits(aux_bitstream,j*MB_width+i+1,MB_in_VOP_length);
				
				if (GetVopShape(curr) != BINARY_SHAPE_ONLY) 
				  BitstreamPutBits(aux_bitstream,GetVopBQuantizer(curr),
						   GetVopQuantPrecision(curr));
				
				if (first_marker)
				  {
				    first_marker = 0;
				    /* Write the HEC-flag and then the HEC itself */
				    if (GetVopShape(curr) == RECTANGULAR)
				      BitstreamPutBits(aux_bitstream,1,1);
				    BitstreamPutHEC(vol_config, curr, time, aux_bitstream);

				  }
				else
				  {  
				    if (GetVopShape(curr) == RECTANGULAR)
				      BitstreamPutBits(aux_bitstream,0,1);
				  }
				    
				NextResyncMarker(vo_id,vol_id);
				num_bits[vo_id][vol_id].syntax += 
				  BitstreamPut(aux_bitstream,vo_id,vol_id);
				BitstreamFree(aux_bitstream);
				    
				comb_bitstream = BitstreamInit();
				    
				num_bits_packet = 0;
				after_marker = 1;
				slice_counter++;
			      }
			  }
		      }
			
		    num_bits[vo_id][vol_id].mot_shape_text += 
		      BitstreamPut(comb_bitstream,vo_id,vol_id);
		    BitstreamFree(comb_bitstream);
		  }
			
/* >>> added for DRC by Fujitsu (top)    <<< */
                if(GetVopReducedResolution(curr)) {
	            UpSamplingTexture(reduced_res_rec_error, rec_error); 
                    CopyQPStore(reduced_res_rec_error, rec_error); 
                }
/* >>> added for DRC by Fujitsu (bottom) <<< */

		AddImage(comp->y_chan, rec_error->y_chan, rec_curr->y_chan);
		AddImage(comp->u_chan, rec_error->u_chan, rec_curr->u_chan);
		AddImage(comp->v_chan, rec_error->v_chan, rec_curr->v_chan);
		    
		CopyImage(GetVopQP(rec_error), GetVopQP(rec_curr));
		    
/* >>> added for DRC by Fujitsu (top)    <<< */
                if(GetVopReducedResolution(curr)) {
                  PutVopAverageQp(GetVopAverageQp(reduced_res_rec_error),curr);
                } else {
                  PutVopAverageQp(GetVopAverageQp(rec_error),curr);
                }
/* >>> added for DRC by Fujitsu (bottom) <<< */

		ClipImage (rec_curr->y_chan,GetVopBrightWhite(rec_curr));
		ClipImage (rec_curr->u_chan,GetVopBrightWhite(rec_curr));
		ClipImage (rec_curr->v_chan,GetVopBrightWhite(rec_curr));
		    		    
/* >>> added for DRC by Fujitsu (top)    <<< */
                if(GetVopReducedResolution(curr)) {
                    BlockBoundaryFilter(rec_curr, cod_flag, vp_num, (!GetVopNewpredEnable(curr))||(GetVopNewpredSegmentType(curr))); /* DRC 1999.12.14 */
                    FreeVop(reduced_res_rec_error);
                }
/* >>> added for DRC by Fujitsu (bottom) <<< */

		FreeVop(error_vop);
		FreeVop(comp);
		FreeVop(rec_error);
	      }
	    
	    FreeShapePacket();
	    
	    if (GetVopShape(curr) && (GetVopShape(curr) != BINARY_SHAPE_ONLY))
	      {		    
		if (GetVopPredictionType(curr)!=B_VOP && !quarter_pel) /* MW QPEL 09-JUL-1998 */
		  FreeImage(pi);
		FreeImage(modeA);
		FreeImage(motA_x);
		FreeImage(motA_y);
	      }
	    
	    FreeImage(alpha_decisions);
	    
	    if(alpha_sub_pad!=NULL) 
	      FreeImage(alpha_sub_pad);
	    
/* >>> added for DRC by Fujitsu (top)    <<< */
            if(GetVopReducedResolution(curr)) {
                FreeVop(reduced_res_error_vop);
                FreeImage(mot_x_rr);
                FreeImage(mot_y_rr);
            }
            free((Char*)cod_flag); 
            free((Char*)vp_num);  /* DRC 1999.12.14 */
/* >>> added for DRC by Fujitsu (bottom) <<< */

	  }  /* End of error resilient mode */
      }  /* End of P-VOP, B_VOP */
 
  /* Deallocate memory for intermediate bitstreams */
  BitstreamFree(first_shape_code_bitstream);
  BitstreamFree(shape_bitstream);
  BitstreamFree(texture_bitstream);
  BitstreamFree(motion_bitstream);
  BitstreamFree(mottext_bitstream);

  if (flag_static_sprite_piece==0) /* no next start code in the syntax for sprite pieces */
    {
      if (GetVopSpriteUsage(curr)!=STATIC_SPRITE||
	  GetVopPredictionType(curr)==SPRITE_VOP)
        num_bits[vo_id][vol_id].texture+=
	  NextStartCode(vo_id,vol_id); /* added by Minhua Zhou 16-05-97 */
      else
        num_bits[vo_id][vol_id].sprite_piece+=
	  NextStartCode(vo_id,vol_id);
    }
 
  /* Free shape stream */
  for(i=0; i<(GetVopWidth(curr)/MB_SIZE)*(GetVopHeight(curr)/MB_SIZE); i++)
    {
      BitstreamFree(First_stream[i]);
      BitstreamFree(Shape_stream[i]);
    }
  free(First_stream);
  free(Shape_stream);
  
  if (GetVopErrorResDisable(curr) != NON_ERROR_RESILIENT)
    {
      /* Free allocated memory for 3D matrix */
      for (i = 0; i < MB_width*MB_height; i++)
	{
	  for (j = 0; j < 6; j++)
	    free(DC_store[i][j]);
	  free(DC_store[i]);
	}
      free(DC_store);
      
      /* Free allocated memory for 2D matrix */
      for (i = 0; i < MB_width; i++)
	free(slice_nb[i]);
      free(slice_nb);
    }
      
  if  (GetVopPredictionType(curr) == SPRITE_VOP) 
    {
      if (GetVolConfigSpriteUsage(vol_config) != STATIC_SPRITE)
      	{
	  free(prev_warp_param);
	  PutVolConfigPrevWarpParam(warp_param, vol_config);
	}
      else
      	free(warp_param);
      
      if (GetVolConfigNoOfSpritePoints(vol_config)) 
	{
	  free(traj); 
	  free(difftraj); 
	  free(qtraj);   
	}
    } 
	
  /* Compute the Vop PSNR's */
  num_bits[vo_id][vol_id].psnr_y = VopPSNR_Y(curr,rec_curr);
  for(aux=0;aux<GetVopAuxCompCount(curr);aux++) /* MAC (SB) 16-Nov-99 */
    num_bits[vo_id][vol_id].psnr_g[aux] = VopPSNR_G(curr,rec_curr,aux);	/* HYUNDAI (Grayscale) */
  num_bits[vo_id][vol_id].psnr_u = VopPSNR_U(curr,rec_curr);
  num_bits[vo_id][vol_id].psnr_v = VopPSNR_V(curr,rec_curr);

  if(!vop_spat_scal && temporal_scalability != 0)
    {
      FreeVopChannels(no_padding_vop);
      AllocVopChannels(no_padding_vop,GetImageSizeX(rec_curr->a_chan),
		       GetImageSizeY(rec_curr->a_chan), GetVopAuxCompCount(rec_curr));
      CopyVop(rec_curr,no_padding_vop);
    }

/* begin: added for OBSS by Samsung AIT (1999-09-29) */
  if(GetVolConfigVersion(vol_config)!=1) {	/* version 2 */
    if (GetVopSpriteUsage(curr) != STATIC_SPRITE) {
        if( GetVopInterlaced(curr) )
        {
            VopFieldPadding(curr);
            VopFieldPadding(rec_curr);
        }
        else
        {
            VopPadding(curr);
            VopPadding(rec_curr);
        }
    }
  } else {
/* end: added for OBSS by Samsung AIT (1999-09-29) */
  if (GetVopSpriteUsage(curr) != STATIC_SPRITE)
    if ((GetVopPredictionType(curr)!=B_VOP) ||
	(vop_spat_scal) ||
	(temporal_scalability == 2 && GetVopPredictionType(curr)==B_VOP))
      {
/* HYUNDAI 980507 : start */
        if( GetVopInterlaced(curr) )
        {
            VopFieldPadding(curr);
            VopFieldPadding(rec_curr);
        }
        else
        {
            VopPadding(curr);
            VopPadding(rec_curr);
        }
/* HYUNDAI 980507 : end */
      }
/* begin: added for OBSS by Samsung AIT (1999-09-29) */
  }
/* end: added for OBSS by Samsung AIT (1999-09-29) */

  if (GetVopPredictionType(curr) != SPRITE_VOP || GetVopSpriteUsage(curr) != STATIC_SPRITE )
    if (GetVopShape(curr) != BINARY_SHAPE_ONLY)  /* BSO_NOEL */
      {
	/* Deallocate memory for motion vectors and MB modes */
	if (GetVopPredictionType(curr)!=B_VOP ||
	    (GetVopScalability( curr ) && temporal_scalability == 2)) 
	  {
	    if (mot_x_P[vo_id][vol_id]!=NULL) 
	      FreeImage(mot_x_P[vo_id][vol_id]);
	    if (mot_y_P[vo_id][vol_id]!=NULL) 
	      FreeImage(mot_y_P[vo_id][vol_id]);
	    if (MB_decisions_P[vo_id][vol_id]!=NULL) 
	      FreeImage(MB_decisions_P[vo_id][vol_id]);
              
	    if (GetVopPredictionType(curr)==I_VOP) 
	      {
		mot_x_P[vo_id][vol_id]=AllocImage(MB_width*2,MB_height*2,FLOAT_TYPE);
                mot_y_P[vo_id][vol_id]=AllocImage(MB_width*2,MB_height*2,FLOAT_TYPE);
                SetConstantImage (mot_x_P[vo_id][vol_id],+0.0);
                SetConstantImage (mot_y_P[vo_id][vol_id],+0.0);
                if (MB_decisions!=NULL) FreeImage(MB_decisions);
                MB_decisions_P[vo_id][vol_id]=AllocImage(MB_width,MB_height,SHORT_TYPE);
                SetConstantImage (MB_decisions_P[vo_id][vol_id],+0.0);
	      } 
	    else 
	      {
		mot_x_P[vo_id][vol_id] = mot_x;
		mot_y_P[vo_id][vol_id] = mot_y;
		MB_decisions_P[vo_id][vol_id]=MB_decisions;
	      }
	  } 
	else 
	  {
	    FreeImage(mot_x);
	    FreeImage(mot_y);
	    FreeImage(MB_decisions);
	  }
      }
  
  /* Compute total bits for this Vop */
  if (GetVolConfigSpriteUsage(vol_config) != STATIC_SPRITE || 
      GetVopPredictionType(curr) == SPRITE_VOP)
    {
      num_bits[vo_id][vol_id].vop =
	num_bits[vo_id][vol_id].syntax + num_bits[vo_id][vol_id].shape 
	+ num_bits[vo_id][vol_id].motion + num_bits[vo_id][vol_id].texture 
	+ num_bits[vo_id][vol_id].mot_shape_text;
  
/* >>> added for DRC by Fujitsu (top)    <<< */
      PutVopBitsUsed(num_bits[vo_id][vol_id].vop,curr);
/* >>> added for DRC by Fujitsu (bottom) <<< */

      /* Increment bit count for VOL */
      num_bits[vo_id][vol_id].vol += num_bits[vo_id][vol_id].vop; 

      /* Increment average counters */
      num_bits[vo_id][vol_id].psnr_y_ave += num_bits[vo_id][vol_id].psnr_y;
      for(aux=0;aux<GetVolConfigAuxCompCount(vol_config);aux++) /* MAC (SB) 16-Nov-99 */
        num_bits[vo_id][vol_id].psnr_g_ave[aux] += num_bits[vo_id][vol_id].psnr_g[aux];	/* HYUNDAI (Grayscale) */
      num_bits[vo_id][vol_id].psnr_u_ave += num_bits[vo_id][vol_id].psnr_u;
      num_bits[vo_id][vol_id].psnr_v_ave += num_bits[vo_id][vol_id].psnr_v;
      num_bits[vo_id][vol_id].average += num_bits[vo_id][vol_id].vop;
      num_bits[vo_id][vol_id].average_shape += shape_bits;
      num_bits[vo_id][vol_id].shape = shape_bits;
    }
 
 
  return;
} /* CodeVop() */






/***********************************************************CommentBegin******
 *
 * -- VopPSNR_xxxx -- Functions computing the Vop PSNRs.
 *
 *		VopPSNR_Y(Vop *original, Vop *reconstructed)
 *		VopPSNR_U(Vop *original, Vop *reconstructed)
 * 	VopPSNR_V(Vop *original, Vop *reconstructed)
 *
 * Author :		
 *	Noel Brady Teltec Irl.
 *
 * Created :		
 *	6-6-96
 *
 * Purpose :		
 *	Computes PSNRs for the various components of the VOP
 *	
 * 
 * Arguments in : 	
 *	Vop *original - the source Vop
 *	Vop *reconstructed - the coded or noisy vop
 *
 * Arguments in/out :	
 *	-
 *
 * Arguments out :	
 *	-
 *
 * Return values :	
 *	The PSNR value.
 *
 * Side effects :	
 *	-
 *
 * Description :	
 *	In the computation, only pixels within the Vop shape are considered.
 *	The alpha plane from the reconstructed Vop is used to mask the
 *	error signal.
 *
 * See also :
 *	MaskedPSNRImage()
 *
 * Modified :		
 *	2-Dec-96 Jan De Lameillieure (HHI): calculate SNR only in pels
 *			that belong to original AND reconstructed segment
 *			mask
 *  	20-MAR-97 Jan De Lameillieure (HHI) : added shape argument to
 *			SubsampleAlphaMap()
 *      25.06.97  Minhua Zhou: Removed  "SubsampleAlphaMap" in VopPSNR_U,VopPSNR_V
 *      21.05.98 Ji Heon Kweon (HYUNDAI) : support for grayscale coding
 *
 ***********************************************************CommentEnd********/

Float 
VopPSNR_Y(Vop *original, Vop *reconstructed)
{
  Image	*im_ori = GetVopY(original),
    *im_rec = GetVopY(reconstructed),
    *alpha_ori = GetVopA(original),
    *alpha_rec = GetVopA(reconstructed);

  return MaskedPSNRImage(im_ori,im_rec,alpha_ori,alpha_rec);
}

/* HYUNDAI (Grayscale */
Float
VopPSNR_G(Vop *original, Vop *reconstructed, Int aux_comp)
{
  Image *im_ori = GetVopG(aux_comp,original),
    *im_rec = GetVopG(aux_comp,reconstructed),
    *alpha_ori = GetVopA(original),
    *alpha_rec = GetVopA(reconstructed);

  return MaskedPSNRImage(im_ori,im_rec,alpha_ori,alpha_rec);
}

Float
VopPSNR_U(Vop *original, Vop *reconstructed)
{
	Image *im_ori = GetVopU(original),
			*im_rec = GetVopU(reconstructed),
  			*alpha_ori_sub = GetVopAuv(original),
			*alpha_rec_sub = GetVopAuv(reconstructed);
	Float psnr;

      

	psnr = MaskedPSNRImage(im_ori,im_rec,alpha_ori_sub,alpha_rec_sub);
	return psnr;
}

Float
VopPSNR_V(Vop *original, Vop *reconstructed)
{
	Image *im_ori = GetVopV(original),
			*im_rec = GetVopV(reconstructed),
  			*alpha_ori_sub = GetVopAuv(original),
			*alpha_rec_sub = GetVopAuv(reconstructed);
	Float psnr;

      

	psnr = MaskedPSNRImage(im_ori,im_rec,alpha_ori_sub,alpha_rec_sub);
	return psnr;
}

/***********************************************************CommentBegin******
 *
 * -- BitstreamPutGOV -- Writes all fields of the Group of VOPs syntax
 *
 * Author :		
 *	Minhua Zhou
 *
 * Created :		
 *	05-05-97
 *
 * Purpose :		
 * 
 * Arguments in : 	
 *	Vop *vop - pointer to vop containing header information
 * Int vo_id - current VO Id
 *
 * Arguments in/out :	
 *	-
 *
 * Arguments out :	
 *	-
 *
 * Return values :	
 *	UInt num_bits - number of bits written
 *
 * Side effects :	
 *	-
 *
 * Description :	
 *
 * See also :
 *
 * Modified :	23.03.98 M. Wollborn: included user data in GOV 
 *                                    due to N2171, Cl. 2.1.9	
  ***********************************************************CommentEnd********/
 
UInt BitstreamPutGOV(Vop *vop, Int vo_id,
                     Float time,
                     Int TRD, 
		     VolConfig *vol_config)
  {
    Image *buffer;
    Int time_s,vol_id,num_bits;
    
    vol_id = GetVolConfigId(vol_config);
    fprintf(stdout,"Transmission of GOV\n");
    
    /* Set up intermediate integer level data structure */
    buffer = BitstreamInit();
    BitstreamPutBits(buffer,GROUP_START_CODE,32);
    
    /* modified to encode GOV header by SONY 980212 */
    time_s = (Int)( (vol_config->frame - vol_config->frame_skip * (2*TRD-1) - vol_config->start_frame) / vol_config->disk_seq_frame_rate );
    if(time_s<0) time_s=0;
    /* 980212 */
    
    /* Sending time_code */
    BitstreamPutBits(buffer,(time_s/3600)%24,5); /* Hours */
    BitstreamPutBits(buffer,(time_s/60)%60,6); /* Minutes */
    BitstreamPutBits(buffer,1,1);   /* Marker bit */
    BitstreamPutBits(buffer,time_s%60,6); /* Seconds */
    PutVolConfigModTimeBase(time_s,vol_config);
    PutVolConfigModTimeBase(time_s,vol_config);
    
/* SONY 070498 - start */       
    BitstreamPutBits(buffer,1,1);
/* SONY 070498 - end */
    
    BitstreamPutBits(buffer,0,1); /* broken_link=0 */
    
    num_bits = BitstreamPut(buffer,vo_id,vol_id);
    num_bits +=NextStartCode(vo_id,vol_id);
    BitstreamFree(buffer);
    
    /* Included for user data due to N2171, Cl. 2.1.9 MW 23-MAR-1998 */
    if(GetVolConfigIsUserDataInGov(vol_config))
      num_bits += PutUserDataToBitstream(GetVolConfigUserDataInGovFile(vol_config),
					 vo_id,vol_id);
    return(num_bits);
  }  






/***********************************************************CommentBegin******
 *
 * -- BitstreamPutVopHeader -- Writes all fields of the vop header syntax
 *
 * Author :		
 *	Noel O'Connor Teltec Irl.
 *
 * Created :		
 *	11-03-96
 *
 * Purpose :		
 *	This function writes all fields of the vop header syntax to the
 * bitstream disk file.
 * 
 * Arguments in : 	
 *	Vop *vop - pointer to vop containing header information
 * Int vo_id - current VO Id
 *
 * Arguments in/out :	
 *	-
 *
 * Arguments out :	
 *	-
 *
 * Return values :	
 *	UInt num_bits - number of bits written
 *
 * Side effects :	
 *	-
 *
 * Description :	
 *	The vop header (start_code, vop_ID, etc.) is first
 *	written to an intermediate integer level bitstream data structure.
 *	This intermediate bitstream data structure is then written to disk.
 *
 * See also :
 *	mom_bitstream.c
 *
 * Modified :		
 * 21.05.96 - Noel O'Connor : modified to comply with VM2.1
 * 17.09.96 - M.Wollborn: time writing modified with respect to VM3.1	
 *	21.01.97 Added bitstuffing by Luis.
 * 04.02.97 Noel O'Connor: mods for non unique VOl Ids 
 * 10.02.97 Fernando Jaureguizar: error corrected: GetVopIntraQuantizer()
 *          instead of GetVopQuantizer() in case of intra frame
 * 13.03.97 Minhua Zhou: Added B_VOPs
 * 21.04.97 Jan De Lameillieure : added writing of VOP_gray_quant to bit-stream
 * 07.05.97 Noel Brady: added writing of VOP_CR and change_CR_disable
 * 09.05.97 Minhua Zhou:  modified "modulo_time_base" and "VOP_time_increment"
 *          according to VM7.x 
 * 04.08.97 Minhua Zhou: added f_code in the VOP Layer 
 * 04.08.97 Minhua Zhou: added intra_dc_vlc_thr
 * 05.08.97 Minhua Zhou: added vop_coded
 * 06.08.97 Noel Brady: In BINARY_SHAPE_ONLY mode, several fields in 
 *				the VOP header are not sent.
 * 28.08.97 Osamu Sunohara: modified to calclate modulo_time_base in
 *          spatial scalability exactly. 
 * 08.09.97 Cecile Dufour: added the 3 last arguments for Static sprites
 * 27.03.98 M.Wollborn: Modifications due to N2171 Cl. 2.5.14
 * 21.05.98 Ji Heon Kweon (HYUNDAI) : support for grayscale coding
 * 08.06.98 Marc Mongenet (EPFL): added Complexity Estimation syntax support
 * 15.02.99 U. Benzler : added quarter pel support
 * 16.08.99 Shigeru Fukunaga (Oki): added modules for NEWPRED
 * 06.09.99 Eishi Morimatsu (Fujitsu Labs.): added DRC support
 *
 ***********************************************************CommentEnd********/
 
UInt
BitstreamPutVopHeader(Vop *vop,
		      Int vo_id,
		      Float time, Int TRB, /* TRB!=0<--> B_VOP*/
		      VolConfig *vol_config,
		      BitCount num_bits[MAX_NUM_VOS][MAX_NUM_VOLS],
		      VOConfig *vo_config_list, 
		      Int rc_type,
/*** 10/27 TPS */
                      Int modulo_tps)
/* 10/27 TPS ***/
{
  Image	*buffer;
  Int bits;
  Int	time_modulo,
        vol_id;
  Float time_inc;

  Int	index, n;
  
  UInt	num_bits_header=0;
  Float	brightness_factor;
  Int	piece_width, piece_height, piece_xoffset, piece_yoffset, tmp_val;
  
  Int	np_vop_id;  /** added for NEWPRED (Oki) 16-AUG-1999 **/

  /** added for NEWPRED (Oki) 16-AUG-1999 **/
  if(GetVopNewpredEnable(vop)){
    /* set vop_id for NEWPRED */
    np_vop_id = GetVopNewpredVopId(vop);
  }
  /** end of NEWPRED (Oki) 16-AUG-1999 **/

  /* Set up intermediate integer level data structure */
  buffer = BitstreamInit();
  
  /* 
   *
   * Write all syntax fields in vop header to data structure
   *
   */
  
   vol_id = GetVolConfigId(vol_config);
  
   BitstreamPutBits(buffer,VOP_START_CODE,VOP_START_CODE_LENGTH); 
   
   BitstreamPutBits(buffer,GetVopPredictionType(vop),2);

  /* Get last encoded modulo time base */
  
/* SONY 070498 - start */  
  /* 21.08.98 Sven Brandau: changed due to N2339, Clause 2.1.11
     from Takefumi Nagumo, eMail 16.08.98 */

  /*modified*/
  index = GetVolConfigModTimeBase(vol_config, 
	  ((GetVopPredictionType(vop)==B_VOP&&GetVopScalability(vop))||
	  (GetVopPredictionType(vop)!=B_VOP))?1:0);

/* SONY 070498 - end */

/* 280897 */

  time_modulo = time - index*1000;
  while(time_modulo >= 1000)
    {
      BitstreamPutBits(buffer,1,1);
      time_modulo = time_modulo - 1000;
      index++;
      printf("time modulo : 1\n");
    }
  BitstreamPutBits(buffer,0,1);
  
  /* Store this modulo time base */
  /*
  if(modulo_tps ==1) 
    PutVolConfigModTimeBase(index,vol_config);
  
  if (GetVopPredictionType(vop)!=B_VOP)
    PutVolConfigModTimeBase(index,vol_config);	
  */
  /* 21.08.98 Sven Brandau: changed due to N2339, Clause 2.1.11
     from Takefumi Nagumo, eMail 16.08.98 */
  if(modulo_tps ==1) 
    PutVolConfigModTimeBase(index,vol_config);
 /*modified*/
  if (GetVopPredictionType(vop)!=B_VOP ||
      (GetVopScalability(vop)))
    PutVolConfigModTimeBase(index,vol_config);

  time_inc = (time - index*1000);
  
  bits = ceil(log((double)GetVopTimeIncrementResolution(vop))/log(2.0));
  if (bits<1) bits=1;
  time_inc=time_inc*(double)GetVopTimeIncrementResolution(vop)/1000.0;
  
  /* marker bit */
  BitstreamPutBits(buffer,1,1);
  
  BitstreamPutBits(buffer,(Int)(time_inc+0.001),bits);
  
  /* marker bit */
  BitstreamPutBits(buffer,1,1);
  
  if (GetVopWidth(vop)==0) 
    {
      printf("Empty VOP at %.2f\n",time); /* MW 30-NOV-1998 */
      BitstreamPutBits(buffer,0L,1L);
      num_bits_header = BitstreamPut(buffer,vo_id,vol_id);
      num_bits_header +=NextStartCode(vo_id,vol_id); 
      BitstreamFree(buffer);
      return(num_bits_header);
    } 
  else 
    BitstreamPutBits(buffer,1L,1L);

  /** added for NEWPRED (Oki) 16-AUG-1999 **/
  if(GetVopNewpredEnable(vop)){
    /* insert additional syntax for NEWPRED */
    BitstreamPutNEWPRED(vol_config, vop, np_vop_id, 
			0, buffer, 1);
  }
  /** end of NEWPRED (Oki) 16-AUG-1999 **/

  if ( GetVolConfigShape(vol_config) != BINARY_SHAPE_ONLY)		/* BSO_NOEL */
    {  
      
      if( GetVopPredictionType(vop) == P_VOP ||
	  ( GetVolConfigSpriteUsage(vol_config) != STATIC_SPRITE &&
	    GetVopPredictionType(vop) == SPRITE_VOP))
        BitstreamPutBits(buffer,GetVopRoundingType(vop),1);

/* >>> added for DRC by Fujitsu (top)    <<< */
      if( ( GetVolConfigDrcEnable(vol_config) != 0 ) &&
          ( GetVopPredictionType(vop) == P_VOP ||
            GetVopPredictionType(vop) == I_VOP ) &&
          ( GetVolConfigShape(vol_config) == RECTANGULAR ) )
          BitstreamPutBits(buffer,GetVopReducedResolution(vop),1);
/* >>> added for DRC by Fujitsu (bottom) <<< */

    }		/* BSO_NOEL */

  if(GetVolConfigShape(vol_config) != RECTANGULAR)
    {
  if (!(GetVopSpriteUsage(vop)==STATIC_SPRITE&&
  			GetVopPredictionType(vop)==I_VOP))
     {
      BitstreamPutBits(buffer,GetVopWidth(vop),13);
        
      /* marker bit */
      BitstreamPutBits(buffer,1,1);
      
      BitstreamPutBits(buffer,GetVopHeight(vop),13);		
      
      /* marker bit */
      BitstreamPutBits(buffer,1,1);

      /* C. Dufour revised on 12/12/97 for low-latency sprite */      
      if ( GetVolConfigSpriteUsage(vol_config) == STATIC_SPRITE &&
	   GetVopPredictionType(vop) == I_VOP)
        {
	  tmp_val = GetVopHorSpatRef(vop) + 
	    GetVolConfigSpriteLeftEdge(vol_config);
	  if (tmp_val<0) tmp_val +=8192; 
	    BitstreamPutBits(buffer,tmp_val,13);
        }
      else
      /* end revision */
	{
              /* 16.11.98 - Sven Brandau:  "check even value for vop_horizontal_mc_spatial_ref"
                                                                       due to N2470b, Clause 2.1.34 */   
              if (GetVopHorSpatRef(vop)%2)
                fprintf(stderr, "vop_horizontal_mc_spatial_ref shall be divisible by 2\n");
	  BitstreamPutBits(buffer,GetVopHorSpatRef(vop),13);
	}

      /* marker bit */
      BitstreamPutBits(buffer,1,1);
      
      /* C. Dufour revised on 12/12/97 for low-latency sprite */      
      if ( GetVolConfigSpriteUsage(vol_config) == STATIC_SPRITE &&
	   GetVopPredictionType(vop) == I_VOP)
        {
	  tmp_val = GetVopVerSpatRef(vop) + 
	    GetVolConfigSpriteTopEdge(vol_config);
	  if (tmp_val<0) tmp_val +=8192; 
	    BitstreamPutBits(buffer,tmp_val,13);
        }
      else
      /* end revision */
	{      
              /* 16.11.98 - Sven Brandau:  "check even value for vop_vertical_mc_spatial_ref"
                                                                       due to N2470b, Clause 2.1.34 */
              if (GetVopInterlaced(vop) && (GetVopVerSpatRef(vop)%4))
                fprintf(stderr, "vop_horizontal_mc_spatial_ref shall be divisible by 4\n");
              else if (GetVopVerSpatRef(vop)%2)
                fprintf(stderr, "vop_horizontal_mc_spatial_ref shall be divisible by 2\n");
	  BitstreamPutBits(buffer,GetVopVerSpatRef(vop),13);
	}
      } /* Not (STATIC_SPRITE and I_VOP) */

      /* marker bit - Karsten Suehring */
      BitstreamPutBits(buffer,1,1);

    if (GetVolConfigShape(vol_config)!=BINARY_SHAPE_ONLY)	/* added for OBSS by Samsung AIT (1999-09-29) */
      if(GetVolConfigScalability(vol_config) && 
	 GetVolConfigEnhanceType(vol_config))
        /* for TPS */
        BitstreamPutBits(buffer, GetVopBackComp(vop), 1);
        /**/
      
      /* change_CR_disable */
      BitstreamPutBits(buffer,GetVopChangeCRDisable(vop),1);

      PutVopConstantAlpha(0,vop);
      BitstreamPutBits(buffer,GetVopConstantAlpha(vop),1);
      if (GetVopConstantAlpha(vop)) 
        BitstreamPutBits(buffer,GetVopConstantAlphaValue(vop),8);
    }


  /* Complexity Estimation syntax support - Marc Mongenet (EPFL) - 8 Jun 1998 */
  if (!GetVopComplexityEstimationDisable(vop))
    BitstreamPutDCECS(buffer, vop);


  if (GetVolConfigShape(vol_config) != BINARY_SHAPE_ONLY) /* BSO_NOEL */
    {  
      /*PutVopIntraDCVlcThr(0,vop);*/
      BitstreamPutBits(buffer,GetVopIntraDCVlcThr(vop),3);
      /* 12.08.98 Sven Brandau: "move interlace bit from VOP to VOL" due to N2339, Clause 2.1.9 */
      /*BitstreamPutBits(buffer, GetVopInterlaced(vop) , 1);*/
      if (GetVopInterlaced(vop)) 
	{
	  BitstreamPutBits(buffer, GetVopTopFieldFirst(vop),1);
	  BitstreamPutBits(buffer, GetVopAlternateScan(vop),1);
        }
    }

 
  /* SPRITE SPRITE SPRITE */
  if ((GetVolConfigSpriteUsage(vol_config)!= SPRITE_NOT_USED )
      &&(GetVopPredictionType(vop)==SPRITE_VOP) )
    {
      if (GetVolConfigNoOfSpritePoints(vol_config)) 
      	{
	  EncodeSpriteTraj(GetVopDiffTrajPointCoord(vop),buffer,
			   GetVolConfigNoOfSpritePoints(vol_config),
			   GetVolConfigSpriteUsage(vol_config));
      	}
      if (GetVolConfigBrightnessChangeInSprite(vol_config))
        brightness_factor = encode_brightness_change_factor (GetVopBrightnessChangeFactor(vop) ,buffer);
      else
        brightness_factor = 1;
      
      PutVopBrightnessChangeFactor(brightness_factor, vop);
      if (GetVolConfigSpriteUsage(vol_config) == STATIC_SPRITE)
	{
	  if (GetVolConfigSpriteTransmitMode(vol_config)!=STOP)
	    {
	      do
		{ 
		  FindNextSpritePieceCoord(vop,vol_config,
					   &piece_width, &piece_height,
					   &piece_xoffset, &piece_yoffset);

		  BitstreamPutBits(buffer,GetVolConfigSpriteTransmitMode(vol_config),2);
		  num_bits_header += BitstreamPut(buffer,vo_id,vol_id);
		  BitstreamFree(buffer);
		  buffer = BitstreamInit();
		
		  if (GetVolConfigSpriteTransmitMode(vol_config)==PIECE ||
		      GetVolConfigSpriteTransmitMode(vol_config)==UPDATE)
		    {
		      EncodeSpritePiece(vol_config,
					vo_id, vol_id,
					piece_width,
					piece_height,
					piece_xoffset,
					piece_yoffset,
					num_bits,
					vo_config_list,
					rc_type);
		      num_bits_header += num_bits[vo_id][vol_id].sprite_piece;
		    }
		} while (GetVolConfigSpriteTransmitMode(vol_config)!=STOP &&
			 GetVolConfigSpriteTransmitMode(vol_config)!=PAUSE);
	    }

	  num_bits_header += BitstreamPut(buffer,vo_id,vol_id);
	  /* No longer require the intermediate data structure */
	  BitstreamFree(buffer);
	  return(num_bits_header);
	}
    }
  
  if (GetVolConfigShape(vol_config) != BINARY_SHAPE_ONLY) /* BSO_NOEL */
    {
      if (GetVopPredictionType(vop) == I_VOP) 	/* I_VOP */
        BitstreamPutBits(buffer,GetVopIntraQuantizer(vop),GetVopQuantPrecision(vop));
      else  if (GetVopPredictionType(vop) == B_VOP)
        BitstreamPutBits(buffer,GetVopBQuantizer(vop),GetVopQuantPrecision(vop));
      else
        BitstreamPutBits(buffer,GetVopQuantizer(vop),GetVopQuantPrecision(vop));

      /* HYUNDAI (Grayscale) */
      if(GetVolConfigShape(vol_config) == GREY_SCALE) {
        for(n=0;n<GetVolConfigAuxCompCount(vol_config);n++) { /* MAC (SB) 11-Nov-99 */ 
          if (GetVopPredictionType(vop) == I_VOP) 	/* I_VOP */
            BitstreamPutBits(buffer,GetVopIntraGLQuantizer(n,vop),6);
          else  if (GetVopPredictionType(vop) == B_VOP)
            BitstreamPutBits(buffer,GetVopBGLQuantizer(n,vop),6);
          else
            BitstreamPutBits(buffer,GetVopGLQuantizer(n,vop),6);
        }
      }

      /* added by Minhua Zhou 04.08.97 */
      if (GetVopPredictionType(vop)!=I_VOP) {
       if (GetVopQuarterPel(vop))
        BitstreamPutBits(buffer,GetVopFCodeFor(vop)+1,3); /* UB 990215 added quarter pel support */
       else
        BitstreamPutBits(buffer,GetVopFCodeFor(vop),3);
      }
      if (GetVopPredictionType(vop)==B_VOP) {
       if (GetVopQuarterPel(vop))
        BitstreamPutBits(buffer,GetVopFCodeBack(vop)+1,3); /* UB 990215 added quarter pel support */
       else
        BitstreamPutBits(buffer,GetVopFCodeBack(vop),3);
      }
   
      if (!GetVopScalability(vop))
	{
	  /* Modified due to N2171 Cl. 2.5.14 MW 27-MAR-1998 */
	  /* if (!GetVopErrorResDisable(vop)) */
	  /*   { */
	  if (GetVopShape(vop) && (GetVopPredictionType(vop)!=I_VOP))
	    BitstreamPutBits(buffer,GetVopShapeCodingType(vop),1);
	  /*   } */
	}
   
      /* Background composition not implemented yet here (UPS)*/

      /*  WriteBGCAlphaBitstream in Enhance_vop used
	  if(( GetVopPredictionType(vop)== P_VOP  && GetVopRefSelCode(vop) ==3)
	       || ( GetVopPredictionType(vop)==B_VOP && GetVopRefSelCode(vop) ==0)) 
	    {
	    BitstreamPutBits(buffer,GetVopRefSelCode(vop),2);
	    if(GetVopPredictionType(vop)==P_VOP ||GetVopPredictionType(vop)==B_VOP)
	      {
	        BitstreamPutBits(buffer,GetVopForTempRef(vop),10);
		if(GetVopPredictionType(vop)==B_VOP)
		  {
		    BitstreamPutBits(buffer, 1, 1);
		    BitstreamPutBits(buffer,GetVopBackTempRef(vop),10);
		  }
	      }
	    }*//*end of ssp (UPS)*/
		  
    } /* BSO_NOEL */	      
  
  /*
   *
   * Write intermediate bitstream data structure to disk
   *
   */
  num_bits_header += BitstreamPut(buffer,vo_id,vol_id);
  
  /* No longer require the intermediate data structure */
  BitstreamFree(buffer);
  
  return(num_bits_header);
}

/***********************************************************CommentBegin******
 *
 * -- SetUpRecVop -- Sets up the reconstructed vop structure
 *
 * Author :		
 *	Noel O'Connor Teltec Irl.
 *
 * Created :		
 *	23-04-96
 *
 * Purpose :	
 * This function sets up a reconstructed vop structure in which the
 * result of coding a particular vop will be stored. The reconstructed
 * vop will have the same dimensions as the vop to be coded. The function
 * CloneVop() is called which returns an exact copy of the vop to
 * be coded (incl. image fields). The image fields of the reconstructed vop
 * are then initialised.	
 * 
 * Arguments in : 	
 *  Vop *vop - pointer to the vop to be coded which is the basis for
 *				setting up the reconstructed vop
 *
 * Arguments in/out :	
 *	-
 *
 * Arguments out :	
 *	-
 *
 * Return values :	
 *	Vop *rec_vop - pointer to the newly allocated and initialised 
 *					reconstructed vop
 *
 * Side effects :	
 *	Memory is allocated in this function for rec_vop
 *
 * Description :	
 *	-
 *
 * See also :
 *	-
 *
 * Modified :		
 *	21.01.97 Robert Danielsen: Set to 0 for chroma instead of 128.
 *          Fix by Noel/Paulo.
 *      21.05.98 Ji Heon Kweon (HYUNDAI) : support for grayscale coding
 *
 ***********************************************************CommentEnd********/

Vop *
SetUpRecVop(Vop *vop)
{
  Vop	*rec_vop;

  Image *y,
    *u,
    *v,
    *alpha;

  Int aux;


  /* Reconstructed current will be the same size as the
     bounded vop with the same vop information */
  rec_vop = CloneVop(vop);

  y = GetVopY(rec_vop);
  u = GetVopU(rec_vop);
  v = GetVopV(rec_vop);
  alpha = GetVopA(rec_vop);

  /* CloneVop() also copies image fields of input vop. For 
     reconstructed vop these should be initialised to zero for Y
     and 128 for U and V. */
  SetConstantImage(y,0);
  for(aux=0;aux<GetVopAuxCompCount(rec_vop);aux++)  	/* MAC (SB) 16-Nov-99 */
    SetConstantImage(GetVopG(aux,rec_vop),0);		/* HYUNDAI (Grayscale) */
  SetConstantImage(u,0);
  SetConstantImage(v,0);
  SetConstantImage(alpha,0);

  return(rec_vop);
}


/***********************************************************CommentBegin******
 *
 * -- WriteCodedVopToDisk -- Writes a coded vop to disk
 *
 * Author :		
 *	Noel O'Connor Teltec Irl.
 *
 * Created :		
 *	19-04-96
 *
 * Purpose :	
 *	This function takes as input a coded vop and writes it to disk.
 *	The coded vop is bounded. It is possible (indeed very likely) that the 
 * size of the bounding box will change during the course of coding an
 * entire sequence. Thus the vop to be written to disk is first "pasted"
 * into a newly allocated vop which has dimensions of disk_vop_width
 *	& disk_vop_height.The coded vop is pasted in at location 
 *	(hor_spat_ref,ver_spat_ref). In this way each frame in the disk
 *	sequence of coded vops is garaunteed to
 * be the same size. The coded vop is also masked by the coded
 *	alpha channel before it is written to disk. This is just so that
 *	the image on disk contains no padding data, just the active
 *	vop.
 * 
 * Arguments in : 	
 * Vop *vop - pointer to the bounded vop whcih is to be written to disk
 * Char *y_file - name of file containing coded Y image on disk
 * Char *u_file - name of file containing coded U image on disk
 * Char *v_file - name of file containing coded V image on disk
 *	Char *a_file - name of file containing coded Alpha image on disk
 *	Int time - time instant
 *	Int	disk_vop_width - X dimension of file to be written to disk
 *	Int disk_vop_height - Y dimension of file to be written to disk
 * Int write_alpha - Flag indication whether or not to write the alpha
 *		channel to disk
 * Int vop_has_content - Flag for empty VOPs.
 *
 * Arguments in/out :	
 *	-
 *
 * Arguments out :	
 *	-
 *
 * Return values :	
 *  -
 *
 * Side effects :	
 *  -
 *
 * Description :	
 *	-
 *
 * See also :
 *	-
 *
 * Modified :		
 *
 *	Put the two "pel_in++" out of the if-loop; bug reported
 *			by Kevin O'Connel on 26-JUN-1996 (M.Wollborn)
 *  	20-MAR-97 Jan De Lameillieure (HHI) : added shape argument
 *			to SubsampleAlphaMap()
 *      26.05.97 Minhua Zhou: removed SubsampleAlphaMap()
 *      21.05.98 Ji Heon Kweon (HYUNDAI) : support for grayscale coding
 *
 ***********************************************************CommentEnd********/
 
Void
WriteCodedVopToDisk(Vop *vop,
                    Char *y_file,
                    Char *u_file,
                    Char *v_file,
                    Char *a_file,
                    Char g_files[MAX_MAC][100],
                    Int time,
                    Int	disk_vop_width,
                    Int disk_vop_height,
                    Int shape,
                    Int vop_has_content)
{
  Vop	*disk_vop;
	
  Image *y_in,
	*u_in,
	*v_in,
	*a_in,
	*y_out,
	*u_out,
	*v_out,
	*a_out,
	*a_sub,
        *g_in,	/* HYUNDAI (Grayscale) */
        *g_out;
			
  Int	x,y,
        hor_ref, ver_ref,
	dim_x, dim_y,
	pel_in,
	pel_out,
	alpha_active=0,
        aux;
	
  SInt	*ptr_in_1,
	*ptr_in_2,
        *ptr_out_1,
	*ptr_out_2,
	*ptr_alp;
	
	
  /* Allocate memory for vop to be written to disk */ 
  disk_vop = AllocVop(disk_vop_width,disk_vop_height,GetVopAuxCompCount(vop));
  PutVopBitsPerPixel(GetVopBitsPerPixel(vop),disk_vop);
  
  if(vop_has_content)
  {
    /* Set up pointer to image structures */
    y_in = GetVopY(vop);
    u_in = GetVopU(vop);
    v_in = GetVopV(vop);
    a_in = GetVopA(vop);
    y_out = GetVopY(disk_vop);
    u_out = GetVopU(disk_vop);
    v_out = GetVopV(disk_vop);
    a_out = GetVopA(disk_vop);

    
    /* Get location at which to copy coded vop into disk_vop */
    hor_ref = GetVopHorSpatRef(vop);
    ver_ref = GetVopVerSpatRef(vop);
    
    /* Initialise U and V fields of disk vop to 128 */
    SetConstantImage(u_out,128);
    SetConstantImage(v_out,128);
    
    /* Get size of coded vop */
    dim_x = GetImageSizeX(y_in);
    dim_y = GetImageSizeY(y_in);
    
    /* Paste coded vop into vop to be written to disk at
       horizontal and vertical spatial reference.
       Mask the coded vop with the alpha map. */
    
    /* Y and Alpha first */
    ptr_in_1 = (SInt *)GetImageData(y_in);
    ptr_out_1 = (SInt *)GetImageData(y_out);

    ptr_in_2 = (SInt *)GetImageData(a_in);   
    ptr_out_2 = (SInt *)GetImageData(a_out);
    
    pel_in = 0;
    for(y=ver_ref;y<ver_ref + dim_y; y++)
      for(x=hor_ref;x<hor_ref + dim_x; x++)
      {
        if(ValidCoordinate(x,y,disk_vop_width,disk_vop_height))
        {
          if(ptr_in_2[pel_in])
          {
            pel_out = y * disk_vop_width + x;
            ptr_out_1[pel_out] = ptr_in_1[pel_in];
            ptr_out_2[pel_out] = ptr_in_2[pel_in];
          }
        }
        
        pel_in++; /* Put out of loop, MW 26-JUN-1996 */
      }


    /* MAC (SB) 16-Nov-99 */    
    for(aux=0;aux<GetVopAuxCompCount(vop);aux++) {
      
      g_in  = GetVopG(aux,vop);
      g_out = GetVopG(aux,disk_vop);

      ptr_in_1  = (SInt *)GetImageData(g_in);
      ptr_out_1 = (SInt *)GetImageData(g_out);
      ptr_in_2  = (SInt *)GetImageData(a_in);
    
      pel_in = 0;
      for(y=ver_ref;y<ver_ref + dim_y; y++) {
        for(x=hor_ref;x<hor_ref + dim_x; x++) {
          if(ValidCoordinate(x,y,disk_vop_width,disk_vop_height)) {
            pel_out = y * disk_vop_width + x;
            if(ptr_in_2[pel_in])
              ptr_out_1[pel_out] = ptr_in_1[pel_in];
          }
          pel_in++; /* Put out of loop, MW 26-JUN-1996 */
        }
      }
    }




    
    /* Subsample the alpha map so that it can be used to mask the
       coded U and V channels */
    a_sub = GetVopAuv(vop);
    
    /* U and Y next */
    ptr_in_1 = (SInt *)GetImageData(u_in);
    ptr_out_1 = (SInt *)GetImageData(u_out);
    ptr_in_2 = (SInt *)GetImageData(v_in);
    ptr_out_2 = (SInt *)GetImageData(v_out);

    ptr_alp = (SInt *)GetImageData(a_sub);
    
    pel_in = 0;
    for(y=(ver_ref/2);y<(ver_ref + dim_y)/2; y++)
      for(x=(hor_ref/2);x<(hor_ref + dim_x)/2; x++)
      {
        if(ValidCoordinate(x,y,disk_vop_width/2,disk_vop_height/2))
        {
          /* Mask the coded output with the (subsampled) coded
             alpha channel */
          if(ptr_alp[pel_in])
          {
            pel_out = y * (disk_vop_width/2) + x;
            ptr_out_1[pel_out] = ptr_in_1[pel_in];
            ptr_out_2[pel_out] = ptr_in_2[pel_in];
          }
        }
        pel_in++; /* Put out of loop, MW 26-JUN-1996 */
      }
    
    /* Write disk_vop to disk */
    if(shape == RECTANGULAR)
      alpha_active = FALSE;
    else
      alpha_active = TRUE;	
    
  }
  
  if(time == 0)
    WriteVopGeneric(disk_vop,
                    y_file,
                    u_file,
                    v_file,
                    a_file,
                    g_files,
                    GetVopAuxCompCount(vop),
                    time,
                    IO_FORMAT,
                    IO_OVERWRITE,
                    alpha_active);
  else
    WriteVopGeneric(disk_vop,
                    y_file,
                    u_file,
                    v_file,
                    a_file,
                    g_files,
                    GetVopAuxCompCount(vop),
                    time,
                    IO_FORMAT,
                    IO_APPEND,
                    alpha_active);

  
  /* Deallocate vop memory */
  FreeVop(disk_vop);
  
  /* Deallocate subampled alpha map */
  /* Only if VOP has content, MW 13-SEP-1996 */
  /* FreeImage(a_sub); */
  
  return;
}


/***********************************************************CommentBegin******
 *
 * -- cal_fcode -- 
 *
 * Author :		
 *	Minhua Zhou
 *
 * Created :		
 *	04.08.97
 *
 * Purpose : calculate f_code according to the given search range	
  * 
 * Arguments in : 	
 *      Int  sr    : search range
 *      Int quarter_pel : flag to indicate 1/4 pel MC support (starting with f_code==0 at sr 8 ;
 *                           this is _not_the tramsmitted f_code, it is only used to 'trick' the ME routines)
 *
 * Arguments in/out :	
 *	-
 *
 * Arguments out :	
 *	-
 *
 * Return values :	
 *   f_code
 *
 * Side effects :	
 *  -
 *
 * Description :	
 *	-
 *
 * See also :
 *	-
 *
 * Modified : 990215 U. Benzler : added quarter pel support		
 *
 *
 ***********************************************************CommentEnd********/

Int cal_fcode (Int sr, Int quarter_pel) {
 if ((quarter_pel ) && (sr<=8)) return 0;
  else if (sr<=16) return 1; 
   else if (sr<=32) return 2;
    else if (sr<=64) return 3;
     else if (sr<=128) return 4;
      else if (sr<=256) return 5;
        else if (sr<=512) return 6;
         else if ((sr<=1024) && (!quarter_pel)) return 7;
           else {
     fprintf(stdout, "ERROR in cal_search_range\n");
     return (-1);
   } 
}





/***********************************************************CommentBegin******
 *
 * -- BitstreamPutHEC -- Writes Header Extension Code (HEC) syntax
 *
 * Author :		
 *	Michael Wollborn
 *
 * Created :		
 *	27-MAR-1998
 *
 * Purpose :		
 * 
 * Arguments in : 	
 *      VolConfig * vol_config - pointer to the VOL configuration data
 *	Vop *curr              - pointer to the current VOP
 *      Float time             - current encoding time
 *
 * Arguments in/out :	
 *	Image *aux_bitstream   - intermediate bitstream for syntax
 *
 * Arguments out :	
 *	-
 *
 * Return values :	
 *	-
 *
 * Side effects :	
 *	-
 *
 * Description :	
 *
 * See also :
 *
 * Modified :	27.03.98 M. Wollborn: included intra_dc_vlc_thr 
 *			              due to N2171, Cl. 2.5.3
 *              15.02.99 U. Benzler : added quarter pel support
 *              03.03.99 Seishi TAKAMURA (NTT): added GMC coding
 *	        02.04.99 N. Yamaguchi: included shape info.
 *			              due to N2693
 *	        06.09.99 Eishi Morimatsu (Fujitsu Labs.): added DRC support
 *	
 ***********************************************************CommentEnd********/

Void BitstreamPutHEC(VolConfig *vol_config, Vop *curr, Float time, Image *aux_bitstream)
{
  Int           index,time_modulo;
  Int           bits;
  Float         time_inc;

  /*****
   *
   *    Write the header extension code to the bitstream
   *
   *****/
  index = GetVolConfigModTimeBase(vol_config,0);
  time_modulo = time - index*1000;
  while(time_modulo >= 1000)
    {
      BitstreamPutBits(aux_bitstream,1,1);
      time_modulo = time_modulo - 1000;
      index++;
    }
  BitstreamPutBits(aux_bitstream,0,1);
  
  time_inc = (time - index*1000);
  bits = ceil(log((double)GetVopTimeIncrementResolution(curr))/log(2.0));
  if (bits<1) 
    bits=1;
  time_inc=time_inc*(double)GetVopTimeIncrementResolution(curr)/1000.0;
  BitstreamPutBits(aux_bitstream,1,1); /* marker bit */
  BitstreamPutBits(aux_bitstream,(Int)(time_inc+0.001),bits);
  BitstreamPutBits(aux_bitstream,1,1); /* marker */
  BitstreamPutBits(aux_bitstream,GetVopPredictionType(curr),2);
  
  if (GetVopShape(curr) != RECTANGULAR)
    {
      /* change_CR_disable */
      BitstreamPutBits(aux_bitstream,GetVopChangeCRDisable(curr),1);
      if (GetVopPredictionType(curr)!=I_VOP
	  && GetVopShape(curr)!=BINARY_SHAPE_ONLY)
	BitstreamPutBits(aux_bitstream,GetVopShapeCodingType(curr),1);
    }
  if (GetVopShape(curr) != BINARY_SHAPE_ONLY)		
    {
      /* Added "intra_dc_vlc_thr" due to N2171 Cl. 2.5.3 MW 27-MAR-1998 */
      /*PutVopIntraDCVlcThr(0,curr);*/
      BitstreamPutBits(aux_bitstream,GetVopIntraDCVlcThr(curr),3);

/* modified by NTT for GMC coding : start */
      if ((GetVolConfigSpriteUsage(vol_config)!= SPRITE_NOT_USED )
	  &&(GetVopPredictionType(curr)==SPRITE_VOP) )
      {
	  if (GetVolConfigNoOfSpritePoints(vol_config)) {
	      EncodeSpriteTraj(GetVopDiffTrajPointCoord(curr),aux_bitstream,
			       GetVolConfigNoOfSpritePoints(vol_config),
			       GetVolConfigSpriteUsage(vol_config));
	  }
      }
 /* modified by NTT for GMC coding : end */

/* >>> added for DRC by Fujitsu (top)    <<< */
     if( ( GetVolConfigDrcEnable(vol_config) != 0 ) &&
         ( GetVopPredictionType(curr) == P_VOP ||
           GetVopPredictionType(curr) == I_VOP ) &&
         ( GetVolConfigShape(vol_config) == RECTANGULAR ) )
         BitstreamPutBits(aux_bitstream,GetVopReducedResolution(curr),1);
/* >>> added for DRC by Fujitsu (bottom) <<< */

      if (GetVopPredictionType(curr) != I_VOP) {
       if (GetVopQuarterPel(curr))
        BitstreamPutBits(aux_bitstream,GetVopFCodeFor(curr)+1,3); /* UB 990215 added quarter pel support */
       else
        BitstreamPutBits(aux_bitstream,GetVopFCodeFor(curr),3);
      }
      if (GetVopPredictionType(curr) == B_VOP) {
       if (GetVopQuarterPel(curr))
        BitstreamPutBits(aux_bitstream,GetVopFCodeBack(curr)+1,3); /* UB 990215 added quarter pel support */
       else
        BitstreamPutBits(aux_bitstream,GetVopFCodeBack(curr),3);
      }
    }

  return;
}

/***********************************************************CommentBegin******
 *
 * -- BitstreamPutShapeHEC -- Writes Header Extension Code (HEC) syntax
 *
 * Author :		
 *	Noboru Yamaguchi (TOSHIBA)
 *
 * Created :		
 *	02-APR-1999
 *
 * Purpose :		
 *      revised HEC for shape due to N2693
 * 
 * Arguments in : 	
 *      VolConfig * vol_config - pointer to the VOL configuration data
 *	Vop *vop              - pointer to the current VOP
 *
 * Arguments in/out :	
 *	Image *buffer         - intermediate bitstream for syntax
 *
 * Arguments out :	
 *	-
 *
 * Return values :	
 *	-
 *
 * Side effects :	
 *	-
 *
 * Description :	
 *
 * See also :
 *
 ***********************************************************CommentEnd********/

Void BitstreamPutShapeHEC(VolConfig *vol_config, Vop *vop, Image *buffer)
{

  Int tmp_val;

  /*****
   *
   *    Write the header extension code to the bitstream (Bounding Rect.)
   *
   *****/
  if (!(GetVopSpriteUsage(vop)==STATIC_SPRITE&&
	GetVopPredictionType(vop)==I_VOP))
    {
      BitstreamPutBits(buffer,GetVopWidth(vop),13);
      
      /* marker bit */
      BitstreamPutBits(buffer,1,1);
	  
      BitstreamPutBits(buffer,GetVopHeight(vop),13);		
	  
      /* marker bit */
      BitstreamPutBits(buffer,1,1);

      /* C. Dufour revised on 12/12/97 for low-latency sprite */      
      if ( GetVolConfigSpriteUsage(vol_config) == STATIC_SPRITE &&
	  GetVopPredictionType(vop) == I_VOP)
	{
	  tmp_val = GetVopHorSpatRef(vop) + 
	    GetVolConfigSpriteLeftEdge(vol_config);
	  if (tmp_val<0) tmp_val +=8192; 
	  BitstreamPutBits(buffer,tmp_val,13);
	}
      else
	/* end revision */
	{
	  /* 16.11.98 - Sven Brandau:  "check even value for vop_horizontal_mc_spatial_ref"
	     due to N2470b, Clause 2.1.34 */   
	  if (GetVopHorSpatRef(vop)%2)
	    fprintf(stderr, "vop_horizontal_mc_spatial_ref shall be divisible by 2\n");
	  BitstreamPutBits(buffer,GetVopHorSpatRef(vop),13);
	}
	  
      /* marker bit */
      BitstreamPutBits(buffer,1,1);
	  
      /* C. Dufour revised on 12/12/97 for low-latency sprite */      
      if ( GetVolConfigSpriteUsage(vol_config) == STATIC_SPRITE &&
	  GetVopPredictionType(vop) == I_VOP)
	{
	  tmp_val = GetVopVerSpatRef(vop) + 
	    GetVolConfigSpriteTopEdge(vol_config);
	  if (tmp_val<0) tmp_val +=8192; 
	  BitstreamPutBits(buffer,tmp_val,13);
	}
      else
	/* end revision */
	{      
	  /* 16.11.98 - Sven Brandau:  "check even value for vop_vertical_mc_spatial_ref"
	     due to N2470b, Clause 2.1.34 */
	  if (GetVopInterlaced(vop) && (GetVopVerSpatRef(vop)%4))
	    fprintf(stderr, "vop_horizontal_mc_spatial_ref shall be divisible by 4\n");
	  else if (GetVopVerSpatRef(vop)%2)
	    fprintf(stderr, "vop_horizontal_mc_spatial_ref shall be divisible by 2\n");
	  BitstreamPutBits(buffer,GetVopVerSpatRef(vop),13);
	}

      /* marker bit */
      BitstreamPutBits(buffer,1,1);
	  
    } /* Not (STATIC_SPRITE and I_VOP) */

  return;
}


/***********************************************************CommentBegin******
 *
 * -- BitstreamPutDCECS -- Writes read_VOP_complexity_estimation_header syntax
 *
 * Author :
 *	Marc Mongenet, Swiss Federal Institute of Technology, Lausanne
 *
 * Created :
 *	08-JUN-1998
 *
 * Purpose :
 *      VOP complexity estimation data are written in the bitstream.
 *      Data with value 0 are encoded as 1 to avoid Start Code emulation.
 *
 * Arguments in :
 *	Vop * vop        - pointer to the current VOP
 *
 * Arguments in/out :
 *	Image * buffer   - bitstream
 *
 * Arguments out :
 *
 * Return values :
 *
 * Side effects :
 *
 * Description :
 *      Decision to write or not DCECS data in the bitstream is based on the
 *      flag correponding to each DCECS data.
 *
 * See also :
 *
 * Modified :
 *      26.10.99 Massimo Ravasi (EPFL): added Complexity Estimation syntax support
 *                                      Update version 2
 *	
 ***********************************************************CommentEnd********/

Void BitstreamPutDCECS (Image * buffer,
			Vop * vop)
{

  if (GetVopPredictionType(vop) == I_VOP ||
      GetVopPredictionType(vop) == P_VOP ||
      GetVopPredictionType(vop) == B_VOP)
  {
    if (GetVopOpaque(vop))
      BitstreamPutBits(buffer, CodedDCECS(GetVopDCECSOpaque(vop), 8), 8);
    if (GetVopTransparent(vop))
      BitstreamPutBits(buffer, CodedDCECS(GetVopDCECSTransparent(vop), 8), 8);
    if (GetVopIntraCAE(vop))
      BitstreamPutBits(buffer, CodedDCECS(GetVopDCECSIntraCAE(vop), 8), 8);
    if (GetVopInterCAE(vop))
      BitstreamPutBits(buffer, CodedDCECS(GetVopDCECSInterCAE(vop), 8), 8);
    if (GetVopNoUpdate(vop))
      BitstreamPutBits(buffer, CodedDCECS(GetVopDCECSNoUpdate(vop), 8), 8);
    if (GetVopUpsampling(vop))
      BitstreamPutBits(buffer, CodedDCECS(GetVopDCECSUpsampling(vop), 8), 8);
  }

  if (GetVopIntraBlocks(vop))
    BitstreamPutBits(buffer, CodedDCECS(GetVopDCECSIntraBlocks(vop), 8), 8);
  if (GetVopNotCodedBlocks(vop))
    BitstreamPutBits(buffer, CodedDCECS(GetVopDCECSNotCodedBlocks(vop), 8), 8);
  if (GetVopDCTCoefs(vop))
    BitstreamPutBits(buffer, CodedDCECS(GetVopDCECSDCTCoefs(vop), 8), 8);
  if (GetVopDCTLines(vop))
    BitstreamPutBits(buffer, CodedDCECS(GetVopDCECSDCTLines(vop), 8), 8);
  if (GetVopVLCSymbols(vop))
    BitstreamPutBits(buffer, CodedDCECS(GetVopDCECSVLCSymbols(vop), 8), 8);
 if (GetVopVLCBits(vop))
    BitstreamPutBits(buffer, CodedDCECS(GetVopDCECSVLCBits(vop), 4), 4);

  if (GetVopPredictionType(vop) == P_VOP ||
      GetVopPredictionType(vop) == B_VOP ||
      (GetVopPredictionType(vop) == SPRITE_VOP  && GetVopSpriteUsage(vop) == STATIC_SPRITE) )
  {
    if (GetVopInterBlocks(vop))
      BitstreamPutBits(buffer, CodedDCECS(GetVopDCECSInterBlocks(vop), 8), 8);
    if (GetVopInter4vBlocks(vop))
      BitstreamPutBits(buffer, CodedDCECS(GetVopDCECSInter4vBlocks(vop), 8), 8);
    if (GetVopAPM(vop))
      BitstreamPutBits(buffer, CodedDCECS(GetVopDCECSAPM(vop), 8), 8);
    if (GetVopNPM(vop))
      BitstreamPutBits(buffer, CodedDCECS(GetVopDCECSNPM(vop), 8), 8);
    if (GetVopForwBackMCQ(vop))
      BitstreamPutBits(buffer, CodedDCECS(GetVopDCECSForwBackMCQ(vop), 8), 8);
    if (GetVopHalfpel2(vop))
      BitstreamPutBits(buffer, CodedDCECS(GetVopDCECSHalfpel2(vop), 8), 8);
    if (GetVopHalfpel4(vop))
      BitstreamPutBits(buffer, CodedDCECS(GetVopDCECSHalfpel4(vop), 8), 8);
  }

  if (GetVopPredictionType(vop) == B_VOP ||
      (GetVopPredictionType(vop) == SPRITE_VOP  && GetVopSpriteUsage(vop) == STATIC_SPRITE) )
  {
    if (GetVopInterpolateMCQ(vop))
      BitstreamPutBits(buffer, CodedDCECS(GetVopDCECSInterpolateMCQ(vop), 8), 8);
  }

	/* START: Complexity Estimation syntax support - Update version 2 - Massimo Ravasi (EPFL) - 26 Oct 1999 */
  if (GetVopPredictionType(vop) == I_VOP ||
      GetVopPredictionType(vop) == P_VOP ||
      GetVopPredictionType(vop) == B_VOP) {

    if (GetVopSadct(vop)) {
      BitstreamPutBits(buffer, CodedDCECS(GetVopDCECSSadct(vop), 8), 8);			
		}
	}

  if (GetVopPredictionType(vop) == P_VOP ||
      GetVopPredictionType(vop) == B_VOP ||
      (GetVopPredictionType(vop) == SPRITE_VOP && GetVopSpriteUsage(vop) == STATIC_SPRITE)) {

    if (GetVopQuarterpel(vop)) {
      BitstreamPutBits(buffer, CodedDCECS(GetVopDCECSQuarterpel(vop), 8), 8);			
		}
	}
  /* END: Complexity Estimation syntax support - Update Version 2 */
}


/***********************************************************CommentBegin******
 *
 * -- CodedDCECS -- Small function to help BitstreamPutDCECS function.
 *
 * Author :
 *	Marc Mongenet, Swiss Federal Institute of Technology, Lausanne
 *
 * Created :
 *	09-JUN-1998
 *
 * Purpose :
 *      Encode data with value 0 as 1 to avoid Start Code emulation
 *
 * Arguments in :
 *	Int original   - unencoded DCECS data
 *      Int nb_bits    - number of bits of the encoded data in bitstream
 *
 * Arguments in/out :
 *
 * Arguments out :
 *	Int            - encoded DCECS data
 *
 * Return values :
 *
 * Side effects :
 *
 * Description :
 *      Data with value 0 are returned as 1.
 *
 * See also :
 *	BitstreamPutDCECS()
 *
 ***********************************************************CommentEnd********/

Int CodedDCECS (Int original,
		UInt nb_bits)
{
  original &= (1 << nb_bits) - 1; /* mask first to get the value in the bitstream */
  if (original != 0)
    return original;
  else
    return 1;
}
