/*****************************************************************************
 *
 * This software module was originally developed by
 *
 *   J. Ignacio Ronda (UPM-GTI / ACTS-MoMuSys).
 *
 * and edited by
 *
 *   Angel Pacheco (UPM-GTI / ACTS-MoMuSys).
 *   Ulrike Pestel (TUH / ACTS-MoMuSys).
 *   Fernando Jaureguizar (UPM-GTI / ACTS-MoMuSys).
 *   Ferran  Marques (UPC / ACTS-MoMuSys).
 *   Cecile Dufour (LEP / ACTS-MoMuSys).
 *   Bob Eifrig (NextLevel Systems)
 *   Seishi TAKAMURA (NTT)
 *   Oki Electric Industry Co., Ltd. (contact: Shigeru Fukunaga)
 *   Fujitsu Laboratories Ltd. (contact: Eishi Morimatsu)
 *
 * in the course of development of the MPEG-4 Video (ISO/IEC 14496-2) standard.
 * This software module is an implementation of a part of one or more MPEG-4
 * Video (ISO/IEC 14496-2) tools as specified by the MPEG-4 Video (ISO/IEC
 * 14496-2) standard.
 *
 * ISO/IEC gives users of the MPEG-4 Video (ISO/IEC 14496-2) standard free
 * license to this software module or modifications thereof for use in hardware
 * or software products claiming conformance to the MPEG-4 Video (ISO/IEC
 * 14496-2) standard.
 *
 * Those intending to use this software module in hardware or software products
 * are advised that its use may infringe existing patents. The original
 * developer of this software module and his/her company, the subsequent
 * editors and their companies, and ISO/IEC have no liability for use of this
 * software module or modifications thereof in an implementation. Copyright is
 * not released for non MPEG-4 Video (ISO/IEC 14496-2) Standard conforming
 * products.
 *
 * ACTS-MoMuSys partners retain full right to use the code for his/her own
 * purpose, assign or donate the code to a third party and to inhibit third
 * parties from using the code for non MPEG-4 Video (ISO/IEC 14496-2) Standard
 * conforming products. This copyright notice must be included in all copies or
 * derivative works.
 *
 * Copyright (c) 1997
 *
 *****************************************************************************/

/***********************************************************HeaderBegin*******
 *
 * File:        mot_vop.c
 *
 * Author:      J. Ignacio Ronda / Angel Pacheco, UPM-GTI
 *
 * Created:     02.02.96
 *
 * Description: Compute the motion estimation over the data of a VOP
 *
 * Flags:       -D_DEBUG_MV_MOD_ : prints the resulting 16x16 / 8x8 motion
 *                                 vectors, and associated MB modes
 *              -D_DEBUG_TRANS_  : prints if a block/MB is transparent and
 *                                 his error
 *
 * Modified:
 *      21.04.96 Robert Danielsen: Reformatted. New headers.
 *      02.07.96 Fernando Jaureguizar: Reformatted.
 *      30.08.96 Fernando Jaureguizar: subsamp_alpha() modified to
 *               allow B_BOUNDARY block type and moved to mot_utils* files
 *      18.09.96 Fernando Jaureguizar: Now new B_TRANSP and MB_TRANSP defines
 *               are in mot_util.h. Their calls are modified.
 *      28.11.96 Ferran Marques: Integration of changes from (22.10.96)
 *      05.02.97 Angel Pacheco: deletion of the *pel_pos arrays (VM5.1)
 *               having the valid positions (padded pixels) in which
 *               the search for the motion vectors must be done (as VM4.x said).
 *      21.03.97 Cecile Dufour: added warp_param and padsprite for
 *               ONLINE_SPRITE add B_BOUNDARY and MB_BOUNDARY in mot_util.h
 *      14.05.97 Fernando Jaureguizar: new commentaries about new enlarged
 *               f_code range according to VM7.0
 *               Modification in MotionEstimatePicture() function to
 *               cope with enlarged f_code range.
 *      16.06.97 Angel Pacheco: unified the TRANSPARENT modes.
 *      01.08.97 Fernando Jaureguiza: canged the wrong name advanced
 *               by the correct one enable_8x8_mv.
 *      13.11.97 Fernando Jaureguizar: formating and new header.
 *      09.03.98 Fernando Jaureguizar: New formating. Deleted not used
 *               mode16 parameter in FullPelMotionEstMB()
 *      31.08.98 Guido Heising (HHI): non version 1 items removed 
 *      15.02.99 U. Benzler (University of Hannover) : added quarter pel support
 *	03.03.99 Seishi TAKAMURA (NTT): added GMC coding
 *	16.08.99 Shigeru Fukunaga (Oki): added modules for NEWPRED
 *	06.09.99 Eishi Morimatsu (Fujitsu Labs.): added DRC support
 *
 ***********************************************************HeaderEnd*********/

/************************    INCLUDE FILES    ********************************/

#include "mot_util.h"
#include "mot_est.h"

#include "GMC.h"	/* modified by NTT for GMC coding */
#include "newpred.h"	/** added for NEWPRED (Oki) 16-AUG-1999 **/

/***********************************************************CommentBegin******
 *
 * -- compute_Nb --
 *
 * Author :
 *      UPM-GTI - Angel Pacheco
 *
 * Created :
 *      24.4.96
 *
 * Purpose :
 *      compute the Nb (MBs pixels inside the shape) for all MBs
 *
 * Arguments in :
 *      SInt *alpha      alpha plane data
 *      Int  br_width    width of the alpha plane data
 *      Int  br_height   height  of the alpha plane data
 *	Int  reduced_resolution  vop reduced resolution flag for current vop
 *
 * Arguments in/out :
 *
 *
 * Arguments out :
 *      SInt *MB_Nb      subsampled alpha Nb's
 *
 * Return values :
 *      none
 *
 * Side effects :
 *
 *
 * Description :
 *      It does not allocate memory for the Nb array
 *
 * See also :
 *
 *
 * Modified :
 *
 *
 ***********************************************************CommentEnd********/

/* static */ Void	/* MW QPEL 07-JUL-1998 */
compute_Nb(
  SInt   *alpha,    /* <-- alpha plane data                */
  Int    br_width,  /* <-- width of the alpha plane data   */
  Int    br_height, /* <-- height  of the alpha plane data */
  SInt   *MB_Nb,     /* --> subsampled alpha Nb's           */
  Int    reduced_resolution /* >>> added for DRC by Fujitsu <<< */
  )
{
  Int   h, v;
  Int   aux_hor, aux_ver; /* >>> modified for DRC by Fujitsu <<< */
  Int   mb_size_variable; /* >>> added for DRC by Fujitsu <<< */

/* >>> added for DRC by Fujitsu (top)    <<< */
  if(reduced_resolution) 
    mb_size_variable = MB_SIZE * 2;
  else
    mb_size_variable = MB_SIZE;

  aux_hor=br_width/mb_size_variable;  /* width  in  Bs */
  aux_ver=br_height/mb_size_variable; /* height in  Bs */
/* >>> added for DRC by Fujitsu (bottom)    <<< */

  for (v=0;v<aux_ver;v++)
    for (h=0;h<aux_hor;h++)
      MB_Nb[v*aux_hor+h]=0;

  for (v=0;v<br_height;v++)
    for (h=0;h<br_width;h++)
      if (alpha[v*br_width+h]!=0)
        MB_Nb[(v/mb_size_variable)*aux_hor+(h/mb_size_variable)]++; /* >>> modified for DRC by Fujitsu <<< */

}

/***********************************************************CommentBegin******
 *
 * -- MotionEstimatePicture -- Computes MV's and predictor errors
 *
 * Author :
 *      UPM-GTI - J. Ignacio Ronda / Angel Pacheco
 *
 * Created :
 *
 *
 * Purpose :
 *      Computes MV's (8x8 and 16x16) and predictor errors for the whole
 *      vop.
 *
 * Arguments in :
 *      Vop   *curr_vop     Y current VOP: vop_width x vop_height
 *      SInt  *prev_rec     Previous reconstructed luma
 *      SInt  *alpha        quantized alpha plane of current picture
 *      SInt  *prev         Y padd with edge
 *      SInt  *prev_ipol    Y interpolated (from pi)
 *      Int   prev_x        absolute horizontal position of the previous vop
 *      Int   prev_y        absolute vertical position of the previous vop
 *      Int   vop_width     horizontal previous vop dimension
 *      Int   vop_height    vertical previous vop dimension
 *      Image *padsprite    padded online sprite
 *      Vop   *sprite
 *      Int   no_of_sprite_points
 *      Int   warpingaccuracy
 *      Int   offset_pad_x  change corrdinates from padsprite to vop
 *      Int   offset_pad_y
 *      Int   enable_8x8_mv 8x8 MV (=1) or only 16x16 MV (=0)
 *      Int   quarter pel   flag to indicate quarter pel MC
 *      Int   edge          edge arround the reference vop
 *      Int   f_code        MV search range 1/2 or 1/4 pel: 1=32,2=64,...,7=2048
 *      Int   br_x          absolute horizontal position of the current vop
 *      Int   br_y          absolute vertical   position of the current vop
 *      Int   br_width      current bounding rectangule width
 *      Int   br_height     current bounding rectangle height
 *      Int   ref_sel_code  ref_select code for Scalability (UPS)
 *
 * Arguments in/out :
 *
 *
 * Arguments out :
 *      Float *mv16_w      predicted horizontal 16x16 MV (if approp.)
 *      Float *mv16_h      predicted vertical 16x16 MV   (if approp.)
 *      Float *mv8_w       predicted horizontal 8x8 MV   (if approp.)
 *      Float *mv8_h       predicted vertical 8x8 MV     (if approp.)
 *      Float *mvF_w       predicted horizontal field MV (if approp.)
 *      Float *mvF_h       predicted vertical field MV   (if approp.)
 *      SInt  *mode16      mode of the preditect motion vector
 *      SInt  *alpha_sub   sumsampled alpha plane
 *
 * Return values :
 *      none
 *
 * Side effects :
 *
 *
 * Description :
 *
 *
 * See also :
 *
 *
 * Modified :
 *      05.02.97 Angel Pacheco: deletion of the *pel_pos arrays (VM5.1)
 *               having the valid positions (padded pixels) in which the
 *               search for the motion vectors must be done (as VM4.x said).
 *      14.05.97 Fernando Jaureguizar: Modification to cope with enlarged f_code
 *               range (VM7.0).
 *      17.07.97 Ulrike Pestel: for scalability
 *      01.01.97 Fernando Jaureguizar: No 1/2 pel accuracy for (0;0) FW MV
 *               in spatial scalability (SpSc)
 *      11.12.97 Bob Eifrig: Added interlaced video support
 *      15.02.99 U. Benzler : added quarter pel support and search range for FullPelMotionEstMB
 *	03.03.99 Seishi TAKAMURA (NTT): added GMC coding
 *	16.08.99 Shigeru Fukunaga (Oki): added modules for NEWPRED
 *	06.09.99 Eishi Morimatsu (Fujitsu Labs.): added DRC support
 *	28.11.99 Shigeru Fukunaga (Oki): modified modules for NEWPRED
 *
 ***********************************************************CommentEnd********/

Void
MotionEstimatePicture(
  Vop     *curr_vop,   /* <-- Current VOP                                  */
  SInt    *prev_rec,   /* <-- Previous reconstructed Y                     */
  SInt    *alpha,      /* <-- quantized alpha plane of current picture     */
  SInt    *prev,       /* <-- Original Y padd with edge                    */
  SInt    *prev_ipol,  /* <--  Y interpolated (from pi)                    */
  SInt    *prev_ipol_topfield, SInt *prev_ipol_botfield,  /* <--  Y interpolated for interlaced */ /* MW QPEL 07-JUL-1998 */
  Int     prev_x,      /* <-- absolute horiz. position of previous vop     */
  Int     prev_y,      /* <-- absolute verti. position of  previous vop    */
  Int     vop_width,   /* <-- horizontal previous vop dimension            */
  Int     vop_height,  /* <-- vertical previous vop dimension              */
  Int     enable_8x8_mv,/* <-- 8x8 MV (=1) or only 16x16 MV (=0)            */
  Int     quarter_pel, /* <-- quarter pel MC mode flag                     */	/* MW QPEL 07-JUL-1998 */
  Int     edge,        /* <-- edge arround the reference vop               */
  Int     f_code,      /* <-- MV search range 1/2 or 1/4 pel: 1=32,2=64,...,7=2048*/	/* MW QPEL 07-JUL-1998 */
  Int     br_x,        /* <-- absolute horiz. position of the current vop  */
  Int     br_y,        /* <-- absolute verti. position of the current vop  */
  Int     br_width,    /* <-- current bounding rectangule width            */
  Int     br_height,   /* <-- current bounding rectangle height            */
  Int     ref_sel_code,/* <-- ref_sel_code for scalability                 */
  Float   *mv16_w,     /* --> predicted horizontal 16x16 MV(if approp.)    */
  Float   *mv16_h,     /* --> predicted vertical 16x16 MV  (if approp.)    */
  Float   *mv8_w,      /* --> predicted horizontal 8x8 MV  (if approp.)    */
  Float   *mv8_h,      /* --> predicted vertical 8x8 MV    (if approp.)    */
  Float   *mvF_w,      /* --> predicted horizontal field MV  (if approp.)  */
  Float   *mvF_h,      /* --> predicted vertical field MV    (if approp.)  */
  SInt    *mode16,     /* --> mode of the preditect motion vector          */
  SInt    *alpha_sub,   /* --> sumsampled alpha plane                       */
  Vop	*prev_rec_vop	/* <-- Previous reconstructed vop    added NTT for GMC coding */
  )
{
  Int   i, j;
  SInt   curr_mb[MB_SIZE][MB_SIZE], /* MW 07-JUL-1998 */
        curr_mb_alpha[MB_SIZE][MB_SIZE];
  Int   sad8 = MV_MAX_ERROR,
        sad16;
  Int   imas_w,
        imas_h,
        Mode;
  Int   posmode,
        pos16,
        pos8;
  Int   min_error16,
        min_error8_0,
        min_error8_1,
        min_error8_2,
        min_error8_3;
  Int   min_errorF[4];
  SInt  *curr = (SInt *)GetImageData(GetVopY(curr_vop));
  Int   xoff, yoff;
  SInt  *MB_Nb; /* Nb's of each MB of the vop */
  /***************************************************************************
  array of flags, which contains for the MB and for each one of the 4 Blocks
  the following info sequentially:
    xm, 1 if the lower search (x axis) is completed (no 1/2 search can be done)
           0, do 1/2 search in the lower bound (x axis)
    xM, 1 if the upper search (x axis) is completed (no 1/2 search can be done)
           0, do 1/2 search in the upper bound (x axis)
    ym, 1 if the lower search (y axis) is completed (no 1/2 search can be done)
           0, do 1/2 search in the lower bound (y axis)
    yM, 1 if the upper search (y axis) is completed (no 1/2 search can be done)
           0, do 1/2 search in the upper bound (y axis)
  ***************************************************************************/
  SInt  *halfpelflags;
  Int   flag_static_sprite=0;
  Int	sadGMC = MV_MAX_ERROR;	/* modified by NTT for GMC coding */
  Int	QP=0, QP_count=0;  /* added by Y.Suzuki (28/03/99) */
  SInt	*QP_store, *prev_alpha_sub;  /* added by Y.Suzuki (28/03/99) */

  /** added for NEWPRED (Oki) 16-AUG-1999 **/
  Image *tmp_image;	/* reference image structure of NEWPRED semgent */
  Image *tmp_image_ipol;/* interpolated reference image structure of NEWPRED segment */
  SInt	*prev2;		/* reference image of NEWPRED segment */
  SInt	*prev_ipol2;	/* interpolated reference image of NEWPRED segment */
  Int	np_seg_id = 0;	/* NEWPRED segment ID */
  Int	segment_height;	/* height of NEWPRED segment (number of MB_line) */
  Int	segment_pos;	/* position of NEWPRED segment (number of MB_line) */
  Int	num_segments;	/* number of NEWPRED segments per VOP */
  Int	mba_segment[MAXNPSEG];/* MBA of each NEWPRED segment */
  /** end of NEWPRED (Oki) 16-AUG-1999 **/

/* >>> added for DRC by Fujitsu (top)    <<< */
  Int   mb_size_variable, b_size_variable;
  SInt  curr_mb_rr[MB_SIZE*2][MB_SIZE*2],
        curr_mb_alpha_rr[MB_SIZE*2][MB_SIZE*2];
  SInt  *curr_mb_ptr0, *curr_mb_ptr1, *curr_mb_ptr2, *curr_mb_ptr3,
        *curr_mb_alpha_ptr0, *curr_mb_alpha_ptr1, *curr_mb_alpha_ptr2, *curr_mb_alpha_ptr3;
  Int   mba_scale;
/* >>> added for DRC by Fujitsu (bottom)    <<< */

/* >>> added for DRC by Fujitsu (top)    <<< */
  if(GetVopReducedResolution(curr_vop)) {
    mb_size_variable = MB_SIZE * 2;		
    b_size_variable = B_SIZE * 2;
    curr_mb_ptr0 = &curr_mb_rr[0][0];		
    curr_mb_ptr1 = &curr_mb_rr[0][16];		
    curr_mb_ptr2 = &curr_mb_rr[16][0];		
    curr_mb_ptr3 = &curr_mb_rr[16][16];		
    curr_mb_alpha_ptr0 = &curr_mb_alpha_rr[0][0];		
    curr_mb_alpha_ptr1 = &curr_mb_alpha_rr[0][16];		
    curr_mb_alpha_ptr2 = &curr_mb_alpha_rr[16][0];		
    curr_mb_alpha_ptr3 = &curr_mb_alpha_rr[16][16];		
    sad8 = MV_MAX_ERROR*4;
    mba_scale = 4;
  } else {
    mb_size_variable = MB_SIZE;		
    b_size_variable = B_SIZE;
    curr_mb_ptr0 = &curr_mb[0][0];		
    curr_mb_ptr1 = &curr_mb[0][8];		
    curr_mb_ptr2 = &curr_mb[8][0];		
    curr_mb_ptr3 = &curr_mb[8][8];		
    curr_mb_alpha_ptr0 = &curr_mb_alpha[0][0];		
    curr_mb_alpha_ptr1 = &curr_mb_alpha[0][8];		
    curr_mb_alpha_ptr2 = &curr_mb_alpha[8][0];		
    curr_mb_alpha_ptr3 = &curr_mb_alpha[8][8];		
    mba_scale = 1;
  } 
/* >>> added for DRC by Fujitsu (bottom)    <<< */

  /** added for NEWPRED (Oki) 16-AUG-1999 **/
  if(GetVopNewpredEnable(curr_vop)){
    /* set number of NEWPRED segments and MBA */
    num_segments = GetVopNewpredNumVps(curr_vop);
    for(i = 0; i <= num_segments; i++)
      mba_segment[i] = GetVopNewpredMbaVp(curr_vop, i)/mba_scale; /* >>> modified for DRC by Fujitsu <<< */

    /* alloc memory for reference NEWPRED segment (padded size) */
    tmp_image = AllocImage(vop_width + 2*edge, vop_height + 2*edge, SHORT_TYPE);
    prev2 = (SInt*)((SInt*)GetImageData(tmp_image)
		    +(vop_width+2*edge)*edge+edge);
    /* alloc memory for interpolated reference NEWPRED segment (padded size) */
    tmp_image_ipol = AllocImage(2*(vop_width + 2*edge), 2*(vop_height + 2*edge), SHORT_TYPE);
    prev_ipol2 = (SInt*)((SInt*)GetImageData(tmp_image_ipol)
			 +2*(vop_width+2*edge)*2*edge+2*edge);
  }
  else{
    prev2 = prev;
    prev_ipol2 = prev_ipol;
  }
  /** end of NEWPRED (Oki) 16-AUG-1999 **/

  if ((f_code==0) && (!quarter_pel)) /* UB 990215 added quarter pel support */
    flag_static_sprite = 1;

  imas_w=br_width/mb_size_variable; /* >>> modified for DRC by Fujitsu <<< */
  imas_h=br_height/mb_size_variable; /* >>> modified for DRC by Fujitsu <<< */

  /* Do motion estimation and store result in array */

  /* MW QPEL 07-JUL-1998 */
  /* halfpelflags=(SInt*)malloc(5*4*sizeof(SInt)); */
  halfpelflags=(SInt*)malloc(9*4*sizeof(SInt));

  MB_Nb=(SInt*)malloc(imas_w*imas_h*sizeof(SInt));

/* >>> added for DRC by Fujitsu (top)    <<< */
  if(GetVopReducedResolution(curr_vop)) 
    subsamp_alpha_RR(alpha, br_width, br_height, 1 /* block-based */, alpha_sub);
  else
/* >>> added for DRC by Fujitsu (bottom)    <<< */
  subsamp_alpha(alpha, br_width, br_height, 1 /* block-based */, alpha_sub);
  compute_Nb(alpha, br_width, br_height, MB_Nb, GetVopReducedResolution(curr_vop)); /* >>> modified for DRC by Fujitsu <<< */

/* added by Y.Suzuki (28/03/99) */
  if (GetVopSpriteUsage(curr_vop) == GMC_SPRITE &&
	     GetVopPredictionType(curr_vop) == 3) {
	QP_store = (SInt *)GetImageData(GetVopQP(prev_rec_vop));
	prev_alpha_sub=(SInt *)malloc(vop_width/B_SIZE*vop_height/B_SIZE*sizeof(SInt));
        subsamp_alpha((SInt *)GetImageData(GetVopA(prev_rec_vop)), vop_width, vop_height, 
			1, prev_alpha_sub);
     for ( j=0; j< (vop_height/MB_SIZE); j++)
       for ( i=0; i< (vop_width/MB_SIZE); i++)
         if(!MB_TRANSP(prev_alpha_sub,vop_width/B_SIZE,i,j,MBM_TRANSPARENT))
	  {
		QP_count++;
		QP += (Int)QP_store[j*vop_width/MB_SIZE+i];
	  }
     QP = (Int)((Float)QP/QP_count + 0.5);
	free(prev_alpha_sub);
  }

  for ( j=0; j< (br_height/mb_size_variable); j++) /* >>> modified for DRC by Fujitsu <<< */
    for ( i=0; i< (br_width/mb_size_variable); i++) /* >>> modified for DRC by Fujitsu <<< */
      {
      /** added for NEWPRED (Oki) 16-AUG-1999 **/
      if(GetVopNewpredEnable(curr_vop)){
	/* interpolating recerence NEWPRED segment after padding */
	if(np_seg_id < num_segments){
	  if(j * (br_width/mb_size_variable) + i == mba_segment[np_seg_id]){ /* >>> modified for DRC by Fujitsu <<< */
	    segment_pos = (Int)(mba_segment[np_seg_id]/(br_width/mb_size_variable)); /* >>> modified for DRC by Fujitsu <<< *//** modified for NEWPRED (Oki) 28-NOV-1999 **/
	    segment_height = (Int)((mba_segment[np_seg_id+1] - mba_segment[np_seg_id])/(br_width/mb_size_variable)); /* >>> modified for DRC by Fujitsu <<< */

	    /* padding NEWPRED segment */
	    PadNPSeg(prev, 	        /* top left pointer of reference frame */
		     prev2,	        /* top left pointer of reference NEWPRED segment */
		     vop_width,         /* Vop width */
		     vop_height,        /* Vop height */
		     edge,	        /* padding size */
		     segment_pos,	/* position of NEWPRED segment */
		     segment_height,	/* height of NEWPRED segment */
		     mba_segment,       /* MBA */         /** added for NEWPRED (Oki) 28-NOV-1999 **/
		     np_seg_id,         /* segment No. */ /** added for NEWPRED (Oki) 28-NOV-1999 **/
		     mb_size_variable); /* MB size */ /* >>> modified for DRC by Fujitsu <<< */

	    /* interpolating NEWPRED segment */
	    InterpolateSInt(prev_ipol2 - (2*(vop_width+2*edge)*2*edge+2*edge),
			    prev2 - ((vop_width+2*edge)*edge+edge), 
			    vop_width + 2*edge,
			    vop_height + 2*edge,
			    GetVopRoundingType(curr_vop));

	    np_seg_id++;		/* NEWPRED segment ID increment */
	  }
	}
      }
      /** end of NEWPRED (Oki) 16-AUG-1999 **/

      /* Integer pel search */

      posmode =          j * imas_w +   i;
      pos16   = pos8 = 2*j*2*imas_w + 2*i;

      if(!MB_TRANSP(alpha_sub,br_width/b_size_variable,i,j,MBM_TRANSPARENT)) /* >>> modified for DRC by Fujitsu <<< */
        {
        Mode = FullPelMotionEstMB(
             curr_vop, alpha, 
	     prev2,	/** modified for NEWPRED (Oki) 16-AUG-1999 **/
	     alpha_sub, br_x, br_y,
             br_width, br_height, i, j, prev_x, prev_y, vop_width, vop_height,
             enable_8x8_mv, edge, f_code, GetVopSearchRangeFor(curr_vop), MB_Nb, ref_sel_code, /* UB 990215 added search range */
             mv16_w, mv16_h, mv8_w, mv8_h, mvF_w, mvF_h, halfpelflags);

#ifdef _DRC_DEBUG_
  printf("mode = %d\n",Mode); 
  printf("  pos16 =%d, mode = %d, x=%4.1f, y=%4.1f, SAD=%d\n, ",pos16, Mode, mv16_w[pos16], mv16_h[pos16], min_error16);
#endif
        /* Half/Quarter pel search */	/* MW QPEL 07-JUL-1998 */

        /* 0==MBM_INTRA,1==MBM_INTER16||MBM_INTER8||MODE_SPRITE */
        /* f_code=0 corresponds to STATIC SPRITE */
        if ( Mode != 0)
          {
          if (ref_sel_code!=3) /*SpSc*/
            {
/* >>> added for DRC by Fujitsu (top)    <<< */
            if(GetVopReducedResolution(curr_vop)) { 
              FindMB_RR( i*mb_size_variable, j*mb_size_variable, br_width, curr,  curr_mb_rr);
              FindMB_RR( i*mb_size_variable, j*mb_size_variable, br_width, alpha, curr_mb_alpha_rr);
              FindSubPel (i*mb_size_variable,j*mb_size_variable, 2 /* MW QPEL 07-JUL-1998 */, 
		  	   prev_ipol2,	/** modified for NEWPRED (Oki) 16-AUG-1999 **/
                           curr_mb_ptr0, curr_mb_alpha_ptr0, 32, 32 /* MW QPEL 07-JUL-1998 */, 0,
                           br_x-prev_x,br_y-prev_y,vop_width, vop_height,
                           edge, halfpelflags, MB_Nb[posmode],
                           &mv16_w[pos16], &mv16_h[pos16], &min_error16,
                           flag_static_sprite, GetVopRoundingType(curr_vop), GetVopBrightWhite(curr_vop) /* MW QPEL 07-JUL-1998 */, GetVopReducedResolution(curr_vop)/* >>> added for DRC by Fujitsu <<< */ );
	    } else {
/* >>> added for DRC by Fujitsu (bottom)    <<< */
            FindMB( i*MB_SIZE, j*MB_SIZE, br_width, curr,  curr_mb);
            FindMB( i*MB_SIZE, j*MB_SIZE, br_width, alpha, curr_mb_alpha);
            FindSubPel (i*MB_SIZE,j*MB_SIZE, 2 /* MW QPEL 07-JUL-1998 */, 
			 prev_ipol2,	/** modified for NEWPRED (Oki) 16-AUG-1999 **/
                         &curr_mb[0][0], &curr_mb_alpha[0][0], 16, 16 /* MW QPEL 07-JUL-1998 */, 0,
                         br_x-prev_x,br_y-prev_y,vop_width, vop_height,
                         edge, halfpelflags, MB_Nb[posmode],
                         &mv16_w[pos16], &mv16_h[pos16], &min_error16,
                         flag_static_sprite, GetVopRoundingType(curr_vop), GetVopBrightWhite(curr_vop) /* MW QPEL 07-JUL-1998 */, GetVopReducedResolution(curr_vop)/* >>> added for DRC by Fujitsu <<< */);
/* >>> added for DRC by Fujitsu (top)    <<< */
	    } 
/* >>> added for DRC by Fujitsu (bottom)    <<< */

	    /* MW QPEL 07-JUL-1998 >> */
            if (quarter_pel) FindSubPel (i*MB_SIZE,j*MB_SIZE, 4, prev_rec,
                         &curr_mb[0][0], &curr_mb_alpha[0][0], 16,16, 0,
                         br_x-prev_x,br_y-prev_y,vop_width, vop_height,
                         edge, halfpelflags, MB_Nb[posmode],
                         &mv16_w[pos16], &mv16_h[pos16], &min_error16,
                         flag_static_sprite, GetVopRoundingType(curr_vop), GetVopBrightWhite(curr_vop),0) ;/* >>> modified for DRC by Fujitsu <<< */
	    /* << MW QPEL 07-JUL-1998 */ 

            /* sad16(0,0) already decreased by Nb/2+1 in FindHalfPel() */
            sad16 = min_error16;
            mode16[posmode] = MBM_INTER16;

            if (curr_vop->interlaced)
              {
              /* Do field halfpel refinement */

              xoff = i*MB_SIZE + br_x - prev_x;
              yoff = j*MB_SIZE + br_y - prev_y;

              /* cur=Top, ref=Top */
	      if (quarter_pel) { 		/* MW QPEL 07-JUL-1998 */
		FindSubPel (i*MB_SIZE,j*MB_SIZE, 2, prev_ipol_topfield,
			    &curr_mb[0][0], &curr_mb_alpha[0][0], 16,8, 0,
			    br_x-prev_x,br_y-prev_y,vop_width, vop_height,
			    edge, &halfpelflags[20], MB_Nb[posmode],
			    &mvF_w[pos16], &mvF_h[pos16], &min_errorF[0],
			    flag_static_sprite, GetVopRoundingType(curr_vop), GetVopBrightWhite(curr_vop),0); /* >>> modified for DRC by Fujitsu <<< */
		FindSubPel (i*MB_SIZE,j*MB_SIZE, 4, prev_rec,
			    &curr_mb[0][0], &curr_mb_alpha[0][0], 16,8, 0,
			    br_x-prev_x,br_y-prev_y,vop_width, vop_height,
			    edge, &halfpelflags[20], MB_Nb[posmode],
			    &mvF_w[pos16], &mvF_h[pos16], &min_errorF[0],
			    flag_static_sprite, GetVopRoundingType(curr_vop), GetVopBrightWhite(curr_vop),0) ; /* >>> modified for DRC by Fujitsu <<< */
	      } /* << MW QPEL 07-JUL-1998 */
	      else {
		FindHalfPelField(xoff, yoff, prev_rec,
				 &curr_mb[0][0], &curr_mb_alpha[0][0],
				 vop_width, vop_height, edge,
				 &mvF_w[pos16], &mvF_h[pos16], &min_errorF[0]);
	      }

              /* cur=Top, ref=Bot */
	      if (quarter_pel) { 		/* MW QPEL 07-JUL-1998 */
		FindSubPel (i*MB_SIZE,j*MB_SIZE, 2, prev_ipol_botfield,
			    &curr_mb[0][0], &curr_mb_alpha[0][0], 16,8, 0,
			    br_x-prev_x,br_y-prev_y,vop_width, vop_height,
			    edge, &halfpelflags[24], MB_Nb[posmode],
			    &mvF_w[pos16+1], &mvF_h[pos16+1], &min_errorF[1],
			    flag_static_sprite, GetVopRoundingType(curr_vop), GetVopBrightWhite(curr_vop),0); /* >>> modified for DRC by Fujitsu <<< */
		FindSubPel (i*MB_SIZE,j*MB_SIZE, 4, &prev_rec[vop_width + 2*edge],
			    &curr_mb[0][0], &curr_mb_alpha[0][0], 16,8, 0,
			    br_x-prev_x,br_y-prev_y,vop_width, vop_height,
			    edge, &halfpelflags[24], MB_Nb[posmode],
			    &mvF_w[pos16+1], &mvF_h[pos16+1], &min_errorF[1],
			    flag_static_sprite, GetVopRoundingType(curr_vop), GetVopBrightWhite(curr_vop),0) ; /* >>> modified for DRC by Fujitsu <<< */
	      } /* << MW QPEL 07-JUL-1998 */
	      else {
		FindHalfPelField(xoff, yoff, &prev_rec[vop_width + 2*edge],
				 &curr_mb[0][0], &curr_mb_alpha[0][0],
				 vop_width, vop_height, edge,
				 &mvF_w[pos16+1], &mvF_h[pos16+1], &min_errorF[1]);
	      }
              pos16 += 2*imas_w;

              /* cur=Bot, ref=Top */
	      if (quarter_pel) { 		/* MW QPEL 07-JUL-1998 */
		FindSubPel (i*MB_SIZE,j*MB_SIZE, 2, prev_ipol_topfield,
			    &curr_mb[1][0], &curr_mb_alpha[1][0], 16,8, 0,
			    br_x-prev_x,br_y-prev_y,vop_width, vop_height,
			    edge, &halfpelflags[28], MB_Nb[posmode],
			    &mvF_w[pos16], &mvF_h[pos16], &min_errorF[2],
			    flag_static_sprite, GetVopRoundingType(curr_vop), GetVopBrightWhite(curr_vop),0); /* >>> modified for DRC by Fujitsu <<< */
		FindSubPel (i*MB_SIZE,j*MB_SIZE, 4, prev_rec,
			    &curr_mb[1][0], &curr_mb_alpha[1][0], 16,8, 0,
			    br_x-prev_x,br_y-prev_y,vop_width, vop_height,
			    edge, &halfpelflags[28], MB_Nb[posmode],
			    &mvF_w[pos16], &mvF_h[pos16], &min_errorF[2],
			    flag_static_sprite, GetVopRoundingType(curr_vop), GetVopBrightWhite(curr_vop),0) ; /* >>> modified for DRC by Fujitsu <<< */
	      } /* << MW QPEL 07-JUL-1998 */
	      else {
		FindHalfPelField(xoff, yoff, prev_rec,
				 &curr_mb[1][0], &curr_mb_alpha[1][0],
				 vop_width, vop_height, edge,
				 &mvF_w[pos16], &mvF_h[pos16], &min_errorF[2]);
	      }

              /* cur=Bot, ref=Bot */
	      if (quarter_pel) { 		/* MW QPEL 07-JUL-1998 */
		FindSubPel (i*MB_SIZE,j*MB_SIZE, 2, prev_ipol_botfield,
			    &curr_mb[1][0], &curr_mb_alpha[1][0], 16,8, 0,
			    br_x-prev_x,br_y-prev_y,vop_width, vop_height,
			    edge, &halfpelflags[32], MB_Nb[posmode],
			    &mvF_w[pos16+1], &mvF_h[pos16+1], &min_errorF[3],
			    flag_static_sprite, GetVopRoundingType(curr_vop), GetVopBrightWhite(curr_vop),0); /* >>> modified for DRC by Fujitsu <<< */
		FindSubPel (i*MB_SIZE,j*MB_SIZE, 4, &prev_rec[vop_width + 2*edge],
			    &curr_mb[1][0], &curr_mb_alpha[1][0], 16,8, 0,
			    br_x-prev_x,br_y-prev_y,vop_width, vop_height,
			    edge, &halfpelflags[32], MB_Nb[posmode],
			    &mvF_w[pos16+1], &mvF_h[pos16+1], &min_errorF[3],
			    flag_static_sprite, GetVopRoundingType(curr_vop), GetVopBrightWhite(curr_vop),0) ; /* >>> modified for DRC by Fujitsu <<< */
	      } /* << MW QPEL 07-JUL-1998 */ 
	      else {
		FindHalfPelField(xoff, yoff, &prev_rec[vop_width + 2*edge],
				 &curr_mb[1][0], &curr_mb_alpha[1][0],
				 vop_width, vop_height, edge,
				 &mvF_w[pos16+1], &mvF_h[pos16+1],&min_errorF[3]);
	      }
              pos16 -= 2*imas_w;

              /* determine the best field MC mode */
              if (min_errorF[0] <= min_errorF[1])
                {
                sad16 = min_errorF[0];
                if (min_errorF[3] <= min_errorF[2])
                  {
                  sad16 += min_errorF[3];
                  Mode = MBM_FIELD01;
                  }
                else
                  {
                  sad16 += min_errorF[2];
                  Mode = MBM_FIELD00;
                  }
                }
              else
                {
                sad16 = min_errorF[1];
                if (min_errorF[3] <= min_errorF[2])
                  {
                  sad16 += min_errorF[3];
                  Mode = MBM_FIELD11;
                  }
                else
                  {
                  sad16 += min_errorF[2];
                  Mode = MBM_FIELD10;
                  }
                }
              sad16 += MB_Nb[posmode]/4 + 1;        /* Bias against field */
              if (min_error16 <= sad16)
                sad16 = min_error16;
              else
                mode16[posmode] = Mode;
              } /* interlaced */

	    /* modified by NTT for GMC coding :start */
            if (GetVopSpriteUsage(curr_vop)) {
		sadGMC = calcSAD_GME(curr, alpha, prev_rec_vop, curr_vop, br_width,
				     i*MB_SIZE, j*MB_SIZE);
		sadGMC -= (MB_Nb[posmode]/2 + 1);
	    }
	    /* modified by NTT for GMC coding :end */

            if (enable_8x8_mv)
              {
              /* fprintf(stderr,"enable_8x8_mv\n"); */
              if (!B_TRANSP(alpha_sub,br_width/b_size_variable,i,j,0,0,MBM_TRANSPARENT)) /* >>> modified for DRC by Fujitsu <<< */
		{
/* >>> added for DRC by Fujitsu (top)    <<< */
                  if(GetVopReducedResolution(curr_vop)) { 
		    FindSubPel(i*mb_size_variable, j*mb_size_variable, 2 /* MW QPEL 07-JUL-1998 */, 
			       prev_ipol2,	/** modified for NEWPRED (Oki) 16-AUG-1999 **/
			       curr_mb_ptr0, curr_mb_alpha_ptr0, 16, 16 /* MW QPEL 07-JUL-1998 */, 0,
			       br_x-prev_x,br_y-prev_y, vop_width, vop_height,
			       edge, halfpelflags, 0, &mv8_w[pos8], &mv8_h[pos8],
			       &min_error8_0, flag_static_sprite, GetVopRoundingType(curr_vop), GetVopBrightWhite(curr_vop) /* MW QPEL 07-JUL-1998 */, GetVopReducedResolution(curr_vop)/* >>> modified for DRC by Fujitsu <<< */);
	          } else {
/* >>> added for DRC by Fujitsu (bottom)    <<< */
		  FindSubPel(i*MB_SIZE, j*MB_SIZE, 2 /* MW QPEL 07-JUL-1998 */, 
			     prev_ipol2,	/** modified for NEWPRED (Oki) 16-AUG-1999 **/
			     &curr_mb[0][0], &curr_mb_alpha[0][0], 8, 8 /* MW QPEL 07-JUL-1998 */, 0,
			     br_x-prev_x,br_y-prev_y, vop_width, vop_height,
			     edge, halfpelflags, 0, &mv8_w[pos8], &mv8_h[pos8],
			     &min_error8_0, flag_static_sprite, GetVopRoundingType(curr_vop), GetVopBrightWhite(curr_vop) /* MW QPEL 07-JUL-1998 */,GetVopReducedResolution(curr_vop)/* >>> modified for DRC by Fujitsu <<< */);
		  
		  /* MW QPEL 07-JUL-1998 >> */
		  if (quarter_pel) FindSubPel(i*MB_SIZE, j*MB_SIZE, 4, prev_rec,
					      &curr_mb[0][0], &curr_mb_alpha[0][0], 8,8, 0,
					      br_x-prev_x,br_y-prev_y, vop_width, vop_height,
					      edge, halfpelflags, 0, &mv8_w[pos8], &mv8_h[pos8],
					      &min_error8_0,flag_static_sprite, GetVopRoundingType(curr_vop), GetVopBrightWhite(curr_vop),0); /* >>> modified for DRC by Fujitsu <<< */
		  /* << MW QPEL 07-JUL-1998 */
/* >>> added for DRC by Fujitsu (top)    <<< */
	          } 
/* >>> added for DRC by Fujitsu (bottom)    <<< */
		}
              else
                {
                /* default value for transparent blocks */
                mv8_w[pos8]=mv8_h[pos8]=0.0;
                min_error8_0=0;
                }

              if (!B_TRANSP(alpha_sub,br_width/b_size_variable,i,j,1,0,MBM_TRANSPARENT)) /* >>> modified for DRC by Fujitsu <<< */
		{
/* >>> added for DRC by Fujitsu (top)    <<< */
                  if(GetVopReducedResolution(curr_vop)) { 
		    FindSubPel(i*mb_size_variable, j*mb_size_variable, 2 /* MW QPEL 07-JUL-1998 */, 
			       prev_ipol2,	/** modified for NEWPRED (Oki) 16-AUG-1999 **/
			       curr_mb_ptr1, curr_mb_alpha_ptr1, 16, 16 /* MW QPEL 07-JUL-1998 */, 1,
			       br_x-prev_x,br_y-prev_y, vop_width, vop_height,
			       edge, halfpelflags, 0, &mv8_w[pos8+1], &mv8_h[pos8+1],
			       &min_error8_1, flag_static_sprite, GetVopRoundingType(curr_vop), GetVopBrightWhite(curr_vop) /* MW QPEL 07-JUL-1998 */,GetVopReducedResolution(curr_vop)/* >>> modified for DRC by Fujitsu <<< */);
	          } else {
/* >>> added for DRC by Fujitsu (bottom)    <<< */
		  FindSubPel(i*MB_SIZE, j*MB_SIZE, 2 /* MW QPEL 07-JUL-1998 */, 
			     prev_ipol2,	/** modified for NEWPRED (Oki) 16-AUG-1999 **/
			     &curr_mb[0][8], &curr_mb_alpha[0][8], 8, 8 /* MW QPEL 07-JUL-1998 */, 1,
			     br_x-prev_x,br_y-prev_y, vop_width,vop_height,
			     edge, halfpelflags,0,&mv8_w[pos8+1], &mv8_h[pos8+1],
			     &min_error8_1, flag_static_sprite, GetVopRoundingType(curr_vop), GetVopBrightWhite(curr_vop) /* MW QPEL 07-JUL-1998 */,GetVopReducedResolution(curr_vop)/* >>> modified for DRC by Fujitsu <<< */);
		  
		  /* MW QPEL 07-JUL-1998 >> */
		  if (quarter_pel) FindSubPel(i*MB_SIZE, j*MB_SIZE, 4, prev_rec,
					      &curr_mb[0][8], &curr_mb_alpha[0][8], 8,8, 1,
					      br_x-prev_x,br_y-prev_y, vop_width,vop_height,
					      edge, halfpelflags, 0, &mv8_w[pos8+1], &mv8_h[pos8+1],
					      &min_error8_1,flag_static_sprite, GetVopRoundingType(curr_vop), GetVopBrightWhite(curr_vop),0); /* >>> modified for DRC by Fujitsu <<< */
		  /* << MW QPEL 07-JUL-1998 */
/* >>> added for DRC by Fujitsu (top)    <<< */
	          } 
/* >>> added for DRC by Fujitsu (bottom)    <<< */
		}
              else
                {
                /* default value for transparent blocks */
                mv8_w[pos8+1]=mv8_h[pos8+1]=0.0;
                min_error8_1=0;
                }

              pos8+=2*imas_w;
              if (!B_TRANSP(alpha_sub,br_width/b_size_variable,i,j,0,1,MBM_TRANSPARENT)) /* >>> modified for DRC by Fujitsu <<< */
		{
/* >>> added for DRC by Fujitsu (top)    <<< */
                  if(GetVopReducedResolution(curr_vop)) { 
		    FindSubPel(i*mb_size_variable, j*mb_size_variable, 2 /* MW QPEL 07-JUL-1998 */, 
			       prev_ipol2,	/** modified for NEWPRED (Oki) 16-AUG-1999 **/
			       curr_mb_ptr2, curr_mb_alpha_ptr2, 16, 16 /* MW QPEL 07-JUL-1998 */, 2,
			       br_x-prev_x,br_y-prev_y, vop_width, vop_height,
			       edge, halfpelflags, 0, &mv8_w[pos8], &mv8_h[pos8],
			       &min_error8_2, flag_static_sprite, GetVopRoundingType(curr_vop), GetVopBrightWhite(curr_vop) /* MW QPEL 07-JUL-1998 */,GetVopReducedResolution(curr_vop)/* >>> modified for DRC by Fujitsu <<< */);
	          } else {
/* >>> added for DRC by Fujitsu (bottom)    <<< */
		  FindSubPel(i*MB_SIZE, j*MB_SIZE, 2 /* MW QPEL 07-JUL-1998 */, 
			     prev_ipol2,	/** modified for NEWPRED (Oki) 16-AUG-1999 **/
			     &curr_mb[8][0], &curr_mb_alpha[8][0], 8, 8 /* MW QPEL 07-JUL-1998 */, 2,
			     br_x-prev_x,br_y-prev_y, vop_width,vop_height,
			     edge, halfpelflags, 0, &mv8_w[pos8], &mv8_h[pos8],
			     &min_error8_2, flag_static_sprite, GetVopRoundingType(curr_vop), GetVopBrightWhite(curr_vop) /* MW QPEL 07-JUL-1998 */,GetVopReducedResolution(curr_vop)/* >>> modified for DRC by Fujitsu <<< */);
		  
		  /* MW QPEL 07-JUL-1998 >> */
		  if (quarter_pel) FindSubPel(i*MB_SIZE, j*MB_SIZE, 4, prev_rec,
					      &curr_mb[8][0], &curr_mb_alpha[8][0], 8,8, 2,
					      br_x-prev_x,br_y-prev_y, vop_width,vop_height,
					      edge, halfpelflags, 0, &mv8_w[pos8], &mv8_h[pos8],
					      &min_error8_2,flag_static_sprite, GetVopRoundingType(curr_vop), GetVopBrightWhite(curr_vop),0); /* >>> modified for DRC by Fujitsu <<< */
		  /* << MW QPEL 07-JUL-1998 */
/* >>> added for DRC by Fujitsu (top)    <<< */
	          } 
/* >>> added for DRC by Fujitsu (bottom)    <<< */
		}
              else
                {
                /* default value for transparent blocks */
                mv8_w[pos8]=mv8_h[pos8]=0.0;
                min_error8_2=0;
                }

              if (!B_TRANSP(alpha_sub,br_width/b_size_variable,i,j,1,1,MBM_TRANSPARENT)) /* >>> modified for DRC by Fujitsu <<< */
		{
/* >>> added for DRC by Fujitsu (top)    <<< */
                  if(GetVopReducedResolution(curr_vop)) { 
		    FindSubPel(i*mb_size_variable, j*mb_size_variable, 2 /* MW QPEL 07-JUL-1998 */, 
			       prev_ipol2,	/** modified for NEWPRED (Oki) 16-AUG-1999 **/
			       curr_mb_ptr3, curr_mb_alpha_ptr3, 16, 16 /* MW QPEL 07-JUL-1998 */, 3,
			       br_x-prev_x,br_y-prev_y, vop_width, vop_height,
			       edge, halfpelflags, 0, &mv8_w[pos8+1], &mv8_h[pos8+1],
			       &min_error8_3, flag_static_sprite, GetVopRoundingType(curr_vop), GetVopBrightWhite(curr_vop) /* MW QPEL 07-JUL-1998 */,GetVopReducedResolution(curr_vop)/* >>> modified for DRC by Fujitsu <<< */);
	          } else {
/* >>> added for DRC by Fujitsu (bottom)    <<< */
		  FindSubPel(i*MB_SIZE, j*MB_SIZE, 2 /* MW QPEL 07-JUL-1998 */, 
			     prev_ipol2,	/** modified for NEWPRED (Oki) 16-AUG-1999 **/
			     &curr_mb[8][8], &curr_mb_alpha[8][8], 8, 8 /* MW QPEL 07-JUL-1998 */, 3,
			     br_x-prev_x,br_y-prev_y, vop_width,vop_height,
			     edge, halfpelflags,0,&mv8_w[pos8+1], &mv8_h[pos8+1],
			     &min_error8_3, flag_static_sprite, GetVopRoundingType(curr_vop), GetVopBrightWhite(curr_vop) /* MW QPEL 07-JUL-1998 */,GetVopReducedResolution(curr_vop)/* >>> modified for DRC by Fujitsu <<< */);
		  
		  /* MW QPEL 07-JUL-1998 >> */
		  if (quarter_pel) FindSubPel(i*MB_SIZE, j*MB_SIZE, 4, prev_rec,
					      &curr_mb[8][8], &curr_mb_alpha[8][8], 8,8, 3,
					      br_x-prev_x,br_y-prev_y, vop_width,vop_height,
					      edge, halfpelflags, 0, &mv8_w[pos8+1], &mv8_h[pos8+1],
					      &min_error8_3,flag_static_sprite, GetVopRoundingType(curr_vop), GetVopBrightWhite(curr_vop),0);/* >>> modified for DRC by Fujitsu <<< */
		  /* << MW QPEL 07-JUL-1998 */
/* >>> added for DRC by Fujitsu (top)    <<< */
	          } 
/* >>> added for DRC by Fujitsu (bottom)    <<< */
		}
              else
                {
                /* default value for transparent blocks */
                mv8_w[pos8+1]=mv8_h[pos8+1]=0.0;
                min_error8_3=0;
                }

              sad8 = min_error8_0+min_error8_1+min_error8_2+min_error8_3;

/* modified by NTT for GMC coding : start */
	      if (! (GetVopSpriteUsage(curr_vop) == GMC_SPRITE &&
		     GetVopPredictionType(curr_vop) == 3)) {
/* modified by NTT for GMC coding : end */
              /* Choose 8x8 or 16x16 vectors */
              if (sad8 < (sad16 -(MB_Nb[posmode]/2+1)))
                  mode16[posmode] = MBM_INTER8;
              else
                {
                /* sad16(0,0) was decreased by MB_Nb, now add it back */
		/* MW 07-JUL-1998 */
                /* if (mv16_w[pos16]==0.0 && mv16_h[pos16]==0.0) */
                if ((mv16_w[pos16]==0.0) && (mv16_h[pos16]==0.0) && (mode16[posmode]==MBM_INTER16))
                  sad16 += MB_Nb[posmode]/2+1;

                }/* mode inter 8 */
/* modified by NTT for GMC coding : start */
	      } else { /* GMC */
		  Int	gmcOff, gmcOn, min_error;
/*		  Int	QP = GetVopQuantizer(curr_vop); removed by Y.Suzuki (28/03/99)*/

		  /* MacroBlock decision in Sprite-VOP for GMC */
		  if (sad8 < (sad16 -(MB_Nb[posmode]/2+1))) {
		      gmcOff = sad8;
		      gmcOn  = sadGMC + (MB_Nb[posmode] / 2 + 1) - (MB_Nb[posmode] * QP / 16);
		      mode16[posmode] = MBM_INTER8;
		      min_error = sad8;
		  } else if (mode16[posmode]==MBM_FIELD00 || mode16[posmode]==MBM_FIELD01 ||
			     mode16[posmode]==MBM_FIELD10 || mode16[posmode]==MBM_FIELD11) {
		      gmcOff = sad16 - (MB_Nb[posmode]/4+1);
		      gmcOn  = sadGMC + (MB_Nb[posmode] / 2 + 1) - (MB_Nb[posmode] * QP / 32);
		      min_error = sad16;
		  } else if (mv16_w[pos16]==0.0 && mv16_h[pos16]==0.0) {
		      gmcOff = sad16 + (MB_Nb[posmode] / 2 + 1);
		      gmcOn  = sadGMC + (MB_Nb[posmode] / 2 + 1) - (MB_Nb[posmode] / 2 + 1);
		      mode16[posmode] = MBM_INTER16;
		      min_error = sad16;
		  } else {
		      gmcOff = sad16;
		      gmcOn  = sadGMC + (MB_Nb[posmode] / 2 + 1) - (MB_Nb[posmode] * QP / 64);
		      mode16[posmode] = MBM_INTER16;
		      min_error = sad16;
		  }

		  /* Sprite On/Off decision */
		  if (gmcOn < gmcOff) {
		      mode16[posmode] = MBM_SPRITE;
		      min_error = sadGMC;
		  }

		  /* Inter/Intra decision */
		  if (ChooseMode((SInt *)GetImageData(GetVopY(curr_vop)), alpha,
				 i*MB_SIZE, j*MB_SIZE, MB_Nb, min_error, br_width, mb_size_variable) == 0) { /* >>> modified for DRC by Fujitsu <<< */
		      mode16[posmode] = MBM_INTRA;
		  }
	      }	/* GMC */
/* modified by NTT for GMC coding : end */
              } /* of enable_8x8_mv mode */
            else /* non enable_8x8_mv */
              {
              /* Choose 16x16 vectors or sprite */
              /* sad16(0,0) was decreased by MB_Nb, now add it back */

	      /* MW 07-JUL-1998 */
              /* if ((mv16_w[pos16]==0.0) && (mv16_h[pos16]==0.0)) */
              if ((mv16_w[pos16]==0.0) && (mv16_h[pos16]==0.0) && (mode16[posmode]==MBM_INTER16))
                sad16 += MB_Nb[posmode]/2+1;

/* modified by NTT for GMC coding : start */
              if (sadGMC <= sad16) {
		  mode16[posmode] = MBM_SPRITE;
	      }
/* modified by NTT for GMC coding : end */
              }
            } /* non spatial scalability */ /*SpSc*/
          else
            mode16[posmode] = MBM_INTER16; /*SpSc*/
          } /* end of mode non zero */

        else  /* MV are set to zero in the calling code */
          {}
        }
      else /* transparent block */
        {
        mode16[posmode] = MBM_TRANSPARENT;
        }


      pos8 = 2*j*2*imas_w + 2*i;   /* >>> added for DRC by Fujitsu (for correct log for DEBUG option)<<< */
#ifdef _DEBUG_
      if(!MB_TRANSP(alpha_sub,br_width/b_size_variable,i,j,MBM_TRANSPARENT)) /* >>> modified for DRC by Fujitsu <<< */
        {
	  /* MW 07-JUL-1998 */
	  /* if(Mode!=0 ) */
	  if(mode16[posmode]!=0 )
	    {
	      /* MW 07-JUL-1998 */
	      /* if(sad8>=sad16) */
	      if(mode16[posmode]==MBM_INTER16)
		{
		  fprintf(stderr,"MB(h,v)(%2d,%2d):\tMV(%f,%f) err=%d\n",i,j,
			  mv16_w[pos16],mv16_h[pos16],min_error16);
		  fprintf(stderr,"MB mode = %d\n",mode16[posmode]);
		}
	      /* MW 07-JUL-1998 */
	      /* else */
	      else if(mode16[posmode]==MBM_INTER8)
		{
		  fprintf(stderr,"MB(%d,%d)-mode 4\n",i,j);
		  if (!B_TRANSP(alpha_sub,br_width/b_size_variable,i,j,0,0,MBM_TRANSPARENT)) /* >>> modified for DRC by Fujitsu <<< */
		    {
		      fprintf(stderr,"B(0,0):\tMV(%f,%f) err=%d\n",mv8_w[pos8],
			      mv8_h[pos8],min_error8_0);
		    }
		  else
		    fprintf(stderr,"B(0,0) TRANSP\n");
		  
		  if (!B_TRANSP(alpha_sub,br_width/b_size_variable,i,j,1,0,MBM_TRANSPARENT)) /* >>> modified for DRC by Fujitsu <<< */
		    {
		      fprintf(stderr,"B(1,0):\tMV(%f,%f) err=%d\n",mv8_w[pos8+1],
			      mv8_h[pos8+1],min_error8_1);
		    }
		  else
		    fprintf(stderr,"B(1,0) TRANSP\n");

		  pos8+=2*imas_w;
		  if (!B_TRANSP(alpha_sub,br_width/b_size_variable,i,j,0,1,MBM_TRANSPARENT)) /* >>> modified for DRC by Fujitsu <<< */
		    {
		      fprintf(stderr,"B(0,1):\tMV(%f,%f) err=%d\n",mv8_w[pos8],
			      mv8_h[pos8],min_error8_2);
		    }
		  else
		    fprintf(stderr,"B(0,1) TRANSP\n");
		  
		  if (!B_TRANSP(alpha_sub,br_width/b_size_variable,i,j,1,1,MBM_TRANSPARENT)) /* >>> modified for DRC by Fujitsu <<< */
		    {
		      fprintf(stderr,"B(1,1):\tMV(%f,%f) err=%d\n",mv8_w[pos8+1],
			      mv8_h[pos8+1],min_error8_3);
		    }
		  else
		    fprintf(stderr,"B(1,1) TRANSP\n");
		}
	      else if(mode16[posmode]==MBM_FIELD00)	      /* MW 07-JUL-1998 */
		{
		  fprintf(stderr,"MB(h,v)(%2d,%2d):\ttop field MV(%f,%f) \n bottom field MV(%f,%f) err=%d\n",i,j,
			  mvF_w[pos16],mvF_h[pos16],mvF_w[pos16+2*imas_w],mvF_h[pos16+2*imas_w],sad16);
		  fprintf(stderr,"MB mode = MBM_FIELD00\n");
		}
	      else if(mode16[posmode]==MBM_FIELD01)	      /* MW 07-JUL-1998 */
		{
		  fprintf(stderr,"MB(h,v)(%2d,%2d):\ttop field MV(%f,%f) \n bottom field MV(%f,%f) err=%d\n",i,j,
			  mvF_w[pos16],mvF_h[pos16],mvF_w[pos16+2*imas_w+1],mvF_h[pos16+2*imas_w+1],sad16);
		  fprintf(stderr,"MB mode = MBM_FIELD01\n");
		}
	      else if(mode16[posmode]==MBM_FIELD10)	      /* MW 07-JUL-1998 */
		{
		  fprintf(stderr,"MB(h,v)(%2d,%2d):\ttop field MV(%f,%f) \n bottom field MV(%f,%f) err=%d\n",i,j,
			  mvF_w[pos16+1],mvF_h[pos16+1],mvF_w[pos16+2*imas_w],mvF_h[pos16+2*imas_w],sad16);
		  fprintf(stderr,"MB mode = MBM_FIELD10\n");
		}
	      else if(mode16[posmode]==MBM_FIELD11)	      /* MW 07-JUL-1998 */
		{
		  fprintf(stderr,"MB(h,v)(%2d,%2d):\ttop field MV(%f,%f) \n bottom field MV(%f,%f) err=%d\n",i,j,
			  mvF_w[pos16+1],mvF_h[pos16+1],mvF_w[pos16+2*imas_w+1],mvF_h[pos16+2*imas_w+1],sad16);
		  fprintf(stderr,"MB mode = MBM_FIELD11\n");
		}
/* modified by NTT for GMC coding : start */
	      else if(mode16[posmode]==MBM_SPRITE)
	      {
		  fprintf(stderr,"MB(h,v)(%2d,%2d):\tGMC MB\n",i,j);
	      }
/* modified by NTT for GMC coding : end */
	      else 	      /* MW 07-JUL-1998 */
		{
		  printf("Unknown Mode %d\n",mode16[posmode]);
		}
	    }
	  else
          fprintf(stderr,"MB(i,j)(%2d,%2d): mode 0\n",i,j);
        }
      else
        fprintf(stderr,"MB(h,v)(%2d,%2d):\tTRANSP-MV, mode 0\n",i,j);
#endif
      }

#ifdef _DEBUG_MV_MOD_

#define ABSDOUBLE(x) (((x) > 0.0001) ? (x) : (((x) < -0.0001) ? -(x): 0.0 ))

#define CHECK16(x,y,px,py,ran) \
 (((ABSDOUBLE(mv16_w[2*j*2*imas_w+2*i]    )<range) || \
   (ABSDOUBLE(mv16_h[2*j*2*imas_w+2*i]      )<range)) ?1 : 0)

/* Note,<=11 due to the maximum diference betwen mv16 and mv18 is:
 *    10  (window +/- 10 around mv16) plus
 *    1/2 (mv16 halfpel posible movement) plus
 *    1/2 (mv8  halfpel posible movement) equals
 *    11
 */

/* The macros sould be more corectly defined (11==WINDOW_W+1, etc), but
 * for this moment are enought
 */

#define CHECK81(x,y,px,py,ran) \
 (((ABSDOUBLE(mv8_w[2*j*2*imas_w+2*i]-mv16_w[2*j*2*imas_w+2*i])<=11) && \
   (ABSDOUBLE(mv8_h[2*j*2*imas_w+2*i]-mv16_h[2*j*2*imas_w+2*i])<=11))? 1 : 0)

#define CHECK82(x,y,px,py,ran) \
 (((ABSDOUBLE(mv8_w[2*j*2*imas_w+2*i+1]-mv16_w[2*j*2*imas_w+2*i])<=11) && \
   (ABSDOUBLE(mv8_h[2*j*2*imas_w+2*i+1]-mv16_h[2*j*2*imas_w+2*i])<=11))? 1:0)

#define CHECK83(x,y,px,py,ran) \
 (((ABSDOUBLE(mv8_w[(2*j+1)*2*imas_w+2*i]-mv16_w[2*j*2*imas_w+2*i])<=11) && \
   (ABSDOUBLE(mv8_h[(2*j+1)*2*imas_w+2*i]-mv16_h[2*j*2*imas_w+2*i])<=11))? 1:0)

#define CHECK84(x,y,px,py,ran) \
 (((ABSDOUBLE(mv8_w[(2*j+1)*2*imas_w+2*i+1]-mv16_w[2*j*2*imas_w+2*i])<=11) && \
   (ABSDOUBLE(mv8_h[(2*j+1)*2*imas_w+2*i+1]-mv16_h[2*j*2*imas_w+2*i])<=11))?1:0)

  fprintf(stdout,"Motion estimation\n");
  fprintf(stdout,"16x16 vectors:\n");

  for ( j = 0; j <imas_h ; j++)
    {
    for ( i = 0; i < imas_w; i++)
      {
      if ((mode16[j*imas_w + i] == 1)||(mode16[j*imas_w + i] ==4)) /* INTER */
        {
        Int range;

        range=(Int)pow(2.0,(double)(f_code+4)); /* Range in 1/2 pel units */
        if(CHECK16(mv16_w[2*j*2*imas_w+2*i],mv16_h[2*j*2*imas_w+2*i],
                   0.0,0.0,range))
          fprintf(stdout," (%+05.1f %+05.1f)",  mv16_w[2*j*2*imas_w+2*i],
                  mv16_h[2*j*2*imas_w+2*i]);
        else
          fprintf(stdout,"!#%+05.1f %+05.1f#",  mv16_w[2*j*2*imas_w+2*i],
                  mv16_h[2*j*2*imas_w+2*i]);
        }
      else
        fprintf(stdout," (   .     . )");
      }
    fprintf(stdout,"\n");
    }
  if (enable_8x8_mv)
    {
    Float pmv_x, pmv_y;
    fprintf(stdout,"8x8 vectors:\n\n");
    fprintf(stdout,"Block 0\n");
    for ( j = 0; j < imas_h; j++)
      {
      for ( i = 0; i < imas_w; i++)
        {
        pmv_x= mv16_w[2*j*2*imas_w+2*i];
        pmv_y= mv16_h[2*j*2*imas_w+2*i];
        if (mode16[j*imas_w + i] == 4) /* INTER8 */
          {
          if(CHECK81(mv8_w[2*j*2*imas_w+2*i],mv8_h[2*j*2*imas_w+2*i],
            pmv_x,pmv_y,10))
            fprintf(stdout," (%+05.1f %+05.1f)", mv8_w[2*j*2*imas_w+2*i],
                    mv8_h[2*j*2*imas_w+2*i]);
          else
            fprintf(stdout,"!#%+05.1f %+05.1f#", mv8_w[2*j*2*imas_w+2*i],
                    mv8_h[2*j*2*imas_w+2*i]);
          }
        else if(mode16[j*imas_w + i] == 1) /* INTER16, do not check it */
          fprintf(stdout," (%+05.1f %+05.1f)", mv8_w[2*j*2*imas_w+2*i],
                  mv8_h[2*j*2*imas_w+2*i]);
        else
          fprintf(stdout," (   .     . )");
        }
      fprintf(stdout,"\n");
      fprintf(stdout,"\n");
      }
    fprintf(stdout,"Block 1\n");
    for ( j = 0; j < imas_h; j++)
      {
      for ( i = 0; i < imas_w; i++)
        {
        pmv_x= mv16_w[2*j*2*imas_w+2*i];
        pmv_y= mv16_h[2*j*2*imas_w+2*i];
        if (mode16[j*imas_w + i] == 4) /* INTER8 */
          {
          if(CHECK82(mv8_w[2*j*2*imas_w+2*i+1],mv8_h[2*j*2*imas_w+2*i+1],
                     pmv_x,pmv_y,10))
            fprintf(stdout," (%+05.1f %+05.1f)", mv8_w[2*j*2*imas_w+2*i+1],
                    mv8_h[2*j*2*imas_w+2*i+1]);
          else
            fprintf(stdout,"!#%+05.1f %+05.1f#", mv8_w[2*j*2*imas_w+2*i+1],
                    mv8_h[2*j*2*imas_w+2*i+1]);
          }
        else if (mode16[j*imas_w + i] == 1) /* INTER16, do not check it */
          fprintf(stdout," (%+05.1f %+05.1f)", mv8_w[2*j*2*imas_w+2*i+1],
                  mv8_h[2*j*2*imas_w+2*i+1]);
        else
          fprintf(stdout," (   .     . )");
        }
      fprintf(stdout,"\n");
      fprintf(stdout,"\n");
      }
    fprintf(stdout,"Block 2\n");
    for ( j = 0; j < imas_h; j++)
      {
      for ( i = 0; i < imas_w; i++)
        {
        pmv_x= mv16_w[2*j*2*imas_w+2*i];
        pmv_y= mv16_h[2*j*2*imas_w+2*i];
        if (mode16[j*imas_w + i] == 4) /* INTER8 */
          {
          if(CHECK83(mv8_w[(2*j+1)*2*imas_w+2*i],mv8_h[(2*j+1)*2*imas_w+2*i],
                     pmv_x,pmv_y,10))
            fprintf(stdout," (%+05.1f %+05.1f)", mv8_w[(2*j+1)*2*imas_w+2*i],
                    mv8_h[(2*j+1)*2*imas_w+2*i]);
          else
            fprintf(stdout,"!#%+05.1f %+05.1f#", mv8_w[(2*j+1)*2*imas_w+2*i],
                    mv8_h[(2*j+1)*2*imas_w+2*i]);
          }
        else if (mode16[j*imas_w + i] == 1) /* INTER16, do not check it */
          fprintf(stdout," (%+05.1f %+05.1f)", mv8_w[(2*j+1)*2*imas_w+2*i],
                  mv8_h[(2*j+1)*2*imas_w+2*i]);
        else
          fprintf(stdout," (   .     . )");
        }
      fprintf(stdout,"\n");
      fprintf(stdout,"\n");
      }
    fprintf(stdout,"Block 3\n");
    for ( j = 0; j < imas_h; j++)
      {
      for ( i = 0; i < imas_w; i++)
        {
        pmv_x= mv16_w[2*j*2*imas_w+2*i];
        pmv_y= mv16_h[2*j*2*imas_w+2*i];
        if (mode16[j*imas_w + i] == 4) /* INTER8 */
          {
          if(CHECK84(mv8_w[(2*j+1)*2*imas_w+2*i+1],
                     mv8_h[(2*j+1)*2*imas_w+2*i+1], pmv_x,pmv_y,10))
            fprintf(stdout," (%+05.1f %+05.1f)", mv8_w[(2*j+1)*2*imas_w+2*i+1],
                    mv8_h[(2*j+1)*2*imas_w+2*i+1]);
          else
            fprintf(stdout,"!#%+05.1f %+05.1f#", mv8_w[(2*j+1)*2*imas_w+2*i+1],
                    mv8_h[(2*j+1)*2*imas_w+2*i+1]);
          }
        else if (mode16[j*imas_w + i] == 1) /* INTER16, do not check it */
          fprintf(stdout," (%+05.1f %+05.1f)", mv8_w[(2*j+1)*2*imas_w+2*i+1],
                  mv8_h[(2*j+1)*2*imas_w+2*i+1]);
        else
          fprintf(stdout," (   .     . )");
        }
      fprintf(stdout,"\n");
      fprintf(stdout,"\n");
      }
    }

  fprintf(stdout,"Modes:\n");

  for ( j = 0; j <imas_h ; j++)
    {
    for ( i = 0; i < imas_w; i++)
      {
      fprintf(stdout," %d ",mode16[j*imas_w+i]);
      }
    fprintf(stdout,"\n");
    }
#endif

  free((Char*)MB_Nb);
  free((Char*)halfpelflags);

  /** added for NEWPRED (Oki) 16-AUG-1999 **/
  if(GetVopNewpredEnable(curr_vop)){
    FreeImage(tmp_image);
    FreeImage(tmp_image_ipol);
  }
  /** end of NEWPRED (Oki) 16-AUG-1999 **/

  return;
}

/***********************************************************CommentBegin******
 *
 * -- FullPelMotionEstMB -- Computes MV's and predictor errors
 *
 * Author :
 *      Bob Eifrig
 *      General Instrument
 *
 * Created :
 *
 *
 * Purpose :
 *      To obtain full-pel motion vectors and make the Intra/Inter decision
 *
 * Arguments in :
 *      Vol *vol           the VOL structure
 *      Int i, j           Macroblock coordinates
 *      SInt *ref          Reference picture
 *      SInt *alpha_sub    Subsampled alpha
 *      SInt *MB_Nb        Non-transparent pels per MB
 *
 * Arguments out :
 *      Float   *mv16   16x16 motion vector
 *      Float   *mvF    Four field motion vectors
 *      Float   *mv8    Four 8x8 block motion vectors
 *
 * Return values :
 *      none
 *
 * Side effects :
 *
 *
 * Description :
 *
 *
 * See also :
 *
 *
 * Modified : 15.02.99 U. Benzler : added SearchRange (sr) in function call
 *	03.03.99 Seishi TAKAMURA (NTT): added GMC coding
 *	06.09.99 Eishi Morimatsu (Fujitsu Labs.): added DRC support
 *
 *
 ***********************************************************CommentEnd********/

Int
FullPelMotionEstMB(
   Vop     *curr_vop,
   SInt    *alpha,
   SInt    *prev,
   SInt    *alpha_sub,
   Int     br_x,
   Int     br_y,
   Int     br_width,
   Int     br_height,
   Int     i,
   Int     j,
   Int     prev_x,
   Int     prev_y,
   Int     vop_width,
   Int     vop_height,
   Int     enable_8x8_mv,
   Int     edge,
   Int     f_code,
   Int     sr, /* UB 990215 added search range */
   SInt    *MB_Nb,
   Int     ref_sel_code,
   Float   *mv16_w,
   Float   *mv16_h,
   Float   *mv8_w,
   Float   *mv8_h,
   Float   *mvF_w,
   Float   *mvF_h,
   SInt    *halfpelflags)
{
  Char   line[256];
  Int    iv16[2], ivF[8], iv8[8], mbx, mby, interflag;
  Int    k, min_error, imv, imv_width;
  Int    xmin, xmax, ymin, ymax;

/* >>> added for DRC by Fujitsu (top)    <<< */
  Int   mb_size_variable;
/* >>> added for DRC by Fujitsu (bottom)    <<< */

/* >>> added for DRC by Fujitsu (top)    <<< */
  if(GetVopReducedResolution(curr_vop))
    mb_size_variable = MB_SIZE * 2;		
  else
    mb_size_variable = MB_SIZE;		
/* >>> added for DRC by Fujitsu (bottom)    <<< */

  imv_width = 2*vop_width/mb_size_variable; /* >>> modified for DRC by Fujitsu <<< */
  imv = 2*i + 2*imv_width*j;
  if (curr_vop->mvfileusage == 1)
    {
    if (fgets(line, sizeof line, curr_vop->mvfile) == NULL)
      {
      fprintf(stderr, "EOF on %s\n", curr_vop->mvfilename);
      exit(1);
      }
    (*curr_vop->mvlinenop)++;
    if (sscanf(line,
               "%d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d",
               &mbx, &mby, &interflag, &iv16[0], &iv16[1],
               &ivF[0], &ivF[1], &ivF[2], &ivF[3], &ivF[4],
               &ivF[5], &ivF[6], &ivF[7],
               &iv8[0], &iv8[1], &iv8[2], &iv8[3], &iv8[4],
               &iv8[5], &iv8[6], &iv8[7]) != 21)
      {
      fprintf(stderr, "Bad format on %s:%d\n",
              curr_vop->mvfilename, *curr_vop->mvlinenop);
      exit(1);
      }
    if ((mbx != i) || (mby != j))
      {
      fprintf(stderr, "Exepected MB (%d %d), got (%d %d)\n",
              i, j, mbx, mby);
      exit(1);
      }

    xmin = -((i*MB_SIZE + edge) << 1);
    xmax =  ((GetVopWidth(curr_vop)  - i*MB_SIZE + MB_SIZE - edge) << 1);
    ymin = -((j*MB_SIZE + edge) << 1);
    ymax =  ((GetVopHeight(curr_vop) - j*MB_SIZE + MB_SIZE - edge) << 1);

    if (iv16[0] < xmin)
      iv16[0] = xmin;
    if (iv16[0] > xmax)
      iv16[0] = xmax;
    if (iv16[1] < ymin)
      iv16[1] = ymin;
    if (iv16[1] > ymax)
      iv16[1] = ymax;

    for (k = 0; k < 8; k += 2)
      {
      if (ivF[0] < xmin)
        ivF[0] = xmin;
      if (ivF[0] > xmax)
        ivF[0] = xmax;
      if (ivF[1] < ymin)
        ivF[1] = ymin;
      if (ivF[1] > ymax)
        ivF[1] = ymax;
      }

    if (iv8[0] <  xmin)
      iv8[0] =  xmin;
    if (iv8[0] > (xmax + MB_SIZE))
      iv8[0] = (xmax + MB_SIZE);

    if (iv8[1] <  ymin)
      iv8[1] =  ymin;
    if (iv8[1] > (ymax + MB_SIZE))
      iv8[1] = (ymax + MB_SIZE);

    if (iv8[2] < (xmin - MB_SIZE))
      iv8[2] = (xmin - MB_SIZE);
    if (iv8[2] >  xmax)
      iv8[2] =  xmax;

    if (iv8[3] <  ymin)
      iv8[3] =  ymin;
    if (iv8[3] > (ymax + MB_SIZE))
      iv8[3] = (ymax + MB_SIZE);

    if (iv8[4] <  xmin)
      iv8[4] =  xmin;
    if (iv8[4] > (xmax + MB_SIZE))
      iv8[4] = (xmax + MB_SIZE);

    if (iv8[5] < (ymin - MB_SIZE))
      iv8[5] = (ymin - MB_SIZE);
    if (iv8[5] >  ymax)
      iv8[5] =  ymax;

    if (iv8[6] < (xmin - MB_SIZE))
      iv8[6] = (xmin - MB_SIZE);
    if (iv8[6] >  xmax)
      iv8[6] =  xmax;

    if (iv8[7] < (ymin - MB_SIZE))
      iv8[7] = (ymin - MB_SIZE);
    if (iv8[7] >  ymax)
      iv8[7] =  ymax;

    mv16_w += imv;
    mv16_h += imv;
    if (enable_8x8_mv) {
      mv8_w  += imv;
      mv8_h  += imv;
    }
    mvF_w  += imv;
    mvF_h  += imv;

    mv16_w[0] = mv16_w[1] = mv16_w[imv_width] = mv16_w[imv_width+1] =
                (Float)(0.5 * iv16[0]);
    mv16_h[0] = mv16_h[1] = mv16_h[imv_width] = mv16_h[imv_width+1] =
                (Float)(0.5 * iv16[1]);

    mvF_w[0]             = (Float)(0.5 * ivF[0]);
    mvF_h[0]             = (Float)(0.5 * ivF[1]);
    mvF_w[1]             = (Float)(0.5 * ivF[2]);
    mvF_h[1]             = (Float)(0.5 * ivF[3]);
    mvF_w[imv_width    ] = (Float)(0.5 * ivF[4]);
    mvF_h[imv_width]     = (Float)(0.5 * ivF[5]);
    mvF_w[imv_width + 1] = (Float)(0.5 * ivF[6]);
    mvF_h[imv_width + 1] = (Float)(0.5 * ivF[7]);
    mv8_w[0]             = (Float)(0.5 * iv8[0]);
    mv8_h[0]             = (Float)(0.5 * iv8[1]);
    mv8_w[1]             = (Float)(0.5 * iv8[2]);
    mv8_h[1]             = (Float)(0.5 * iv8[3]);
    mv8_w[imv_width    ] = (Float)(0.5 * iv8[4]);
    mv8_h[imv_width]     = (Float)(0.5 * iv8[5]);
    mv8_w[imv_width + 1] = (Float)(0.5 * iv8[6]);
    mv8_h[imv_width + 1] = (Float)(0.5 * iv8[7]);
    }
  else
    {
    MBMotionEstimation(curr_vop, alpha, prev, alpha_sub, br_x, br_y,
                       br_width, i, j, prev_x, prev_y,
                       vop_width, vop_height, enable_8x8_mv, edge,
                       f_code, sr, MB_Nb, ref_sel_code, mv16_w, mv16_h, /* UB 990215 added search range */
                       mv8_w, mv8_h, mvF_w, mvF_h, &min_error, halfpelflags);

#ifdef _DRC_DEBUG_
    printf("DRC DBG: %d\n",min_error); 
    printf("DRC DBG: x=%f,y=%f,minMAD=%d\n",mv16_w[0],mv16_h[0],min_error); 
#endif

    /* Inter/Intra decision */
    interflag = ChooseMode((SInt *)GetImageData(GetVopY(curr_vop)),
    alpha,i*mb_size_variable,j*mb_size_variable, MB_Nb, min_error, br_width, mb_size_variable); /* >>> modified for DRC by Fujitsu <<< */

/* modified by NTT for GMC coding :start */
    if (GetVopSpriteUsage(curr_vop) == GMC_SPRITE && min_error != MV_MAX_ERROR) {
	interflag = 1;
    }
/* modified by NTT for GMC coding :end */

    /* Write MVs to file */
    if (curr_vop->mvfileusage == 2) {
      mv16_w += imv; mv16_h += imv;
      if (enable_8x8_mv) {
	mv8_w  += imv; mv8_h  += imv;
      }
      mvF_w  += imv; mvF_h  += imv;
      fprintf(curr_vop->mvfile,
                "%3d %3d %3d %3d %3d %3d %3d %3d %3d %3d %3d %3d %3d %3d %3d %3d %3d %3d %3d %3d %3d\n",
              i, j, interflag,
              (int)(2*mv16_w[0]),          (int)(2*mv16_h[0]),
              (int)(2*mvF_w[0]),           (int)(2*mvF_h[0]),
              (int)(2*mvF_w[1]),           (int)(2*mvF_h[1]),
              (int)(2*mvF_w[imv_width]),   (int)(2*mvF_h[imv_width]),
              (int)(2*mvF_w[imv_width+1]), (int)(2*mvF_h[imv_width+1]),
              (int)(2*mv8_w[0]),           (int)(2*mv8_h[0]),
              (int)(2*mv8_w[1]),           (int)(2*mv8_h[0]),
              (int)(2*mv8_w[imv_width]),   (int)(2*mv8_h[imv_width]),
              (int)(2*mv8_w[imv_width+1]), (int)(2*mv8_h[imv_width+1]));
      (*curr_vop->mvlinenop)++;
      }
    }
  return(interflag);
}
