/*****************************************************************************
 *
 * This software module was originally developed by
 *
 *   Jong Deuk Kim (HYUNDAI)
 *
 * in the course of development of the MPEG-4 Video (ISO/IEC 14496-2) standard.
 * This software module is an implementation of a part of one or more MPEG-4
 * Video (ISO/IEC 14496-2) tools as specified by the MPEG-4 Video (ISO/IEC
 * 14496-2) standard.
 *
 * ISO/IEC gives users of the MPEG-4 Video (ISO/IEC 14496-2) standard free
 * license to this software module or modifications thereof for use in hardware
 * or software products claiming conformance to the MPEG-4 Video (ISO/IEC
 * 14496-2) standard.
 *
 * Those intending to use this software module in hardware or software products
 * are advised that its use may infringe existing patents. The original
 * developer of this software module and his/her company, the subsequent
 * editors and their companies, and ISO/IEC have no liability for use of this
 * software module or modifications thereof in an implementation. Copyright is
 * not released for non MPEG-4 Video (ISO/IEC 14496-2) Standard conforming
 * products.
 *
 * ACTS-MoMuSys partners retain full right to use the code for his/her own
 * purpose, assign or donate the code to a third party and to inhibit third
 * parties from using the code for non MPEG-4 Video (ISO/IEC 14496-2) Standard
 * conforming products. This copyright notice must be included in all copies or
 * derivative works.
 *
 * Copyright (c) 1998
 *
 *****************************************************************************/
/***********************************************************HeaderBegin*******
 *
 * File:        interlaced_B.c
 *
 * Author:      Jong Deuk Kim (jdkim97@hei.co.kr), HYUNDAI
 *
 * Created:     07.05.98
 *
 * Description: subroutines for motion estimation in interlaced B-VOP 
 *
 *
 * Modified:
 *            980730 U. Benzler, Uni Hannover : added quarter pel support
 *
 ***********************************************************HeaderEnd*********/
  
/************************    INCLUDE FILES    ********************************/
 
#include "momusys.h"
#include "mom_structs.h"
#include "vm_common_defs.h"
#include "mom_access.h"
#include "mom_image.h"
#include "mom_vop.h"
#include "mot_util.h"
#include "mot_padding.h"
#include "mot_est.h"
#include "io_generic.h"
#include "mot_comp.h"
#include "vm_config.h"
#include "vm_stats.h"
#include "interlaced_B.h"

#define DEFAULT_EDGE 16

#include <stdio.h>
#include <string.h>
#include <fcntl.h>



/***********************************************************CommentBegin******
 *
 * --MB_pel_field_motion_estimation--
 *
 * Author :
 *      HYUNDAI - Jong Deuk Kim
 *
 * Created :
 *      07.05.98
 *
 * Purpose :
 *      Inter pel Field motion Estimation for MB.
 *
 * Arguments in :
 *
 * Arguments in/out :
 *
 *
 * Arguments out :
 *
 * Return values :
 *      none
 *
 * Side effects :
 *
 *
 * Description :
 *
 *
 * See also :
 *
 *
 * Modified :
 *
 *
 ***********************************************************CommentEnd********/
Void
MB_pel_field_motion_estimation(
   SInt *blk16,
   SInt *mask16,
   SInt *ref_blk,
   Int  Sr_x_low,
   Int  Sr_x_upper,
   Int  Sr_y_low,
   Int  Sr_y_upper,
   Int  Sr_x,
   Int  Sr_y,
   Int  npix,
   Int  NB,
   Int  blk_nr,
   SInt sign, /* 0 , 1,  2, 3,  4 <--> 16x16*/
   SInt *vx_out,
   SInt *vy_out,
   Int  *err
   )
{
  Sr_y_low = (Sr_y_low + 1) & ~1;


  /*
   * Do field full pel MV search : cur=top, ref=top
   */
   err[0] = Field16x8_SAD_B(blk16, mask16, ref_blk, 
			Sr_x_low, Sr_x_upper, Sr_y_low, Sr_y_upper,
		    	Sr_x, Sr_y, npix, NB, blk_nr, sign, 
			&vx_out[0], &vy_out[0], 0 /* top-top */);

  /*
   * Do field full pel MV search : cur=top, ref=bot
   */
   err[1] = Field16x8_SAD_B(blk16, mask16, ref_blk, 
			Sr_x_low, Sr_x_upper, Sr_y_low, Sr_y_upper,
		     	Sr_x, Sr_y, npix, NB, blk_nr, sign, 
			&vx_out[1], &vy_out[1], 1 /* top-bot */);


  /*
   * Do field full pel MV search : cur=bot, ref=top
   */
   err[2] = Field16x8_SAD_B(blk16, mask16, ref_blk, 
			Sr_x_low, Sr_x_upper, Sr_y_low, Sr_y_upper,
			Sr_x, Sr_y, npix, NB, blk_nr, sign, 
			&vx_out[2], &vy_out[2], 2 /* bot-top */);


  /*
   * Do field full pel MV search : cur=bot, ref=bot
   */
   err[3] = Field16x8_SAD_B(blk16, mask16, ref_blk, 
			Sr_x_low, Sr_x_upper, Sr_y_low, Sr_y_upper,
		     	Sr_x, Sr_y, npix, NB, blk_nr, sign, 
			&vx_out[3], &vy_out[3], 3 /* bot-bot */);
}

/***********************************************************CommentBegin******
 *
 * --Field16x8_SAD_B--
 *
 * Author :
 *      HYUNDAI - Jong Deuk Kim
 *
 * Created :
 *      07.05.98
 *
 * Purpose :
 *      Calculate Field SAD for B-VOP
 *
 * Arguments in :
 *
 * Arguments in/out :
 *
 *
 * Arguments out :
 *
 * Return values :
 *      none
 *
 * Side effects :
 *
 *
 * Description :
 *
 *
 * See also :
 *
 *
 * Modified :
 *
 *
 ***********************************************************CommentEnd********/
Int Field16x8_SAD_B(
   SInt *blk16,
   SInt *mask16,
   SInt *ref_blk,
   Int  Sr_x_low,
   Int  Sr_x_upper,
   Int  Sr_y_low,
   Int  Sr_y_upper,
   Int  Sr_x,
   Int  Sr_y,
   Int  npix,
   Int  NB,
   Int  blk_nr,
   SInt sign, /* 0 , 1,  2, 3,  4 <--> 16x16*/
   SInt *vx_out,
   SInt *vy_out,
   Int  pred_mode        /* 0:top-top, 1:top-bot, 2:bot-top, 3:bot-bot */
   )
{
  SInt         *i0,*j0,*k0,*k1;
  Int          index1;
  Int          sum,sum_min=0,offset;
  static Int   k1_start0[5]={0,8,128,136,0};
  static Int   k1_end0[5]  ={128,128,256,256,256};
  static Int   pos[5] ={0,0,8,8,0};
  SInt         *k1_start=k1_start0[blk_nr]+blk16;
  SInt         *k1_end=k1_end0[blk_nr]+blk16;
  SInt         *msk;
  Int          mask_offset;
  Int          i,j,vx=0,vy=0;
  Int          error=200000;
  Int	       cur_off=0, ref_off=0, k2;

  switch(pred_mode)
  {
     case 0 : cur_off = 0; ref_off = 0;
	      break;
     case 1 : cur_off = 0; ref_off = 1;
              break;
     case 2 : cur_off = 1; ref_off = 0;
              break;
     case 3 : cur_off = 1; ref_off = 1;
              break;
  }

  k1_start += cur_off*MB_SIZE;
  k1_end   -= (1-cur_off)*MB_SIZE;  


  offset =(Sr_y+1)*npix+Sr_x+1;
  if (blk_nr==4)
  {
    for (i=0;i<16;i+=2)
      for (j=0;j<16;j++)
      {
        index1 = 16*(i+cur_off)+j;
        if (mask16[index1])
        {
          error = blk16[index1]-ref_blk[(i+ref_off)*npix+j+offset];
          if (error<0)
            sum_min-=error;
          else sum_min+=error;
        }
      }
/*      sum_min -= NB/2-1;   */
  }
  else
    sum_min = 2000000;

  mask_offset=mask16-blk16;
  i0 = (Sr_y+Sr_y_low+pos[blk_nr]+ref_off+1)*npix+Sr_x+Sr_x_low+(blk_nr%2)*8+ref_blk;
  if (blk_nr==4)
  {
    if (sign==MBM_OPAQUE)
      for (i=Sr_y_low;i<Sr_y_upper;i+=2)
      {
        j0 = i0;
        for (j=Sr_x_low;j<Sr_x_upper;j++)
        {
          j0++;
          sum=0;
          for (k0=j0,k1=k1_start;k1<k1_end;k0+=2*npix,k1+=32)
          {
            error = k0[0]-k1[0];
            if (error<0) sum-=error;else sum+=error;
            error = k0[1]-k1[1];
            if (error<0) sum-=error;else sum+=error;
            error = k0[2]-k1[2];
            if (error<0) sum-=error;else sum+=error;
            error = k0[3]-k1[3];
            if (error<0) sum-=error;else sum+=error;
            error = k0[4]-k1[4];
            if (error<0) sum-=error;else sum+=error;
            error = k0[5]-k1[5];
            if (error<0) sum-=error;else sum+=error;
            error = k0[6]-k1[6];
            if (error<0) sum-=error;else sum+=error;
            error = k0[7]-k1[7];
            if (error<0) sum-=error;else sum+=error;
            error = k0[8]-k1[8];
            if (error<0) sum-=error;else sum+=error;
            error = k0[9]-k1[9];
            if (error<0) sum-=error;else sum+=error;
            error = k0[10]-k1[10];
            if (error<0) sum-=error;else sum+=error;
            error = k0[11]-k1[11];
            if (error<0) sum-=error;else sum+=error;
            error = k0[12]-k1[12];
            if (error<0) sum-=error;else sum+=error;
            error = k0[13]-k1[13];
            if (error<0) sum-=error;else sum+=error;
            error = k0[14]-k1[14];
            if (error<0) sum-=error;else sum+=error;
            error = k0[15]-k1[15];
            if (error<0) sum-=error;else sum+=error;
            if (sum>sum_min) break;
          }
 
          if (sum<sum_min)
            {
            sum_min=sum;
            vx=j;vy=i;
            }
          else if (sum==sum_min)
            if (abs(vx)+abs(vy)>abs(i)+abs(j))
              {
              vx=j;vy=i;
              }
          }
        i0+=2*npix;
        }
     else
        for (i=Sr_y_low;i<Sr_y_upper;i+=2)
          {
          j0=i0;
          for (j=Sr_x_low;j<Sr_x_upper;j++)
            {
            j0++;
            sum=0;
            for (k2=cur_off*MB_SIZE, k0=j0,k1=k1_start;k1<k1_end;k0+=2*npix,k1+=32, k2+=32)
              {
		if(mask16[k2])
                {
                error = k0[0]-k1[0];
                if (error<0) sum-=error;else sum+=error;
                }
	      if(mask16[k2+1])
                {
                error = k0[1]-k1[1];
                if (error<0) sum-=error;else sum+=error;
                }
	      if(mask16[k2+2])
                {
                error = k0[2]-k1[2];
                if (error<0) sum-=error;else sum+=error;
                }
	      if(mask16[k2+3])
                {
                error = k0[3]-k1[3];
                if (error<0) sum-=error;else sum+=error;
                }
	      if(mask16[k2+4])
                {
                error = k0[4]-k1[4];
                if (error<0) sum-=error;else sum+=error;
                }
	      if(mask16[k2+5])
                {
                error = k0[5]-k1[5];
                if (error<0) sum-=error;else sum+=error;
                }
	      if(mask16[k2+6])
                {
                error = k0[6]-k1[6];
                if (error<0) sum-=error;else sum+=error;
                }
	      if(mask16[k2+7])
                {
                error = k0[7]-k1[7];
                if (error<0) sum-=error;else sum+=error;
                }
	      if(mask16[k2+8])
                {
                error = k0[8]-k1[8];
                if (error<0) sum-=error;else sum+=error;
                }
	      if(mask16[k2+9])
                {
                error = k0[9]-k1[9];
                if (error<0) sum-=error;else sum+=error;
                }
	      if(mask16[k2+10])
                {
                error = k0[10]-k1[10];
                if (error<0) sum-=error;else sum+=error;
                }
	      if(mask16[k2+11])
                {
                error = k0[11]-k1[11];
                if (error<0) sum-=error;else sum+=error;
                }
	      if(mask16[k2+12])
                {
                error = k0[12]-k1[12];
                if (error<0) sum-=error;else sum+=error;
                }
	      if(mask16[k2+13])
                {
                error = k0[13]-k1[13];
                if (error<0) sum-=error;else sum+=error;
                }
	      if(mask16[k2+14])
                {
                error = k0[14]-k1[14];
                if (error<0) sum-=error;else sum+=error;
                }
	      if(mask16[k2+15])
                {
                error = k0[15]-k1[15];
                if (error<0) sum-=error;else sum+=error;
                }
              if (sum>sum_min) break;
              }
 
            if (sum<sum_min)
              {
              sum_min=sum;
              vx=j;vy=i;
              }
            else if (sum==sum_min)
              if (abs(vx)+abs(vy)>abs(i)+abs(j))
                {
                vx=j;vy=i;
                }
            }
          i0 += 2*npix;
          }
    }
  else
    {
    if (sign==MBM_OPAQUE)
      for (i=Sr_y_low;i<Sr_y_upper;i+=2)
        {
        j0=i0;
        for (j=Sr_x_low;j<Sr_x_upper;j++)
          {
          j0++;
          sum=0;
          for (k0=j0,k1=k1_start;k1<k1_end;k0+=2*npix,k1+=32)
            {
            error = k0[0]-k1[0];
            if (error<0) sum-=error;else sum+=error;
            error = k0[1]-k1[1];
            if (error<0) sum-=error;else sum+=error;
            error = k0[2]-k1[2];
            if (error<0) sum-=error;else sum+=error;
            error = k0[3]-k1[3];
            if (error<0) sum-=error;else sum+=error;
            error = k0[4]-k1[4];
            if (error<0) sum-=error;else sum+=error;
            error = k0[5]-k1[5];
            if (error<0) sum-=error;else sum+=error;
            error = k0[6]-k1[6];
            if (error<0) sum-=error;else sum+=error;
            error = k0[7]-k1[7];
            if (error<0) sum-=error;else sum+=error;
            if (sum>sum_min) break;
            }
 
          if (sum<sum_min)
            {
            sum_min=sum;
            vx=j;vy=i;
            }
          else if (sum==sum_min)
            if (abs(vx)+abs(vy)>abs(i)+abs(j))
              {
              vx=j;vy=i;
              }
          }
	i0 += 2*npix;
        }
    else
      for (i=Sr_y_low;i<Sr_y_upper;i+=2)
        {
        j0=i0;
        for (j=Sr_x_low;j<Sr_x_upper;j++)
          {
          j0++;
          sum=0;
          for (k0=j0,k1=k1_start;k1<k1_end;k0+=2*npix,k1+=32)
            {
            msk = k1+mask_offset;
            if(msk[0])
              {
              error = k0[0]-k1[0];
              if (error<0) sum-=error;else sum+=error;
              }
            if(msk[1])
              {
              error = k0[1]-k1[1];
              if (error<0) sum-=error;else sum+=error;
              }
            if(msk[2])
              {
              error = k0[2]-k1[2];
              if (error<0) sum-=error;else sum+=error;
              }
            if(msk[3])
              {
              error = k0[3]-k1[3];
              if (error<0) sum-=error;else sum+=error;
              }
            if(msk[4])
              {
              error = k0[4]-k1[4];
              if (error<0) sum-=error;else sum+=error;
              }
            if(msk[5])
              {
              error = k0[5]-k1[5];
              if (error<0) sum-=error;else sum+=error;
              }
            if(msk[6])
              {
              error = k0[6]-k1[6];
              if (error<0) sum-=error;else sum+=error;
              }
            if(msk[7])
              {
              error = k0[7]-k1[7];
              if (error<0) sum-=error;else sum+=error;
              }
            if (sum>sum_min) break;
            }
 
          if (sum<sum_min)
            {
            sum_min=sum;
            vx=j;vy=i;
            }
          else if (sum==sum_min)
            if (abs(vx)+abs(vy)>abs(i)+abs(j))
              {
              vx=j;vy=i;
              }
          }
	i0 += 2*npix;
        }
    }

  *vx_out = (SInt )vx;
  *vy_out = (SInt )vy;

  return (sum_min);
}


/***********************************************************CommentBegin******
 *
 * --MB_halfpel_field_motion_estimation--
 *
 * Author :
 *      HYUNDAI - Jong Deuk Kim
 *
 * Created :
 *      07.05.98
 *
 * Purpose :
 *      half pel Field motion Estimation for MB.
 *
 * Arguments in :
 *
 * Arguments in/out :
 *
 *
 * Arguments out :
 *
 * Return values :
 *      none
 *
 * Side effects :
 *
 *
 * Description :
 *
 *
 * See also :
 *
 *
 * Modified :
 *             980729 U.Benzler, Uni Hannover : added rounding type
 *
 *
 ***********************************************************CommentEnd********/
Void
MB_halfpel_field_motion_estimation(
   SInt   *blk,
   SInt   *mask,
   SInt   *ref_Y,
   Int    npix,
   Int    offset_x,
   Int    offset_y,
   Int    Sr_x,
   Int    Sr_y,
   Int    blk_nr,
   SInt   sign,
   SInt   *vx_pel,
   SInt   *vy_pel,
   SInt   *vx_hpel_out,
   SInt   *vy_hpel_out,
   Int    *err,
   Int    rounding_type
   )
{
   err[0] = Halfpel_SAD_B( blk, mask, ref_Y, npix, offset_x, offset_y,
   		  Sr_x, Sr_y, blk_nr, sign, vx_pel[0], vy_pel[0],
   		  &vx_hpel_out[0], &vy_hpel_out[0], 0 /* top-top */,
		  err[0],rounding_type);

   err[1] = Halfpel_SAD_B( blk, mask, ref_Y, npix, offset_x, offset_y,
   		  Sr_x, Sr_y, blk_nr, sign, vx_pel[1], vy_pel[1],
   		  &vx_hpel_out[1], &vy_hpel_out[1], 1 /* top-bot */,
		  err[1],rounding_type);

   err[2] = Halfpel_SAD_B( blk, mask, ref_Y, npix, offset_x, offset_y,
   		  Sr_x, Sr_y, blk_nr, sign, vx_pel[2], vy_pel[2],
   		  &vx_hpel_out[2], &vy_hpel_out[2], 2 /* bot-top */,
		  err[2],rounding_type);

   err[3] = Halfpel_SAD_B( blk, mask, ref_Y, npix, offset_x, offset_y,
   		  Sr_x, Sr_y, blk_nr, sign, vx_pel[3], vy_pel[3],
   		  &vx_hpel_out[3], &vy_hpel_out[3], 3 /* bot-bot */,
		  err[3],rounding_type);
}


/***********************************************************CommentBegin******
 *
 * --Halfpel_SAD_B--
 *
 * Author :
 *      HYUNDAI - Jong Deuk Kim
 *
 * Created :
 *      07.05.98
 *
 * Purpose :
 *      Calculate half pel Field SAD for B-VOP.
 * 
 * Arguments in :
 *
 * Arguments in/out :
 *
 *
 * Arguments out :
 *
 * Return values :
 *      none
 *
 * Side effects :
 *
 *
 * Description :
 *
 *
 * See also :
 *
 *
 * Modified :
 *             980729 U.Benzler, Uni Hannover : added rounding type
 *
 *
 ***********************************************************CommentEnd********/
Int
Halfpel_SAD_B(
   SInt   *blk,
   SInt   *mask,
   SInt   *ref_Y,
   Int    npix,
   Int    offset_x,
   Int    offset_y,
   Int    Sr_x,
   Int    Sr_y,
   Int    blk_nr,
   SInt   sign,
   SInt   vx_pel,
   SInt   vy_pel,
   SInt   *vx_hpel_out,
   SInt   *vy_hpel_out,
   Int	  pred_mode,  /* 0:top-top, 1:top-bot, 2:bot-top, 3:bot-bot */
   Int	  err,
   Int	  rounding_type
   )
{
  Int           i,k,l;
  static SInt   vyy[9]={-2,-2,-2, 0,0, 2,2,2,0};
  static SInt   vxx[9]={-1, 0, 1,-1,1,-1,0,1,0};
  static Int    k_start[5]={0,0, 8, 8, 0};
  static Int    k_end[5]=  {8,8,16,16,16};
  static Int    l_start[5]={0, 8,0, 8, 0};
  static Int    l_end[5]=  {8,16,8,16,16};
 
  SInt          vx[9],vy[9];
  Int           pel[9],int_pel[9],a18,a86;
  Int           index1,index2,sum[9],offset[9],error;
  Int           row0,col0;
  Int           blk_size=16;
  Int		cur_off=0, ref_off=0;

  switch(pred_mode)
  {
     case 0 :  cur_off = 0; ref_off = 0;
	       break;
     case 1 :  cur_off = 0; ref_off = 1;
	       break;
     case 2 :  cur_off = 1; ref_off = 0;
	       break;
     case 3 :  cur_off = 1; ref_off = 1;
	       break;
  }
 
  /*
    0 1 2
    3 8 4
    5 6 7
  */
 
  row0 = offset_y+vy_pel;
  col0 = offset_x+vx_pel;
 
  offset[0]=(row0-2)*npix+col0-1;
  offset[1]=offset[0]+1;
  offset[2]=offset[1]+1;
  offset[3]=offset[0]+2*npix;
  offset[8]=offset[3]+1;
  offset[4]=offset[8]+1;
  offset[5]=offset[3]+2*npix;
  offset[6]=offset[5]+1;
  offset[7]=offset[6]+1;
 
  for (i=0;i<8;i++)
    sum[i]=0; sum[8] = err;
  if (sign==MBM_OPAQUE)
    for (k=k_start[blk_nr];k<k_end[blk_nr];k+=2)
      for (l=l_start[blk_nr];l<l_end[blk_nr];l++)
      {
        index1=(k+cur_off)*blk_size+l;
        index2=(k+ref_off)*npix+l;
        pel[0]=ref_Y[index2+offset[0]];
        pel[1]=ref_Y[index2+offset[1]];
        pel[2]=ref_Y[index2+offset[2]];
        pel[3]=ref_Y[index2+offset[3]];
        pel[4]=ref_Y[index2+offset[4]];
        pel[5]=ref_Y[index2+offset[5]];
        pel[6]=ref_Y[index2+offset[6]];
        pel[7]=ref_Y[index2+offset[7]];
        pel[8]=ref_Y[index2+offset[8]];

        a18=pel[1]+pel[8];
        a86=pel[8]+pel[6];
        int_pel[0]=(pel[0]+pel[3]+a18+2-rounding_type)>>2;
        int_pel[1]=(a18+1-rounding_type)>>1;
        int_pel[2]=(a18+pel[2]+pel[4]+2-rounding_type)>>2;
        int_pel[3]=(pel[3]+pel[8]+1-rounding_type)>>1;
        int_pel[4]=(pel[8]+pel[4]+1-rounding_type)>>1;
        int_pel[5]=(pel[3]+pel[5]+a86+2-rounding_type)>>2;
        int_pel[6]=(a86+1-rounding_type)>>1;
        int_pel[7]=(pel[4]+pel[7]+a86+2-rounding_type)>>2;
        int_pel[8]=pel[8];
 
        error = blk[index1]-int_pel[0];
        if (error<0) sum[0]-=error;else sum[0]+=error;
        error = blk[index1]-int_pel[1];
        if (error<0) sum[1]-=error;else sum[1]+=error;
        error = blk[index1]-int_pel[2];
        if (error<0) sum[2]-=error;else sum[2]+=error;
        error = blk[index1]-int_pel[3];
        if (error<0) sum[3]-=error;else sum[3]+=error;
        error = blk[index1]-int_pel[4];
        if (error<0) sum[4]-=error;else sum[4]+=error;
        error = blk[index1]-int_pel[5];
        if (error<0) sum[5]-=error;else sum[5]+=error;
        error = blk[index1]-int_pel[6];
        if (error<0) sum[6]-=error;else sum[6]+=error;
        error = blk[index1]-int_pel[7];
        if (error<0) sum[7]-=error;else sum[7]+=error;
      }
  else
    for (k=k_start[blk_nr];k<k_end[blk_nr];k+=2)
      for (l=l_start[blk_nr];l<l_end[blk_nr];l++)
        {
        index1=(k+cur_off)*blk_size+l;
        if (mask[index1])
          {
          index2=(k+ref_off)*npix+l;
          pel[0]=ref_Y[index2+offset[0]];
          pel[1]=ref_Y[index2+offset[1]];
          pel[2]=ref_Y[index2+offset[2]];
          pel[3]=ref_Y[index2+offset[3]];
          pel[4]=ref_Y[index2+offset[4]];
          pel[5]=ref_Y[index2+offset[5]];
          pel[6]=ref_Y[index2+offset[6]];
          pel[7]=ref_Y[index2+offset[7]];
          pel[8]=ref_Y[index2+offset[8]];
 
 
          a18=pel[1]+pel[8];
          a86=pel[8]+pel[6];
          int_pel[0]=(pel[0]+pel[3]+a18+2-rounding_type)>>2;
          int_pel[1]=(a18+1-rounding_type)>>1;
          int_pel[2]=(a18+pel[2]+pel[4]+2-rounding_type)>>2;
          int_pel[3]=(pel[3]+pel[8]+1-rounding_type)>>1;
          int_pel[4]=(pel[8]+pel[4]+1-rounding_type)>>1;
          int_pel[5]=(pel[3]+pel[5]+a86+2-rounding_type)>>2;
          int_pel[6]=(a86+1-rounding_type)>>1;
          int_pel[7]=(pel[4]+pel[7]+a86+2-rounding_type)>>2;
          int_pel[8]=pel[8];
 
          error = blk[index1]-int_pel[0];
          if (error<0) sum[0]-=error;else sum[0]+=error;
          error = blk[index1]-int_pel[1];
          if (error<0) sum[1]-=error;else sum[1]+=error;
          error = blk[index1]-int_pel[2];
          if (error<0) sum[2]-=error;else sum[2]+=error;
          error = blk[index1]-int_pel[3];
          if (error<0) sum[3]-=error;else sum[3]+=error;
          error = blk[index1]-int_pel[4];
          if (error<0) sum[4]-=error;else sum[4]+=error;
          error = blk[index1]-int_pel[5];
          if (error<0) sum[5]-=error;else sum[5]+=error;
          error = blk[index1]-int_pel[6];
          if (error<0) sum[6]-=error;else sum[6]+=error;
          error = blk[index1]-int_pel[7];
          if (error<0) sum[7]-=error;else sum[7]+=error;
          }
        }
 
  vx_pel += vx_pel;
  vy_pel += vy_pel;
  for (i=0;i<9;i++)
  {
    vx[i]=vx_pel+vxx[i];
    vy[i]=vy_pel+vyy[i];
  }
 
  for (i=0;i<8;i++)
    if ((vx[i]<-Sr_x)||(vx[i]>Sr_x-1)||(vy[i]<-Sr_y)||(vy[i]>Sr_y-1))
      sum[i]=sum[8]+1;
  k=0;
  for (i=1;i<9;i++)
    if (sum[i]<sum[k])
      k=i;

  *vx_hpel_out=vx[k];
  *vy_hpel_out=vy[k];
  

  return (sum[k]);

  *vx_hpel_out=vx_pel*2;
  *vy_hpel_out=vy_pel*2;

  return (err);
}


/***********************************************************CommentBegin******
 *
 * --FieldDirect--
 *
 * Author :
 *      HYUNDAI - Jong Deuk Kim
 *
 * Created :
 *      07.05.98
 *
 * Purpose :
 *      Field Direct Mode Motion Estimation.
 *
 * Arguments in :
 *
 * Arguments in/out :
 *
 *
 * Arguments out :
 *
 * Return values :
 *      none
 *
 * Side effects :
 *
 *
 * Description :
 *
 *
 * See also :
 *
 *
 * Modified :
 *
 *            980730 U. Benzler, Uni Hannover : added quarter pel support
 *
 ***********************************************************CommentEnd********/
Int
FieldDirect(SInt	*blk16,
	    SInt	*mask16,
	    SInt 	*prev_rec, 
	    SInt 	*next_rec,
	    SInt        *prev_rec_mb,  /* UB 980730 */
	    SInt        *next_rec_mb,  /* UB 980730 */
	    Int 	MB_mode, 
	    Int 	col, 
	    Int 	row, 
	    Int 	spat_offset_x_for, 
	    Int 	spat_offset_y_for, 
	    Int 	spat_offset_x_bak, 
	    Int 	spat_offset_y_bak, 
	    Int 	prev_vop_width, 
	    Int 	prev_vop_height, 
	    Int 	next_vop_width, 
	    Int 	next_vop_height, 
	    Int 	top_field_first, 
	    Int 	sr_direct, 
	    SInt 	*pvx, 
	    SInt 	*pvy, 
	    SInt	*vx,
	    SInt 	*vy,
	    Int 	TRB, 
	    Int 	TRD,
	    Int 	rounding_control, /* UB 980730 */
	    Int 	edge,
	    Int         quarter_pel,
	    Int 	bright_white) /* UB 980730 */
  {
    static SInt dtrt[] = {  0, 0,  1, 1, 0, 0, -1, -1 }; /* UB 980730 */
    static SInt dtrb[] = { -1, 0, -1, 0, 1, 0,  1,  0 }; /* UB 980730 */
    SInt *pred_for, *pred_bak;
    Int MVD_x, MVD_y;
    SInt ftx, fty, btx, bty, trbt, trdt;
    SInt fbx, fby, bbx, bby, trbb, trdb;
    SInt ptx, pty, pbx, pby;
    Int  fld_avi_err, error, top_off,bot_off, k, code;
    
    code = MB_mode - MBM_FIELD00;

    top_off = (code & 2) ? 1 : 0;
    bot_off = (code & 1) ? 1 : 0;

    if (top_field_first) code += 4;  /* ? */

    trdt = 2*TRD + dtrt[code];
    trbt = 2*TRB + dtrt[code];
    trdb = 2*TRD + dtrb[code];
    trbb = 2*TRB + dtrb[code];

    ptx = pvx[0]; pty = pvy[0];
    pbx = pvx[1]; pby = pvy[1];

    pred_for = (SInt *)malloc(sizeof(SInt)*MB_SIZE*MB_SIZE);
    pred_bak = (SInt *)malloc(sizeof(SInt)*MB_SIZE*MB_SIZE);

    error = 200000;

    for (MVD_y = -sr_direct; MVD_y <= sr_direct; MVD_y++) {
        for (MVD_x = -sr_direct; MVD_x <= sr_direct; MVD_x++) {
            /* Find MVs for the top field */
            ftx = (SInt)((trbt * ptx) / trdt + MVD_x);
            fty = (SInt)((trbt * pty) / trdt + MVD_y);
            btx = MVD_x ? (ftx - ptx) : (SInt)(((trbt - trdt) * ptx) / trdt);
            bty = MVD_y ? (fty - pty) : (SInt)(((trbt - trdt) * pty) / trdt);

            /* Find MVs for the bottom field */
            fbx = (SInt)((trbb * pbx) / trdb + MVD_x);
            fby = (SInt)((trbb * pby) / trdb + MVD_y);
            bbx = MVD_x ? (fbx - pbx) : (SInt)(((trbb - trdb) * pbx) / trdb);
            bby = MVD_y ? (fby - pby) : (SInt)(((trbb - trdb) * pby) / trdb);

	    if (quarter_pel) /* UB 980730 */
	      {
		ClipMV(col + spat_offset_x_for + edge, row + spat_offset_y_for + edge, prev_vop_width, prev_vop_height,
		       edge, &ftx, &fty, 4);
		InterpolateBlock((SInt*)(prev_rec_mb + top_off*prev_vop_width), prev_vop_width , ftx, (fty&~1)/*no LSB for vertical field vectors*/,
				 4 , 16 , 8 , pred_for , 32, rounding_control, bright_white);
		ClipMV(col + spat_offset_x_for + edge, row + spat_offset_y_for + edge, prev_vop_width, prev_vop_height,
		       edge, &fbx, &fby, 4);
		InterpolateBlock((SInt*)(prev_rec_mb + bot_off*prev_vop_width), prev_vop_width , fbx, (fby&~1)/*no LSB for vertical field vectors*/,
				 4 , 16 , 8 , &pred_for[16] , 32, rounding_control, bright_white);
		ClipMV(col + spat_offset_x_bak + edge, row + spat_offset_y_bak + edge, next_vop_width, next_vop_height,
		       edge, &btx, &bty, 4);
		InterpolateBlock(next_rec_mb, next_vop_width , btx, (bty&~1)/*no LSB for vertical field vectors*/,
				 4 , 16 , 8 , pred_bak , 32, rounding_control, bright_white);
		ClipMV(col + spat_offset_x_bak + edge, row + spat_offset_y_bak + edge, next_vop_width, next_vop_height,
		       edge, &bbx, &bby, 4);
		InterpolateBlock((SInt*)(next_rec_mb + next_vop_width), next_vop_width , bbx, (bby&~1)/*no LSB for vertical field vectors*/,
				 4 , 16 , 8 , &pred_bak[16] , 32, rounding_control, bright_white);
	      }
	    else
	      { /* UB 980730 */
		halfpel_field_compensation(prev_rec,ftx,fty,
					   col+spat_offset_x_for,
					   row+spat_offset_y_for,
					   prev_vop_width,prev_vop_height,
					   16,16,2,rounding_control,edge,pred_for,1, top_off);
		
		halfpel_field_compensation(prev_rec,fbx,fby,
					   col+spat_offset_x_for,
					   row+spat_offset_y_for,
					   prev_vop_width,prev_vop_height,
					   16,16,2,rounding_control,edge,pred_for, 0 /*bottom*/,bot_off);
		
		halfpel_field_compensation(next_rec,btx,bty,
					   col+spat_offset_x_bak,
					   row+spat_offset_y_bak,
                                      next_vop_width,next_vop_height,
					   16,16,2,rounding_control,edge,pred_bak,1/*top*/, 0);
		
		halfpel_field_compensation(next_rec,bbx,bby,
					   col+spat_offset_x_bak,
					   row+spat_offset_y_bak,
					   next_vop_width,next_vop_height,
					   16,16,2,rounding_control,edge,pred_bak, 0 /*bottom*/,1);
	      }

            fld_avi_err = 0;
            for(k=0; k<256; k++)
              if (mask16[k])
              {
                pred_for[k]=(pred_for[k]+pred_bak[k]+1)>>1;
                fld_avi_err+=abs(blk16[k]-pred_for[k]);
              }  
	    if(fld_avi_err < error)
	    {
		error = fld_avi_err;
		*vx = MVD_x;
		*vy = MVD_y;             
	    }
	    else if( fld_avi_err == error)
	    {
		if(abs(MVD_x)+abs(MVD_y) < abs(*vx)+abs(*vy))
		{
		    *vx = MVD_x;
		    *vy = MVD_y;
		}
	    }
        }
    }
    free(pred_for);
    free(pred_bak);
 
    return (error);
}

