/******************************************************************************
 *
 * This software module was originally developed by
 *
 *      Ji Heon Kweon (HYUNDAI)
 *
 * in the course of development of the MPEG-4 Video (ISO/IEC 14496-2) standard.
 * This software module is an implementation of a part of one or more MPEG-4
 * Video (ISO/IEC 14496-2) tools as specified by the MPEG-4 Video (ISO/IEC
 * 14496-2) standard.
 *
 * ISO/IEC gives users of the MPEG-4 Video (ISO/IEC 14496-2) standard free
 * license to this software module or modifications thereof for use in hardware
 * or software products claiming conformance to the MPEG-4 Video (ISO/IEC
 * 14496-2) standard.
 *
 * Those intending to use this software module in hardware or software products
 * are advised that its use may infringe existing patents. The original
 * developer of this software module and his/her company, the subsequent
 * editors and their companies, and ISO/IEC have no liability for use of this
 * software module or modifications thereof in an implementation. Copyright is
 * not released for non MPEG-4 Video (ISO/IEC 14496-2) standard conforming
 * products.
 *
 * ACTS-MoMuSys partners retain full right to use the code for his/her own
 * purpose, assign or donate the code to a third party and to inhibit third
 * parties from using the code for non MPEG-4 Video (ISO/IEC 14496-2) standard
 * conforming products. This copyright notice must be included in all copies or
 * derivative works.
 *
 * Copyright (c) 1998
 *
 *****************************************************************************/

/***********************************************************HeaderBegin*******
 *
 * File:        alp_code_grey.c
 *
 * Author:      HYUNDAI - Ji Hweon Kweon
 * Created:     21-05-98
 *
 * Description:
 *
 * Notes:
 *
 * Modified:
 *
 ***********************************************************HeaderEnd*********/

#include <stdio.h>
#include <sys/stat.h>
#include "momusys.h"
#include "mom_access.h"
#include "mom_image.h"
#include "vm_enc_defs.h"
#include "vm_common_defs.h"
#include "mot_est.h"            /* because of MBM_INTRA */
#include "mom_bitstream_i.h"
#include "text_util.h"
#include "text_bits.h"
#include "text_quant.h"
#include "putvlc.h"
#include "text_code_mb.h"
#include "alp_code_grey.h"
#include "zigzag.h"             /* added 14-NOV-1996 MW */

#include "vm_config.h"
#include "text_code.h"


/* 08.02.99 HHI Schueuer */
#include "sadct_bsnrmem.h"
#include "sadct.h"
#include "sadct_s_k.h"
#include "sadct_momusys.h"
#include "sadct_momusys_kaup.h"
#include "sadct_momusys_s_k.h"
/* end HHI */

#define OPAQUE 255
#define MIDOPAQUE 128


void
ObtainSupport(Image *AlphaPlain)
{
  Int i;
  Short *alpha = (Short *) GetImageData(AlphaPlain);
 
  for (i=0;i<GetImageSizeY(AlphaPlain)*GetImageSizeX(AlphaPlain);i++)
    alpha[i] = (alpha[i]>0) ? BINARY_ALPHA : 0;
}

void
InvertAlpha(Image *AlphaPlain)
{
  Int i;
  Short *alpha = (Short *) GetImageData(AlphaPlain);
 
  for (i=0;i<GetImageSizeY(AlphaPlain)*GetImageSizeX(AlphaPlain);i++)
    alpha[i] = (alpha[i]>0) ? 0 : BINARY_ALPHA;
}

void
CodeGrayscaleAlpha(
        Bits *bits,
        Vop *curr,
        Vop *rec_curr,
        Int MB_width,
        Int mb_x,
        Int mb_y,
        Int ***DC_store,
        SInt *QP_store,
        Int QP,
        Int Mode,
        Int MB_transp_pattern[4],
        Image *shape_bitstream,
        Int aux_comp )
{
  Int i,j,k,l,m,n;
  Image *mblock;
  Short *pixel;
  Int alpha_mb_all_opaque=0;
  Int alpha_residue_all_zero=0;
  Int fblock[8][8];
  Int coeff[64];
  Int *coeff_ind = coeff;
  Int qcoeff[256];
  Int *qcoeff_ind;
  Int rcoeff[256];
  Int *rcoeff_ind;
  Image *currentImage;
  SInt *recon;
  Int CBPA=0;                   /* JDL 21-APR-97 : initialised CBPA */
  Int block_nr;
  Int *qmat;
  Int direction[4];
  Int ACpred_flag = -1;
  Int dc_scaler;

  /* 05.02.99 HHI Schueuer */
  /* variables for the sadct */
  Short *alpha_pntr = (Short *)(GetImageData(GetVopA(rec_curr)));
  Short alpha_block[4][8][8];
  Short alpha_buf[4][8][8];
  Short nrpix = GetImageSizeX(GetVopA(rec_curr));
  Int active_pels[4];
  Int x1, y1;
  Int nr;
  /* end HHI */

  currentImage = GetVopG(aux_comp,curr);
  recon = (SInt *) GetImageData(GetVopG(aux_comp,rec_curr));

  
 
  mblock = AllocImage(16,16,SHORT_TYPE);
  GetSubImage(currentImage,mblock,mb_x*MB_SIZE,mb_y*MB_SIZE);
  pixel = (Short *)GetImageData(mblock);
 
  QP_store[mb_y*MB_width+mb_x] = (SInt) QP;

  /* Ref(start) : MS TestMemo 3 */
  dc_scaler = cal_dc_scaler(QP,1);
 
  alpha_mb_all_opaque = 1;
  for (i=0; i<MB_SIZE; i++)
    for (j=0; j<MB_SIZE; j++)
      if(pixel[i*MB_SIZE+j] != OPAQUE)   /* Ref(insert) : MS TestMemo 4 */
	alpha_mb_all_opaque = 0;

  /* 05.02.99 HHI Schueuer */
  for (k = 0; k < 4; k++)
    for (i = 0; i < 8; i++)
      for (j = 0; j < 8; j++)
	alpha_buf[k][i][j]=alpha_block[k][i][j]=BINARY_ALPHA;

  
  if (GetVopSADCTDisable(curr) == 0) {
      for (i = 0; i < 8; i++) {
	for (j = 0; j < 8; j++) {
	  alpha_block[0][i][j] = alpha_pntr[((mb_y * MB_SIZE) + i) * nrpix + ((mb_x * MB_SIZE) + j)];
	  alpha_block[1][i][j] = alpha_pntr[((mb_y * MB_SIZE) + i) * nrpix + ((mb_x * MB_SIZE) + j + 8)];
	  alpha_block[2][i][j] = alpha_pntr[((mb_y * MB_SIZE) + i + 8) * nrpix + ((mb_x * MB_SIZE) + j)];
	  alpha_block[3][i][j] = alpha_pntr[((mb_y * MB_SIZE) + i + 8) * nrpix + ((mb_x * MB_SIZE) + j + 8)];
	}
      }
  }

  for (k = 0; k < 4; k++) {
    sadct_rowlength_out(k, alpha_block[k], 8, 8);
    active_pels[k] = 0;
    for (x1 = 0; x1 < 8; x1++)
      for (y1 = 0; y1 < 8; y1++)
	if(alpha_block[k][x1][y1] == BINARY_ALPHA)
	  active_pels[k]++;
  }

  if ( (active_pels[0] != 64) || (active_pels[1] != 64) || (active_pels[2] != 64) || (active_pels[3] != 64))
    alpha_mb_all_opaque = 0;
  

  /* end HHI */
 
  if ((Mode == MODE_INTRA) || (Mode == MODE_INTRA_Q)) {
    /* writing CODA */
    BitstreamPutBits(shape_bitstream, alpha_mb_all_opaque, 1);
    bits->CODA += 1;
  } else {
      alpha_residue_all_zero = 1;
        for (i=0; i<MB_SIZE; i++)
          for (j=0; j<MB_SIZE; j++)
            if(pixel[i*MB_SIZE+j] != 0)
              alpha_residue_all_zero = 0;
 
        if(alpha_residue_all_zero) {
          BitstreamPutBits(shape_bitstream, 1, 1);
          bits->CODA += 1;
        } else if(alpha_mb_all_opaque) {
            BitstreamPutBits(shape_bitstream, 1, 2);
            bits->CODA += 2;
        } else {
            BitstreamPutBits(shape_bitstream, 0, 2);
            bits->CODA += 2;
        }

  }
 
  if ((!alpha_mb_all_opaque  ) && !alpha_residue_all_zero) {
 
  if ((Mode == MODE_INTRA) || (Mode == MODE_INTRA_Q)) {
 
      block_nr=0;
      /* 08.02.99 HHI Schueuer: TODO : ersetzen durch block_nr */
      nr = 0;
      /* end HHI */
      for (i=0; i<MB_SIZE; i+=8)
        for (j=0; j<MB_SIZE; j+=8) {	  

          qcoeff_ind = &(qcoeff[block_nr*64]);
          rcoeff_ind = &(rcoeff[block_nr*64]);
 
          if(MB_transp_pattern[block_nr]!=1) {
            for (k=0; k<8; k++) 
              for (l=0; l<8; l++)
                fblock[k][l] = pixel[(i+k)*MB_SIZE + (j+l)];

	    /* 08.02.99 HHI Schueuer */
	    if ((GetVopSADCTDisable(curr)!=0) || (active_pels[nr] == 64) ) {
	      BlockDCT (fblock, coeff_ind);
	    }
	    else {
	      BlockSADCT_s_k (fblock, coeff_ind, alpha_block[nr]);
	    }
	    /* end HHI */
	      
 
            /* MW 22-APR-1997 Changes for MPEG quantization */
 
            if(GetVopQuantType(curr))
              {
                if(Mode==MODE_INTRA || Mode==MODE_INTRA_Q)
                  qmat = GetVopGrayIntraQuantMat(aux_comp,curr);
                else
                  qmat = GetVopGrayNonintraQuantMat(aux_comp,curr);
 
                /* Ref(start) : MS TestMemo 1 */
                BlockQuantMPEG(coeff_ind,QP,Mode,1,qmat,qcoeff_ind,OPAQUE,2);
                BlockDequantMPEG(qcoeff_ind,QP,Mode,1,qmat,rcoeff_ind,2);
                /* Ref(end) : MS TestMemo 1 */
              }
            else {
              /* Ref(start) : MS TestMemo 1 */
              BlockQuantH263(coeff_ind,QP,Mode,1,qcoeff_ind,OPAQUE,2);
              BlockDequantH263(qcoeff_ind,QP,Mode,1,rcoeff_ind,2, 0, GetVopBitsPerPixel(curr));
              /* Ref(end) : MS TestMemo 1 */
            }

	    /* 08.02.99 HHI Schueuer */
	    if ((GetVopSADCTDisable(curr)!=0) || (active_pels[nr] == 64) ) 
	      BlockIDCT (rcoeff_ind, fblock, OPAQUE);
	    else
	      BlockSAIDCT_s_k (rcoeff_ind, fblock, alpha_block[nr]);
	    /* end HHI */
 
            for (k=0;k<8;k++)
              for (l=0;l<8;l++)
                fblock[k][l] =  MIN(OPAQUE,MAX(0,fblock[k][l]));  /* intra clipping */
 
            for(k=1; k<64; k++)
              if (*(qcoeff_ind+k))
                  CBPA |= 1<<(3-block_nr);
 
            /* Store the qcoeff-values needed later for prediction */
            if(GetVopIntraACDCPredDisable(curr) == 0) {
              DC_store[mb_y*MB_width+mb_x][block_nr][0] = *(qcoeff_ind) * cal_dc_scaler(QP,1);              

              for (m = 1; m < 8; m++)
                DC_store[mb_y*MB_width+mb_x][block_nr][m] = *(qcoeff_ind+m);
 
              for (m = 0; m < 7; m++)
                DC_store[mb_y*MB_width+mb_x][block_nr][m+8] = *(qcoeff_ind+(m+1)*8);
            }

	  }
        else {
          for(k=0; k<64; k++)
            *(qcoeff_ind+k) = 0;
          for (k=0; k<8; k++)
            for (l=0; l<8; l++)
              fblock[k][l] = 0;
 
          /* overwrite the DC_store with QDC = MIDOPAQUE for transparent blocks */
          if(GetVopIntraACDCPredDisable(curr) == 0)
            DC_store[mb_y*MB_width+mb_x][block_nr][0] = MIDOPAQUE*8;
        }
 
        for (k=0; k<8; k++)
          for (l=0; l<8; l++)
            recon[(mb_y*MB_SIZE+i+k)*GetImageSizeX(GetVopG(aux_comp,rec_curr)) + (mb_x*MB_SIZE+j+l)]
              = (SInt)fblock[k][l];
 
        block_nr++;
	nr++;
      }  
 
      if(GetVopIntraACDCPredDisable(curr) == 0)
         {
           ACpred_flag = doDCACpred_grey(
                                qcoeff,
                                &CBPA,
                                64,
                                mb_x,
                                mb_y,
                                DC_store,
                                QP_store,
                                QP,
                                MB_width,
                                direction,
                                MIDOPAQUE,
                                GetVopSADCTDisable(curr) || (GetVopShape(curr)==RECTANGULAR));
           BitstreamPutBits(shape_bitstream, (long)ACpred_flag, 1L);
           bits->g_ACpred_flag += 1;
         }
      else
        ACpred_flag = -1;
 
      /* CBPA */
      bits->CBPA += PutCBPY(CBPA,0,MB_transp_pattern,shape_bitstream); /* Ref(insert) : MS TestMemo 5 */
 
      CodeAlphaBlockData(
                                bits,
                                MB_transp_pattern,
                                qcoeff,
                                Mode,
                                CBPA,
                                64,
                                GetVopIntraACDCPredDisable(curr),
                                shape_bitstream,
                                direction,
				GetVopSADCTDisable(curr));
 
    }
    else {      /* P-VOP and not an intra-MB */
 
      block_nr=0;

      /* 08.02.99 HHI Schueuer */
      nr = 0;
      /* end HHI */
      
      for (i=0; i<MB_SIZE; i+=8)
        for (j=0; j<MB_SIZE; j+=8) {
          qcoeff_ind = &(qcoeff[block_nr*64]);
          rcoeff_ind = &(rcoeff[block_nr*64]);
 
          if(MB_transp_pattern[block_nr]!=1) {
            for (k=0; k<8; k++)
              for (l=0; l<8; l++)
                fblock[k][l] = pixel[(i+k)*MB_SIZE + (j+l)];

	    /* 08.02.99 HHI Schueuer */
	    if ((GetVopSADCTDisable(curr)!=0) || (active_pels[nr] == 64) ) 
	      BlockDCT (fblock, coeff_ind);
	    else
	      BlockSADCT_Kaup (fblock, coeff_ind, alpha_block[nr]);
	    /* end HHI */
	      
            if(GetVopQuantType(curr))
              {
                if(Mode==MODE_INTRA || Mode==MODE_INTRA_Q)
                  qmat = GetVopGrayIntraQuantMat(aux_comp,curr);
                else
                  qmat = GetVopGrayNonintraQuantMat(aux_comp,curr);
 
                /* Ref(start) : MS TestMemo 1 */
                BlockQuantMPEG(coeff_ind,QP,Mode,1,qmat,qcoeff_ind,OPAQUE,2);
                BlockDequantMPEG(qcoeff_ind,QP,Mode,1,qmat,rcoeff_ind,2);
                /* Ref(end) : MS TestMemo 1 */
              }
            else {
              /* Ref(start) : MS TestMemo 1 */
              BlockQuantH263(coeff_ind,QP,Mode,1,qcoeff_ind,OPAQUE,2);
              BlockDequantH263(qcoeff_ind,QP,Mode,1,rcoeff_ind,2, 0, GetVopBitsPerPixel(curr));
              /* Ref(end) : MS TestMemo 1 */
            }

	    /* 08.02.99 HHI Schueuer */
	    if ((GetVopSADCTDisable(curr)!=0) || (active_pels[nr] == 64) ) 
	      BlockIDCT (rcoeff_ind, fblock,OPAQUE);
	    else
	      BlockSAIDCT_Kaup (rcoeff_ind, fblock, alpha_block[nr]);
	    /* end HHI */
	      
            for(k=0; k<64; k++)
                if (*(qcoeff_ind+k))
                  CBPA |= 1<<(3-block_nr);
      } else {
          for(k=0; k<64; k++)
            *(qcoeff_ind+k) = 0;
          for (k=0; k<8; k++)
            for (l=0; l<8; l++)
              fblock[k][l] = 0;
      }  

	  
      for (k=0; k<8; k++)
        for (l=0; l<8; l++)
          recon[(mb_y*MB_SIZE+i+k)*GetImageSizeX(GetVopG(aux_comp,rec_curr)) + (mb_x*MB_SIZE+j+l)]
            = (SInt)fblock[k][l];
 
      DC_store[mb_y*MB_width+mb_x][block_nr][0] = MIDOPAQUE*8;
 
      block_nr++;
      /* 08.02.99 HHI Schueuer */
      nr++;
      /* end HHI */
    }
 
    /* CBPA */
    bits->CBPA += PutCBPY(CBPA,0,MB_transp_pattern,shape_bitstream);

    CodeAlphaBlockData(
                                bits,
                                MB_transp_pattern,
                                qcoeff,
                                Mode,
                                CBPA,
                                64,
                                GetVopIntraACDCPredDisable(curr),
                                shape_bitstream,
                                direction,
				GetVopSADCTDisable(curr));
 
    }
  }
  else {
    if(alpha_mb_all_opaque) {
      for (i=0; i<MB_SIZE; i++)
        for (j=0; j<MB_SIZE; j++)
          recon[(mb_y*MB_SIZE+i)*GetImageSizeX(GetVopG(aux_comp,rec_curr))
               + (mb_x*MB_SIZE+j)] = (SInt)OPAQUE;
      if ((Mode == MODE_INTRA) || (Mode == MODE_INTRA_Q)) {
      /* Ref(start) : MS TestMemo 3 */
        for (m = 0; m < 4; m++) {
           DC_store[mb_y*MB_width+mb_x][m][0]
                = (((OPAQUE*8) + (dc_scaler>>1)) / dc_scaler) * dc_scaler;
           for(n=1; n<15; n++)
             DC_store[mb_y*MB_width+mb_x][m][n] = 0;
        /* Ref(end) : MS TestMemo 3 */
        }
      } else {
          for (m = 0; m < 4; m++) {
             DC_store[mb_y*MB_width+mb_x][m][0] = MIDOPAQUE*8;
             for(n=1; n<15; n++)
               DC_store[mb_y*MB_width+mb_x][m][n] = 0;
          }
      }  
    } else {
      for (m = 0; m < 4; m++) {
         DC_store[mb_y*MB_width+mb_x][m][0] = MIDOPAQUE*8;
         for(n=1; n<15; n++)
           DC_store[mb_y*MB_width+mb_x][m][n] = 0;
      }  
 
      for (i=0; i<MB_SIZE; i++)
        for (j=0; j<MB_SIZE; j++)
          recon[(mb_y*MB_SIZE+i)*GetImageSizeX(GetVopG(aux_comp,rec_curr)) + (mb_x*MB_SIZE+j)] = (SInt)0;
    }
  }
 
  FreeImage(mblock);
}
 
 
void
B_CodeGrayscaleAlpha(
        Bits *bits,
        Vop *curr,
        Vop *rec_curr,
        Int MB_width,
        Int mb_x,
        Int mb_y,
        Int QP,
        Int MB_transp_pattern[4],
        Image *shape_bitstream,
        Int aux_comp )
{
  Int i,j,k,l;
  Image *mblock;
  Short *pixel;
  Int alpha_mb_all_opaque=0;
  Int alpha_residue_all_zero=0;
  Int fblock[8][8];
  Int coeff[64];
  Int *coeff_ind = coeff;
  Int qcoeff[256];
  Int *qcoeff_ind;
  Int rcoeff[256];
  Int *rcoeff_ind;
  Image *currentImage;
  SInt *recon;
  Int CBPA=0;                   /* JDL 21-APR-97 : initialised CBPA */
  Int block_nr;
  Int *qmat;
  Int direction[4];
  /* 10.02.99 HHI Schueuer */
  /* variables for the sadct */
  Short *alpha_pntr = (Short *)(GetImageData(GetVopA(rec_curr)));
  Short alpha_block[4][8][8];
  Short alpha_buf[4][8][8];
  Short nrpix = GetImageSizeX(GetVopA(rec_curr));
  Int active_pels[4];
  Int x1, y1;
  /* end HHI */  
 
 
  currentImage = GetVopG(aux_comp,curr);
  recon = (SInt *) GetImageData(GetVopG(aux_comp,rec_curr));
 
  mblock = AllocImage(16,16,SHORT_TYPE);
  GetSubImage(currentImage,mblock,mb_x*MB_SIZE,mb_y*MB_SIZE);
  pixel = (Short *)GetImageData(mblock);

  /* 10.02.99 HHI Schueuer */
  for (k = 0; k < 4; k++)
    for (i = 0; i < 8; i++)
      for (j = 0; j < 8; j++)
	alpha_buf[k][i][j]=alpha_block[k][i][j]=BINARY_ALPHA;

  
  if (GetVopSADCTDisable(curr) == 0) {
      for (i = 0; i < 8; i++) {
	for (j = 0; j < 8; j++) {
	  alpha_block[0][i][j] = alpha_pntr[((mb_y * MB_SIZE) + i) * nrpix + ((mb_x * MB_SIZE) + j)];
	  alpha_block[1][i][j] = alpha_pntr[((mb_y * MB_SIZE) + i) * nrpix + ((mb_x * MB_SIZE) + j + 8)];
	  alpha_block[2][i][j] = alpha_pntr[((mb_y * MB_SIZE) + i + 8) * nrpix + ((mb_x * MB_SIZE) + j)];
	  alpha_block[3][i][j] = alpha_pntr[((mb_y * MB_SIZE) + i + 8) * nrpix + ((mb_x * MB_SIZE) + j + 8)];
	}
      }
  }

  for (k = 0; k < 4; k++) {
    sadct_rowlength_out(k, alpha_block[k], 8, 8);
    active_pels[k] = 0;
    for (x1 = 0; x1 < 8; x1++)
      for (y1 = 0; y1 < 8; y1++)
	if(alpha_block[k][x1][y1] == BINARY_ALPHA)
	  active_pels[k]++;
  }

  /* end HHI */
  
  alpha_mb_all_opaque = 1;
    for (i=0; i<MB_SIZE; i++)
      for (j=0; j<MB_SIZE; j++)
        if(pixel[i*MB_SIZE+j] != OPAQUE)   /* Ref(insert) : MS TestMemo 4 */
          alpha_mb_all_opaque = 0;
 
  alpha_residue_all_zero = 1;
    for (i=0; i<MB_SIZE; i++)
      for (j=0; j<MB_SIZE; j++)
        if(pixel[i*MB_SIZE+j] != 0)
          alpha_residue_all_zero = 0;
 
    if(alpha_residue_all_zero) {
        BitstreamPutBits(shape_bitstream, 1, 1);
        bits->CODA += 1;
    } else if(alpha_mb_all_opaque) {
        BitstreamPutBits(shape_bitstream, 1, 2);
        bits->CODA += 2;
    } else {
        BitstreamPutBits(shape_bitstream, 0, 2);
        bits->CODA += 2;
    }
 
  if (!alpha_mb_all_opaque && !alpha_residue_all_zero) {
 
      block_nr=0;
      for (i=0; i<MB_SIZE; i+=8)
        for (j=0; j<MB_SIZE; j+=8) {
          qcoeff_ind = &(qcoeff[block_nr*64]);
          rcoeff_ind = &(rcoeff[block_nr*64]);
 
          if(MB_transp_pattern[block_nr]!=1) {
            for (k=0; k<8; k++)
              for (l=0; l<8; l++)
                fblock[k][l] = pixel[(i+k)*MB_SIZE + (j+l)];

	    /* 10.02.99 HHI Schueuer */
	    if ((GetVopSADCTDisable(curr)!=0) || (active_pels[block_nr] == 64) )
	      BlockDCT (fblock, coeff_ind);
	    else
	      BlockSADCT_Kaup (fblock, coeff_ind, alpha_block[block_nr]);
	    /* end HHI */
 
            if(GetVopQuantType(curr))
              {
                qmat = GetVopGrayNonintraQuantMat(aux_comp,curr);
 
                /* Ref(start) : MS TestMemo 1 */
                BlockQuantMPEG(coeff_ind,QP,MODE_INTER,1,qmat,qcoeff_ind,OPAQUE,2);
                BlockDequantMPEG(qcoeff_ind,QP,MODE_INTER,1,qmat,rcoeff_ind,2);
                /* Ref(end) : MS TestMemo 1 */
              }
            else {
              /* Ref(start) : MS TestMemo 1 */
              BlockQuantH263(coeff_ind,QP,MODE_INTER,1,qcoeff_ind,OPAQUE,2);
              BlockDequantH263(qcoeff_ind,QP,MODE_INTER,1,rcoeff_ind,2, 0, GetVopBitsPerPixel(curr));
              /* Ref(end) : MS TestMemo 1 */
            }

	    /* 10.02.99 HHI Schueuer */
	    if ((GetVopSADCTDisable(curr)!=0) || (active_pels[block_nr] == 64) ) 
	      BlockIDCT (rcoeff_ind, fblock,OPAQUE);
	    else
	      BlockSAIDCT_Kaup (rcoeff_ind, fblock, alpha_block[block_nr]);
	    /* end HHI */
 
            for(k=0; k<64; k++)
                if (*(qcoeff_ind+k))
                  CBPA |= 1<<(3-block_nr);
      } else {
          for(k=0; k<64; k++)
            *(qcoeff_ind+k) = 0;
          for (k=0; k<8; k++)
            for (l=0; l<8; l++)
              fblock[k][l] = 0;
      }  
 
      for (k=0; k<8; k++)
        for (l=0; l<8; l++)
          recon[(mb_y*MB_SIZE+i+k)*GetImageSizeX(GetVopG(aux_comp,rec_curr)) + (mb_x*MB_SIZE+j+l)]
            = (SInt)fblock[k][l];
 
        block_nr++;
    }
 
    /* CBPA */
    bits->CBPA += PutCBPY(CBPA,0,MB_transp_pattern,shape_bitstream);
 
    CodeAlphaBlockData(
                                bits,
                                MB_transp_pattern,
                                qcoeff,
                                MODE_INTER,
                                CBPA,
                                64,
                                GetVopIntraACDCPredDisable(curr),
                                shape_bitstream,
                                direction,
				GetVopSADCTDisable(curr));
 
  }
  else {
    if(alpha_mb_all_opaque) {
      for (i=0; i<MB_SIZE; i++)
        for (j=0; j<MB_SIZE; j++)
          recon[(mb_y*MB_SIZE+i)*GetImageSizeX(GetVopG(aux_comp,rec_curr))
               + (mb_x*MB_SIZE+j)] = (SInt)OPAQUE;
    } else {
      for (i=0; i<MB_SIZE; i++)
        for (j=0; j<MB_SIZE; j++)
          recon[(mb_y*MB_SIZE+i)*GetImageSizeX(GetVopG(aux_comp,rec_curr)) + (mb_x*MB_SIZE+j)] = (SInt)0;
    }
  }
 
  FreeImage(mblock);
}




Void CodeAlphaBlockData (Bits *bits, Int transp_pattern[], Int *qcoeff, Int Mode, Int
			 CBPA, Int ncoeffs,
                         Int intra_dcpred_disable, Image *bitstream, Int direction[],
			 Int sadct_disable)
{
    Int i, m, coeff[64];
    Int switched = 0; /* Ref : MS TestMemo 2 */
    Int reverse_vlc = 0; /* Error Resilient Enable Mode is not supported in this s/w version */

    /* 08.02.99 HHI Schueuer */
    Int sadct_used_alpha[4];
    for (i = 0; i < 4; i++)
      sadct_used_alpha[i] = 0;
    if (sadct_disable == 0) 
      SADCT_Used_Decision_alpha(sadct_used_alpha);
    /* end HHI */
    
    if (Mode == MODE_INTRA || Mode == MODE_INTRA_Q)
      {  
            for (i = 0; i < 4; i++)
              {  
                if (transp_pattern[i]!=1) /* Not transparent */
                  {
                    /* Do the zigzag scanning of coefficients */
		    /* 08.02.99 HHI Schueuer */
		    if (sadct_used_alpha[i]) { 
		      SADCT_Scan(&qcoeff[i*ncoeffs], coeff, i, direction[i]);
		    }
		    else { /* end HHI */
		      for (m = 0; m < 64; m++)
			{
			  if (direction[i] == 0)
                            *(coeff + zigzag[m]) = qcoeff[i*ncoeffs+m];
			  else if (direction[i] == 1)
                            *(coeff + zigzag_v[m]) = qcoeff[i*ncoeffs+m];
			  else if (direction[i] == 2)
                            *(coeff + zigzag_h[m]) = qcoeff[i*ncoeffs+m];
			  else
			    {
			      fprintf(stderr, "MB_CodeCoeff(): Error in zigzag direction\n");
			      exit(-1);
			    }
			}
                    }
 
                if (switched==0)
                      bits->G += IntraDC_dpcm(coeff[0],1,bitstream);
 
                    /* Code AC coeffs. dep. on block pattern MW 15-NOV-1996 */
                    if ((i==0 && CBPA&8) ||
                        (i==1 && CBPA&4) ||
                        (i==2 && CBPA&2)  ||
                        (i==3 && CBPA&1))
                      {  
                        if (!reverse_vlc)
                              bits->G += CodeCoeff(1-switched,Mode, coeff,i,ncoeffs,bitstream);
                        else
                              bits->G += CodeCoeff_RVLC(1-switched,Mode, coeff, i,
                                                        ncoeffs, bitstream);
                      }  
                  }
              }
      }
      else        /* inter block encoding */
      {
        for (i = 0; i < 4; i++)
          {
 
           if (transp_pattern[i]!=1) { /* Not transparent */
	     /* Do the zigzag scanning of coefficients */
	     /* 08.02.99 HHI Schueuer */
	     if (sadct_used_alpha[i]) {
	       SADCT_Scan(&qcoeff[i*ncoeffs], coeff, i, 0);
	     }       
	     else { /* end HHI */
	       for (m = 0; m < 64; m++)
		 *(coeff + zigzag[m]) = qcoeff[i*ncoeffs+m];
	     }
 
              if ((i==0 && CBPA&8) ||
                  (i==1 && CBPA&4) ||
                  (i==2 && CBPA&2) ||
                  (i==3 && CBPA&1))
                {
                  if (!reverse_vlc)
                        bits->G += CodeCoeff(0,Mode, coeff, i, ncoeffs, bitstream);
                  else
                        bits->G += CodeCoeff_RVLC(0,Mode, coeff, i, ncoeffs,
                                                bitstream);
         
                }
            }
         }
      }     
}        
 




















