/******************************************************************************
 * This software module was originally developed by
 *	Seishi TAKAMURA (NTT)
 * in the course of development of the <MPEG-4 Video(ISO/IEC 14496-2)>
 * standard.  This software module is an implementation of a part of
 * one or more MPEG-4 Video(ISO/IEC 14496-2) standard tools as
 * specified by the MPEG-4 Video(ISO/IEC 14496-2) standard.  ISO/IEC
 * gives users of the MPEG-4 Video(ISO/IEC 14496-2) standard free
 * license to this software module or modifications thereof for use in
 * hardware or software products claiming conformance to the MPEG-4
 * Video(ISO/IEC 14496-2) standard.  Those intending to use this
 * software module in hardware or software products are advised that
 * its use may infringe existing patents.  THE ORIGINAL DEVELOPER OF
 * THIS SOFTWARE MODULE AND HIS/HER COMPANY, THE SUBSEQUENT EDITORS
 * AND THEIR COMPANIES, AND ISO/IEC HAVE NO LIABILITY FOR USE OF THIS
 * SOFTWARE MODULE OR MODIFICATIONS THEREOF.  No license to this
 * software module is granted for non MPEG-4 Video(ISO/IEC 14496-2)
 * standard conforming products. NTT retains full right to use the
 * software module for his/her own purpose, assign or donate the
 * software module to a third party and to inhibit third parties from
 * using the code for non MPEG-4 Video(ISO/IEC 14496-2) standard
 * conforming products.  This copyright notice must be included in all
 * copies or derivative works of the software module.
 *
 * Copyright (C) 1999.
 *****************************************************************************/

/*************************************************HeaderBegin****************
 *
 * File:	GMC.c
 *
 * Author:	Seishi TAKAMURA (NTT)
 * Created:	03.03.99
 *                                                                          
 * Description: GMC coding tool
 *
 * Notes: 	
 *
 * Modified:	
 *
 *************************************************HeaderEnd******************/

/************************    INCLUDE FILES    ********************************/
#include <sys/stat.h>
#include "mot_util.h"
#include "GMC.h"

/***********************************************************CommentBegin******
 *
 * -- calcSAD_GME -- calculation SAD for GMC prediction MB
 *
 * Author :		
 *	Seishi TAKAMURA (NTT)
 *
 * Created :		
 *	03.03.99
 *
 * Purpose :		
 *	calculation SAD for GMC prediction MB
 * 
 * Arguments in : 	
 *	SInt	*curr		current Y-signal data
 *	SInt	*alpha		current alpha plane data
 *	Vop	*prev_rec_vop	previous Vop data
 *	Vop	*curr_vop	current Vop data
 *	Int	br_width	current Vop width size
 *	Int	Col		MB left top coodinate (x)
 *      Int	Row		MB left top coodinate (y)
 *
 * Arguments in/out :	
 *
 * Arguments out :	
 *
 * Return values :	
 *	Int	SAD		SAD value
 *	
 * Side effects :	
 *	
 * Description :	
 *
 * See also :
 *
 * Modified :		
 *
 ***********************************************************CommentEnd********/
Int
calcSAD_GME(SInt	*curr, 
	    SInt	*alpha, 
	    Vop		*prev_rec_vop,
	    Vop		*curr_vop,
	    Int		br_width, 
	    Int		Col, 
	    Int		Row)
{
    Int		k, l, i;
    SInt	predict[16][16];
    SInt	*curr_block	= (SInt*)LoadArea(curr, Col, Row, MB_SIZE, MB_SIZE, br_width);
    SInt	*alpha_block	= (SInt*)LoadArea(alpha,Col, Row, MB_SIZE, MB_SIZE, br_width);
    Int		SAD		= 0;	/* return value */

    /* Making GMC block */
    if (GetPred_GMC(predict, Col, Row, curr_vop, GetVopY(prev_rec_vop),
		    GetVopHorSpatRef(prev_rec_vop), GetVopVerSpatRef(prev_rec_vop))) {
	/* caluculation SAD */
	for (k = 0, i = 0; k < MB_SIZE; k++) {
	    for (l = 0; l < MB_SIZE; l++, i++) {
		if (alpha_block[i]) {
		    SAD += abs(predict[k][l] - curr_block[i]);
		}
	    }
	}
    } else {
	/* warping error */
	SAD = MV_MAX_ERROR;
    }

    free(curr_block);
    free(alpha_block);

    return (SAD);
}
