/* header file for TM-5 rate control */

struct tm5rc {
    Int     Xi;         /* I-picture complexity */
    Int     Xp;         /* P-picture complexity */
    Int     Xb;         /* B-picture complexity */
    Int     r_tm5;      /* Reaction parameter */
    Int     d0i;        /* I-pic virtual buffer occupancy */
    Int     d0p;        /* P-pic virtual buffer occupancy */
    Int     d0b;        /* B-pic virtual buffer occupancy */
    Double  avg_act;    /* Ave activity (of last picture) */
    Double  *mbact;     /* Activity of each macroblock */
    Int     R_tm5;      
    Int     T_tm5;
    Int     d_tm5;      /* buffer occupancy accumulator */
    Double  actsum;     /* Cumulative sum of activities */
    Int     Ni;         /* Nbr I-pics reamining in GOP */
    Int     Np;         /* Nbr P-pics remaining in GOP */
    Int     Nb;         /* Nbr B-pics remaining in GOP */
    Int     S_tm5;
    Int     Q_tm5;      /* Sum of quantizer value (for activity calc) */
    Int     prev_mquant;/* Previous quantizer */
    Int     mb_width;   /* Nbr MBs in horiz direction */
    Int     mb_height;  /* Nbr MBs in vert direction */
    Int     mquant;     /* running quantizer value */
    Int     bitrate;    /* Bit rate (bits/second) */
    Double  pic_rate;   /* Pictures per second */

    Int     rc_type;    /* Rate control type code */
    FILE    *Qfile;     /* Quantizer file */
    Int     linectr;    /* numbers on current Qfile line */
};

typedef struct tm5rc    Tm5Rc;

#include "tm5rc.p"
